/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.command.admin.AdminCommandType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.CommandIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.RandomIcon;
import com.github.rumsfield.konquest.display.menu.HelpMenu;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MainMenu
extends StateMenu {
    private final KonPlayer player;
    private final int ROOT_SLOT_SECRET = 34;

    public MainMenu(Konquest konquest, KonPlayer player) {
        super(konquest, HelpMenu.MenuState.ROOT, null);
        this.player = player;
        this.setCurrentView(MenuState.ROOT);
    }

    public DisplayView goToDashboard() {
        return this.refreshNewView(MenuState.DASHBOARD);
    }

    private DisplayView createRootView() {
        int ROOT_SLOT_HELP = 1;
        int ROOT_SLOT_DASH = 4;
        int ROOT_SLOT_KINGDOM = 7;
        int ROOT_SLOT_INFO = 10;
        int ROOT_SLOT_EVENT = 13;
        int ROOT_SLOT_TOWN = 16;
        int ROOT_SLOT_QUEST = 19;
        int ROOT_SLOT_STATS = 21;
        int ROOT_SLOT_PREFIX = 22;
        int ROOT_SLOT_SCORE = 23;
        int ROOT_SLOT_TRAVEL = 25;
        DisplayView result = new DisplayView(3, MessagePath.MENU_MAIN_TITLE.getMessage(new Object[0]));
        InfoIcon icon = new InfoIcon(MessagePath.MENU_MAIN_HELP.getMessage(new Object[0]), CommandType.HELP.iconMaterial(), ROOT_SLOT_HELP, true);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_HELP.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.HELP);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_MAIN_DASHBOARD.getMessage(new Object[0]), Material.REDSTONE_BLOCK, ROOT_SLOT_DASH, true);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_DASHBOARD.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.DASHBOARD);
        result.addIcon(icon);
        CommandType iconCommand = CommandType.KINGDOM;
        boolean isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_KINGDOM.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_KINGDOM, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_KINGDOM.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.KINGDOM);
        result.addIcon(icon);
        iconCommand = CommandType.INFO;
        isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_INFO.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_INFO, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_INFO.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.INFO);
        result.addIcon(icon);
        iconCommand = CommandType.TOWN;
        isClickable = !this.player.isBarbarian() && this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_TOWN.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_TOWN, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_TOWN.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else if (this.player.isBarbarian()) {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.TOWN);
        result.addIcon(icon);
        iconCommand = CommandType.QUEST;
        isClickable = this.getKonquest().getDirectiveManager().isEnabled() && this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_QUEST.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_QUEST, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_QUEST.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else if (this.getKonquest().getDirectiveManager().isEnabled()) {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
        }
        icon.setState(MenuState.QUEST);
        result.addIcon(icon);
        iconCommand = CommandType.STATS;
        isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_STATS.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_STATS, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_STATS.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.STATS);
        result.addIcon(icon);
        iconCommand = CommandType.PREFIX;
        isClickable = this.getKonquest().getAccomplishmentManager().isEnabled() && this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_PREFIX.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_PREFIX, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_PREFIX.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else if (this.getKonquest().getAccomplishmentManager().isEnabled()) {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
        }
        icon.setState(MenuState.PREFIX);
        result.addIcon(icon);
        iconCommand = CommandType.SCORE;
        isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_SCORE.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_SCORE, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_SCORE.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.SCORE);
        result.addIcon(icon);
        iconCommand = CommandType.TRAVEL;
        isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_TRAVEL.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_TRAVEL, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_TRAVEL.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.TRAVEL);
        result.addIcon(icon);
        iconCommand = CommandType.EVENT;
        isClickable = this.getKonquest().getGlobalEventManager().isEnabled() && this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_EVENT.getMessage(new Object[0]), iconCommand.iconMaterial(), ROOT_SLOT_EVENT, isClickable);
        icon.addDescription(MessagePath.MENU_MAIN_DESCRIPTION_EVENT.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.EVENT);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        icon = new InfoIcon(" ", Material.GRAY_STAINED_GLASS_PANE, 34, true);
        icon.setState(MenuState.SECRET);
        result.addIcon(icon);
        return result;
    }

    private DisplayView createSecretView() {
        DisplayView result = new DisplayView(1, "Secret Menu");
        RandomIcon icon = new RandomIcon("Roll The Dice", 4, true);
        icon.addDescription(String.valueOf(ChatColor.MAGIC) + "Gain a mysterious ability.");
        icon.setState(MenuState.SECRET_RTD);
        result.addIcon(icon);
        result.setRefreshTickRate(5);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createDashboardView() {
        int DASH_SLOT_MAP_AUTO = 2;
        int DASH_SLOT_CHAT = 3;
        int DASH_SLOT_BORDER = 4;
        int DASH_SLOT_FLY = 5;
        int DASH_SLOT_BYPASS = 6;
        int DASH_SLOT_MAP = 12;
        int DASH_SLOT_FAVOR = 13;
        int DASH_SLOT_SPY = 14;
        DisplayView result = new DisplayView(2, MessagePath.MENU_MAIN_TITLE_DASHBOARD.getMessage(new Object[0]));
        CommandType iconCommand = CommandType.MAP;
        boolean currentValue = this.player.isMapAuto();
        Material iconMaterial = currentValue ? Material.LIGHT_GRAY_WOOL : Material.LIGHT_GRAY_CARPET;
        boolean isClickable = this.hasPermission(iconCommand);
        MenuIcon icon = new InfoIcon(MessagePath.MENU_MAIN_MAP_AUTO.getMessage(new Object[0]), iconMaterial, DASH_SLOT_MAP_AUTO, isClickable);
        icon.addDescription(this.getDisplayValue(currentValue));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_MAP_AUTO);
        result.addIcon(icon);
        iconCommand = CommandType.CHAT;
        currentValue = !this.player.isGlobalChat();
        iconMaterial = currentValue ? Material.GREEN_WOOL : Material.GREEN_CARPET;
        isClickable = !this.player.isBarbarian() && this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_KINGDOM_CHAT.getMessage(new Object[0]), iconMaterial, DASH_SLOT_CHAT, isClickable);
        icon.addDescription(this.getDisplayValue(currentValue));
        boolean isChatFormatEnabled = this.getKonquest().getCore().getBoolean(CorePath.CHAT_ENABLE_FORMAT.getPath(), true);
        if (isChatFormatEnabled) {
            if (!this.player.isBarbarian()) {
                if (this.hasPermission(iconCommand)) {
                    icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
                }
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            }
        } else {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_CHAT);
        result.addIcon(icon);
        iconCommand = CommandType.BORDER;
        currentValue = this.player.isBorderDisplay();
        iconMaterial = currentValue ? Material.BROWN_WOOL : Material.BROWN_CARPET;
        isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_BORDER.getMessage(new Object[0]), iconMaterial, DASH_SLOT_BORDER, isClickable);
        icon.addDescription(this.getDisplayValue(currentValue));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_BORDER);
        result.addIcon(icon);
        iconCommand = CommandType.FLY;
        currentValue = this.player.isFlyEnabled();
        iconMaterial = currentValue ? Material.LIGHT_BLUE_WOOL : Material.LIGHT_BLUE_CARPET;
        isClickable = this.hasPermission(iconCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_FLYING.getMessage(new Object[0]), iconMaterial, DASH_SLOT_FLY, isClickable);
        icon.addDescription(this.getDisplayValue(currentValue));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_FLY);
        result.addIcon(icon);
        AdminCommandType iconAdminCommand = AdminCommandType.BYPASS;
        currentValue = this.player.isAdminBypassActive();
        iconMaterial = currentValue ? Material.ORANGE_WOOL : Material.ORANGE_CARPET;
        isClickable = this.hasPermission(iconAdminCommand);
        icon = new InfoIcon(MessagePath.MENU_MAIN_ADMIN_BYPASS.getMessage(new Object[0]), iconMaterial, DASH_SLOT_BYPASS, isClickable);
        icon.addDescription(this.getDisplayValue(currentValue));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_BYPASS);
        result.addIcon(icon);
        iconCommand = CommandType.MAP;
        boolean isPermission = this.player.getBukkitPlayer().hasPermission(iconCommand.permission());
        icon = new CommandIcon(iconCommand, isPermission, 0, 0, DASH_SLOT_MAP);
        if (isPermission) {
            icon.addHint(MessagePath.MENU_MAIN_HINT_MAP_1.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_MAIN_HINT_MAP_2.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_MAP);
        result.addIcon(icon);
        iconCommand = CommandType.FAVOR;
        isPermission = this.player.getBukkitPlayer().hasPermission(iconCommand.permission());
        icon = new CommandIcon(iconCommand, isPermission, 0, 0, DASH_SLOT_FAVOR);
        if (isPermission) {
            icon.addHint(MessagePath.MENU_MAIN_HINT_FAVOR.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_FAVOR);
        result.addIcon(icon);
        iconCommand = CommandType.SPY;
        double cost_spy = this.getKonquest().getCore().getDouble(CorePath.FAVOR_COST_SPY.getPath(), 0.0);
        isPermission = this.player.getBukkitPlayer().hasPermission(iconCommand.permission());
        icon = new CommandIcon(iconCommand, isPermission, (int)cost_spy, 0, DASH_SLOT_SPY);
        if (isPermission) {
            icon.addHint(MessagePath.MENU_MAIN_HINT_SPY.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DASH_SPY);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        switch (((MenuState)context).ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 11: {
                result.add(this.createDashboardView());
                break;
            }
            case 20: {
                result.add(this.createSecretView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavReturn(slot)) {
                result = this.setCurrentView(MenuState.ROOT);
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            } else if (slot == 34) {
                result = this.setCurrentView(MenuState.SECRET);
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState nextState = (MenuState)clickedIcon.getState();
            if (nextState == null) {
                return null;
            }
            switch (((MenuState)this.getCurrentState()).ordinal()) {
                case 0: {
                    switch (nextState.ordinal()) {
                        case 1: {
                            this.getKonquest().getDisplayManager().displayHelpMenu(this.player);
                            break;
                        }
                        case 11: {
                            result = this.setCurrentView(MenuState.DASHBOARD);
                            break;
                        }
                        case 2: {
                            this.getKonquest().getDisplayManager().displayKingdomMenu(this.player);
                            break;
                        }
                        case 3: {
                            this.getKonquest().getDisplayManager().displayInfoMenu(this.player);
                            break;
                        }
                        case 4: {
                            this.getKonquest().getDisplayManager().displayTownMenu(this.player);
                            break;
                        }
                        case 5: {
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getKonquest().getPlugin(), () -> this.getKonquest().getDirectiveManager().displayBook(this.player), 5L);
                            break;
                        }
                        case 6: {
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getKonquest().getPlugin(), () -> this.getKonquest().getAccomplishmentManager().displayStats(this.player), 5L);
                            break;
                        }
                        case 7: {
                            this.getKonquest().getDisplayManager().displayPrefixMenu(this.player);
                            break;
                        }
                        case 8: {
                            this.getKonquest().getDisplayManager().displayScoreMenu(this.player);
                            break;
                        }
                        case 9: {
                            this.getKonquest().getDisplayManager().displayTravelMenu(this.player);
                            break;
                        }
                        case 10: {
                            this.getKonquest().getDisplayManager().displayEventMenu(this.player);
                        }
                    }
                    break;
                }
                case 11: {
                    boolean doRefresh = true;
                    switch (nextState.ordinal()) {
                        case 12: {
                            this.player.setIsMapAuto(!this.player.isMapAuto());
                            this.playStatusSound(this.player.getBukkitPlayer(), true);
                            break;
                        }
                        case 13: {
                            this.player.setIsGlobalChat(!this.player.isGlobalChat());
                            this.playStatusSound(this.player.getBukkitPlayer(), true);
                            break;
                        }
                        case 14: {
                            this.player.setIsBorderDisplay(!this.player.isBorderDisplay());
                            this.getKonquest().getTerritoryManager().updatePlayerBorderParticles(this.player);
                            this.playStatusSound(this.player.getBukkitPlayer(), true);
                            break;
                        }
                        case 15: {
                            boolean status = this.getKonquest().getPlayerManager().togglePlayerFly(this.player);
                            this.playStatusSound(this.player.getBukkitPlayer(), status);
                            break;
                        }
                        case 16: {
                            this.player.setIsAdminBypassActive(!this.player.isAdminBypassActive());
                            this.playStatusSound(this.player.getBukkitPlayer(), true);
                            break;
                        }
                        case 17: 
                        case 18: 
                        case 19: {
                            if (!(clickedIcon instanceof CommandIcon)) break;
                            CommandIcon icon = (CommandIcon)clickedIcon;
                            ArrayList<String> args = new ArrayList<String>();
                            CommandType cmd = icon.getCommand();
                            if (cmd.equals((Object)CommandType.MAP) && !clickType) {
                                args.add("far");
                            }
                            cmd.command().execute(this.getKonquest(), (CommandSender)this.player.getBukkitPlayer(), args);
                            if (!cmd.equals((Object)CommandType.SPY)) break;
                            doRefresh = false;
                        }
                    }
                    if (!doRefresh) break;
                    result = this.refreshCurrentView();
                    break;
                }
                case 20: {
                    if (!nextState.equals(MenuState.SECRET_RTD)) break;
                    this.rollTheDice();
                    break;
                }
            }
        }
        return result;
    }

    private boolean hasPermission(CommandType cmd) {
        return this.player.getBukkitPlayer().hasPermission(cmd.permission());
    }

    private boolean hasPermission(AdminCommandType cmd) {
        return this.player.getBukkitPlayer().hasPermission(cmd.permission());
    }

    private String getDisplayValue(boolean value) {
        return DisplayManager.boolean2Lang(value) + " " + DisplayManager.boolean2Symbol(value);
    }

    private void rollTheDice() {
        try {
            Location playerLoc = this.player.getBukkitPlayer().getLocation();
            boolean isHit = false;
            int index = ThreadLocalRandom.current().nextInt(0, 100);
            switch (index) {
                case 0: {
                    isHit = true;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getKonquest().getPlugin(), () -> this.player.getBukkitPlayer().getWorld().strikeLightning(playerLoc), 40L);
                    break;
                }
                case 10: {
                    isHit = true;
                    this.player.getBukkitPlayer().addPotionEffect(new PotionEffect(PotionEffectType.POISON, 1200, 1));
                    break;
                }
                case 20: {
                    isHit = true;
                    this.player.getBukkitPlayer().addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 2400, 1));
                    break;
                }
                case 30: {
                    isHit = true;
                    this.player.getBukkitPlayer().addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 2400, 1));
                    break;
                }
                case 40: {
                    isHit = true;
                    this.player.getBukkitPlayer().addPotionEffect(new PotionEffect(PotionEffectType.HEALTH_BOOST, 12000, 2));
                    break;
                }
                case 50: {
                    isHit = true;
                    this.giveItems(new ItemStack(Material.GRASS_BLOCK, 3));
                    break;
                }
                case 60: {
                    isHit = true;
                    this.giveItems(new ItemStack(Material.POISONOUS_POTATO, 5));
                    break;
                }
                case 70: {
                    isHit = true;
                    this.giveItems(new ItemStack(Material.LEATHER_BOOTS, 1));
                    break;
                }
                case 80: {
                    isHit = true;
                    this.giveItems(new ItemStack(Material.STICK, 7));
                    break;
                }
                case 90: {
                    isHit = true;
                    int statIndex = ThreadLocalRandom.current().nextInt(0, KonStatsType.values().length);
                    KonStatsType randomStat = KonStatsType.values()[statIndex];
                    int addValue = 1;
                    this.getKonquest().getAccomplishmentManager().modifyPlayerStat(this.player, randomStat, addValue);
                    int newValue = this.player.getPlayerStats().getStat(randomStat);
                    ChatUtil.sendNotice(this.player, MessagePath.COMMAND_ADMIN_STAT_NOTICE_ADD.getMessage(addValue, randomStat.toString(), this.player.getBukkitPlayer().getName(), newValue));
                    break;
                }
            }
            this.playStatusSound(this.player.getBukkitPlayer(), isHit);
        }
        catch (Error | Exception issue) {
            ChatUtil.printConsoleError("Failed to apply random effect to player " + this.player.getBukkitPlayer().getName());
            issue.printStackTrace();
        }
    }

    private void giveItems(ItemStack items) {
        HashMap leftovers = this.player.getBukkitPlayer().getInventory().addItem(new ItemStack[]{items});
        for (ItemStack item : leftovers.values()) {
            this.player.getBukkitPlayer().getWorld().dropItem(this.player.getBukkitPlayer().getLocation(), item);
        }
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        HELP,
        KINGDOM,
        INFO,
        TOWN,
        QUEST,
        STATS,
        PREFIX,
        SCORE,
        TRAVEL,
        EVENT,
        DASHBOARD,
        DASH_MAP_AUTO,
        DASH_CHAT,
        DASH_BORDER,
        DASH_FLY,
        DASH_BYPASS,
        DASH_MAP,
        DASH_FAVOR,
        DASH_SPY,
        SECRET,
        SECRET_RTD;

    }
}

