/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.PlayerIcon;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPlot;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlotMenu
extends StateMenu {
    private final int INDEX_SCROLL_LEFT = 0;
    private final int INDEX_SCROLL_UP = 1;
    private final int INDEX_SCROLL_DOWN = 2;
    private final int INDEX_SCROLL_RIGHT = 3;
    private final int INDEX_CREATE = 5;
    private final int INDEX_DELETE = 6;
    private final int INDEX_FINISH = 6;
    private final int INDEX_EDIT = 7;
    private final KonTown town;
    private Point origin;
    private final Player bukkitPlayer;
    private final int maxSize;
    private final Location playerLoc;
    private KonPlot editPlot = null;
    private KonPlot oldPlot = null;
    private final Material[] plotColors = new Material[]{Material.MAGENTA_STAINED_GLASS_PANE, Material.CYAN_STAINED_GLASS_PANE, Material.BLUE_STAINED_GLASS_PANE, Material.ORANGE_STAINED_GLASS_PANE, Material.PINK_STAINED_GLASS_PANE, Material.YELLOW_STAINED_GLASS_PANE, Material.PURPLE_STAINED_GLASS_PANE, Material.LIGHT_BLUE_STAINED_GLASS_PANE};

    public PlotMenu(Konquest konquest, KonTown town, KonPlayer player, int maxSize) {
        super(konquest, MenuState.ROOT, null);
        this.town = town;
        this.bukkitPlayer = player.getBukkitPlayer();
        this.maxSize = maxSize;
        this.playerLoc = this.bukkitPlayer.getLocation();
        this.origin = town.isLocInside(this.playerLoc) ? HelperUtil.toPoint(this.playerLoc) : HelperUtil.toPoint(town.getCenterLoc());
        this.setCurrentView(MenuState.ROOT);
    }

    private DisplayView createEditView() {
        DisplayView result = new DisplayView(1, this.getTitle(MenuState.EDIT));
        int EDIT_SLOT_ADD_LAND = 2;
        int EDIT_SLOT_REMOVE_LAND = 3;
        int EDIT_SLOT_ADD_PLAYER = 5;
        int EDIT_SLOT_REMOVE_PLAYER = 6;
        int EDIT_SLOT_SHOW_PLAYER = 7;
        InfoIcon icon = new InfoIcon(MessagePath.MENU_PLOTS_EDIT_ADD_LAND.getMessage(new Object[0]), Material.GRASS_BLOCK, EDIT_SLOT_ADD_LAND, true);
        icon.setState(MenuState.EDIT_LAND_ADD);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_PLOTS_EDIT_REMOVE_LAND.getMessage(new Object[0]), Material.COARSE_DIRT, EDIT_SLOT_REMOVE_LAND, true);
        icon.setState(MenuState.EDIT_LAND_REMOVE);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_PLOTS_EDIT_ADD_PLAYERS.getMessage(new Object[0]), Material.PLAYER_HEAD, EDIT_SLOT_ADD_PLAYER, true);
        icon.setState(MenuState.EDIT_PLAYER_ADD);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_PLOTS_EDIT_REMOVE_PLAYERS.getMessage(new Object[0]), Material.SKELETON_SKULL, EDIT_SLOT_REMOVE_PLAYER, true);
        icon.setState(MenuState.EDIT_PLAYER_REMOVE);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_PLOTS_EDIT_SHOW_PLAYERS.getMessage(new Object[0]), Material.PAINTING, EDIT_SLOT_SHOW_PLAYER, true);
        icon.setState(MenuState.EDIT_PLAYER_SHOW);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private DisplayView createLandView(MenuState context) {
        DisplayView result = new DisplayView(5, this.getTitle(context));
        int colorSelect = 0;
        HashMap<KonPlot, Material> plotColorMap = new HashMap<KonPlot, Material>();
        int index = 0;
        for (int r = -2; r <= 2; ++r) {
            for (int c = -4; c <= 4; ++c) {
                Point drawPoint = new Point(this.origin.x + c, this.origin.y + r);
                KonPlot drawPlot = null;
                if (this.town.getChunkList().containsKey(drawPoint)) {
                    ArrayList<Object> loreList = new ArrayList<Object>();
                    ArrayList<String> hintList = new ArrayList<String>();
                    boolean isClickable = false;
                    Material landMat = Material.GREEN_STAINED_GLASS_PANE;
                    String landTitle = String.valueOf(ChatColor.GREEN) + MessagePath.MENU_PLOTS_TOWN_LAND.getMessage(new Object[0]) + " | " + drawPoint.x + "," + drawPoint.y;
                    boolean isPlot = false;
                    if (this.town.hasPlot(drawPoint, this.town.getWorld())) {
                        drawPlot = this.town.getPlot(drawPoint, this.town.getWorld());
                        if (plotColorMap.containsKey(drawPlot)) {
                            landMat = (Material)plotColorMap.get(drawPlot);
                        } else {
                            landMat = this.plotColors[colorSelect];
                            plotColorMap.put(drawPlot, this.plotColors[colorSelect]);
                            if (++colorSelect >= this.plotColors.length) {
                                colorSelect = 0;
                            }
                        }
                        landTitle = String.valueOf(ChatColor.LIGHT_PURPLE) + MessagePath.LABEL_PLOT.getMessage(new Object[0]) + " | " + drawPoint.x + "," + drawPoint.y;
                        if (drawPlot != null) {
                            void var18_19;
                            List<OfflinePlayer> users = drawPlot.getUserOfflinePlayers();
                            boolean bl = false;
                            while (var18_19 < 4) {
                                if (var18_19 < 3 && var18_19 < users.size()) {
                                    loreList.add(users.get((int)var18_19).getName());
                                } else if (var18_19 == 3 && var18_19 == users.size() - 1) {
                                    loreList.add(users.get((int)var18_19).getName());
                                } else if (var18_19 == 3 && var18_19 < users.size()) {
                                    int remaining = users.size() - 3;
                                    loreList.add(remaining + "+");
                                }
                                ++var18_19;
                            }
                        } else {
                            loreList.add(String.valueOf(ChatColor.DARK_RED) + "Invalid Plot");
                        }
                        isPlot = true;
                    }
                    if (this.oldPlot != null && this.oldPlot.hasPoint(drawPoint)) {
                        landMat = Material.GREEN_STAINED_GLASS_PANE;
                        landTitle = String.valueOf(ChatColor.GREEN) + MessagePath.MENU_PLOTS_TOWN_LAND.getMessage(new Object[0]) + " | " + drawPoint.x + "," + drawPoint.y;
                        loreList.clear();
                        isPlot = false;
                    }
                    if (this.editPlot != null && this.editPlot.hasPoint(drawPoint)) {
                        landMat = Material.GLASS_PANE;
                        landTitle = String.valueOf(ChatColor.WHITE) + MessagePath.MENU_PLOTS_EDITING_PLOT.getMessage(new Object[0]) + " | " + drawPoint.x + "," + drawPoint.y;
                        isPlot = true;
                    }
                    if (isPlot) {
                        if (context.equals(MenuState.ROOT_DELETE)) {
                            isClickable = true;
                            hintList.add(MessagePath.MENU_PLOTS_CLICK_DELETE.getMessage(new Object[0]));
                        } else if (context.equals(MenuState.ROOT_EDIT)) {
                            isClickable = true;
                            hintList.add(MessagePath.MENU_PLOTS_CLICK_EDIT.getMessage(new Object[0]));
                        } else if (context.equals(MenuState.EDIT_LAND_REMOVE)) {
                            isClickable = true;
                            hintList.add(MessagePath.MENU_PLOTS_CLICK_REMOVE_CHUNK.getMessage(new Object[0]));
                        }
                    } else if (context.equals(MenuState.ROOT_CREATE)) {
                        isClickable = true;
                        hintList.add(MessagePath.MENU_PLOTS_CLICK_CREATE.getMessage(new Object[0]));
                    } else if (context.equals(MenuState.EDIT_LAND_ADD) || context.equals(MenuState.CREATE_LAND_ADD)) {
                        isClickable = true;
                        hintList.add(MessagePath.MENU_PLOTS_CLICK_ADD_CHUNK.getMessage(new Object[0]));
                    }
                    if (HelperUtil.toPoint(this.town.getCenterLoc()).equals(drawPoint)) {
                        isClickable = false;
                        loreList.clear();
                        loreList.add(String.valueOf(ChatColor.GOLD) + this.town.getName());
                        loreList.add(String.valueOf(ChatColor.YELLOW) + MessagePath.MENU_PLOTS_TOWN_MONUMENT.getMessage(new Object[0]));
                        landMat = Material.OBSIDIAN;
                    }
                    if (HelperUtil.toPoint(this.playerLoc).equals(drawPoint)) {
                        loreList.add(String.valueOf(ChatColor.YELLOW) + MessagePath.MENU_PLOTS_HERE.getMessage(new Object[0]));
                    }
                    InfoIcon icon = new InfoIcon(landTitle, landMat, index, isClickable);
                    for (String string : loreList) {
                        icon.addDescription(string);
                    }
                    for (String string : hintList) {
                        icon.addHint(string);
                    }
                    result.addIcon(icon);
                }
                ++index;
            }
        }
        this.addNavEmpty(result);
        switch (context.ordinal()) {
            case 0: {
                this.addNavScrollLeft(result);
                this.addNavScrollUp(result);
                this.addNavScrollDown(result);
                this.addNavScrollRight(result);
                this.addNavClose(result);
                this.addNavCreate(result);
                this.addNavDelete(result);
                this.addNavEdit(result);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.addNavScrollLeft(result);
                this.addNavScrollUp(result);
                this.addNavScrollDown(result);
                this.addNavScrollRight(result);
                this.addNavClose(result);
                this.addNavReturn(result);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                this.addNavScrollLeft(result);
                this.addNavScrollUp(result);
                this.addNavScrollDown(result);
                this.addNavScrollRight(result);
                this.addNavClose(result);
                this.addNavReturn(result);
                this.addNavFinish(result);
                break;
            }
        }
        return result;
    }

    private List<DisplayView> createPlayerView(MenuState context) {
        String hintStr;
        if (this.editPlot == null || this.town == null) {
            return Collections.emptyList();
        }
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        switch (context.ordinal()) {
            case 5: 
            case 10: {
                players.addAll(this.town.getPlayerResidents());
                players.removeAll(this.editPlot.getUserOfflinePlayers());
                hintStr = MessagePath.MENU_PLOTS_CLICK_ADD_PLAYER.getMessage(new Object[0]);
                break;
            }
            case 11: {
                players.addAll(this.editPlot.getUserOfflinePlayers());
                hintStr = MessagePath.MENU_PLOTS_CLICK_REMOVE_PLAYER.getMessage(new Object[0]);
                break;
            }
            case 9: {
                players.addAll(this.editPlot.getUserOfflinePlayers());
                hintStr = MessagePath.MENU_PLOTS_CLICK_MOVE_PLAYER.getMessage(new Object[0]);
                break;
            }
            default: {
                return null;
            }
        }
        for (OfflinePlayer currentPlayer : players) {
            PlayerIcon icon = new PlayerIcon(currentPlayer, Konquest.friendColor2, null, 0, true);
            icon.addHint(hintStr);
            icons.add(icon);
        }
        ArrayList<DisplayView> result = new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
        for (DisplayView view : result) {
            this.addNavFinish(view);
        }
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        MenuState currentState = (MenuState)context;
        switch (currentState.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                result.add(this.createLandView(currentState));
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                result.addAll(this.createPlayerView(currentState));
                break;
            }
            case 6: {
                result.add(this.createEditView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result;
        block62: {
            MenuState currentState;
            block61: {
                result = null;
                currentState = (MenuState)this.getCurrentState();
                if (currentState == null) {
                    return null;
                }
                if (!this.isCurrentNavSlot(slot)) break block61;
                switch (currentState.ordinal()) {
                    case 0: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavScroll(slot)) {
                            result = this.scrollView(slot);
                            break;
                        }
                        if (this.isNavCreate(slot)) {
                            result = this.setCurrentView(MenuState.ROOT_CREATE);
                            break;
                        }
                        if (this.isNavDelete(slot)) {
                            result = this.setCurrentView(MenuState.ROOT_DELETE);
                            break;
                        }
                        if (this.isNavEdit(slot)) {
                            result = this.setCurrentView(MenuState.ROOT_EDIT);
                            break;
                        }
                        break block62;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavScroll(slot)) {
                            result = this.scrollView(slot);
                            break;
                        }
                        if (this.isNavReturn(slot)) {
                            this.editPlot = null;
                            this.oldPlot = null;
                            result = this.setCurrentView(MenuState.ROOT);
                            break;
                        }
                        break block62;
                    }
                    case 4: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavScroll(slot)) {
                            result = this.scrollView(slot);
                            break;
                        }
                        if (this.isNavReturn(slot)) {
                            this.editPlot = null;
                            this.oldPlot = null;
                            result = this.setCurrentView(MenuState.ROOT_CREATE);
                            break;
                        }
                        if (this.isNavFinish(slot)) {
                            result = this.setCurrentView(MenuState.CREATE_PLAYER_ADD);
                            break;
                        }
                        break block62;
                    }
                    case 5: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavReturn(slot)) {
                            if (this.editPlot != null) {
                                this.editPlot.clearUsers();
                            }
                            result = this.setCurrentView(MenuState.CREATE_LAND_ADD);
                            break;
                        }
                        if (this.isNavFinish(slot)) {
                            this.commitPlot();
                            this.editPlot = null;
                            this.oldPlot = null;
                            result = this.refreshNewView(MenuState.ROOT);
                            break;
                        }
                        if (this.isNavBack(slot)) {
                            result = this.goPageBack();
                            break;
                        }
                        if (this.isNavNext(slot)) {
                            result = this.goPageNext();
                            break;
                        }
                        break block62;
                    }
                    case 6: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavReturn(slot)) {
                            this.editPlot = null;
                            this.oldPlot = null;
                            result = this.setCurrentView(MenuState.ROOT_EDIT);
                            break;
                        }
                        break block62;
                    }
                    case 7: 
                    case 8: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavScroll(slot)) {
                            result = this.scrollView(slot);
                            break;
                        }
                        if (this.isNavReturn(slot)) {
                            result = this.setCurrentView(MenuState.EDIT);
                            break;
                        }
                        if (this.isNavFinish(slot)) {
                            this.commitPlot();
                            this.editPlot = null;
                            this.oldPlot = null;
                            result = this.refreshNewView(MenuState.ROOT);
                            break;
                        }
                        break block62;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        if (this.isNavClose(slot)) {
                            return null;
                        }
                        if (this.isNavReturn(slot)) {
                            result = this.setCurrentView(MenuState.EDIT);
                            break;
                        }
                        if (this.isNavFinish(slot)) {
                            this.commitPlot();
                            this.editPlot = null;
                            this.oldPlot = null;
                            result = this.refreshNewView(MenuState.ROOT);
                            break;
                        }
                        if (this.isNavBack(slot)) {
                            result = this.goPageBack();
                            break;
                        }
                        if (this.isNavNext(slot)) {
                            result = this.goPageNext();
                            break;
                        }
                        break block62;
                    }
                }
                break block62;
            }
            if (this.isCurrentMenuSlot(slot)) {
                DisplayView view = this.getCurrentView();
                if (view == null) {
                    return null;
                }
                Point clickPoint = this.slotToPoint(slot);
                MenuIcon clickedIcon = view.getIcon(slot);
                MenuState nextState = (MenuState)clickedIcon.getState();
                switch (currentState.ordinal()) {
                    case 1: {
                        if (this.town.hasPlot(clickPoint, this.town.getWorld())) break;
                        this.oldPlot = null;
                        this.editPlot = new KonPlot(clickPoint);
                        result = this.refreshNewView(MenuState.CREATE_LAND_ADD);
                        break;
                    }
                    case 2: {
                        if (!this.town.hasPlot(clickPoint, this.town.getWorld())) break;
                        this.oldPlot = this.town.getPlot(clickPoint, this.town.getWorld());
                        this.editPlot = null;
                        this.commitPlot();
                        result = this.refreshNewView(MenuState.ROOT);
                        break;
                    }
                    case 3: {
                        if (!this.town.hasPlot(clickPoint, this.town.getWorld())) break;
                        this.oldPlot = this.town.getPlot(clickPoint, this.town.getWorld());
                        this.editPlot = this.oldPlot.clone();
                        result = this.setCurrentView(MenuState.EDIT);
                        break;
                    }
                    case 4: 
                    case 7: {
                        if (this.town.hasPlot(clickPoint, this.town.getWorld()) || this.editPlot == null || this.editPlot.hasPoint(clickPoint)) break;
                        if (this.maxSize < 1 || this.editPlot.getPoints().size() < this.maxSize) {
                            this.editPlot.addPoint(clickPoint);
                        } else {
                            Konquest.playFailSound(this.bukkitPlayer);
                        }
                        result = this.refreshCurrentView();
                        break;
                    }
                    case 5: 
                    case 10: {
                        if (!(clickedIcon instanceof PlayerIcon) || this.editPlot == null) break;
                        PlayerIcon icon = (PlayerIcon)clickedIcon;
                        this.editPlot.addUser(icon.getOfflinePlayer());
                        result = this.refreshCurrentView();
                        break;
                    }
                    case 6: {
                        if (nextState == null) {
                            return null;
                        }
                        switch (nextState.ordinal()) {
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                result = this.refreshNewView(nextState);
                            }
                        }
                        break;
                    }
                    case 8: {
                        if (this.editPlot == null || !this.editPlot.hasPoint(clickPoint)) break;
                        if (this.editPlot.getPoints().size() > 1) {
                            this.editPlot.removePoint(clickPoint);
                        } else {
                            Konquest.playFailSound(this.bukkitPlayer);
                        }
                        result = this.refreshCurrentView();
                        break;
                    }
                    case 9: {
                        if (!(clickedIcon instanceof PlayerIcon) || this.editPlot == null) break;
                        PlayerIcon icon = (PlayerIcon)clickedIcon;
                        List<UUID> members = this.editPlot.getUsers();
                        if (members.remove(icon.getOfflinePlayer().getUniqueId())) {
                            this.editPlot.clearUsers();
                            this.editPlot.addUser(icon.getOfflinePlayer());
                            this.editPlot.addUsers(members);
                        }
                        result = this.refreshCurrentView();
                        break;
                    }
                    case 11: {
                        if (!(clickedIcon instanceof PlayerIcon) || this.editPlot == null) break;
                        PlayerIcon icon = (PlayerIcon)clickedIcon;
                        this.editPlot.removeUser(icon.getOfflinePlayer());
                        result = this.refreshCurrentView();
                        break;
                    }
                }
            }
        }
        return result;
    }

    private DisplayView scrollView(int slot) {
        int navIndex = this.getCurrentNavIndex(slot);
        if (navIndex == 0) {
            this.origin = new Point(this.origin.x - 1, this.origin.y);
        } else if (navIndex == 1) {
            this.origin = new Point(this.origin.x, this.origin.y - 1);
        } else if (navIndex == 2) {
            this.origin = new Point(this.origin.x, this.origin.y + 1);
        } else if (navIndex == 3) {
            this.origin = new Point(this.origin.x + 1, this.origin.y);
        }
        return this.refreshCurrentView();
    }

    private String getTitle(MenuState context) {
        String result = "";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_PLOTS_TITLE_PLOTS.getMessage(new Object[0]);
                break;
            }
            case 1: {
                result = MessagePath.MENU_PLOTS_TITLE_CREATE.getMessage(new Object[0]);
                break;
            }
            case 2: {
                result = MessagePath.MENU_PLOTS_TITLE_DELETE.getMessage(new Object[0]);
                break;
            }
            case 3: {
                result = MessagePath.MENU_PLOTS_TITLE_EDIT.getMessage(new Object[0]);
                break;
            }
            case 4: 
            case 7: {
                result = MessagePath.MENU_PLOTS_TITLE_ADD_LAND.getMessage(new Object[0]);
                break;
            }
            case 5: 
            case 10: {
                result = MessagePath.MENU_PLOTS_TITLE_ADD_PLAYERS.getMessage(new Object[0]);
                break;
            }
            case 6: {
                result = MessagePath.MENU_PLOTS_TITLE_EDIT_OPTIONS.getMessage(new Object[0]);
                break;
            }
            case 8: {
                result = MessagePath.MENU_PLOTS_TITLE_REMOVE_LAND.getMessage(new Object[0]);
                break;
            }
            case 9: {
                result = MessagePath.MENU_PLOTS_TITLE_SHOW_PLAYERS.getMessage(new Object[0]);
                break;
            }
            case 11: {
                result = MessagePath.MENU_PLOTS_TITLE_REMOVE_PLAYERS.getMessage(new Object[0]);
                break;
            }
        }
        return result;
    }

    private Point slotToPoint(int slot) {
        int xDiff = slot % 9 - 4;
        int yDiff = Math.floorDiv(slot, 9) - 2;
        return new Point(this.origin.x + xDiff, this.origin.y + yDiff);
    }

    private void commitPlot() {
        if (this.oldPlot != null) {
            this.town.removePlot(this.oldPlot);
        }
        if (this.editPlot != null) {
            this.town.putPlot(this.editPlot);
        }
        Konquest.playSuccessSound(this.bukkitPlayer);
    }

    private boolean isNavScroll(int slot) {
        if (this.isCurrentNavSlot(slot)) {
            int navIndex = this.getCurrentNavIndex(slot);
            return navIndex == 0 || navIndex == 1 || navIndex == 2 || navIndex == 3;
        }
        return false;
    }

    private boolean isNavCreate(int slot) {
        return this.isNavIndex(slot, 5);
    }

    private boolean isNavDelete(int slot) {
        return this.isNavIndex(slot, 6);
    }

    private boolean isNavEdit(int slot) {
        return this.isNavIndex(slot, 7);
    }

    private boolean isNavFinish(int slot) {
        return this.isNavIndex(slot, 6);
    }

    private void addNavScrollLeft(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 0;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + "\u25c0", Material.STONE_BUTTON, index, true));
    }

    private void addNavScrollUp(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 1;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + "\u25b2", Material.STONE_BUTTON, index, true));
    }

    private void addNavScrollDown(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 2;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + "\u25bc", Material.STONE_BUTTON, index, true));
    }

    private void addNavScrollRight(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 3;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + "\u25b6", Material.STONE_BUTTON, index, true));
    }

    private void addNavCreate(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 5;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.MENU_PLOTS_BUTTON_CREATE.getMessage(new Object[0]), Material.OAK_SAPLING, index, true));
    }

    private void addNavDelete(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 6;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.MENU_PLOTS_BUTTON_DELETE.getMessage(new Object[0]), Material.BARRIER, index, true));
    }

    private void addNavEdit(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 7;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.MENU_PLOTS_BUTTON_EDIT.getMessage(new Object[0]), Material.WRITABLE_BOOK, index, true));
    }

    private void addNavFinish(DisplayView view) {
        if (view == null) {
            return;
        }
        int index = this.getNavStartSlot(view) + 6;
        view.addIcon(new InfoIcon(String.valueOf(ChatColor.GOLD) + MessagePath.MENU_PLOTS_BUTTON_FINISH.getMessage(new Object[0]), Material.WRITTEN_BOOK, index, true));
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        ROOT_CREATE,
        ROOT_DELETE,
        ROOT_EDIT,
        CREATE_LAND_ADD,
        CREATE_PLAYER_ADD,
        EDIT,
        EDIT_LAND_ADD,
        EDIT_LAND_REMOVE,
        EDIT_PLAYER_SHOW,
        EDIT_PLAYER_ADD,
        EDIT_PLAYER_REMOVE;

    }
}

