/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.PrefixCustomIcon;
import com.github.rumsfield.konquest.display.icon.PrefixIcon;
import com.github.rumsfield.konquest.display.icon.StatIcon;
import com.github.rumsfield.konquest.model.KonCustomPrefix;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPrefixCategory;
import com.github.rumsfield.konquest.model.KonPrefixType;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public class PrefixMenu
extends StateMenu {
    private final KonPlayer player;

    public PrefixMenu(Konquest konquest, KonPlayer player) {
        super(konquest, MenuState.ROOT, null);
        this.player = player;
        this.setCurrentView(MenuState.ROOT);
    }

    private DisplayView createRootView() {
        if (!this.getKonquest().getAccomplishmentManager().isEnabled()) {
            return null;
        }
        int ROOT_SLOT_CURRENT = 3;
        int ROOT_SLOT_DISABLE = 5;
        int ROOT_SLOT_PREFIX = 11;
        int ROOT_SLOT_CUSTOM = 13;
        int ROOT_SLOT_STATS = 15;
        DisplayView result = new DisplayView(2, this.getTitle(MenuState.ROOT));
        String playerPrefix = this.player.getPlayerPrefix().isEnabled() ? ChatUtil.parseHex(this.player.getPlayerPrefix().getMainPrefixName()) : MessagePath.LABEL_DISABLED.getMessage(new Object[0]);
        InfoIcon icon = new InfoIcon(MessagePath.MENU_PREFIX_CURRENT_PREFIX.getMessage(new Object[0]), Material.PLAYER_HEAD, ROOT_SLOT_CURRENT, false);
        icon.addDescription(playerPrefix);
        result.addIcon(icon);
        boolean isPrefixDisabled = !this.player.getPlayerPrefix().isEnabled();
        boolean isTitleAlwaysShown = this.getKonquest().getCore().getBoolean(CorePath.CHAT_ALWAYS_SHOW_TITLE.getPath(), false);
        boolean isDisableClickable = !isPrefixDisabled && !isTitleAlwaysShown;
        icon = new InfoIcon(MessagePath.MENU_PREFIX_DISABLE_PREFIX.getMessage(new Object[0]), Material.MILK_BUCKET, ROOT_SLOT_DISABLE, isDisableClickable);
        if (isDisableClickable) {
            icon.addHint(MessagePath.MENU_HINT_DISABLE.getMessage(new Object[0]));
        } else if (isPrefixDisabled) {
            icon.addDescription(MessagePath.COMMAND_PREFIX_ERROR_DISABLE.getMessage(new Object[0]));
        } else {
            icon.addDescription(MessagePath.COMMAND_PREFIX_ERROR_ALWAYS_ON.getMessage(new Object[0]));
        }
        icon.setState(MenuState.DISABLE);
        result.addIcon(icon);
        boolean isPrefixClickable = !this.player.isBarbarian();
        icon = new InfoIcon(MessagePath.MENU_PREFIX_TITLE_PREFIX.getMessage(new Object[0]), Material.NAME_TAG, ROOT_SLOT_PREFIX, isPrefixClickable);
        icon.addDescription(MessagePath.MENU_PREFIX_DESCRIPTION_PREFIX.getMessage(new Object[0]));
        if (isPrefixClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
        }
        icon.setState(MenuState.PREFIX);
        result.addIcon(icon);
        if (this.getKonquest().getAccomplishmentManager().getNumCustomPrefixes() > 0) {
            boolean isCustomClickable = !this.player.isBarbarian();
            icon = new InfoIcon(MessagePath.MENU_PREFIX_TITLE_CUSTOM.getMessage(new Object[0]), Material.GOLD_BLOCK, ROOT_SLOT_CUSTOM, isCustomClickable);
            icon.addDescription(MessagePath.MENU_PREFIX_DESCRIPTION_CUSTOM.getMessage(new Object[0]));
            if (isCustomClickable) {
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            }
            icon.setState(MenuState.CUSTOM);
            result.addIcon(icon);
        }
        icon = new InfoIcon(MessagePath.MENU_PREFIX_TITLE_STATS.getMessage(new Object[0]), Material.BOOK, ROOT_SLOT_STATS, true);
        icon.addDescription(MessagePath.MENU_PREFIX_DESCRIPTION_STATS.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.STATS);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavHome(result);
        this.addNavClose(result);
        return result;
    }

    /*
     * Could not resolve type clashes
     */
    private List<DisplayView> createPrefixView() {
        ArrayList<MenuIcon> prefixIcons = new ArrayList<MenuIcon>();
        for (KonPrefixCategory category : KonPrefixCategory.values()) {
            ArrayList<Enum> categoryPrefixes = new ArrayList<Enum>();
            double level = 0.0;
            for (KonStatsType statCheck : KonStatsType.values()) {
                if (!statCheck.getCategory().equals((Object)category)) continue;
                level += (double)this.player.getPlayerStats().getStat(statCheck) * statCheck.weight();
            }
            for (Enum prefix : KonPrefixType.values()) {
                if (!((KonPrefixType)prefix).category().equals((Object)category)) continue;
                categoryPrefixes.add(prefix);
            }
            categoryPrefixes.sort(this.prefixComparator);
            for (KonPrefixType prefix : categoryPrefixes) {
                String levelFormat;
                boolean isClickable;
                String categoryLevel = String.format("%.2f", level);
                if (this.player.getPlayerPrefix().hasPrefix(prefix)) {
                    isClickable = true;
                    levelFormat = String.valueOf(ChatColor.DARK_GREEN) + categoryLevel + String.valueOf(ChatColor.WHITE) + "/" + String.valueOf(ChatColor.AQUA) + prefix.level();
                } else {
                    isClickable = false;
                    levelFormat = String.valueOf(ChatColor.DARK_RED) + categoryLevel + String.valueOf(ChatColor.WHITE) + "/" + String.valueOf(ChatColor.AQUA) + prefix.level();
                }
                PrefixIcon icon = new PrefixIcon(prefix, 0, isClickable);
                icon.addProperty(prefix.category().getTitle());
                icon.addDescription(levelFormat);
                if (isClickable) {
                    icon.addHint(MessagePath.MENU_HINT_APPLY.getMessage(new Object[0]));
                }
                prefixIcons.add(icon);
            }
            int fillerCount = 9 - Math.floorMod(categoryPrefixes.size(), 9);
            for (int i = 0; i < fillerCount; ++i) {
                prefixIcons.add(new InfoIcon(" ", Material.GLASS_PANE, 0, false));
            }
        }
        return new ArrayList<DisplayView>(this.makePages(prefixIcons, this.getTitle(MenuState.PREFIX)));
    }

    private List<DisplayView> createCustomView() {
        ArrayList<MenuIcon> customPrefixIcons = new ArrayList<MenuIcon>();
        for (KonCustomPrefix currentCustom : this.getKonquest().getAccomplishmentManager().getCustomPrefixes()) {
            boolean isClickable = this.player.getBukkitPlayer().hasPermission("konquest.prefix." + currentCustom.getLabel());
            PrefixCustomIcon icon = new PrefixCustomIcon(currentCustom, 0, isClickable);
            if (!this.player.getPlayerPrefix().isCustomAvailable(currentCustom.getLabel())) {
                icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(currentCustom.getCost()));
            }
            if (isClickable) {
                icon.addHint(MessagePath.MENU_HINT_APPLY.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
            }
            customPrefixIcons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(customPrefixIcons, this.getTitle(MenuState.CUSTOM)));
    }

    private List<DisplayView> createStatsView() {
        ArrayList<MenuIcon> statsIcons = new ArrayList<MenuIcon>();
        for (KonStatsType stat : KonStatsType.values()) {
            int statValue = this.player.getPlayerStats().getStat(stat);
            StatIcon icon = new StatIcon(stat, statValue, 0, false);
            statsIcons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(statsIcons, this.getTitle(MenuState.STATS)));
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        switch (((MenuState)context).ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 2: {
                result.addAll(this.createPrefixView());
                break;
            }
            case 3: {
                result.addAll(this.createCustomView());
                break;
            }
            case 4: {
                result.addAll(this.createStatsView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                result = this.setCurrentView(MenuState.ROOT);
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState currentState = (MenuState)this.getCurrentState();
            if (currentState == null) {
                return null;
            }
            MenuState nextState = (MenuState)clickedIcon.getState();
            switch (currentState.ordinal()) {
                case 0: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            result = this.setCurrentView(nextState);
                            break;
                        }
                        case 1: {
                            boolean status = this.getKonquest().getAccomplishmentManager().disablePlayerPrefix(this.player);
                            this.playStatusSound(this.player.getBukkitPlayer(), status);
                            result = this.refreshCurrentView();
                        }
                    }
                    break;
                }
                case 2: {
                    if (!(clickedIcon instanceof PrefixIcon)) break;
                    PrefixIcon icon = (PrefixIcon)clickedIcon;
                    boolean status = this.getKonquest().getAccomplishmentManager().applyPlayerPrefix(this.player, icon.getPrefix());
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshNewView(MenuState.ROOT);
                    break;
                }
                case 3: {
                    if (!(clickedIcon instanceof PrefixCustomIcon)) break;
                    PrefixCustomIcon icon = (PrefixCustomIcon)clickedIcon;
                    boolean status = this.getKonquest().getAccomplishmentManager().applyPlayerCustomPrefix(this.player, icon.getPrefix());
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshNewView(MenuState.ROOT);
                    break;
                }
            }
        }
        return result;
    }

    private String getTitle(MenuState context) {
        String result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_MAIN_PREFIX.getMessage(new Object[0]);
                break;
            }
            case 2: {
                result = MessagePath.MENU_PREFIX_TITLE_PREFIX.getMessage(new Object[0]);
                break;
            }
            case 3: {
                result = MessagePath.MENU_PREFIX_TITLE_CUSTOM.getMessage(new Object[0]);
                break;
            }
            case 4: {
                result = MessagePath.MENU_PREFIX_TITLE_STATS.getMessage(new Object[0]);
                break;
            }
        }
        return result;
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        DISABLE,
        PREFIX,
        CUSTOM,
        STATS;

    }
}

