/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.KingdomIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.PlayerIcon;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonKingdomScoreAttributes;
import com.github.rumsfield.konquest.model.KonLeaderboard;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPlayerScoreAttributes;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;

public class ScoreMenu
extends StateMenu {
    private final KonPlayer player;
    private KonOfflinePlayer scorePlayer;
    private KonKingdom scoreKingdom;
    private MenuState returnState;

    public ScoreMenu(Konquest konquest, KonPlayer player) {
        super(konquest, MenuState.ROOT, null);
        this.player = player;
        this.scorePlayer = null;
        this.scoreKingdom = null;
        this.returnState = null;
        this.setCurrentView(MenuState.ROOT);
    }

    public void goToPlayerScore(KonOfflinePlayer scorePlayer) {
        if (scorePlayer == null) {
            return;
        }
        this.scorePlayer = scorePlayer;
        this.refreshNewView(MenuState.PLAYER_SCORE);
    }

    public void goToKingdomScore(KonKingdom scoreKingdom) {
        if (scoreKingdom == null) {
            return;
        }
        this.scoreKingdom = scoreKingdom;
        this.refreshNewView(MenuState.KINGDOM_SCORE);
    }

    private DisplayView createRootView() {
        int rows = 1;
        int ROOT_SLOT_PLAYER = 2;
        int ROOT_SLOT_KINGDOM = 3;
        int ROOT_SLOT_ALL_PLAYERS = 5;
        int ROOT_SLOT_ALL_KINGDOMS = 6;
        DisplayView result = new DisplayView(rows, this.getTitle(MenuState.ROOT));
        int playerScore = this.getKonquest().getKingdomManager().getPlayerScore(this.player);
        int kingdomScore = this.getKonquest().getKingdomManager().getKingdomScore(this.player.getKingdom());
        String playerName = this.player.getBukkitPlayer().getName();
        String kingdomName = this.player.getKingdom().getName();
        boolean isPlayerClickable = this.isPlayerScored(this.player);
        MenuIcon icon = new PlayerIcon((OfflinePlayer)this.player.getBukkitPlayer(), this.getColor((KonOfflinePlayer)this.player, this.player), this.getRelation((KonOfflinePlayer)this.player, this.player), ROOT_SLOT_PLAYER, isPlayerClickable);
        icon.addNameValue(MessagePath.MENU_SCORE_PLAYER_SCORE.getMessage(new Object[0]), playerScore);
        if (isPlayerClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            if (this.player.isBarbarian()) {
                icon.addError(MessagePath.COMMAND_SCORE_ERROR_BARBARIAN.getMessage(playerName));
            } else {
                icon.addError(MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(kingdomName));
            }
        }
        icon.setState(MenuState.PLAYER_SELF);
        result.addIcon(icon);
        boolean isKingdomClickable = this.isKingdomScored(this.player.getKingdom());
        icon = new KingdomIcon(this.player.getKingdom(), this.getColor((KonOfflinePlayer)this.player, this.player), this.getRelation((KonOfflinePlayer)this.player, this.player), ROOT_SLOT_KINGDOM, isKingdomClickable);
        icon.addNameValue(MessagePath.MENU_SCORE_KINGDOM_SCORE.getMessage(new Object[0]), kingdomScore);
        if (isKingdomClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            if (this.player.isBarbarian()) {
                icon.addError(MessagePath.COMMAND_SCORE_ERROR_BARBARIAN.getMessage(playerName));
            } else {
                icon.addError(MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(kingdomName));
            }
        }
        icon.setState(MenuState.KINGDOM_SELF);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_PLAYERS.getMessage(new Object[0]), Material.PLAYER_HEAD, ROOT_SLOT_ALL_PLAYERS, true);
        icon.addDescription(MessagePath.MENU_SCORE_DESCRIPTION_PLAYERS.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.PLAYER_ALL);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), Material.DIAMOND_HELMET, ROOT_SLOT_ALL_KINGDOMS, true);
        icon.addDescription(MessagePath.MENU_SCORE_DESCRIPTION_KINGDOMS.getMessage(new Object[0]));
        icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        icon.setState(MenuState.KINGDOM_ALL);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavHome(result);
        this.addNavClose(result);
        return result;
    }

    private List<DisplayView> createPlayerView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonOfflinePlayer> players = new ArrayList<KonOfflinePlayer>(this.getKonquest().getPlayerManager().getAllKonquestOfflinePlayers());
        players.sort(this.playerScoreComparator);
        int rank = 1;
        for (KonOfflinePlayer currentPlayer : players) {
            if (!this.isPlayerScored(currentPlayer)) continue;
            String currentPlayerName = currentPlayer.getOfflineBukkitPlayer().getName();
            String currentKingdomName = currentPlayer.getKingdom().getName();
            int currentScore = this.getKonquest().getKingdomManager().getPlayerScore(currentPlayer);
            boolean isPlayerClickable = this.isPlayerScored(currentPlayer);
            PlayerIcon icon = new PlayerIcon(currentPlayer.getOfflineBukkitPlayer(), this.getColor((KonOfflinePlayer)this.player, currentPlayer), this.getRelation((KonOfflinePlayer)this.player, currentPlayer), 0, isPlayerClickable);
            icon.addProperty(MessagePath.LABEL_LEADERBOARD.getMessage(new Object[0]) + " #" + rank);
            icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), currentScore);
            if (!currentPlayer.isBarbarian()) {
                icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), currentKingdomName);
            }
            if (isPlayerClickable) {
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                if (currentPlayer.isBarbarian()) {
                    icon.addError(MessagePath.COMMAND_SCORE_ERROR_BARBARIAN.getMessage(currentPlayerName));
                } else {
                    icon.addError(MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(currentKingdomName));
                }
            }
            icon.setState(MenuState.PLAYER_SCORE);
            icons.add(icon);
            ++rank;
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.PLAYER_ALL)));
    }

    private List<DisplayView> createKingdomView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonKingdom> kingdoms = new ArrayList<KonKingdom>(this.getKonquest().getKingdomManager().getKingdoms());
        kingdoms.sort(this.kingdomScoreComparator);
        int rank = 1;
        for (KonKingdom currentKingdom : kingdoms) {
            String currentKingdomName = currentKingdom.getName();
            int currentScore = this.getKonquest().getKingdomManager().getKingdomScore(currentKingdom);
            boolean isKingdomClickable = this.isKingdomScored(currentKingdom);
            KingdomIcon icon = new KingdomIcon(currentKingdom, this.getColor((KonOfflinePlayer)this.player, currentKingdom), this.getRelation((KonOfflinePlayer)this.player, currentKingdom), 0, isKingdomClickable);
            icon.addProperty(MessagePath.LABEL_LEADERBOARD.getMessage(new Object[0]) + " #" + rank);
            icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), currentScore);
            if (isKingdomClickable) {
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                if (currentKingdom.isCreated()) {
                    icon.addError(MessagePath.COMMAND_SCORE_ERROR_PEACEFUL.getMessage(currentKingdomName));
                }
            }
            icon.setState(MenuState.KINGDOM_SCORE);
            icons.add(icon);
            ++rank;
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.KINGDOM_ALL)));
    }

    private DisplayView createPlayerScoreView() {
        if (this.scorePlayer == null) {
            return null;
        }
        int SLOT_TOTAL = 0;
        int SLOT_TOWN_LORD = 2;
        int SLOT_TOWN_KNIGHT = 3;
        int SLOT_TOWN_RESIDENT = 4;
        int SLOT_LAND_LORD = 5;
        int SLOT_LAND_KNIGHT = 6;
        int SLOT_LAND_RESIDENT = 7;
        DisplayView result = new DisplayView(1, this.getTitle(MenuState.PLAYER_SCORE));
        KonPlayerScoreAttributes playerScoreAttributes = this.getKonquest().getKingdomManager().getPlayerScoreAttributes(this.scorePlayer);
        int playerScore = playerScoreAttributes.getScore();
        MenuIcon icon = new PlayerIcon(this.scorePlayer.getOfflineBukkitPlayer(), this.getColor((KonOfflinePlayer)this.player, this.scorePlayer), this.getRelation((KonOfflinePlayer)this.player, this.scorePlayer), SLOT_TOTAL, false);
        icon.addNameValue(MessagePath.MENU_SCORE_PLAYER_SCORE.getMessage(new Object[0]), playerScore);
        result.addIcon(icon);
        int attValue = playerScoreAttributes.getAttributeValue(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS);
        int attScore = playerScoreAttributes.getAttributeScore(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_TOWN_1.getMessage(new Object[0]), Material.IRON_HELMET, SLOT_TOWN_LORD, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = playerScoreAttributes.getAttributeValue(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS);
        attScore = playerScoreAttributes.getAttributeScore(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_TOWN_2.getMessage(new Object[0]), Material.IRON_HORSE_ARMOR, SLOT_TOWN_KNIGHT, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = playerScoreAttributes.getAttributeValue(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS);
        attScore = playerScoreAttributes.getAttributeScore(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_TOWN_3.getMessage(new Object[0]), Material.LEATHER_CHESTPLATE, SLOT_TOWN_RESIDENT, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = playerScoreAttributes.getAttributeValue(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS);
        attScore = playerScoreAttributes.getAttributeScore(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_LAND_1.getMessage(new Object[0]), Material.SMOOTH_STONE, SLOT_LAND_LORD, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = playerScoreAttributes.getAttributeValue(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS);
        attScore = playerScoreAttributes.getAttributeScore(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_LAND_2.getMessage(new Object[0]), Material.OAK_PLANKS, SLOT_LAND_KNIGHT, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = playerScoreAttributes.getAttributeValue(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS);
        attScore = playerScoreAttributes.getAttributeScore(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_LAND_3.getMessage(new Object[0]), Material.GRASS_BLOCK, SLOT_LAND_RESIDENT, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    private DisplayView createKingdomScoreView() {
        if (this.scoreKingdom == null) {
            return null;
        }
        int NUM_LEADERBOARD = 9;
        int rows = 2;
        int SLOT_LEADERBOARD_START = 0;
        int SLOT_TOTAL = 9;
        int SLOT_TOWNS = 11;
        int SLOT_LAND = 12;
        int SLOT_FAVOR = 13;
        int SLOT_POPULATION = 14;
        DisplayView result = new DisplayView(rows, this.getTitle(MenuState.KINGDOM_SCORE));
        KonKingdomScoreAttributes kingdomScoreAttributes = this.getKonquest().getKingdomManager().getKingdomScoreAttributes(this.scoreKingdom);
        int kingdomScore = kingdomScoreAttributes.getScore();
        String kingdomName = this.scoreKingdom.getName();
        MenuIcon icon = new KingdomIcon(this.scoreKingdom, this.getColor((KonOfflinePlayer)this.player, this.scoreKingdom), this.getRelation((KonOfflinePlayer)this.player, this.scoreKingdom), SLOT_TOTAL, false);
        icon.addNameValue(MessagePath.MENU_SCORE_KINGDOM_SCORE.getMessage(new Object[0]), kingdomScore);
        result.addIcon(icon);
        int attValue = kingdomScoreAttributes.getAttributeValue(KonKingdomScoreAttributes.ScoreAttribute.TOWNS);
        int attScore = kingdomScoreAttributes.getAttributeScore(KonKingdomScoreAttributes.ScoreAttribute.TOWNS);
        icon = new InfoIcon(MessagePath.MENU_SCORE_KINGDOM_TOWNS.getMessage(new Object[0]), Material.OBSIDIAN, SLOT_TOWNS, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = kingdomScoreAttributes.getAttributeValue(KonKingdomScoreAttributes.ScoreAttribute.LAND);
        attScore = kingdomScoreAttributes.getAttributeScore(KonKingdomScoreAttributes.ScoreAttribute.LAND);
        icon = new InfoIcon(MessagePath.MENU_SCORE_KINGDOM_LAND.getMessage(new Object[0]), Material.GRASS_BLOCK, SLOT_LAND, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = kingdomScoreAttributes.getAttributeValue(KonKingdomScoreAttributes.ScoreAttribute.FAVOR);
        attScore = kingdomScoreAttributes.getAttributeScore(KonKingdomScoreAttributes.ScoreAttribute.FAVOR);
        icon = new InfoIcon(MessagePath.MENU_SCORE_KINGDOM_FAVOR.getMessage(new Object[0]), Material.GOLD_INGOT, SLOT_FAVOR, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        attValue = kingdomScoreAttributes.getAttributeValue(KonKingdomScoreAttributes.ScoreAttribute.POPULATION);
        attScore = kingdomScoreAttributes.getAttributeScore(KonKingdomScoreAttributes.ScoreAttribute.POPULATION);
        icon = new InfoIcon(MessagePath.MENU_SCORE_KINGDOM_POPULATION.getMessage(new Object[0]), Material.PLAYER_HEAD, SLOT_POPULATION, false);
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), attValue);
        icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), attScore);
        result.addIcon(icon);
        KonLeaderboard leaderboard = this.getKonquest().getKingdomManager().getKingdomLeaderboard(this.scoreKingdom);
        if (leaderboard.isEmpty()) {
            icon = new InfoIcon(String.valueOf(ChatColor.DARK_RED) + MessagePath.LABEL_LEADERBOARD.getMessage(new Object[0]), Material.BARRIER, SLOT_LEADERBOARD_START, false);
            icon.addError(MessagePath.MENU_SCORE_LEADERBOARD_EMPTY.getMessage(new Object[0]));
            result.addIcon(icon);
        } else {
            int numEntries = NUM_LEADERBOARD;
            if (leaderboard.getSize() < numEntries) {
                numEntries = leaderboard.getSize();
            }
            int rank = 1;
            int index = SLOT_LEADERBOARD_START;
            for (int n = 0; n < numEntries; ++n) {
                OfflinePlayer entryPlayer = leaderboard.getOfflinePlayer(n);
                KonOfflinePlayer offlinePlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(entryPlayer);
                if (offlinePlayer == null) continue;
                icon = new PlayerIcon(entryPlayer, this.getColor((KonOfflinePlayer)this.player, offlinePlayer), this.getRelation((KonOfflinePlayer)this.player, offlinePlayer), index, true);
                icon.addProperty(MessagePath.LABEL_LEADERBOARD.getMessage(new Object[0]) + " #" + rank);
                icon.addNameValue(MessagePath.LABEL_SCORE.getMessage(new Object[0]), leaderboard.getScore(n));
                icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), kingdomName);
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.PLAYER_SCORE);
                result.addIcon(icon);
                ++rank;
                ++index;
            }
        }
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        switch (((MenuState)context).ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 2: {
                result.addAll(this.createPlayerView());
                break;
            }
            case 5: {
                result.addAll(this.createKingdomView());
                break;
            }
            case 3: {
                result.add(this.createPlayerScoreView());
                break;
            }
            case 6: {
                result.add(this.createKingdomScoreView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        MenuState currentState = (MenuState)this.getCurrentState();
        if (currentState == null) {
            return null;
        }
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                switch (currentState.ordinal()) {
                    case 3: {
                        this.scorePlayer = null;
                        result = this.returnState == null ? this.setCurrentView(MenuState.ROOT) : this.setCurrentView(this.returnState);
                        this.returnState = null;
                        break;
                    }
                    case 6: {
                        this.scoreKingdom = null;
                        result = this.returnState == null ? this.setCurrentView(MenuState.ROOT) : this.setCurrentView(this.returnState);
                        this.returnState = null;
                        break;
                    }
                    default: {
                        result = this.setCurrentView(MenuState.ROOT);
                        break;
                    }
                }
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState nextState = (MenuState)clickedIcon.getState();
            this.returnState = currentState;
            switch (currentState.ordinal()) {
                case 0: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 2: 
                        case 5: {
                            result = this.setCurrentView(nextState);
                            break;
                        }
                        case 1: {
                            this.scorePlayer = this.player;
                            result = this.refreshNewView(MenuState.PLAYER_SCORE);
                            break;
                        }
                        case 4: {
                            this.scoreKingdom = this.player.getKingdom();
                            result = this.refreshNewView(MenuState.KINGDOM_SCORE);
                        }
                    }
                    break;
                }
                case 2: 
                case 6: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    this.scorePlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(icon.getOfflinePlayer());
                    result = this.refreshNewView(MenuState.PLAYER_SCORE);
                    break;
                }
                case 5: {
                    if (!(clickedIcon instanceof KingdomIcon)) break;
                    KingdomIcon icon = (KingdomIcon)clickedIcon;
                    this.scoreKingdom = icon.getKingdom();
                    result = this.refreshNewView(MenuState.KINGDOM_SCORE);
                    break;
                }
            }
        }
        return result;
    }

    private String getTitle(MenuState context) {
        String result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_MAIN_SCORE.getMessage(new Object[0]);
                break;
            }
            case 2: {
                result = MessagePath.LABEL_PLAYERS.getMessage(new Object[0]);
                break;
            }
            case 3: {
                result = MessagePath.MENU_SCORE_PLAYER_SCORE.getMessage(new Object[0]);
                break;
            }
            case 5: {
                result = MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]);
                break;
            }
            case 6: {
                result = MessagePath.MENU_SCORE_KINGDOM_SCORE.getMessage(new Object[0]);
                break;
            }
        }
        return result;
    }

    private boolean isPlayerScored(KonOfflinePlayer player) {
        return !player.isBarbarian() && !player.getKingdom().isPeaceful();
    }

    private boolean isKingdomScored(KonKingdom kingdom) {
        return kingdom.isCreated() && !kingdom.isPeaceful();
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        PLAYER_SELF,
        PLAYER_ALL,
        PLAYER_SCORE,
        KINGDOM_SELF,
        KINGDOM_ALL,
        KINGDOM_SCORE;

    }
}

