/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.api.model.KonquestUpgrade;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.ArmorIcon;
import com.github.rumsfield.konquest.display.icon.CommandIcon;
import com.github.rumsfield.konquest.display.icon.ConfirmationIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.OptionIcon;
import com.github.rumsfield.konquest.display.icon.PlayerIcon;
import com.github.rumsfield.konquest.display.icon.ProfessionIcon;
import com.github.rumsfield.konquest.display.icon.ShieldIcon;
import com.github.rumsfield.konquest.display.icon.TownIcon;
import com.github.rumsfield.konquest.display.icon.UpgradeIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.model.KonArmor;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonLootTable;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonShield;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonTownOption;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Villager;

public class TownMenu
extends StateMenu {
    private final KingdomManager manager;
    private final KonPlayer player;
    private final KonKingdom kingdom;
    private final boolean isAdmin;
    private KonTown town;

    public TownMenu(Konquest konquest, KonPlayer player, boolean isAdmin) {
        super(konquest, MenuState.ROOT, null);
        this.player = player;
        this.isAdmin = isAdmin;
        this.manager = konquest.getKingdomManager();
        this.kingdom = player.getKingdom();
        this.town = null;
        this.updateAccess();
        this.setCurrentView(MenuState.ROOT);
    }

    public void goToManagementRoot(KonTown town) {
        if (town == null) {
            return;
        }
        this.town = town;
        this.updateAccess();
        if (this.isAccess(AccessType.DEFAULT)) {
            this.playStatusSound(this.player.getBukkitPlayer(), false);
            return;
        }
        this.refreshNewView(MenuState.MANAGEMENT_ROOT);
    }

    private DisplayView createRootView() {
        if (this.isAccess(AccessType.BARBARIAN)) {
            return null;
        }
        boolean isClickable = !this.isAdmin;
        int ROOT_SLOT_JOIN = 0;
        int ROOT_SLOT_LEAVE = 2;
        int ROOT_SLOT_MANAGE = 4;
        int ROOT_SLOT_INVITES = 6;
        int ROOT_SLOT_LIST = 8;
        int ROOT_SLOT_SETTLE = 12;
        int ROOT_SLOT_CLAIM = 13;
        int ROOT_SLOT_UNCLAIM = 14;
        DisplayView result = new DisplayView(2, this.getTitle(MenuState.ROOT));
        MenuIcon icon = new InfoIcon(MessagePath.MENU_TOWN_JOIN.getMessage(new Object[0]), Material.SADDLE, ROOT_SLOT_JOIN, isClickable);
        icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_JOIN.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        icon.setState(MenuState.JOIN);
        result.addIcon(icon);
        icon = new InfoIcon(MessagePath.MENU_TOWN_LEAVE.getMessage(new Object[0]), Material.ARROW, ROOT_SLOT_LEAVE, isClickable);
        icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_LEAVE.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        icon.setState(MenuState.LEAVE);
        result.addIcon(icon);
        int numList = this.kingdom.getCapitalTowns().size();
        icon = new InfoIcon(MessagePath.MENU_TOWN_LIST.getMessage(new Object[0]), Material.PAPER, ROOT_SLOT_LIST, true);
        icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_LIST.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numList);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.LIST);
        result.addIcon(icon);
        int numInvites = this.manager.getInviteTowns(this.player).size();
        Material inviteMat = numInvites > 0 ? Material.WRITABLE_BOOK : Material.BOOK;
        icon = new InfoIcon(MessagePath.MENU_TOWN_INVITES.getMessage(new Object[0]), inviteMat, ROOT_SLOT_INVITES, isClickable);
        icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_INVITES.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numInvites);
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
        }
        icon.setState(MenuState.INVITES);
        result.addIcon(icon);
        int numManage = this.manager.getManageTowns(this.player).size();
        icon = new InfoIcon(MessagePath.MENU_TOWN_MANAGE.getMessage(new Object[0]), Material.BOOKSHELF, ROOT_SLOT_MANAGE, true);
        icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_MANAGE.getMessage(new Object[0]));
        icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numManage);
        icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
        icon.setState(MenuState.MANAGE);
        result.addIcon(icon);
        CommandType iconCommand = CommandType.SETTLE;
        double settleCost = this.getKonquest().getKingdomManager().getSettleCost(this.player);
        boolean isPermission = this.player.getBukkitPlayer().hasPermission(iconCommand.permission());
        icon = new CommandIcon(iconCommand, isPermission, (int)settleCost, 0, ROOT_SLOT_SETTLE);
        if (isPermission) {
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        iconCommand = CommandType.CLAIM;
        double cost_claim = this.getKonquest().getCore().getDouble(CorePath.FAVOR_COST_CLAIM.getPath(), 0.0);
        isPermission = this.player.getBukkitPlayer().hasPermission(iconCommand.permission());
        icon = new CommandIcon(iconCommand, isPermission, (int)cost_claim, 0, ROOT_SLOT_CLAIM);
        if (isPermission) {
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        iconCommand = CommandType.UNCLAIM;
        isPermission = this.player.getBukkitPlayer().hasPermission(iconCommand.permission());
        icon = new CommandIcon(iconCommand, isPermission, 0, 0, ROOT_SLOT_UNCLAIM);
        if (isPermission) {
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_NO_PERMISSION.getMessage(new Object[0]));
        }
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavHome(result);
        this.addNavClose(result);
        return result;
    }

    private List<DisplayView> createTownView(MenuState context) {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        switch (context.ordinal()) {
            case 1: {
                for (KonTown town : this.kingdom.getCapitalTowns()) {
                    if (town.isPlayerResident(this.player.getOfflineBukkitPlayer())) continue;
                    towns.add(town);
                }
                break;
            }
            case 2: {
                for (KonTown town : this.kingdom.getCapitalTowns()) {
                    if (!town.isPlayerResident(this.player.getOfflineBukkitPlayer())) continue;
                    towns.add(town);
                }
                break;
            }
            case 5: {
                towns.addAll(this.kingdom.getCapitalTowns());
                break;
            }
            case 4: {
                towns.addAll(this.manager.getInviteTowns(this.player));
                break;
            }
            case 3: {
                if (this.isAccess(AccessType.ADMIN)) {
                    for (KonKingdom kingdom : this.manager.getKingdoms()) {
                        towns.addAll(kingdom.getCapitalTowns());
                    }
                    break;
                }
                towns.addAll(this.manager.getManageTowns(this.player));
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        towns.sort(this.townComparator);
        for (KonTown currentTown : towns) {
            boolean isCurrentTownClickable = !(context.equals(MenuState.JOIN) && !currentTown.isJoinable() || context.equals(MenuState.LEAVE) && !currentTown.isLeaveable());
            TownIcon icon = new TownIcon(currentTown, this.getColor((KonOfflinePlayer)this.player, currentTown), this.getRelation((KonOfflinePlayer)this.player, currentTown), 0, isCurrentTownClickable);
            switch (context.ordinal()) {
                case 1: {
                    if (currentTown.isJoinable()) {
                        if (currentTown.isOpen() || currentTown.getNumResidents() == 0) {
                            icon.addHint(MessagePath.MENU_TOWN_HINT_JOIN_NOW.getMessage(new Object[0]));
                            break;
                        }
                        icon.addHint(MessagePath.MENU_TOWN_HINT_JOIN.getMessage(new Object[0]));
                        break;
                    }
                    icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    break;
                }
                case 2: {
                    if (currentTown.isLeaveable()) {
                        icon.addHint(MessagePath.MENU_TOWN_HINT_LEAVE.getMessage(new Object[0]));
                        break;
                    }
                    icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                    break;
                }
                case 5: {
                    icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
                    break;
                }
                case 4: {
                    icon.addHint(MessagePath.MENU_HINT_ACCEPT.getMessage(new Object[0]));
                    icon.addHint(MessagePath.MENU_HINT_DECLINE.getMessage(new Object[0]));
                    break;
                }
                case 3: {
                    int numRequests = currentTown.getJoinRequests().size();
                    if (numRequests > 0) {
                        icon.addAlert(MessagePath.MENU_TOWN_REQUESTS.getMessage(new Object[0]));
                    }
                    icon.addNameValue(MessagePath.MENU_TOWN_REQUESTS.getMessage(new Object[0]), numRequests);
                    icon.addHint(MessagePath.MENU_TOWN_HINT_MANAGE.getMessage(new Object[0]));
                    break;
                }
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private DisplayView createManagementRootView() {
        MenuIcon icon;
        int rows;
        if (this.isAccess(AccessType.LORD) || this.isAccess(AccessType.ADMIN)) {
            rows = 2;
        } else if (this.isAccess(AccessType.KNIGHT)) {
            rows = 1;
        } else {
            return null;
        }
        int ROOT_SLOT_REQUESTS = 0;
        int ROOT_SLOT_PLOTS = 2;
        int ROOT_SLOT_INFO = 4;
        int ROOT_SLOT_SHIELD = 6;
        int ROOT_SLOT_ARMOR = 8;
        int ROOT_SLOT_PROMOTE = 10;
        int ROOT_SLOT_DEMOTE = 11;
        int ROOT_SLOT_TRANSFER = 12;
        int ROOT_SLOT_DESTROY = 13;
        int ROOT_SLOT_UPGRADES = 14;
        int ROOT_SLOT_OPTIONS = 15;
        int ROOT_SLOT_SPECIALIZATION = 16;
        DisplayView result = new DisplayView(rows, this.getTitle(MenuState.MANAGEMENT_ROOT));
        if (this.isAccess(AccessType.KNIGHT) || this.isAccess(AccessType.LORD) || this.isAccess(AccessType.ADMIN)) {
            int numRequests = this.town.getJoinRequests().size();
            Material requestMat = numRequests > 0 ? Material.HONEY_BOTTLE : Material.GLASS_BOTTLE;
            icon = new InfoIcon(MessagePath.MENU_TOWN_REQUESTS.getMessage(new Object[0]), requestMat, ROOT_SLOT_REQUESTS, true);
            icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_REQUESTS.getMessage(new Object[0]));
            icon.addNameValue(MessagePath.LABEL_TOTAL.getMessage(new Object[0]), numRequests);
            icon.addProperty(MessagePath.RELATIONSHIP_ROLE_KNIGHT.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.A_REQUESTS);
            result.addIcon(icon);
            if (this.getKonquest().getPlotManager().isEnabled()) {
                boolean isPlotsClickable = this.isAdmin || this.town.hasPropertyValue(KonPropertyFlag.PLOTS) && this.town.getPropertyValue(KonPropertyFlag.PLOTS);
                icon = new InfoIcon(MessagePath.MENU_TOWN_PLOTS.getMessage(new Object[0]), Material.GRASS_BLOCK, ROOT_SLOT_PLOTS, isPlotsClickable);
                icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_PLOTS.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_ROLE_KNIGHT.getMessage(new Object[0]));
                if (isPlotsClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
                }
                icon.setState(MenuState.A_PLOTS);
                result.addIcon(icon);
            }
            boolean isInfoClickable = !this.isAdmin;
            icon = new TownIcon(this.town, this.getColor((KonOfflinePlayer)this.player, this.town), this.getRelation((KonOfflinePlayer)this.player, this.town), ROOT_SLOT_INFO, isInfoClickable);
            icon.addProperty(MessagePath.LABEL_INFORMATION.getMessage(new Object[0]));
            if (isInfoClickable) {
                icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            }
            icon.setState(MenuState.A_INFO);
            result.addIcon(icon);
            if (this.getKonquest().getShieldManager().isShieldsEnabled()) {
                icon = new InfoIcon(MessagePath.MENU_TOWN_SHIELDS.getMessage(new Object[0]), Material.SHIELD, ROOT_SLOT_SHIELD, true);
                icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_SHIELDS.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_ROLE_KNIGHT.getMessage(new Object[0]));
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.A_SHIELD);
                result.addIcon(icon);
            }
            if (this.getKonquest().getShieldManager().isArmorsEnabled()) {
                icon = new InfoIcon(MessagePath.MENU_TOWN_ARMOR.getMessage(new Object[0]), Material.CHAINMAIL_CHESTPLATE, ROOT_SLOT_ARMOR, true);
                icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_ARMOR.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_ROLE_KNIGHT.getMessage(new Object[0]));
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.A_ARMOR);
                result.addIcon(icon);
            }
        }
        if (this.isAccess(AccessType.LORD) || this.isAccess(AccessType.ADMIN)) {
            boolean isPromoteClickable = this.town.isPromoteable() || this.isAdmin;
            icon = new InfoIcon(MessagePath.MENU_TOWN_PROMOTE.getMessage(new Object[0]), Material.IRON_HORSE_ARMOR, ROOT_SLOT_PROMOTE, isPromoteClickable);
            icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_PROMOTE.getMessage(new Object[0]));
            icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
            if (isPromoteClickable) {
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            }
            icon.setState(MenuState.B_PROMOTE);
            result.addIcon(icon);
            boolean isDemoteClickable = this.town.isDemoteable() || this.isAdmin;
            icon = new InfoIcon(MessagePath.MENU_TOWN_DEMOTE.getMessage(new Object[0]), Material.LEATHER_CHESTPLATE, ROOT_SLOT_DEMOTE, isDemoteClickable);
            icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_DEMOTE.getMessage(new Object[0]));
            icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
            if (isPromoteClickable) {
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            }
            icon.setState(MenuState.B_DEMOTE);
            result.addIcon(icon);
            boolean isTransferClickable = this.town.isTransferable() || this.isAdmin;
            icon = new InfoIcon(MessagePath.MENU_TOWN_TRANSFER.getMessage(new Object[0]), Material.IRON_HELMET, ROOT_SLOT_TRANSFER, isTransferClickable);
            icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_TRANSFER.getMessage(new Object[0]));
            icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
            if (isPromoteClickable) {
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            }
            icon.setState(MenuState.B_TRANSFER);
            result.addIcon(icon);
            if (this.town.getTerritoryType().equals((Object)KonquestTerritoryType.TOWN) && this.getKonquest().getKingdomManager().getIsTownDestroyLordEnable()) {
                icon = new InfoIcon(MessagePath.MENU_TOWN_DESTROY.getMessage(new Object[0]), Material.TNT, ROOT_SLOT_DESTROY, true);
                icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_DESTROY.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
                icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                icon.setState(MenuState.B_DESTROY);
                result.addIcon(icon);
            }
            if (this.getKonquest().getUpgradeManager().isEnabled()) {
                boolean isUpgradesClickable = this.isAdmin || this.town.hasPropertyValue(KonPropertyFlag.UPGRADE) && this.town.getPropertyValue(KonPropertyFlag.UPGRADE);
                icon = new InfoIcon(MessagePath.MENU_TOWN_UPGRADES.getMessage(new Object[0]), Material.GOLDEN_APPLE, ROOT_SLOT_UPGRADES, isUpgradesClickable);
                icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_UPGRADES.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
                if (isUpgradesClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
                }
                icon.setState(MenuState.B_UPGRADES);
                result.addIcon(icon);
            }
            icon = new InfoIcon(MessagePath.MENU_TOWN_OPTIONS.getMessage(new Object[0]), Material.OAK_SIGN, ROOT_SLOT_OPTIONS, true);
            icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_OPTIONS.getMessage(new Object[0]));
            icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
            icon.setState(MenuState.B_OPTIONS);
            result.addIcon(icon);
            if (this.getKonquest().getKingdomManager().getIsDiscountEnable()) {
                boolean isSpecializationClickable = this.isAdmin || this.town.hasPropertyValue(KonPropertyFlag.SPECIALIZE) && this.town.getPropertyValue(KonPropertyFlag.SPECIALIZE);
                icon = new InfoIcon(MessagePath.MENU_TOWN_SPECIAL.getMessage(new Object[0]), Material.EMERALD, ROOT_SLOT_SPECIALIZATION, isSpecializationClickable);
                icon.addDescription(MessagePath.MENU_TOWN_DESCRIPTION_SPECIAL.getMessage(new Object[0]));
                icon.addProperty(MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]));
                icon.addNameValue(MessagePath.LABEL_SPECIALIZATION.getMessage(new Object[0]), this.town.getSpecializationName());
                if (isSpecializationClickable) {
                    icon.addHint(MessagePath.MENU_HINT_OPEN.getMessage(new Object[0]));
                } else {
                    icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
                }
                icon.setState(MenuState.B_SPECIALIZATION);
                result.addIcon(icon);
            }
        }
        this.addNavEmpty(result);
        this.addNavClose(result);
        if (!this.isAdmin) {
            this.addNavHome(result);
            this.addNavReturn(result);
        }
        return result;
    }

    private List<DisplayView> createPlayerView(MenuState context) {
        if (this.town == null) {
            return Collections.emptyList();
        }
        String loreHintStr1 = "";
        String loreHintStr2 = "";
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        switch (context.ordinal()) {
            case 7: {
                players.addAll(this.town.getJoinRequests());
                loreHintStr1 = MessagePath.MENU_HINT_ACCEPT.getMessage(new Object[0]);
                loreHintStr2 = MessagePath.MENU_HINT_DECLINE.getMessage(new Object[0]);
                break;
            }
            case 12: {
                players.addAll(this.town.getPlayerResidentsOnly());
                loreHintStr1 = MessagePath.MENU_TOWN_HINT_PROMOTE.getMessage(new Object[0]);
                break;
            }
            case 13: {
                players.addAll(this.town.getPlayerKnightsOnly());
                loreHintStr1 = MessagePath.MENU_TOWN_HINT_DEMOTE.getMessage(new Object[0]);
                break;
            }
            case 14: {
                players.addAll(this.town.getPlayerKnightsOnly());
                players.addAll(this.town.getPlayerResidentsOnly());
                loreHintStr1 = MessagePath.MENU_TOWN_HINT_TRANSFER.getMessage(new Object[0]);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        for (OfflinePlayer currentPlayer : players) {
            KonOfflinePlayer offlinePlayer = this.getKonquest().getPlayerManager().getOfflinePlayer(currentPlayer);
            if (offlinePlayer == null) continue;
            PlayerIcon icon = new PlayerIcon(currentPlayer, this.getColor((KonOfflinePlayer)this.player, offlinePlayer), this.getRelation((KonOfflinePlayer)this.player, offlinePlayer), 0, true);
            String townRole = this.town.getPlayerRoleName(currentPlayer);
            if (!townRole.isEmpty()) {
                icon.addNameValue(MessagePath.LABEL_TOWN_ROLE.getMessage(new Object[0]), townRole);
            }
            if (!loreHintStr1.isEmpty()) {
                icon.addHint(loreHintStr1);
            }
            if (!loreHintStr2.isEmpty()) {
                icon.addHint(loreHintStr2);
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(context)));
    }

    private List<DisplayView> createShieldView() {
        if (this.town == null || !this.getKonquest().getShieldManager().isShieldsEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        for (KonShield currentShield : this.getKonquest().getShieldManager().getShields()) {
            int cost = this.getKonquest().getShieldManager().getTotalCostShield(currentShield, this.town);
            icons.add(new ShieldIcon(currentShield, cost, 0));
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.A_SHIELD)));
    }

    private List<DisplayView> createArmorView() {
        if (this.town == null || !this.getKonquest().getShieldManager().isArmorsEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        for (KonArmor currentArmor : this.getKonquest().getShieldManager().getArmors()) {
            int cost = this.getKonquest().getShieldManager().getTotalCostArmor(currentArmor, this.town);
            icons.add(new ArmorIcon(currentArmor, cost, 0));
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.A_ARMOR)));
    }

    private List<DisplayView> createUpgradeView() {
        if (this.town == null || !this.getKonquest().getUpgradeManager().isEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        HashMap<KonquestUpgrade, Integer> availableUpgrades = this.getKonquest().getUpgradeManager().getAvailableUpgrades(this.town);
        ArrayList<KonUpgrade> allUpgrades = new ArrayList<KonUpgrade>();
        for (KonUpgrade upgrade : KonUpgrade.values()) {
            if (!availableUpgrades.containsKey(upgrade)) continue;
            allUpgrades.add(upgrade);
        }
        for (KonUpgrade currentUpgrade : allUpgrades) {
            int currentLevel = availableUpgrades.get(currentUpgrade);
            int cost = this.getKonquest().getUpgradeManager().getUpgradeCost(currentUpgrade, currentLevel);
            int pop = this.getKonquest().getUpgradeManager().getUpgradePopulation(currentUpgrade, currentLevel);
            icons.add(new UpgradeIcon(currentUpgrade, currentLevel, 0, cost, pop));
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.B_UPGRADES)));
    }

    private List<DisplayView> createOptionsView() {
        if (this.town == null) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonTownOption> allOptions = new ArrayList<KonTownOption>();
        for (KonTownOption townOption : KonTownOption.values()) {
            boolean isOptionEnabled = true;
            if (townOption.equals((Object)KonTownOption.ALLIED_BUILDING)) {
                isOptionEnabled = this.getKonquest().getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath(), false);
            }
            if (this.town.isTownOptionOverridden(townOption)) {
                isOptionEnabled = false;
            }
            if (!isOptionEnabled) continue;
            allOptions.add(townOption);
        }
        for (KonTownOption currentOption : allOptions) {
            boolean val = this.town.getTownOption(currentOption);
            String currentValue = DisplayManager.boolean2Lang(val) + " " + DisplayManager.boolean2Symbol(val);
            OptionIcon icon = new OptionIcon(currentOption, 0, true);
            icon.addNameValue(MessagePath.LABEL_CURRENT.getMessage(new Object[0]), currentValue);
            icon.addHint(MessagePath.MENU_HINT_CHANGE.getMessage(new Object[0]));
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.B_OPTIONS)));
    }

    private List<DisplayView> createSpecializationView() {
        if (this.town == null || !this.getKonquest().getKingdomManager().getIsDiscountEnable()) {
            return Collections.emptyList();
        }
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        double costSpecial = this.getKonquest().getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SPECIALIZE.getPath());
        for (Villager.Profession profession : CompatibilityUtil.getProfessions()) {
            KonLootTable specialLoot;
            if (CompatibilityUtil.isProfessionEqual(profession, this.town.getSpecialization())) continue;
            ProfessionIcon icon = new ProfessionIcon(profession, 0, true);
            icon.addProperty(MessagePath.LABEL_SPECIALIZATION.getMessage(new Object[0]));
            if (!this.isAdmin) {
                icon.addNameValue(MessagePath.LABEL_COST.getMessage(new Object[0]), KonquestPlugin.getCurrencyFormat(costSpecial));
            }
            if ((specialLoot = this.getKonquest().getLootManager().getMonumentSpecialLootTable(CompatibilityUtil.getProfessionName(profession))) != null) {
                icon.addNameValue(MessagePath.LABEL_LOOT_TYPE.getMessage(new Object[0]), specialLoot.getName());
                icon.addDescription(MessagePath.MENU_TOWN_LOOT_SPECIAL.getMessage(new Object[0]));
            }
            icon.addDescription(MessagePath.MENU_TOWN_LORE_SPECIAL.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_TOWN_HINT_SPECIAL.getMessage(new Object[0]));
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.B_SPECIALIZATION)));
    }

    private DisplayView createDestroyView() {
        DisplayView result = new DisplayView(1, this.getTitle(MenuState.B_DESTROY));
        int SLOT_YES = 3;
        int SLOT_NO = 5;
        ConfirmationIcon icon = new ConfirmationIcon(true, SLOT_YES);
        icon.addHint(MessagePath.MENU_TOWN_HINT_DESTROY.getMessage(new Object[0]));
        icon.setState(MenuState.CONFIRM_YES);
        result.addIcon(icon);
        icon = new ConfirmationIcon(false, SLOT_NO);
        icon.addHint(MessagePath.MENU_HINT_EXIT.getMessage(new Object[0]));
        icon.setState(MenuState.CONFIRM_NO);
        result.addIcon(icon);
        this.addNavEmpty(result);
        this.addNavClose(result);
        this.addNavReturn(result);
        return result;
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        MenuState currentState = (MenuState)context;
        switch (currentState.ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                result.addAll(this.createTownView(currentState));
                break;
            }
            case 6: {
                result.add(this.createManagementRootView());
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                result.addAll(this.createPlayerView(currentState));
                break;
            }
            case 10: {
                result.addAll(this.createShieldView());
                break;
            }
            case 11: {
                result.addAll(this.createArmorView());
                break;
            }
            case 16: {
                result.addAll(this.createUpgradeView());
                break;
            }
            case 17: {
                result.addAll(this.createOptionsView());
                break;
            }
            case 18: {
                result.addAll(this.createSpecializationView());
                break;
            }
            case 15: {
                result.add(this.createDestroyView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        MenuState currentState = (MenuState)this.getCurrentState();
        if (currentState == null) {
            return null;
        }
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                switch (currentState.ordinal()) {
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        result = this.refreshNewView(MenuState.MANAGEMENT_ROOT);
                        break;
                    }
                    case 6: {
                        this.town = null;
                        result = this.refreshNewView(MenuState.MANAGE);
                        break;
                    }
                    default: {
                        result = this.refreshNewView(MenuState.ROOT);
                        break;
                    }
                }
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState nextState = (MenuState)clickedIcon.getState();
            switch (currentState.ordinal()) {
                case 0: {
                    if (clickedIcon instanceof CommandIcon) {
                        CommandIcon icon = (CommandIcon)clickedIcon;
                        for (String usageLine : icon.getCommand().argumentUsage()) {
                            ChatUtil.sendNotice((CommandSender)this.player.getBukkitPlayer(), usageLine);
                        }
                        result = view;
                        break;
                    }
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            result = this.refreshNewView(nextState);
                        }
                    }
                    break;
                }
                case 1: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown clickTown = icon.getTown();
                    boolean status = this.manager.menuJoinTownRequest(this.player, clickTown);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 2: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown clickTown = icon.getTown();
                    boolean status = this.manager.menuLeaveTown(this.player, clickTown);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 5: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown clickTown = icon.getTown();
                    this.getKonquest().getDisplayManager().displayInfoTownMenu(this.player, clickTown);
                    break;
                }
                case 4: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown clickTown = icon.getTown();
                    boolean status = this.manager.menuRespondTownInvite(this.player, clickTown, clickType);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 3: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    this.town = icon.getTown();
                    if (this.town == null) {
                        return null;
                    }
                    this.updateAccess();
                    if (this.isAccess(AccessType.DEFAULT)) {
                        this.playStatusSound(this.player.getBukkitPlayer(), false);
                        return null;
                    }
                    result = this.refreshNewView(MenuState.MANAGEMENT_ROOT);
                    break;
                }
                case 6: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 7: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            result = this.setCurrentView(nextState);
                            break;
                        }
                        case 8: {
                            this.getKonquest().getDisplayManager().displayTownPlotMenu(this.player, this.town);
                            break;
                        }
                        case 9: {
                            this.getKonquest().getDisplayManager().displayInfoTownMenu(this.player, this.town);
                        }
                    }
                    break;
                }
                case 7: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuRespondTownRequest(this.player, clickPlayer, this.town, clickType);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 10: {
                    if (!(clickedIcon instanceof ShieldIcon)) break;
                    ShieldIcon icon = (ShieldIcon)clickedIcon;
                    boolean status = this.getKonquest().getShieldManager().activateTownShield(icon.getShield(), this.town, this.player.getBukkitPlayer(), this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 11: {
                    if (!(clickedIcon instanceof ArmorIcon)) break;
                    ArmorIcon icon = (ArmorIcon)clickedIcon;
                    boolean status = this.getKonquest().getShieldManager().activateTownArmor(icon.getArmor(), this.town, this.player.getBukkitPlayer(), this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 12: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuPromoteDemoteTownKnight(this.player, clickPlayer, this.town, true);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 13: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuPromoteDemoteTownKnight(this.player, clickPlayer, this.town, false);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 14: {
                    if (!(clickedIcon instanceof PlayerIcon)) break;
                    PlayerIcon icon = (PlayerIcon)clickedIcon;
                    OfflinePlayer clickPlayer = icon.getOfflinePlayer();
                    boolean status = this.manager.menuTransferTownLord(this.player, clickPlayer, this.town, this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 15: {
                    if (nextState == null) {
                        return null;
                    }
                    if (!nextState.equals(MenuState.CONFIRM_YES)) break;
                    boolean status = this.manager.menuDestroyTown(this.town, this.player);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    break;
                }
                case 16: {
                    if (!(clickedIcon instanceof UpgradeIcon)) break;
                    UpgradeIcon icon = (UpgradeIcon)clickedIcon;
                    boolean status = this.getKonquest().getUpgradeManager().addTownUpgrade(this.town, icon.getUpgrade(), icon.getLevel(), this.player.getBukkitPlayer());
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 17: {
                    if (!(clickedIcon instanceof OptionIcon)) break;
                    OptionIcon icon = (OptionIcon)clickedIcon;
                    boolean status = this.manager.changeTownOption(icon.getOption(), this.town, this.player.getBukkitPlayer());
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
                case 18: {
                    if (!(clickedIcon instanceof ProfessionIcon)) break;
                    ProfessionIcon icon = (ProfessionIcon)clickedIcon;
                    Villager.Profession clickProfession = icon.getProfession();
                    boolean status = this.manager.menuChangeTownSpecialization(this.town, clickProfession, this.player, this.isAdmin);
                    this.playStatusSound(this.player.getBukkitPlayer(), status);
                    result = this.refreshCurrentView();
                    break;
                }
            }
        }
        return result;
    }

    private String getTitle(MenuState context) {
        Object result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_MAIN_TOWN.getMessage(new Object[0]);
                break;
            }
            case 1: {
                result = MessagePath.MENU_TOWN_TITLE_JOIN.getMessage(new Object[0]);
                break;
            }
            case 2: {
                result = MessagePath.MENU_TOWN_TITLE_LEAVE.getMessage(new Object[0]);
                break;
            }
            case 5: {
                result = MessagePath.MENU_TOWN_TITLE_LIST.getMessage(new Object[0]);
                break;
            }
            case 4: {
                result = MessagePath.MENU_TOWN_TITLE_INVITES.getMessage(new Object[0]);
                break;
            }
            case 3: {
                result = MessagePath.MENU_TOWN_TITLE_MANAGE_TOWN.getMessage(new Object[0]);
                break;
            }
            case 6: {
                result = MessagePath.MENU_TOWN_TITLE_MANAGE.getMessage(new Object[0]);
                break;
            }
            case 7: {
                result = MessagePath.MENU_TOWN_TITLE_REQUESTS.getMessage(new Object[0]);
                break;
            }
            case 10: {
                result = MessagePath.MENU_TOWN_SHIELDS.getMessage(new Object[0]);
                break;
            }
            case 11: {
                result = MessagePath.MENU_TOWN_ARMOR.getMessage(new Object[0]);
                break;
            }
            case 12: {
                result = MessagePath.MENU_TOWN_PROMOTE.getMessage(new Object[0]);
                break;
            }
            case 13: {
                result = MessagePath.MENU_TOWN_DEMOTE.getMessage(new Object[0]);
                break;
            }
            case 14: {
                result = MessagePath.MENU_TOWN_TRANSFER.getMessage(new Object[0]);
                break;
            }
            case 15: {
                result = MessagePath.MENU_TOWN_DESTROY.getMessage(new Object[0]);
                break;
            }
            case 16: {
                result = MessagePath.MENU_TOWN_UPGRADES.getMessage(new Object[0]);
                break;
            }
            case 17: {
                result = MessagePath.MENU_TOWN_OPTIONS.getMessage(new Object[0]);
                break;
            }
            case 18: {
                result = MessagePath.MENU_TOWN_SPECIAL.getMessage(new Object[0]);
                break;
            }
        }
        if (this.isAdmin) {
            result = DisplayManager.adminFormat + MessagePath.LABEL_ADMIN.getMessage(new Object[0]) + " - " + (String)result;
        }
        return result;
    }

    private void updateAccess() {
        UUID id = this.player.getBukkitPlayer().getUniqueId();
        if (this.isAdmin) {
            this.setAccess(AccessType.ADMIN);
        } else if (this.town != null) {
            if (this.town.isLord(id)) {
                this.setAccess(AccessType.LORD);
            } else if (this.town.isPlayerKnight((OfflinePlayer)this.player.getBukkitPlayer())) {
                this.setAccess(AccessType.KNIGHT);
            } else {
                this.setAccess(AccessType.DEFAULT);
            }
        } else if (this.player.isBarbarian()) {
            this.setAccess(AccessType.BARBARIAN);
        } else {
            this.setAccess(AccessType.DEFAULT);
        }
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        JOIN,
        LEAVE,
        MANAGE,
        INVITES,
        LIST,
        MANAGEMENT_ROOT,
        A_REQUESTS,
        A_PLOTS,
        A_INFO,
        A_SHIELD,
        A_ARMOR,
        B_PROMOTE,
        B_DEMOTE,
        B_TRANSFER,
        B_DESTROY,
        B_UPGRADES,
        B_OPTIONS,
        B_SPECIALIZATION,
        CONFIRM_YES,
        CONFIRM_NO;

    }

    static enum AccessType implements StateMenu.Access
    {
        DEFAULT,
        KNIGHT,
        LORD,
        ADMIN,
        BARBARIAN;

    }
}

