/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.display.menu;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.CampIcon;
import com.github.rumsfield.konquest.display.icon.InfoIcon;
import com.github.rumsfield.konquest.display.icon.KingdomIcon;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.icon.RuinIcon;
import com.github.rumsfield.konquest.display.icon.SanctuaryIcon;
import com.github.rumsfield.konquest.display.icon.TemplateIcon;
import com.github.rumsfield.konquest.display.icon.TownIcon;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.manager.TravelManager;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class TravelMenu
extends StateMenu {
    private final KonPlayer player;
    private final boolean isAdmin;

    public TravelMenu(Konquest konquest, KonPlayer player, boolean isAdmin) {
        super(konquest, MenuState.ROOT, AccessType.DEFAULT);
        this.player = player;
        this.isAdmin = isAdmin;
        if (isAdmin) {
            this.setAccess(AccessType.ADMIN);
        } else {
            this.setAccess(AccessType.DEFAULT);
        }
        this.setCurrentView(MenuState.ROOT);
    }

    private DisplayView createRootView() {
        if (!this.isAdmin && !this.getKonquest().isWorldValid(this.player.getBukkitPlayer().getWorld())) {
            ChatUtil.sendError((CommandSender)this.player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return null;
        }
        if (!this.isAdmin && !this.isTravelInTerritoryAllowed()) {
            ChatUtil.sendError((CommandSender)this.player.getBukkitPlayer(), MessagePath.COMMAND_TRAVEL_ERROR_ENEMY_TERRITORY.getMessage(new Object[0]));
            return null;
        }
        boolean isSanctuaryTravel = this.getKonquest().getCore().getBoolean(CorePath.TRAVEL_ENABLE_SANCTUARY.getPath(), false);
        boolean isCapitalTravel = this.getKonquest().getCore().getBoolean(CorePath.TRAVEL_ENABLE_CAPITAL.getPath(), false);
        boolean isCampTravel = this.getKonquest().getCore().getBoolean(CorePath.TRAVEL_ENABLE_CAMP.getPath(), false);
        boolean isHomeTravel = this.getKonquest().getCore().getBoolean(CorePath.TRAVEL_ENABLE_HOME.getPath(), false);
        boolean isWildTravel = this.getKonquest().getCore().getBoolean(CorePath.TRAVEL_ENABLE_WILD.getPath(), false);
        boolean isTownTravel = this.getKonquest().getCore().getBoolean(CorePath.TRAVEL_ENABLE_TOWNS.getPath(), false);
        int rows = 1;
        if (this.isAccess(AccessType.ADMIN)) {
            rows = 2;
        }
        int SLOT_KINGDOMS = 0;
        int SLOT_TOWNS = 1;
        int SLOT_SANCTUARIES = 2;
        int SLOT_CAPITAL = 5;
        int SLOT_HOME = 6;
        int SLOT_CAMP = 7;
        int SLOT_WILD = 8;
        int SLOT_CAMPS = 9;
        int SLOT_TEMPLATES = 10;
        int SLOT_RUINS = 11;
        DisplayView result = new DisplayView(rows, this.getTitle(MenuState.ROOT));
        boolean isClickable = this.isAdmin || isTownTravel && !this.player.isBarbarian();
        InfoIcon icon = new InfoIcon(MessagePath.LABEL_TOWNS.getMessage(new Object[0]), Material.OBSIDIAN, SLOT_TOWNS, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        } else if (!isTownTravel) {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
        }
        icon.setState(MenuState.TOWN_LIST);
        result.addIcon(icon);
        isClickable = this.isAdmin || isCapitalTravel && !this.player.isBarbarian();
        icon = new InfoIcon(MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]), Material.DIAMOND_HELMET, SLOT_KINGDOMS, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        } else if (!isCapitalTravel) {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
        }
        icon.setState(MenuState.KINGDOM_LIST);
        result.addIcon(icon);
        isClickable = this.isAdmin || isSanctuaryTravel;
        icon = new InfoIcon(MessagePath.LABEL_SANCTUARIES.getMessage(new Object[0]), Material.SMOOTH_QUARTZ, SLOT_SANCTUARIES, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        }
        icon.setState(MenuState.SANCTUARY_LIST);
        result.addIcon(icon);
        boolean isFlagAllowed = this.player.getKingdom().getCapital().getPropertyValue(KonPropertyFlag.TRAVEL);
        isClickable = this.isAdmin || isCapitalTravel && isFlagAllowed && !this.player.isBarbarian();
        icon = new InfoIcon(MessagePath.TERRITORY_CAPITAL.getMessage(new Object[0]), Material.NETHERITE_BLOCK, SLOT_CAPITAL, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        icon.addDescription(MessagePath.MENU_TRAVEL_DESCRIPTION_CAPITAL.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
        } else if (!isCapitalTravel) {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        } else if (!isFlagAllowed) {
            icon.addAlert(MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
            icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
        }
        icon.setState(MenuState.CAPITAL);
        result.addIcon(icon);
        boolean isHomeAvailable = this.player.getBukkitPlayer().getBedSpawnLocation() != null;
        isClickable = this.isAdmin || isHomeTravel && isHomeAvailable && !this.player.isBarbarian();
        icon = new InfoIcon(MessagePath.LABEL_HOME.getMessage(new Object[0]), Material.WHITE_BED, SLOT_HOME, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        icon.addDescription(MessagePath.MENU_TRAVEL_DESCRIPTION_HOME.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
        } else if (!isHomeTravel) {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        } else if (!isHomeAvailable) {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_NO_HOME.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
        }
        icon.setState(MenuState.HOME);
        result.addIcon(icon);
        boolean isCampSet = this.getKonquest().getCampManager().isCampSet(this.player);
        isClickable = this.player.isBarbarian() && isCampSet && (isCampTravel || this.isAdmin);
        icon = new InfoIcon(MessagePath.TERRITORY_CAMP.getMessage(new Object[0]), Material.ORANGE_BED, SLOT_CAMP, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        icon.addDescription(MessagePath.MENU_TRAVEL_DESCRIPTION_CAMP.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
        } else if (!isHomeTravel) {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        } else if (!isCampSet) {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_NO_CAMP.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
        }
        icon.setState(MenuState.CAMP);
        result.addIcon(icon);
        isClickable = this.isAdmin || isWildTravel;
        icon = new InfoIcon(MessagePath.GENERIC_NOTICE_WILD.getMessage(new Object[0]), Material.TALL_GRASS, SLOT_WILD, isClickable);
        icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
        icon.addDescription(MessagePath.MENU_TRAVEL_DESCRIPTION_WILD.getMessage(new Object[0]));
        if (isClickable) {
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
        } else {
            icon.addAlert(MessagePath.LABEL_DISABLED.getMessage(new Object[0]));
            icon.addError(MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        }
        icon.setState(MenuState.WILD);
        result.addIcon(icon);
        if (this.isAccess(AccessType.ADMIN)) {
            icon = new InfoIcon(MessagePath.LABEL_CAMPS.getMessage(new Object[0]), Material.ORANGE_BED, SLOT_CAMPS, true);
            icon.addProperty(MessagePath.LABEL_ADMIN.getMessage(new Object[0]));
            icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.CAMP_LIST);
            result.addIcon(icon);
            icon = new InfoIcon(MessagePath.LABEL_MONUMENT_TEMPLATES.getMessage(new Object[0]), Material.CRAFTING_TABLE, SLOT_TEMPLATES, true);
            icon.addProperty(MessagePath.LABEL_ADMIN.getMessage(new Object[0]));
            icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.TEMPLATE_LIST);
            result.addIcon(icon);
            icon = new InfoIcon(MessagePath.LABEL_RUINS.getMessage(new Object[0]), Material.MOSSY_COBBLESTONE, SLOT_RUINS, true);
            icon.addProperty(MessagePath.LABEL_ADMIN.getMessage(new Object[0]));
            icon.addProperty(MessagePath.LABEL_TRAVEL.getMessage(new Object[0]));
            icon.addHint(MessagePath.MENU_HINT_VIEW.getMessage(new Object[0]));
            icon.setState(MenuState.RUIN_LIST);
            result.addIcon(icon);
        }
        this.addNavEmpty(result);
        this.addNavClose(result);
        if (!this.isAdmin) {
            this.addNavHome(result);
        }
        return result;
    }

    private List<DisplayView> createTownView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        if (this.isAccess(AccessType.ADMIN)) {
            for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                towns.addAll(kingdom.getTowns());
            }
        } else {
            for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                if (!this.getKonquest().getKingdomManager().isPlayerFriendly(this.player, kingdom) && !this.getKonquest().getKingdomManager().isPlayerAlly(this.player, kingdom)) continue;
                towns.addAll(kingdom.getTowns());
            }
        }
        towns.sort(this.townNameComparator);
        for (KonTown currentTown : towns) {
            boolean isFlagTravelAllowed = currentTown.getPropertyValue(KonPropertyFlag.TRAVEL);
            boolean isCooldownAllowed = !currentTown.isPlayerTravelDisabled(this.player.getBukkitPlayer().getUniqueId());
            boolean isClickable = this.isAdmin || isFlagTravelAllowed && isCooldownAllowed;
            TownIcon icon = new TownIcon(currentTown, this.getColor((KonOfflinePlayer)this.player, currentTown), this.getRelation((KonOfflinePlayer)this.player, currentTown), 0, isClickable);
            icon.addNameValue(MessagePath.LABEL_KINGDOM.getMessage(new Object[0]), currentTown.getKingdom().getName());
            if (isClickable) {
                icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
            } else if (!isFlagTravelAllowed) {
                icon.addAlert(MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
            } else {
                String cooldown = currentTown.getPlayerTravelCooldownString(this.player.getBukkitPlayer().getUniqueId());
                icon.addAlert(MessagePath.LABEL_UNAVAILABLE.getMessage(new Object[0]));
                icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_COOLDOWN.getMessage(cooldown, currentTown.getName()));
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.TOWN_LIST)));
    }

    private List<DisplayView> createKingdomView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonKingdom> kingdoms = new ArrayList<KonKingdom>();
        if (this.isAccess(AccessType.ADMIN)) {
            kingdoms.addAll(this.getKonquest().getKingdomManager().getKingdoms());
        } else {
            for (KonKingdom kingdom : this.getKonquest().getKingdomManager().getKingdoms()) {
                if (!this.getKonquest().getKingdomManager().isPlayerFriendly(this.player, kingdom) && !this.getKonquest().getKingdomManager().isPlayerAlly(this.player, kingdom)) continue;
                kingdoms.add(kingdom);
            }
        }
        kingdoms.sort(this.kingdomNameComparator);
        for (KonKingdom currentKingdom : kingdoms) {
            boolean isFlagTravelAllowed = currentKingdom.getCapital().getPropertyValue(KonPropertyFlag.TRAVEL);
            boolean isClickable = this.isAdmin || isFlagTravelAllowed;
            KingdomIcon icon = new KingdomIcon(currentKingdom, this.getColor((KonOfflinePlayer)this.player, currentKingdom), this.getRelation((KonOfflinePlayer)this.player, currentKingdom), 0, isClickable);
            if (isClickable) {
                icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.KINGDOM_LIST)));
    }

    private List<DisplayView> createSanctuaryView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonSanctuary> sanctuaries = new ArrayList<KonSanctuary>(this.getKonquest().getSanctuaryManager().getSanctuaries());
        sanctuaries.sort(this.sanctuaryComparator);
        for (KonSanctuary currentSanctuary : sanctuaries) {
            boolean isFlagTravelAllowed = currentSanctuary.getPropertyValue(KonPropertyFlag.TRAVEL);
            boolean isClickable = this.isAdmin || isFlagTravelAllowed;
            SanctuaryIcon icon = new SanctuaryIcon(currentSanctuary, 0, isClickable);
            if (isClickable) {
                icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
            } else {
                icon.addAlert(MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                icon.addError(MessagePath.COMMAND_TRAVEL_ERROR_DISABLED.getMessage(new Object[0]));
            }
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.SANCTUARY_LIST)));
    }

    private List<DisplayView> createCampView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonCamp> camps = new ArrayList<KonCamp>(this.getKonquest().getCampManager().getCamps());
        camps.sort(this.campComparator);
        for (KonCamp currentCamp : camps) {
            CampIcon icon = new CampIcon(currentCamp, 0, true);
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.CAMP_LIST)));
    }

    private List<DisplayView> createRuinView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonRuin> ruins = new ArrayList<KonRuin>(this.getKonquest().getRuinManager().getRuins());
        ruins.sort(this.ruinComparator);
        for (KonRuin currentRuin : ruins) {
            RuinIcon icon = new RuinIcon(currentRuin, 0, true);
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.RUIN_LIST)));
    }

    private List<DisplayView> createTemplateView() {
        ArrayList<MenuIcon> icons = new ArrayList<MenuIcon>();
        ArrayList<KonMonumentTemplate> templates = new ArrayList<KonMonumentTemplate>(this.getKonquest().getSanctuaryManager().getAllTemplates());
        templates.sort(this.templateComparator);
        for (KonMonumentTemplate currentTemplate : templates) {
            TemplateIcon icon = new TemplateIcon(currentTemplate, 0, true);
            icon.addHint(MessagePath.MENU_HINT_TRAVEL.getMessage(new Object[0]));
            icons.add(icon);
        }
        return new ArrayList<DisplayView>(this.makePages(icons, this.getTitle(MenuState.TEMPLATE_LIST)));
    }

    @Override
    public ArrayList<DisplayView> createView(StateMenu.State context) {
        ArrayList<DisplayView> result = new ArrayList<DisplayView>();
        switch (((MenuState)context).ordinal()) {
            case 0: {
                result.add(this.createRootView());
                break;
            }
            case 1: {
                result.addAll(this.createTownView());
                break;
            }
            case 2: {
                result.addAll(this.createKingdomView());
                break;
            }
            case 3: {
                result.addAll(this.createSanctuaryView());
                break;
            }
            case 4: {
                result.addAll(this.createCampView());
                break;
            }
            case 5: {
                result.addAll(this.createRuinView());
                break;
            }
            case 6: {
                result.addAll(this.createTemplateView());
                break;
            }
        }
        return result;
    }

    @Override
    public DisplayView updateState(int slot, boolean clickType) {
        DisplayView result = null;
        if (this.isCurrentNavSlot(slot)) {
            if (this.isNavClose(slot)) {
                return null;
            }
            if (this.isNavHome(slot)) {
                this.getKonquest().getDisplayManager().displayMainMenu(this.player);
            } else if (this.isNavReturn(slot)) {
                result = this.setCurrentView(MenuState.ROOT);
            } else if (this.isNavBack(slot)) {
                result = this.goPageBack();
            } else if (this.isNavNext(slot)) {
                result = this.goPageNext();
            }
        } else if (this.isCurrentMenuSlot(slot)) {
            DisplayView view = this.getCurrentView();
            if (view == null) {
                return null;
            }
            MenuIcon clickedIcon = view.getIcon(slot);
            MenuState currentState = (MenuState)this.getCurrentState();
            if (currentState == null) {
                return null;
            }
            MenuState nextState = (MenuState)clickedIcon.getState();
            switch (currentState.ordinal()) {
                case 0: {
                    if (nextState == null) {
                        return null;
                    }
                    switch (nextState.ordinal()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            result = this.refreshNewView(nextState);
                            break;
                        }
                        case 7: {
                            KonCapital travelTerritory = this.player.getKingdom().getCapital();
                            Location travelLocation = travelTerritory.getSpawnLoc();
                            this.playerTravel(travelLocation, travelTerritory, TravelManager.TravelDestination.CAPITAL);
                            break;
                        }
                        case 8: {
                            Location travelLocation = this.player.getBukkitPlayer().getBedSpawnLocation();
                            this.playerTravel(travelLocation, null, TravelManager.TravelDestination.HOME);
                            break;
                        }
                        case 9: {
                            if (!this.getKonquest().getCampManager().isCampSet(this.player)) break;
                            KonCamp travelTerritory = this.getKonquest().getCampManager().getCamp(this.player);
                            Location travelLocation = travelTerritory.getSpawnLoc();
                            this.playerTravel(travelLocation, travelTerritory, TravelManager.TravelDestination.CAMP);
                            break;
                        }
                        case 10: {
                            this.playerTravel(null, null, TravelManager.TravelDestination.WILD);
                        }
                    }
                    break;
                }
                case 1: {
                    if (!(clickedIcon instanceof TownIcon)) break;
                    TownIcon icon = (TownIcon)clickedIcon;
                    KonTown travelTerritory = icon.getTown();
                    Location travelLocation = travelTerritory.getSpawnLoc();
                    this.playerTravel(travelLocation, travelTerritory, TravelManager.TravelDestination.TOWN);
                    break;
                }
                case 2: {
                    if (!(clickedIcon instanceof KingdomIcon)) break;
                    KingdomIcon icon = (KingdomIcon)clickedIcon;
                    KonCapital travelTerritory = icon.getKingdom().getCapital();
                    Location travelLocation = travelTerritory.getSpawnLoc();
                    this.playerTravel(travelLocation, travelTerritory, TravelManager.TravelDestination.CAPITAL);
                    break;
                }
                case 3: {
                    if (!(clickedIcon instanceof SanctuaryIcon)) break;
                    SanctuaryIcon icon = (SanctuaryIcon)clickedIcon;
                    KonSanctuary travelTerritory = icon.getSanctuary();
                    Location travelLocation = travelTerritory.getSpawnLoc();
                    this.playerTravel(travelLocation, travelTerritory, TravelManager.TravelDestination.SANCTUARY);
                    break;
                }
                case 4: {
                    if (!(clickedIcon instanceof CampIcon)) break;
                    CampIcon icon = (CampIcon)clickedIcon;
                    Location travelLocation = icon.getCamp().getSpawnLoc();
                    this.playerTravel(travelLocation, null, TravelManager.TravelDestination.OTHER);
                    break;
                }
                case 5: {
                    if (!(clickedIcon instanceof RuinIcon)) break;
                    RuinIcon icon = (RuinIcon)clickedIcon;
                    Location travelLocation = icon.getRuin().getSpawnLoc();
                    this.playerTravel(travelLocation, null, TravelManager.TravelDestination.OTHER);
                    break;
                }
                case 6: {
                    if (!(clickedIcon instanceof TemplateIcon)) break;
                    TemplateIcon icon = (TemplateIcon)clickedIcon;
                    Location travelLocation = icon.getTemplate().getSpawnLoc();
                    this.playerTravel(travelLocation, null, TravelManager.TravelDestination.OTHER);
                    break;
                }
            }
        }
        return result;
    }

    private String getTitle(MenuState context) {
        Object result = "error";
        switch (context.ordinal()) {
            case 0: {
                result = MessagePath.MENU_MAIN_TRAVEL.getMessage(new Object[0]);
                break;
            }
            case 1: {
                result = MessagePath.LABEL_TOWNS.getMessage(new Object[0]);
                break;
            }
            case 2: {
                result = MessagePath.LABEL_KINGDOMS.getMessage(new Object[0]);
                break;
            }
            case 3: {
                result = MessagePath.LABEL_SANCTUARIES.getMessage(new Object[0]);
                break;
            }
            case 4: {
                result = MessagePath.LABEL_CAMPS.getMessage(new Object[0]);
                break;
            }
            case 5: {
                result = MessagePath.LABEL_RUINS.getMessage(new Object[0]);
                break;
            }
            case 6: {
                result = MessagePath.LABEL_MONUMENT_TEMPLATES.getMessage(new Object[0]);
                break;
            }
        }
        if (this.isAdmin) {
            result = DisplayManager.adminFormat + MessagePath.LABEL_ADMIN.getMessage(new Object[0]) + " - " + (String)result;
        }
        return result;
    }

    private boolean isTravelInTerritoryAllowed() {
        boolean blockEnemyTravel = this.getKonquest().getCore().getBoolean(CorePath.KINGDOMS_NO_ENEMY_TRAVEL.getPath());
        boolean blockCampTravel = this.getKonquest().getCore().getBoolean(CorePath.CAMPS_NO_ENEMY_TRAVEL.getPath());
        Location playerLoc = this.player.getBukkitPlayer().getLocation();
        if (this.getKonquest().getTerritoryManager().isChunkClaimed(playerLoc)) {
            KonTerritory locTerritory = this.getKonquest().getTerritoryManager().getChunkTerritory(playerLoc);
            assert (locTerritory != null);
            KonKingdom locKingdom = locTerritory.getKingdom();
            boolean isKingdomTravelAllowed = locTerritory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY) || locKingdom.equals(this.player.getKingdom()) || this.getKonquest().getKingdomManager().isPlayerPeace(this.player, locKingdom) || this.getKonquest().getKingdomManager().isPlayerTrade(this.player, locKingdom) || this.getKonquest().getKingdomManager().isPlayerAlly(this.player, locKingdom);
            boolean isCampTravelBlocked = locTerritory instanceof KonCamp && !((KonCamp)locTerritory).isPlayerOwner((OfflinePlayer)this.player.getBukkitPlayer());
            return !(blockEnemyTravel && !isKingdomTravelAllowed || blockCampTravel && isCampTravelBlocked);
        }
        return true;
    }

    private void playerTravel(Location travelLocation, KonTerritory travelTerritory, TravelManager.TravelDestination travelDestination) {
        boolean status;
        if (travelDestination.equals((Object)TravelManager.TravelDestination.WILD)) {
            status = true;
            this.getKonquest().getTravelManager().submitWildTravel(this.player.getBukkitPlayer());
        } else {
            assert (travelLocation != null);
            if (this.isAccess(AccessType.ADMIN)) {
                status = true;
                this.getKonquest().telePlayerLocation(this.player.getBukkitPlayer(), travelLocation);
            } else {
                status = this.getKonquest().getTravelManager().submitTravel(this.player.getBukkitPlayer(), travelDestination, travelTerritory, travelLocation);
            }
        }
        this.playStatusSound(this.player.getBukkitPlayer(), status);
    }

    static enum MenuState implements StateMenu.State
    {
        ROOT,
        TOWN_LIST,
        KINGDOM_LIST,
        SANCTUARY_LIST,
        CAMP_LIST,
        RUIN_LIST,
        TEMPLATE_LIST,
        CAPITAL,
        HOME,
        CAMP,
        WILD;

    }

    static enum AccessType implements StateMenu.Access
    {
        DEFAULT,
        ADMIN;

    }
}

