/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.utility.CorePath;
import de.bluecolored.bluemap.api.BlueMapAPI;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BlueMapHook
implements PluginHook {
    private final Konquest konquest;
    private boolean isEnabled;
    private boolean isReady;

    public BlueMapHook(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.isReady = false;
    }

    @Override
    public String getPluginName() {
        return "BlueMap";
    }

    @Override
    public int reload() {
        this.isEnabled = false;
        Plugin bluemap = Bukkit.getPluginManager().getPlugin("BlueMap");
        if (bluemap == null) {
            return 1;
        }
        if (!bluemap.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_BLUEMAP.getPath(), false)) {
            return 3;
        }
        this.isReady = false;
        BlueMapAPI.onEnable(api -> {
            this.isReady = true;
            this.konquest.getMapHandler().initialize();
            this.konquest.getMapHandler().drawAllTerritories("BlueMap");
        });
        this.isEnabled = true;
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isReady() {
        return this.isReady;
    }

    @Nullable
    public BlueMapAPI getAPI() {
        return BlueMapAPI.getInstance().orElse(null);
    }
}

