/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.Acrobot.ChestShop.ChestShop;
import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.listener.ChestShopListener;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ChestShopHook
implements PluginHook {
    private final Konquest konquest;
    private ChestShop chestShopAPI;
    private boolean isEnabled;

    public ChestShopHook(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.chestShopAPI = null;
    }

    @Override
    public int reload() {
        this.isEnabled = false;
        Plugin chestShop = Bukkit.getPluginManager().getPlugin("ChestShop");
        if (chestShop == null) {
            return 1;
        }
        if (!chestShop.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_CHESTSHOP.getPath(), false)) {
            return 3;
        }
        try {
            this.chestShopAPI = (ChestShop)chestShop;
            this.konquest.getPlugin().getServer().getPluginManager().registerEvents((Listener)new ChestShopListener(this.konquest.getPlugin()), (Plugin)this.konquest.getPlugin());
            this.isEnabled = true;
            return 0;
        }
        catch (NoClassDefFoundError ignore) {
            ChatUtil.printConsoleError("Wrong ChestShop plugin installed, check the Konquest wiki for official dependencies.");
            return 4;
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public String getPluginName() {
        return "ChestShop";
    }

    @Nullable
    public ChestShop getAPI() {
        return this.chestShopAPI;
    }
}

