/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.listener.DiscordSRVListener;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.managers.RoleManager;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.RoleAction;
import github.scarsz.discordsrv.util.DiscordUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DiscordSrvHook
implements PluginHook {
    private final String noPermissionMessage = "Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.";
    private final int barbarianColor = 10723594;
    private int roleDefaultColor;
    private String roleSuffix;
    private boolean roleIsMentionable;
    private ArrayList<Permission> rolePermissions;
    private final Konquest konquest;
    private boolean isEnabled;
    private final DiscordSRVListener discordSrvListener;
    private boolean isKonquestReady;
    private boolean isDiscordReady;

    public DiscordSrvHook(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.discordSrvListener = new DiscordSRVListener(konquest);
        this.isKonquestReady = false;
        this.isDiscordReady = false;
        this.roleDefaultColor = 10723594;
        this.roleSuffix = "(auto)";
        this.roleIsMentionable = true;
        this.rolePermissions = new ArrayList();
    }

    @Override
    public String getPluginName() {
        return "DiscordSRV";
    }

    @Override
    public int reload() {
        this.isEnabled = false;
        Plugin discordSrv = Bukkit.getPluginManager().getPlugin("DiscordSRV");
        if (discordSrv == null) {
            return 1;
        }
        if (!discordSrv.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV.getPath(), false)) {
            return 3;
        }
        try {
            DiscordSRV.api.subscribe((Object)this.discordSrvListener);
            this.isDiscordReady = DiscordSRV.isReady;
            this.isEnabled = true;
            this.reloadSettings();
            return 0;
        }
        catch (Exception e) {
            ChatUtil.printConsoleError("Failed to integrate DiscordSRV, see exception message:");
            e.printStackTrace();
            return -1;
        }
    }

    public void reloadSettings() {
        if (!this.isEnabled) {
            return;
        }
        String defaultColor = this.konquest.getCore().getString(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_ROLE_DEFAULT_COLOR.getPath(), "");
        if (defaultColor.isEmpty()) {
            this.roleDefaultColor = 10723594;
        } else {
            this.roleDefaultColor = ChatUtil.lookupColorRGB(defaultColor);
            if (this.roleDefaultColor == -1) {
                this.roleDefaultColor = 10723594;
            }
        }
        this.roleSuffix = this.konquest.getCore().getString(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_ROLE_SUFFIX.getPath(), "(auto)");
        this.roleIsMentionable = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_ROLE_IS_MENTIONABLE.getPath(), true);
        List rolePermissionNames = this.konquest.getCore().getStringList(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_ROLE_PERMISSIONS.getPath());
        this.rolePermissions = new ArrayList();
        for (String permName : rolePermissionNames) {
            try {
                this.rolePermissions.add(Permission.valueOf((String)permName));
            }
            catch (IllegalArgumentException | NullPointerException me) {
                ChatUtil.printConsoleError("Invalid Discord role permission specified in discord.yml: " + permName);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.isEnabled) {
            try {
                DiscordSRV.api.unsubscribe((Object)this.discordSrvListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setKonquestReady() {
        this.isKonquestReady = true;
    }

    public void setDiscordReady() {
        this.isDiscordReady = true;
    }

    private boolean isReady() {
        return this.isEnabled && this.isKonquestReady && this.isDiscordReady;
    }

    public String getLinkMessage(Player player) {
        if (!this.isEnabled) {
            return "";
        }
        String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
        if (discordId == null) {
            return String.valueOf(ChatColor.RED) + MessagePath.DISCORD_SRV_NO_LINK.getMessage(new Object[0]);
        }
        User user = DiscordUtil.getJda().getUserById(discordId);
        if (user == null) {
            return String.valueOf(ChatColor.YELLOW) + MessagePath.DISCORD_SRV_NO_USER.getMessage(new Object[0]);
        }
        return String.valueOf(ChatColor.GREEN) + MessagePath.DISCORD_SRV_LINKED_USER.getMessage(user.getAsTag());
    }

    private Member getPlayerMember(OfflinePlayer player) {
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printDebug("Discord main guild does not exist.");
            return null;
        }
        String discordId = "";
        try {
            discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (discordId == null || discordId.isEmpty()) {
            ChatUtil.printDebug("Discord user link for player " + player.getName() + " does not exist.");
            return null;
        }
        Member playerMember = null;
        try {
            playerMember = mainGuild.getMemberById(discordId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (playerMember == null) {
            ChatUtil.printDebug("Discord guild membership for player " + player.getName() + " does not exist.");
            return null;
        }
        ChatUtil.printDebug("Got Discord member " + playerMember.getEffectiveName() + " from guild " + mainGuild.getName() + " for player " + player.getName());
        return playerMember;
    }

    private String formatRoleName(String baseName) {
        return this.roleSuffix.isEmpty() ? baseName : baseName + " " + this.roleSuffix;
    }

    private boolean isRoleAuto(String roleName) {
        return !this.roleSuffix.isEmpty() && roleName.contains(this.roleSuffix);
    }

    private boolean updateRole(Role role, String name, int color) {
        try {
            RoleManager manager = role.getManager();
            if (!name.isEmpty()) {
                manager = manager.setName(name);
            }
            if (color != 0) {
                manager = manager.setColor(color);
            }
            manager = manager.setMentionable(this.roleIsMentionable);
            manager = manager.setPermissions(this.rolePermissions);
            manager.reason("Konquest auto role update");
            manager.queue();
            ChatUtil.printDebug("Discord updated existing role: " + role.getName());
        }
        catch (Exception me) {
            ChatUtil.sendAdminBroadcast("Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.");
            ChatUtil.printConsoleError("Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.");
            return false;
        }
        return true;
    }

    private boolean createRole(String name, int color, Consumer<Role> callback) {
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printConsoleError("Discord main guild does not exist.");
            return false;
        }
        try {
            RoleAction addRole = mainGuild.createRole();
            if (!name.isEmpty()) {
                addRole = addRole.setName(name);
            }
            if (color != 0) {
                addRole = addRole.setColor(Integer.valueOf(color));
            }
            addRole = addRole.setMentionable(Boolean.valueOf(this.roleIsMentionable));
            addRole = addRole.setPermissions(this.rolePermissions);
            addRole.reason("Konquest auto role creation");
            if (callback == null) {
                addRole.queue();
            } else {
                addRole.queue(callback);
            }
            ChatUtil.printDebug("Discord created new role: " + name);
        }
        catch (Exception me) {
            ChatUtil.sendAdminBroadcast("Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.");
            ChatUtil.printConsoleError("Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.");
            return false;
        }
        return true;
    }

    private boolean deleteRole(Role role) {
        try {
            role.delete().reason("Konquest auto role removal").queue();
            ChatUtil.printDebug("Discord removed existing role: " + role.getName());
        }
        catch (Exception me) {
            ChatUtil.sendAdminBroadcast("Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.");
            ChatUtil.printConsoleError("Failed to modify kingdom roles in Discord. The Discord bot lacks sufficient permissions to manage roles. Change the bot's permissions, or disable the auto_roles option in Konquest core.yml.");
            return false;
        }
        return true;
    }

    public void refreshRoles() {
        if (!this.isReady()) {
            return;
        }
        boolean isAutoRoleEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_AUTO_ROLES.getPath());
        if (!isAutoRoleEnabled) {
            return;
        }
        ChatUtil.printConsoleAlert("Starting Discord Auto-Role Refresh");
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printConsoleError("Discord main guild does not exist.");
            return;
        }
        int numRolesCreated = 0;
        int numRolesUpdated = 0;
        int numRolesDeleted = 0;
        HashSet<String> activeKingdomRoleNames = new HashSet<String>();
        ArrayList<KonKingdom> allKingdoms = new ArrayList<KonKingdom>();
        allKingdoms.add(this.konquest.getKingdomManager().getBarbarians());
        allKingdoms.addAll(this.konquest.getKingdomManager().getKingdoms());
        for (KonKingdom kingdom : allKingdoms) {
            activeKingdomRoleNames.add(this.formatRoleName(kingdom.getName()));
        }
        for (KonKingdom kingdom : allKingdoms) {
            String kingdomRoleName = this.formatRoleName(kingdom.getName());
            int kingdomColor = kingdom.getWebColorFormal();
            if (kingdom.equals(this.konquest.getKingdomManager().getBarbarians())) {
                kingdomColor = this.roleDefaultColor;
            }
            HashSet<Member> kingdomMembers = new HashSet<Member>();
            for (OfflinePlayer offlinePlayer : this.konquest.getPlayerManager().getAllBukkitPlayersInKingdom(kingdom)) {
                Member playerMember = this.getPlayerMember(offlinePlayer);
                if (playerMember == null) continue;
                kingdomMembers.add(playerMember);
            }
            HashSet<Role> rolesToRemove = new HashSet<Role>();
            for (Role discordRole : mainGuild.getRoles()) {
                String discordRoleName = discordRole.getName();
                if (discordRoleName.equalsIgnoreCase(kingdomRoleName) || !this.isRoleAuto(discordRoleName) && !activeKingdomRoleNames.contains(discordRoleName)) continue;
                rolesToRemove.add(discordRole);
            }
            if (mainGuild.getRolesByName(kingdomRoleName, true).isEmpty()) {
                Consumer<Role> consumer = role -> {
                    for (Member member : kingdomMembers) {
                        DiscordUtil.removeRolesFromMember((Member)member, (Set)rolesToRemove);
                        DiscordUtil.addRoleToMember((Member)member, (Role)role);
                        ChatUtil.printDebug("Discord assigned role " + role.getName() + " to member " + member.getEffectiveName());
                    }
                };
                if (this.createRole(kingdomRoleName, kingdomColor, consumer)) {
                    ++numRolesCreated;
                    continue;
                }
                ChatUtil.printConsoleError("Discord Auto-Role refresh failed.");
                return;
            }
            Role role2 = (Role)mainGuild.getRolesByName(kingdomRoleName, true).getFirst();
            for (Member member : kingdomMembers) {
                DiscordUtil.removeRolesFromMember((Member)member, rolesToRemove);
                DiscordUtil.addRoleToMember((Member)member, (Role)role2);
                ChatUtil.printDebug("Discord assigned role " + role2.getName() + " to member " + member.getEffectiveName());
            }
            if (this.updateRole(role2, "", kingdomColor)) {
                ++numRolesUpdated;
                continue;
            }
            ChatUtil.printConsoleError("Discord Auto-Role refresh failed.");
            return;
        }
        for (Role discordRole : mainGuild.getRoles()) {
            String roleName = discordRole.getName();
            if (!this.isRoleAuto(roleName) || activeKingdomRoleNames.contains(roleName) || discordRole.isPublicRole() || discordRole.isManaged()) continue;
            if (this.deleteRole(discordRole)) {
                ++numRolesDeleted;
                continue;
            }
            ChatUtil.printConsoleError("Discord Auto-Role refresh failed.");
            return;
        }
        ChatUtil.printConsoleAlert("Discord Auto-Role refresh finished with " + numRolesCreated + " kingdom roles created, " + numRolesUpdated + " updated, " + numRolesDeleted + " deleted.");
    }

    public void addKingdomRole(String kingdomName, int color) {
        if (!this.isReady()) {
            return;
        }
        boolean isAutoRoleEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_AUTO_ROLES.getPath());
        if (!isAutoRoleEnabled) {
            return;
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printDebug("Discord main guild does not exist.");
            return;
        }
        String roleName = this.formatRoleName(kingdomName);
        if (!mainGuild.getRolesByName(roleName, true).isEmpty()) {
            ChatUtil.printDebug("Discord kingdom role already exists, could not add " + kingdomName);
            return;
        }
        this.createRole(roleName, color, role -> ChatUtil.printDebug("Discord finished creating role " + role.getName()));
    }

    public void removeKingdomRole(String kingdomName) {
        if (!this.isReady()) {
            return;
        }
        boolean isAutoRoleEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_AUTO_ROLES.getPath());
        if (!isAutoRoleEnabled) {
            return;
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printDebug("Discord main guild does not exist.");
            return;
        }
        for (Role kingdomRole : mainGuild.getRolesByName(this.formatRoleName(kingdomName), true)) {
            this.deleteRole(kingdomRole);
        }
    }

    public void changeKingdomRole(String kingdomName, String changeToName, int changeToColor) {
        if (!this.isReady()) {
            return;
        }
        boolean isAutoRoleEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_AUTO_ROLES.getPath());
        if (!isAutoRoleEnabled) {
            return;
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printDebug("Discord main guild does not exist.");
            return;
        }
        String updateName = "";
        if (changeToName != null && !changeToName.isEmpty() && !changeToName.equals(kingdomName)) {
            updateName = this.formatRoleName(changeToName);
        }
        int updateColor = 0;
        if (changeToColor != 0 && changeToColor != -1) {
            updateColor = changeToColor;
        }
        for (Role kingdomRole : mainGuild.getRolesByName(this.formatRoleName(kingdomName), true)) {
            this.updateRole(kingdomRole, updateName, updateColor);
        }
    }

    public void refreshPlayerRoles(KonOfflinePlayer player) {
        if (!this.isReady()) {
            return;
        }
        boolean isAutoRoleEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_AUTO_ROLES.getPath());
        if (!isAutoRoleEnabled) {
            return;
        }
        Member playerMember = this.getPlayerMember(player.getOfflineBukkitPlayer());
        if (playerMember == null) {
            return;
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            ChatUtil.printDebug("Discord main guild does not exist.");
            return;
        }
        String kingdomRoleName = this.formatRoleName(player.getKingdom().getName());
        HashSet<String> activeKingdomRoleNames = new HashSet<String>();
        ArrayList<KonKingdom> allKingdoms = new ArrayList<KonKingdom>();
        allKingdoms.add(this.konquest.getKingdomManager().getBarbarians());
        allKingdoms.addAll(this.konquest.getKingdomManager().getKingdoms());
        for (KonKingdom kingdom : allKingdoms) {
            activeKingdomRoleNames.add(this.formatRoleName(kingdom.getName()));
        }
        HashSet rolesToRemove = new HashSet();
        HashSet rolesToAdd = new HashSet();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> {
            for (Role discordRole : mainGuild.getRoles()) {
                String discordRoleName = discordRole.getName();
                if (discordRoleName.equalsIgnoreCase(kingdomRoleName)) {
                    rolesToAdd.add(discordRole);
                    continue;
                }
                if (!this.isRoleAuto(discordRoleName) && !activeKingdomRoleNames.contains(discordRoleName)) continue;
                rolesToRemove.add(discordRole);
            }
            if (rolesToAdd.isEmpty()) {
                ChatUtil.printDebug("Discord is missing active kingdom role " + kingdomRoleName);
            }
            DiscordUtil.modifyRolesOfMember((Member)playerMember, (Set)rolesToAdd, (Set)rolesToRemove);
            ChatUtil.printDebug("Discord refreshed role \"" + kingdomRoleName + "\" for member \"" + playerMember.getEffectiveName() + "\" linked to player \"" + player.getOfflineBukkitPlayer().getName() + "\".");
        }, 100L);
    }

    public void sendGameChatToDiscord(Player player, String message, String channel, boolean isCancelled) {
        if (!this.isEnabled) {
            return;
        }
        DiscordSRV.getPlugin().processChatMessage(player, message, channel, isCancelled);
    }

    public void sendDiscordToGameChatKingdomChannel(User guildUser, Message guildMessage, String kingdomChannel) {
        if (!this.isEnabled) {
            return;
        }
        if (kingdomChannel.equalsIgnoreCase("global") || !this.konquest.getKingdomManager().isKingdom(kingdomChannel)) {
            return;
        }
        KonKingdom kingdom = this.konquest.getKingdomManager().getKingdom(kingdomChannel);
        for (KonPlayer viewerPlayer : this.konquest.getPlayerManager().getPlayersOnline()) {
            Object messageFormat = "";
            String chatFormat = String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(ChatColor.AQUA) + MessagePath.DISCORD_SRV_DISCORD.getMessage(new Object[0]) + String.valueOf(ChatColor.WHITE) + "] ";
            String chatMessage = guildMessage.getContentDisplay();
            boolean sendMessage = false;
            if (viewerPlayer.getKingdom().equals(kingdom)) {
                chatFormat = chatFormat + Konquest.friendColor1 + kingdom.getName() + " " + guildUser.getName();
                messageFormat = String.valueOf(ChatColor.RESET) + Konquest.friendColor2 + String.valueOf(ChatColor.ITALIC);
                sendMessage = true;
            } else if (viewerPlayer.isAdminBypassActive()) {
                chatFormat = chatFormat + String.valueOf(ChatColor.GOLD) + kingdom.getName() + " " + guildUser.getName();
                messageFormat = String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.ITALIC);
                sendMessage = true;
            }
            if (!sendMessage) continue;
            viewerPlayer.getBukkitPlayer().sendMessage(chatFormat + " \u00bb " + (String)messageFormat + chatMessage);
        }
    }

    public void alertDiscordMember(OfflinePlayer player, String message) {
        User user;
        String discordId;
        boolean doAlert = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_RAID_ALERT_DIRECT.getPath(), false);
        if (this.isEnabled && doAlert && (discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId())) != null && (user = DiscordUtil.getJda().getUserById(discordId)) != null) {
            user.openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage((CharSequence)message).queue());
        }
    }

    public void alertDiscordChannel(String channel, String message) {
        boolean doAlert = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DISCORDSRV_OPTIONS_RAID_ALERT_CHANNEL.getPath(), false);
        if (!this.isEnabled || !doAlert) {
            return;
        }
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channel);
        if (textChannel == null) {
            ChatUtil.printDebug("Channel called \"" + channel + "\" could not be found in the DiscordSRV configuration");
            return;
        }
        textChannel.sendMessage((CharSequence)("@everyone " + message)).queue();
    }
}

