/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.jetbrains.annotations.Nullable;

public class DynmapHook
implements PluginHook {
    private final Konquest konquest;
    private boolean isEnabled;
    private DynmapAPI dAPI;
    private File webImagesFolder;

    public DynmapHook(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.dAPI = null;
    }

    @Override
    public String getPluginName() {
        return "Dynmap";
    }

    @Override
    public int reload() {
        this.isEnabled = false;
        Plugin dynmap = Bukkit.getPluginManager().getPlugin("dynmap");
        if (dynmap == null) {
            return 1;
        }
        if (!dynmap.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_DYNMAP.getPath(), false)) {
            return 3;
        }
        this.dAPI = (DynmapAPI)Bukkit.getServer().getPluginManager().getPlugin("dynmap");
        if (this.dAPI == null) {
            ChatUtil.printConsoleError("Failed to register Dynmap. Is it disabled?");
            return -1;
        }
        this.webImagesFolder = new File(dynmap.getDataFolder(), "web/images");
        this.isEnabled = true;
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public DynmapAPI getAPI() {
        return this.dAPI;
    }

    public File getWebImagesFolder() {
        return this.webImagesFolder;
    }
}

