/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckPermsHook
implements PluginHook {
    private final Konquest konquest;
    private boolean isEnabled;
    private LuckPerms lpAPI;

    public LuckPermsHook(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.lpAPI = null;
    }

    @Override
    public String getPluginName() {
        return "LuckPerms";
    }

    @Override
    public int reload() {
        this.isEnabled = false;
        Plugin luckPerms = Bukkit.getPluginManager().getPlugin("LuckPerms");
        if (luckPerms == null) {
            return 1;
        }
        if (!luckPerms.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_LUCKPERMS.getPath(), false)) {
            return 3;
        }
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            ChatUtil.printConsoleError("Failed to integrate LuckPerms, plugin not found or disabled");
            return -1;
        }
        this.lpAPI = (LuckPerms)provider.getProvider();
        this.isEnabled = true;
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public LuckPerms getLuckPermsAPI() {
        return this.lpAPI;
    }

    @NotNull
    public String getPrefix(Player player) {
        String prefix = "";
        if (!this.isEnabled) {
            return prefix;
        }
        User user = this.lpAPI.getUserManager().getUser(player.getUniqueId());
        QueryOptions queryOptions = this.lpAPI.getContextManager().getQueryOptions((Object)player);
        CachedMetaData metaData = user.getCachedData().getMetaData(queryOptions);
        if (metaData.getPrefix() != null) {
            prefix = metaData.getPrefix().equalsIgnoreCase("null") ? "" : metaData.getPrefix();
        }
        return prefix;
    }

    @NotNull
    public String getSuffix(Player player) {
        String suffix = "";
        if (!this.isEnabled) {
            return suffix;
        }
        User user = this.lpAPI.getUserManager().getUser(player.getUniqueId());
        QueryOptions queryOptions = this.lpAPI.getContextManager().getQueryOptions((Object)player);
        CachedMetaData metaData = user.getCachedData().getMetaData(queryOptions);
        if (metaData.getSuffix() != null) {
            suffix = metaData.getSuffix().equalsIgnoreCase("null") ? "" : metaData.getSuffix();
        }
        return suffix;
    }
}

