/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.ghostchu.quickshop.api.QuickShopAPI;
import com.ghostchu.quickshop.api.QuickShopProvider;
import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.listener.QuickShopListener;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.Nullable;

public class QuickShopHook
implements PluginHook {
    private final Konquest konquest;
    private QuickShopAPI quickShopAPI;
    private boolean isEnabled;

    public QuickShopHook(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.quickShopAPI = null;
    }

    @Override
    public String getPluginName() {
        return "QuickShop-Hikari";
    }

    @Override
    public int reload() {
        Plugin quickShop;
        this.isEnabled = false;
        if (Bukkit.getPluginManager().isPluginEnabled("QuickShop")) {
            ChatUtil.printConsoleError("Unsupported QuickShop plugin found, install QuickShop-Hikari plugin instead");
        }
        if ((quickShop = Bukkit.getPluginManager().getPlugin("QuickShop-Hikari")) == null) {
            return 1;
        }
        if (!quickShop.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_QUICKSHOP.getPath(), false)) {
            return 3;
        }
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(QuickShopProvider.class);
        if (provider == null) {
            ChatUtil.printConsoleError("Failed to integrate QuickShop-Hikari, plugin not found or disabled");
            return -1;
        }
        this.quickShopAPI = ((QuickShopProvider)provider.getProvider()).getApiInstance();
        this.isEnabled = true;
        this.konquest.getPlugin().getServer().getPluginManager().registerEvents((Listener)new QuickShopListener(this.konquest.getPlugin()), (Plugin)this.konquest.getPlugin());
        return 0;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public QuickShopAPI getAPI() {
        return this.quickShopAPI;
    }
}

