/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.github.rumsfield.konquest.utility.ChatUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.awt.Point;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardExec {
    private static StateFlag ARENA;
    private static StateFlag CLAIM;
    private static StateFlag UNCLAIM;
    private static StateFlag TRAVEL_ENTER;
    private static StateFlag TRAVEL_EXIT;
    private static boolean isAvailable;

    public static boolean load() {
        isAvailable = false;
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        String errorMessageFormat = "Konquest failed to register a custom flag with WorldGuard, %s, because another plugin has already registered it.";
        String flagNameArena = "konquest-arena";
        try {
            StateFlag flag = new StateFlag(flagNameArena, false);
            registry.register((Flag)flag);
            ARENA = flag;
        }
        catch (FlagConflictException e) {
            ChatUtil.printConsoleError(String.format(errorMessageFormat, flagNameArena));
            return false;
        }
        String flagNameClaim = "konquest-claim";
        try {
            StateFlag flag = new StateFlag(flagNameClaim, true);
            registry.register((Flag)flag);
            CLAIM = flag;
        }
        catch (FlagConflictException e) {
            ChatUtil.printConsoleError(String.format(errorMessageFormat, flagNameClaim));
            return false;
        }
        String flagNameUnclaim = "konquest-unclaim";
        try {
            StateFlag flag = new StateFlag(flagNameUnclaim, true);
            registry.register((Flag)flag);
            UNCLAIM = flag;
        }
        catch (FlagConflictException e) {
            ChatUtil.printConsoleError(String.format(errorMessageFormat, flagNameUnclaim));
            return false;
        }
        String flagNameTravelEnter = "konquest-travel-enter";
        try {
            StateFlag flag = new StateFlag(flagNameTravelEnter, true);
            registry.register((Flag)flag);
            TRAVEL_ENTER = flag;
        }
        catch (FlagConflictException e) {
            ChatUtil.printConsoleError(String.format(errorMessageFormat, flagNameTravelEnter));
            return false;
        }
        String flagNameTravelExit = "konquest-travel-exit";
        try {
            StateFlag flag = new StateFlag(flagNameTravelExit, true);
            registry.register((Flag)flag);
            TRAVEL_EXIT = flag;
        }
        catch (FlagConflictException e) {
            ChatUtil.printConsoleError(String.format(errorMessageFormat, flagNameTravelExit));
            return false;
        }
        isAvailable = true;
        return true;
    }

    static boolean isChunkClaimAllowed(World world, Point point, Player player) {
        return WorldGuardExec.isChunkFlagAllowed(CLAIM, world, point, player);
    }

    static boolean isChunkUnclaimAllowed(World world, Point point, Player player) {
        return WorldGuardExec.isChunkFlagAllowed(UNCLAIM, world, point, player);
    }

    private static boolean isChunkFlagAllowed(StateFlag flag, World world, Point point, Player player) {
        if (!isAvailable) {
            return true;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)world));
        if (regions == null) {
            return true;
        }
        int chunkBlockX = point.x << 4;
        int chunkBlockZ = point.y << 4;
        int chunkMinY = world.getMinHeight();
        int chunkMaxY = world.getMaxHeight();
        BlockVector3 pt1 = BlockVector3.at((int)chunkBlockX, (int)chunkMinY, (int)chunkBlockZ);
        BlockVector3 pt2 = BlockVector3.at((int)(chunkBlockX + 15), (int)chunkMaxY, (int)(chunkBlockZ + 15));
        ProtectedCuboidRegion chunkRegion = new ProtectedCuboidRegion("konquest_chunk_temporary", true, pt1, pt2);
        ApplicableRegionSet overlappingChunkRegions = regions.getApplicableRegions((ProtectedRegion)chunkRegion);
        return overlappingChunkRegions.testState((RegionAssociable)WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{flag});
    }

    static boolean isLocationTravelEnterAllowed(Location loc, Player player) {
        return WorldGuardExec.isLocationFlagAllowed(TRAVEL_ENTER, loc, player, true);
    }

    static boolean isLocationTravelExitAllowed(Location loc, Player player) {
        return WorldGuardExec.isLocationFlagAllowed(TRAVEL_EXIT, loc, player, true);
    }

    static boolean isLocationArenaAllowed(Location loc, Player player) {
        return WorldGuardExec.isLocationFlagAllowed(ARENA, loc, player, false);
    }

    private static boolean isLocationFlagAllowed(StateFlag flag, Location loc, Player player, boolean defaultResult) {
        if (!isAvailable) {
            return defaultResult;
        }
        assert (loc.getWorld() != null);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)loc.getWorld()));
        if (regions == null) {
            return defaultResult;
        }
        BlockVector3 pos = BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ());
        ApplicableRegionSet overlappingChunkRegions = regions.getApplicableRegions(pos);
        return overlappingChunkRegions.testState((RegionAssociable)WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{flag});
    }

    static {
        isAvailable = false;
    }
}

