/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.hook;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.hook.WorldGuardExec;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import java.awt.Point;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardHook
implements PluginHook {
    private final Konquest konquest;
    private boolean isEnabled = false;

    public WorldGuardHook(Konquest konquest) {
        this.konquest = konquest;
    }

    @Override
    public int reload() {
        this.isEnabled = false;
        Plugin worldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (worldGuard == null) {
            return 1;
        }
        if (!worldGuard.isEnabled()) {
            return 2;
        }
        if (!this.konquest.getCore().getBoolean(CorePath.INTEGRATION_WORLDGUARD.getPath(), false)) {
            return 3;
        }
        this.isEnabled = true;
        return 0;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public String getPluginName() {
        return "WorldGuard";
    }

    public boolean isChunkClaimAllowed(Location loc, Player player) {
        assert (loc.getWorld() != null);
        return this.isChunkClaimAllowed(loc.getWorld(), HelperUtil.toPoint(loc), player);
    }

    public boolean isChunkClaimAllowed(World world, Point point, Player player) {
        if (!this.isEnabled) {
            return true;
        }
        return WorldGuardExec.isChunkClaimAllowed(world, point, player);
    }

    public boolean isChunkUnclaimAllowed(Location loc, Player player) {
        assert (loc.getWorld() != null);
        return this.isChunkUnclaimAllowed(loc.getWorld(), HelperUtil.toPoint(loc), player);
    }

    public boolean isChunkUnclaimAllowed(World world, Point point, Player player) {
        if (!this.isEnabled) {
            return true;
        }
        return WorldGuardExec.isChunkUnclaimAllowed(world, point, player);
    }

    public boolean isLocationTravelEnterAllowed(Location loc, Player player) {
        if (!this.isEnabled) {
            return true;
        }
        return WorldGuardExec.isLocationTravelEnterAllowed(loc, player);
    }

    public boolean isLocationTravelExitAllowed(Location loc, Player player) {
        if (!this.isEnabled) {
            return true;
        }
        return WorldGuardExec.isLocationTravelExitAllowed(loc, player);
    }

    public boolean isLocationArenaAllowed(Location loc, Player player) {
        if (!this.isEnabled) {
            return false;
        }
        return WorldGuardExec.isLocationArenaAllowed(loc, player);
    }
}

