/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.KonquestEvent;
import com.github.rumsfield.konquest.api.event.camp.KonquestCampDestroyEvent;
import com.github.rumsfield.konquest.api.event.camp.KonquestCampDestroyPostEvent;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerCampEvent;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerConquerEvent;
import com.github.rumsfield.konquest.api.event.ruin.KonquestRuinAttackEvent;
import com.github.rumsfield.konquest.api.event.ruin.KonquestRuinCaptureEvent;
import com.github.rumsfield.konquest.api.event.ruin.KonquestRuinCapturePostEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownAttackEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownCaptureEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownCapturePostEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownDestroyEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownDestroyPostEvent;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.manager.CampManager;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.PlayerManager;
import com.github.rumsfield.konquest.manager.TerritoryManager;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.CustomCommandPath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.type.Bed;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BlockListener
implements Listener {
    private final Konquest konquest;
    private final KingdomManager kingdomManager;
    private final TerritoryManager territoryManager;
    private final CampManager campManager;
    private final PlayerManager playerManager;

    public BlockListener(KonquestPlugin plugin) {
        this.konquest = plugin.getKonquestInstance();
        this.playerManager = this.konquest.getPlayerManager();
        this.kingdomManager = this.konquest.getKingdomManager();
        this.territoryManager = this.konquest.getTerritoryManager();
        this.campManager = this.konquest.getCampManager();
    }

    private void notifyAdminBypass(Player player) {
        if (player.hasPermission("konquest.admin.bypass")) {
            ChatUtil.sendNotice((CommandSender)player, MessagePath.PROTECTION_NOTICE_IGNORE.getMessage(new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
            ChatUtil.printDebug("Failed to handle onBlockBreak for non-existent player");
            return;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
        if (player == null) {
            ChatUtil.printDebug("Failed to handle onBlockBreak for null player");
            return;
        }
        if (this.territoryManager.isChunkClaimed(event.getBlock().getLocation())) {
            if (!player.isAdminBypassActive() && !player.getBukkitPlayer().getGameMode().equals((Object)GameMode.SPECTATOR)) {
                KonSanctuary sanctuary;
                KonMonumentTemplate template;
                KonPropertyFlagHolder flagHolder;
                KonRuin ruin;
                Location breakLoc = event.getBlock().getLocation();
                KonTerritory territory = this.territoryManager.getChunkTerritory(breakLoc);
                boolean isAlwaysAllowed = false;
                if (territory instanceof KonTown) {
                    KonTown town = (KonTown)territory;
                    if (town.getMonument().isLocInside(breakLoc) && event.getBlock().getType().equals((Object)this.konquest.getKingdomManager().getTownCriticalBlock())) {
                        isAlwaysAllowed = true;
                    }
                } else if (territory instanceof KonRuin && (ruin = (KonRuin)territory).isCriticalLocation(breakLoc)) {
                    isAlwaysAllowed = true;
                }
                if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.BUILD) && !flagHolder.getPropertyValue(KonPropertyFlag.BUILD) && !isAlwaysAllowed) {
                    this.notifyAdminBypass(event.getPlayer());
                    ChatUtil.sendKonBlockedFlagTitle(player);
                    event.setCancelled(true);
                    return;
                }
                if (territory instanceof KonTown) {
                    boolean isCapital = territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL);
                    boolean isTown = territory.getTerritoryType().equals((Object)KonquestTerritoryType.TOWN);
                    KonTown town = (KonTown)territory;
                    KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), town.getKingdom());
                    if (!playerRole.equals((Object)KonquestRelationshipType.ENEMY) && town.isLocInsideMonumentProtectionArea(breakLoc)) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    if (playerRole.equals((Object)KonquestRelationshipType.FRIENDLY)) {
                        if (town.canClaimLordship(player)) {
                            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_TOWN_NOTICE_NO_LORD.getMessage(town.getName(), town.getTravelName()));
                        }
                        if (!town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isOpen() || !town.isOpen() && town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                            if (this.konquest.getPlotManager().isPlayerPlotProtectBuild(town, breakLoc, player.getBukkitPlayer())) {
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_NOT_PLOT.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isPlotOnly() && !town.isPlayerKnight(player.getOfflineBukkitPlayer()) && !town.hasPlot(breakLoc)) {
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_ONLY_PLOT.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                        }
                    } else {
                        boolean isProtectChest;
                        boolean isPlayerAlly = playerRole.equals((Object)KonquestRelationshipType.ALLY);
                        boolean isAlliedBuildingEnable = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath(), false);
                        if (!isAlliedBuildingEnable || !isPlayerAlly) {
                            if (territory.getKingdom().isPeaceful()) {
                                ChatUtil.sendNotice((CommandSender)event.getPlayer(), MessagePath.PROTECTION_NOTICE_PEACEFUL_TOWN.getMessage(town.getName()));
                                event.setCancelled(true);
                                return;
                            }
                            if (player.getKingdom().isPeaceful()) {
                                ChatUtil.sendNotice((CommandSender)event.getPlayer(), MessagePath.PROTECTION_NOTICE_PEACEFUL_PLAYER.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                            if (town.getKingdom().isOfflineProtected()) {
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_ONLINE.getMessage(town.getKingdom().getName(), town.getName()));
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isTownWatchProtected()) {
                                int upgradeLevelWatch = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.WATCH);
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_UPGRADE.getMessage(town.getName(), KonUpgrade.WATCH.getName(), upgradeLevelWatch));
                                event.setCancelled(true);
                                return;
                            }
                        }
                        if ((isProtectChest = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_CONTAINERS_BREAK.getPath(), true)) && event.getBlock().getState() instanceof BlockInventoryHolder) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            event.setCancelled(true);
                            return;
                        }
                        if (playerRole.equals((Object)KonquestRelationshipType.ENEMY)) {
                            boolean isBarbarianAttackEnabled = this.konquest.getCore().getBoolean(CorePath.BARBARIANS_ALLOW_ATTACK_KINGDOMS.getPath(), true);
                            if (player.isBarbarian() && !isBarbarianAttackEnabled) {
                                ChatUtil.sendKonBlockedProtectionTitle(player);
                                event.setCancelled(true);
                                return;
                            }
                            if (isCapital && territory.getKingdom().isCapitalImmune()) {
                                int numTowns = territory.getKingdom().getNumTowns();
                                ChatUtil.sendKonBlockedProtectionTitle(player);
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_CAPITAL_IMMUNE.getMessage(numTowns, territory.getKingdom().getName()));
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isCaptureDisabled()) {
                                ChatUtil.sendKonBlockedProtectionTitle(player);
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_CAPTURE.getMessage(town.getCaptureCooldownString()));
                                event.setCancelled(true);
                                return;
                            }
                            boolean isNoProtectedAttack = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_PROTECTED_ATTACKING.getPath(), false);
                            if (isNoProtectedAttack && player.getKingdom().isOfflineProtected()) {
                                ChatUtil.sendKonBlockedProtectionTitle(player);
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_PROTECTED_ATTACK.getMessage(town.getName()));
                                event.setCancelled(true);
                                return;
                            }
                            boolean isMonument = town.getMonument().isLocInside(breakLoc);
                            boolean isCritical = isMonument && event.getBlock().getType().equals((Object)this.konquest.getKingdomManager().getTownCriticalBlock());
                            KonquestTownAttackEvent invokeEvent = new KonquestTownAttackEvent(this.konquest, town, player, event.getBlock(), isMonument, isCritical);
                            Konquest.callKonquestEvent(invokeEvent);
                            if (invokeEvent.isCancelled()) {
                                event.setCancelled(true);
                                return;
                            }
                            town.setAttacked(true, player);
                            town.updateBarTitle();
                            town.applyGlow(event.getPlayer());
                            town.sendRaidAlert(player);
                            if (town.isShielded()) {
                                ChatUtil.sendKonBlockedShieldTitle(player);
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isArmored()) {
                                Material blockMat = event.getBlock().getState().getType();
                                if ((double)blockMat.getHardness() > 0.0 && blockMat.isSolid() && this.konquest.getKingdomManager().isArmorValid(blockMat)) {
                                    town.damageArmor(1);
                                    Konquest.playTownArmorSound(event.getPlayer());
                                } else {
                                    ChatUtil.sendKonBlockedShieldTitle(player);
                                }
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isLocInsideMonumentProtectionArea(breakLoc)) {
                                if (isMonument) {
                                    if (!town.getKingdom().getMonumentTemplate().isValid()) {
                                        ChatUtil.sendKonBlockedProtectionTitle(player);
                                        event.setCancelled(true);
                                        return;
                                    }
                                    boolean isBarbAttackAllowed = this.konquest.getCore().getBoolean(CorePath.TOWNS_BARBARIANS_DESTROY.getPath(), true);
                                    if (player.isBarbarian() && !isBarbAttackAllowed) {
                                        ChatUtil.sendKonBlockedProtectionTitle(player);
                                        event.setCancelled(true);
                                        return;
                                    }
                                    if (!town.getPropertyValue(KonPropertyFlag.CAPTURE)) {
                                        ChatUtil.sendKonBlockedFlagTitle(player);
                                        event.setCancelled(true);
                                        return;
                                    }
                                    event.setDropItems(false);
                                    if (isCritical) {
                                        this.onTownCriticalHit(town, player, isCapital);
                                    }
                                } else {
                                    ChatUtil.sendKonBlockedProtectionTitle(player);
                                    event.setCancelled(true);
                                    return;
                                }
                            }
                            this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.ATTACK_TOWN);
                        } else if (playerRole.equals((Object)KonquestRelationshipType.ALLY)) {
                            if (isAlliedBuildingEnable) {
                                if (!town.isAlliedBuildingAllowed()) {
                                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_NO_ALLIED_BUILD.getMessage(new Object[0]));
                                    ChatUtil.sendKonBlockedProtectionTitle(player);
                                    event.setCancelled(true);
                                }
                            } else {
                                ChatUtil.sendKonBlockedProtectionTitle(player);
                                event.setCancelled(true);
                            }
                        } else {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            event.setCancelled(true);
                        }
                    }
                } else if (territory instanceof KonCamp) {
                    KonCamp camp = (KonCamp)territory;
                    boolean isMemberAllowedContainers = this.konquest.getCore().getBoolean(CorePath.CAMPS_CLAN_ALLOW_CONTAINERS.getPath(), false);
                    boolean isMemberAllowedEdit = this.konquest.getCore().getBoolean(CorePath.CAMPS_CLAN_ALLOW_EDIT_OFFLINE.getPath(), false);
                    boolean isMember = false;
                    if (this.konquest.getCampManager().isCampGrouped(camp)) {
                        isMember = this.konquest.getCampManager().getCampGroup(camp).isPlayerMember((OfflinePlayer)player.getBukkitPlayer());
                    }
                    if (!(!camp.isProtected() || isMember && isMemberAllowedEdit)) {
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAMP.getMessage(camp.getName()));
                        event.setCancelled(true);
                        return;
                    }
                    boolean isProtectChest = this.konquest.getCore().getBoolean(CorePath.CAMPS_PROTECT_CONTAINERS.getPath(), true);
                    if (!(!isProtectChest || isMember && isMemberAllowedContainers || camp.isPlayerOwner((OfflinePlayer)event.getPlayer()) || !(event.getBlock().getState() instanceof BlockInventoryHolder))) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    if (isMember && !camp.isPlayerOwner((OfflinePlayer)event.getPlayer()) && event.getBlock().getBlockData() instanceof Bed) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    boolean isBarbarianAttackEnabled = this.konquest.getCore().getBoolean(CorePath.BARBARIANS_ALLOW_ATTACK_CAMPS.getPath(), true);
                    if (player.isBarbarian() && !camp.isPlayerOwner((OfflinePlayer)event.getPlayer()) && !isBarbarianAttackEnabled) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    if (!camp.isPlayerOwner((OfflinePlayer)event.getPlayer()) && !isMember) {
                        camp.applyGlow(event.getPlayer());
                    }
                    if (event.getBlock().getBlockData() instanceof Bed) {
                        KonquestCampDestroyEvent invokeEvent = new KonquestCampDestroyEvent(this.konquest, camp, player, event.getBlock().getLocation());
                        Konquest.callKonquestEvent(invokeEvent);
                        if (invokeEvent.isCancelled()) {
                            event.setCancelled(true);
                            return;
                        }
                        KonOfflinePlayer owner = this.konquest.getPlayerManager().getOfflinePlayer(camp.getOwner());
                        this.campManager.removeCamp(camp);
                        ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CAMP_DESTROY.getMessage(camp.getName()));
                        KonPlayer onlineOwner = this.playerManager.getPlayerFromName(camp.getOwner().getName());
                        if (onlineOwner != null) {
                            ChatUtil.sendError((CommandSender)onlineOwner.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CAMP_DESTROY_OWNER.getMessage(new Object[0]));
                        } else {
                            ChatUtil.printDebug("Failed attempt to send camp destruction message to offline owner " + camp.getOwner().getName());
                        }
                        Konquest.callKonquestEvent(new KonquestCampDestroyPostEvent(this.konquest, owner, player, event.getBlock().getLocation()));
                    }
                } else if (territory instanceof KonRuin) {
                    ruin = (KonRuin)territory;
                    if (ruin.isCaptureDisabled()) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAPTURE.getMessage(ruin.getCaptureCooldownString()));
                        event.setCancelled(true);
                        return;
                    }
                    if (ruin.isCriticalLocation(breakLoc)) {
                        KonquestRuinAttackEvent invokeEvent = new KonquestRuinAttackEvent(this.konquest, ruin, player, event.getBlock());
                        Konquest.callKonquestEvent(invokeEvent);
                        if (invokeEvent.isCancelled()) {
                            event.setCancelled(true);
                            return;
                        }
                        this.konquest.executeCustomCommand(CustomCommandPath.RUIN_CRITICAL, player.getBukkitPlayer());
                        List<KonPlayer> rewardPlayers = this.konquest.getRuinManager().getRuinPlayers(ruin, player.getKingdom());
                        if (ruin.getRemainingCriticalHits() == 1) {
                            KonquestRuinCaptureEvent invokeEventCapture = new KonquestRuinCaptureEvent(this.konquest, ruin, player, rewardPlayers);
                            Konquest.callKonquestEvent(invokeEventCapture);
                            if (invokeEventCapture.isCancelled()) {
                                event.setCancelled(true);
                                return;
                            }
                        }
                        event.setDropItems(false);
                        boolean hitStatus = ruin.onCriticalHit(breakLoc);
                        ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CRITICAL.getMessage(ruin.getRemainingCriticalHits()));
                        event.getBlock().getWorld().playSound(breakLoc, Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 0.6f);
                        if (hitStatus) {
                            this.konquest.getRuinManager().rewardPlayers(ruin, player.getKingdom());
                            Konquest.callKonquestEvent(new KonquestRuinCapturePostEvent(this.konquest, ruin, player, rewardPlayers));
                            this.konquest.executeCustomCommand(CustomCommandPath.RUIN_CAPTURE, player.getBukkitPlayer());
                        } else {
                            ruin.targetAllGolemsToPlayer(event.getPlayer());
                        }
                    } else {
                        this.notifyAdminBypass(event.getPlayer());
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                    }
                } else if (territory instanceof KonSanctuary && (template = (sanctuary = (KonSanctuary)territory).getTemplate(breakLoc)) != null) {
                    this.notifyAdminBypass(event.getPlayer());
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    event.setCancelled(true);
                    return;
                }
            } else {
                this.checkMonumentTemplateBlanking((BlockEvent)event);
            }
        } else {
            boolean isWildBuild = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_WILD_BUILD.getPath(), true);
            boolean isWorldValid = this.konquest.isWorldValid(event.getBlock().getLocation());
            if (!player.isAdminBypassActive() && !isWildBuild && isWorldValid) {
                this.notifyAdminBypass(event.getPlayer());
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDiamondMine(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
                return;
            }
            Material blockType = event.getBlock().getType();
            boolean isDiamondBreak = blockType.equals((Object)Material.DIAMOND_ORE);
            boolean isDeepslateDiamondBreak = false;
            try {
                isDeepslateDiamondBreak = blockType.equals((Object)Material.DEEPSLATE_DIAMOND_ORE);
            }
            catch (Exception | NoSuchFieldError throwable) {
                // empty catch block
            }
            if (isDiamondBreak || isDeepslateDiamondBreak) {
                boolean isDrop = event.isDropItems();
                ChatUtil.printDebug("Diamond ore block break dropping items: " + isDrop);
                ItemStack handItem = event.getPlayer().getInventory().getItemInMainHand();
                if (isDrop && !handItem.containsEnchantment(Enchantment.SILK_TOUCH)) {
                    if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
                        ChatUtil.printDebug("Failed to handle onBlockBreakLow for non-existent player");
                        return;
                    }
                    KonPlayer player = this.playerManager.getPlayer(event.getPlayer());
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.DIAMONDS, 1);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCropHarvest(BlockBreakEvent event) {
        Ageable crop;
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Material brokenMat = event.getBlock().getType();
        if ((brokenMat.equals((Object)Material.WHEAT) || brokenMat.equals((Object)Material.POTATOES) || brokenMat.equals((Object)Material.CARROTS) || brokenMat.equals((Object)Material.BEETROOTS)) && event.getBlock().getBlockData() instanceof Ageable && (crop = (Ageable)event.getBlock().getBlockData()).getAge() == crop.getMaximumAge()) {
            if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
                ChatUtil.printDebug("Failed to handle onCropHarvest for non-existent player");
                return;
            }
            KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.HARVEST, 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        this.konquest.lastPlaced.put(event.getPlayer(), event.getBlock().getLocation());
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
        if (player == null) {
            ChatUtil.printDebug("Failed to handle onBlockPlace for non-existent player");
            return;
        }
        Location placeLoc = event.getBlock().getLocation();
        if (this.territoryManager.isChunkClaimed(placeLoc)) {
            KonPropertyFlagHolder flagHolder;
            if (player.isAdminBypassActive()) {
                this.checkMonumentTemplateBlanking((BlockEvent)event);
                return;
            }
            KonTerritory territory = this.territoryManager.getChunkTerritory(placeLoc);
            assert (territory != null);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.BUILD) && !flagHolder.getPropertyValue(KonPropertyFlag.BUILD)) {
                this.notifyAdminBypass(event.getPlayer());
                ChatUtil.sendKonBlockedFlagTitle(player);
                event.setCancelled(true);
                return;
            }
            switch (territory.getTerritoryType()) {
                case CAPITAL: 
                case TOWN: {
                    boolean isProtectChest;
                    assert (territory instanceof KonTown);
                    KonTown town = (KonTown)territory;
                    boolean isCapital = territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL);
                    KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), town.getKingdom());
                    if (town.isLocInsideMonumentProtectionArea(placeLoc)) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    if (playerRole.equals((Object)KonquestRelationshipType.FRIENDLY)) {
                        if (town.canClaimLordship(player)) {
                            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_TOWN_NOTICE_NO_LORD.getMessage(town.getName(), town.getTravelName()));
                        }
                        if (!town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isOpen() || !town.isOpen() && town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                            if (this.konquest.getPlotManager().isPlayerPlotProtectBuild(town, placeLoc, player.getBukkitPlayer())) {
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_NOT_PLOT.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isPlotOnly() && !town.isPlayerKnight(player.getOfflineBukkitPlayer()) && !town.hasPlot(placeLoc)) {
                                ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_ONLY_PLOT.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                        }
                        this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.BUILD_TOWN);
                        return;
                    }
                    boolean isPlayerAlly = playerRole.equals((Object)KonquestRelationshipType.ALLY);
                    boolean isAlliedBuildingEnable = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath(), false);
                    if (!isAlliedBuildingEnable || !isPlayerAlly) {
                        if (territory.getKingdom().isPeaceful()) {
                            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_PEACEFUL_TOWN.getMessage(town.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (player.getKingdom().isPeaceful()) {
                            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_PEACEFUL_PLAYER.getMessage(new Object[0]));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.getKingdom().isOfflineProtected()) {
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_ONLINE.getMessage(town.getKingdom().getName(), town.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isTownWatchProtected()) {
                            int upgradeLevelWatch = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.WATCH);
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_UPGRADE.getMessage(town.getName(), KonUpgrade.WATCH.getName(), upgradeLevelWatch));
                            event.setCancelled(true);
                            return;
                        }
                    }
                    if ((isProtectChest = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_CONTAINERS_BREAK.getPath(), true)) && event.getBlock().getState() instanceof BlockInventoryHolder) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    if (playerRole.equals((Object)KonquestRelationshipType.ENEMY)) {
                        if (isCapital && territory.getKingdom().isCapitalImmune()) {
                            int numTowns = territory.getKingdom().getNumTowns();
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_CAPITAL_IMMUNE.getMessage(numTowns, territory.getKingdom().getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isCaptureDisabled()) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_CAPTURE.getMessage(town.getCaptureCooldownString()));
                            event.setCancelled(true);
                            return;
                        }
                        boolean isNoProtectedAttack = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_PROTECTED_ATTACKING.getPath(), false);
                        if (isNoProtectedAttack && player.getKingdom().isOfflineProtected()) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_PROTECTED_ATTACK.getMessage(town.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isShielded()) {
                            ChatUtil.sendKonBlockedShieldTitle(player);
                            event.setCancelled(true);
                            return;
                        }
                        if (!town.isArmored()) return;
                        Konquest.playTownArmorSound(event.getPlayer());
                        event.setCancelled(true);
                        return;
                    }
                    if (playerRole.equals((Object)KonquestRelationshipType.ALLY)) {
                        if (isAlliedBuildingEnable) {
                            if (town.isAlliedBuildingAllowed()) return;
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_NO_ALLIED_BUILD.getMessage(new Object[0]));
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            event.setCancelled(true);
                            return;
                        }
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    event.setCancelled(true);
                    return;
                }
                case CAMP: {
                    assert (territory instanceof KonCamp);
                    KonCamp camp = (KonCamp)territory;
                    boolean isMemberAllowedEdit = this.konquest.getCore().getBoolean(CorePath.CAMPS_CLAN_ALLOW_EDIT_OFFLINE.getPath(), false);
                    boolean isMember = false;
                    if (this.konquest.getCampManager().isCampGrouped(camp)) {
                        isMember = this.konquest.getCampManager().getCampGroup(camp).isPlayerMember((OfflinePlayer)player.getBukkitPlayer());
                    }
                    if (event.getBlock().getBlockData() instanceof Bed) {
                        if (camp.isPlayerOwner((OfflinePlayer)player.getBukkitPlayer())) {
                            camp.setBedLocation(event.getBlock().getLocation());
                            player.getBukkitPlayer().setBedSpawnLocation(event.getBlock().getLocation(), true);
                            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAMP_UPDATE.getMessage(new Object[0]));
                        } else {
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAMP_BED.getMessage(new Object[0]));
                            event.setCancelled(true);
                            return;
                        }
                    }
                    if (!camp.isProtected() || isMember && isMemberAllowedEdit) return;
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAMP.getMessage(camp.getName()));
                    event.setCancelled(true);
                    return;
                }
                case RUIN: {
                    this.notifyAdminBypass(event.getPlayer());
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    event.setCancelled(true);
                    return;
                }
                case SANCTUARY: {
                    assert (territory instanceof KonSanctuary);
                    KonSanctuary sanctuary = (KonSanctuary)territory;
                    KonMonumentTemplate template = sanctuary.getTemplate(placeLoc);
                    if (template == null) return;
                    this.notifyAdminBypass(event.getPlayer());
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    event.setCancelled(true);
                    return;
                }
            }
            return;
        } else {
            if (player.isAdminBypassActive()) {
                return;
            }
            if (player.isBarbarian() && event.getBlock().getBlockData() instanceof Bed && player.getBukkitPlayer().hasPermission("konquest.create.camp")) {
                KonquestPlayerCampEvent invokePreEvent = new KonquestPlayerCampEvent(this.konquest, player, event.getBlock().getLocation());
                Konquest.callKonquestEvent(invokePreEvent);
                if (invokePreEvent.isCancelled()) {
                    event.setCancelled(true);
                    return;
                }
                boolean status = this.campManager.addCampForPlayer(event.getBlock().getLocation(), player);
                if (status) return;
                event.setCancelled(true);
                return;
            } else {
                boolean isWildBuild = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_WILD_BUILD.getPath(), true);
                boolean isWorldValid = this.konquest.isWorldValid(event.getBlock().getLocation());
                if (isWildBuild || !isWorldValid) return;
                this.notifyAdminBypass(event.getPlayer());
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSeedPlant(BlockPlaceEvent event) {
        if (!event.isCancelled()) {
            if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
                return;
            }
            if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
                ChatUtil.printDebug("Failed to handle onSeedPlant for non-existent player");
                return;
            }
            Material placedMat = event.getBlockPlaced().getType();
            if (placedMat.equals((Object)Material.WHEAT) || placedMat.equals((Object)Material.POTATOES) || placedMat.equals((Object)Material.CARROTS) || placedMat.equals((Object)Material.PUMPKIN_STEM) || placedMat.equals((Object)Material.MELON_STEM) || placedMat.equals((Object)Material.COCOA_BEANS) || placedMat.equals((Object)Material.BEETROOTS) || placedMat.equals((Object)Material.SUGAR_CANE)) {
                KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.SEEDS, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFarmTill(BlockPlaceEvent event) {
        if (!event.isCancelled()) {
            if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
                return;
            }
            Material placedMat = event.getBlockPlaced().getType();
            if (placedMat.equals((Object)Material.FARMLAND)) {
                if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
                    ChatUtil.printDebug("Failed to handle onFarmTill for non-existent player");
                    return;
                }
                KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.TILL, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        for (Block block : event.blockList()) {
            boolean isProtectChest;
            if (!this.territoryManager.isChunkClaimed(block.getLocation())) continue;
            KonTerritory territory = this.territoryManager.getChunkTerritory(block.getLocation());
            Material blockMat = block.getType();
            if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY)) {
                ChatUtil.printDebug("protecting Sanctuary from block explosion");
                event.setCancelled(true);
                return;
            }
            if (territory.getKingdom().isPeaceful()) {
                ChatUtil.printDebug("protecting peaceful kingdom from block explosion");
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (town.isLocInsideMonumentProtectionArea(block.getLocation())) {
                    ChatUtil.printDebug("protecting Town Monument from block explosion");
                    event.setCancelled(true);
                    return;
                }
                if (town.getKingdom().isOfflineProtected()) {
                    ChatUtil.printDebug("protecting offline Town from block explosion");
                    event.setCancelled(true);
                    return;
                }
                if (town.isTownWatchProtected()) {
                    ChatUtil.printDebug("protecting upgraded Town from block explosion");
                    event.setCancelled(true);
                    return;
                }
                if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL) && territory.getKingdom().isCapitalImmune()) {
                    ChatUtil.printDebug("protecting immune capital from block explosion");
                    event.setCancelled(true);
                    return;
                }
                if (town.isCaptureDisabled()) {
                    ChatUtil.printDebug("protecting town in capture cooldown from block explosion");
                    event.setCancelled(true);
                    return;
                }
                if (town.isShielded()) {
                    event.setCancelled(true);
                    return;
                }
                if (town.isArmored() && (double)blockMat.getHardness() > 0.0 && blockMat.isSolid() && this.konquest.getKingdomManager().isArmorValid(blockMat)) {
                    int damage = this.konquest.getCore().getInt(CorePath.TOWNS_ARMOR_TNT_DAMAGE.getPath(), 1);
                    town.damageArmor(damage);
                    Konquest.playTownArmorSound(event.getBlock().getLocation());
                    event.setCancelled(true);
                    return;
                }
            }
            if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAMP)) {
                assert (territory instanceof KonCamp);
                KonCamp camp = (KonCamp)territory;
                if (camp.isProtected()) {
                    ChatUtil.printDebug("EVENT: protecting offline camp from block explosion");
                    event.setCancelled(true);
                    return;
                }
            }
            if ((isProtectChest = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_CONTAINERS_EXPLODE.getPath(), true)) && event.getBlock().getState() instanceof BlockInventoryHolder) {
                ChatUtil.printDebug("EVENT: protecting chest inside territory from block explosion");
                event.setCancelled(true);
                return;
            }
            if (event.getBlock().getBlockData() instanceof Bed) {
                ChatUtil.printDebug("EVENT: protecting bed inside territory from block explosion");
                event.setCancelled(true);
                return;
            }
            if (!territory.getTerritoryType().equals((Object)KonquestTerritoryType.RUIN)) continue;
            ChatUtil.printDebug("protecting Ruin from block explosion");
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Location pistonBaseLoc = event.getBlock().getLocation();
        ArrayList<Location> checkLocs = new ArrayList<Location>();
        for (Block pushBlock : event.getBlocks()) {
            Location pushTo;
            Location blockLoc = pushBlock.getLocation();
            if (!checkLocs.contains(blockLoc)) {
                checkLocs.add(blockLoc);
            }
            if (checkLocs.contains(pushTo = new Location(pushBlock.getWorld(), (double)(pushBlock.getX() + event.getDirection().getModX()), (double)(pushBlock.getY() + event.getDirection().getModY()), (double)(pushBlock.getZ() + event.getDirection().getModZ())))) continue;
            checkLocs.add(pushTo);
        }
        boolean isPistonProtect = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_PISTONS_USE.getPath(), true);
        for (Location extendLoc : checkLocs) {
            KonCamp camp;
            if (!this.territoryManager.isChunkClaimed(extendLoc)) continue;
            KonTerritory territory = this.territoryManager.getChunkTerritory(extendLoc);
            if (territory instanceof KonSanctuary) {
                KonSanctuary sanctuary = (KonSanctuary)territory;
                KonMonumentTemplate template = sanctuary.getTemplate(extendLoc);
                if (template != null) {
                    event.setCancelled(true);
                    return;
                }
                if (sanctuary.isLocInside(pistonBaseLoc)) continue;
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (town.isLocInsideMonumentProtectionArea(extendLoc)) {
                    event.setCancelled(true);
                    return;
                }
                if (isPistonProtect && town.getKingdom().isOfflineProtected()) {
                    event.setCancelled(true);
                    return;
                }
                if (!town.isShielded() && !town.isArmored() || town.isLocInside(pistonBaseLoc)) continue;
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonRuin) {
                KonRuin ruin = (KonRuin)territory;
                if (ruin.isCriticalLocation(extendLoc)) {
                    event.setCancelled(true);
                    return;
                }
                boolean isBaseInside = ruin.isLocInside(pistonBaseLoc);
                boolean isBlockInside = ruin.isLocInside(extendLoc);
                if (!isBaseInside) {
                    event.setCancelled(true);
                    return;
                }
                if (isBlockInside) continue;
                event.setCancelled(true);
                return;
            }
            if (!(territory instanceof KonCamp) || !(camp = (KonCamp)territory).isProtected()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Location pistonBaseLoc = event.getBlock().getLocation();
        ArrayList<Location> checkLocs = new ArrayList<Location>();
        for (Block pullBlock : event.getBlocks()) {
            Location pullTo;
            Location blockLoc = pullBlock.getLocation();
            if (!checkLocs.contains(blockLoc)) {
                checkLocs.add(blockLoc);
            }
            if (checkLocs.contains(pullTo = new Location(pullBlock.getWorld(), (double)(pullBlock.getX() + event.getDirection().getModX()), (double)(pullBlock.getY() + event.getDirection().getModY()), (double)(pullBlock.getZ() + event.getDirection().getModZ())))) continue;
            checkLocs.add(pullTo);
        }
        boolean isPistonProtect = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_PISTONS_USE.getPath(), true);
        for (Location retractLoc : checkLocs) {
            KonCamp camp;
            if (!this.territoryManager.isChunkClaimed(retractLoc)) continue;
            KonTerritory territory = this.territoryManager.getChunkTerritory(retractLoc);
            if (territory instanceof KonSanctuary) {
                KonSanctuary sanctuary = (KonSanctuary)territory;
                KonMonumentTemplate template = sanctuary.getTemplate(retractLoc);
                if (template != null) {
                    event.setCancelled(true);
                    return;
                }
                if (sanctuary.isLocInside(pistonBaseLoc)) continue;
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (town.isLocInsideMonumentProtectionArea(retractLoc)) {
                    event.setCancelled(true);
                    return;
                }
                if (isPistonProtect && town.getKingdom().isOfflineProtected()) {
                    event.setCancelled(true);
                    return;
                }
                if (!town.isShielded() && !town.isArmored() || town.isLocInside(pistonBaseLoc)) continue;
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonRuin) {
                KonRuin ruin = (KonRuin)territory;
                if (ruin.isCriticalLocation(retractLoc)) {
                    event.setCancelled(true);
                    return;
                }
                boolean isBaseInside = ruin.isLocInside(pistonBaseLoc);
                boolean isBlockInside = ruin.isLocInside(retractLoc);
                if (!isBaseInside) {
                    event.setCancelled(true);
                    return;
                }
                if (isBlockInside) continue;
                event.setCancelled(true);
                return;
            }
            if (!(territory instanceof KonCamp) || !(camp = (KonCamp)territory).isProtected()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFluidFlow(BlockFromToEvent event) {
        Location locFrom;
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (this.isBlockInsideMonument(event.getToBlock())) {
            event.setCancelled(true);
            return;
        }
        Location locTo = event.getToBlock().getLocation();
        if (!locTo.equals((Object)(locFrom = event.getBlock().getLocation()))) {
            boolean isTerritoryTo = this.territoryManager.isChunkClaimed(locTo);
            boolean isTerritoryFrom = this.territoryManager.isChunkClaimed(locFrom);
            if (isTerritoryTo) {
                if (isTerritoryFrom) {
                    KonTerritory territoryTo = this.territoryManager.getChunkTerritory(locTo);
                    KonTerritory territoryFrom = this.territoryManager.getChunkTerritory(locFrom);
                    if (!territoryTo.getKingdom().equals(territoryFrom.getKingdom())) {
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockForm(BlockFormEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (this.isBlockInsideMonument(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockGrow(BlockGrowEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (this.isBlockInsideMonument(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (this.isBlockInsideMonument(event.getBlock())) {
            event.setCancelled(true);
            return;
        }
        if (this.territoryManager.isChunkClaimed(event.getBlock().getLocation())) {
            KonTerritory territory = this.territoryManager.getChunkTerritory(event.getBlock().getLocation());
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.DAMAGE);
                if (event.getSource().getType().equals((Object)Material.FIRE) && upgradeLevel >= 1) {
                    ChatUtil.printDebug("EVENT: Stopped fire spread in upgraded town, DAMAGE");
                    event.getSource().setType(Material.AIR);
                    event.setCancelled(true);
                    return;
                }
                if (event.getSource().getType().equals((Object)Material.FIRE) && town.isTownWatchProtected()) {
                    ChatUtil.printDebug("EVENT: Stopped fire spread in upgraded town, WATCH");
                    event.getSource().setType(Material.AIR);
                    event.setCancelled(true);
                    return;
                }
                if (event.getSource().getType().equals((Object)Material.FIRE) && town.isShielded()) {
                    event.getSource().setType(Material.AIR);
                    event.setCancelled(true);
                    return;
                }
                if (event.getSource().getType().equals((Object)Material.FIRE) && town.isArmored()) {
                    event.getSource().setType(Material.AIR);
                    event.setCancelled(true);
                    return;
                }
            }
            if (territory instanceof KonRuin) {
                if (event.getSource().getType().equals((Object)Material.FIRE)) {
                    event.getSource().setType(Material.AIR);
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (!this.isBlockInsideMonument(event.getBlock())) {
            return;
        }
        event.setCancelled(true);
    }

    private boolean isBlockInsideMonument(Block block) {
        boolean result = false;
        if (this.territoryManager.isChunkClaimed(block.getLocation())) {
            KonTerritory territory = this.territoryManager.getChunkTerritory(block.getLocation());
            if (territory instanceof KonSanctuary && ((KonSanctuary)territory).isLocInsideTemplate(block.getLocation())) {
                result = true;
            }
            if (territory instanceof KonTown && ((KonTown)territory).isLocInsideMonumentProtectionArea(block.getLocation())) {
                result = true;
            }
        }
        return result;
    }

    private void checkMonumentTemplateBlanking(BlockEvent event) {
        KonSanctuary sanctuary;
        KonMonumentTemplate template;
        KonTerritory territory;
        Location blockLoc = event.getBlock().getLocation();
        if (this.territoryManager.isChunkClaimed(blockLoc) && (territory = this.territoryManager.getChunkTerritory(blockLoc)) instanceof KonSanctuary && (template = (sanctuary = (KonSanctuary)territory).getTemplate(blockLoc)) != null) {
            sanctuary.startTemplateBlanking(template.getName());
        }
    }

    private void onTownCriticalHit(KonTown town, KonPlayer player, boolean isCapital) {
        if (isCapital) {
            ChatUtil.printDebug("Critical strike on Monument in Capital " + town.getName());
        } else {
            ChatUtil.printDebug("Critical strike on Monument in Town " + town.getName());
        }
        int maxCriticalhits = this.konquest.getKingdomManager().getMaxCriticalHits();
        if (town.getMonument().getCriticalHits() + 1 >= maxCriticalhits) {
            KonquestEvent invokeEvent;
            if (isCapital) {
                invokeEvent = new KonquestPlayerConquerEvent(this.konquest, player, town.getKingdom());
                Konquest.callKonquestEvent(invokeEvent);
                if (((KonquestPlayerConquerEvent)invokeEvent).isCancelled()) {
                    return;
                }
            }
            if (player.isBarbarian()) {
                invokeEvent = new KonquestTownDestroyEvent(this.konquest, town, player, isCapital);
                Konquest.callKonquestEvent(invokeEvent);
                if (((KonquestTownDestroyEvent)invokeEvent).isCancelled()) {
                    return;
                }
            } else {
                invokeEvent = new KonquestTownCaptureEvent(this.konquest, town, player, player.getKingdom(), isCapital);
                Konquest.callKonquestEvent(invokeEvent);
                if (((KonquestTownCaptureEvent)invokeEvent).isCancelled()) {
                    return;
                }
            }
        }
        town.getMonument().addCriticalHit();
        town.updateBarTitle();
        if (town.getKingdom().isCapitalSwapInProgress(town)) {
            town.getKingdom().cancelCapitalSwapWarmup();
        }
        if (town.getMonument().getCriticalHits() >= maxCriticalhits) {
            if (player.isBarbarian()) {
                String townName = town.getName();
                String kingdomName = town.getKingdom().getName();
                ArrayList<KonPlayer> monumentPlayers = new ArrayList<KonPlayer>();
                ArrayList<KonPlayer> townLocPlayers = new ArrayList<KonPlayer>();
                for (KonPlayer onlinePlayer : this.playerManager.getPlayersOnline()) {
                    if (town.isLocInsideCenterChunk(onlinePlayer.getBukkitPlayer().getLocation())) {
                        monumentPlayers.add(onlinePlayer);
                    }
                    if (!town.isLocInside(onlinePlayer.getBukkitPlayer().getLocation())) continue;
                    townLocPlayers.add(onlinePlayer);
                }
                int x = town.getCenterLoc().getBlockX();
                int y = town.getCenterLoc().getBlockY();
                int z = town.getCenterLoc().getBlockZ();
                Location townCenterLoc = town.getCenterLoc();
                boolean result = false;
                if (isCapital) {
                    result = this.kingdomManager.removeKingdom(town.getKingdom().getName());
                    if (!result) {
                        ChatUtil.printDebug("Problem destroying Kingdom " + town.getKingdom().getName() + " for a barbarian raider " + player.getBukkitPlayer().getName());
                    }
                } else {
                    result = this.kingdomManager.removeTown(town.getName(), town.getKingdom().getName());
                    if (!result) {
                        ChatUtil.printDebug("Problem destroying Town " + town.getName() + " in Kingdom " + town.getKingdom().getName() + " for a barbarian raider " + player.getBukkitPlayer().getName());
                    }
                }
                if (result) {
                    if (isCapital) {
                        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_KINGDOM_RAZE.getMessage(kingdomName));
                    } else {
                        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_RAZE.getMessage(townName));
                    }
                    ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_DESTROY.getMessage(townName));
                    for (KonPlayer monPlayer : monumentPlayers) {
                        monPlayer.getBukkitPlayer().teleport(this.konquest.getSafeRandomCenteredLocation(townCenterLoc, 2));
                        monPlayer.getBukkitPlayer().playEffect(monPlayer.getBukkitPlayer().getLocation(), Effect.ANVIL_LAND, null);
                    }
                    for (KonPlayer locPlayer : townLocPlayers) {
                        locPlayer.clearAllMobAttackers();
                        this.territoryManager.updatePlayerBorderParticles(locPlayer);
                    }
                    this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CAPTURE_TOWN);
                    this.konquest.getMapHandler().postBroadcast(MessagePath.PROTECTION_NOTICE_RAZE.getMessage(townName) + " (" + x + "," + y + "," + z + ")");
                    Konquest.callKonquestEvent(new KonquestTownDestroyPostEvent(this.konquest, townName, kingdomName, player, isCapital));
                }
            } else {
                KonKingdom oldKingdom = town.getKingdom();
                String oldKingdomName = town.getKingdom().getName();
                String newKingdomName = player.getKingdom().getName();
                KonTown capturedTown = isCapital ? (KonTown)this.kingdomManager.captureCapitalForPlayer(town.getKingdom().getName(), player) : (KonTown)this.kingdomManager.captureTownForPlayer(town.getName(), town.getKingdom().getName(), player);
                if (capturedTown != null) {
                    town = null;
                    if (isCapital) {
                        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_KINGDOM_CONQUER.getMessage(oldKingdomName, newKingdomName));
                    } else {
                        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_CONQUER.getMessage(capturedTown.getName()));
                    }
                    ChatUtil.printDebug("Monument conversion in Town " + capturedTown.getName());
                    ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CAPTURE.getMessage(capturedTown.getName(), player.getKingdom().getName()));
                    capturedTown.setIsCaptureDisabled(true);
                    this.konquest.executeCustomCommand(CustomCommandPath.TOWN_MONUMENT_CAPTURE, player.getBukkitPlayer());
                    this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CAPTURE_TOWN);
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CAPTURES, 1);
                    if (isCapital) {
                        this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CONQUESTS, 1);
                    }
                    int x = capturedTown.getCenterLoc().getBlockX();
                    int y = capturedTown.getCenterLoc().getBlockY();
                    int z = capturedTown.getCenterLoc().getBlockZ();
                    this.konquest.getMapHandler().postBroadcast(MessagePath.PROTECTION_NOTICE_CONQUER.getMessage(capturedTown.getName()) + " (" + x + "," + y + "," + z + ")");
                    Konquest.callKonquestEvent(new KonquestTownCapturePostEvent(this.konquest, capturedTown, player, oldKingdom, isCapital));
                } else {
                    ChatUtil.printDebug("Problem converting Town " + town.getName() + " from Kingdom " + town.getKingdom().getName() + " to " + player.getKingdom().getName());
                    town.refreshMonument();
                    ChatUtil.printDebug("Stopping monument timer with taskID " + town.getMonumentTimer().getTaskID());
                    town.getMonumentTimer().stopTimer();
                    town.setAttacked(false, player);
                    town.setBarProgress(1.0);
                    town.updateBarTitle();
                }
            }
        } else {
            int remainingHits = maxCriticalhits - town.getMonument().getCriticalHits();
            int defendReward = this.konquest.getCore().getInt(CorePath.FAVOR_REWARDS_DEFEND_RAID.getPath());
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CRITICAL.getMessage(remainingHits));
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRITICALS, 1);
            String kingdomName = town.getKingdom().getName();
            this.konquest.executeCustomCommand(CustomCommandPath.TOWN_MONUMENT_CRITICAL, player.getBukkitPlayer());
            boolean isPerm1 = player.getBukkitPlayer().hasPermission("konquest.raid.first");
            if (town.getMonument().getCriticalHits() == 1 && isPerm1) {
                for (KonPlayer kingdomPlayer : this.playerManager.getPlayersInKingdom(kingdomName)) {
                    ChatUtil.sendKonPriorityTitle(kingdomPlayer, String.valueOf(ChatColor.DARK_RED) + MessagePath.PROTECTION_NOTICE_RAID_ALERT.getMessage(new Object[0]), String.valueOf(ChatColor.DARK_RED) + town.getName(), 60, 1, 10);
                    ChatUtil.sendNotice((CommandSender)kingdomPlayer.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_RAID_CAPTURE_1.getMessage(town.getName(), town.getTravelName(), defendReward), ChatColor.DARK_RED);
                }
                this.konquest.getIntegrationManager().getDiscordSrv().alertDiscordChannel(kingdomName, MessagePath.PROTECTION_NOTICE_RAID_DISCORD_CHANNEL.getMessage(town.getName()));
                for (OfflinePlayer allPlayer : this.playerManager.getAllBukkitPlayersInKingdom(kingdomName)) {
                    this.konquest.getIntegrationManager().getDiscordSrv().alertDiscordMember(allPlayer, MessagePath.PROTECTION_NOTICE_RAID_DISCORD_DIRECT.getMessage(town.getName(), kingdomName));
                }
            }
            boolean isPerm2 = player.getBukkitPlayer().hasPermission("konquest.raid.half");
            if (town.getMonument().getCriticalHits() == maxCriticalhits / 2 && isPerm2) {
                for (KonPlayer kingdomPlayer : this.playerManager.getPlayersInKingdom(kingdomName)) {
                    ChatUtil.sendKonPriorityTitle(kingdomPlayer, String.valueOf(ChatColor.DARK_RED) + MessagePath.PROTECTION_NOTICE_RAID_ALERT.getMessage(new Object[0]), String.valueOf(ChatColor.DARK_RED) + town.getName(), 60, 1, 10);
                    ChatUtil.sendNotice((CommandSender)kingdomPlayer.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_RAID_CAPTURE_2.getMessage(town.getName(), town.getTravelName(), defendReward), ChatColor.DARK_RED);
                }
            }
            boolean isPerm3 = player.getBukkitPlayer().hasPermission("konquest.raid.last");
            if (town.getMonument().getCriticalHits() == maxCriticalhits - 1 && isPerm3) {
                for (KonPlayer kingdomPlayer : this.playerManager.getPlayersInKingdom(kingdomName)) {
                    ChatUtil.sendKonPriorityTitle(kingdomPlayer, String.valueOf(ChatColor.DARK_RED) + MessagePath.PROTECTION_NOTICE_RAID_ALERT.getMessage(new Object[0]), String.valueOf(ChatColor.DARK_RED) + town.getName(), 60, 1, 10);
                    ChatUtil.sendNotice((CommandSender)kingdomPlayer.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_RAID_CAPTURE_3.getMessage(town.getName(), town.getTravelName(), defendReward), ChatColor.DARK_RED);
                }
            }
        }
    }
}

