/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.AccountLinkedEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.util.DiscordUtil;

public class DiscordSRVListener {
    private final Konquest konquest;

    public DiscordSRVListener(Konquest konquest) {
        this.konquest = konquest;
    }

    @Subscribe
    public void discordReadyEvent(DiscordReadyEvent event) {
        ChatUtil.printConsole("Chatting on Discord with " + DiscordUtil.getJda().getUsers().size() + " users!");
        this.konquest.getIntegrationManager().getDiscordSrv().setDiscordReady();
        this.konquest.getIntegrationManager().getDiscordSrv().refreshRoles();
    }

    @Subscribe(priority=ListenerPriority.MONITOR)
    public void onDiscordAccountLinked(AccountLinkedEvent event) {
        ChatUtil.printDebug("Discord member linked account to player " + event.getPlayer().getName());
        KonOfflinePlayer player = this.konquest.getPlayerManager().getOfflinePlayerFromID(event.getPlayer().getUniqueId());
        if (player == null) {
            ChatUtil.printDebug("Failed to find linked player from Konquest database.");
            return;
        }
        this.konquest.getIntegrationManager().getDiscordSrv().refreshPlayerRoles(player);
    }

    @Subscribe(priority=ListenerPriority.MONITOR)
    public void onDiscordMessagePostProcess(DiscordGuildMessagePostProcessEvent event) {
        String name = event.getAuthor().getName();
        String channel = event.getChannel().getName();
        String linkChannel = DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel());
        String message = event.getMessage().getContentDisplay();
        ChatUtil.printDebug("Received Discord message: Channel " + channel + "; Link " + linkChannel + "; Author " + name + "; Message " + message);
        this.konquest.getIntegrationManager().getDiscordSrv().sendDiscordToGameChatKingdomChannel(event.getAuthor(), event.getMessage(), linkChannel);
    }
}

