/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerCombatTagEvent;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.PlayerManager;
import com.github.rumsfield.konquest.manager.TerritoryManager;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.CustomCommandPath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Bed;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class EntityListener
implements Listener {
    private final KonquestPlugin konquestPlugin;
    private final Konquest konquest;
    private final KingdomManager kingdomManager;
    private final TerritoryManager territoryManager;
    private final PlayerManager playerManager;

    public EntityListener(KonquestPlugin plugin) {
        this.konquestPlugin = plugin;
        this.konquest = this.konquestPlugin.getKonquestInstance();
        this.playerManager = this.konquest.getPlayerManager();
        this.kingdomManager = this.konquest.getKingdomManager();
        this.territoryManager = this.konquest.getTerritoryManager();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onItemSpawn(ItemSpawnEvent event) {
        KonTown town;
        Location dropLoc = event.getEntity().getLocation();
        if (!this.territoryManager.isChunkClaimed(dropLoc)) {
            return;
        }
        KonTerritory territory = this.territoryManager.getChunkTerritory(dropLoc);
        if (territory instanceof KonTown && (town = (KonTown)territory).getMonument().isItemDropsDisabled() && town.getMonument().isLocInside(dropLoc)) {
            event.getEntity().remove();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityBreed(EntityBreedEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (event.getBreeder() instanceof Player) {
            Player bukkitPlayer = (Player)event.getBreeder();
            if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
                ChatUtil.printDebug("Failed to handle onEntityBreed for non-existent player");
                return;
            }
            KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.BREED, 1);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityBlockChange(EntityChangeBlockEvent event) {
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntityType().equals((Object)EntityType.ENDERMAN) && this.territoryManager.isChunkClaimed(event.getBlock().getLocation())) {
            event.setCancelled(true);
            return;
        }
    }

    private boolean isTerritoryExplosionProtected(KonTerritory territory, Entity explosion) {
        KonCamp camp;
        KonPropertyFlagHolder flagHolder;
        boolean isCreeper = explosion instanceof Creeper;
        if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY) || territory.getTerritoryType().equals((Object)KonquestTerritoryType.RUIN)) {
            return true;
        }
        if (isCreeper && territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.PVE) && !flagHolder.getPropertyValue(KonPropertyFlag.PVE)) {
            return true;
        }
        if (territory instanceof KonCamp && (camp = (KonCamp)territory).isProtected()) {
            return true;
        }
        if (territory instanceof KonTown) {
            UUID ownerId;
            Player owner;
            KonPlayer player;
            KonTown town = (KonTown)territory;
            if (explosion instanceof TNTPrimed && explosion.hasMetadata(Konquest.metaTntOwnerId) && (player = this.playerManager.getPlayer(owner = Bukkit.getPlayer((UUID)(ownerId = UUID.fromString(((MetadataValue)explosion.getMetadata(Konquest.metaTntOwnerId).get(0)).asString()))))) != null) {
                boolean isNoProtectedAttack;
                assert (owner != null);
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), town.getKingdom());
                ChatUtil.printDebug("TNT exploded with owner " + owner.getName() + " relation to " + town.getName() + " as " + String.valueOf((Object)playerRole));
                if (playerRole.equals((Object)KonquestRelationshipType.PEACEFUL) || playerRole.equals((Object)KonquestRelationshipType.TRADE) || playerRole.equals((Object)KonquestRelationshipType.ALLY)) {
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    return true;
                }
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) && (isNoProtectedAttack = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_PROTECTED_ATTACKING.getPath(), false)) && player.getKingdom().isOfflineProtected()) {
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    return true;
                }
            }
            if (town.getKingdom().isPeaceful()) {
                return true;
            }
            if (town.getKingdom().isOfflineProtected()) {
                return true;
            }
            if (town.isTownWatchProtected()) {
                return true;
            }
            int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.DAMAGE);
            if (upgradeLevel >= 2) {
                return true;
            }
            if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL) && town.getKingdom().isCapitalImmune()) {
                return true;
            }
            if (town.isCaptureDisabled()) {
                return true;
            }
            if (town.isShielded()) {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Location explosionLoc = event.getLocation();
        boolean isInTerritory = false;
        KonTerritory wholeTerritory = null;
        if (this.territoryManager.isChunkClaimed(explosionLoc)) {
            wholeTerritory = this.territoryManager.getChunkTerritory(explosionLoc);
            isInTerritory = true;
        } else {
            for (Block block : event.blockList()) {
                if (!this.territoryManager.isChunkClaimed(block.getLocation())) continue;
                wholeTerritory = this.territoryManager.getChunkTerritory(block.getLocation());
                isInTerritory = true;
                break;
            }
        }
        if (isInTerritory && wholeTerritory != null && this.isTerritoryExplosionProtected(wholeTerritory, event.getEntity())) {
            ChatUtil.printDebug("  Protected territory from explosion in " + wholeTerritory.getName());
            event.setCancelled(true);
            return;
        }
        for (Block block : event.blockList()) {
            boolean isProtectChest;
            if (!this.territoryManager.isChunkClaimed(block.getLocation())) continue;
            KonTerritory territory = this.territoryManager.getChunkTerritory(block.getLocation());
            Material blockMat = block.getType();
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (town.isLocInsideMonumentProtectionArea(block.getLocation())) {
                    ChatUtil.printDebug("protecting Town Monument from entity explosion");
                    event.setCancelled(true);
                    return;
                }
                if (town.isArmored() && (double)blockMat.getHardness() > 0.0 && blockMat.isSolid() && this.konquest.getKingdomManager().isArmorValid(blockMat)) {
                    int damage = this.konquest.getCore().getInt(CorePath.TOWNS_ARMOR_TNT_DAMAGE.getPath(), 1);
                    town.damageArmor(damage);
                    Konquest.playTownArmorSound(event.getLocation());
                    event.setCancelled(true);
                    return;
                }
            }
            if ((isProtectChest = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_CONTAINERS_EXPLODE.getPath(), true)) && block.getState() instanceof BlockInventoryHolder) {
                ChatUtil.printDebug("protecting chest inside Town from entity explosion");
                event.setCancelled(true);
                return;
            }
            if (!(block.getBlockData() instanceof Bed)) continue;
            ChatUtil.printDebug("protecting bed inside territory from entity explosion");
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMobSpawn(CreatureSpawnEvent event) {
        KonPropertyFlagHolder flagHolder;
        if (!this.territoryManager.isChunkClaimed(event.getLocation())) {
            return;
        }
        KonTerritory territory = this.territoryManager.getChunkTerritory(event.getLocation());
        if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.MOBS) && !flagHolder.getPropertyValue(KonPropertyFlag.MOBS) && (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.DROWNED) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.JOCKEY) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.BUILD_WITHER) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.LIGHTNING) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.MOUNT) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.PATROL) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.RAID) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.REINFORCEMENTS) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SLIME_SPLIT) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.VILLAGE_INVASION) || event.getEntityType().equals((Object)EntityType.PHANTOM))) {
            event.setCancelled(true);
            return;
        }
        if (territory instanceof KonRuin) {
            boolean stopOnReason;
            EntityType eType = event.getEntityType();
            CreatureSpawnEvent.SpawnReason eReason = event.getSpawnReason();
            boolean stopOnType = !eType.equals((Object)EntityType.ARMOR_STAND) && !eType.equals((Object)EntityType.IRON_GOLEM);
            boolean bl = stopOnReason = !eReason.equals((Object)CreatureSpawnEvent.SpawnReason.COMMAND) && !eReason.equals((Object)CreatureSpawnEvent.SpawnReason.CUSTOM) && !eReason.equals((Object)CreatureSpawnEvent.SpawnReason.DEFAULT) && !eReason.equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER);
            if (stopOnType && stopOnReason) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGolemCreate(CreatureSpawnEvent event) {
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM)) {
            Player closestPlayer = null;
            double closestDistance = Double.MAX_VALUE;
            for (Player player : event.getLocation().getWorld().getPlayers()) {
                ChatUtil.printDebug("Checking for nearest block placement: " + player.getName());
                Location lastPlacedBlock = (Location)this.konquest.lastPlaced.get(player);
                if (lastPlacedBlock == null) continue;
                ChatUtil.printDebug("Checking distance of last placed block");
                double distance = event.getLocation().distance(lastPlacedBlock);
                if (distance < closestDistance && distance < 10.0) {
                    closestPlayer = player;
                    closestDistance = distance;
                    ChatUtil.printDebug("Found closest block by " + closestPlayer.getName() + ", at " + closestDistance);
                    continue;
                }
                ChatUtil.printDebug("Distance is too far by " + player.getName() + ", at " + distance);
            }
            if (closestPlayer != null) {
                ChatUtil.printDebug("Iron Golem spawned by " + closestPlayer.getName());
                if (!this.konquest.getPlayerManager().isOnlinePlayer(closestPlayer)) {
                    ChatUtil.printDebug("Failed to handle onCreatureSpawn for non-existent player");
                    return;
                }
                KonPlayer player = this.konquest.getPlayerManager().getPlayer(closestPlayer);
                this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CREATE_GOLEM);
            } else {
                ChatUtil.printDebug("Iron Golem spawn could not find nearest player");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (!event.isCancelled() && event.getEntity() instanceof Player) {
            if (!this.konquest.getPlayerManager().isOnlinePlayer((Player)event.getEntity())) {
                ChatUtil.printDebug("Failed to handle onEntityPotionEffect for non-existent player");
                return;
            }
            Location eventLoc = event.getEntity().getLocation();
            if (event.getCause().equals((Object)EntityPotionEffectEvent.Cause.MILK) && this.territoryManager.isChunkClaimed(eventLoc)) {
                KonTerritory territory = this.territoryManager.getChunkTerritory(eventLoc);
                KonPlayer player = this.konquest.getPlayerManager().getPlayer((Player)event.getEntity());
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if (playerRole.equals((Object)KonquestRelationshipType.ENEMY) && this.kingdomManager.isTownNerf(event.getModifiedType())) {
                    ChatUtil.printDebug("Cancelling milk bucket removal of town nerfs for player " + player.getBukkitPlayer().getName() + " in territory " + territory.getName());
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityTarget(EntityTargetEvent event) {
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        Entity eAttacker = event.getEntity();
        Location tLoc = target.getLocation();
        Location eLoc = eAttacker.getLocation();
        if (target instanceof Player) {
            Player bukkitPlayer = (Player)target;
            if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
                ChatUtil.printDebug("Failed to handle onEntityTarget for non-existent player");
            } else {
                KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
                if (this.territoryManager.isChunkClaimed(tLoc)) {
                    KonTerritory targetTerritory = this.territoryManager.getChunkTerritory(tLoc);
                    if (eAttacker instanceof Monster && targetTerritory instanceof KonPropertyFlagHolder) {
                        Monster monsterAttacker = (Monster)eAttacker;
                        KonPropertyFlagHolder flagHolder = (KonPropertyFlagHolder)((Object)targetTerritory);
                        if (flagHolder.hasPropertyValue(KonPropertyFlag.PVE) && !flagHolder.getPropertyValue(KonPropertyFlag.PVE)) {
                            monsterAttacker.setTarget(null);
                            event.setCancelled(true);
                            return;
                        }
                    }
                }
                if (this.territoryManager.isChunkClaimed(eLoc)) {
                    KonTerritory attackerTerritory = this.territoryManager.getChunkTerritory(eLoc);
                    if (eAttacker instanceof IronGolem) {
                        IronGolem golemAttacker = (IronGolem)eAttacker;
                        if (attackerTerritory.getKingdom().equals(player.getKingdom())) {
                            golemAttacker.setPlayerCreated(true);
                            golemAttacker.setTarget(null);
                            event.setCancelled(true);
                            return;
                        }
                    }
                }
            }
        }
        if (!(target instanceof Player) && target instanceof LivingEntity && eAttacker instanceof IronGolem) {
            IronGolem golemAttacker = (IronGolem)eAttacker;
            for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
                if (!ruin.isGolem(golemAttacker)) continue;
                target.getWorld().spawnParticle(Particle.SOUL, target.getLocation(), 10);
                target.remove();
                eLoc.getWorld().playSound(eLoc, Sound.ENTITY_GHAST_DEATH, 1.0f, 0.1f);
                event.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> ruin.targetGolemToLast(golemAttacker), 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onArrowInteract(EntityInteractEvent event) {
        boolean isProtectedType;
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getLocation())) {
            return;
        }
        boolean bl = isProtectedType = event.getEntityType().equals((Object)CompatibilityUtil.getEntityType("item")) || event.getEntityType().equals((Object)EntityType.ARROW) || event.getEntityType().equals((Object)EntityType.SPECTRAL_ARROW);
        if (!isProtectedType) {
            return;
        }
        if (this.territoryManager.isChunkClaimed(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent event) {
        boolean status;
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player damagePlayer = (Player)event.getEntity();
        boolean doCancelTravelOnDamage = this.konquest.getCore().getBoolean(CorePath.TRAVEL_CANCEL_ON_DAMAGE.getPath(), false);
        if (doCancelTravelOnDamage && (status = this.konquest.getTravelManager().cancelTravel(damagePlayer))) {
            ChatUtil.sendError((CommandSender)damagePlayer, MessagePath.COMMAND_TRAVEL_ERROR_DAMAGED.getMessage(new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamage(EntityDamageEvent event) {
        KonTown town;
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        Location damageLoc = event.getEntity().getLocation();
        if (!this.territoryManager.isChunkClaimed(damageLoc)) {
            return;
        }
        KonTerritory territory = this.territoryManager.getChunkTerritory(damageLoc);
        if (territory instanceof KonTown && (town = (KonTown)territory).getMonument().isDamageDisabled() && town.getMonument().isLocInside(damageLoc)) {
            ChatUtil.printDebug("Damage is currently disabled in " + town.getName() + " monument, cancelling");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleDamage(VehicleDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getVehicle().getWorld())) {
            return;
        }
        if (!(event.getAttacker() instanceof Player)) {
            return;
        }
        Player bukkitPlayer = (Player)event.getAttacker();
        if (bukkitPlayer == null) {
            return;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (player == null) {
            return;
        }
        Location damageLoc = event.getVehicle().getLocation();
        if (!player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(damageLoc)) {
            KonPropertyFlagHolder flagHolder;
            KonTerritory territory = this.territoryManager.getChunkTerritory(damageLoc);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.BUILD) && !flagHolder.getPropertyValue(KonPropertyFlag.BUILD)) {
                ChatUtil.sendKonBlockedFlagTitle(player);
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                    event.setCancelled(true);
                    return;
                }
            } else if (territory instanceof KonRuin) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityPlace(EntityPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Player bukkitPlayer = event.getPlayer();
        if (bukkitPlayer == null) {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to handle onEntityPlace for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        Location placeLoc = event.getBlock().getLocation();
        if (!player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(placeLoc)) {
            KonPropertyFlagHolder flagHolder;
            KonTerritory territory = this.territoryManager.getChunkTerritory(placeLoc);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.BUILD) && !flagHolder.getPropertyValue(KonPropertyFlag.BUILD)) {
                ChatUtil.sendKonBlockedFlagTitle(player);
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                    event.setCancelled(true);
                    return;
                }
            } else if (territory instanceof KonRuin) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByPlayer(EntityDamageByEntityEvent event) {
        Monster monsterVictim;
        KonTerritory territory;
        Player bukkitPlayer;
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        Entity entityVictim = event.getEntity();
        EntityType eType = event.getEntity().getType();
        if (entityVictim instanceof Player) {
            return;
        }
        if (event.getDamager() instanceof Projectile) {
            Projectile projectile = (Projectile)event.getDamager();
            if (!(projectile.getShooter() instanceof Player)) {
                return;
            }
            bukkitPlayer = (Player)projectile.getShooter();
        } else if (event.getDamager() instanceof Player) {
            bukkitPlayer = (Player)event.getDamager();
        } else {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to handle onEntityDamageByPlayer for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        Location damageLoc = event.getEntity().getLocation();
        Location attackerLoc = bukkitPlayer.getLocation();
        if (!player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(attackerLoc) && (territory = this.territoryManager.getChunkTerritory(attackerLoc)) instanceof KonRuin) {
            KonRuin ruin = (KonRuin)territory;
            if (eType.equals((Object)EntityType.IRON_GOLEM)) {
                IronGolem golem = (IronGolem)event.getEntity();
                if (golem.getHealth() - event.getFinalDamage() <= 0.0) {
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.GOLEMS, 1);
                    if (ruin.isGolem(golem)) {
                        this.konquest.executeCustomCommand(CustomCommandPath.RUIN_GOLEM_KILL, player.getBukkitPlayer());
                    }
                } else {
                    ruin.targetGolemToPlayer(bukkitPlayer, golem);
                }
            }
        }
        if (!player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(damageLoc)) {
            KonPropertyFlagHolder flagHolder;
            territory = this.territoryManager.getChunkTerritory(damageLoc);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.PVE) && !flagHolder.getPropertyValue(KonPropertyFlag.PVE) && !(event.getEntity() instanceof Monster)) {
                ChatUtil.sendKonBlockedFlagTitle(player);
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                boolean isFriendlyGolemAttack;
                KonTown town = (KonTown)territory;
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if ((!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) && (eType.equals((Object)EntityType.ITEM_FRAME) || eType.equals((Object)EntityType.GLOW_ITEM_FRAME) || eType.equals((Object)EntityType.ARMOR_STAND))) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(town.getName()));
                    event.setCancelled(true);
                    return;
                }
                if (playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) && !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer()) && (event.getEntity() instanceof Animals || event.getEntity() instanceof Villager)) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(town.getName()));
                    event.setCancelled(true);
                    return;
                }
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY)) {
                    if (town.getKingdom().isPeaceful()) {
                        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.PROTECTION_NOTICE_PEACEFUL_TOWN.getMessage(town.getName()));
                        event.setCancelled(true);
                        return;
                    }
                    if (event.getEntity() instanceof Animals || event.getEntity() instanceof Villager) {
                        if (territory.getKingdom().isOfflineProtected()) {
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_ONLINE.getMessage(town.getKingdom().getName(), town.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isTownWatchProtected()) {
                            int upgradeLevelWatch = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.WATCH);
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_UPGRADE.getMessage(town.getName(), KonUpgrade.WATCH.getName(), upgradeLevelWatch));
                            event.setCancelled(true);
                            return;
                        }
                        if (!playerRole.equals((Object)KonquestRelationshipType.ENEMY)) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            event.setCancelled(true);
                            return;
                        }
                        if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL) && territory.getKingdom().isCapitalImmune()) {
                            int numTowns = territory.getKingdom().getNumTowns();
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAPITAL_IMMUNE.getMessage(numTowns, territory.getKingdom().getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isCaptureDisabled()) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_CAPTURE.getMessage(town.getCaptureCooldownString()));
                            event.setCancelled(true);
                            return;
                        }
                        boolean isNoProtectedAttack = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_PROTECTED_ATTACKING.getPath(), false);
                        if (isNoProtectedAttack && player.getKingdom().isOfflineProtected()) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_PROTECTED_ATTACK.getMessage(town.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isShielded()) {
                            ChatUtil.sendKonBlockedShieldTitle(player);
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isArmored()) {
                            Konquest.playTownArmorSound(player.getBukkitPlayer());
                            event.setCancelled(true);
                            return;
                        }
                    }
                }
                if (!(isFriendlyGolemAttack = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ATTACK_FRIENDLY_GOLEMS.getPath())) && !playerRole.equals((Object)KonquestRelationshipType.ENEMY) && eType.equals((Object)EntityType.IRON_GOLEM)) {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_GOLEM.getMessage(town.getName()));
                    event.setCancelled(true);
                    return;
                }
                if (playerRole.equals((Object)KonquestRelationshipType.ENEMY) && eType.equals((Object)EntityType.IRON_GOLEM)) {
                    IronGolem golem = (IronGolem)event.getEntity();
                    if (golem.getHealth() - event.getFinalDamage() > 0.0) {
                        KonPlayer previousTargetPlayer;
                        LivingEntity currentTarget = golem.getTarget();
                        if (currentTarget instanceof Player && (previousTargetPlayer = this.playerManager.getPlayer((Player)currentTarget)) != null) {
                            previousTargetPlayer.removeMobAttacker((Mob)golem);
                        }
                        golem.setTarget((LivingEntity)bukkitPlayer);
                        player.addMobAttacker((Mob)golem);
                    } else {
                        this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.GOLEMS, 1);
                    }
                }
            }
        }
        if (entityVictim instanceof Monster && (monsterVictim = (Monster)entityVictim).getHealth() <= event.getFinalDamage()) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.MOBS, 1);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDamageByPlayer(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        boolean isEggAttack = false;
        if (event.getEntity() instanceof Player) {
            Player attackerBukkitPlayer;
            Player victimBukkitPlayer = (Player)event.getEntity();
            if (event.getDamager() instanceof Projectile) {
                Projectile projectile = (Projectile)event.getDamager();
                if (!(projectile.getShooter() instanceof Player)) {
                    return;
                }
                attackerBukkitPlayer = (Player)projectile.getShooter();
                if (event.getDamager() instanceof Egg) {
                    isEggAttack = true;
                }
            } else if (event.getDamager() instanceof Player) {
                attackerBukkitPlayer = (Player)event.getDamager();
            } else {
                return;
            }
            if (!this.konquest.getPlayerManager().isOnlinePlayer(victimBukkitPlayer) || !this.konquest.getPlayerManager().isOnlinePlayer(attackerBukkitPlayer)) {
                ChatUtil.printDebug("Failed to handle onPlayerDamageByPlayer for non-existent player(s)");
                return;
            }
            KonPlayer victimPlayer = this.playerManager.getPlayer(victimBukkitPlayer);
            KonPlayer attackerPlayer = this.playerManager.getPlayer(attackerBukkitPlayer);
            if (victimPlayer == null || attackerPlayer == null) {
                return;
            }
            if (isEggAttack) {
                this.konquest.getAccomplishmentManager().modifyPlayerStat(attackerPlayer, KonStatsType.EGG, 1);
                return;
            }
            boolean isWildDamageEnabled = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_WILD_PVP.getPath(), true);
            boolean isWorldValid = this.konquest.isWorldValid(victimBukkitPlayer.getLocation());
            boolean isAttackInTerritory = this.territoryManager.isChunkClaimed(victimBukkitPlayer.getLocation());
            boolean isVictimInsideFriendlyTerritory = false;
            boolean isPropertyPvpProtected = false;
            boolean isPropertyArenaEnabled = false;
            if (isAttackInTerritory) {
                KonTerritory territory = this.territoryManager.getChunkTerritory(victimBukkitPlayer.getLocation());
                assert (territory != null);
                if (territory instanceof KonPropertyFlagHolder) {
                    KonPropertyFlagHolder flagHolder = (KonPropertyFlagHolder)((Object)territory);
                    if (flagHolder.hasPropertyValue(KonPropertyFlag.PVP) && !flagHolder.getPropertyValue(KonPropertyFlag.PVP)) {
                        isPropertyPvpProtected = true;
                    }
                    if (flagHolder.hasPropertyValue(KonPropertyFlag.ARENA) && flagHolder.getPropertyValue(KonPropertyFlag.ARENA)) {
                        isPropertyArenaEnabled = true;
                    }
                }
                isVictimInsideFriendlyTerritory = territory.getKingdom().equals(victimPlayer.getKingdom());
            } else if (!isWildDamageEnabled && isWorldValid) {
                event.setCancelled(true);
                return;
            }
            boolean isFlagArenaAllowed = this.konquest.getIntegrationManager().getWorldGuard().isLocationArenaAllowed(victimBukkitPlayer.getLocation(), attackerBukkitPlayer);
            boolean isEventPvpValid = this.konquest.getGlobalEventManager().isEffectValid(KonGlobalEventEffect.ALL_PVP);
            boolean isBarbarianPvpEnabled = this.konquest.getCore().getBoolean(CorePath.BARBARIANS_ALLOW_PVP.getPath(), true);
            boolean isAllDamageEnabled = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLOW_ALL_PVP.getPath(), false);
            boolean isPeaceDamageEnabled = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLOW_PEACEFUL_PVP.getPath(), false);
            boolean isPlayerEnemy = true;
            KonquestRelationshipType attackerRole = this.kingdomManager.getRelationRole(attackerPlayer.getKingdom(), victimPlayer.getKingdom());
            if (attackerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || attackerRole.equals((Object)KonquestRelationshipType.ALLY) || attackerRole.equals((Object)KonquestRelationshipType.TRADE) || attackerRole.equals((Object)KonquestRelationshipType.PEACEFUL) && (!isPeaceDamageEnabled || isVictimInsideFriendlyTerritory)) {
                isPlayerEnemy = false;
            }
            if (!(isPropertyArenaEnabled || isFlagArenaAllowed || isEventPvpValid)) {
                if (victimPlayer.getKingdom().isPeaceful()) {
                    ChatUtil.sendNotice((CommandSender)attackerBukkitPlayer, MessagePath.PROTECTION_NOTICE_PEACEFUL_VICTIM.getMessage(new Object[0]));
                    event.setCancelled(true);
                    return;
                }
                if (attackerPlayer.getKingdom().isPeaceful()) {
                    ChatUtil.sendNotice((CommandSender)attackerBukkitPlayer, MessagePath.PROTECTION_NOTICE_PEACEFUL_ATTACKER.getMessage(new Object[0]));
                    event.setCancelled(true);
                    return;
                }
                if (isPropertyPvpProtected) {
                    ChatUtil.sendKonBlockedFlagTitle(attackerPlayer);
                    event.setCancelled(true);
                    return;
                }
                if (!isBarbarianPvpEnabled && (attackerPlayer.isBarbarian() || victimPlayer.isBarbarian())) {
                    ChatUtil.sendKonBlockedProtectionTitle(attackerPlayer);
                    event.setCancelled(true);
                    return;
                }
                if (!isAllDamageEnabled && !isPlayerEnemy) {
                    ChatUtil.sendKonBlockedProtectionTitle(attackerPlayer);
                    event.setCancelled(true);
                    return;
                }
            }
            if (isPlayerEnemy) {
                if (victimBukkitPlayer.getHealth() - event.getFinalDamage() <= 0.0) {
                    this.konquest.getDirectiveManager().updateDirectiveProgress(attackerPlayer, KonDirective.KILL_ENEMY);
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(attackerPlayer, KonStatsType.KILLS, 1);
                } else {
                    int combatTagCooldownSeconds = this.konquest.getCore().getInt(CorePath.COMBAT_ENEMY_DAMAGE_COOLDOWN_SECONDS.getPath(), 0);
                    boolean combatTagEnabled = this.konquest.getCore().getBoolean(CorePath.COMBAT_PREVENT_COMMAND_ON_DAMAGE.getPath(), false);
                    if (combatTagEnabled && combatTagCooldownSeconds > 0) {
                        KonquestPlayerCombatTagEvent invokePreEvent = new KonquestPlayerCombatTagEvent(this.konquest, victimPlayer, attackerPlayer, victimBukkitPlayer.getLocation());
                        Konquest.callKonquestEvent(invokePreEvent);
                        if (!invokePreEvent.isCancelled()) {
                            if (!victimPlayer.isCombatTagged()) {
                                ChatUtil.sendKonPriorityTitle(victimPlayer, "", String.valueOf(ChatColor.GOLD) + MessagePath.PROTECTION_NOTICE_TAGGED.getMessage(new Object[0]), 20, 1, 10);
                                ChatUtil.sendNotice((CommandSender)victimBukkitPlayer, MessagePath.PROTECTION_NOTICE_TAG_MESSAGE.getMessage(new Object[0]));
                            }
                            victimPlayer.getCombatTagTimer().stopTimer();
                            victimPlayer.getCombatTagTimer().setTime(combatTagCooldownSeconds);
                            victimPlayer.getCombatTagTimer().startTimer();
                            victimPlayer.setIsCombatTagged(true);
                        }
                    }
                }
                this.konquest.getAccomplishmentManager().modifyPlayerStat(attackerPlayer, KonStatsType.DAMAGE, (int)event.getFinalDamage());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByExplosion(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getDamager() instanceof Explosive) && !(event.getDamager() instanceof Creeper)) {
            return;
        }
        if (this.territoryManager.isChunkClaimed(event.getDamager().getLocation())) {
            return;
        }
        Location entityLoc = event.getEntity().getLocation();
        if (this.territoryManager.isChunkClaimed(entityLoc)) {
            KonTerritory territory = this.territoryManager.getChunkTerritory(entityLoc);
            assert (territory != null);
            if (this.isTerritoryExplosionProtected(territory, event.getDamager())) {
                ChatUtil.printDebug("  Protected entity " + event.getEntity().getName() + " from explosion damage in " + territory.getName());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player bukkitPlayer = event.getEntity();
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (player != null) {
            player.clearAllMobAttackers();
            player.setIsCombatTagged(false);
            player.getCombatTagTimer().stopTimer();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        EntityType eType = event.getEntity().getType();
        if (eType.equals((Object)EntityType.IRON_GOLEM) && event.getEntity() instanceof IronGolem) {
            IronGolem golem = (IronGolem)event.getEntity();
            for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
                ruin.onGolemDeath(golem);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Player bukkitPlayer;
        KonPlayer player;
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        ProjectileSource source = event.getEntity().getShooter();
        if (event.getEntityType().equals((Object)CompatibilityUtil.getEntityType("potion")) && source instanceof Player && (player = this.playerManager.getPlayer(bukkitPlayer = (Player)source)) != null) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.POTIONS, 1);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPotionSplash(PotionSplashEvent event) {
        this.onPotionThrown((ProjectileHitEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        this.onPotionThrown((ProjectileHitEvent)event);
    }

    private void onPotionThrown(ProjectileHitEvent event) {
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        ProjectileSource source = event.getEntity().getShooter();
        if (!event.getEntityType().equals((Object)CompatibilityUtil.getEntityType("potion")) || !(source instanceof Player)) {
            return;
        }
        Player bukkitPlayer = (Player)source;
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (player == null || player.isAdminBypassActive() || !this.territoryManager.isChunkClaimed(event.getEntity().getLocation())) {
            return;
        }
        KonTerritory territory = this.territoryManager.getChunkTerritory(event.getEntity().getLocation());
        if (territory instanceof KonTown) {
            KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
            if (!playerRole.equals((Object)KonquestRelationshipType.ENEMY) && !playerRole.equals((Object)KonquestRelationshipType.FRIENDLY)) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
        } else if (territory instanceof KonSanctuary) {
            ChatUtil.sendKonBlockedProtectionTitle(player);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAnimalDeathItem(EntityDeathEvent event) {
        KonTerritory territory;
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        boolean cancelGolemDrops = this.konquest.getCore().getBoolean(CorePath.RUINS_NO_GOLEM_DROPS.getPath(), true);
        EntityType eType = event.getEntity().getType();
        if (event.getEntity() instanceof IronGolem && eType.equals((Object)EntityType.IRON_GOLEM) && cancelGolemDrops) {
            IronGolem deadGolem = (IronGolem)event.getEntity();
            for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
                if (!ruin.isGolem(deadGolem)) continue;
                ChatUtil.printDebug("Found dead ruin golem, blocking loot drops");
                for (ItemStack item : event.getDrops()) {
                    item.setAmount(0);
                }
            }
        }
        if (event.getEntity() instanceof Animals && this.territoryManager.isChunkClaimed(event.getEntity().getLocation()) && (territory = this.territoryManager.getChunkTerritory(event.getEntity().getLocation())) instanceof KonTown) {
            KonTown town = (KonTown)territory;
            int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.DROPS);
            if (upgradeLevel >= 1) {
                for (ItemStack item : event.getDrops()) {
                    int droppedAmount = item.getAmount();
                    item.setAmount(droppedAmount + 1);
                }
            }
        }
    }
}

