/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.earth2me.essentials.ITarget;
import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import net.ess3.api.IUser;
import net.ess3.api.events.AfkStatusChangeEvent;
import net.ess3.api.events.teleport.PreTeleportEvent;
import net.essentialsx.api.v2.events.HomeModifyEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class EssentialsXListener
implements Listener {
    private final Konquest konquest;

    public EssentialsXListener(Konquest konquest) {
        this.konquest = konquest;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHomeModify(HomeModifyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Location newHomeLoc = event.getNewLocation();
        if (newHomeLoc == null) {
            return;
        }
        IUser homeOwner = event.getHomeOwner();
        if (homeOwner == null) {
            return;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(homeOwner.getBase());
        if (player == null) {
            return;
        }
        boolean isWildHomeEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_ESSENTIALSX_OPTIONS_ENABLE_WILD_HOMES.getPath(), true);
        if (this.konquest.getTerritoryManager().isChunkClaimed(newHomeLoc)) {
            KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(newHomeLoc);
            assert (territory != null);
            if (territory instanceof KonCamp) {
                KonCamp camp = (KonCamp)territory;
                if (!camp.isPlayerOwner((OfflinePlayer)player.getBukkitPlayer())) {
                    ChatUtil.printDebug("Cancelled EssentialsX home update in camp by non-owner");
                    ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    event.setCancelled(true);
                }
            } else if (!this.konquest.getKingdomManager().isPlayerFriendly(player, territory.getKingdom())) {
                ChatUtil.printDebug("Cancelled EssentialsX home update in non-friendly territory");
                ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                event.setCancelled(true);
            }
        } else if (!isWildHomeEnabled) {
            ChatUtil.printDebug("Cancelled EssentialsX home update in the wild");
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPreTeleport(PreTeleportEvent event) {
        KonTerritory territory;
        if (event.isCancelled()) {
            return;
        }
        boolean isTeleportProtectionEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_ESSENTIALSX_OPTIONS_ENABLE_TELEPORT_PROTECTION.getPath(), true);
        if (!isTeleportProtectionEnabled) {
            return;
        }
        ITarget teleportTarget = event.getTarget();
        if (teleportTarget == null) {
            return;
        }
        Location teleportDestination = teleportTarget.getLocation();
        IUser teleportUser = event.getTeleportee();
        if (teleportUser == null) {
            return;
        }
        Location teleportOrigin = teleportUser.getBase().getLocation();
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(teleportUser.getBase());
        if (player == null) {
            return;
        }
        if (player.isAdminBypassActive()) {
            return;
        }
        boolean isCombatTagEnabled = this.konquest.getCore().getBoolean(CorePath.COMBAT_PREVENT_COMMAND_ON_DAMAGE.getPath(), true);
        if (isCombatTagEnabled && player.isCombatTagged()) {
            ChatUtil.printDebug("Cancelled EssentialsX teleport for combat tagged player");
            ChatUtil.sendError(player, MessagePath.PROTECTION_ERROR_TAG_BLOCKED.getMessage(new Object[0]));
            event.setCancelled(true);
            return;
        }
        if (this.konquest.getTerritoryManager().isChunkClaimed(teleportDestination)) {
            KonPropertyFlagHolder flagHolder;
            territory = this.konquest.getTerritoryManager().getChunkTerritory(teleportDestination);
            assert (territory != null);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.TRAVEL) && !flagHolder.getPropertyValue(KonPropertyFlag.TRAVEL)) {
                ChatUtil.printDebug("Cancelled EssentialsX teleport into territory with TRAVEL flag = false");
                ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                event.setCancelled(true);
                return;
            }
            if (this.konquest.getKingdomManager().isPlayerEnemy(player, territory.getKingdom())) {
                ChatUtil.printDebug("Cancelled EssentialsX teleport into enemy territory");
                ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                event.setCancelled(true);
                return;
            }
        }
        if (this.konquest.getTerritoryManager().isChunkClaimed(teleportOrigin)) {
            territory = this.konquest.getTerritoryManager().getChunkTerritory(teleportOrigin);
            assert (territory != null);
            if (this.konquest.getKingdomManager().isPlayerEnemy(player, territory.getKingdom())) {
                ChatUtil.printDebug("Cancelled EssentialsX teleport out of enemy territory");
                ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAfkChange(AfkStatusChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        IUser afkUser = event.getAffected();
        if (afkUser == null) {
            return;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(afkUser.getBase());
        if (player == null) {
            return;
        }
        player.setIsAfk(event.getValue());
    }
}

