/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.TerritoryManager;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;

public class HangingListener
implements Listener {
    private final Konquest konquest;
    private final KingdomManager kingdomManager;
    private final TerritoryManager territoryManager;

    public HangingListener(KonquestPlugin plugin) {
        this.konquest = plugin.getKonquestInstance();
        this.kingdomManager = this.konquest.getKingdomManager();
        this.territoryManager = this.konquest.getTerritoryManager();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Player bukkitPlayer = event.getPlayer();
        if (bukkitPlayer == null) {
            return;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
        if (player == null) {
            return;
        }
        Location placeLoc = event.getEntity().getLocation();
        if (!player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(placeLoc)) {
            KonPropertyFlagHolder flagHolder;
            KonTerritory territory = this.territoryManager.getChunkTerritory(placeLoc);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.BUILD) && !flagHolder.getPropertyValue(KonPropertyFlag.BUILD)) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (town.getMonument().isLocInside(placeLoc)) {
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    event.setCancelled(true);
                    return;
                }
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                    event.setCancelled(true);
                    return;
                }
            } else if (territory instanceof KonRuin) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHangingBreakPlayer(HangingBreakByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Player bukkitPlayer = (Player)event.getRemover();
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (player == null) {
            return;
        }
        Location brakeLoc = event.getEntity().getLocation();
        if (!player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(brakeLoc)) {
            KonPropertyFlagHolder flagHolder;
            KonTerritory territory = this.territoryManager.getChunkTerritory(brakeLoc);
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.BUILD) && !flagHolder.getPropertyValue(KonPropertyFlag.BUILD)) {
                ChatUtil.sendKonBlockedFlagTitle(player);
                event.setCancelled(true);
                return;
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (town.getMonument().isLocInside(brakeLoc)) {
                    ChatUtil.printDebug("EVENT: Hanging broke inside of monument");
                    ChatUtil.sendKonBlockedProtectionTitle(player);
                    event.setCancelled(true);
                    return;
                }
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                    event.setCancelled(true);
                    return;
                }
            } else if (territory instanceof KonRuin) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHangingBreakMonument(HangingBreakByEntityEvent event) {
        KonTown town;
        Location brakeLoc = event.getEntity().getLocation();
        if (!this.territoryManager.isChunkClaimed(brakeLoc)) {
            return;
        }
        KonTerritory territory = this.territoryManager.getChunkTerritory(brakeLoc);
        if (territory instanceof KonTown && (town = (KonTown)territory).getMonument().isItemDropsDisabled() && town.getMonument().isLocInside(brakeLoc)) {
            event.getEntity().remove();
        }
    }
}

