/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.PlayerManager;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private final Konquest konquest;
    private final KingdomManager kingdomManager;
    private final PlayerManager playerManager;

    public InventoryListener(KonquestPlugin plugin) {
        this.konquest = plugin.getKonquestInstance();
        this.kingdomManager = this.konquest.getKingdomManager();
        this.playerManager = this.konquest.getPlayerManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getInventory().getLocation())) {
            return;
        }
        Location openLoc = event.getInventory().getLocation();
        if (openLoc != null && this.konquest.getTerritoryManager().isChunkClaimed(openLoc)) {
            if (!this.konquest.getPlayerManager().isOnlinePlayer((Player)event.getPlayer())) {
                ChatUtil.printDebug("Failed to handle onInventoryOpen for non-existent player");
                return;
            }
            KonPlayer player = this.playerManager.getPlayer((Player)event.getPlayer());
            if (!player.isAdminBypassActive()) {
                KonPropertyFlagHolder flagHolder;
                boolean isContainer = event.getInventory().getHolder() instanceof BlockInventoryHolder || event.getInventory().getHolder() instanceof DoubleChest || event.getInventory().getHolder() instanceof Vehicle;
                boolean isMerchant = event.getInventory().getType().equals((Object)InventoryType.MERCHANT) && event.getInventory() instanceof MerchantInventory;
                KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(openLoc);
                if (isContainer && territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.CHEST) && !flagHolder.getPropertyValue(KonPropertyFlag.CHEST)) {
                    ChatUtil.sendKonBlockedFlagTitle(player);
                    event.setCancelled(true);
                    return;
                }
                KonquestRelationshipType territoryRole = this.kingdomManager.getRelationRole(territory.getKingdom(), player.getKingdom());
                if (territory instanceof KonTown) {
                    KonTown town = (KonTown)territory;
                    if (isMerchant) {
                        boolean isMerchantAllowed;
                        boolean bl = isMerchantAllowed = territoryRole.equals((Object)KonquestRelationshipType.FRIENDLY) || territoryRole.equals((Object)KonquestRelationshipType.TRADE) || territoryRole.equals((Object)KonquestRelationshipType.ALLY);
                        if (!isMerchantAllowed) {
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_MERCHANT.getMessage(town.getKingdom().getName()));
                            event.setCancelled(true);
                            return;
                        }
                        town.applyTradeDiscounts(player, event.getInventory());
                    } else if (isContainer) {
                        boolean isEnemyInventoryOpenDenied = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PROTECT_CONTAINERS_USE.getPath());
                        if (isEnemyInventoryOpenDenied && !territoryRole.equals((Object)KonquestRelationshipType.FRIENDLY)) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            event.setCancelled(true);
                            return;
                        }
                        if (town.canClaimLordship(player)) {
                            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_TOWN_NOTICE_NO_LORD.getMessage(town.getName(), town.getTravelName()));
                        }
                        if (!town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError((CommandSender)((Player)event.getPlayer()), MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                            event.setCancelled(true);
                            return;
                        }
                        if (town.isOpen() || !town.isOpen() && town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                            if (this.konquest.getPlotManager().isPlayerPlotProtectContainer(town, openLoc, player.getBukkitPlayer())) {
                                ChatUtil.sendError((CommandSender)((Player)event.getPlayer()), MessagePath.PROTECTION_ERROR_NOT_PLOT.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                            if (town.isPlotOnly() && !town.isPlayerKnight(player.getOfflineBukkitPlayer()) && !town.hasPlot(openLoc) && !town.getMonument().isLocInside(openLoc)) {
                                ChatUtil.sendError((CommandSender)((Player)event.getPlayer()), MessagePath.PROTECTION_ERROR_ONLY_PLOT.getMessage(new Object[0]));
                                event.setCancelled(true);
                                return;
                            }
                        }
                    }
                    if (town.getMonument().isLocInside(openLoc) && event.getInventory().getType().equals((Object)InventoryType.CHEST)) {
                        event.setCancelled(true);
                        if (!town.isPlayerLord(player.getOfflineBukkitPlayer()) && !town.isPlayerKnight(player.getOfflineBukkitPlayer())) {
                            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_ERROR_LOOT_DENIED.getMessage(new Object[0]));
                            return;
                        }
                        Inventory lootInventory = this.konquest.getLootManager().updateMonumentLoot(event.getInventory(), town, player.getBukkitPlayer());
                        if (lootInventory == null) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            return;
                        }
                        player.getBukkitPlayer().openInventory(lootInventory);
                    }
                }
                if (territory instanceof KonRuin && event.getInventory().getType().equals((Object)InventoryType.CHEST)) {
                    event.setCancelled(true);
                    Inventory lootInventory = this.konquest.getLootManager().updateRuinLoot(event.getInventory(), (KonRuin)territory, player.getBukkitPlayer());
                    if (lootInventory == null) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        return;
                    }
                    player.getBukkitPlayer().openInventory(lootInventory);
                }
                boolean isCampContainersProtected = this.konquest.getCore().getBoolean(CorePath.CAMPS_PROTECT_CONTAINERS.getPath(), true);
                if (territory instanceof KonCamp && isCampContainersProtected) {
                    KonCamp camp = (KonCamp)territory;
                    boolean isMemberAllowed = this.konquest.getCore().getBoolean(CorePath.CAMPS_CLAN_ALLOW_CONTAINERS.getPath(), false);
                    boolean isMember = false;
                    if (this.konquest.getCampManager().isCampGrouped(camp)) {
                        isMember = this.konquest.getCampManager().getCampGroup(camp).isPlayerMember((OfflinePlayer)player.getBukkitPlayer());
                    }
                    if (!(isMember && isMemberAllowed || player.getBukkitPlayer().getUniqueId().equals(camp.getOwner().getUniqueId()))) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.konquest.getDisplayManager().isNotDisplayMenu(event.getInventory())) {
            return;
        }
        this.konquest.getDisplayManager().onDisplayMenuClose(event.getInventory(), event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDisplayMenuClick(InventoryClickEvent event) {
        if (this.konquest.getDisplayManager().isNotDisplayMenu(event.getClickedInventory())) {
            return;
        }
        int slot = event.getRawSlot();
        Player bukkitPlayer = (Player)event.getWhoClicked();
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (player == null || slot >= CompatibilityUtil.getTopInventory((InventoryEvent)event).getSize()) {
            return;
        }
        event.setResult(Event.Result.DENY);
        event.setCancelled(true);
        if (event.getClick().equals((Object)ClickType.LEFT) || event.getClick().equals((Object)ClickType.RIGHT)) {
            boolean clickType = !event.getClick().equals((Object)ClickType.RIGHT);
            Bukkit.getScheduler().runTask((Plugin)this.konquest.getPlugin(), () -> this.konquest.getDisplayManager().onDisplayMenuClick(player, event.getClickedInventory(), slot, clickType));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onNetheriteCraft(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.PICKUP_ALL) && event.getClickedInventory() instanceof SmithingInventory && !this.konquest.isWorldIgnored(event.getInventory().getLocation())) {
            Material itemType = event.getCurrentItem().getType();
            int slot = event.getRawSlot();
            HumanEntity human = event.getWhoClicked();
            KonPlayer player = this.playerManager.getPlayer((Player)human);
            if (player != null && (itemType.equals((Object)Material.NETHERITE_AXE) || itemType.equals((Object)Material.NETHERITE_HOE) || itemType.equals((Object)Material.NETHERITE_SHOVEL) || itemType.equals((Object)Material.NETHERITE_PICKAXE) || itemType.equals((Object)Material.NETHERITE_SWORD) || itemType.equals((Object)Material.NETHERITE_HELMET) || itemType.equals((Object)Material.NETHERITE_CHESTPLATE) || itemType.equals((Object)Material.NETHERITE_LEGGINGS) || itemType.equals((Object)Material.NETHERITE_BOOTS)) && slot == 2) {
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 5);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLootChestClick(InventoryClickEvent event) {
        if (event.isCancelled() || event.getClickedInventory() == null) {
            return;
        }
        if (!CompatibilityUtil.getTopInventory((InventoryEvent)event).getType().equals((Object)InventoryType.CHEST)) {
            return;
        }
        Location inventoryLocation = null;
        InventoryHolder holder = CompatibilityUtil.getTopInventory((InventoryEvent)event).getHolder();
        if (holder instanceof Chest) {
            inventoryLocation = ((Chest)holder).getLocation();
        }
        if (inventoryLocation == null) {
            return;
        }
        if (this.konquest.isWorldIgnored(inventoryLocation)) {
            return;
        }
        if (event.getRawSlot() < CompatibilityUtil.getTopInventory((InventoryEvent)event).getSize() ? event.getAction().equals((Object)InventoryAction.PICKUP_ALL) || event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) : !event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            return;
        }
        if (this.isLootChestLocation(inventoryLocation)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLootChestDrag(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!CompatibilityUtil.getTopInventory((InventoryEvent)event).getType().equals((Object)InventoryType.CHEST)) {
            return;
        }
        Location inventoryLocation = null;
        InventoryHolder holder = CompatibilityUtil.getTopInventory((InventoryEvent)event).getHolder();
        if (holder instanceof Chest) {
            inventoryLocation = ((Chest)holder).getLocation();
        }
        if (inventoryLocation == null) {
            return;
        }
        if (this.konquest.isWorldIgnored(inventoryLocation)) {
            return;
        }
        boolean isInTop = false;
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot >= CompatibilityUtil.getTopInventory((InventoryEvent)event).getSize()) continue;
            isInTop = true;
            break;
        }
        if (!isInTop) {
            return;
        }
        if (this.isLootChestLocation(inventoryLocation)) {
            event.setCancelled(true);
        }
    }

    private boolean isLootChestLocation(Location loc) {
        KonTown town;
        if (!this.konquest.getTerritoryManager().isChunkClaimed(loc)) {
            return false;
        }
        KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(loc);
        return territory instanceof KonTown ? (town = (KonTown)territory).getMonument().isLocInside(loc) : territory instanceof KonRuin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCraftItem(CraftItemEvent event) {
        if (this.konquest.isWorldIgnored(event.getInventory().getLocation())) {
            return;
        }
        HumanEntity human = event.getWhoClicked();
        if (event.isCancelled() || !(human instanceof Player)) {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer((Player)human)) {
            ChatUtil.printDebug("Failed to handle onCraftItem for non-existent player");
            return;
        }
        Material recipeMaterial = event.getRecipe().getResult().getType();
        KonPlayer player = this.konquest.getPlayerManager().getPlayer((Player)human);
        if (recipeMaterial.equals((Object)Material.IRON_HELMET) || recipeMaterial.equals((Object)Material.IRON_CHESTPLATE) || recipeMaterial.equals((Object)Material.IRON_LEGGINGS) || recipeMaterial.equals((Object)Material.IRON_BOOTS)) {
            this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CRAFT_ARMOR);
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 2);
        } else if (recipeMaterial.equals((Object)Material.DIAMOND_HELMET) || recipeMaterial.equals((Object)Material.DIAMOND_CHESTPLATE) || recipeMaterial.equals((Object)Material.DIAMOND_LEGGINGS) || recipeMaterial.equals((Object)Material.DIAMOND_BOOTS)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 3);
        } else if (recipeMaterial.equals((Object)Material.GOLDEN_HELMET) || recipeMaterial.equals((Object)Material.GOLDEN_CHESTPLATE) || recipeMaterial.equals((Object)Material.GOLDEN_LEGGINGS) || recipeMaterial.equals((Object)Material.GOLDEN_BOOTS)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 1);
        } else if (recipeMaterial.equals((Object)Material.LEATHER_HELMET) || recipeMaterial.equals((Object)Material.LEATHER_CHESTPLATE) || recipeMaterial.equals((Object)Material.LEATHER_LEGGINGS) || recipeMaterial.equals((Object)Material.LEATHER_BOOTS)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 1);
        } else if (recipeMaterial.equals((Object)Material.IRON_AXE) || recipeMaterial.equals((Object)Material.IRON_HOE) || recipeMaterial.equals((Object)Material.IRON_SHOVEL) || recipeMaterial.equals((Object)Material.IRON_PICKAXE) || recipeMaterial.equals((Object)Material.IRON_SWORD)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 1);
        } else if (recipeMaterial.equals((Object)Material.DIAMOND_AXE) || recipeMaterial.equals((Object)Material.DIAMOND_HOE) || recipeMaterial.equals((Object)Material.DIAMOND_SHOVEL) || recipeMaterial.equals((Object)Material.DIAMOND_PICKAXE) || recipeMaterial.equals((Object)Material.DIAMOND_SWORD)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CRAFTED, 2);
        }
        if (recipeMaterial.isEdible()) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FOOD, event.getCurrentItem().getAmount());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFurnaceExtract(FurnaceExtractEvent event) {
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
            ChatUtil.printDebug("Failed to handle onFurnaceExtract for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(event.getPlayer());
        Material extractMat = event.getItemType();
        int stackSize = event.getItemAmount();
        if (extractMat.toString().toLowerCase().contains("ingot") || extractMat.equals((Object)Material.NETHERITE_SCRAP) || extractMat.equals((Object)Material.BRICK)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.INGOTS, stackSize);
        } else if (extractMat.isEdible()) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FOOD, stackSize);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnchantItem(EnchantItemEvent event) {
        KonTerritory territory;
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getInventory().getLocation())) {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getEnchanter())) {
            ChatUtil.printDebug("Failed to handle onEnchantItem for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(event.getEnchanter());
        this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.ENCHANT_ITEM);
        this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.ENCHANTMENTS, 1);
        Location enchantLoc = event.getEnchantBlock().getLocation();
        if (this.konquest.getTerritoryManager().isChunkClaimed(enchantLoc) && (territory = this.konquest.getTerritoryManager().getChunkTerritory(enchantLoc)) instanceof KonTown) {
            KonTown town = (KonTown)territory;
            int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.ENCHANT);
            if (upgradeLevel >= 1) {
                Map enchantsToAdd = event.getEnchantsToAdd();
                for (Enchantment enchant : enchantsToAdd.keySet()) {
                    int enchantLevel = (Integer)enchantsToAdd.get(enchant);
                    if (enchantLevel >= enchant.getMaxLevel()) continue;
                    enchantsToAdd.replace(enchant, enchantLevel + 1);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPrepareItemEnchant(PrepareItemEnchantEvent event) {
        EnchantmentOffer[] offers;
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getInventory().getLocation())) {
            return;
        }
        Location enchantLoc = event.getEnchantBlock().getLocation();
        if (!this.konquest.getTerritoryManager().isChunkClaimed(enchantLoc)) {
            return;
        }
        KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(enchantLoc);
        if (!(territory instanceof KonTown)) {
            return;
        }
        KonTown town = (KonTown)territory;
        int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.ENCHANT);
        if (upgradeLevel < 1) {
            return;
        }
        for (EnchantmentOffer offer : offers = event.getOffers()) {
            int enchantMaxLevel;
            int enchantLevel;
            if (offer == null || (enchantLevel = offer.getEnchantmentLevel()) >= (enchantMaxLevel = offer.getEnchantment().getMaxLevel())) continue;
            offer.setEnchantmentLevel(enchantLevel + 1);
        }
    }
}

