/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.territory.KonquestTerritoryMoveEvent;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.manager.CampManager;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.PlayerManager;
import com.github.rumsfield.konquest.manager.TerritoryManager;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPlot;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timer;
import java.util.ArrayList;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final Konquest konquest;
    private final PlayerManager playerManager;
    private final KingdomManager kingdomManager;
    private final TerritoryManager territoryManager;
    private final CampManager campManager;

    public PlayerListener(KonquestPlugin plugin) {
        this.konquest = plugin.getKonquestInstance();
        this.playerManager = this.konquest.getPlayerManager();
        this.kingdomManager = this.konquest.getKingdomManager();
        this.territoryManager = this.konquest.getTerritoryManager();
        this.campManager = this.konquest.getCampManager();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player bukkitPlayer = event.getPlayer();
        KonPlayer player = this.konquest.initPlayer(bukkitPlayer);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> {
            int boostPercent;
            if (player == null) {
                ChatUtil.printDebug("Failed to use player from null import on player join");
                return;
            }
            if (player.getKingdom().isSmallest() && (boostPercent = this.konquest.getCore().getInt(CorePath.KINGDOMS_SMALLEST_EXP_BOOST_PERCENT.getPath())) > 0) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_SMALL_KINGDOM.getMessage(boostPercent), ChatColor.ITALIC);
            }
            if (bukkitPlayer.hasPermission("konquest.command.admin")) {
                for (String msg : this.konquest.opStatusMessages) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, msg);
                }
                this.konquest.opStatusMessages.clear();
            }
            boolean isDiplomacyRequestsPending = !player.getKingdom().getRelationRequestKingdoms().isEmpty();
            boolean isPlayerKingdomOfficer = player.getKingdom().isOfficer(bukkitPlayer.getUniqueId());
            if (isDiplomacyRequestsPending && isPlayerKingdomOfficer) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_DIPLOMACY_PENDING.getMessage(new Object[0]), ChatColor.GOLD);
            }
            ArrayList<String> townRequestNames = new ArrayList<String>();
            ArrayList<String> townInviteNames = new ArrayList<String>();
            boolean isKingdomInvites = false;
            boolean isKingdomRequests = false;
            UUID id = player.getBukkitPlayer().getUniqueId();
            for (KonKingdom kingdom : this.kingdomManager.getKingdoms()) {
                if (kingdom.isJoinInviteValid(id)) {
                    isKingdomInvites = true;
                }
                for (KonTown town : kingdom.getTowns()) {
                    if (town.isJoinInviteValid(id)) {
                        townInviteNames.add(town.getName());
                    }
                    if (town.getJoinRequests().isEmpty() || !town.isPlayerKnight((OfflinePlayer)player.getBukkitPlayer())) continue;
                    townRequestNames.add(town.getName());
                }
                if (kingdom.getJoinRequests().isEmpty() || !kingdom.isOfficer(id)) continue;
                isKingdomRequests = true;
            }
            if (isKingdomRequests) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_REQUEST_PENDING.getMessage(new Object[0]), ChatColor.LIGHT_PURPLE);
            }
            if (!townRequestNames.isEmpty()) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_REQUEST_PENDING.getMessage(new Object[0]), ChatColor.LIGHT_PURPLE);
                ChatUtil.sendCommaMessage((CommandSender)bukkitPlayer, townRequestNames, ChatColor.LIGHT_PURPLE);
            }
            if (isKingdomInvites) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_INVITE_PENDING.getMessage(new Object[0]));
            }
            if (!townInviteNames.isEmpty()) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_INVITE_PENDING.getMessage(new Object[0]));
                ChatUtil.sendCommaMessage((CommandSender)bukkitPlayer, townInviteNames);
            }
            if (this.konquest.getKingdomManager().getIsTownPurchaseEnable() && isPlayerKingdomOfficer && this.konquest.getKingdomManager().getNumTownPurchaseOffers(player.getKingdom()) > 0) {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_OFFER_PENDING.getMessage(new Object[0]), ChatColor.GOLD);
            }
            if (this.konquest.getIntegrationManager().getDiscordSrv().isEnabled()) {
                this.konquest.getIntegrationManager().getDiscordSrv().refreshPlayerRoles(player);
                String message = this.konquest.getIntegrationManager().getDiscordSrv().getLinkMessage(bukkitPlayer);
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, message);
            }
        }, 10L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        ChatUtil.printDebug("EVENT: Player Quit");
        Player bukkitPlayer = event.getPlayer();
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (player != null) {
            player.stopTimers();
            player.clearAllMobAttackers();
            this.konquest.getDatabaseThread().getDatabase().flushPlayerData(bukkitPlayer);
            this.playerManager.removePlayer(bukkitPlayer);
        } else {
            ChatUtil.printDebug("Null Player Left!");
        }
        this.kingdomManager.updateKingdomOfflineProtection();
        this.campManager.activateCampProtection(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAsyncPlayerChatLowest(AsyncPlayerChatEvent event) {
        if (!this.konquest.getChatPriority().equals((Object)EventPriority.LOWEST)) {
            return;
        }
        this.onAsyncPlayerChat(event);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onAsyncPlayerChatLow(AsyncPlayerChatEvent event) {
        if (!this.konquest.getChatPriority().equals((Object)EventPriority.LOW)) {
            return;
        }
        this.onAsyncPlayerChat(event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onAsyncPlayerChatNormal(AsyncPlayerChatEvent event) {
        if (!this.konquest.getChatPriority().equals((Object)EventPriority.NORMAL)) {
            return;
        }
        this.onAsyncPlayerChat(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAsyncPlayerChatHigh(AsyncPlayerChatEvent event) {
        if (!this.konquest.getChatPriority().equals((Object)EventPriority.HIGH)) {
            return;
        }
        this.onAsyncPlayerChat(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPlayerChatHighest(AsyncPlayerChatEvent event) {
        if (!this.konquest.getChatPriority().equals((Object)EventPriority.HIGHEST)) {
            return;
        }
        this.onAsyncPlayerChat(event);
    }

    private void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        if (!event.isAsynchronous() || event.isCancelled()) {
            return;
        }
        boolean enable = this.konquest.getCore().getBoolean(CorePath.CHAT_ENABLE_FORMAT.getPath(), true);
        if (!enable) {
            return;
        }
        Player bukkitPlayer = event.getPlayer();
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to handle onAsyncPlayerChat for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        assert (player != null);
        KonKingdom kingdom = player.getKingdom();
        boolean isTitleAlwaysShown = this.konquest.getCore().getBoolean(CorePath.CHAT_ALWAYS_SHOW_TITLE.getPath(), false);
        String title = "";
        if (isTitleAlwaysShown || player.getPlayerPrefix().isEnabled()) {
            title = ChatUtil.parseHex(player.getPlayerPrefix().getMainPrefixName());
        }
        String prefix = ChatUtil.parseHex(this.konquest.getIntegrationManager().getLuckPerms().getPrefix(bukkitPlayer));
        String suffix = ChatUtil.parseHex(this.konquest.getIntegrationManager().getLuckPerms().getSuffix(bukkitPlayer));
        String kingdomName = kingdom.getName();
        String kingdomRank = kingdom.getPlayerRankName(bukkitPlayer.getUniqueId());
        String playerName = bukkitPlayer.getName();
        Object primaryColor = String.valueOf(ChatColor.GOLD);
        Object secondaryColor = String.valueOf(ChatColor.GOLD);
        String kingdomWebColor = kingdom.getWebColorString();
        String divider = Konquest.getChatDivider();
        String rawFormat = Konquest.getChatMessage();
        String chatMessage = event.getMessage();
        String chatChannel = "global";
        if (!player.isGlobalChat()) {
            chatChannel = player.getKingdom().getName();
        }
        this.konquest.getIntegrationManager().getDiscordSrv().sendGameChatToDiscord(event.getPlayer(), event.getMessage(), chatChannel, event.isCancelled());
        event.setCancelled(true);
        boolean isGlobal = player.isGlobalChat();
        for (KonPlayer viewerPlayer : this.playerManager.getPlayersOnline()) {
            primaryColor = this.konquest.getDisplayPrimaryColor((KonquestOfflinePlayer)viewerPlayer, player);
            secondaryColor = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)viewerPlayer, player);
            Object kingdomChatFormat = "";
            boolean sendMessage = false;
            if (isGlobal) {
                sendMessage = true;
            } else if (viewerPlayer.getKingdom().equals(kingdom)) {
                kingdomChatFormat = String.valueOf(ChatColor.GRAY) + "[" + Konquest.friendColor1 + MessagePath.LABEL_KINGDOM.getMessage(new Object[0]) + String.valueOf(ChatColor.GRAY) + "]";
                kingdomChatFormat = (String)kingdomChatFormat + " " + Konquest.friendColor1 + playerName + String.valueOf(ChatColor.GRAY) + " \u00bb ";
                kingdomChatFormat = (String)kingdomChatFormat + Konquest.friendColor2 + String.valueOf(ChatColor.ITALIC);
                sendMessage = true;
            } else if (viewerPlayer.isAdminBypassActive()) {
                kingdomChatFormat = String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_BYPASS.getMessage(new Object[0]) + " " + kingdomName + String.valueOf(ChatColor.GRAY) + "]";
                kingdomChatFormat = (String)kingdomChatFormat + " " + String.valueOf(ChatColor.GOLD) + playerName + String.valueOf(ChatColor.GRAY) + " \u00bb ";
                kingdomChatFormat = (String)kingdomChatFormat + String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.ITALIC);
                sendMessage = true;
            }
            if (!sendMessage) continue;
            String parsedFormat = ChatUtil.parseFormat(rawFormat, prefix, suffix, kingdomName, kingdomRank, title, playerName, (String)primaryColor, (String)secondaryColor, kingdomWebColor);
            try {
                parsedFormat = PlaceholderAPI.setPlaceholders((Player)bukkitPlayer, (String)parsedFormat);
                parsedFormat = PlaceholderAPI.setRelationalPlaceholders((Player)viewerPlayer.getBukkitPlayer(), (Player)bukkitPlayer, (String)parsedFormat);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (isGlobal) {
                if (bukkitPlayer.hasPermission("konquest.chatcolor")) {
                    chatMessage = ChatUtil.parseHex(chatMessage);
                }
                viewerPlayer.getBukkitPlayer().sendMessage(parsedFormat + divider + chatMessage);
                continue;
            }
            viewerPlayer.getBukkitPlayer().sendMessage((String)kingdomChatFormat + chatMessage);
        }
        if (player.isGlobalChat()) {
            ChatUtil.printConsole(String.valueOf(ChatColor.GOLD) + playerName + ": " + String.valueOf(ChatColor.DARK_GRAY) + event.getMessage());
        } else {
            ChatUtil.printConsole(String.valueOf(ChatColor.GOLD) + "[" + kingdomName + "] " + playerName + ": " + String.valueOf(ChatColor.DARK_GRAY) + event.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        KonPlayer player = this.playerManager.getPlayer(event.getPlayer());
        if (player == null || !player.isCombatTagged()) {
            return;
        }
        for (String cmd : this.playerManager.getBlockedCommands()) {
            if (!event.getMessage().toLowerCase().startsWith("/" + cmd.toLowerCase())) continue;
            ChatUtil.sendError((CommandSender)event.getPlayer(), MessagePath.PROTECTION_ERROR_TAG_BLOCKED.getMessage(new Object[0]));
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerSetRegion(PlayerInteractEvent event) {
        if (event.getHand() != null && !event.getHand().equals((Object)EquipmentSlot.HAND)) {
            return;
        }
        if (event.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        Player bukkitPlayer = event.getPlayer();
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to handle onPlayerSetRegion for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        assert (player != null);
        if (!player.isSettingRegion()) {
            return;
        }
        if (player.isRegionBlank()) {
            return;
        }
        ChatUtil.printDebug(bukkitPlayer.getName() + " setting region with action " + String.valueOf(event.getAction()) + ", equipment " + String.valueOf(event.getHand()) + ", state is " + String.valueOf((Object)player.getRegionType()));
        if (event.getClickedBlock() == null) {
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_CLICKED_AIR.getMessage(new Object[0]));
            player.setRegionCornerOneBuffer(null);
            player.setRegionCornerTwoBuffer(null);
            player.settingRegion(KonPlayer.RegionType.NONE);
            event.setCancelled(true);
            return;
        }
        Location location = event.getClickedBlock().getLocation();
        String ruinName = "";
        switch (player.getRegionType()) {
            case MONUMENT: {
                if (player.getRegionCornerOneBuffer() == null) {
                    KonTerritory territory = this.territoryManager.getChunkTerritory(location);
                    if (territory != null && territory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY)) {
                        String sanctuaryName = territory.getName();
                        player.setRegionSanctuaryName(sanctuaryName);
                        player.setRegionCornerOneBuffer(location);
                        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_CREATE_2.getMessage(new Object[0]), ChatColor.LIGHT_PURPLE);
                        break;
                    }
                    String templateName = player.getRegionTemplateName();
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_REGION.getMessage(templateName));
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_SANCTUARY.getMessage(new Object[0]));
                    player.setRegionCornerOneBuffer(null);
                    player.setRegionCornerTwoBuffer(null);
                    player.settingRegion(KonPlayer.RegionType.NONE);
                    ChatUtil.printDebug("Ended setting monument region, no sanctuary");
                    break;
                }
                if (player.getRegionCornerTwoBuffer() == null) {
                    player.setRegionCornerTwoBuffer(location);
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_CREATE_3.getMessage(new Object[0]), ChatColor.LIGHT_PURPLE);
                    break;
                }
                KonSanctuary sanctuary = this.konquest.getSanctuaryManager().getSanctuary(player.getRegionSanctuaryName());
                String templateName = player.getRegionTemplateName();
                double templateCost = player.getRegionTemplateCost();
                Location templateCorner1 = player.getRegionCornerOneBuffer();
                Location templateCorner2 = player.getRegionCornerTwoBuffer();
                int createMonumentStatus = this.konquest.getSanctuaryManager().createMonumentTemplate(sanctuary, templateName, templateCorner1, templateCorner2, location, templateCost);
                switch (createMonumentStatus) {
                    case 0: {
                        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_TEMPLATE_READY.getMessage(templateName));
                        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_NOTICE_SUCCESS.getMessage(templateName));
                        this.kingdomManager.reloadMonumentsForTemplate(this.konquest.getSanctuaryManager().getTemplate(templateName));
                        break;
                    }
                    case 1: {
                        int diffX = (int)Math.abs(templateCorner1.getX() - templateCorner2.getX()) + 1;
                        int diffZ = (int)Math.abs(templateCorner1.getZ() - templateCorner2.getZ()) + 1;
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_BASE.getMessage(templateName, diffX, diffZ));
                        break;
                    }
                    case 2: {
                        String criticalBlockTypeName = this.konquest.getCore().getString(CorePath.MONUMENTS_CRITICAL_BLOCK.getPath());
                        int maxCriticalhits = this.konquest.getCore().getInt(CorePath.MONUMENTS_DESTROY_AMOUNT.getPath());
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_CRITICAL.getMessage(templateName, maxCriticalhits, criticalBlockTypeName));
                        break;
                    }
                    case 3: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_TRAVEL.getMessage(templateName));
                        break;
                    }
                    case 4: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_REGION.getMessage(templateName));
                        break;
                    }
                    case 5: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(templateName));
                        break;
                    }
                    case 10: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_RESET.getMessage(templateName));
                        break;
                    }
                    default: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(createMonumentStatus));
                    }
                }
                player.setRegionCornerOneBuffer(null);
                player.setRegionCornerTwoBuffer(null);
                player.setRegionTemplateCost(0.0);
                player.settingRegion(KonPlayer.RegionType.NONE);
                ChatUtil.printDebug("Finished setting monument region");
                break;
            }
            case RUIN_CRITICAL: {
                KonTerritory territory;
                boolean validCriticalBlock = false;
                if (this.territoryManager.isChunkClaimed(location) && (territory = this.territoryManager.getChunkTerritory(location)) instanceof KonRuin) {
                    Material criticalType = this.konquest.getRuinManager().getRuinCriticalBlock();
                    if (event.getClickedBlock().getType().equals((Object)criticalType)) {
                        ((KonRuin)territory).addCriticalLocation(location);
                        ruinName = territory.getName();
                        validCriticalBlock = true;
                    } else {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_RUIN_ERROR_MATCH.getMessage(criticalType.toString()));
                    }
                }
                if (validCriticalBlock) {
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_ADD.getMessage(ruinName));
                } else {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_RUIN_ERROR_INVALID.getMessage(new Object[0]));
                }
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_CLICK_AIR.getMessage(new Object[0]));
                break;
            }
            case RUIN_SPAWN: {
                KonTerritory territory;
                boolean validSpawnBlock = false;
                if (this.territoryManager.isChunkClaimed(location) && (territory = this.territoryManager.getChunkTerritory(location)) instanceof KonRuin) {
                    ((KonRuin)territory).addSpawnLocation(location);
                    ruinName = territory.getName();
                    validSpawnBlock = true;
                }
                if (validSpawnBlock) {
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_RUIN_NOTICE_ADD.getMessage(ruinName));
                } else {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_RUIN_ERROR_INVALID.getMessage(new Object[0]));
                }
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_CLICK_AIR.getMessage(new Object[0]));
                break;
            }
        }
        player.setRegionBlank();
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerUse(PlayerInteractEvent event) {
        Player bukkitPlayer = event.getPlayer();
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to handle onPlayerInteract for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (!player.isAdminBypassActive() && event.hasBlock() && !event.useInteractedBlock().equals((Object)Event.Result.DENY)) {
            BlockState clickedState = event.getClickedBlock().getState();
            if (this.territoryManager.isChunkClaimed(clickedState.getLocation())) {
                KonRuin ruin;
                KonPropertyFlagHolder flagHolder;
                KonTerritory territory = this.territoryManager.getChunkTerritory(clickedState.getLocation());
                if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.USE) && !flagHolder.getPropertyValue(KonPropertyFlag.USE) && !(clickedState instanceof Sign)) {
                    this.preventUse(event, player);
                }
                if (territory instanceof KonRuin && (ruin = (KonRuin)territory).isCriticalLocation(event.getClickedBlock().getLocation())) {
                    ruin.targetAllGolemsToPlayer(bukkitPlayer);
                }
                if (territory instanceof KonTown) {
                    Material clickedMat;
                    boolean isAlliedBuilder;
                    KonTown town = (KonTown)territory;
                    KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                    boolean isFriendly = playerRole.equals((Object)KonquestRelationshipType.FRIENDLY);
                    boolean isClosedNonResident = !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer());
                    boolean bl = isAlliedBuilder = playerRole.equals((Object)KonquestRelationshipType.ALLY) && town.isAlliedBuildingAllowed() && this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath(), false);
                    if (isFriendly && isClosedNonResident) {
                        if (!town.isFriendlyRedstoneAllowed() && this.preventUse(event, player)) {
                            event.setCancelled(true);
                            return;
                        }
                        if (this.preventPhysical(event, player)) {
                            event.setCancelled(true);
                            return;
                        }
                    }
                    if (!isFriendly && !isAlliedBuilder) {
                        if (!town.isEnemyRedstoneAllowed() && this.preventUse(event, player)) {
                            event.setCancelled(true);
                            return;
                        }
                        if (this.preventPhysical(event, player)) {
                            event.setCancelled(true);
                            return;
                        }
                    }
                    if ((!isFriendly || isClosedNonResident) && !isAlliedBuilder && (clickedMat = event.getClickedBlock().getType()).equals((Object)Material.ITEM_FRAME)) {
                        ChatUtil.sendKonBlockedProtectionTitle(player);
                        event.setCancelled(true);
                        return;
                    }
                }
            } else {
                boolean isWildUse = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_WILD_USE.getPath(), true);
                boolean isWorldValid = this.konquest.isWorldValid(clickedState.getLocation());
                if (!isWildUse && isWorldValid) {
                    if (this.preventUse(event, player)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (this.preventPhysical(event, player)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
        if (event.hasItem() && !event.useItemInHand().equals((Object)Event.Result.DENY) && event.getItem().getType().isRecord() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.hasBlock() && event.getClickedBlock().getType().equals((Object)Material.JUKEBOX) && !this.konquest.isWorldIgnored(event.getClickedBlock().getLocation()) && player.isRecordPlayCooldownOver()) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.MUSIC, 1);
            player.markRecordPlayCooldown();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerEnterVehicle(VehicleEnterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity passenger = event.getEntered();
        if (passenger instanceof Player) {
            Player bukkitPlayer = (Player)passenger;
            boolean status = this.onPlayerEnterLeaveChunk(event.getVehicle().getLocation(), bukkitPlayer.getLocation(), bukkitPlayer, false);
            if (!status) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getPlayer().getLocation())) {
            return;
        }
        Entity clickedEntity = event.getRightClicked();
        Player bukkitPlayer = event.getPlayer();
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (player != null && !player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(clickedEntity.getLocation())) {
            boolean isEntityAlwaysAllowed;
            AnimalTamer owner;
            Tameable tamedEntity;
            KonTerritory territory = this.territoryManager.getChunkTerritory(clickedEntity.getLocation());
            boolean isTamedByPlayer = false;
            if (clickedEntity instanceof Tameable && (tamedEntity = (Tameable)clickedEntity).isTamed() && (owner = tamedEntity.getOwner()) != null && owner.getUniqueId().equals(bukkitPlayer.getUniqueId())) {
                isTamedByPlayer = true;
            }
            boolean bl = isEntityAlwaysAllowed = clickedEntity instanceof Player || clickedEntity instanceof Villager || clickedEntity instanceof Boat || clickedEntity instanceof Minecart;
            if (!isEntityAlwaysAllowed && !isTamedByPlayer) {
                KonPropertyFlagHolder flagHolder;
                if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.USE) && !flagHolder.getPropertyValue(KonPropertyFlag.USE)) {
                    ChatUtil.sendKonBlockedFlagTitle(player);
                    event.setCancelled(true);
                    return;
                }
                if (territory instanceof KonTown) {
                    boolean isClosedNotResident;
                    KonTown town = (KonTown)territory;
                    KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                    boolean isNotFriendly = !playerRole.equals((Object)KonquestRelationshipType.FRIENDLY);
                    boolean bl2 = isClosedNotResident = !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer());
                    if (isNotFriendly || isClosedNotResident) {
                        boolean isAlliedBuilder;
                        boolean isAlliedBuildingEnable = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath(), false);
                        boolean bl3 = isAlliedBuilder = isAlliedBuildingEnable && town.isAlliedBuildingAllowed() && playerRole.equals((Object)KonquestRelationshipType.ALLY);
                        if (!isAlliedBuilder) {
                            ChatUtil.sendKonBlockedProtectionTitle(player);
                            event.setCancelled(true);
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getPlayer().getLocation())) {
            return;
        }
        Player bukkitPlayer = event.getPlayer();
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (player != null && !player.isAdminBypassActive() && this.territoryManager.isChunkClaimed(event.getRightClicked().getLocation())) {
            KonPropertyFlagHolder flagHolder;
            KonTerritory territory = this.territoryManager.getChunkTerritory(event.getRightClicked().getLocation());
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.USE) && !flagHolder.getPropertyValue(KonPropertyFlag.USE)) {
                ChatUtil.sendKonBlockedFlagTitle(player);
                event.setCancelled(true);
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), territory.getKingdom());
                if (!playerRole.equals((Object)KonquestRelationshipType.FRIENDLY) || !town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_NOT_RESIDENT.getMessage(territory.getName()));
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerFish(PlayerFishEvent event) {
        if (!event.isCancelled()) {
            Entity caughtEntity;
            if (this.konquest.isWorldIgnored(event.getPlayer().getLocation())) {
                return;
            }
            KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
            if (player != null && event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH) && (caughtEntity = event.getCaught()) instanceof Item) {
                Item caughtItem = (Item)caughtEntity;
                Material caughtType = caughtItem.getItemStack().getType();
                if (caughtType.equals((Object)Material.COD) || caughtType.equals((Object)Material.SALMON) || caughtType.equals((Object)Material.TROPICAL_FISH) || caughtType.equals((Object)Material.PUFFERFISH)) {
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FISH, 1);
                } else if (caughtType.equals((Object)Material.BOW) || caughtType.equals((Object)Material.ENCHANTED_BOOK) || caughtType.equals((Object)Material.FISHING_ROD) || caughtType.equals((Object)Material.NAME_TAG) || caughtType.equals((Object)Material.NAUTILUS_SHELL) || caughtType.equals((Object)Material.SADDLE)) {
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FISH, 5);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (!event.isCancelled()) {
            if (this.konquest.isWorldIgnored(event.getPlayer().getLocation())) {
                return;
            }
            KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
            if (player != null && event.getItem().getType().equals((Object)Material.POTION)) {
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.POTIONS, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        this.onBucketUse((PlayerBucketEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        this.onBucketUse((PlayerBucketEvent)event);
    }

    private void onBucketUse(PlayerBucketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
            ChatUtil.printDebug("Failed to handle onBucketUse for non-existent player");
            return;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(event.getPlayer());
        assert (player != null);
        if (player.isAdminBypassActive()) {
            return;
        }
        boolean cancelUse = false;
        if (this.territoryManager.isChunkClaimed(event.getBlock().getLocation())) {
            KonPropertyFlagHolder flagHolder;
            KonTerritory territory = this.territoryManager.getChunkTerritory(event.getBlock().getLocation());
            if (territory instanceof KonSanctuary && ((KonSanctuary)territory).isLocInsideTemplate(event.getBlock().getLocation())) {
                cancelUse = true;
            } else if (territory instanceof KonTown && ((KonTown)territory).isLocInsideMonumentProtectionArea(event.getBlock().getLocation())) {
                cancelUse = true;
            } else if (territory instanceof KonTown && !player.getKingdom().equals(territory.getKingdom())) {
                cancelUse = true;
            } else if (territory instanceof KonRuin) {
                cancelUse = true;
            } else if (territory instanceof KonCamp && !((KonCamp)territory).isPlayerOwner((OfflinePlayer)event.getPlayer())) {
                cancelUse = true;
            }
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.USE) && !flagHolder.getPropertyValue(KonPropertyFlag.USE)) {
                cancelUse = true;
            }
        } else {
            boolean isWildUse = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_WILD_USE.getPath(), true);
            boolean isWorldValid = this.konquest.isWorldValid(event.getBlock().getLocation());
            if (!isWildUse && isWorldValid) {
                cancelUse = true;
            }
        }
        if (cancelUse) {
            ChatUtil.sendKonBlockedProtectionTitle(player);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawnCapital(PlayerRespawnEvent event) {
        if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
            ChatUtil.printDebug("Failed to handle onPlayerRespawnCapital for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(event.getPlayer());
        if (player == null) {
            return;
        }
        boolean isCapitalRespawn = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_CAPITAL_RESPAWN.getPath(), true);
        if (!event.isBedSpawn() && !player.isBarbarian() && isCapitalRespawn) {
            event.setRespawnLocation(player.getKingdom().getCapital().getSpawnLoc());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawnFinal(PlayerRespawnEvent event) {
        if (!this.konquest.getPlayerManager().isOnlinePlayer(event.getPlayer())) {
            ChatUtil.printDebug("Failed to handle onPlayerRespawnFinal for non-existent player");
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(event.getPlayer());
        if (player == null) {
            return;
        }
        Location deathLoc = event.getPlayer().getLocation();
        Location respawnLoc = event.getRespawnLocation();
        boolean isTerritoryTo = this.territoryManager.isChunkClaimed(respawnLoc);
        boolean isTerritoryFrom = this.territoryManager.isChunkClaimed(deathLoc);
        KonTerritory territoryTo = null;
        KonTerritory territoryFrom = null;
        if (isTerritoryFrom) {
            territoryFrom = this.territoryManager.getChunkTerritory(deathLoc);
            this.onExitTerritory(territoryFrom, player);
        }
        if (isTerritoryTo) {
            territoryTo = this.territoryManager.getChunkTerritory(respawnLoc);
            this.onEnterTerritory(territoryTo, respawnLoc, deathLoc, player);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        int eventBoostMultiplier;
        double totalBoostMultiplier;
        if (this.konquest.isWorldIgnored(event.getPlayer().getLocation())) {
            return;
        }
        Player bukkitPlayer = event.getPlayer();
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        int boostPercent = this.konquest.getCore().getInt(CorePath.KINGDOMS_SMALLEST_EXP_BOOST_PERCENT.getPath());
        double smallestBoostMultiplier = 1.0;
        if (boostPercent > 0 && player != null && player.getKingdom().isSmallest()) {
            smallestBoostMultiplier = 1.0 + (double)boostPercent / 100.0;
        }
        if ((totalBoostMultiplier = smallestBoostMultiplier * (double)(eventBoostMultiplier = this.konquest.getGlobalEventManager().getExpMultiplier())) > 1.0) {
            int baseAmount = event.getAmount();
            int boostedAmount = (int)((double)baseAmount * totalBoostMultiplier);
            event.setAmount(boostedAmount);
            ChatUtil.printDebug("Applied Exp boost from " + baseAmount + " to " + boostedAmount + " (" + totalBoostMultiplier + "x) to player " + event.getPlayer().getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Location portalToLoc = event.getTo();
        if (portalToLoc != null) {
            ChatUtil.printDebug("EVENT: Player portal to world " + portalToLoc.getWorld().getName() + " because " + String.valueOf(event.getCause()) + ", location: " + String.valueOf(portalToLoc));
            Player bukkitPlayer = event.getPlayer();
            if (this.konquest.isWorldValid(portalToLoc.getWorld()) && this.territoryManager.isChunkClaimed(portalToLoc)) {
                KonPropertyFlagHolder flagHolder;
                KonTerritory territory = this.territoryManager.getChunkTerritory(portalToLoc);
                if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.USE) && !flagHolder.getPropertyValue(KonPropertyFlag.USE)) {
                    ChatUtil.printDebug("EVENT: Portal creation stopped inside of territory " + territory.getName());
                    event.setCanCreatePortal(false);
                    event.setCancelled(true);
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_PORTAL_EXIT.getMessage(new Object[0]));
                    return;
                }
                boolean cancelPortal = false;
                if (territory instanceof KonSanctuary && ((KonSanctuary)territory).isLocInsideTemplate(event.getTo())) {
                    cancelPortal = true;
                } else if (territory instanceof KonTown && ((KonTown)territory).isLocInsideMonumentProtectionArea(event.getTo())) {
                    cancelPortal = true;
                }
                if (cancelPortal) {
                    ChatUtil.printDebug("EVENT: Portal creation stopped inside of town monument " + territory.getName());
                    event.setCanCreatePortal(false);
                    event.setCancelled(true);
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_PORTAL_EXIT.getMessage(new Object[0]));
                    return;
                }
            }
            boolean forceEntryExit = event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.COMMAND) || event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.PLUGIN) || event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.SPECTATE) || event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.UNKNOWN);
            boolean status = this.onPlayerEnterLeaveChunk(event.getTo(), event.getFrom(), event.getPlayer(), forceEntryExit);
            if (!status) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        boolean status = this.onPlayerEnterLeaveChunk(event.getTo(), event.getFrom(), event.getPlayer(), false);
        if (status) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        boolean isEnemyPearlBlocked = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_ENEMY_ENDER_PEARL.getPath(), false);
        Player bukkitPlayer = event.getPlayer();
        if (!this.konquest.getPlayerManager().isOnlinePlayer(bukkitPlayer)) {
            return;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (isEnemyPearlBlocked && event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.ENDER_PEARL)) {
            boolean isEnemyFrom;
            boolean isEnemyTo = this.territoryManager.isChunkClaimed(event.getTo()) && !this.kingdomManager.isPlayerFriendly(player, this.territoryManager.getChunkTerritory(event.getTo()).getKingdom());
            boolean bl = isEnemyFrom = this.territoryManager.isChunkClaimed(event.getFrom()) && !this.kingdomManager.isPlayerFriendly(player, this.territoryManager.getChunkTerritory(event.getFrom()).getKingdom());
            if (isEnemyTo || isEnemyFrom) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
                event.setCancelled(true);
                return;
            }
        }
        boolean forceEntryExit = event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.COMMAND) || event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.PLUGIN) || event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.SPECTATE) || event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.UNKNOWN);
        boolean status = this.onPlayerEnterLeaveChunk(event.getTo(), event.getFrom(), event.getPlayer(), forceEntryExit);
        if (status) {
            return;
        }
        event.setCancelled(true);
    }

    private boolean onPlayerEnterLeaveChunk(Location moveTo, Location moveFrom, Player movePlayer, boolean force) {
        boolean status;
        boolean doCancelTravelOnMove;
        if ((!moveTo.getBlock().equals((Object)moveFrom.getBlock()) || !moveTo.getWorld().equals((Object)moveFrom.getWorld())) && (doCancelTravelOnMove = this.konquest.getCore().getBoolean(CorePath.TRAVEL_CANCEL_ON_MOVE.getPath(), false)) && (status = this.konquest.getTravelManager().cancelTravel(movePlayer))) {
            ChatUtil.sendError((CommandSender)movePlayer, MessagePath.COMMAND_TRAVEL_ERROR_CANCELED.getMessage(new Object[0]));
        }
        if (!moveTo.getChunk().equals((Object)moveFrom.getChunk()) || !moveTo.getWorld().equals((Object)moveFrom.getWorld())) {
            String color;
            if (!this.konquest.getPlayerManager().isOnlinePlayer(movePlayer)) {
                return true;
            }
            KonPlayer player = this.playerManager.getPlayer(movePlayer);
            boolean isTerritoryTo = this.territoryManager.isChunkClaimed(moveTo);
            boolean isTerritoryFrom = this.territoryManager.isChunkClaimed(moveFrom);
            KonTerritory territoryTo = null;
            KonTerritory territoryFrom = null;
            if (isTerritoryTo) {
                territoryTo = this.territoryManager.getChunkTerritory(moveTo);
            }
            if (isTerritoryFrom) {
                territoryFrom = this.territoryManager.getChunkTerritory(moveFrom);
            }
            if (isTerritoryTo || isTerritoryFrom) {
                KonquestTerritoryMoveEvent invokeEvent = new KonquestTerritoryMoveEvent(this.konquest, territoryTo, territoryFrom, player);
                Konquest.callKonquestEvent(invokeEvent);
                if (invokeEvent.isCancelled()) {
                    return false;
                }
            }
            if (moveTo.getWorld().equals((Object)moveFrom.getWorld())) {
                if (player.isAutoFollowActive()) {
                    if (!isTerritoryTo) {
                        if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.ADMIN_CLAIM)) {
                            if (this.territoryManager.claimForAdmin(player, moveTo)) {
                                ChatUtil.sendKonTitle(player, "", String.valueOf(ChatColor.GOLD) + MessagePath.COMMAND_CLAIM_NOTICE_PASS_AUTO.getMessage(new Object[0]), 15);
                            } else {
                                player.setAutoFollow(KonPlayer.FollowType.NONE);
                                ChatUtil.sendNotice((CommandSender)movePlayer, MessagePath.COMMAND_CLAIM_NOTICE_FAIL_AUTO.getMessage(new Object[0]));
                            }
                        } else if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.CLAIM)) {
                            if (this.territoryManager.claimForPlayer(player, moveTo)) {
                                ChatUtil.sendKonTitle(player, "", String.valueOf(ChatColor.GREEN) + MessagePath.COMMAND_CLAIM_NOTICE_PASS_AUTO.getMessage(new Object[0]), 15);
                            } else {
                                player.setAutoFollow(KonPlayer.FollowType.NONE);
                                ChatUtil.sendNotice((CommandSender)movePlayer, MessagePath.COMMAND_CLAIM_NOTICE_FAIL_AUTO.getMessage(new Object[0]));
                            }
                        }
                    } else if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.ADMIN_UNCLAIM)) {
                        if (this.territoryManager.unclaimForAdmin(player, moveTo)) {
                            ChatUtil.sendKonTitle(player, "", String.valueOf(ChatColor.GOLD) + MessagePath.COMMAND_UNCLAIM_NOTICE_PASS_AUTO.getMessage(new Object[0]), 15);
                        } else {
                            player.setAutoFollow(KonPlayer.FollowType.NONE);
                            ChatUtil.sendNotice((CommandSender)movePlayer, MessagePath.COMMAND_UNCLAIM_NOTICE_FAIL_AUTO.getMessage(new Object[0]));
                        }
                    } else if (player.getAutoFollow().equals((Object)KonPlayer.FollowType.UNCLAIM)) {
                        if (this.territoryManager.unclaimForPlayer(player, moveTo)) {
                            ChatUtil.sendKonTitle(player, "", String.valueOf(ChatColor.GREEN) + MessagePath.COMMAND_UNCLAIM_NOTICE_PASS_AUTO.getMessage(new Object[0]), 15);
                        } else {
                            player.setAutoFollow(KonPlayer.FollowType.NONE);
                            ChatUtil.sendNotice((CommandSender)movePlayer, MessagePath.COMMAND_UNCLAIM_NOTICE_FAIL_AUTO.getMessage(new Object[0]));
                        }
                    }
                    isTerritoryTo = this.territoryManager.isChunkClaimed(moveTo);
                    isTerritoryFrom = this.territoryManager.isChunkClaimed(moveFrom);
                    if (isTerritoryTo) {
                        territoryTo = this.territoryManager.getChunkTerritory(moveTo);
                    }
                    if (isTerritoryFrom) {
                        territoryFrom = this.territoryManager.getChunkTerritory(moveFrom);
                    }
                }
                if (!isTerritoryTo && isTerritoryFrom) {
                    if (this.isDeniedExitTerritory(territoryFrom, player, force)) {
                        return false;
                    }
                    ChatUtil.sendKonTitle(player, "", MessagePath.GENERIC_NOTICE_WILD.getMessage(new Object[0]));
                    this.onExitTerritory(territoryFrom, player);
                    player.setFlyDisableWarmup(true);
                } else if (isTerritoryTo && !isTerritoryFrom) {
                    if (this.isDeniedEnterTerritory(territoryTo, player, force)) {
                        return false;
                    }
                    color = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)player, territoryTo);
                    ChatUtil.sendKonTitle(player, "", color + territoryTo.getName());
                    this.onEnterTerritory(territoryTo, moveTo, moveFrom, player);
                    if (territoryTo.getKingdom().equals(player.getKingdom())) {
                        player.setFlyDisableWarmup(false);
                    } else {
                        player.setIsFlyEnabled(false);
                    }
                } else if (isTerritoryTo) {
                    if (!territoryTo.equals(territoryFrom)) {
                        if (this.isDeniedExitTerritory(territoryFrom, player, force)) {
                            return false;
                        }
                        if (this.isDeniedEnterTerritory(territoryTo, player, force)) {
                            return false;
                        }
                        color = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)player, territoryTo);
                        ChatUtil.sendKonTitle(player, "", color + territoryTo.getName());
                        this.onExitTerritory(territoryFrom, player);
                        this.onEnterTerritory(territoryTo, moveTo, moveFrom, player);
                        if (territoryTo.getKingdom().equals(player.getKingdom())) {
                            player.setFlyDisableWarmup(false);
                        } else {
                            player.setIsFlyEnabled(false);
                        }
                    } else if (territoryTo instanceof KonTown) {
                        KonTown town = (KonTown)territoryTo;
                        if (this.kingdomManager.isPlayerEnemy(player, town.getKingdom())) {
                            this.kingdomManager.applyTownNerf(player, town);
                            town.updateGolemTargets(player, true);
                        } else {
                            this.kingdomManager.clearTownNerf(player);
                        }
                        if (this.kingdomManager.isPlayerFriendly(player, town.getKingdom())) {
                            this.displayPlotMessage(town, moveTo, moveFrom, player);
                        }
                    }
                }
                if (player.isMapAuto()) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> this.territoryManager.printPlayerMap(player, 9, moveTo), 1L);
                }
            } else {
                if (isTerritoryFrom && this.isDeniedExitTerritory(territoryFrom, player, force)) {
                    return false;
                }
                if (isTerritoryTo && this.isDeniedEnterTerritory(territoryTo, player, force)) {
                    return false;
                }
                if (player.isAutoFollowActive()) {
                    player.setAutoFollow(KonPlayer.FollowType.NONE);
                    ChatUtil.sendNotice((CommandSender)movePlayer, MessagePath.COMMAND_CLAIM_NOTICE_FAIL_AUTO.getMessage(new Object[0]));
                }
                if (player.isMapAuto()) {
                    player.setIsMapAuto(false);
                }
                player.setIsFlyEnabled(false);
                if (isTerritoryFrom) {
                    this.onExitTerritory(territoryFrom, player);
                }
                if (isTerritoryTo) {
                    color = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)player, territoryTo);
                    String territoryName = territoryTo.getName();
                    ChatUtil.sendKonTitle(player, "", color + territoryName);
                    this.onEnterTerritory(territoryTo, moveTo, moveFrom, player);
                }
            }
            this.territoryManager.updatePlayerBorderParticles(player, moveTo);
        }
        return true;
    }

    private boolean isDeniedEnterTerritory(KonTerritory territoryTo, KonPlayer player, boolean force) {
        KonPropertyFlagHolder flagHolder;
        if (territoryTo == null) {
            return false;
        }
        if (force) {
            return false;
        }
        if (player.isAdminBypassActive()) {
            return false;
        }
        if (territoryTo.getKingdom().equals(player.getKingdom())) {
            return false;
        }
        if (territoryTo instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territoryTo)).hasPropertyValue(KonPropertyFlag.ENTER) && !flagHolder.getPropertyValue(KonPropertyFlag.ENTER)) {
            if (player.getBukkitPlayer().isInsideVehicle()) {
                Vehicle vehicle = (Vehicle)player.getBukkitPlayer().getVehicle();
                vehicle.setVelocity(vehicle.getVelocity().multiply(-4));
                vehicle.eject();
            }
            ChatUtil.sendKonBlockedFlagTitle(player);
            if (player.getBukkitPlayer().hasPermission("konquest.command.admin")) {
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_IGNORE.getMessage(new Object[0]));
            }
            return true;
        }
        return false;
    }

    private void onEnterTerritory(KonTerritory territoryTo, Location locTo, Location locFrom, KonPlayer player) {
        KonPropertyFlagHolder flagHolder;
        if (territoryTo == null) {
            return;
        }
        if (territoryTo instanceof KonBarDisplayer) {
            ((KonBarDisplayer)((Object)territoryTo)).addBarPlayer(player);
        }
        if (territoryTo instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territoryTo)).hasPropertyValue(KonPropertyFlag.PVE) && !flagHolder.getPropertyValue(KonPropertyFlag.PVE) && locTo.getWorld() != null) {
            for (Entity searchEntity : locTo.getWorld().getNearbyEntities(locTo, 32.0, 32.0, 32.0, e -> e instanceof Mob)) {
                Mob searchMob = (Mob)searchEntity;
                LivingEntity mobTarget = searchMob.getTarget();
                if (mobTarget == null || !mobTarget.equals((Object)player.getBukkitPlayer())) continue;
                searchMob.setTarget(null);
            }
        }
        if (territoryTo instanceof KonTown) {
            KonTown town = (KonTown)territoryTo;
            if (town.getPlayerResidents().isEmpty() && town.getKingdom().equals(player.getKingdom())) {
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_TOWN_NOTICE_NO_LORD.getMessage(town.getName(), town.getTravelName()));
            }
            this.displayPlotMessage(town, locTo, locFrom, player);
            town.updateGolemTargets(player, true);
            this.kingdomManager.applyTownHearts(player, town);
            if (!(player.isAdminBypassActive() || player.getBukkitPlayer().getGameMode().equals((Object)GameMode.SPECTATOR) || player.getKingdom().isPeaceful())) {
                if (this.kingdomManager.isPlayerEnemy(player, town.getKingdom())) {
                    town.sendRaidAlert(player);
                    this.kingdomManager.applyTownNerf(player, town);
                } else if (this.kingdomManager.isPlayerFriendly(player, town.getKingdom())) {
                    this.kingdomManager.clearTownNerf(player);
                }
            }
        } else if (territoryTo instanceof KonCamp) {
            KonCamp camp = (KonCamp)territoryTo;
            boolean isPerm = player.getBukkitPlayer().hasPermission("konquest.raid.entry");
            if (!camp.isRaidAlertDisabled() && !player.isAdminBypassActive() && !player.getKingdom().isPeaceful() && isPerm && camp.isOwnerOnline()) {
                KonPlayer ownerOnlinePlayer;
                boolean isMember = false;
                if (this.konquest.getCampManager().isCampGrouped(camp)) {
                    isMember = this.konquest.getCampManager().getCampGroup(camp).isPlayerMember((OfflinePlayer)player.getBukkitPlayer());
                }
                if ((ownerOnlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(camp.getOwner().getUniqueId())) != null && !isMember && !player.getBukkitPlayer().getUniqueId().equals(camp.getOwner().getUniqueId())) {
                    Player ownerBukkitPlayer = ownerOnlinePlayer.getBukkitPlayer();
                    ChatUtil.sendNotice((CommandSender)ownerBukkitPlayer, MessagePath.PROTECTION_NOTICE_RAID.getMessage(camp.getName(), "camp"), ChatColor.DARK_RED);
                    ChatUtil.sendKonPriorityTitle(ownerOnlinePlayer, String.valueOf(ChatColor.DARK_RED) + MessagePath.PROTECTION_NOTICE_RAID_ALERT.getMessage(new Object[0]), String.valueOf(ChatColor.DARK_RED) + camp.getName(), 60, 1, 10);
                    int raidAlertTimeSeconds = this.konquest.getCore().getInt(CorePath.TOWNS_RAID_ALERT_COOLDOWN.getPath());
                    ChatUtil.printDebug("Starting raid alert timer for " + raidAlertTimeSeconds + " seconds");
                    Timer raidAlertTimer = camp.getRaidAlertTimer();
                    camp.setIsRaidAlertDisabled(true);
                    raidAlertTimer.stopTimer();
                    raidAlertTimer.setTime(raidAlertTimeSeconds);
                    raidAlertTimer.startTimer();
                }
            }
        } else if (territoryTo instanceof KonRuin) {
            KonRuin ruin = (KonRuin)territoryTo;
            ruin.spawnAllGolems();
        }
    }

    private boolean isDeniedExitTerritory(KonTerritory territoryFrom, KonPlayer player, boolean force) {
        KonPropertyFlagHolder flagHolder;
        if (territoryFrom == null) {
            return false;
        }
        if (force) {
            return false;
        }
        if (player.isAdminBypassActive()) {
            return false;
        }
        if (territoryFrom.getKingdom().equals(player.getKingdom())) {
            return false;
        }
        if (territoryFrom instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territoryFrom)).hasPropertyValue(KonPropertyFlag.EXIT) && !flagHolder.getPropertyValue(KonPropertyFlag.EXIT)) {
            if (player.getBukkitPlayer().isInsideVehicle()) {
                Vehicle vehicle = (Vehicle)player.getBukkitPlayer().getVehicle();
                vehicle.setVelocity(vehicle.getVelocity().multiply(-4));
                vehicle.eject();
            }
            ChatUtil.sendKonBlockedFlagTitle(player);
            if (player.getBukkitPlayer().hasPermission("konquest.command.admin")) {
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_IGNORE.getMessage(new Object[0]));
            }
            return true;
        }
        return false;
    }

    private void onExitTerritory(KonTerritory territoryFrom, KonPlayer player) {
        if (territoryFrom == null) {
            return;
        }
        if (territoryFrom instanceof KonBarDisplayer) {
            ((KonBarDisplayer)((Object)territoryFrom)).removeBarPlayer(player);
        }
        if (territoryFrom instanceof KonTown) {
            KonTown town = (KonTown)territoryFrom;
            player.clearAllMobAttackers();
            town.updateGolemTargets(player, false);
            this.kingdomManager.clearTownHearts(player);
            this.kingdomManager.clearTownNerf(player);
        } else if (territoryFrom instanceof KonRuin) {
            KonRuin ruin = (KonRuin)territoryFrom;
            ruin.stopTargetingPlayer(player.getBukkitPlayer());
        }
    }

    private void displayPlotMessage(KonTown town, Location toLoc, Location fromLoc, KonPlayer player) {
        if (town.getKingdom().equals(player.getKingdom())) {
            boolean isPlotTo = town.hasPlot(toLoc);
            boolean isPlotFrom = town.hasPlot(fromLoc);
            String plotMessage = "";
            ChatColor plotMessageColor = ChatColor.GOLD;
            boolean doDisplay = false;
            if (isPlotTo) {
                KonPlot plotTo = town.getPlot(toLoc);
                if (!isPlotFrom || !plotTo.equals(town.getPlot(fromLoc))) {
                    plotMessage = plotTo.getDisplayText();
                    if (plotTo.hasUser((OfflinePlayer)player.getBukkitPlayer())) {
                        plotMessageColor = ChatColor.DARK_GREEN;
                    }
                    doDisplay = true;
                }
            } else if ((isPlotFrom || !town.isLocInside(fromLoc)) && town.isLocInside(toLoc)) {
                plotMessage = town instanceof KonCapital ? MessagePath.MENU_PLOTS_CAPITAL_LAND.getMessage(new Object[0]) : MessagePath.MENU_PLOTS_TOWN_LAND.getMessage(new Object[0]);
                plotMessageColor = ChatColor.DARK_GREEN;
                doDisplay = true;
            }
            if (!doDisplay) {
                return;
            }
            player.getBukkitPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(plotMessageColor) + plotMessage));
        }
    }

    private boolean preventUse(PlayerInteractEvent event, KonPlayer player) {
        BlockState clickedState;
        BlockData clickedBlockData;
        if (event.hasBlock() && event.getClickedBlock() != null && ((clickedBlockData = (clickedState = event.getClickedBlock().getState()).getBlockData()) instanceof AnaloguePowerable || clickedBlockData instanceof Powerable || clickedState.getType().isInteractable())) {
            event.setUseInteractedBlock(Event.Result.DENY);
            if (!(clickedState instanceof Sign)) {
                ChatUtil.sendKonBlockedProtectionTitle(player);
            }
            return true;
        }
        return false;
    }

    private boolean preventPhysical(PlayerInteractEvent event, KonPlayer player) {
        if (event.hasBlock() && event.getClickedBlock() != null) {
            BlockData clickedBlockData = event.getClickedBlock().getBlockData();
            if (event.getAction().equals((Object)Action.PHYSICAL) && clickedBlockData instanceof Farmland) {
                event.setUseInteractedBlock(Event.Result.DENY);
                ChatUtil.sendKonBlockedProtectionTitle(player);
                return true;
            }
        }
        return false;
    }
}

