/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.ghostchu.quickshop.api.event.ShopClickEvent;
import com.ghostchu.quickshop.api.event.ShopPreCreateEvent;
import com.ghostchu.quickshop.api.event.ShopPurchaseEvent;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.shop.ShopHandler;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class QuickShopListener
implements Listener {
    private final ShopHandler shopHandler;

    public QuickShopListener(KonquestPlugin plugin) {
        this.shopHandler = plugin.getKonquestInstance().getShopHandler();
    }

    @EventHandler
    public void onShopPreCreate(ShopPreCreateEvent event) {
        boolean status;
        Optional opPlayer = event.getCreator().getBukkitPlayer();
        if (opPlayer.isPresent() && !(status = this.shopHandler.onShopCreate(event.getLocation(), (Player)opPlayer.get()))) {
            event.setCancelled(true, "Konquest");
        }
    }

    @EventHandler
    public void onShopPurchase(ShopPurchaseEvent event) {
        boolean status;
        Optional opPlayer = event.getPurchaser().getBukkitPlayer();
        if (opPlayer.isPresent() && !(status = this.shopHandler.onShopUse(event.getShop().getLocation(), (Player)opPlayer.get()))) {
            event.setCancelled(true, "Konquest");
        }
    }

    @EventHandler
    public void onShopClick(ShopClickEvent event) {
        boolean status = this.shopHandler.onShopUse(event.getShop().getLocation(), event.getClicker());
        if (!status) {
            event.setCancelled(true, "Konquest");
        }
    }
}

