/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Fire;
import org.bukkit.block.data.type.TNT;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

public class TNTListener
implements Listener {
    private final String metaOwnerId = Konquest.metaTntOwnerId;
    private final KonquestPlugin plugin;
    private final Konquest konquest;
    private final HashMap<Player, Location> lastPowered;

    public TNTListener(KonquestPlugin plugin) {
        this.plugin = plugin;
        this.konquest = plugin.getKonquestInstance();
        this.lastPowered = new HashMap();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onTNTSpawn(EntitySpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof TNTPrimed)) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getLocation().getWorld())) {
            return;
        }
        Block spawnBlock = event.getLocation().getBlock();
        World spawnWorld = event.getLocation().getWorld();
        assert (spawnWorld != null);
        boolean hasOwner = false;
        Object ownerSource = "";
        Player nearestPlayer = null;
        double nearestDistance = 0.0;
        int x = spawnBlock.getX() - 2;
        int y = spawnBlock.getY() - 2;
        int z = spawnBlock.getZ() - 2;
        for (int ix = 0; ix < 5; ++ix) {
            block1: for (int iy = 0; iy < 5; ++iy) {
                for (int iz = 0; iz < 5; ++iz) {
                    BlockState checkState = spawnWorld.getBlockAt(new Location(spawnWorld, (double)(x + ix), (double)(y + iy), (double)(z + iz))).getState();
                    if (!checkState.hasMetadata(this.metaOwnerId)) continue;
                    for (MetadataValue meta : checkState.getMetadata(this.metaOwnerId)) {
                        event.getEntity().setMetadata(this.metaOwnerId, meta);
                    }
                    UUID ownerId = UUID.fromString(((MetadataValue)checkState.getMetadata(this.metaOwnerId).get(0)).asString());
                    Player owner = Bukkit.getPlayer((UUID)ownerId);
                    String ownerName = owner == null ? "unknown" : owner.getName();
                    ownerSource = "Block " + String.valueOf(checkState.getType()) + " with owner " + ownerName;
                    hasOwner = true;
                    checkState.removeMetadata(this.metaOwnerId, (Plugin)this.plugin);
                    continue block1;
                }
            }
        }
        if (!hasOwner) {
            Player nearestPowerPlayer = null;
            double nearestPowerDistance = 0.0;
            for (Player checkPlayer : this.lastPowered.keySet()) {
                double checkDistance;
                Location checkLocation = this.lastPowered.get(checkPlayer);
                if (!event.getLocation().getWorld().equals((Object)checkLocation.getWorld()) || !((checkDistance = event.getLocation().distance(checkLocation)) < 256.0) || nearestPowerPlayer != null && !(checkDistance < nearestPowerDistance)) continue;
                nearestPowerPlayer = checkPlayer;
                nearestPowerDistance = checkDistance;
            }
            if (nearestPowerPlayer != null) {
                ownerSource = "Powered by player " + nearestPowerPlayer.getName();
                hasOwner = true;
                this.updateMetaOwner((Metadatable)event.getEntity(), nearestPowerPlayer);
            }
        }
        if (!hasOwner) {
            for (Entity checkEntity : spawnWorld.getNearbyEntities(event.getLocation(), 32.0, 32.0, 32.0)) {
                if (checkEntity.hasMetadata(this.metaOwnerId)) {
                    for (MetadataValue meta : checkEntity.getMetadata(this.metaOwnerId)) {
                        event.getEntity().setMetadata(this.metaOwnerId, meta);
                    }
                    UUID ownerId = UUID.fromString(((MetadataValue)checkEntity.getMetadata(this.metaOwnerId).get(0)).asString());
                    Player owner = Bukkit.getPlayer((UUID)ownerId);
                    String ownerName = owner == null ? "unknown" : owner.getName();
                    ownerSource = "Entity " + checkEntity.getName() + " with owner " + ownerName;
                    hasOwner = true;
                    break;
                }
                if (!(checkEntity instanceof Player)) continue;
                double checkDistance = event.getLocation().distance(checkEntity.getLocation());
                if (nearestPlayer != null && !(checkDistance < nearestDistance)) continue;
                nearestPlayer = (Player)checkEntity;
                nearestDistance = checkDistance;
            }
        }
        if (!hasOwner && nearestPlayer != null) {
            ownerSource = "Nearby player " + nearestPlayer.getName();
            hasOwner = true;
            this.updateMetaOwner((Metadatable)event.getEntity(), nearestPlayer);
        }
        if (hasOwner) {
            ChatUtil.printDebug("Primed TNT spawned because of: " + (String)ownerSource);
        } else {
            ChatUtil.printDebug("Primed TNT spawned from unknown source.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTNTInteractPlayer(PlayerInteractEvent event) {
        if (this.konquest.isWorldIgnored(event.getPlayer().getWorld())) {
            return;
        }
        Block clickBlock = event.getClickedBlock();
        if (event.hasBlock() && clickBlock != null) {
            if (clickBlock.getBlockData() instanceof TNT && event.hasItem() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                this.updateMetaOwner((Metadatable)clickBlock.getState(), event.getPlayer());
            } else if (clickBlock.getBlockData() instanceof AnaloguePowerable || clickBlock.getBlockData() instanceof Powerable) {
                this.updateLastPowered(event.getPlayer(), clickBlock.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTNTPlayerShoot(ProjectileLaunchEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof AbstractArrow) && !(event.getEntity() instanceof Explosive)) {
            return;
        }
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getEntity().getWorld())) {
            return;
        }
        this.updateMetaOwner((Metadatable)event.getEntity(), (Player)event.getEntity().getShooter());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTNTPlayerPlaceRedstone(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Material placeType = event.getBlockPlaced().getType();
        if (!(placeType.equals((Object)Material.REDSTONE_BLOCK) || placeType.equals((Object)Material.REDSTONE_TORCH) || placeType.equals((Object)Material.REDSTONE_WALL_TORCH) || placeType.equals((Object)Material.FIRE))) {
            return;
        }
        this.updateMetaOwner((Metadatable)event.getBlockPlaced().getState(), event.getPlayer());
        if (placeType.equals((Object)Material.REDSTONE_BLOCK) || placeType.equals((Object)Material.REDSTONE_TORCH) || placeType.equals((Object)Material.REDSTONE_WALL_TORCH)) {
            this.updateLastPowered(event.getPlayer(), event.getBlockPlaced().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTNTPlayerBreakRedstone(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        Material breakType = event.getBlock().getType();
        if (breakType.equals((Object)Material.REDSTONE_BLOCK) || breakType.equals((Object)Material.REDSTONE_TORCH) || breakType.equals((Object)Material.REDSTONE_WALL_TORCH)) {
            this.updateLastPowered(event.getPlayer(), event.getBlock().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTNTFireSpread(BlockSpreadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.konquest.isWorldIgnored(event.getBlock().getWorld())) {
            return;
        }
        if (!(event.getBlock().getBlockData() instanceof Fire)) {
            return;
        }
        if (!(event.getSource().getBlockData() instanceof Fire)) {
            return;
        }
        if (event.getSource().getState().hasMetadata(this.metaOwnerId)) {
            for (MetadataValue meta : event.getSource().getState().getMetadata(this.metaOwnerId)) {
                event.getBlock().getState().setMetadata(this.metaOwnerId, meta);
                event.getBlock().getState().update();
            }
        }
    }

    private void updateMetaOwner(Metadatable meta, Player owner) {
        meta.setMetadata(this.metaOwnerId, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)owner.getUniqueId().toString()));
        if (meta instanceof BlockState && !((BlockState)meta).update(true)) {
            ChatUtil.printDebug("Failed to add metadata to block state for TNT owner.");
        }
    }

    private void updateLastPowered(Player player, Location loc) {
        if (!this.lastPowered.containsKey(player)) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.lastPowered.remove(player), 600L);
        }
        this.lastPowered.put(player, loc);
    }
}

