/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.listener;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.HelperUtil;
import java.awt.Point;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class WorldListener
implements Listener {
    private final Konquest konquest;

    public WorldListener(KonquestPlugin plugin) {
        this.konquest = plugin.getKonquestInstance();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPortalCreate(PortalCreateEvent event) {
        ChatUtil.printDebug("EVENT: Portal is being created in " + event.getWorld().getName());
        if (event.isCancelled()) {
            return;
        }
        if (!this.konquest.isWorldValid(event.getWorld())) {
            return;
        }
        for (BlockState current_blockState : event.getBlocks()) {
            KonPropertyFlagHolder flagHolder;
            if (!this.konquest.getTerritoryManager().isChunkClaimed(current_blockState.getLocation())) continue;
            KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(current_blockState.getLocation());
            if (territory instanceof KonPropertyFlagHolder && (flagHolder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.PORTALS) && !flagHolder.getPropertyValue(KonPropertyFlag.PORTALS)) {
                ChatUtil.printDebug("EVENT: Portal creation stopped inside of " + territory.getName());
                event.setCancelled(true);
                return;
            }
            if (!this.isLocInsideMonument(current_blockState.getLocation())) continue;
            ChatUtil.printDebug("EVENT: Portal creation stopped inside of monument " + territory.getName());
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(ChunkLoadEvent event) {
        KonTown town;
        KonTerritory territory;
        if (this.konquest.getTerritoryManager().isChunkClaimed(HelperUtil.toPoint(event.getChunk()), event.getWorld()) && (territory = this.konquest.getTerritoryManager().getChunkTerritory(HelperUtil.toPoint(event.getChunk()), event.getWorld())) instanceof KonTown && (town = (KonTown)territory).isChunkCenter(event.getChunk())) {
            ChatUtil.printDebug("EVENT: Loaded monument chunk of town " + town.getName());
            if (!town.getKingdom().isMonumentTemplateValid()) {
                ChatUtil.printDebug("Could not paste monument in town " + town.getName() + " while monument template is invalid");
            } else if (town.isAttacked()) {
                ChatUtil.printDebug("Could not paste monument in town " + town.getName() + " while under attack");
            } else {
                boolean status = town.reloadMonument();
                if (!status) {
                    ChatUtil.printDebug("Failed to paste invalid monument template!");
                }
            }
        }
        this.konquest.applyQueuedTeleports(event.getChunk());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkUnload(ChunkUnloadEvent event) {
        KonTerritory territory;
        Point chunkPoint = HelperUtil.toPoint(event.getChunk());
        if (this.konquest.getTerritoryManager().isChunkClaimed(chunkPoint, event.getWorld()) && (territory = this.konquest.getTerritoryManager().getChunkTerritory(HelperUtil.toPoint(event.getChunk()), event.getWorld())) instanceof KonRuin) {
            KonRuin ruin = (KonRuin)territory;
            for (Location spawn : ruin.getSpawnLocations()) {
                Point spawnPoint = HelperUtil.toPoint(spawn);
                if (!chunkPoint.equals(spawnPoint)) continue;
                ruin.removeGolem(spawn);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.konquest.isWorldIgnored(event.getWorld())) {
            return;
        }
        for (BlockState bState : event.getBlocks()) {
            if (!this.isLocInsideMonument(bState.getLocation())) continue;
            ChatUtil.printDebug("EVENT: Prevented structure growth within monument");
            event.setCancelled(true);
            return;
        }
    }

    private boolean isLocInsideMonument(Location loc) {
        if (!this.konquest.getTerritoryManager().isChunkClaimed(loc)) {
            return false;
        }
        KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(loc);
        if (territory instanceof KonSanctuary && ((KonSanctuary)territory).isLocInsideTemplate(loc)) {
            return true;
        }
        return territory instanceof KonTown && ((KonTown)territory).isLocInsideMonumentProtectionArea(loc);
    }
}

