/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerPrefixEvent;
import com.github.rumsfield.konquest.model.KonCustomPrefix;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPrefix;
import com.github.rumsfield.konquest.model.KonPrefixCategory;
import com.github.rumsfield.konquest.model.KonPrefixType;
import com.github.rumsfield.konquest.model.KonStats;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class AccomplishmentManager {
    private final Konquest konquest;
    private boolean isEnabled;
    private final HashMap<String, KonCustomPrefix> customPrefixes;

    public AccomplishmentManager(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.customPrefixes = new HashMap();
    }

    public void initialize() {
        this.isEnabled = this.konquest.getCore().getBoolean(CorePath.ACCOMPLISHMENT_PREFIX.getPath());
        ChatUtil.printDebug("Accomplishment Manager is ready with prefix " + this.isEnabled);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void modifyPlayerStat(KonPlayer player, KonStatsType stat, int amount) {
        this.modifyPlayerStat(player, stat, amount, false);
    }

    public void modifyPlayerStat(KonPlayer player, KonStatsType stat, int amount, boolean force) {
        if (!force && (player.isAdminBypassActive() || player.isBarbarian())) {
            return;
        }
        KonStats playerStats = player.getPlayerStats();
        KonPrefix playerPrefix = player.getPlayerPrefix();
        playerStats.increaseStat(stat, amount);
        if (!this.isEnabled) {
            return;
        }
        double level = 0.0;
        for (KonStatsType konStatsType : KonStatsType.values()) {
            if (!konStatsType.getCategory().equals((Object)stat.getCategory())) continue;
            level += (double)playerStats.getStat(konStatsType) * konStatsType.weight();
        }
        for (Enum enum_ : KonPrefixType.values()) {
            if (!((KonPrefixType)enum_).category().equals((Object)stat.getCategory())) continue;
            if ((double)((KonPrefixType)enum_).level() <= level && !playerPrefix.hasPrefix((KonPrefixType)enum_)) {
                ChatUtil.printDebug("Accomplishment unlock for player " + player.getBukkitPlayer().getName() + " with prefix " + ((KonPrefixType)enum_).getName());
                playerPrefix.addPrefix((KonPrefixType)enum_);
                ChatUtil.sendKonPriorityTitle(player, String.valueOf(ChatColor.DARK_PURPLE) + ((KonPrefixType)enum_).getName(), String.valueOf(ChatColor.GOLD) + MessagePath.GENERIC_NOTICE_ACCOMPLISHMENT.getMessage(new Object[0]), 60, 5, 10);
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), String.valueOf(ChatColor.WHITE) + MessagePath.GENERIC_NOTICE_PREFIX_UNLOCK.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.DARK_PURPLE) + ((KonPrefixType)enum_).getName());
                Konquest.playNotificationGoodSound(player.getBukkitPlayer());
                continue;
            }
            if (!playerPrefix.hasPrefix((KonPrefixType)enum_) || !((double)((KonPrefixType)enum_).level() > level)) continue;
            ChatUtil.printDebug("Accomplishment reverted for player " + player.getBukkitPlayer().getName() + " with prefix " + ((KonPrefixType)enum_).getName());
            playerPrefix.removePrefix((KonPrefixType)enum_);
            if (playerPrefix.getMainPrefix().equals(enum_)) {
                playerPrefix.setEnable(false);
            }
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), String.valueOf(ChatColor.WHITE) + MessagePath.GENERIC_NOTICE_PREFIX_LOST.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.DARK_RED) + ((KonPrefixType)enum_).getName());
            Konquest.playNotificationBadSound(player.getBukkitPlayer());
        }
    }

    public void initPlayerPrefixes(KonPlayer player) {
        if (this.isEnabled) {
            HashMap<KonPrefixCategory, Double> categoryLevels = new HashMap<KonPrefixCategory, Double>();
            KonStats playerStats = player.getPlayerStats();
            KonPrefix playerPrefix = player.getPlayerPrefix();
            for (KonStatsType konStatsType : KonStatsType.values()) {
                double level = 0.0;
                if (categoryLevels.containsKey((Object)konStatsType.getCategory())) {
                    level = (Double)categoryLevels.get((Object)konStatsType.getCategory());
                }
                double newLevel = level + (double)playerStats.getStat(konStatsType) * konStatsType.weight();
                categoryLevels.put(konStatsType.getCategory(), newLevel);
            }
            playerPrefix.clear();
            for (Enum enum_ : KonPrefixType.values()) {
                double playerLevel;
                int prefixLevel = ((KonPrefixType)enum_).level();
                if (!((double)prefixLevel <= (playerLevel = ((Double)categoryLevels.get((Object)((KonPrefixType)enum_).category())).doubleValue()))) continue;
                playerPrefix.addPrefix((KonPrefixType)enum_);
            }
        }
    }

    public void displayStats(KonPlayer player) {
        KonStats playerStats = player.getPlayerStats();
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        ArrayList<Object> pages = new ArrayList<Object>();
        BookMeta meta = (BookMeta)Bukkit.getServer().getItemFactory().getItemMeta(Material.WRITTEN_BOOK);
        assert (meta != null);
        meta.setAuthor("Konquest");
        meta.setGeneration(BookMeta.Generation.ORIGINAL);
        meta.setTitle(MessagePath.MENU_STATS_TITLE.getMessage(new Object[0]));
        Object titlePage = "";
        titlePage = (String)titlePage + String.valueOf(ChatColor.DARK_PURPLE) + String.valueOf(ChatColor.BOLD) + MessagePath.MENU_STATS_TITLE.getMessage(new Object[0]);
        titlePage = (String)titlePage + String.valueOf(ChatColor.RESET) + "\n\n";
        titlePage = (String)titlePage + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_INTRO_1.getMessage(new Object[0]);
        titlePage = (String)titlePage + String.valueOf(ChatColor.RESET) + "\n\n";
        titlePage = (String)titlePage + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_INTRO_2.getMessage(new Object[0]);
        pages.add(titlePage);
        for (KonPrefixCategory cat : KonPrefixCategory.values()) {
            double level = 0.0;
            for (KonStatsType statCheck : KonStatsType.values()) {
                if (!statCheck.getCategory().equals((Object)cat)) continue;
                level += (double)playerStats.getStat(statCheck) * statCheck.weight();
            }
            StringBuilder unlockedPrefixNames = new StringBuilder();
            String nextPrefixName = "";
            double nextLevel = Double.MAX_VALUE;
            for (KonPrefixType pre : KonPrefixType.values()) {
                if (!pre.category().equals((Object)cat)) continue;
                if ((double)pre.level() > level) {
                    if (!((double)pre.level() < nextLevel)) continue;
                    nextPrefixName = pre.getName();
                    nextLevel = pre.level();
                    continue;
                }
                unlockedPrefixNames.append(pre.getName()).append(" ");
            }
            Object levelProgress = MessagePath.MENU_STATS_MAX.getMessage(new Object[0]);
            if (nextLevel != Double.MAX_VALUE) {
                levelProgress = (int)level + "/" + (int)nextLevel;
            }
            Object page = "";
            page = (String)page + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_CATEGORY.getMessage(new Object[0]) + ":";
            page = (String)page + String.valueOf(ChatColor.RESET) + "\n";
            page = (String)page + String.valueOf(ChatColor.DARK_PURPLE) + cat.getTitle();
            page = (String)page + String.valueOf(ChatColor.RESET) + "\n";
            page = (String)page + String.valueOf(ChatColor.GRAY) + (String)levelProgress;
            page = (String)page + String.valueOf(ChatColor.RESET) + "\n\n";
            page = (String)page + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_NEXT.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.DARK_GREEN) + nextPrefixName;
            page = (String)page + String.valueOf(ChatColor.RESET) + "\n\n";
            page = (String)page + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_UNLOCK.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.GREEN) + String.valueOf(unlockedPrefixNames);
            pages.add(page);
            for (KonStatsType stat : KonStatsType.values()) {
                if (!stat.getCategory().equals((Object)cat)) continue;
                int currentAmount = playerStats.getStat(stat);
                double currentLevel = (double)currentAmount * stat.weight();
                page = "";
                page = (String)page + String.valueOf(ChatColor.DARK_PURPLE) + cat.getTitle();
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n";
                page = (String)page + String.valueOf(ChatColor.DARK_PURPLE) + String.valueOf(ChatColor.ITALIC) + stat.displayName();
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n";
                page = (String)page + String.valueOf(ChatColor.BLACK) + stat.description();
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n\n";
                page = (String)page + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_AMOUNT.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.GRAY) + currentAmount;
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n";
                page = (String)page + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_STATS_POINTS.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.GRAY) + (int)currentLevel;
                pages.add(page);
            }
        }
        meta.setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        player.getBukkitPlayer().openBook(book);
    }

    public boolean disablePlayerPrefix(KonPlayer player) {
        boolean isTitleAlwaysShown = this.konquest.getCore().getBoolean(CorePath.CHAT_ALWAYS_SHOW_TITLE.getPath(), false);
        if (isTitleAlwaysShown) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_PREFIX_ERROR_ALWAYS_ON.getMessage(new Object[0]));
        } else {
            if (player.getPlayerPrefix().isEnabled()) {
                player.getPlayerPrefix().setEnable(false);
                KonquestPlayerPrefixEvent invokeEvent = new KonquestPlayerPrefixEvent(this.konquest, player, "", true);
                Konquest.callKonquestEvent(invokeEvent);
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_PREFIX_NOTICE_DISABLE.getMessage(new Object[0]));
                return true;
            }
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_PREFIX_ERROR_DISABLE.getMessage(new Object[0]));
        }
        return false;
    }

    public boolean applyPlayerPrefix(KonPlayer player, KonPrefixType prefix) {
        boolean result = false;
        if (player.getPlayerPrefix().selectPrefix(prefix)) {
            player.getPlayerPrefix().setEnable(true);
            KonquestPlayerPrefixEvent invokeEvent = new KonquestPlayerPrefixEvent(this.konquest, player, prefix.getName(), false);
            Konquest.callKonquestEvent(invokeEvent);
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_PREFIX_NOTICE_NEW.getMessage(prefix.getName()));
            result = true;
        } else {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_PREFIX_ERROR_NEW.getMessage(prefix.getName()));
        }
        return result;
    }

    public void loadCustomPrefixes() {
        this.customPrefixes.clear();
        FileConfiguration prefixConfig = this.konquest.getConfigManager().getConfig("prefix");
        if (prefixConfig.get("prefix") == null) {
            ChatUtil.printDebug("There is no prefix section in prefix.yml");
            return;
        }
        String prefixName = "";
        int prefixCost = 0;
        for (String prefixLabel : prefixConfig.getConfigurationSection("prefix").getKeys(false)) {
            boolean status = true;
            ConfigurationSection prefixEntry = prefixConfig.getConfigurationSection("prefix." + prefixLabel);
            if (prefixEntry != null && StringUtils.isAlphanumeric((CharSequence)prefixLabel.replace("_", ""))) {
                if (prefixEntry.contains("name")) {
                    prefixName = prefixEntry.getString("name", "");
                    if (prefixName.isEmpty()) {
                        ChatUtil.printConsoleError("prefix.yml has an invalid name for prefix: " + prefixLabel);
                        status = false;
                    }
                } else {
                    ChatUtil.printConsoleError("prefix.yml is missing name for prefix: " + prefixLabel);
                    status = false;
                }
                if (prefixEntry.contains("cost")) {
                    prefixCost = prefixEntry.getInt("cost", 0);
                    prefixCost = Math.max(prefixCost, 0);
                } else {
                    ChatUtil.printConsoleError("prefix.yml is missing cost for prefix: " + prefixLabel);
                    status = false;
                }
                if (!status) continue;
                this.customPrefixes.put(prefixLabel.toLowerCase(), new KonCustomPrefix(prefixLabel.toLowerCase(), prefixName, prefixCost));
                ChatUtil.printDebug("Loaded custom prefix: " + prefixLabel);
                continue;
            }
            ChatUtil.printConsoleError("Failed to load invalid custom prefix, must only contain letters, numbers and underscores: " + prefixLabel);
        }
    }

    public Set<String> getCustomPrefixLabels() {
        return this.customPrefixes.keySet();
    }

    public List<KonCustomPrefix> getCustomPrefixes() {
        return new ArrayList<KonCustomPrefix>(this.customPrefixes.values());
    }

    public int getNumCustomPrefixes() {
        return this.customPrefixes.size();
    }

    public boolean setPlayerCustomPrefix(KonPlayer player, String prefixKey) {
        boolean result = false;
        if (this.customPrefixes.containsKey(prefixKey)) {
            KonCustomPrefix prefix = this.customPrefixes.get(prefixKey);
            if (player.getPlayerPrefix().setCustomPrefix(prefix)) {
                result = true;
            }
        }
        return result;
    }

    public boolean applyPlayerCustomPrefix(KonPlayer player, KonCustomPrefix prefix) {
        boolean checkPassed = false;
        if (!player.getBukkitPlayer().hasPermission("konquest.prefix." + prefix.getLabel())) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (player.getPlayerPrefix().isCustomAvailable(prefix.getLabel())) {
            checkPassed = true;
        } else {
            int cost = prefix.getCost();
            if (cost > 0) {
                if (KonquestPlugin.getBalance((OfflinePlayer)player.getBukkitPlayer()) < (double)cost) {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(cost));
                } else if (KonquestPlugin.withdrawPlayer((OfflinePlayer)player.getBukkitPlayer(), cost)) {
                    checkPassed = true;
                }
            } else {
                checkPassed = true;
            }
        }
        if (!checkPassed) {
            return false;
        }
        player.getPlayerPrefix().addAvailableCustom(prefix.getLabel());
        if (!player.getPlayerPrefix().setCustomPrefix(prefix)) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        player.getPlayerPrefix().setEnable(true);
        ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_PREFIX_NOTICE_NEW.getMessage(ChatUtil.parseHex(prefix.getName())));
        return true;
    }
}

