/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.event.camp.KonquestCampCreateEvent;
import com.github.rumsfield.konquest.api.manager.KonquestCampManager;
import com.github.rumsfield.konquest.api.model.KonquestCamp;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonCampGroup;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.data.type.Bed;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CampManager
implements KonquestCampManager {
    private final Konquest konquest;
    private final HashMap<String, KonCamp> barbarianCamps;
    private final HashMap<KonCamp, KonCampGroup> groupMap;
    private boolean isClanEnabled;
    private boolean isCampDataNull;

    public CampManager(Konquest konquest) {
        this.konquest = konquest;
        this.barbarianCamps = new HashMap();
        this.groupMap = new HashMap();
        this.isClanEnabled = false;
        this.isCampDataNull = false;
    }

    public void initCamps() {
        this.isClanEnabled = this.konquest.getCore().getBoolean(CorePath.CAMPS_CLAN_ENABLE.getPath(), false);
        this.loadCamps();
        this.refreshGroups();
        ChatUtil.printDebug("Loaded camps and groups");
    }

    @Override
    public boolean isCampSet(KonquestOfflinePlayer player) {
        String uuid = player.getOfflineBukkitPlayer().getUniqueId().toString();
        return player.isBarbarian() && this.barbarianCamps.containsKey(uuid);
    }

    public boolean isCampName(String name) {
        for (KonCamp camp : this.barbarianCamps.values()) {
            if (!camp.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public KonCamp getCampByName(String name) {
        for (KonCamp camp : this.barbarianCamps.values()) {
            if (!camp.getName().equalsIgnoreCase(name)) continue;
            return camp;
        }
        return null;
    }

    @Override
    public KonCamp getCamp(KonquestOfflinePlayer player) {
        String uuid = player.getOfflineBukkitPlayer().getUniqueId().toString();
        return this.getCamp(uuid);
    }

    public KonCamp getCamp(String uuid) {
        return this.barbarianCamps.get(uuid);
    }

    public ArrayList<KonCamp> getCamps() {
        return new ArrayList<KonCamp>(this.barbarianCamps.values());
    }

    public ArrayList<String> getCampNames() {
        ArrayList<String> campNames = new ArrayList<String>();
        for (KonCamp camp : this.barbarianCamps.values()) {
            campNames.add(camp.getName());
        }
        return campNames;
    }

    public void activateCampProtection(@Nullable KonOfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            return;
        }
        KonCamp camp = this.getCamp(offlinePlayer);
        if (camp == null) {
            return;
        }
        ChatUtil.printDebug("Set camp protection to true for player " + offlinePlayer.getOfflineBukkitPlayer().getName());
        camp.setProtected(true);
    }

    public void deactivateCampProtection(KonOfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            return;
        }
        KonCamp camp = this.getCamp(offlinePlayer);
        if (camp == null) {
            return;
        }
        ChatUtil.printDebug("Set camp protection to false for player " + offlinePlayer.getOfflineBukkitPlayer().getName());
        camp.setProtected(false);
    }

    public int addCamp(Location loc, KonOfflinePlayer player) {
        KonCamp newCamp;
        boolean enable = this.konquest.getCore().getBoolean(CorePath.CAMPS_ENABLE.getPath(), true);
        if (!enable) {
            ChatUtil.printDebug("Failed to add camp, feature disabled!");
            return 4;
        }
        if (!this.konquest.isWorldValid(loc)) {
            ChatUtil.printDebug("Failed to add camp, location is in invalid world");
            return 5;
        }
        String uuid = player.getOfflineBukkitPlayer().getUniqueId().toString();
        if (!player.isBarbarian()) {
            ChatUtil.printDebug("Failed to add camp, player " + player.getOfflineBukkitPlayer().getName() + " " + uuid + " is not a barbarian!");
            return 3;
        }
        if (!this.barbarianCamps.containsKey(uuid)) {
            int radius = this.konquest.getCore().getInt(CorePath.CAMPS_INIT_RADIUS.getPath());
            World addWorld = loc.getWorld();
            for (Point point : HelperUtil.getAreaPoints(loc, radius)) {
                if (!this.konquest.getTerritoryManager().isChunkClaimed(point, addWorld)) continue;
                ChatUtil.printDebug("Found a chunk conflict in camp placement for player " + player.getOfflineBukkitPlayer().getName() + " " + uuid);
                return 1;
            }
            boolean isOfflineJoinAllow = this.konquest.getCore().getBoolean(CorePath.CAMPS_CLAN_ALLOW_JOIN_OFFLINE.getPath());
            if (this.isClanEnabled) {
                boolean isAdjacentCampPresent = false;
                boolean isAnyAdjacentOwnerOnline = false;
                for (Point point : HelperUtil.getBorderPoints(loc, radius + 1)) {
                    if (!this.konquest.getTerritoryManager().isChunkClaimed(point, loc.getWorld()) || !(this.konquest.getTerritoryManager().getChunkTerritory(point, loc.getWorld()) instanceof KonCamp)) continue;
                    KonCamp adjCamp = (KonCamp)this.konquest.getTerritoryManager().getChunkTerritory(point, loc.getWorld());
                    isAdjacentCampPresent = true;
                    if (adjCamp == null || !adjCamp.isOwnerOnline()) continue;
                    isAnyAdjacentOwnerOnline = true;
                }
                if (isAdjacentCampPresent && !isAnyAdjacentOwnerOnline && !isOfflineJoinAllow) {
                    ChatUtil.printDebug("Failed to add camp, no adjacent camps have online members.");
                    return 6;
                }
            }
            newCamp = new KonCamp(loc, player.getOfflineBukkitPlayer(), this.konquest.getKingdomManager().getBarbarians(), this.konquest);
            this.barbarianCamps.put(uuid, newCamp);
            newCamp.initClaim();
            newCamp.updateBarPlayers();
            this.konquest.getTerritoryManager().addAllTerritory(loc.getWorld(), newCamp.getChunkList());
            this.refreshGroups();
            if (this.groupMap.containsKey(newCamp)) {
                Konquest.playCampGroupSound(loc);
                for (KonCamp groupCamp : this.groupMap.get(newCamp).getCamps()) {
                    KonPlayer ownerOnlinePlayer;
                    if (!groupCamp.isOwnerOnline() || (ownerOnlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(groupCamp.getOwner().getUniqueId())) == null) continue;
                    ChatUtil.sendNotice((CommandSender)ownerOnlinePlayer.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CAMP_CLAN_ADD.getMessage(newCamp.getName()));
                }
            }
        } else {
            return 2;
        }
        this.konquest.getMapHandler().drawUpdateTerritory(newCamp);
        return 0;
    }

    public boolean addCampForPlayer(Location loc, KonPlayer player) {
        int status;
        Player bukkitPlayer = player.getBukkitPlayer();
        if (this.konquest.getIntegrationManager().getWorldGuard().isEnabled()) {
            int radius = this.konquest.getCore().getInt(CorePath.CAMPS_INIT_RADIUS.getPath());
            World locWorld = loc.getWorld();
            for (Point point : HelperUtil.getAreaPoints(loc, radius)) {
                if (this.konquest.getIntegrationManager().getWorldGuard().isChunkClaimAllowed(locWorld, point, bukkitPlayer)) continue;
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_CLAIM_DENY.getMessage(new Object[0]));
                return false;
            }
        }
        if ((status = this.addCamp(loc, player)) == 0) {
            KonCamp newCamp = this.getCamp(player);
            if (newCamp != null) {
                KonquestCampCreateEvent invokeEvent = new KonquestCampCreateEvent(this.konquest, newCamp, player);
                Konquest.callKonquestEvent(invokeEvent);
                player.getBukkitPlayer().setBedSpawnLocation(loc, true);
                ChatUtil.sendKonTitle(player, "", Konquest.barbarianColor2 + newCamp.getName());
            }
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.PROTECTION_NOTICE_CAMP_CREATE.getMessage(new Object[0]));
        } else {
            switch (status) {
                case 1: {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_CAMP_FAIL_OVERLAP.getMessage(new Object[0]));
                    return false;
                }
                case 2: {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_CAMP_CREATE.getMessage(new Object[0]));
                    return false;
                }
                case 3: {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_CAMP_FAIL_BARBARIAN.getMessage(new Object[0]));
                    return false;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_CAMP_FAIL_OFFLINE.getMessage(new Object[0]));
                    break;
                }
                default: {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                }
            }
        }
        return true;
    }

    @Override
    public boolean removeCamp(KonquestOfflinePlayer player) {
        String uuid = player.getOfflineBukkitPlayer().getUniqueId().toString();
        return this.removeCamp(uuid);
    }

    public boolean removeCamp(KonCamp camp) {
        String uuid = camp.getOwner().getUniqueId().toString();
        return this.removeCamp(uuid);
    }

    public boolean removeCamp(String uuid) {
        KonCamp removedCamp;
        if (this.barbarianCamps.containsKey(uuid)) {
            ArrayList<Point> campPoints = new ArrayList<Point>(this.barbarianCamps.get(uuid).getChunkList().keySet());
            this.konquest.getShopHandler().deleteShopsInPoints(campPoints, this.barbarianCamps.get(uuid).getWorld());
            removedCamp = this.barbarianCamps.remove(uuid);
            removedCamp.removeAllBarPlayers();
            if (removedCamp.getBedLocation().getBlock().getBlockData() instanceof Bed) {
                removedCamp.getBedLocation().getBlock().breakNaturally();
            }
            this.konquest.getTerritoryManager().removeAllTerritory(removedCamp.getWorld(), removedCamp.getChunkList().keySet());
            Collection<Object> groupSet = new ArrayList();
            if (this.groupMap.containsKey(removedCamp)) {
                groupSet = this.groupMap.get(removedCamp).getCamps();
            }
            this.refreshGroups();
            for (KonCamp groupCamp : groupSet) {
                KonPlayer ownerOnlinePlayer;
                if (!groupCamp.isOwnerOnline() || (ownerOnlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(groupCamp.getOwner().getUniqueId())) == null) continue;
                ChatUtil.sendNotice((CommandSender)ownerOnlinePlayer.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_CAMP_CLAN_REMOVE.getMessage(removedCamp.getName()));
            }
        } else {
            ChatUtil.printDebug("Failed to remove camp for missing UUID " + uuid);
            return false;
        }
        this.konquest.getMapHandler().drawRemoveTerritory(removedCamp);
        Object var3_3 = null;
        ChatUtil.printDebug("Successfully removed camp for UUID " + uuid);
        return true;
    }

    @Override
    public boolean isCampGrouped(KonquestCamp camp) {
        return this.groupMap.containsKey(camp);
    }

    @Override
    public KonCampGroup getCampGroup(KonquestCamp camp) {
        return this.groupMap.get(camp);
    }

    @Override
    public boolean isCampGroupsEnabled() {
        return this.isClanEnabled;
    }

    private void refreshGroups() {
        this.groupMap.clear();
        if (!this.isClanEnabled) {
            return;
        }
        int totalGroups = 0;
        int radius = this.konquest.getCore().getInt(CorePath.CAMPS_INIT_RADIUS.getPath());
        for (KonCamp currCamp : this.barbarianCamps.values()) {
            if (this.groupMap.containsKey(currCamp)) continue;
            Location center = currCamp.getCenterLoc();
            HashSet<KonCamp> adjCamps = new HashSet<KonCamp>();
            for (Point point : HelperUtil.getBorderPoints(center, radius + 1)) {
                if (!this.konquest.getTerritoryManager().isChunkClaimed(point, center.getWorld()) || !(this.konquest.getTerritoryManager().getChunkTerritory(point, center.getWorld()) instanceof KonCamp)) continue;
                KonCamp adjCamp = (KonCamp)this.konquest.getTerritoryManager().getChunkTerritory(point, center.getWorld());
                adjCamps.add(adjCamp);
            }
            HashSet<KonCampGroup> adjGroups = new HashSet<KonCampGroup>();
            for (Object adjCamp2 : adjCamps) {
                if (!this.groupMap.containsKey(adjCamp2)) continue;
                adjGroups.add(this.groupMap.get(adjCamp2));
            }
            if (adjGroups.isEmpty()) {
                Object adjCamp2;
                if (adjCamps.isEmpty()) continue;
                KonCampGroup konCampGroup = new KonCampGroup();
                konCampGroup.addCamp(currCamp);
                this.groupMap.put(currCamp, konCampGroup);
                adjCamp2 = adjCamps.iterator();
                while (adjCamp2.hasNext()) {
                    KonCamp konCamp = (KonCamp)adjCamp2.next();
                    konCampGroup.addCamp(konCamp);
                    this.groupMap.put(konCamp, konCampGroup);
                }
                ++totalGroups;
                continue;
            }
            Iterator iterator = adjGroups.iterator();
            if (!iterator.hasNext()) continue;
            KonCampGroup mainGroup = (KonCampGroup)iterator.next();
            mainGroup.addCamp(currCamp);
            this.groupMap.put(currCamp, mainGroup);
            for (KonCamp adjCamp4 : adjCamps) {
                mainGroup.addCamp(adjCamp4);
                this.groupMap.put(adjCamp4, mainGroup);
            }
            while (iterator.hasNext()) {
                KonCampGroup konCampGroup = (KonCampGroup)iterator.next();
                mainGroup.mergeGroup(konCampGroup);
                konCampGroup.clearCamps();
                --totalGroups;
            }
        }
        ChatUtil.printDebug("Refreshed " + totalGroups + " camp groups");
    }

    private void loadCamps() {
        boolean enable = this.konquest.getCore().getBoolean(CorePath.CAMPS_ENABLE.getPath(), true);
        if (!enable) {
            ChatUtil.printConsoleAlert("Disabled barbarian camps");
            return;
        }
        FileConfiguration campsConfig = this.konquest.getConfigManager().getConfig("camps");
        if (campsConfig.get("camps") == null) {
            ChatUtil.printConsoleError("Failed to load any camps from camps.yml! Check file permissions.");
            this.isCampDataNull = true;
            return;
        }
        ConfigurationSection campsSection = campsConfig.getConfigurationSection("camps");
        Set playerSet = campsSection.getKeys(false);
        String defaultWorldName = this.konquest.getCore().getString(CorePath.WORLD_NAME.getPath(), "world");
        int totalCamps = 0;
        for (String uuid : playerSet) {
            if (!campsSection.contains(uuid)) continue;
            OfflinePlayer offlineBukkitPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
            if (this.konquest.getPlayerManager().isOfflinePlayer(offlineBukkitPlayer)) {
                KonOfflinePlayer offlinePlayer = this.konquest.getPlayerManager().getOfflinePlayer(offlineBukkitPlayer);
                ConfigurationSection playerCampSection = campsSection.getConfigurationSection(uuid);
                String worldName = playerCampSection.getString("world", defaultWorldName);
                List sectionList = playerCampSection.getDoubleList("center");
                double x = (Double)sectionList.get(0);
                double y = (Double)sectionList.get(1);
                double z = (Double)sectionList.get(2);
                World world = Bukkit.getWorld((String)worldName);
                if (world != null) {
                    Location camp_center = new Location(world, x, y, z);
                    int status = this.addCamp(camp_center, offlinePlayer);
                    if (status == 0) {
                        this.getCamp(offlinePlayer).addPoints(HelperUtil.formatStringToPoints(playerCampSection.getString("chunks")));
                        this.konquest.getTerritoryManager().addAllTerritory(world, this.getCamp(offlinePlayer).getChunkList());
                        ++totalCamps;
                        continue;
                    }
                    ChatUtil.printDebug("Failed to add camp for player " + offlineBukkitPlayer.getName() + ", error code: " + status);
                    continue;
                }
                String message = "Failed to load camp for player " + offlineBukkitPlayer.getName() + " in an unloaded world, " + worldName + ". Check plugin load order.";
                ChatUtil.printConsoleError(message);
                this.konquest.opStatusMessages.add(message);
                continue;
            }
            ChatUtil.printDebug("Failed to find player " + offlineBukkitPlayer.getName() + " when adding their camp");
        }
        ChatUtil.printDebug("Updated all camps from camps.yml, total " + totalCamps);
    }

    public void saveCamps() {
        if (this.isCampDataNull && this.barbarianCamps.isEmpty()) {
            ChatUtil.printConsoleError("Aborted saving camp data because a problem was encountered while loading data from camps.yml");
            return;
        }
        YamlConfiguration newSaveConfig = new YamlConfiguration();
        ConfigurationSection root = newSaveConfig.createSection("camps");
        try {
            for (String uuid : this.barbarianCamps.keySet()) {
                KonCamp camp = this.barbarianCamps.get(uuid);
                ConfigurationSection campSection = root.createSection(uuid);
                campSection.set("world", (Object)camp.getWorld().getName());
                campSection.set("center", (Object)new int[]{camp.getCenterLoc().getBlockX(), camp.getCenterLoc().getBlockY(), camp.getCenterLoc().getBlockZ()});
                campSection.set("chunks", (Object)HelperUtil.formatPointsToString(camp.getChunkList().keySet()));
            }
            FileConfiguration campsConfig = this.konquest.getConfigManager().getConfig("camps");
            campsConfig.set("camps", newSaveConfig.get("camps"));
            if (!this.barbarianCamps.isEmpty()) {
                ChatUtil.printConsole("Saved Camps");
            }
        }
        catch (Error | Exception internalError) {
            ChatUtil.printConsoleError("Failed to save camps, report this as a bug to the plugin author!");
            internalError.printStackTrace();
        }
    }
}

