/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.model.KonConfig;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.Version;
import com.github.rumsfield.konquest.utility.ZipUtility;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final Konquest konquest;
    private final HashMap<String, KonConfig> configCache;
    private String language;
    private FileConfiguration langConfig;

    public ConfigManager(Konquest konquest) {
        this.konquest = konquest;
        this.configCache = new HashMap();
        this.language = "english";
    }

    public void initialize() {
        this.addConfig("core", new KonConfig("core", false));
        this.createBackupData();
        this.checkIncompatibleUpdate();
        this.updateConfigVersion("core");
        this.addConfig("upgrades", new KonConfig("upgrades", false));
        this.updateConfigVersion("upgrades");
        this.addConfig("properties", new KonConfig("properties", false));
        this.updateConfigVersion("properties");
        this.addConfig("shields", new KonConfig("shields", false));
        this.updateConfigVersion("shields");
        this.addConfig("loot", new KonConfig("loot", false));
        this.updateConfigVersion("loot");
        this.addConfig("prefix", new KonConfig("prefix", false));
        this.updateConfigVersion("prefix");
        this.addConfig("commands", new KonConfig("commands", false));
        this.updateConfigVersion("commands");
        this.addConfig("town-options", new KonConfig("town-options", false));
        this.updateConfigVersion("town-options");
        this.migrateConfigFile("kingdoms.yml", "data/kingdoms.yml");
        this.migrateConfigFile("camps.yml", "data/camps.yml");
        this.migrateConfigFile("ruins.yml", "data/ruins.yml");
        this.addConfig("kingdoms", new KonConfig("data/kingdoms"));
        this.addConfig("camps", new KonConfig("data/camps"));
        this.addConfig("ruins", new KonConfig("data/ruins"));
        this.addConfig("sanctuaries", new KonConfig("data/sanctuaries"));
        this.addConfig("global-events", new KonConfig("data/global-events"));
        Konquest.getInstance().getPlugin().saveResource("backup-instructions-readme.txt", true);
        Konquest.getInstance().getPlugin().saveResource("banners/banner-instructions-readme.txt", true);
        File defaultBannerFile = new File(Konquest.getInstance().getPlugin().getDataFolder(), "banners/default.png");
        if (!defaultBannerFile.exists()) {
            Konquest.getInstance().getPlugin().saveResource("banners/default.png", false);
        }
        this.addConfig("lang_english", new KonConfig("lang/english", false));
        this.updateConfigVersion("lang_english");
        this.addConfig("lang_chinese", new KonConfig("lang/chinese", false));
        this.updateConfigVersion("lang_chinese");
        this.addConfig("lang_russian", new KonConfig("lang/russian", false));
        this.updateConfigVersion("lang_russian");
        this.addConfig("lang_spanish", new KonConfig("lang/spanish", false));
        this.updateConfigVersion("lang_spanish");
        this.addConfig("lang_turkish", new KonConfig("lang/turkish", false));
        this.updateConfigVersion("lang_turkish");
        this.addConfig("lang_german", new KonConfig("lang/german", false));
        this.updateConfigVersion("lang_german");
        this.language = this.getConfig("core").getString("language", "english");
        if (this.configCache.containsKey("lang_" + this.language)) {
            this.langConfig = this.getConfig("lang_" + this.language);
            ChatUtil.printConsoleAlert("Using " + this.language + " language file");
        } else if (this.addConfig("lang_custom", new KonConfig("lang/" + this.language, false))) {
            this.langConfig = this.getConfig("lang_custom");
            ChatUtil.printConsoleAlert("Using custom " + this.language + " language file");
        } else {
            this.langConfig = this.getConfig("lang_english");
            ChatUtil.printConsoleError("Failed to load invalid language file " + this.language + ".yml in Konquest/lang folder. Using default lang/english.yml.");
        }
        this.validateCorePaths();
    }

    public FileConfiguration getLang() {
        return this.langConfig;
    }

    public String getLangName() {
        return this.language;
    }

    public FileConfiguration getConfig(String key) {
        YamlConfiguration result = new YamlConfiguration();
        if (!this.configCache.containsKey(key)) {
            ChatUtil.printConsoleError("Bad internal reference to file " + key);
        } else {
            result = this.configCache.get(key).getConfig();
        }
        return result;
    }

    public boolean addConfig(String key, KonConfig config) {
        boolean status = false;
        if (config.saveDefaultConfig() && config.reloadConfig()) {
            this.configCache.put(key, config);
            status = true;
        }
        return status;
    }

    public Konquest getKonquest() {
        return this.konquest;
    }

    public void reloadConfigs() {
        for (KonConfig config : this.configCache.values()) {
            config.reloadConfig();
        }
    }

    public void saveConfigs() {
        for (KonConfig config : this.configCache.values()) {
            config.saveConfig();
        }
    }

    public void saveConfig(String name) {
        if (this.configCache.containsKey(name)) {
            this.configCache.get(name).saveConfig();
        } else {
            ChatUtil.printConsoleError("Tried to save non-existant config " + name);
        }
    }

    public void updateConfigVersion(String name) {
        if (this.configCache.containsKey(name)) {
            this.configCache.get(name).updateVersion();
        } else {
            ChatUtil.printConsoleError("Tried to update non-existant config " + name);
        }
    }

    public void overwriteBadConfig(String key) {
        this.configCache.get(key).saveNewConfig();
        this.configCache.get(key).reloadConfig();
        ChatUtil.printConsoleError("Bad config file \"" + key + "\", saved default version. Review this file for errors.");
    }

    private void migrateConfigFile(String oldPath, String newpath) {
        File oldFile = new File(Konquest.getInstance().getPlugin().getDataFolder(), oldPath);
        File newFile = new File(Konquest.getInstance().getPlugin().getDataFolder(), newpath);
        if (oldFile.exists()) {
            Path source = oldFile.toPath();
            Path destination = newFile.toPath();
            try {
                Files.createDirectories(destination, new FileAttribute[0]);
                Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
                oldFile.delete();
                ChatUtil.printConsoleAlert("Migrated data file " + oldPath + " to " + newpath);
            }
            catch (IOException e) {
                e.printStackTrace();
                ChatUtil.printConsoleError("Failed to move file " + oldPath + " to " + newpath);
            }
        }
    }

    private boolean validateCorePaths() {
        boolean result = true;
        FileConfiguration coreConfig = this.getConfig("core");
        for (CorePath path : CorePath.values()) {
            if (coreConfig.contains(path.getPath(), true)) continue;
            result = false;
            ChatUtil.printConsoleError("Core configuration file is missing path: " + path.getPath());
        }
        if (!result) {
            ChatUtil.printConsoleError("The Konquest core.yml config file may be corrupted. Try renaming or deleting the file, then restart the server.");
        }
        return result;
    }

    private void createBackupData() {
        int numBackups = this.konquest.getCore().getInt(CorePath.BACKUP_DATA_AMOUNT.getPath());
        if ((numBackups = Math.max(numBackups, 0)) == 0) {
            ChatUtil.printConsoleAlert("Data backups are disabled.");
            return;
        }
        String dateStr = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
        KonquestPlugin plugin = Konquest.getInstance().getPlugin();
        File konquestFolder = plugin.getDataFolder();
        File dataFolder = new File(konquestFolder, "data");
        if (!dataFolder.exists()) {
            ChatUtil.printConsoleAlert("Skipping backup, data folder not found.");
            return;
        }
        String destFolder = konquestFolder.getAbsolutePath();
        String destName = "backup_data_" + dateStr + ".zip";
        String archiveName = destFolder + File.separator + destName;
        ChatUtil.printConsoleAlert("Creating backup archive: " + destName);
        ArrayList<File> zipSources = new ArrayList<File>();
        zipSources.add(dataFolder);
        ZipUtility zipUtil = new ZipUtility();
        try {
            zipUtil.zip(zipSources, archiveName);
        }
        catch (Exception ex) {
            ChatUtil.printConsoleError("Failed to create backup archive of " + dataFolder.getPath());
            ex.printStackTrace();
        }
        FileFilter backupFileFilter = file -> file.getName().matches("backup_data_.+\\.zip");
        File[] allBackupArchives = konquestFolder.listFiles(backupFileFilter);
        if (allBackupArchives != null && allBackupArchives.length > numBackups) {
            Arrays.sort(allBackupArchives, Comparator.comparingLong(File::lastModified));
            int numDelete = allBackupArchives.length - numBackups;
            for (int i = 0; i < numDelete; ++i) {
                ChatUtil.printConsoleAlert("Deleting backup archive: " + allBackupArchives[i].getName());
                allBackupArchives[i].delete();
            }
        }
    }

    private void checkIncompatibleUpdate() {
        ArrayList<Version> versionBoundaries = new ArrayList<Version>();
        versionBoundaries.add(new Version("0.11.0"));
        KonquestPlugin plugin = Konquest.getInstance().getPlugin();
        FileConfiguration core = this.configCache.get("core").getConfig();
        String fileVersionStr = core.getString("version", "0.0.0");
        String pluginVersionStr = plugin.getDescription().getVersion();
        Version coreVersion = new Version(fileVersionStr);
        Version pluginVersion = new Version(pluginVersionStr);
        for (Version boundary : versionBoundaries) {
            if (coreVersion.equals(new Version("0.0.0")) || coreVersion.compareTo(boundary) >= 0 || pluginVersion.compareTo(boundary) < 0) continue;
            ChatUtil.printConsoleError("/!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\");
            ChatUtil.printConsoleError("Updating from Konquest version " + fileVersionStr + " to version " + pluginVersionStr + " requires extra setup!");
            ChatUtil.printConsoleError("You must review all kingdoms for correctness, or delete the Konquest folder.");
            ChatUtil.printConsoleError("Not all plugin data is guaranteed to transfer to the new version.");
            ChatUtil.printConsoleError("The original plugin data folder will be archived to Konquest_" + fileVersionStr + ".zip.");
            ChatUtil.printConsoleError("--> Recommended to delete the Konquest folder and restart the server. <--");
            ChatUtil.printConsoleError("/!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\ /!\\");
            String destFolder = plugin.getDataFolder().getParentFile().getAbsolutePath();
            String destName = plugin.getDataFolder().getName() + "_" + fileVersionStr + ".zip";
            String archiveName = destFolder + File.separator + destName;
            ChatUtil.printConsole("Archive: " + archiveName);
            ArrayList<File> zipSources = new ArrayList<File>();
            zipSources.add(plugin.getDataFolder());
            ZipUtility zipUtil = new ZipUtility();
            try {
                zipUtil.zip(zipSources, archiveName);
            }
            catch (Exception ex) {
                ChatUtil.printConsoleError("Failed to archive Konquest plugin folder.");
                ex.printStackTrace();
            }
            break;
        }
    }
}

