/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class DirectiveManager {
    private final Konquest konquest;
    private final HashMap<KonDirective, Double> rewardTable;
    private boolean isEnabled;

    public DirectiveManager(Konquest konquest) {
        this.konquest = konquest;
        this.rewardTable = new HashMap();
        this.isEnabled = false;
    }

    public void initialize() {
        for (KonDirective dir : KonDirective.values()) {
            String dirName = dir.toString().toLowerCase();
            double reward = 10.0;
            if (this.konquest.getCore().contains("core.favor.rewards." + dirName)) {
                reward = this.konquest.getCore().getDouble("core.favor.rewards." + dirName, 0.0);
            }
            this.rewardTable.put(dir, reward);
        }
        this.isEnabled = this.konquest.getCore().getBoolean(CorePath.DIRECTIVE_QUESTS.getPath(), true);
        ChatUtil.printDebug("Directive Manager is ready, enabled: " + this.isEnabled);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void updateDirectiveProgress(KonPlayer player, KonDirective directive) {
        if (this.isEnabled) {
            if (!player.getBukkitPlayer().hasPermission(directive.permission())) {
                ChatUtil.printDebug("Player " + player.getBukkitPlayer().getName() + " does not have permission for directive " + String.valueOf((Object)directive));
                return;
            }
            int currentProgress = player.getDirectiveProgress(directive);
            if (currentProgress < directive.stages()) {
                int newProgress = currentProgress + 1;
                player.setDirectiveProgress(directive, newProgress);
                if (newProgress >= directive.stages()) {
                    ChatUtil.printDebug("Directive rewarded to player " + player.getBukkitPlayer().getName() + " for directive " + directive.title());
                    double reward = this.rewardTable.get((Object)directive);
                    if (KonquestPlugin.depositPlayer((OfflinePlayer)player.getBukkitPlayer(), reward)) {
                        ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_NOTICE_QUEST.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.ITALIC) + directive.title());
                    }
                }
            }
        }
    }

    public void displayBook(KonPlayer player) {
        if (this.isEnabled) {
            ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
            ArrayList<Object> pages = new ArrayList<Object>();
            BookMeta meta = (BookMeta)Bukkit.getServer().getItemFactory().getItemMeta(Material.WRITTEN_BOOK);
            assert (meta != null);
            meta.setAuthor("Konquest");
            meta.setGeneration(BookMeta.Generation.ORIGINAL);
            meta.setTitle(MessagePath.MENU_QUEST_TITLE.getMessage(new Object[0]));
            Object titlePage = "";
            titlePage = (String)titlePage + String.valueOf(ChatColor.DARK_PURPLE) + String.valueOf(ChatColor.BOLD) + MessagePath.MENU_QUEST_TITLE.getMessage(new Object[0]);
            titlePage = (String)titlePage + String.valueOf(ChatColor.RESET) + "\n\n";
            titlePage = (String)titlePage + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_QUEST_INTRO_1.getMessage(new Object[0]);
            titlePage = (String)titlePage + String.valueOf(ChatColor.RESET) + "\n\n";
            titlePage = (String)titlePage + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_QUEST_INTRO_2.getMessage(new Object[0]);
            pages.add(titlePage);
            for (KonDirective dir : KonDirective.values()) {
                int currentProgress = player.getDirectiveProgress(dir);
                int stages = dir.stages();
                ChatColor progressColor = ChatColor.GRAY;
                if (currentProgress >= stages) {
                    progressColor = ChatColor.DARK_GREEN;
                }
                Object page = "";
                page = (String)page + String.valueOf(ChatColor.DARK_PURPLE) + String.valueOf(ChatColor.ITALIC) + dir.title();
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n\n";
                page = (String)page + String.valueOf(ChatColor.BLACK) + dir.description();
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n\n";
                page = (String)page + String.valueOf(progressColor) + currentProgress + "/" + stages;
                page = (String)page + String.valueOf(ChatColor.RESET) + "\n\n";
                page = (String)page + String.valueOf(ChatColor.BLACK) + MessagePath.MENU_QUEST_REWARD.getMessage(new Object[0]) + ": " + String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(this.rewardTable.get((Object)dir));
                pages.add(page);
            }
            meta.setPages(pages);
            book.setItemMeta((ItemMeta)meta);
            player.getBukkitPlayer().openBook(book);
        }
    }
}

