/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.display.DisplayView;
import com.github.rumsfield.konquest.display.StateMenu;
import com.github.rumsfield.konquest.display.icon.MenuIcon;
import com.github.rumsfield.konquest.display.menu.EventMenu;
import com.github.rumsfield.konquest.display.menu.HelpMenu;
import com.github.rumsfield.konquest.display.menu.InfoMenu;
import com.github.rumsfield.konquest.display.menu.KingdomMenu;
import com.github.rumsfield.konquest.display.menu.MainMenu;
import com.github.rumsfield.konquest.display.menu.PlotMenu;
import com.github.rumsfield.konquest.display.menu.PrefixMenu;
import com.github.rumsfield.konquest.display.menu.ScoreMenu;
import com.github.rumsfield.konquest.display.menu.TownMenu;
import com.github.rumsfield.konquest.display.menu.TravelMenu;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class DisplayManager {
    private final Konquest konquest;
    private final HashMap<Inventory, StateMenu> stateMenus;
    public static String adminFormat = String.valueOf(ChatColor.DARK_GRAY);
    public static String titleFormat = String.valueOf(ChatColor.BLACK);
    public static String nameFormat = String.valueOf(ChatColor.GOLD);
    public static String loreFormat = String.valueOf(ChatColor.YELLOW);
    public static String valueFormat = String.valueOf(ChatColor.AQUA);
    public static String hintFormat = String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.UNDERLINE) + "\u21d2";
    public static String propertyFormat = String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.ITALIC) + "\u25c6";
    public static String alertFormat = String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.ITALIC) + "\u26a0";
    public static String errorFormat = String.valueOf(ChatColor.RED);

    public DisplayManager(Konquest konquest) {
        this.konquest = konquest;
        this.stateMenus = new HashMap();
    }

    public void initialize() {
        ChatUtil.printDebug("Display Manager is ready");
    }

    public boolean isNotDisplayMenu(@Nullable Inventory inv) {
        if (inv == null) {
            return true;
        }
        return !this.stateMenus.containsKey(inv);
    }

    public void onDisplayMenuClick(KonPlayer clickPlayer, Inventory inv, int slot, boolean clickType) {
        if (inv == null) {
            return;
        }
        Player bukkitPlayer = clickPlayer.getBukkitPlayer();
        try {
            if (this.stateMenus.containsKey(inv)) {
                StateMenu clickMenu = this.stateMenus.get(inv);
                DisplayView currentView = clickMenu.getCurrentView();
                if (currentView == null || !currentView.getInventory().equals((Object)inv)) {
                    ChatUtil.printDebug("State menu view is not current!");
                    return;
                }
                MenuIcon clickedIcon = currentView.getIcon(slot);
                if (clickedIcon == null || !clickedIcon.isClickable()) {
                    return;
                }
                this.playMenuClickSound(bukkitPlayer);
                clickMenu.stopIconUpdates();
                DisplayView updateView = clickMenu.updateState(slot, clickType);
                this.stateMenus.remove(inv);
                if (updateView != null) {
                    bukkitPlayer.openInventory(updateView.getInventory());
                    this.stateMenus.put(updateView.getInventory(), clickMenu);
                } else {
                    bukkitPlayer.closeInventory();
                }
            }
        }
        catch (Error | Exception e) {
            bukkitPlayer.closeInventory();
            ChatUtil.printConsoleError("Failed to handle menu click, report this as a bug to the plugin author!");
            e.printStackTrace();
        }
    }

    public void onDisplayMenuClose(Inventory inv, HumanEntity owner) {
        this.stateMenus.remove(inv);
    }

    public void displayMenuToPlayer(KonPlayer viewer, StateMenu menu) {
        DisplayView view = menu.getCurrentView();
        if (view == null) {
            return;
        }
        this.playMenuOpenSound(viewer.getBukkitPlayer());
        this.stateMenus.put(view.getInventory(), menu);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.konquest.getPlugin(), () -> viewer.getBukkitPlayer().openInventory(view.getInventory()), 1L);
    }

    public void displayHelpMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        HelpMenu newMenu = new HelpMenu(this.konquest, displayPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayMainMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        MainMenu newMenu = new MainMenu(this.konquest, displayPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayMainMenuDashboard(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        MainMenu newMenu = new MainMenu(this.konquest, displayPlayer);
        newMenu.goToDashboard();
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayKingdomMenu(KonPlayer displayPlayer) {
        this.displayKingdomMenu(displayPlayer, displayPlayer.getKingdom(), false);
    }

    public void displayKingdomMenu(KonPlayer displayPlayer, KonKingdom kingdom, boolean isAdmin) {
        if (displayPlayer == null) {
            return;
        }
        KingdomMenu newMenu = new KingdomMenu(this.konquest, displayPlayer, kingdom, isAdmin);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayTownMenu(KonPlayer displayPlayer) {
        this.displayTownMenu(displayPlayer, false);
    }

    public void displayTownMenu(KonPlayer displayPlayer, boolean isAdmin) {
        if (displayPlayer == null) {
            return;
        }
        TownMenu newMenu = new TownMenu(this.konquest, displayPlayer, isAdmin);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayTownManagementMenu(KonPlayer displayPlayer, KonTown town, boolean isAdmin) {
        if (displayPlayer == null) {
            return;
        }
        TownMenu newMenu = new TownMenu(this.konquest, displayPlayer, isAdmin);
        newMenu.goToManagementRoot(town);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayTownPlotMenu(KonPlayer displayPlayer, KonTown town) {
        boolean isPlotsEnabled = this.konquest.getPlotManager().isEnabled();
        if (!isPlotsEnabled) {
            ChatUtil.sendError((CommandSender)displayPlayer.getBukkitPlayer(), MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
        } else {
            int maxSize = this.konquest.getPlotManager().getMaxSize();
            PlotMenu newMenu = new PlotMenu(this.konquest, town, displayPlayer, maxSize);
            this.displayMenuToPlayer(displayPlayer, newMenu);
        }
    }

    public void displayPrefixMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        PrefixMenu newMenu = new PrefixMenu(this.konquest, displayPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayScoreMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        ScoreMenu newMenu = new ScoreMenu(this.konquest, displayPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayScorePlayerMenu(KonPlayer displayPlayer, KonOfflinePlayer scorePlayer) {
        if (displayPlayer == null) {
            return;
        }
        ScoreMenu newMenu = new ScoreMenu(this.konquest, displayPlayer);
        newMenu.goToPlayerScore(scorePlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayScoreKingdomMenu(KonPlayer displayPlayer, KonKingdom scoreKingdom) {
        if (displayPlayer == null) {
            return;
        }
        ScoreMenu newMenu = new ScoreMenu(this.konquest, displayPlayer);
        newMenu.goToKingdomScore(scoreKingdom);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoPlayerMenu(KonPlayer displayPlayer, KonOfflinePlayer infoPlayer) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToPlayerInfo(infoPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoKingdomMenu(KonPlayer displayPlayer, KonKingdom infoKingdom) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToKingdomInfo(infoKingdom);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoTownMenu(KonPlayer displayPlayer, KonTown infoTown) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToTownInfo(infoTown);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoSanctuaryMenu(KonPlayer displayPlayer, KonSanctuary infoSanctuary) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToSanctuaryInfo(infoSanctuary);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoRuinMenu(KonPlayer displayPlayer, KonRuin infoRuin) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToRuinInfo(infoRuin);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoCampMenu(KonPlayer displayPlayer, KonCamp infoCamp) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToCampInfo(infoCamp);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoTemplateMenu(KonPlayer displayPlayer, KonMonumentTemplate infoTemplate) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToTemplateInfo(infoTemplate);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayInfoTemplateListMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        InfoMenu newMenu = new InfoMenu(this.konquest, displayPlayer);
        newMenu.goToTemplateListInfo();
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayTravelMenu(KonPlayer displayPlayer) {
        this.displayTravelMenu(displayPlayer, false);
    }

    public void displayTravelMenu(KonPlayer displayPlayer, boolean isAdmin) {
        if (displayPlayer == null) {
            return;
        }
        TravelMenu newMenu = new TravelMenu(this.konquest, displayPlayer, isAdmin);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public void displayEventMenu(KonPlayer displayPlayer) {
        if (displayPlayer == null) {
            return;
        }
        EventMenu newMenu = new EventMenu(this.konquest, displayPlayer);
        this.displayMenuToPlayer(displayPlayer, newMenu);
    }

    public static String boolean2Symbol(boolean val) {
        if (val) {
            return String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.BOLD) + "\u2713";
        }
        return String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u274c";
    }

    public static String boolean2Lang(boolean val) {
        if (val) {
            return MessagePath.LABEL_TRUE.getMessage(new Object[0]);
        }
        return MessagePath.LABEL_FALSE.getMessage(new Object[0]);
    }

    private void playMenuClickSound(Player bukkitPlayer) {
        bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 0.8f);
    }

    private void playMenuOpenSound(Player bukkitPlayer) {
        bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.4f);
    }
}

