/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.event.server.KonquestGlobalEventEndEvent;
import com.github.rumsfield.konquest.api.event.server.KonquestGlobalEventStartEvent;
import com.github.rumsfield.konquest.model.KonGlobalEvent;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class GlobalEventManager
implements Timeable {
    private final Konquest konquest;
    private final ArrayList<KonGlobalEvent> events;
    private final HashSet<KonGlobalEventEffect> validEffects;
    private final Timer eventTimer;
    private boolean isEventDataNull;
    private final Comparator<KonGlobalEvent> eventComparator;
    private int eventIntervalSeconds;
    private boolean isEnabled;
    public static double favorDiscountMultiplier = 1.0;

    public GlobalEventManager(Konquest konquest) {
        this.konquest = konquest;
        this.events = new ArrayList();
        this.validEffects = new HashSet();
        this.eventTimer = new Timer(this);
        this.isEventDataNull = false;
        this.eventIntervalSeconds = 30;
        this.isEnabled = true;
        this.eventComparator = (eventOne, eventTwo) -> {
            long s2;
            int result = 0;
            long s1 = eventOne.getStartTime();
            if (s1 < (s2 = eventTwo.getStartTime())) {
                result = 1;
            } else if (s1 > s2) {
                result = -1;
            }
            return result;
        };
    }

    public void initialize() {
        this.loadEvents();
        this.eventIntervalSeconds = Math.abs(this.konquest.getCore().getInt(CorePath.EVENT_INTERVAL.getPath()));
        if (this.eventIntervalSeconds == 0) {
            this.isEnabled = false;
            this.eventTimer.stopTimer();
        } else {
            this.isEnabled = true;
            this.refreshAllEvents();
            this.eventTimer.stopTimer();
            this.eventTimer.setTime(this.eventIntervalSeconds);
            this.eventTimer.startLoopTimer();
        }
        ChatUtil.printDebug("Global Event Manager is ready, enabled = " + this.isEnabled);
    }

    public void shutdown() {
        this.konquest.getKingdomManager().enableGlobalEventWar(false);
        this.konquest.getKingdomManager().enableGlobalEventPeace(false);
        this.konquest.getShieldManager().enableGlobalEventFreeShield(false);
        this.konquest.getShieldManager().enableGlobalEventDisableShield(false);
        this.konquest.getShieldManager().enableGlobalEventDisableArmor(false);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Event Timer ended with null taskID!");
        } else if (taskID == this.eventTimer.getTaskID()) {
            this.refreshAllEvents();
        }
    }

    private void refreshAllEvents() {
        HashSet<KonGlobalEventEffect> eventEffects = new HashSet<KonGlobalEventEffect>();
        for (KonGlobalEvent event : this.events) {
            ArrayList<String> eventEffectDescriptions;
            ArrayList<String> eventEffectNames;
            boolean wasActive = event.isActive();
            boolean nowActive = event.refreshActive();
            if (!wasActive && nowActive) {
                if (event.isEnabled()) {
                    this.notifyAllPlayers(MessagePath.COMMAND_EVENT_BROADCAST_START.getMessage(event.getName()), true);
                    eventEffectNames = new ArrayList<String>();
                    eventEffectDescriptions = new ArrayList<String>();
                    for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                        if (!event.hasEffect(effect)) continue;
                        eventEffectNames.add(effect.getTitle());
                        eventEffectDescriptions.add(effect.getDescription());
                    }
                    KonquestGlobalEventStartEvent konquestGlobalEventStartEvent = new KonquestGlobalEventStartEvent(this.konquest, event.getName(), event.getDurationHours(), eventEffectNames, eventEffectDescriptions);
                    Konquest.callKonquestEvent(konquestGlobalEventStartEvent);
                }
            } else if (wasActive && !nowActive && event.isEnabled()) {
                this.notifyAllPlayers(MessagePath.COMMAND_EVENT_BROADCAST_END.getMessage(event.getName()), false);
                eventEffectNames = new ArrayList();
                eventEffectDescriptions = new ArrayList();
                for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                    if (!event.hasEffect(effect)) continue;
                    eventEffectNames.add(effect.getTitle());
                    eventEffectDescriptions.add(effect.getDescription());
                }
                KonquestGlobalEventEndEvent konquestGlobalEventEndEvent = new KonquestGlobalEventEndEvent(this.konquest, event.getName(), event.getRepetitionDays(), eventEffectNames, eventEffectDescriptions);
                Konquest.callKonquestEvent(konquestGlobalEventEndEvent);
            }
            if (!event.isActive() || !event.isEnabled()) continue;
            eventEffects.addAll(event.getEffects());
        }
        this.validEffects.clear();
        for (KonGlobalEventEffect effect : eventEffects) {
            boolean isHighestPriorityEffect = true;
            for (KonGlobalEventEffect otherEffect : eventEffects) {
                if (!effect.isHigherPriority(otherEffect)) continue;
                isHighestPriorityEffect = false;
                break;
            }
            if (!isHighestPriorityEffect) continue;
            this.validEffects.add(effect);
        }
        this.konquest.getKingdomManager().enableGlobalEventWar(this.isEffectValid(KonGlobalEventEffect.ALL_WAR));
        this.konquest.getKingdomManager().enableGlobalEventPeace(this.isEffectValid(KonGlobalEventEffect.ALL_PEACE));
        this.konquest.getShieldManager().enableGlobalEventFreeShield(this.isEffectValid(KonGlobalEventEffect.FREE_SHIELDS));
        this.konquest.getShieldManager().enableGlobalEventDisableShield(this.isEffectValid(KonGlobalEventEffect.NO_SHIELDS));
        this.konquest.getShieldManager().enableGlobalEventDisableArmor(this.isEffectValid(KonGlobalEventEffect.NO_ARMOR));
        this.updateFavorDiscountMultiplier();
    }

    public void refreshDelayedEvents() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Konquest.getInstance().getPlugin(), this::refreshAllEvents, 20L);
    }

    public boolean isEffectValid(KonGlobalEventEffect effect) {
        return this.validEffects.contains((Object)effect);
    }

    public ArrayList<KonGlobalEventEffect> getValidEffects() {
        return new ArrayList<KonGlobalEventEffect>(this.validEffects);
    }

    private void updateFavorDiscountMultiplier() {
        favorDiscountMultiplier = this.validEffects.contains((Object)KonGlobalEventEffect.FAVOR_3) ? 0.2 : (this.validEffects.contains((Object)KonGlobalEventEffect.FAVOR_2) ? 0.5 : (this.validEffects.contains((Object)KonGlobalEventEffect.FAVOR_1) ? 0.8 : 1.0));
    }

    public int getMonumentLootMultiplier() {
        if (this.validEffects.contains((Object)KonGlobalEventEffect.MONUMENT_LOOT_3)) {
            return 10;
        }
        if (this.validEffects.contains((Object)KonGlobalEventEffect.MONUMENT_LOOT_2)) {
            return 5;
        }
        if (this.validEffects.contains((Object)KonGlobalEventEffect.MONUMENT_LOOT_1)) {
            return 2;
        }
        return 1;
    }

    public int getRuinLootMultiplier() {
        if (this.validEffects.contains((Object)KonGlobalEventEffect.RUIN_LOOT_3)) {
            return 10;
        }
        if (this.validEffects.contains((Object)KonGlobalEventEffect.RUIN_LOOT_2)) {
            return 5;
        }
        if (this.validEffects.contains((Object)KonGlobalEventEffect.RUIN_LOOT_1)) {
            return 2;
        }
        return 1;
    }

    public int getExpMultiplier() {
        if (this.validEffects.contains((Object)KonGlobalEventEffect.EXP_BOOST_3)) {
            return 10;
        }
        if (this.validEffects.contains((Object)KonGlobalEventEffect.EXP_BOOST_2)) {
            return 5;
        }
        if (this.validEffects.contains((Object)KonGlobalEventEffect.EXP_BOOST_1)) {
            return 2;
        }
        return 1;
    }

    public ArrayList<KonGlobalEvent> getEvents(boolean isActive) {
        ArrayList<KonGlobalEvent> result = new ArrayList<KonGlobalEvent>();
        if (isActive) {
            for (KonGlobalEvent event : this.events) {
                if (!event.isActive()) continue;
                result.add(event);
            }
        } else {
            result.addAll(this.events);
        }
        return result;
    }

    public ArrayList<KonGlobalEvent> getEventsOnDay(Date day) {
        ArrayList<KonGlobalEvent> result = new ArrayList<KonGlobalEvent>();
        for (KonGlobalEvent event : this.events) {
            if (!event.isActiveOnDay(day)) continue;
            result.add(event);
        }
        return result;
    }

    @Nullable
    public KonGlobalEvent getNextEvent() {
        KonGlobalEvent nextEvent = null;
        Date nextStart = null;
        for (KonGlobalEvent event : this.events) {
            Date eventNextStart = event.getNextStartDate();
            if (eventNextStart == null || nextStart != null && !eventNextStart.before(nextStart)) continue;
            nextStart = eventNextStart;
            nextEvent = event;
        }
        return nextEvent;
    }

    public ArrayList<KonGlobalEvent> getSortedEvents() {
        ArrayList<KonGlobalEvent> result = new ArrayList<KonGlobalEvent>(this.events);
        result.sort(this.eventComparator);
        return result;
    }

    public ArrayList<String> getEventNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (KonGlobalEvent event : this.events) {
            result.add(event.getName());
        }
        return result;
    }

    @Nullable
    public KonGlobalEvent getEvent(String name) {
        for (KonGlobalEvent event : this.events) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public boolean isEvent(String name) {
        for (KonGlobalEvent event : this.events) {
            if (!event.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean createEvent(String name, boolean isEnabled, long start, long duration, long repetition, List<KonGlobalEventEffect> effects) {
        if (this.konquest.validateNameConstraints(name) != 0) {
            return false;
        }
        KonGlobalEvent globalEvent = new KonGlobalEvent(name);
        globalEvent.setEnabled(isEnabled);
        globalEvent.setStart(start);
        globalEvent.setDuration(duration);
        globalEvent.setRepetition(repetition);
        for (KonGlobalEventEffect effect : effects) {
            globalEvent.addEffect(effect);
        }
        return this.addEvent(globalEvent);
    }

    public void modifyEventEnable(String name, boolean isEnabled) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return;
        }
        globalEvent.setEnabled(isEnabled);
        this.refreshDelayedEvents();
    }

    public void modifyEventStart(String name, Date startDate) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return;
        }
        globalEvent.setStart(startDate);
        this.refreshDelayedEvents();
    }

    public boolean modifyEventDuration(String name, long duration) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return false;
        }
        if (globalEvent.getRepetitionTime() < duration) {
            return false;
        }
        globalEvent.setDuration(duration);
        this.refreshDelayedEvents();
        return true;
    }

    public boolean modifyEventRepetition(String name, long repetition) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return false;
        }
        if (globalEvent.getDurationTime() > repetition) {
            return false;
        }
        globalEvent.setRepetition(repetition);
        this.refreshDelayedEvents();
        return true;
    }

    public void modifyEventEffects(String name, List<KonGlobalEventEffect> effects) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return;
        }
        globalEvent.clearEffects();
        for (KonGlobalEventEffect effect : effects) {
            globalEvent.addEffect(effect);
        }
        this.refreshDelayedEvents();
    }

    public void enableEvent(String name, boolean isEnabled) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return;
        }
        boolean wasEnabled = globalEvent.isEnabled();
        globalEvent.setEnabled(isEnabled);
        if (globalEvent.isActive()) {
            if (!wasEnabled && isEnabled) {
                ChatUtil.sendBroadcast(MessagePath.COMMAND_EVENT_BROADCAST_ENABLE.getMessage(globalEvent.getName()));
            } else if (wasEnabled && !isEnabled) {
                ChatUtil.sendBroadcast(MessagePath.COMMAND_EVENT_BROADCAST_DISABLE.getMessage(globalEvent.getName()));
            }
        }
        this.refreshDelayedEvents();
    }

    public void cancelEvent(String name) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return;
        }
        if (globalEvent.isActive()) {
            this.notifyAllPlayers(MessagePath.COMMAND_EVENT_BROADCAST_END.getMessage(globalEvent.getName()), false);
            ArrayList<String> eventEffectNames = new ArrayList<String>();
            ArrayList<String> eventEffectDescriptions = new ArrayList<String>();
            for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                if (!globalEvent.hasEffect(effect)) continue;
                eventEffectNames.add(effect.getTitle());
                eventEffectDescriptions.add(effect.getDescription());
            }
            KonquestGlobalEventEndEvent invokeEvent = new KonquestGlobalEventEndEvent(this.konquest, globalEvent.getName(), 0.0, eventEffectNames, eventEffectDescriptions);
            Konquest.callKonquestEvent(invokeEvent);
        }
        this.removeEvent(globalEvent);
        this.refreshDelayedEvents();
    }

    public void startEvent(String name) {
        KonGlobalEvent globalEvent = this.getEvent(name);
        if (globalEvent == null) {
            return;
        }
        globalEvent.setEnabled(true);
        Date now = new Date();
        globalEvent.setStart(now.getTime());
        this.refreshDelayedEvents();
    }

    private void removeEvent(KonGlobalEvent event) {
        String eventName = event.getName();
        this.events.remove(event);
        ChatUtil.printConsole("Removed Global Event " + eventName);
    }

    private boolean addEvent(KonGlobalEvent event) {
        if (this.events.contains(event)) {
            return false;
        }
        if (this.isEvent(event.getName())) {
            return false;
        }
        String eventName = event.getName();
        this.events.add(event);
        ChatUtil.printConsole("Added Global Event " + eventName);
        return true;
    }

    private void notifyAllPlayers(String message, boolean type) {
        for (KonPlayer onlinePlayer : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (type) {
                Konquest.playNotificationGoodSound(onlinePlayer.getBukkitPlayer());
                continue;
            }
            Konquest.playNotificationBadSound(onlinePlayer.getBukkitPlayer());
        }
        ChatUtil.sendBroadcast(message);
    }

    private void loadEvents() {
        FileConfiguration eventsConfig = this.konquest.getConfigManager().getConfig("global-events");
        if (eventsConfig.get("global-events") == null) {
            ChatUtil.printConsoleError("Failed to load any global events from global-events.yml! Check file permissions.");
            this.isEventDataNull = true;
            return;
        }
        ConfigurationSection eventsSection = eventsConfig.getConfigurationSection("global-events");
        for (String eventName : eventsConfig.getConfigurationSection("global-events").getKeys(false)) {
            ConfigurationSection eventSection = eventsSection.getConfigurationSection(eventName);
            boolean isEnabled = eventSection.getBoolean("enabled");
            long startTime = eventSection.getLong("start");
            long durationTime = eventSection.getLong("duration");
            long repetitionTime = eventSection.getLong("repetition");
            List eventEffects = eventSection.getStringList("effects");
            KonGlobalEvent globalEvent = new KonGlobalEvent(eventName);
            globalEvent.setEnabled(isEnabled);
            globalEvent.setStart(startTime);
            globalEvent.setDuration(durationTime);
            globalEvent.setRepetition(repetitionTime);
            for (String effectName : eventEffects) {
                globalEvent.addEffect(KonGlobalEventEffect.getEffect(effectName));
            }
            if (this.addEvent(globalEvent)) {
                ChatUtil.printDebug("Loaded global event " + eventName);
                continue;
            }
            String message = "Could not load global event " + eventName + ", global-events.yml may be corrupted and needs to be deleted.";
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
        }
    }

    public void saveEvents() {
        if (this.isEventDataNull && this.events.isEmpty()) {
            ChatUtil.printConsoleError("Aborted saving global event data because a problem was encountered while loading data from global-events.yml");
            return;
        }
        YamlConfiguration newSaveConfig = new YamlConfiguration();
        ConfigurationSection root = newSaveConfig.createSection("global-events");
        try {
            for (KonGlobalEvent event : this.events) {
                ConfigurationSection eventSection = root.createSection(event.getName());
                eventSection.set("enabled", (Object)event.isEnabled());
                eventSection.set("start", (Object)event.getStartTime());
                eventSection.set("duration", (Object)event.getDurationTime());
                eventSection.set("repetition", (Object)event.getRepetitionTime());
                ArrayList<String> eventEffectNames = new ArrayList<String>();
                for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                    if (!event.hasEffect(effect)) continue;
                    eventEffectNames.add(effect.toString());
                }
                eventSection.set("effects", eventEffectNames);
            }
            FileConfiguration eventsConfig = this.konquest.getConfigManager().getConfig("global-events");
            eventsConfig.set("global-events", newSaveConfig.get("global-events"));
            if (!this.events.isEmpty()) {
                ChatUtil.printConsole("Saved Global Events");
            }
        }
        catch (Error | Exception internalError) {
            ChatUtil.printConsoleError("Failed to save global events, report this as a bug to the plugin author!");
            internalError.printStackTrace();
        }
    }
}

