/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.hook.BlueMapHook;
import com.github.rumsfield.konquest.hook.ChestShopHook;
import com.github.rumsfield.konquest.hook.DiscordSrvHook;
import com.github.rumsfield.konquest.hook.DynmapHook;
import com.github.rumsfield.konquest.hook.EssentialsXHook;
import com.github.rumsfield.konquest.hook.LuckPermsHook;
import com.github.rumsfield.konquest.hook.PlaceholderAPIHook;
import com.github.rumsfield.konquest.hook.PluginHook;
import com.github.rumsfield.konquest.hook.ProtocolLibHook;
import com.github.rumsfield.konquest.hook.QuickShopHook;
import com.github.rumsfield.konquest.hook.SquaremapHook;
import com.github.rumsfield.konquest.hook.WorldGuardHook;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class IntegrationManager {
    private final ArrayList<PluginHook> hooks = new ArrayList();
    private final LuckPermsHook luckpermsHook;
    private final ChestShopHook chestshopHook;
    private final QuickShopHook quickshopHook;
    private final DiscordSrvHook discordsrvHook;
    private final DynmapHook dynmapHook;
    private final BlueMapHook bluemapHook;
    private final SquaremapHook squaremapHook;
    private final WorldGuardHook worldguardHook;
    private final ProtocolLibHook protocollibHook;
    private final PlaceholderAPIHook placeholderapiHook;
    private final EssentialsXHook essentialsXHook;

    public IntegrationManager(Konquest konquest) {
        this.luckpermsHook = new LuckPermsHook(konquest);
        this.chestshopHook = new ChestShopHook(konquest);
        this.quickshopHook = new QuickShopHook(konquest);
        this.discordsrvHook = new DiscordSrvHook(konquest);
        this.dynmapHook = new DynmapHook(konquest);
        this.bluemapHook = new BlueMapHook(konquest);
        this.squaremapHook = new SquaremapHook(konquest);
        this.worldguardHook = new WorldGuardHook(konquest);
        this.protocollibHook = new ProtocolLibHook();
        this.placeholderapiHook = new PlaceholderAPIHook();
        this.essentialsXHook = new EssentialsXHook(konquest);
        this.hooks.add(this.protocollibHook);
        this.hooks.add(this.placeholderapiHook);
        this.hooks.add(this.essentialsXHook);
        this.hooks.add(this.luckpermsHook);
        this.hooks.add(this.dynmapHook);
        this.hooks.add(this.bluemapHook);
        this.hooks.add(this.squaremapHook);
        this.hooks.add(this.worldguardHook);
        this.hooks.add(this.discordsrvHook);
        this.hooks.add(this.quickshopHook);
        this.hooks.add(this.chestshopHook);
    }

    public void initialize() {
        ChatUtil.printConsoleAlert("Integrated Plugin Status...");
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        for (PluginHook hook : this.hooks) {
            int status = 0;
            if (!hook.isEnabled()) {
                status = hook.reload();
            }
            statusList.add(status);
        }
        for (int i = 0; i < this.hooks.size(); ++i) {
            PluginHook hook;
            hook = this.hooks.get(i);
            int code = (Integer)statusList.get(i);
            String hookStatus = String.format(String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.RESET) + "%-30s -> %s", hook.getPluginName(), this.getStatus(code));
            Bukkit.getServer().getConsoleSender().sendMessage(hookStatus);
        }
    }

    public void disable() {
        for (PluginHook hook : this.hooks) {
            hook.shutdown();
        }
        ChatUtil.printDebug("Integration Manager is disabled");
    }

    private String getStatus(int code) {
        Object result = "";
        switch (code) {
            case 0: {
                result = String.valueOf(ChatColor.DARK_GREEN) + "Active";
                break;
            }
            case 1: {
                result = String.valueOf(ChatColor.DARK_AQUA) + "Not Loaded";
                break;
            }
            case 2: {
                result = String.valueOf(ChatColor.LIGHT_PURPLE) + "Disabled";
                break;
            }
            case 3: {
                result = String.valueOf(ChatColor.GRAY) + "Inactive";
                break;
            }
            case 4: {
                result = String.valueOf(ChatColor.RED) + "Unsupported Plugin";
                break;
            }
            default: {
                result = String.valueOf(ChatColor.DARK_RED) + "Failed";
            }
        }
        return result;
    }

    public LuckPermsHook getLuckPerms() {
        return this.luckpermsHook;
    }

    public ChestShopHook getChestShop() {
        return this.chestshopHook;
    }

    public QuickShopHook getQuickShop() {
        return this.quickshopHook;
    }

    public DiscordSrvHook getDiscordSrv() {
        return this.discordsrvHook;
    }

    public DynmapHook getDynmap() {
        return this.dynmapHook;
    }

    public BlueMapHook getBlueMap() {
        return this.bluemapHook;
    }

    public SquaremapHook getSquaremap() {
        return this.squaremapHook;
    }

    public WorldGuardHook getWorldGuard() {
        return this.worldguardHook;
    }

    public ProtocolLibHook getProtocolLib() {
        return this.protocollibHook;
    }

    public PlaceholderAPIHook getPlaceholderAPI() {
        return this.placeholderapiHook;
    }

    public EssentialsXHook getEssentialsXAPI() {
        return this.essentialsXHook;
    }
}

