/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.KonquestAPI;
import com.github.rumsfield.konquest.api.event.kingdom.KonquestKingdomConquerEvent;
import com.github.rumsfield.konquest.api.event.kingdom.KonquestKingdomCreateEvent;
import com.github.rumsfield.konquest.api.event.kingdom.KonquestKingdomDiplomacyEvent;
import com.github.rumsfield.konquest.api.event.kingdom.KonquestKingdomDisbandEvent;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerExileEvent;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerKingdomEvent;
import com.github.rumsfield.konquest.api.event.town.KonquestTownDestroyPostEvent;
import com.github.rumsfield.konquest.api.manager.KonquestKingdomManager;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.api.model.KonquestKingdom;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.api.model.KonquestPlayer;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.api.model.KonquestTown;
import com.github.rumsfield.konquest.api.model.KonquestUpgrade;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonKingdomScoreAttributes;
import com.github.rumsfield.konquest.model.KonLeaderboard;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPlayerScoreAttributes;
import com.github.rumsfield.konquest.model.KonPlot;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonStats;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonTownOption;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.DiplomacyTicket;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.LoadingPrinter;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KingdomManager
implements KonquestKingdomManager,
Timeable {
    private final Konquest konquest;
    private final HashMap<String, KonKingdom> kingdomMap;
    private KonKingdom barbarians;
    private KonKingdom neutrals;
    private final HashMap<PotionEffectType, Integer> townNerfs;
    private Material townCriticalBlock;
    private int maxCriticalHits;
    private final HashSet<Material> armorBlocks;
    private boolean isArmorBlockWhitelist;
    private int joinCooldownSeconds;
    private int exileCooldownSeconds;
    private final HashMap<UUID, Integer> joinPlayerCooldowns;
    private final HashMap<UUID, Integer> exilePlayerCooldowns;
    private final ArrayList<DiplomacyTicket> diplomacyTickets;
    private boolean isKingdomDataNull;
    private final Timer payTimer;
    private boolean isGlobalEventWar;
    private boolean isGlobalEventPeace;
    private boolean isAdminOnly;
    private long payIntervalSeconds;
    private double payPerChunk;
    private double payPerResident;
    private double payLimit;
    private int payPercentOfficer;
    private int payPercentMaster;
    private double costCreate;
    private double costRename;
    private double costTemplate;
    private boolean discountEnable;
    private int discountPercent;
    private boolean discountStack;
    private double costDiplomacyWar;
    private double costDiplomacyPeace;
    private double costDiplomacyTrade;
    private double costDiplomacyAlliance;
    private double costCapitalSwap;
    private boolean capitalSwapEnable;
    private boolean capitalSwapWar;
    private double capitalSwapWarmup;
    private boolean townDestroyLordEnable;
    private boolean townDestroyMasterEnable;
    private boolean townPurchaseEnable;

    public KingdomManager(Konquest konquest) {
        this.konquest = konquest;
        this.kingdomMap = new HashMap();
        this.barbarians = null;
        this.neutrals = null;
        this.townNerfs = new HashMap();
        this.townCriticalBlock = Material.OBSIDIAN;
        this.maxCriticalHits = 12;
        this.armorBlocks = new HashSet();
        this.isArmorBlockWhitelist = false;
        this.joinCooldownSeconds = 0;
        this.exileCooldownSeconds = 0;
        this.joinPlayerCooldowns = new HashMap();
        this.exilePlayerCooldowns = new HashMap();
        this.diplomacyTickets = new ArrayList();
        this.isKingdomDataNull = false;
        this.isGlobalEventWar = false;
        this.isGlobalEventPeace = false;
        this.isAdminOnly = false;
        this.payIntervalSeconds = 0L;
        this.payPerChunk = 0.0;
        this.payPerResident = 0.0;
        this.payLimit = 0.0;
        this.payPercentOfficer = 0;
        this.payPercentMaster = 0;
        this.costCreate = 0.0;
        this.costRename = 0.0;
        this.costTemplate = 0.0;
        this.costDiplomacyWar = 0.0;
        this.costDiplomacyPeace = 0.0;
        this.costDiplomacyTrade = 0.0;
        this.costDiplomacyAlliance = 0.0;
        this.costCapitalSwap = 0.0;
        this.payTimer = new Timer(this);
    }

    public void initialize() {
        this.barbarians = new KonKingdom(MessagePath.LABEL_BARBARIANS.getMessage(new Object[0]), this.konquest);
        this.neutrals = new KonKingdom(MessagePath.LABEL_NEUTRALS.getMessage(new Object[0]), this.konquest);
        this.loadArmorBlacklist();
        this.loadJoinExileCooldowns();
        this.loadKingdoms();
        this.makeTownNerfs();
        ChatUtil.printDebug("Kingdom Manager is ready");
    }

    public void loadOptions() {
        this.isAdminOnly = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_CREATE_ADMIN_ONLY.getPath());
        this.payIntervalSeconds = this.konquest.getCore().getLong(CorePath.FAVOR_KINGDOMS_PAY_INTERVAL_SECONDS.getPath());
        this.payPerChunk = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_PAY_PER_CHUNK.getPath());
        this.payPerResident = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_PAY_PER_RESIDENT.getPath());
        this.payLimit = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_PAY_LIMIT.getPath());
        this.payPercentOfficer = this.konquest.getCore().getInt(CorePath.FAVOR_KINGDOMS_BONUS_OFFICER_PERCENT.getPath());
        this.payPercentMaster = this.konquest.getCore().getInt(CorePath.FAVOR_KINGDOMS_BONUS_MASTER_PERCENT.getPath());
        this.costCreate = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_COST_CREATE.getPath());
        this.costRename = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_COST_RENAME.getPath());
        this.costTemplate = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_COST_TEMPLATE.getPath());
        this.costDiplomacyWar = this.konquest.getCore().getDouble(CorePath.FAVOR_DIPLOMACY_COST_WAR.getPath());
        this.costDiplomacyPeace = this.konquest.getCore().getDouble(CorePath.FAVOR_DIPLOMACY_COST_PEACE.getPath());
        this.costDiplomacyTrade = this.konquest.getCore().getDouble(CorePath.FAVOR_DIPLOMACY_COST_TRADE.getPath());
        this.costDiplomacyAlliance = this.konquest.getCore().getDouble(CorePath.FAVOR_DIPLOMACY_COST_ALLIANCE.getPath());
        this.costCapitalSwap = this.konquest.getCore().getDouble(CorePath.FAVOR_KINGDOMS_COST_CAPITAL_SWAP.getPath());
        this.payPerChunk = this.payPerChunk < 0.0 ? 0.0 : this.payPerChunk;
        this.payPerResident = this.payPerResident < 0.0 ? 0.0 : this.payPerResident;
        this.payLimit = this.payLimit < 0.0 ? 0.0 : this.payLimit;
        this.costCreate = this.costCreate < 0.0 ? 0.0 : this.costCreate;
        this.costRename = this.costRename < 0.0 ? 0.0 : this.costRename;
        this.costTemplate = this.costTemplate < 0.0 ? 0.0 : this.costTemplate;
        this.costDiplomacyWar = Math.max(this.costDiplomacyWar, 0.0);
        this.costDiplomacyPeace = Math.max(this.costDiplomacyPeace, 0.0);
        this.costDiplomacyTrade = Math.max(this.costDiplomacyTrade, 0.0);
        this.costDiplomacyAlliance = Math.max(this.costDiplomacyAlliance, 0.0);
        this.costCapitalSwap = Math.max(this.costCapitalSwap, 0.0);
        this.payPercentOfficer = Math.max(this.payPercentOfficer, 0);
        this.payPercentOfficer = Math.min(this.payPercentOfficer, 100);
        this.payPercentMaster = Math.max(this.payPercentMaster, 0);
        this.payPercentMaster = Math.min(this.payPercentMaster, 100);
        this.payTimer.stopTimer();
        if (this.payIntervalSeconds > 0L) {
            this.payTimer.setTime((int)this.payIntervalSeconds);
            this.payTimer.startLoopTimer();
        }
        this.capitalSwapEnable = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_CAPITAL_SWAP_ENABLE.getPath());
        this.capitalSwapWar = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_CAPITAL_SWAP_WAR.getPath());
        this.capitalSwapWarmup = this.konquest.getCore().getDouble(CorePath.KINGDOMS_CAPITAL_SWAP_WARMUP.getPath());
        this.townDestroyLordEnable = this.konquest.getCore().getBoolean(CorePath.TOWNS_ALLOW_DESTROY_LORD.getPath());
        this.townDestroyMasterEnable = this.konquest.getCore().getBoolean(CorePath.TOWNS_ALLOW_DESTROY_MASTER.getPath());
        this.townPurchaseEnable = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PURCHASE_TOWNS.getPath());
        this.discountEnable = this.konquest.getCore().getBoolean(CorePath.TOWNS_DISCOUNT_ENABLE.getPath());
        this.discountPercent = this.konquest.getCore().getInt(CorePath.TOWNS_DISCOUNT_PERCENT.getPath());
        this.discountStack = this.konquest.getCore().getBoolean(CorePath.TOWNS_DISCOUNT_STACK.getPath());
        this.discountPercent = Math.max(this.discountPercent, 0);
        this.discountPercent = Math.min(this.discountPercent, 100);
        for (KonKingdom kingdom : this.getKingdoms()) {
            for (KonTown konTown : kingdom.getCapitalTowns()) {
                konTown.refreshOptionOverrides();
            }
        }
        boolean showOptionList = false;
        FileConfiguration townOptionsConfig = this.konquest.getConfigManager().getConfig("town-options");
        ConfigurationSection rootSection = townOptionsConfig.getConfigurationSection("town-options");
        if (rootSection != null) {
            for (String townSectionName : rootSection.getKeys(false)) {
                if (townSectionName.equals("global") || this.isTown(townSectionName) || this.isCapital(townSectionName)) {
                    for (String optionName : rootSection.getConfigurationSection(townSectionName).getKeys(false)) {
                        if (KonTownOption.getOption(optionName) != null) continue;
                        ChatUtil.printConsoleError("Invalid option \"" + optionName + "\" for entry \"" + townSectionName + "\" in town-options.yml, must match a Town Option.");
                        showOptionList = true;
                    }
                    continue;
                }
                ChatUtil.printConsoleError("Invalid entry \"" + townSectionName + "\" in town-options.yml, must match a town name, kingdom name, or global.");
            }
            if (showOptionList) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (KonTownOption option : KonTownOption.values()) {
                    arrayList.add(option.toString());
                }
                ChatUtil.printConsoleError("Town Option names are: " + HelperUtil.formatCommaSeparatedList(arrayList));
            }
        }
    }

    public String getKingdomPayTime() {
        String noColor = "";
        int timerCount = Math.max(this.payTimer.getTime(), 0);
        return HelperUtil.getTimeFormat(timerCount, noColor);
    }

    public double getCostCreate() {
        return this.costCreate;
    }

    public double getCostRename() {
        return this.costRename;
    }

    public double getCostTemplate() {
        return this.costTemplate;
    }

    public boolean getIsDiscountEnable() {
        return this.discountEnable;
    }

    public int getDiscountPercent() {
        return this.discountPercent;
    }

    public boolean getIsDiscountStack() {
        return this.discountStack;
    }

    public boolean getIsCapitalSwapEnable() {
        return this.capitalSwapEnable;
    }

    public double getCostCapitalSwap() {
        return this.costCapitalSwap;
    }

    public boolean getIsTownDestroyLordEnable() {
        return this.townDestroyLordEnable;
    }

    public boolean getIsTownDestroyMasterEnable() {
        return this.townDestroyMasterEnable;
    }

    public boolean getIsTownPurchaseEnable() {
        return this.townPurchaseEnable;
    }

    public boolean isKingdomCreateAdminOnly() {
        return this.isAdminOnly;
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Kingdom Pay Timer ended with null taskID!");
        } else if (taskID == this.payTimer.getTaskID()) {
            ChatUtil.printDebug("Kingdom Pay timer completed a new cycle");
            this.disbursePayments();
        }
    }

    private void disbursePayments() {
        HashMap<UUID, Double> payments = new HashMap<UUID, Double>();
        for (KonPlayer onlinePlayer : this.konquest.getPlayerManager().getPlayersOnline()) {
            payments.put(onlinePlayer.getBukkitPlayer().getUniqueId(), 0.0);
        }
        ChatUtil.printDebug("Evaluating kingdom payments...");
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            ChatUtil.printDebug("  Kingdom of " + kingdom.getName());
            int kingdomLand = kingdom.getNumLand();
            int kingdomPopulation = kingdom.getNumMembers();
            double baseBonus = (double)kingdomLand * this.payPerChunk + (double)kingdomPopulation * this.payPerResident;
            double masterBonus = baseBonus * ((double)this.payPercentMaster / 100.0);
            double officerBonus = baseBonus * ((double)this.payPercentOfficer / 100.0);
            UUID masterId = kingdom.getMaster();
            if (payments.containsKey(masterId)) {
                payments.put(masterId, (Double)payments.get(masterId) + masterBonus);
                Player masterPlayer = Bukkit.getPlayer((UUID)masterId);
                String masterName = masterPlayer == null ? "unknown" : masterPlayer.getName();
                ChatUtil.printDebug("  + " + masterName + " Master Bonus = " + masterBonus);
            }
            for (OfflinePlayer officer : kingdom.getPlayerOfficersOnly()) {
                UUID officerId = officer.getUniqueId();
                if (!payments.containsKey(officerId)) continue;
                payments.put(officerId, (Double)payments.get(officerId) + officerBonus);
                Player officerPlayer = Bukkit.getPlayer((UUID)officerId);
                String officerName = officerPlayer == null ? "unknown" : officerPlayer.getName();
                ChatUtil.printDebug("  + " + officerName + " Officer Bonus = " + officerBonus);
            }
            for (KonTown town : kingdom.getCapitalTowns()) {
                int townLand = town.getNumLand();
                int townPopulation = town.getNumResidents();
                double townPay = (double)townLand * this.payPerChunk + (double)townPopulation * this.payPerResident;
                UUID lordId = town.getLord();
                if (!payments.containsKey(lordId)) continue;
                payments.put(lordId, (Double)payments.get(lordId) + townPay);
                Player lordPlayer = Bukkit.getPlayer((UUID)lordId);
                String lordName = lordPlayer == null ? "unknown" : lordPlayer.getName();
                ChatUtil.printDebug("  + " + lordName + " Town Lord of " + town.getName() + " = " + townPay);
            }
        }
        ChatUtil.printDebug("Depositing kingdom payments...");
        boolean isEssentialsEnabled = this.konquest.getIntegrationManager().getEssentialsXAPI().isEnabled();
        boolean isAfkPayEnabled = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_ESSENTIALSX_OPTIONS_ENABLE_AFK_PAYMENTS.getPath(), true);
        for (UUID id : payments.keySet()) {
            String playerName;
            double payAmount = (Double)payments.get(id);
            if (this.payLimit > 0.0 && payAmount > this.payLimit) {
                payAmount = this.payLimit;
            }
            Player bukkitPlayer = Bukkit.getPlayer((UUID)id);
            KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
            if (!(payAmount > 0.0) || player == null) continue;
            String string = playerName = bukkitPlayer == null ? "unknown" : bukkitPlayer.getName();
            if (isEssentialsEnabled && !isAfkPayEnabled && player.isAfk()) {
                ChatUtil.printDebug("  " + playerName + " Skipped payment while AFK");
                continue;
            }
            ChatUtil.printDebug("  " + playerName + " = " + payAmount);
            if (!KonquestPlugin.depositPlayer((OfflinePlayer)bukkitPlayer, payAmount)) continue;
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_PAY.getMessage(new Object[0]));
        }
    }

    private int validateTownLocationConstraints(Location loc) {
        int searchDistance;
        if (!this.konquest.isWorldValid(loc.getWorld())) {
            ChatUtil.printDebug("Failed to add town, invalid world: " + loc.getWorld().getName());
            return 1;
        }
        int min_distance_sanc = this.konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_SANCTUARY.getPath());
        int min_distance_town = this.konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
        int minDistance = Integer.MAX_VALUE;
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            searchDistance = HelperUtil.chunkDistance(loc, kingdom.getCapital().getCenterLoc());
            if (searchDistance != -1 && min_distance_town > 0 && searchDistance < min_distance_town) {
                ChatUtil.printDebug("Failed to add town, too close to capital " + kingdom.getCapital().getName());
                return 2;
            }
            if (searchDistance != -1 && searchDistance < minDistance) {
                minDistance = searchDistance;
            }
            for (KonTown town : kingdom.getTowns()) {
                searchDistance = HelperUtil.chunkDistance(loc, town.getCenterLoc());
                if (searchDistance != -1 && min_distance_town > 0 && searchDistance < min_distance_town) {
                    ChatUtil.printDebug("Failed to add town, too close to town " + town.getName());
                    return 2;
                }
                if (searchDistance == -1 || searchDistance >= minDistance) continue;
                minDistance = searchDistance;
            }
        }
        for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
            searchDistance = HelperUtil.chunkDistance(loc, ruin.getCenterLoc());
            if (searchDistance != -1 && min_distance_town > 0 && searchDistance < min_distance_town) {
                ChatUtil.printDebug("Failed to add town, too close to ruin " + ruin.getName());
                return 2;
            }
            if (searchDistance == -1 || searchDistance >= minDistance) continue;
            minDistance = searchDistance;
        }
        for (KonSanctuary sanctuary : this.konquest.getSanctuaryManager().getSanctuaries()) {
            searchDistance = HelperUtil.chunkDistance(loc, sanctuary.getCenterLoc());
            if (searchDistance != -1 && min_distance_sanc > 0 && searchDistance < min_distance_sanc) {
                ChatUtil.printDebug("Failed to add town, too close to sanctuary " + sanctuary.getName());
                return 2;
            }
            if (searchDistance == -1 || searchDistance >= minDistance) continue;
            minDistance = searchDistance;
        }
        if (minDistance != Integer.MAX_VALUE) {
            int maxLimit = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_DISTANCE_ALL.getPath(), 0);
            if (maxLimit > 0 && minDistance > maxLimit) {
                ChatUtil.printDebug("Failed to add town, too far from other towns and capitals");
                return 3;
            }
            int radius = this.konquest.getCore().getInt(CorePath.TOWNS_INIT_RADIUS.getPath(), 2);
            if (radius < 1) {
                radius = 1;
            }
            ChatUtil.printDebug("Checking for chunk conflicts with radius " + radius);
            for (Point point : HelperUtil.getAreaPoints(loc, radius)) {
                if (!this.konquest.getTerritoryManager().isChunkClaimed(point, loc.getWorld())) continue;
                ChatUtil.printDebug("Found a chunk conflict");
                return 4;
            }
        }
        return 0;
    }

    public void teleportAwayFromCenter(KonTown town) {
        for (KonPlayer occupant : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!town.isLocInsideCenterChunk(occupant.getBukkitPlayer().getLocation())) continue;
            final Location tpLoc = this.konquest.getSafeRandomCenteredLocation(town.getCenterLoc(), 2);
            if (tpLoc == null) {
                ChatUtil.printDebug("Failed to teleport player " + occupant.getBukkitPlayer().getName() + " to a safe location.");
                continue;
            }
            double x0 = tpLoc.getX();
            double x1 = town.getCenterLoc().getX();
            double z0 = tpLoc.getZ();
            double z1 = town.getCenterLoc().getZ();
            float yaw = (float)(180.0 - Math.atan2(x0 - x1, z0 - z1) * 180.0 / Math.PI);
            tpLoc.setYaw(yaw);
            if (occupant.getBukkitPlayer().isInsideVehicle()) {
                ChatUtil.printDebug("Settling occupant player is in a vehicle, type " + String.valueOf(occupant.getBukkitPlayer().getVehicle().getType()));
                final Entity vehicle = occupant.getBukkitPlayer().getVehicle();
                final List passengers = vehicle.getPassengers();
                occupant.getBukkitPlayer().leaveVehicle();
                occupant.getBukkitPlayer().teleport(tpLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                new BukkitRunnable(){

                    public void run() {
                        vehicle.teleport(tpLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                        for (Entity e : passengers) {
                            vehicle.addPassenger(e);
                        }
                    }
                }.runTaskLater((Plugin)this.konquest.getPlugin(), 10L);
                continue;
            }
            occupant.getBukkitPlayer().teleport(tpLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int createKingdom(Location centerLocation, String kingdomName, String templateName, KonPlayer master, boolean isAdmin) {
        if (this.isAdminOnly && !isAdmin) {
            return -1;
        }
        Player bukkitPlayer = master.getBukkitPlayer();
        if (this.konquest.validateNameConstraints(kingdomName) != 0) {
            return 1;
        }
        if (!isAdmin) {
            if (!master.isBarbarian()) {
                return 2;
            }
            for (KonKingdom kingdom : this.kingdomMap.values()) {
                if (!kingdom.isMember(bukkitPlayer.getUniqueId())) continue;
                return 2;
            }
        }
        if (!this.konquest.getSanctuaryManager().isValidTemplate(templateName)) {
            return 4;
        }
        KonMonumentTemplate template = this.konquest.getSanctuaryManager().getTemplate(templateName);
        double totalCost = this.costCreate + template.getCost();
        if (!isAdmin && totalCost > 0.0 && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < totalCost) {
            return 3;
        }
        int locStatus = this.validateTownLocationConstraints(centerLocation);
        if (locStatus != 0) {
            return locStatus + 4;
        }
        this.kingdomMap.put(kingdomName, new KonKingdom(centerLocation, kingdomName, this.konquest));
        KonKingdom newKingdom = this.kingdomMap.get(kingdomName);
        if (newKingdom == null) return -1;
        newKingdom.setMonumentTemplate(template);
        int initStatus = newKingdom.initCapital();
        if (initStatus == 0) {
            this.konquest.getTerritoryManager().addAllTerritory(centerLocation.getWorld(), newKingdom.getCapital().getChunkList());
            this.konquest.getMapHandler().drawUpdateTerritory(newKingdom.getCapital());
            this.konquest.getIntegrationManager().getDiscordSrv().addKingdomRole(newKingdom.getName(), newKingdom.getWebColorFormal());
            if (isAdmin) {
                newKingdom.setIsAdminOperated(true);
                newKingdom.setIsOpen(true);
            } else {
                int assignStatus;
                newKingdom.setIsAdminOperated(false);
                if (totalCost > 0.0 && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, totalCost)) {
                    this.konquest.getAccomplishmentManager().modifyPlayerStat(master, KonStatsType.FAVOR, (int)totalCost);
                }
                if ((assignStatus = this.assignPlayerKingdom(bukkitPlayer.getUniqueId(), kingdomName, true)) != 0) {
                    ChatUtil.printDebug("Failed to assign player " + bukkitPlayer.getName() + " to created kingdom " + kingdomName + ", status code " + assignStatus);
                }
                newKingdom.forceMaster(bukkitPlayer.getUniqueId());
                newKingdom.getCapital().setPlayerLord((OfflinePlayer)bukkitPlayer);
            }
        } else {
            ChatUtil.printDebug("Kingdom capital init failed, error code: " + initStatus);
            newKingdom.removeCapital();
            this.kingdomMap.remove(kingdomName);
            return 10 + initStatus;
        }
        this.konquest.getTerritoryManager().updatePlayerBorderParticles(newKingdom.getCapital().getCenterLoc());
        newKingdom.getCapital().updateBarPlayers();
        Konquest.callKonquestEvent(new KonquestKingdomCreateEvent(this.konquest, newKingdom, master, centerLocation, isAdmin));
        return 0;
    }

    @Override
    public boolean removeKingdom(String name) {
        if (this.kingdomMap.containsKey(name)) {
            KonKingdom kingdom = this.kingdomMap.get(name);
            kingdom.clearMaster();
            kingdom.clearMembers();
            for (KonOfflinePlayer member : this.konquest.getPlayerManager().getAllPlayersInKingdom(kingdom)) {
                String playerName = member.getOfflineBukkitPlayer().getName();
                member.setKingdom(this.getBarbarians());
                member.setExileKingdom(this.getBarbarians());
                member.setBarbarian(true);
                if (member instanceof KonPlayer) {
                    ChatUtil.printDebug("Removing online KonPlayer " + playerName + " to barbarian.");
                    KonPlayer onlinePlayer = (KonPlayer)member;
                    onlinePlayer.getPlayerPrefix().setEnable(false);
                    this.konquest.updateNamePackets(onlinePlayer);
                    ChatUtil.sendNotice((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.GENERIC_NOTICE_FORCE_BARBARIAN.getMessage(new Object[0]));
                } else {
                    ChatUtil.printDebug("Removing offline KonOfflinePlayer " + playerName + " to barbarian.");
                }
                this.konquest.getDatabaseThread().getDatabase().setOfflinePlayer(member);
                this.konquest.getIntegrationManager().getDiscordSrv().refreshPlayerRoles(member);
            }
            for (KonTown town : kingdom.getTowns()) {
                this.removeTown(town.getName(), kingdom.getName());
            }
            kingdom.clearActiveRelations();
            kingdom.clearRelationRequests();
            for (KonKingdom otherKingdom : this.kingdomMap.values()) {
                otherKingdom.removeActiveRelation(kingdom);
                otherKingdom.removeRelationRequest(kingdom);
            }
            kingdom = null;
            KonKingdom oldKingdom = this.kingdomMap.remove(name);
            if (oldKingdom != null) {
                oldKingdom.removeCapital();
                this.konquest.getTerritoryManager().removeAllTerritory(oldKingdom.getCapital().getWorld(), oldKingdom.getCapital().getChunkList().keySet());
                this.konquest.getMapHandler().drawRemoveTerritory(oldKingdom.getCapital());
                this.konquest.getIntegrationManager().getDiscordSrv().removeKingdomRole(oldKingdom.getName());
                oldKingdom = null;
                for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
                    this.konquest.getTerritoryManager().updatePlayerBorderParticles(player);
                }
                ChatUtil.printDebug("Removed Kingdom " + name);
                return true;
            }
            ChatUtil.printDebug("Failed to remove null Kingdom " + name);
        }
        ChatUtil.printDebug("Failed to remove unknown Kingdom " + name);
        return false;
    }

    public int renameKingdom(String oldName, String newName, KonPlayer player, boolean ignoreCost) {
        if (!this.isKingdom(oldName)) {
            return 1;
        }
        if (this.konquest.validateNameConstraints(newName) != 0) {
            return 2;
        }
        if (!ignoreCost && this.costRename > 0.0 && player != null && KonquestPlugin.getBalance((OfflinePlayer)player.getBukkitPlayer()) < this.costRename) {
            return 3;
        }
        KonKingdom oldKingdom = this.getKingdom(oldName);
        String oldKingdomName = oldKingdom.getName();
        for (KonTown town : oldKingdom.getTowns()) {
            this.konquest.getMapHandler().drawRemoveTerritory(town);
        }
        this.konquest.getMapHandler().drawRemoveTerritory(oldKingdom.getCapital());
        this.getKingdom(oldName).setName(newName);
        KonKingdom kingdom = this.kingdomMap.remove(oldName);
        this.kingdomMap.put(newName, kingdom);
        kingdom.getCapital().updateName();
        this.konquest.getMapHandler().drawUpdateTerritory(kingdom.getCapital());
        for (KonTown town : kingdom.getTowns()) {
            this.konquest.getMapHandler().drawUpdateTerritory(town);
        }
        this.konquest.getDatabaseThread().getDatabase().setOfflinePlayers(this.konquest.getPlayerManager().getAllPlayersInKingdom(kingdom));
        this.konquest.getIntegrationManager().getDiscordSrv().changeKingdomRole(oldKingdomName, kingdom.getName(), kingdom.getWebColorFormal());
        if (!ignoreCost && this.costRename > 0.0 && player != null && KonquestPlugin.withdrawPlayer((OfflinePlayer)player.getBukkitPlayer(), this.costRename)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)this.costRename);
        }
        return 0;
    }

    public boolean isKingdomMembershipFull(KonKingdom kingdom) {
        int smallestKingdomPlayerCount;
        int targetKingdomPlayerCount = this.konquest.getPlayerManager().getAllPlayersInKingdom(kingdom).size();
        int config_max_player_diff = this.konquest.getCore().getInt(CorePath.KINGDOMS_MAX_PLAYER_DIFF.getPath(), 0);
        if (config_max_player_diff > 0 && targetKingdomPlayerCount > (smallestKingdomPlayerCount = this.konquest.getPlayerManager().getAllPlayersInKingdom(this.getSmallestKingdomName()).size()) + config_max_player_diff) {
            return true;
        }
        int config_max_player_limit = this.konquest.getCore().getInt(CorePath.KINGDOMS_MAX_PLAYER_LIMIT.getPath(), 0);
        return config_max_player_limit > 0 && targetKingdomPlayerCount >= config_max_player_limit;
    }

    public int isPlayerJoinKingdomAllowed(KonPlayer player, KonKingdom kingdom) {
        UUID id = player.getBukkitPlayer().getUniqueId();
        if (kingdom.equals(player.getKingdom()) || kingdom.isMember(id)) {
            return 1;
        }
        for (KonKingdom otherKingdom : this.getKingdoms()) {
            if (!otherKingdom.isMaster(id)) continue;
            return 2;
        }
        if (this.isPlayerJoinCooldown((OfflinePlayer)player.getBukkitPlayer())) {
            return 3;
        }
        boolean isPerKingdomJoin = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PER_KINGDOM_JOIN_PERMISSIONS.getPath(), false);
        String permission = "konquest.join." + kingdom.getName().toLowerCase();
        if (isPerKingdomJoin && !player.getBukkitPlayer().hasPermission(permission)) {
            return 4;
        }
        boolean isAllowSwitch = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLOW_EXILE_SWITCH.getPath(), false);
        if (!(isAllowSwitch || kingdom.equals(player.getExileKingdom()) || this.getBarbarians().equals(player.getExileKingdom()))) {
            return 5;
        }
        if (this.isKingdomMembershipFull(kingdom)) {
            return 6;
        }
        return 0;
    }

    @Override
    public int assignPlayerKingdom(UUID id, String kingdomName, boolean force) {
        boolean memberStatus;
        KonKingdom playerExileKingdom;
        if (!this.isKingdom(kingdomName)) {
            return 1;
        }
        KonOfflinePlayer offlinePlayer = null;
        KonPlayer onlinePlayer = null;
        boolean isOnline = true;
        onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(id);
        if (onlinePlayer == null) {
            offlinePlayer = this.konquest.getPlayerManager().getOfflinePlayerFromID(id);
            if (offlinePlayer == null) {
                return 9;
            }
            isOnline = false;
        }
        KonKingdom joinKingdom = this.getKingdom(kingdomName);
        KonKingdom playerKingdom = isOnline ? onlinePlayer.getKingdom() : offlinePlayer.getKingdom();
        KonKingdom konKingdom = playerExileKingdom = isOnline ? onlinePlayer.getExileKingdom() : offlinePlayer.getExileKingdom();
        if (joinKingdom.equals(playerKingdom) || joinKingdom.isMember(id)) {
            return 5;
        }
        String oldKingdomName = playerKingdom.getName();
        if (!force) {
            boolean isAllowSwitch;
            boolean isCooldown;
            for (KonKingdom kingdom : this.getKingdoms()) {
                if (!kingdom.isMaster(id)) continue;
                return 6;
            }
            boolean bl = isCooldown = isOnline ? this.isPlayerJoinCooldown((OfflinePlayer)onlinePlayer.getBukkitPlayer()) : this.isPlayerJoinCooldown(offlinePlayer.getOfflineBukkitPlayer());
            if (isCooldown) {
                return 8;
            }
            boolean isPerKingdomJoin = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_PER_KINGDOM_JOIN_PERMISSIONS.getPath(), false);
            if (isOnline && isPerKingdomJoin) {
                String permission = "konquest.join." + joinKingdom.getName().toLowerCase();
                if (!onlinePlayer.getBukkitPlayer().hasPermission(permission)) {
                    return 3;
                }
            }
            if (!((isAllowSwitch = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLOW_EXILE_SWITCH.getPath(), false)) || joinKingdom.equals(playerExileKingdom) || this.getBarbarians().equals(playerExileKingdom))) {
                return 7;
            }
            if (this.isKingdomMembershipFull(joinKingdom)) {
                return 2;
            }
            if (isOnline) {
                KonquestPlayerKingdomEvent invokeEvent = new KonquestPlayerKingdomEvent(this.konquest, onlinePlayer, joinKingdom, onlinePlayer.getExileKingdom());
                Konquest.callKonquestEvent(invokeEvent);
                if (invokeEvent.isCancelled()) {
                    return 4;
                }
            }
        }
        this.konquest.getCampManager().removeCamp(id.toString());
        if (playerKingdom.isCreated()) {
            boolean removeStatus = isOnline ? this.removeKingdomMember(onlinePlayer, playerKingdom, force) : this.removeKingdomMember(offlinePlayer, playerKingdom, force);
            if (removeStatus) {
                if (isOnline) {
                    ChatUtil.sendNotice((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_REMOVE_MEMBER.getMessage(oldKingdomName));
                }
            } else {
                ChatUtil.printDebug("Failed to remove member " + String.valueOf(id) + " from kingdom " + playerKingdom.getName());
                return -1;
            }
        }
        if (!(memberStatus = joinKingdom.addMember(id, false))) {
            ChatUtil.printDebug("Failed to add member " + String.valueOf(id) + " to kingdom " + joinKingdom.getName());
            return -1;
        }
        if (isOnline) {
            onlinePlayer.setKingdom(joinKingdom);
            onlinePlayer.setExileKingdom(joinKingdom);
            onlinePlayer.setBarbarian(false);
            this.addKingdomResidents(onlinePlayer, joinKingdom);
            KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(onlinePlayer.getBukkitPlayer().getLocation());
            if (territory instanceof KonBarDisplayer) {
                ((KonBarDisplayer)((Object)territory)).removeBarPlayer(onlinePlayer);
                ((KonBarDisplayer)((Object)territory)).addBarPlayer(onlinePlayer);
            }
            this.updateKingdomOfflineProtection();
            this.updatePlayerMembershipStats(onlinePlayer);
            this.konquest.updateNamePackets(onlinePlayer);
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(onlinePlayer);
            if (!force) {
                this.applyPlayerJoinCooldown((OfflinePlayer)onlinePlayer.getBukkitPlayer());
            }
        } else {
            offlinePlayer.setKingdom(joinKingdom);
            offlinePlayer.setExileKingdom(joinKingdom);
            offlinePlayer.setBarbarian(false);
            this.addKingdomResidents(offlinePlayer, joinKingdom);
            this.konquest.getDatabaseThread().getDatabase().setOfflinePlayer(offlinePlayer);
        }
        KonOfflinePlayer commonPlayer = isOnline ? onlinePlayer : offlinePlayer;
        this.konquest.getIntegrationManager().getDiscordSrv().refreshPlayerRoles(commonPlayer);
        this.konquest.getMapHandler().drawLabelTerritory(joinKingdom.getCapital());
        this.updateSmallestKingdom();
        return 0;
    }

    @Override
    public int exilePlayerBarbarian(UUID id, boolean teleport, boolean clearStats, boolean isFull, boolean force) {
        OfflinePlayer offlineBukkitPlayer;
        boolean doRemoveStats;
        boolean removeStatus;
        boolean isPlayerBarbarian;
        KonOfflinePlayer offlinePlayer = null;
        KonPlayer onlinePlayer = null;
        boolean isOnline = false;
        onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(id);
        if (onlinePlayer == null) {
            offlinePlayer = this.konquest.getPlayerManager().getOfflinePlayerFromID(id);
            if (offlinePlayer == null) {
                return 9;
            }
        } else {
            isOnline = true;
        }
        KonKingdom oldKingdom = isOnline ? onlinePlayer.getKingdom() : offlinePlayer.getKingdom();
        String oldKingdomName = oldKingdom.getName();
        boolean bl = isPlayerBarbarian = isOnline ? onlinePlayer.isBarbarian() : offlinePlayer.isBarbarian();
        if (isPlayerBarbarian || !oldKingdom.isCreated()) {
            return 1;
        }
        if (!force) {
            for (KonKingdom kingdom : this.getKingdoms()) {
                if (!kingdom.isMaster(id)) continue;
                return 6;
            }
            if (isOnline && this.isPlayerExileCooldown((OfflinePlayer)onlinePlayer.getBukkitPlayer())) {
                return 8;
            }
            KonquestPlayerExileEvent invokeEvent = new KonquestPlayerExileEvent(this.konquest, offlinePlayer, oldKingdom);
            Konquest.callKonquestEvent(invokeEvent);
            if (invokeEvent.isCancelled()) {
                return 4;
            }
        }
        if (!(removeStatus = isOnline ? this.removeKingdomMember(onlinePlayer, oldKingdom, force) : this.removeKingdomMember(offlinePlayer, oldKingdom, force))) {
            ChatUtil.printDebug("Failed to remove member " + id.toString() + " from kingdom " + oldKingdom.getName());
            return -1;
        }
        if (isOnline) {
            World playerWorld = onlinePlayer.getBukkitPlayer().getLocation().getWorld();
            if (teleport && playerWorld != null && this.konquest.isWorldValid(playerWorld)) {
                boolean doWorldSpawn = this.konquest.getCore().getBoolean(CorePath.EXILE_TELEPORT_WORLD_SPAWN.getPath(), false);
                boolean doWildTeleport = this.konquest.getCore().getBoolean(CorePath.EXILE_TELEPORT_WILD.getPath(), true);
                Location exileLoc = null;
                if (doWorldSpawn) {
                    exileLoc = playerWorld.getSpawnLocation();
                } else if (doWildTeleport) {
                    exileLoc = this.konquest.getRandomWildLocation(playerWorld);
                } else {
                    ChatUtil.printDebug("Teleport for player " + onlinePlayer.getBukkitPlayer().getName() + " on exile is disabled.");
                }
                if (exileLoc != null) {
                    this.konquest.telePlayerLocation(onlinePlayer.getBukkitPlayer(), exileLoc);
                    onlinePlayer.getBukkitPlayer().setBedSpawnLocation(exileLoc, true);
                } else {
                    ChatUtil.printDebug("Could not teleport player " + onlinePlayer.getBukkitPlayer().getName() + " on exile, disabled or null location.");
                }
            }
        }
        if ((doRemoveStats = this.konquest.getCore().getBoolean(CorePath.EXILE_REMOVE_STATS.getPath(), true)) && clearStats) {
            if (isOnline) {
                onlinePlayer.getPlayerStats().clearStats();
                onlinePlayer.getPlayerPrefix().setEnable(false);
                ChatUtil.sendNotice((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_EXILE_STATS.getMessage(new Object[0]));
            } else {
                KonStats stats = this.konquest.getDatabaseThread().getDatabase().pullPlayerStats(offlinePlayer.getOfflineBukkitPlayer());
                stats.clearStats();
                this.konquest.getDatabaseThread().getDatabase().pushPlayerStats(offlinePlayer.getOfflineBukkitPlayer(), stats);
            }
        }
        boolean doRemoveFavor = this.konquest.getCore().getBoolean(CorePath.EXILE_REMOVE_FAVOR.getPath(), true);
        OfflinePlayer offlinePlayer2 = offlineBukkitPlayer = isOnline ? onlinePlayer.getOfflineBukkitPlayer() : offlinePlayer.getOfflineBukkitPlayer();
        if (doRemoveFavor) {
            double balance = KonquestPlugin.getBalance(offlineBukkitPlayer);
            KonquestPlugin.withdrawPlayer(offlineBukkitPlayer, balance);
            if (isOnline) {
                ChatUtil.sendNotice((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_EXILE_FAVOR.getMessage(new Object[0]));
            }
        }
        KonKingdom exileKingdom = this.getBarbarians();
        if (!isFull && this.isKingdom(oldKingdomName)) {
            exileKingdom = oldKingdom;
        }
        if (isOnline) {
            onlinePlayer.setIsGlobalChat(true);
            onlinePlayer.setBarbarian(true);
            onlinePlayer.setExileKingdom(exileKingdom);
            onlinePlayer.setKingdom(this.getBarbarians());
            KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(onlinePlayer.getBukkitPlayer().getLocation());
            if (territory instanceof KonBarDisplayer) {
                KonBarDisplayer barDisplayer = (KonBarDisplayer)((Object)territory);
                barDisplayer.removeBarPlayer(onlinePlayer);
                barDisplayer.addBarPlayer(onlinePlayer);
            }
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                town.sendRaidAlert(onlinePlayer);
            }
            this.konquest.updateNamePackets(onlinePlayer);
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(onlinePlayer);
            if (!force) {
                this.applyPlayerExileCooldown((OfflinePlayer)onlinePlayer.getBukkitPlayer());
            }
            ChatUtil.sendNotice((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_EXILE.getMessage(oldKingdomName));
        } else {
            offlinePlayer.setKingdom(this.getBarbarians());
            offlinePlayer.setExileKingdom(exileKingdom);
            offlinePlayer.setBarbarian(true);
            this.konquest.getDatabaseThread().getDatabase().setOfflinePlayer(offlinePlayer);
        }
        KonOfflinePlayer commonPlayer = isOnline ? onlinePlayer : offlinePlayer;
        this.konquest.getIntegrationManager().getDiscordSrv().refreshPlayerRoles(commonPlayer);
        this.konquest.getMapHandler().drawLabelTerritory(this.getKingdom(oldKingdomName).getCapital());
        this.updateSmallestKingdom();
        this.updateKingdomOfflineProtection();
        return 0;
    }

    public boolean menuJoinKingdomRequest(KonPlayer player, KonKingdom kingdom) {
        if (kingdom == null) {
            return false;
        }
        UUID id = player.getBukkitPlayer().getUniqueId();
        if (kingdom.isCreated() && !kingdom.isJoinable() || player.getKingdom().isCreated() && !player.getKingdom().isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int joinCheckStatus = this.isPlayerJoinKingdomAllowed(player, kingdom);
        if (joinCheckStatus != 0) {
            switch (joinCheckStatus) {
                case 1: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_MEMBER.getMessage(new Object[0]));
                    break;
                }
                case 2: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_MASTER.getMessage(new Object[0]));
                    break;
                }
                case 3: {
                    String remainCooldown = this.getJoinCooldownRemainingTimeFormat((OfflinePlayer)player.getBukkitPlayer(), ChatColor.RED);
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_COOLDOWN.getMessage(remainCooldown));
                    break;
                }
                case 4: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]));
                    break;
                }
                case 5: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_SWITCH.getMessage(new Object[0]));
                    break;
                }
                case 6: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_LIMIT.getMessage(kingdom.getName()));
                    break;
                }
                default: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                }
            }
            return false;
        }
        if (kingdom.isOpen() || kingdom.isJoinInviteValid(id)) {
            int status = this.assignPlayerKingdom(id, kingdom.getName(), false);
            kingdom.removeJoinRequest(id);
            if (status != 0) {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                return false;
            }
            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_JOIN.getMessage(player.getBukkitPlayer().getName(), kingdom.getName()));
        } else if (!kingdom.isJoinRequestValid(id)) {
            kingdom.addJoinRequest(id, false);
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_REQUEST_SENT.getMessage(kingdom.getName()));
            this.broadcastOfficers(kingdom, MessagePath.COMMAND_KINGDOM_NOTICE_REQUEST_RECEIVED.getMessage(new Object[0]));
        } else {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_REQUEST_EXISTS.getMessage(kingdom.getName()));
            return false;
        }
        return true;
    }

    public boolean menuRespondKingdomRequest(KonPlayer player, KonOfflinePlayer requester, KonKingdom kingdom, boolean resp) {
        if (kingdom == null) {
            return true;
        }
        OfflinePlayer offlineBukkitPlayer = requester.getOfflineBukkitPlayer();
        UUID id = offlineBukkitPlayer.getUniqueId();
        if (!kingdom.isJoinRequestValid(id)) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            return false;
        }
        kingdom.removeJoinRequest(id);
        if (!resp) {
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_REQUEST_DECLINED.getMessage(offlineBukkitPlayer.getName()));
            if (offlineBukkitPlayer.isOnline()) {
                ChatUtil.sendError((CommandSender)((Player)offlineBukkitPlayer), MessagePath.COMMAND_KINGDOM_ERROR_REQUEST_DENY.getMessage(kingdom.getName()));
            }
            return false;
        }
        if (kingdom.isMember(id)) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_INVITE_MEMBER.getMessage(offlineBukkitPlayer.getName()));
            return false;
        }
        if (kingdom.isCreated() && !kingdom.isJoinable() || requester.getKingdom().isCreated() && !requester.getKingdom().isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int status = this.assignPlayerKingdom(id, kingdom.getName(), false);
        if (status != 0) {
            switch (status) {
                case 2: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_LIMIT.getMessage(kingdom.getName()));
                    break;
                }
                case 3: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]));
                    break;
                }
                case 6: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_MASTER.getMessage(new Object[0]));
                    break;
                }
                case 7: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_SWITCH.getMessage(new Object[0]));
                    break;
                }
                case 8: {
                    String remainCooldown = this.getJoinCooldownRemainingTimeFormat(offlineBukkitPlayer, ChatColor.RED);
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_COOLDOWN.getMessage(remainCooldown));
                    break;
                }
                default: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                }
            }
            return false;
        }
        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_JOIN.getMessage(offlineBukkitPlayer.getName(), kingdom.getName()));
        return true;
    }

    public boolean joinKingdomInvite(KonPlayer player, KonOfflinePlayer invitee, KonKingdom kingdom) {
        if (kingdom == null) {
            return false;
        }
        OfflinePlayer offlineBukkitPlayer = invitee.getOfflineBukkitPlayer();
        UUID id = offlineBukkitPlayer.getUniqueId();
        if (kingdom.isCreated() && !kingdom.isJoinable() || invitee.getKingdom().isCreated() && !invitee.getKingdom().isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (kingdom.isMember(id)) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_INVITE_MEMBER.getMessage(offlineBukkitPlayer.getName()));
            return false;
        }
        if (kingdom.isOpen()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_INVITE_OPEN.getMessage(new Object[0]));
            return false;
        }
        if (kingdom.isJoinRequestValid(id)) {
            int status = this.assignPlayerKingdom(id, kingdom.getName(), false);
            kingdom.removeJoinRequest(id);
            if (status != 0) {
                switch (status) {
                    case 2: {
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_LIMIT.getMessage(kingdom.getName()));
                        break;
                    }
                    case 3: {
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]));
                        break;
                    }
                    case 6: {
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_MASTER.getMessage(new Object[0]));
                        break;
                    }
                    case 7: {
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_SWITCH.getMessage(new Object[0]));
                        break;
                    }
                    case 8: {
                        String remainCooldown = this.getJoinCooldownRemainingTimeFormat(offlineBukkitPlayer, ChatColor.RED);
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_COOLDOWN.getMessage(remainCooldown));
                        break;
                    }
                    default: {
                        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                    }
                }
                return false;
            }
            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_JOIN.getMessage(offlineBukkitPlayer.getName(), kingdom.getName()));
        } else if (!kingdom.isJoinInviteValid(id)) {
            kingdom.addJoinRequest(id, true);
            if (offlineBukkitPlayer.isOnline()) {
                ChatUtil.sendNotice((CommandSender)((Player)offlineBukkitPlayer), MessagePath.COMMAND_KINGDOM_NOTICE_INVITE_RECEIVED.getMessage(new Object[0]));
            }
        } else {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_INVITE_EXISTS.getMessage(offlineBukkitPlayer.getName()));
            return false;
        }
        return true;
    }

    public boolean menuRespondKingdomInvite(KonPlayer player, KonKingdom kingdom, boolean resp) {
        if (kingdom == null) {
            return false;
        }
        UUID id = player.getBukkitPlayer().getUniqueId();
        if (!kingdom.isJoinInviteValid(id)) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            return false;
        }
        kingdom.removeJoinRequest(id);
        if (!resp) {
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_INVITE_DECLINED.getMessage(kingdom.getName()));
            return false;
        }
        if (kingdom.isCreated() && !kingdom.isJoinable() || player.getKingdom().isCreated() && !player.getKingdom().isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int status = this.assignPlayerKingdom(id, kingdom.getName(), false);
        if (status != 0) {
            switch (status) {
                case 2: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_LIMIT.getMessage(kingdom.getName()));
                    break;
                }
                case 3: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]));
                    break;
                }
                case 5: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_MEMBER.getMessage(new Object[0]));
                    break;
                }
                case 6: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_MASTER.getMessage(new Object[0]));
                    break;
                }
                case 7: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_SWITCH.getMessage(new Object[0]));
                    break;
                }
                case 8: {
                    String remainCooldown = this.getJoinCooldownRemainingTimeFormat((OfflinePlayer)player.getBukkitPlayer(), ChatColor.RED);
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_JOIN_COOLDOWN.getMessage(remainCooldown));
                    break;
                }
                default: {
                    ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                }
            }
            return false;
        }
        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_JOIN.getMessage(player.getBukkitPlayer().getName(), kingdom.getName()));
        return true;
    }

    public boolean menuExileKingdom(KonPlayer player) {
        UUID id = player.getBukkitPlayer().getUniqueId();
        if (!player.getKingdom().isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int status = this.exilePlayerBarbarian(id, true, true, false, false);
        if (status == 0) {
            return true;
        }
        switch (status) {
            case 1: {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_KICK_MASTER.getMessage(new Object[0]));
                break;
            }
            case 8: {
                String remainCooldown = this.getExileCooldownRemainingTimeFormat((OfflinePlayer)player.getBukkitPlayer(), ChatColor.RED);
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_EXILE_COOLDOWN.getMessage(remainCooldown));
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            }
        }
        return false;
    }

    private void addKingdomResidents(KonOfflinePlayer player, KonKingdom kingdom) {
        OfflinePlayer offlinePlayer = player.getOfflineBukkitPlayer();
        int numMaxResidents = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_RESIDENT_LIMIT.getPath(), 0);
        for (KonTown townOrCapital : kingdom.getCapitalTowns()) {
            if (!townOrCapital.getTownOption(KonTownOption.KINGDOM_RESIDENTS) || player.isBarbarian() || townOrCapital.isPlayerResident(offlinePlayer) || !townOrCapital.isJoinable() || numMaxResidents > 0 && townOrCapital.getNumResidents() >= numMaxResidents) continue;
            townOrCapital.removeJoinRequest(offlinePlayer.getUniqueId());
            if (!townOrCapital.addPlayerResident(offlinePlayer, false)) continue;
            for (OfflinePlayer resident : townOrCapital.getPlayerResidents()) {
                if (!resident.isOnline()) continue;
                ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_NEW_RESIDENT.getMessage(offlinePlayer.getName(), townOrCapital.getName()));
            }
        }
    }

    public boolean kickKingdomMember(KonPlayer player, OfflinePlayer member) {
        if (!player.getKingdom().isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int status = this.exilePlayerBarbarian(member.getUniqueId(), true, false, false, false);
        if (status == 0) {
            return true;
        }
        switch (status) {
            case 1: {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_KICK_BARBARIAN.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_KICK_MASTER.getMessage(new Object[0]));
                break;
            }
            case 8: {
                String remainCooldown = this.getExileCooldownRemainingTimeFormat(member, ChatColor.RED);
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_ERROR_EXILE_COOLDOWN.getMessage(remainCooldown));
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean removeKingdomMember(KonOfflinePlayer player, KonKingdom kingdom, boolean force) {
        boolean result;
        if (kingdom == null) return false;
        if (!kingdom.isCreated()) {
            return false;
        }
        UUID playerID = player.getOfflineBukkitPlayer().getUniqueId();
        String playerName = player.getOfflineBukkitPlayer().getName();
        String kingdomName = kingdom.getName();
        boolean isPlayerMaster = kingdom.isMaster(playerID);
        if (isPlayerMaster && !force) {
            ChatUtil.printDebug("Failed to remove master player " + playerName + " from kingdom " + kingdomName + ", force = false");
            return false;
        }
        if (isPlayerMaster && !kingdom.isAdminOperated()) {
            ChatUtil.printDebug("Attempting to transfer master in kingdom " + kingdomName + ", force = true");
            ArrayList<OfflinePlayer> officers = kingdom.getPlayerOfficersOnly();
            if (!officers.isEmpty()) {
                OfflinePlayer newMaster = (OfflinePlayer)officers.get(0);
                boolean officerToMasterStatus = kingdom.setMaster(newMaster.getUniqueId());
                if (!officerToMasterStatus) {
                    ChatUtil.printDebug("Could not transfer master to officer player " + newMaster.getName() + " in kingdom " + kingdomName);
                    return false;
                }
                this.broadcastMembers(kingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_TRANSFER.getMessage(newMaster.getName(), kingdomName));
                ChatUtil.printDebug("Transferred master to officer player " + newMaster.getName() + " in kingdom " + kingdomName);
            } else {
                ArrayList<OfflinePlayer> members = kingdom.getPlayerMembersOnly();
                if (!members.isEmpty()) {
                    OfflinePlayer newMaster = (OfflinePlayer)members.get(0);
                    boolean memberToMasterStatus = kingdom.setMaster(newMaster.getUniqueId());
                    if (!memberToMasterStatus) {
                        ChatUtil.printDebug("Could not transfer master to member player " + newMaster.getName() + " in kingdom " + kingdomName);
                        return false;
                    }
                    this.broadcastMembers(kingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_TRANSFER.getMessage(newMaster.getName(), kingdomName));
                    ChatUtil.printDebug("Transferred master to member player " + newMaster.getName() + " in kingdom " + kingdomName);
                } else {
                    if (this.removeKingdom(kingdomName)) {
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_DISBAND.getMessage(kingdomName));
                        ChatUtil.printDebug("Successfully removed all players from kingdom " + kingdomName + ", and removed the kingdom");
                        Konquest.callKonquestEvent(new KonquestKingdomDisbandEvent((KonquestAPI)this.konquest, kingdomName));
                        return true;
                    }
                    ChatUtil.printDebug("Failed to remove kingdom " + kingdomName + ", no officers or members");
                    return false;
                }
            }
        }
        if (kingdom.isMaster(playerID) && kingdom.isAdminOperated()) {
            kingdom.clearMaster();
        }
        if (result = kingdom.isMember(playerID) ? kingdom.removeMember(playerID) : true) {
            player.setKingdom(this.getBarbarians());
            player.setExileKingdom(kingdom);
            player.setBarbarian(true);
            this.konquest.getDatabaseThread().getDatabase().setOfflinePlayer(player);
            ChatUtil.printDebug("Successfully removed player " + playerName + " from kingdom " + kingdomName);
            return true;
        }
        ChatUtil.printDebug("Failed to remove player " + playerName + " from kingdom " + kingdomName);
        return false;
    }

    public List<KonKingdom> getInviteKingdoms(KonOfflinePlayer player) {
        ArrayList<KonKingdom> result = new ArrayList<KonKingdom>();
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (player.getKingdom().equals(kingdom) || !kingdom.isJoinInviteValid(player.getOfflineBukkitPlayer().getUniqueId())) continue;
            result.add(kingdom);
        }
        return result;
    }

    public List<String> getInviteKingdomNames(KonOfflinePlayer player) {
        ArrayList<String> result = new ArrayList<String>();
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (player.getKingdom().equals(kingdom) || !kingdom.isJoinInviteValid(player.getOfflineBukkitPlayer().getUniqueId())) continue;
            result.add(kingdom.getName());
        }
        return result;
    }

    public List<KonTown> getInviteTowns(KonOfflinePlayer player) {
        ArrayList<KonTown> result = new ArrayList<KonTown>();
        for (KonTown town : player.getKingdom().getCapitalTowns()) {
            if (town.isPlayerResident(player.getOfflineBukkitPlayer()) || !town.isJoinInviteValid(player.getOfflineBukkitPlayer().getUniqueId())) continue;
            result.add(town);
        }
        return result;
    }

    public List<String> getInviteTownNames(KonOfflinePlayer player) {
        ArrayList<String> result = new ArrayList<String>();
        for (KonTown town : player.getKingdom().getCapitalTowns()) {
            if (town.isPlayerResident(player.getOfflineBukkitPlayer()) || !town.isJoinInviteValid(player.getOfflineBukkitPlayer().getUniqueId())) continue;
            result.add(town.getName());
        }
        return result;
    }

    public List<KonTown> getRequestTowns(KonOfflinePlayer player) {
        ArrayList<KonTown> result = new ArrayList<KonTown>();
        for (KonTown town : this.getManageTowns(player)) {
            if (town.getJoinRequests().size() <= 0) continue;
            result.add(town);
        }
        return result;
    }

    public List<String> getRequestTownNames(KonOfflinePlayer player) {
        ArrayList<String> result = new ArrayList<String>();
        for (KonTown town : this.getManageTowns(player)) {
            if (town.getJoinRequests().size() <= 0) continue;
            result.add(town.getName());
        }
        return result;
    }

    public List<KonTown> getManageTowns(KonOfflinePlayer player) {
        ArrayList<KonTown> result = new ArrayList<KonTown>();
        for (KonTown town : player.getKingdom().getCapitalTowns()) {
            if (!town.isPlayerKnight(player.getOfflineBukkitPlayer())) continue;
            result.add(town);
        }
        return result;
    }

    public boolean menuPromoteOfficer(OfflinePlayer player, KonKingdom kingdom) {
        UUID id = player.getUniqueId();
        if (kingdom.isOfficer(id)) {
            return false;
        }
        if (kingdom.setOfficer(id, true)) {
            this.broadcastMembers(kingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_PROMOTE.getMessage(player.getName(), kingdom.getName()));
            return true;
        }
        return false;
    }

    public boolean menuDemoteOfficer(OfflinePlayer player, KonKingdom kingdom) {
        UUID id = player.getUniqueId();
        if (!kingdom.isOfficer(id)) {
            return false;
        }
        if (kingdom.isMaster(id)) {
            return false;
        }
        if (kingdom.setOfficer(id, false)) {
            this.broadcastMembers(kingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_DEMOTE.getMessage(player.getName(), kingdom.getName()));
            return true;
        }
        return false;
    }

    public boolean menuTransferMaster(OfflinePlayer master, KonKingdom kingdom, KonPlayer sender) {
        UUID id = master.getUniqueId();
        if (kingdom.isMember(id) && kingdom.setMaster(id)) {
            ChatUtil.sendNotice((CommandSender)sender.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_TRANSFER_MASTER.getMessage(master.getName(), kingdom.getName()));
            this.broadcastMembers(kingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_TRANSFER.getMessage(master.getName(), kingdom.getName()));
            return true;
        }
        ChatUtil.sendError((CommandSender)sender.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
        return false;
    }

    private void broadcastMembers(KonKingdom kingdom, String message) {
        if (kingdom == null) {
            return;
        }
        for (OfflinePlayer offlinePlayer : kingdom.getPlayerMembers()) {
            if (!offlinePlayer.isOnline()) continue;
            Player player = (Player)offlinePlayer;
            ChatUtil.sendNotice((CommandSender)player, message);
        }
    }

    private void broadcastOfficers(KonKingdom kingdom, String message) {
        if (kingdom == null) {
            return;
        }
        for (OfflinePlayer offlinePlayer : kingdom.getPlayerOfficers()) {
            if (!offlinePlayer.isOnline()) continue;
            Player player = (Player)offlinePlayer;
            ChatUtil.sendNotice((CommandSender)player, message);
        }
    }

    public void menuToggleKingdomOpen(KonKingdom kingdom, KonPlayer player) {
        if (kingdom == null || !kingdom.isCreated()) {
            return;
        }
        if (kingdom.isOpen()) {
            kingdom.setIsOpen(false);
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_CLOSED.getMessage(new Object[0]));
        } else {
            kingdom.setIsOpen(true);
            ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_OPEN.getMessage(new Object[0]));
        }
    }

    public boolean menuDisbandKingdom(KonKingdom kingdom, KonPlayer player) {
        if (kingdom == null || !kingdom.isCreated() || kingdom.isAdminOperated()) {
            return false;
        }
        String kingdomName = kingdom.getName();
        boolean status = this.removeKingdom(kingdomName);
        if (status) {
            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_DISBAND.getMessage(kingdomName));
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.KINGDOMS, -1, true);
            Konquest.callKonquestEvent(new KonquestKingdomDisbandEvent((KonquestAPI)this.konquest, kingdomName));
            return true;
        }
        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
        return false;
    }

    public boolean menuChangeKingdomTemplate(KonKingdom kingdom, KonMonumentTemplate template, KonPlayer player, boolean ignoreCost) {
        if (kingdom == null || !kingdom.isCreated()) {
            return false;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        if (template == null || !template.isValid()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            return false;
        }
        if (kingdom.getMonumentTemplate().equals(template)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_TEMPLATE_CHOSEN.getMessage(new Object[0]));
            return false;
        }
        if (kingdom.getCapital().isAttacked()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_TEMPLATE_ATTACK.getMessage(new Object[0]));
            return false;
        }
        boolean hasTemplate = kingdom.hasMonumentTemplate();
        double totalCost = this.costTemplate + template.getCost();
        if (!ignoreCost && hasTemplate && totalCost > 0.0 && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < totalCost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(totalCost));
            return false;
        }
        kingdom.updateMonumentTemplate(template);
        if (!ignoreCost && hasTemplate && totalCost > 0.0 && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, totalCost)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)totalCost);
        }
        ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_TEMPLATE.getMessage(template.getName()));
        return true;
    }

    public boolean menuChangeTownSpecialization(KonTown town, Villager.Profession profession, KonPlayer payPlayer, CommandSender messageSender, boolean isAdmin) {
        if (town == null || profession == null) {
            return false;
        }
        if (!isAdmin && town.hasPropertyValue(KonPropertyFlag.SPECIALIZE) && !town.getPropertyValue(KonPropertyFlag.SPECIALIZE)) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        double costSpecial = this.konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SPECIALIZE.getPath());
        if (costSpecial > 0.0 && !isAdmin && payPlayer != null && KonquestPlugin.getBalance((OfflinePlayer)payPlayer.getBukkitPlayer()) < costSpecial) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(costSpecial));
            return false;
        }
        town.setSpecialization(profession);
        if (costSpecial > 0.0 && !isAdmin && payPlayer != null && KonquestPlugin.withdrawPlayer((OfflinePlayer)payPlayer.getBukkitPlayer(), costSpecial)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(payPlayer, KonStatsType.FAVOR, (int)costSpecial);
        }
        String professionName = CompatibilityUtil.getProfessionName(profession);
        ChatUtil.sendNotice(messageSender, MessagePath.COMMAND_TOWN_NOTICE_SPECIALIZE.getMessage(town.getName(), professionName));
        return true;
    }

    public boolean menuChangeTownSpecialization(KonTown town, Villager.Profession profession, KonPlayer player, boolean isAdmin) {
        if (player == null) {
            return false;
        }
        return this.menuChangeTownSpecialization(town, profession, player, (CommandSender)player.getBukkitPlayer(), isAdmin);
    }

    public boolean menuChangeKingdomRelation(@Nullable KonKingdom kingdom, @Nullable KonKingdom otherKingdom, @NotNull KonquestDiplomacyType relation, KonPlayer payPlayer, CommandSender messageSender, boolean isAdmin) {
        if (kingdom == null || otherKingdom == null) {
            return false;
        }
        if (kingdom.isPeaceful() || otherKingdom.isPeaceful()) {
            ChatUtil.printDebug("Tried to change relation of peaceful kingdom(s), reverting to default.");
            kingdom.removeActiveRelation(otherKingdom);
            otherKingdom.removeActiveRelation(kingdom);
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        if (kingdom.equals(otherKingdom)) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (this.isGlobalEventWar || this.isGlobalEventPeace) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_NO_EVENT.getMessage(new Object[0]));
            return false;
        }
        double costRelation = this.getRelationCost(relation);
        if (costRelation > 0.0 && !isAdmin && payPlayer != null && KonquestPlugin.getBalance((OfflinePlayer)payPlayer.getBukkitPlayer()) < costRelation) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(costRelation));
            return false;
        }
        KonquestDiplomacyType ourActiveState = kingdom.getActiveRelation(otherKingdom);
        KonquestDiplomacyType ourRequestState = kingdom.getRelationRequest(otherKingdom);
        KonquestDiplomacyType theirActiveState = otherKingdom.getActiveRelation(kingdom);
        KonquestDiplomacyType theirRequestState = otherKingdom.getRelationRequest(kingdom);
        ChatUtil.printDebug("Attempting to change kingdom " + kingdom.getName() + " relation to " + otherKingdom.getName() + ": " + relation.toString());
        ChatUtil.printDebug("Our states [" + String.valueOf((Object)ourActiveState) + "," + String.valueOf((Object)ourRequestState) + "]; Their states [" + String.valueOf((Object)theirActiveState) + "," + String.valueOf((Object)theirRequestState) + "]");
        if (!this.isValidRelationChoice(kingdom, otherKingdom, relation)) {
            ChatUtil.sendError(messageSender, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_INVALID.getMessage(new Object[0]));
            return false;
        }
        if (!ourActiveState.equals((Object)theirActiveState)) {
            ChatUtil.printDebug("Found invalid state combination, reverting to default.");
            kingdom.removeActiveRelation(otherKingdom);
            otherKingdom.removeActiveRelation(kingdom);
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        boolean isInstantWar = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_INSTANT_WAR.getPath(), false);
        boolean isInstantPeace = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_INSTANT_PEACE.getPath(), false);
        boolean isDefensePact = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLY_DEFENSE_PACT.getPath(), false);
        if (isAdmin) {
            this.setJointActiveRelation(kingdom, otherKingdom, relation);
            switch (relation) {
                case PEACE: {
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_PEACE.getMessage(kingdom.getName(), otherKingdom.getName()));
                    break;
                }
                case TRADE: {
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_TRADE.getMessage(kingdom.getName(), otherKingdom.getName()));
                    break;
                }
                case ALLIANCE: {
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_ALLY.getMessage(kingdom.getName(), otherKingdom.getName()));
                    break;
                }
                case WAR: {
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_WAR.getMessage(kingdom.getName(), otherKingdom.getName()));
                    break;
                }
            }
        } else {
            switch (relation) {
                case PEACE: {
                    if (ourActiveState.equals((Object)KonquestDiplomacyType.WAR)) {
                        if (isInstantPeace) {
                            this.setJointActiveRelation(kingdom, otherKingdom, relation);
                            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_PEACE.getMessage(kingdom.getName(), otherKingdom.getName()));
                            break;
                        }
                        if (kingdom.hasRelationRequest(otherKingdom) && kingdom.getRelationRequest(otherKingdom).equals((Object)relation)) {
                            this.setJointActiveRelation(kingdom, otherKingdom, relation);
                            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_PEACE.getMessage(kingdom.getName(), otherKingdom.getName()));
                            break;
                        }
                        if (otherKingdom.hasRelationRequest(kingdom) && otherKingdom.getRelationRequest(kingdom).equals((Object)KonquestDiplomacyType.PEACE)) {
                            ChatUtil.sendError(messageSender, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_EXISTS.getMessage(new Object[0]));
                            return false;
                        }
                        otherKingdom.setRelationRequest(kingdom, relation);
                        ChatUtil.sendNotice(messageSender, MessagePath.COMMAND_KINGDOM_NOTICE_DIPLOMACY_SENT.getMessage(otherKingdom.getName()));
                        this.broadcastMembers(otherKingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_PEACE_REQUEST.getMessage(kingdom.getName()));
                        break;
                    }
                    if (ourActiveState.equals((Object)KonquestDiplomacyType.ALLIANCE)) {
                        this.setJointActiveRelation(kingdom, otherKingdom, relation);
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_NO_ALLY.getMessage(kingdom.getName(), otherKingdom.getName()));
                        break;
                    }
                    if (!ourActiveState.equals((Object)KonquestDiplomacyType.TRADE)) break;
                    this.setJointActiveRelation(kingdom, otherKingdom, relation);
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_NO_TRADE.getMessage(kingdom.getName(), otherKingdom.getName()));
                    break;
                }
                case TRADE: {
                    if (ourActiveState.equals((Object)KonquestDiplomacyType.PEACE)) {
                        if (kingdom.hasRelationRequest(otherKingdom) && kingdom.getRelationRequest(otherKingdom).equals((Object)relation)) {
                            this.setJointActiveRelation(kingdom, otherKingdom, relation);
                            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_TRADE.getMessage(kingdom.getName(), otherKingdom.getName()));
                            break;
                        }
                        if (otherKingdom.hasRelationRequest(kingdom) && otherKingdom.getRelationRequest(kingdom).equals((Object)KonquestDiplomacyType.TRADE)) {
                            ChatUtil.sendError(messageSender, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_EXISTS.getMessage(new Object[0]));
                            return false;
                        }
                        otherKingdom.setRelationRequest(kingdom, relation);
                        ChatUtil.sendNotice(messageSender, MessagePath.COMMAND_KINGDOM_NOTICE_DIPLOMACY_SENT.getMessage(otherKingdom.getName()));
                        this.broadcastMembers(otherKingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_TRADE_REQUEST.getMessage(kingdom.getName()));
                        break;
                    }
                    if (!ourActiveState.equals((Object)KonquestDiplomacyType.ALLIANCE)) break;
                    this.removeJointActiveRelation(kingdom, otherKingdom);
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_NO_ALLY.getMessage(kingdom.getName(), otherKingdom.getName()));
                    break;
                }
                case ALLIANCE: {
                    if (kingdom.hasRelationRequest(otherKingdom) && kingdom.getRelationRequest(otherKingdom).equals((Object)relation)) {
                        this.setJointActiveRelation(kingdom, otherKingdom, relation);
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_ALLY.getMessage(kingdom.getName(), otherKingdom.getName()));
                        break;
                    }
                    if (otherKingdom.hasRelationRequest(kingdom) && otherKingdom.getRelationRequest(kingdom).equals((Object)KonquestDiplomacyType.ALLIANCE)) {
                        ChatUtil.sendError(messageSender, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_EXISTS.getMessage(new Object[0]));
                        return false;
                    }
                    otherKingdom.setRelationRequest(kingdom, relation);
                    ChatUtil.sendNotice(messageSender, MessagePath.COMMAND_KINGDOM_NOTICE_DIPLOMACY_SENT.getMessage(otherKingdom.getName()));
                    this.broadcastMembers(otherKingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_ALLY_REQUEST.getMessage(kingdom.getName()));
                    break;
                }
                case WAR: {
                    boolean isWarDeclared = false;
                    if (isInstantWar) {
                        this.setJointActiveRelation(kingdom, otherKingdom, relation);
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_WAR.getMessage(kingdom.getName(), otherKingdom.getName()));
                        isWarDeclared = true;
                    } else if (kingdom.hasRelationRequest(otherKingdom) && kingdom.getRelationRequest(otherKingdom).equals((Object)relation)) {
                        this.setJointActiveRelation(kingdom, otherKingdom, relation);
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_WAR.getMessage(kingdom.getName(), otherKingdom.getName()));
                        isWarDeclared = true;
                    } else {
                        if (otherKingdom.hasRelationRequest(kingdom) && otherKingdom.getRelationRequest(kingdom).equals((Object)KonquestDiplomacyType.WAR)) {
                            ChatUtil.sendError(messageSender, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_EXISTS.getMessage(new Object[0]));
                            return false;
                        }
                        otherKingdom.setRelationRequest(kingdom, relation);
                        ChatUtil.sendNotice(messageSender, MessagePath.COMMAND_KINGDOM_NOTICE_DIPLOMACY_SENT.getMessage(otherKingdom.getName()));
                        this.broadcastMembers(otherKingdom, MessagePath.COMMAND_KINGDOM_BROADCAST_WAR_REQUEST.getMessage(kingdom.getName()));
                    }
                    if (!isWarDeclared || !isDefensePact) break;
                    for (KonKingdom otherAlly : otherKingdom.getActiveRelationKingdoms(KonquestDiplomacyType.ALLIANCE)) {
                        if (otherAlly.equals(kingdom)) continue;
                        this.setJointActiveRelation(kingdom, otherAlly, relation);
                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_WAR.getMessage(kingdom.getName(), otherAlly.getName()));
                    }
                    break;
                }
            }
        }
        KonquestDiplomacyType ourNewActiveState = kingdom.getActiveRelation(otherKingdom);
        KonquestDiplomacyType ourNewRequestState = kingdom.getRelationRequest(otherKingdom);
        KonquestDiplomacyType theirNewActiveState = otherKingdom.getActiveRelation(kingdom);
        KonquestDiplomacyType theirNewRequestState = otherKingdom.getRelationRequest(kingdom);
        ChatUtil.printDebug("Finished; Our states [" + String.valueOf((Object)ourNewActiveState) + "," + String.valueOf((Object)ourNewRequestState) + "]; Their states [" + String.valueOf((Object)theirNewActiveState) + "," + String.valueOf((Object)theirNewRequestState) + "]");
        if (!ourActiveState.equals((Object)ourNewActiveState)) {
            this.konquest.updateNamePackets(kingdom);
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(kingdom);
            this.konquest.getTerritoryManager().updateTownDisplayBars(kingdom);
            this.refreshTownNerfs(kingdom);
        }
        if (!theirActiveState.equals((Object)theirNewActiveState)) {
            this.konquest.updateNamePackets(otherKingdom);
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(otherKingdom);
            this.konquest.getTerritoryManager().updateTownDisplayBars(otherKingdom);
            this.refreshTownNerfs(otherKingdom);
        }
        if (costRelation > 0.0 && !isAdmin && payPlayer != null && KonquestPlugin.withdrawPlayer((OfflinePlayer)payPlayer.getBukkitPlayer(), costRelation)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(payPlayer, KonStatsType.FAVOR, (int)costRelation);
        }
        Konquest.callKonquestEvent(new KonquestKingdomDiplomacyEvent(this.konquest, kingdom, otherKingdom, ourNewActiveState));
        return true;
    }

    public boolean menuChangeKingdomRelation(@Nullable KonKingdom kingdom, @Nullable KonKingdom otherKingdom, @NotNull KonquestDiplomacyType relation, KonPlayer player, boolean isAdmin) {
        if (player == null) {
            return false;
        }
        return this.menuChangeKingdomRelation(kingdom, otherKingdom, relation, player, (CommandSender)player.getBukkitPlayer(), isAdmin);
    }

    public boolean isValidRelationChoice(@NotNull KonKingdom kingdom1, @NotNull KonKingdom kingdom2, @NotNull KonquestDiplomacyType relation) {
        KonquestDiplomacyType ourRelation = kingdom1.getActiveRelation(kingdom2);
        if (ourRelation.equals((Object)relation)) {
            return false;
        }
        if (ourRelation.equals((Object)KonquestDiplomacyType.WAR) && !relation.equals((Object)KonquestDiplomacyType.PEACE)) {
            return false;
        }
        return !ourRelation.equals((Object)KonquestDiplomacyType.ALLIANCE) || !relation.equals((Object)KonquestDiplomacyType.WAR);
    }

    public double getRelationCost(@NotNull KonquestDiplomacyType relation) {
        switch (relation) {
            case WAR: {
                return this.costDiplomacyWar;
            }
            case PEACE: {
                return this.costDiplomacyPeace;
            }
            case TRADE: {
                return this.costDiplomacyTrade;
            }
            case ALLIANCE: {
                return this.costDiplomacyAlliance;
            }
        }
        return 0.0;
    }

    private void setJointActiveRelation(@NotNull KonKingdom kingdom1, @NotNull KonKingdom kingdom2, @NotNull KonquestDiplomacyType relation) {
        kingdom1.setActiveRelation(kingdom2, relation);
        kingdom1.removeRelationRequest(kingdom2);
        kingdom2.setActiveRelation(kingdom1, relation);
        kingdom2.removeRelationRequest(kingdom1);
    }

    private void removeJointActiveRelation(@NotNull KonKingdom kingdom1, @NotNull KonKingdom kingdom2) {
        kingdom1.removeActiveRelation(kingdom2);
        kingdom1.removeRelationRequest(kingdom2);
        kingdom2.removeActiveRelation(kingdom1);
        kingdom2.removeRelationRequest(kingdom1);
    }

    public void enableGlobalEventWar(boolean isEnabled) {
        boolean wasEnabled = this.isGlobalEventWar;
        this.isGlobalEventWar = isEnabled;
        if (wasEnabled != isEnabled) {
            for (KonKingdom kingdom : this.getKingdoms()) {
                this.konquest.updateNamePackets(kingdom);
                this.konquest.getTerritoryManager().updatePlayerBorderParticles(kingdom);
                this.konquest.getTerritoryManager().updateTownDisplayBars(kingdom);
                this.refreshTownNerfs(kingdom);
            }
        }
    }

    public void enableGlobalEventPeace(boolean isEnabled) {
        boolean wasEnabled = this.isGlobalEventPeace;
        this.isGlobalEventPeace = isEnabled;
        if (wasEnabled != isEnabled) {
            for (KonKingdom kingdom : this.getKingdoms()) {
                this.konquest.updateNamePackets(kingdom);
                this.konquest.getTerritoryManager().updatePlayerBorderParticles(kingdom);
                this.konquest.getTerritoryManager().updateTownDisplayBars(kingdom);
                this.refreshTownNerfs(kingdom);
            }
        }
    }

    @Override
    public KonquestDiplomacyType getDiplomacy(@NotNull KonquestKingdom kingdom1, @NotNull KonquestKingdom kingdom2) {
        if (this.isGlobalEventWar) {
            return KonquestDiplomacyType.WAR;
        }
        if (this.isGlobalEventPeace) {
            return KonquestDiplomacyType.PEACE;
        }
        if (!kingdom1.isCreated() || !kingdom2.isCreated()) {
            return KonquestDiplomacyType.WAR;
        }
        if (kingdom1.getActiveRelation(kingdom2).equals((Object)kingdom2.getActiveRelation(kingdom1))) {
            return kingdom1.getActiveRelation(kingdom2);
        }
        if (kingdom1 instanceof KonKingdom) {
            ((KonKingdom)kingdom1).removeActiveRelation(kingdom2);
        }
        if (kingdom2 instanceof KonKingdom) {
            ((KonKingdom)kingdom2).removeActiveRelation(kingdom1);
        }
        return KonquestDiplomacyType.getDefault();
    }

    public boolean isKingdomWar(@NotNull KonquestKingdom kingdom1, @NotNull KonquestKingdom kingdom2) {
        return this.getDiplomacy(kingdom1, kingdom2).equals((Object)KonquestDiplomacyType.WAR);
    }

    public boolean isKingdomPeace(@NotNull KonquestKingdom kingdom1, @NotNull KonquestKingdom kingdom2) {
        return this.getDiplomacy(kingdom1, kingdom2).equals((Object)KonquestDiplomacyType.PEACE);
    }

    public boolean isKingdomTrade(@NotNull KonquestKingdom kingdom1, @NotNull KonquestKingdom kingdom2) {
        return this.getDiplomacy(kingdom1, kingdom2).equals((Object)KonquestDiplomacyType.TRADE);
    }

    public boolean isKingdomAlliance(@NotNull KonquestKingdom kingdom1, @NotNull KonquestKingdom kingdom2) {
        return this.getDiplomacy(kingdom1, kingdom2).equals((Object)KonquestDiplomacyType.ALLIANCE);
    }

    @Override
    public KonquestRelationshipType getRelationRole(@Nullable KonquestKingdom displayKingdom, @Nullable KonquestKingdom contextKingdom) {
        KonquestRelationshipType result;
        if (displayKingdom == null || contextKingdom == null) {
            ChatUtil.printDebug("Failed to evaluate relation of null kingdom");
            return KonquestRelationshipType.NEUTRAL;
        }
        if (contextKingdom.equals(this.getBarbarians())) {
            result = KonquestRelationshipType.BARBARIAN;
        } else if (contextKingdom.equals(this.getNeutrals())) {
            result = KonquestRelationshipType.NEUTRAL;
        } else if (displayKingdom.equals(contextKingdom)) {
            result = KonquestRelationshipType.FRIENDLY;
        } else if (displayKingdom.equals(this.getBarbarians())) {
            result = this.isGlobalEventPeace ? KonquestRelationshipType.PEACEFUL : KonquestRelationshipType.ENEMY;
        } else {
            if (this.isGlobalEventWar) {
                return KonquestRelationshipType.ENEMY;
            }
            result = this.isKingdomWar(displayKingdom, contextKingdom) ? (this.isGlobalEventPeace ? KonquestRelationshipType.PEACEFUL : KonquestRelationshipType.ENEMY) : (this.isKingdomAlliance(displayKingdom, contextKingdom) ? KonquestRelationshipType.ALLY : (this.isKingdomTrade(displayKingdom, contextKingdom) ? KonquestRelationshipType.TRADE : (this.isKingdomPeace(displayKingdom, contextKingdom) ? KonquestRelationshipType.PEACEFUL : KonquestRelationshipType.NEUTRAL)));
        }
        return result;
    }

    public boolean isPlayerEnemy(@NotNull KonOfflinePlayer offlinePlayer, @NotNull KonKingdom kingdom) {
        return this.getRelationRole(offlinePlayer.getKingdom(), kingdom).equals((Object)KonquestRelationshipType.ENEMY);
    }

    public boolean isPlayerAlly(@NotNull KonOfflinePlayer offlinePlayer, @NotNull KonKingdom kingdom) {
        return this.getRelationRole(offlinePlayer.getKingdom(), kingdom).equals((Object)KonquestRelationshipType.ALLY);
    }

    public boolean isPlayerFriendly(@NotNull KonOfflinePlayer offlinePlayer, @NotNull KonKingdom kingdom) {
        return this.getRelationRole(offlinePlayer.getKingdom(), kingdom).equals((Object)KonquestRelationshipType.FRIENDLY);
    }

    public boolean isPlayerTrade(@NotNull KonOfflinePlayer offlinePlayer, @NotNull KonKingdom kingdom) {
        return this.getRelationRole(offlinePlayer.getKingdom(), kingdom).equals((Object)KonquestRelationshipType.TRADE);
    }

    public boolean isPlayerPeace(@NotNull KonOfflinePlayer offlinePlayer, @NotNull KonKingdom kingdom) {
        return this.getRelationRole(offlinePlayer.getKingdom(), kingdom).equals((Object)KonquestRelationshipType.PEACEFUL);
    }

    public boolean isPlayerForeign(@NotNull KonOfflinePlayer offlinePlayer, @NotNull KonKingdom kingdom) {
        return !this.getRelationRole(offlinePlayer.getKingdom(), kingdom).equals((Object)KonquestRelationshipType.FRIENDLY);
    }

    public boolean isKingdomBarbarian(@NotNull KonKingdom kingdom) {
        return kingdom.equals(this.barbarians);
    }

    public boolean isKingdomNeutral(@NotNull KonKingdom kingdom) {
        return kingdom.equals(this.neutrals);
    }

    @Override
    public int createTown(@NotNull Location loc, String name, String kingdomName) {
        int yFloor;
        ChatUtil.printDebug("Attempting to add new town " + name + " for kingdom " + kingdomName);
        if (this.konquest.validateNameConstraints(name) != 0) {
            ChatUtil.printDebug("Town name " + name + " failed name validation");
            return 3;
        }
        if (!this.isKingdom(kingdomName)) {
            ChatUtil.printDebug("Kingdom name " + kingdomName + " failed name validation");
            return 3;
        }
        int locStatus = this.validateTownLocationConstraints(loc);
        if (locStatus == 1) {
            return 5;
        }
        if (locStatus == 2) {
            return 6;
        }
        if (locStatus == 3) {
            return 7;
        }
        if (locStatus == 4) {
            return 1;
        }
        if (!this.getKingdom(kingdomName).isMonumentTemplateValid()) {
            ChatUtil.printDebug("Failed to create town with invalid or blanked monument template.");
            return 4;
        }
        Point point = HelperUtil.toPoint(loc);
        int xLocal = loc.getBlockX() - point.x * 16;
        int zLocal = loc.getBlockZ() - point.y * 16;
        Chunk chunk = loc.getChunk();
        for (yFloor = chunk.getChunkSnapshot(true, false, false).getHighestBlockYAt(xLocal, zLocal); (chunk.getBlock(xLocal, yFloor, zLocal).isPassable() || !chunk.getBlock(xLocal, yFloor, zLocal).getType().isOccluding()) && yFloor > 0; --yFloor) {
        }
        loc.setY((double)(yFloor + 1));
        if (this.getKingdom(kingdomName).addTown(loc, name)) {
            int initStatus = this.getKingdom(kingdomName).initTown(name);
            if (initStatus == 0) {
                KonTown newTown = this.getKingdom(kingdomName).getTown(name);
                this.konquest.getTerritoryManager().addAllTerritory(loc.getWorld(), newTown.getChunkList());
                this.konquest.getMapHandler().drawUpdateTerritory(newTown);
                newTown.updateBarPlayers();
                this.konquest.getTerritoryManager().updatePlayerBorderParticles(newTown.getCenterLoc());
                return 0;
            }
            this.getKingdom(kingdomName).removeTown(name);
            return 10 + initStatus;
        }
        return 3;
    }

    @Override
    public boolean removeTown(String name, String kingdomName) {
        if (!this.isKingdom(kingdomName) || !this.getKingdom(kingdomName).hasTown(name)) {
            return false;
        }
        KonKingdom kingdom = this.getKingdom(kingdomName);
        KonTown town = kingdom.getTown(name);
        ArrayList<Point> townPoints = new ArrayList<Point>(town.getChunkList().keySet());
        ArrayList<OfflinePlayer> residentPlayers = town.getPlayerResidents();
        ArrayList<KonPlayer> nearbyPlayers = this.konquest.getPlayerManager().getPlayersNearTerritory(town);
        this.clearAllTownNerfs(town);
        this.clearAllTownHearts(town);
        if (!kingdom.removeTown(name)) {
            return false;
        }
        this.konquest.getTerritoryManager().removeAllTerritory(town.getWorld(), townPoints);
        for (KonPlayer player : nearbyPlayers) {
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(player);
        }
        for (OfflinePlayer resident : residentPlayers) {
            KonPlayer onlineResident;
            if (!resident.isOnline() || (onlineResident = this.konquest.getPlayerManager().getPlayer((Player)resident)) == null) continue;
            this.updatePlayerMembershipStats(onlineResident);
        }
        this.konquest.getMapHandler().drawRemoveTerritory(town);
        this.konquest.getMapHandler().drawLabelTerritory(town.getKingdom().getCapital());
        this.konquest.getShopHandler().deleteShopsInPoints(townPoints, town.getWorld());
        return true;
    }

    @Override
    public boolean renameTown(String oldName, String newName, String kingdomName) {
        if (!this.isKingdom(kingdomName) || !this.getKingdom(kingdomName).hasTown(oldName)) {
            return false;
        }
        KonKingdom kingdom = this.getKingdom(kingdomName);
        this.konquest.getMapHandler().drawRemoveTerritory(kingdom.getTown(oldName));
        boolean success = kingdom.renameTown(oldName, newName);
        if (!success) {
            return false;
        }
        KonTown town = kingdom.getTown(newName);
        if (town != null) {
            this.konquest.getMapHandler().drawUpdateTerritory(town);
        }
        return true;
    }

    @Override
    @Nullable
    public KonquestTown captureTownForPlayer(String name, String oldKingdomName, @Nullable KonquestPlayer conquerPlayerArg) {
        if (conquerPlayerArg == null) {
            return null;
        }
        if (!(conquerPlayerArg instanceof KonPlayer)) {
            return null;
        }
        KonPlayer conquerPlayer = (KonPlayer)conquerPlayerArg;
        if (conquerPlayer.isBarbarian()) {
            return null;
        }
        KonTown town = this.captureTown(name, oldKingdomName, conquerPlayer.getKingdom());
        if (town != null) {
            town.setPlayerLord(conquerPlayer.getOfflineBukkitPlayer());
            return town;
        }
        return null;
    }

    @Nullable
    public KonTown captureTown(String name, String oldKingdomName, @NotNull KonKingdom conquerKingdom) {
        if (!conquerKingdom.isMonumentTemplateValid()) {
            ChatUtil.printDebug("Failed to capture town for kingdom with invalid template: " + conquerKingdom.getName());
            return null;
        }
        boolean captureUpgrades = this.konquest.getCore().getBoolean(CorePath.TOWNS_CAPTURE_UPGRADES.getPath(), true);
        if (this.isKingdom(oldKingdomName) && this.getKingdom(oldKingdomName).hasTown(name)) {
            this.konquest.getMapHandler().drawRemoveTerritory(this.getKingdom(oldKingdomName).getTown(name));
            this.getKingdom(oldKingdomName).getTown(name).purgeResidents();
            this.getKingdom(oldKingdomName).getTown(name).clearShieldsArmors();
            this.getKingdom(oldKingdomName).getTown(name).clearPurchaseOffers();
            this.getKingdom(oldKingdomName).getTown(name).setKingdom(conquerKingdom);
            conquerKingdom.addTownConquer(name, this.getKingdom(oldKingdomName).removeTownConquer(name));
            KonTown captureTown = conquerKingdom.getTown(name);
            captureTown.refreshMonument();
            this.refreshTownNerfs(captureTown);
            this.refreshTownHearts(captureTown);
            captureTown.updateBarPlayers();
            if (captureUpgrades) {
                this.konquest.getUpgradeManager().updateTownDisabledUpgrades(captureTown);
            } else {
                captureTown.clearUpgrades();
            }
            captureTown.clearPlots();
            this.konquest.getMapHandler().drawUpdateTerritory(captureTown);
            this.konquest.getMapHandler().drawLabelTerritory(this.getKingdom(oldKingdomName).getCapital());
            this.konquest.getMapHandler().drawLabelTerritory(conquerKingdom.getCapital());
            this.konquest.getShopHandler().deleteShopsInPoints(captureTown.getChunkList().keySet(), captureTown.getWorld());
            this.captureTownUpdate(captureTown);
            return captureTown;
        }
        return null;
    }

    @Nullable
    public KonquestTown captureCapitalForPlayer(String oldKingdomName, @Nullable KonquestPlayer conquerPlayerArg) {
        if (conquerPlayerArg == null) {
            return null;
        }
        if (!(conquerPlayerArg instanceof KonPlayer)) {
            return null;
        }
        KonPlayer conquerPlayer = (KonPlayer)conquerPlayerArg;
        if (conquerPlayer.isBarbarian()) {
            return null;
        }
        KonTown town = this.captureCapital(oldKingdomName, conquerPlayer.getKingdom());
        if (town != null) {
            town.setPlayerLord(conquerPlayer.getOfflineBukkitPlayer());
            return town;
        }
        return null;
    }

    @Nullable
    public KonTown captureCapital(String oldKingdomName, @NotNull KonKingdom conquerKingdom) {
        if (!conquerKingdom.isMonumentTemplateValid()) {
            ChatUtil.printDebug("Failed to capture capital for kingdom with invalid template: " + conquerKingdom.getName());
            return null;
        }
        boolean captureUpgrades = this.konquest.getCore().getBoolean(CorePath.TOWNS_CAPTURE_UPGRADES.getPath(), true);
        if (this.isKingdom(oldKingdomName)) {
            Location townLoc = this.getKingdom(oldKingdomName).getCapital().getCenterLoc();
            String townKingdom = conquerKingdom.getName();
            HashSet<Point> townLand = this.getKingdom(oldKingdomName).getCapital().getChunkPoints();
            Map<KonPropertyFlag, Boolean> townProperties = this.getKingdom(oldKingdomName).getCapital().getAllProperties();
            Map<KonquestUpgrade, Integer> townUpgrades = this.getKingdom(oldKingdomName).getCapital().getUpgrades();
            this.removeKingdom(oldKingdomName);
            int nameStatus = this.konquest.validateNameConstraints(oldKingdomName);
            if (nameStatus != 0) {
                ChatUtil.printDebug("Failed to name captured capital to " + oldKingdomName + ", validation failed with status code " + nameStatus);
                return null;
            }
            int status = this.createTown(townLoc, oldKingdomName, townKingdom);
            if (status == 0) {
                KonTown town = conquerKingdom.getTown(oldKingdomName);
                town.addPoints(townLand);
                this.konquest.getTerritoryManager().addAllTerritory(town.getWorld(), town.getChunkList());
                for (KonPropertyFlag flag : townProperties.keySet()) {
                    town.setPropertyValue(flag, townProperties.get((Object)flag));
                }
                if (captureUpgrades) {
                    for (KonquestUpgrade upgrade : townUpgrades.keySet()) {
                        town.addUpgrade(upgrade, townUpgrades.get(upgrade));
                    }
                    this.konquest.getUpgradeManager().updateTownDisabledUpgrades(town);
                }
                this.refreshTownNerfs(town);
                this.refreshTownHearts(town);
                town.updateBarPlayers();
                this.konquest.getMapHandler().drawUpdateTerritory(town);
                this.konquest.getMapHandler().drawLabelTerritory(conquerKingdom.getCapital());
                this.konquest.getShopHandler().deleteShopsInPoints(town.getChunkList().keySet(), town.getWorld());
                Konquest.callKonquestEvent(new KonquestKingdomConquerEvent(this.konquest, oldKingdomName, conquerKingdom));
                this.captureTownUpdate(town);
                return town;
            }
            ChatUtil.printDebug("Failed to create new town over captured capital, status code " + status);
            return null;
        }
        return null;
    }

    private void captureTownUpdate(KonTown town) {
        block0: for (KonPlayer onlinePlayer : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (town.isLocInsideCenterChunk(onlinePlayer.getBukkitPlayer().getLocation())) {
                onlinePlayer.getBukkitPlayer().teleport(this.konquest.getSafeRandomCenteredLocation(town.getCenterLoc(), 2));
                onlinePlayer.getBukkitPlayer().playEffect(onlinePlayer.getBukkitPlayer().getLocation(), Effect.ANVIL_LAND, null);
            }
            if (town.isLocInside(onlinePlayer.getBukkitPlayer().getLocation())) {
                onlinePlayer.clearAllMobAttackers();
            }
            for (Chunk chunk : HelperUtil.getAreaChunks(onlinePlayer.getBukkitPlayer().getLocation(), 2)) {
                if (!town.hasChunk(chunk)) continue;
                this.konquest.getTerritoryManager().updatePlayerBorderParticles(onlinePlayer);
                continue block0;
            }
        }
        town.getMonumentTimer().stopTimer();
        town.setAttacked(false, null);
        town.setBarProgress(1.0);
        town.updateBarTitle();
    }

    public boolean menuDestroyTown(KonTown town, KonPlayer player) {
        if (town == null) {
            return false;
        }
        if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        String townName = town.getName();
        String kingdomName = town.getKingdom().getName();
        if (!this.removeTown(townName, town.getKingdom().getName())) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_DESTROY.getMessage(townName));
        Konquest.callKonquestEvent(new KonquestTownDestroyPostEvent(this.konquest, townName, kingdomName, player, false));
        return true;
    }

    public boolean menuCapitalSwap(KonTown town, KonPlayer player, boolean isAdmin) {
        if (town == null || player == null) {
            return false;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        KonKingdom kingdom = town.getKingdom();
        if (!this.capitalSwapEnable) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (!isAdmin && (kingdom.getCapital().isAttacked() || town.isAttacked())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_CAPITAL_SWAP_ATTACK.getMessage(new Object[0]));
            return false;
        }
        if (!(this.capitalSwapWar || isAdmin || kingdom.getActiveRelationKingdoms(KonquestDiplomacyType.WAR).isEmpty())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_CAPITAL_SWAP_WAR.getMessage(new Object[0]));
            return false;
        }
        if (this.costCapitalSwap > 0.0 && !isAdmin && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < this.costCapitalSwap) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(this.costCapitalSwap));
            return false;
        }
        if (this.capitalSwapWarmup > 0.0 && !isAdmin) {
            kingdom.startCapitalSwapWarmup(town, (int)this.capitalSwapWarmup);
        } else {
            boolean status = kingdom.swapCapitalToTown(town);
            if (!status) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                return false;
            }
        }
        if (this.costCapitalSwap > 0.0 && !isAdmin && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, this.costCapitalSwap)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)this.costCapitalSwap);
        }
        return true;
    }

    private void broadcastResidents(KonTown town, String message) {
        if (town == null) {
            return;
        }
        for (OfflinePlayer offlinePlayer : town.getPlayerResidents()) {
            if (!offlinePlayer.isOnline()) continue;
            Player player = (Player)offlinePlayer;
            ChatUtil.sendNotice((CommandSender)player, message);
        }
    }

    private void broadcastKnights(KonTown town, String message) {
        if (town == null) {
            return;
        }
        for (OfflinePlayer offlinePlayer : town.getPlayerKnights()) {
            if (!offlinePlayer.isOnline()) continue;
            Player player = (Player)offlinePlayer;
            ChatUtil.sendNotice((CommandSender)player, message);
        }
    }

    public boolean menuJoinTownRequest(KonPlayer player, KonTown town) {
        Player bukkitPlayer = player.getBukkitPlayer();
        if (player.isBarbarian()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return false;
        }
        if (town.isPlayerResident((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_JOIN_MEMBER.getMessage(new Object[0]));
            return false;
        }
        if (!town.isJoinable()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int numMaxResidents = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_RESIDENT_LIMIT.getPath(), 0);
        if (numMaxResidents > 0 && town.getNumResidents() >= numMaxResidents) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_JOIN_LIMIT.getMessage(town.getName()));
            return false;
        }
        UUID myId = bukkitPlayer.getUniqueId();
        if (town.isOpen() || town.isJoinInviteValid(myId)) {
            town.removeJoinRequest(myId);
            if (town.addPlayerResident((OfflinePlayer)bukkitPlayer, false)) {
                for (OfflinePlayer resident : town.getPlayerResidents()) {
                    if (!resident.isOnline()) continue;
                    ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_NEW_RESIDENT.getMessage(bukkitPlayer.getName(), town.getName()));
                }
                this.updatePlayerMembershipStats(player);
            }
        } else {
            if (town.isJoinRequestValid(myId)) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_REQUEST_EXISTS.getMessage(town.getName()));
                return false;
            }
            if (town.getNumResidents() == 0) {
                town.setPlayerLord((OfflinePlayer)bukkitPlayer);
                town.removeJoinRequest(myId);
                this.updatePlayerMembershipStats(player);
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_NEW_RESIDENT.getMessage(bukkitPlayer.getName(), town.getName()));
            } else {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_REQUEST_SENT.getMessage(town.getName()));
                town.addJoinRequest(myId, false);
                this.broadcastKnights(town, MessagePath.COMMAND_TOWN_NOTICE_REQUEST_RECEIVED.getMessage(new Object[0]));
            }
        }
        return true;
    }

    public boolean menuLeaveTown(KonPlayer player, KonTown town) {
        Player bukkitPlayer = player.getBukkitPlayer();
        if (player.isBarbarian()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return false;
        }
        if (!town.isPlayerResident((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            return false;
        }
        if (!town.isLeaveable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (town.removePlayerResident((OfflinePlayer)bukkitPlayer)) {
            for (OfflinePlayer resident : town.getPlayerResidents()) {
                if (!resident.isOnline()) continue;
                ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_LEAVE_RESIDENT.getMessage(bukkitPlayer.getName(), town.getName()));
            }
        } else {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            return false;
        }
        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_LEAVE_RESIDENT.getMessage(bukkitPlayer.getName(), town.getName()));
        this.updatePlayerMembershipStats(player);
        return true;
    }

    public boolean menuRespondTownInvite(KonPlayer player, KonTown town, boolean resp) {
        Player bukkitPlayer = player.getBukkitPlayer();
        UUID myId = bukkitPlayer.getUniqueId();
        if (!town.isJoinInviteValid(myId)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INVALID_PLAYER.getMessage(new Object[0]));
            return false;
        }
        town.removeJoinRequest(myId);
        if (player.isBarbarian()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return false;
        }
        if (town.isPlayerResident((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_JOIN_MEMBER.getMessage(town.getName()));
            return false;
        }
        if (!town.isJoinable()) {
            ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int numMaxResidents = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_RESIDENT_LIMIT.getPath(), 0);
        if (numMaxResidents > 0 && town.getNumResidents() >= numMaxResidents) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_JOIN_LIMIT.getMessage(town.getName()));
            return false;
        }
        if (resp) {
            if (town.addPlayerResident((OfflinePlayer)bukkitPlayer, false)) {
                for (OfflinePlayer resident : town.getPlayerResidents()) {
                    if (!resident.isOnline()) continue;
                    ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_NEW_RESIDENT.getMessage(bukkitPlayer.getName(), town.getName()));
                }
                this.updatePlayerMembershipStats(player);
            }
        } else {
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_INVITE_DECLINED.getMessage(town.getName()));
        }
        return true;
    }

    public boolean menuRespondTownRequest(KonPlayer sender, OfflinePlayer requester, KonTown town, boolean resp) {
        Player bukkitPlayer = sender.getBukkitPlayer();
        UUID id = requester.getUniqueId();
        if (!town.isJoinRequestValid(id)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INVALID_PLAYER.getMessage(new Object[0]));
            return false;
        }
        if (!town.isPlayerLord((OfflinePlayer)bukkitPlayer) && !town.isPlayerKnight((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        town.removeJoinRequest(id);
        if (!town.isJoinable()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        int numMaxResidents = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_RESIDENT_LIMIT.getPath(), 0);
        if (numMaxResidents > 0 && town.getNumResidents() >= numMaxResidents) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_JOIN_LIMIT.getMessage(town.getName()));
            return false;
        }
        KonOfflinePlayer offlinePlayer = this.konquest.getPlayerManager().getOfflinePlayer(requester);
        if (offlinePlayer == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(requester.getName()));
            return false;
        }
        if (!offlinePlayer.getKingdom().equals(town.getKingdom())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_ENEMY_PLAYER.getMessage(new Object[0]));
            return false;
        }
        if (town.isPlayerResident(requester)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_INVITE_MEMBER.getMessage(requester.getName()));
            return false;
        }
        KonPlayer onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(id);
        if (resp) {
            if (town.addPlayerResident(requester, false)) {
                for (OfflinePlayer resident : town.getPlayerResidents()) {
                    if (!resident.isOnline()) continue;
                    ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_NEW_RESIDENT.getMessage(requester.getName(), town.getName()));
                }
                if (onlinePlayer != null) {
                    this.updatePlayerMembershipStats(onlinePlayer);
                }
            }
        } else {
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_REQUEST_DECLINED.getMessage(requester.getName()));
            if (onlinePlayer != null) {
                ChatUtil.sendError((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_TOWN_ERROR_REQUEST_DENY.getMessage(town.getName()));
            }
        }
        return true;
    }

    public void addTownPlayer(KonPlayer sender, KonOfflinePlayer player, KonTown town) {
        Player bukkitPlayer = sender.getBukkitPlayer();
        if (!town.isPlayerLord((OfflinePlayer)bukkitPlayer) && !town.isPlayerKnight((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        if (player == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return;
        }
        if (!town.isJoinable()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        int numMaxResidents = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_RESIDENT_LIMIT.getPath(), 0);
        if (numMaxResidents > 0 && town.getNumResidents() >= numMaxResidents) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_JOIN_LIMIT.getMessage(town.getName()));
            return;
        }
        OfflinePlayer offlinePlayer = player.getOfflineBukkitPlayer();
        UUID id = offlinePlayer.getUniqueId();
        if (!player.getKingdom().equals(town.getKingdom())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_ENEMY_PLAYER.getMessage(new Object[0]));
            return;
        }
        if (town.isPlayerResident(offlinePlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_INVITE_MEMBER.getMessage(offlinePlayer.getName()));
            return;
        }
        if (town.isOpen()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_INVITE_OPEN.getMessage(new Object[0]));
            return;
        }
        KonPlayer onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(id);
        if (town.isJoinInviteValid(id)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_INVITE_EXISTS.getMessage(offlinePlayer.getName()));
        } else if (town.isJoinRequestValid(id)) {
            town.removeJoinRequest(id);
            if (town.addPlayerResident(offlinePlayer, false)) {
                for (OfflinePlayer resident : town.getPlayerResidents()) {
                    if (!resident.isOnline()) continue;
                    ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_NEW_RESIDENT.getMessage(offlinePlayer.getName(), town.getName()));
                }
                if (onlinePlayer != null) {
                    this.updatePlayerMembershipStats(onlinePlayer);
                }
            }
        } else {
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_NOTICE_INVITE_SENT.getMessage(offlinePlayer.getName(), town.getName()));
            town.addJoinRequest(id, true);
            if (onlinePlayer != null) {
                ChatUtil.sendNotice((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_TOWN_NOTICE_INVITE_RECEIVED.getMessage(new Object[0]));
            }
        }
    }

    public void kickTownPlayer(KonPlayer sender, KonOfflinePlayer player, KonTown town) {
        Player bukkitPlayer = sender.getBukkitPlayer();
        if (!town.isPlayerLord((OfflinePlayer)bukkitPlayer) && !town.isPlayerKnight((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        if (player == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return;
        }
        if (!town.isLeaveable()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        OfflinePlayer offlinePlayer = player.getOfflineBukkitPlayer();
        if (!town.isPlayerResident(offlinePlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_KICK_FAIL.getMessage(offlinePlayer.getName(), town.getName()));
            return;
        }
        if (town.isPlayerLord(player.getOfflineBukkitPlayer())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        UUID id = offlinePlayer.getUniqueId();
        KonPlayer onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(offlinePlayer.getUniqueId());
        if (town.removePlayerResident(offlinePlayer)) {
            town.removeJoinRequest(id);
            for (OfflinePlayer resident : town.getPlayerResidents()) {
                if (!resident.isOnline()) continue;
                ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_KICK_RESIDENT.getMessage(offlinePlayer.getName(), town.getName()));
            }
            if (onlinePlayer != null) {
                ChatUtil.sendError((CommandSender)onlinePlayer.getBukkitPlayer(), MessagePath.COMMAND_TOWN_ERROR_KICKED.getMessage(town.getName()));
                this.updatePlayerMembershipStats(onlinePlayer);
            }
        } else {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_KICK_FAIL.getMessage(offlinePlayer.getName(), town.getName()));
        }
    }

    public boolean menuPromoteDemoteTownKnight(KonPlayer sender, OfflinePlayer member, KonTown town, boolean action) {
        Player bukkitPlayer = sender.getBukkitPlayer();
        UUID id = member.getUniqueId();
        if (!town.isPlayerLord((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        KonOfflinePlayer offlinePlayer = this.konquest.getPlayerManager().getOfflinePlayer(member);
        if (offlinePlayer == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(member.getName()));
            return false;
        }
        if (!offlinePlayer.getKingdom().equals(town.getKingdom())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_ENEMY_PLAYER.getMessage(new Object[0]));
            return false;
        }
        if (id.equals(bukkitPlayer.getUniqueId()) || town.isLord(id)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (!town.isPlayerResident(member)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_KNIGHT_RESIDENT.getMessage(new Object[0]));
            return false;
        }
        KonPlayer onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(id);
        if (action) {
            if (town.isPlayerKnight(member)) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_PROMOTE_KNIGHT.getMessage(member.getName()));
                return false;
            }
            town.setPlayerKnight(member, true);
            for (OfflinePlayer resident : town.getPlayerResidents()) {
                if (!resident.isOnline()) continue;
                ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_KNIGHT_SET.getMessage(member.getName(), town.getName()));
            }
        } else {
            if (!town.isPlayerKnight(member)) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TOWN_ERROR_DEMOTE_RESIDENT.getMessage(member.getName()));
                return false;
            }
            town.setPlayerKnight(offlinePlayer.getOfflineBukkitPlayer(), false);
            for (OfflinePlayer resident : town.getPlayerResidents()) {
                if (!resident.isOnline()) continue;
                ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_KNIGHT_CLEAR.getMessage(member.getName(), town.getName()));
            }
        }
        if (onlinePlayer != null) {
            this.updatePlayerMembershipStats(onlinePlayer);
        }
        return true;
    }

    public boolean menuTransferTownLord(KonPlayer sender, OfflinePlayer member, KonTown town, boolean isAdmin) {
        Player bukkitPlayer = sender.getBukkitPlayer();
        UUID id = member.getUniqueId();
        if (town.isLordValid() && !isAdmin && !town.isPlayerLord((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        KonOfflinePlayer offlinePlayer = this.konquest.getPlayerManager().getOfflinePlayer(member);
        if (offlinePlayer == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(member.getName()));
            return false;
        }
        if (!offlinePlayer.getKingdom().equals(town.getKingdom())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_ENEMY_PLAYER.getMessage(new Object[0]));
            return false;
        }
        if (!town.isPlayerResident(member)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (id.equals(bukkitPlayer.getUniqueId())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        town.setPlayerLord(member);
        for (OfflinePlayer resident : town.getPlayerResidents()) {
            if (!resident.isOnline()) continue;
            ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_LORD_SUCCESS.getMessage(town.getName(), member.getName()));
        }
        KonPlayer onlinePlayer = this.konquest.getPlayerManager().getPlayerFromID(id);
        if (onlinePlayer != null) {
            this.updatePlayerMembershipStats(onlinePlayer);
        }
        return true;
    }

    public void lordTownTakeover(KonPlayer player, KonTown town) {
        Player bukkitPlayer = player.getBukkitPlayer();
        if (town.isLordValid() || !town.isJoinable()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return;
        }
        if (!town.isOpen()) {
            if (!town.getPlayerKnights().isEmpty()) {
                if (!town.isPlayerKnight((OfflinePlayer)bukkitPlayer)) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    return;
                }
            } else if (!town.getPlayerResidents().isEmpty()) {
                if (!town.isPlayerResident((OfflinePlayer)bukkitPlayer)) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    return;
                }
            } else if (!town.getKingdom().equals(player.getKingdom())) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_ENEMY_TOWN.getMessage(new Object[0]));
                return;
            }
        }
        town.setPlayerLord((OfflinePlayer)bukkitPlayer);
        town.removeJoinRequest(bukkitPlayer.getUniqueId());
        for (OfflinePlayer resident : town.getPlayerResidents()) {
            if (!resident.isOnline()) continue;
            ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TOWN_NOTICE_LORD_CLAIM.getMessage(bukkitPlayer.getName(), town.getName()));
        }
        this.updatePlayerMembershipStats(player);
    }

    public String getSmallestKingdomName() {
        String smallestName = "";
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (!kingdom.isSmallest()) continue;
            smallestName = kingdom.getName();
        }
        return smallestName;
    }

    public void updateSmallestKingdom() {
        KonKingdom smallestKingdom = null;
        int smallestSize = Integer.MAX_VALUE;
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            kingdom.setSmallest(false);
            int size = this.konquest.getPlayerManager().getAllPlayersInKingdom(kingdom.getName()).size();
            if (size >= smallestSize) continue;
            smallestKingdom = kingdom;
            smallestSize = size;
        }
        if (smallestKingdom == null) {
            ChatUtil.printDebug("Failed to update smallest kingdom, got null!");
            return;
        }
        smallestKingdom.setSmallest(true);
        ChatUtil.printDebug("Updated smallest kingdom: " + smallestKingdom.getName());
    }

    public KonTerritory getClosestEnemyTown(Location loc, KonKingdom friendlyKingdom) {
        KonTown closestTerritory = null;
        int minDistance = Integer.MAX_VALUE;
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (kingdom.equals(friendlyKingdom)) continue;
            for (KonTown town : kingdom.getTowns()) {
                int townDist = HelperUtil.chunkDistance(loc, town.getCenterLoc());
                if (townDist == -1 || townDist >= minDistance) continue;
                minDistance = townDist;
                closestTerritory = town;
            }
        }
        return closestTerritory;
    }

    @Override
    public ArrayList<String> getKingdomNames() {
        return new ArrayList<String>(this.kingdomMap.keySet());
    }

    public ArrayList<KonKingdom> getKingdoms() {
        return new ArrayList<KonKingdom>(this.kingdomMap.values());
    }

    @Override
    public KonKingdom getKingdom(String name) {
        if (this.kingdomMap.containsKey(name)) {
            return this.kingdomMap.get(name);
        }
        if (name.equalsIgnoreCase("barbarians")) {
            return this.barbarians;
        }
        for (String kingdomName : this.kingdomMap.keySet()) {
            if (!name.equalsIgnoreCase(kingdomName)) continue;
            return this.kingdomMap.get(kingdomName);
        }
        ChatUtil.printDebug("KingdomManager couldn't get Kingdom! " + name);
        return this.barbarians;
    }

    @Override
    public boolean isKingdom(String name) {
        if (this.kingdomMap.containsKey(name)) {
            return true;
        }
        for (String kingdomName : this.kingdomMap.keySet()) {
            if (!name.equalsIgnoreCase(kingdomName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ArrayList<String> getTownNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            names.addAll(kingdom.getTownNames());
        }
        return names;
    }

    @Nullable
    public KonTown getTown(String name) {
        KonTown result = null;
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (!kingdom.hasTown(name)) continue;
            result = kingdom.getTown(name);
        }
        return result;
    }

    @Override
    public boolean isTown(String name) {
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (!kingdom.hasTown(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public KonCapital getCapital(String name) {
        KonCapital result = null;
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (!kingdom.hasCapital(name)) continue;
            result = kingdom.getCapital();
        }
        return result;
    }

    public boolean isCapital(String name) {
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (!kingdom.hasCapital(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public KonTown getTownCapital(String name) {
        for (KonKingdom kingdom : this.kingdomMap.values()) {
            if (kingdom.hasCapital(name)) {
                return kingdom.getCapital();
            }
            if (!kingdom.hasTown(name)) continue;
            return kingdom.getTown(name);
        }
        return null;
    }

    @Override
    public KonKingdom getBarbarians() {
        return this.barbarians;
    }

    @Override
    public KonKingdom getNeutrals() {
        return this.neutrals;
    }

    public void reloadMonumentsForTemplate(KonMonumentTemplate template) {
        for (KonKingdom kingdom : this.getKingdoms()) {
            if (!kingdom.isMonumentTemplateValid() || !kingdom.getMonumentTemplate().equals(template)) continue;
            kingdom.reloadLoadedTownMonuments();
        }
    }

    public boolean isTownOptionFeatureEnabled(@NotNull KonTownOption option) {
        if (option.equals((Object)KonTownOption.ALLIED_BUILDING)) {
            return this.konquest.getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath(), false);
        }
        return true;
    }

    public boolean changeTownOption(KonTownOption option, KonTown town, Player bukkitPlayer) {
        boolean currentValue = town.getTownOption(option);
        boolean result = currentValue ? this.setTownOption(option, town, (CommandSender)bukkitPlayer, false) : this.setTownOption(option, town, (CommandSender)bukkitPlayer, true);
        return result;
    }

    public boolean setTownOption(KonTownOption option, KonTown town, CommandSender messageSender, boolean value) {
        if (!this.isTownOptionFeatureEnabled(option)) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        if (town.isTownOptionOverridden(option)) {
            ChatUtil.sendError(messageSender, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        boolean result = town.setTownOption(option, value);
        String statusMessage = "";
        switch (option) {
            case OPEN: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_CLOSE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_OPEN.getMessage(town.getName());
                break;
            }
            case PLOTS_ONLY: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_PLOT_DISABLE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_PLOT_ENABLE.getMessage(town.getName());
                break;
            }
            case ALLIED_BUILDING: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_ALLIED_BUILDING_DISABLE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_ALLIED_BUILDING_ENABLE.getMessage(town.getName());
                break;
            }
            case FRIENDLY_REDSTONE: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_FRIENDLY_REDSTONE_DISABLE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_FRIENDLY_REDSTONE_ENABLE.getMessage(town.getName());
                break;
            }
            case ENEMY_REDSTONE: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_REDSTONE_DISABLE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_REDSTONE_ENABLE.getMessage(town.getName());
                break;
            }
            case GOLEM_OFFENSE: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_GOLEM_DISABLE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_GOLEM_ENABLE.getMessage(town.getName());
                break;
            }
            case KINGDOM_RESIDENTS: {
                if (!value) {
                    statusMessage = MessagePath.COMMAND_TOWN_NOTICE_KINGDOM_RESIDENT_DISABLE.getMessage(town.getName());
                    break;
                }
                statusMessage = MessagePath.COMMAND_TOWN_NOTICE_KINGDOM_RESIDENT_ENABLE.getMessage(town.getName());
                break;
            }
            default: {
                statusMessage = MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage("Missing town option case " + String.valueOf((Object)option) + " in KingdomManager#setTownOption");
            }
        }
        boolean isSenderResident = false;
        for (OfflinePlayer resident : town.getPlayerResidents()) {
            if (resident.isOnline()) {
                ChatUtil.sendNotice((CommandSender)((Player)resident), statusMessage);
            }
            if (!resident.equals((Object)messageSender)) continue;
            isSenderResident = true;
        }
        if (!isSenderResident) {
            ChatUtil.sendNotice(messageSender, statusMessage);
        }
        return result;
    }

    private void makeTownNerfs() {
        this.townNerfs.put(CompatibilityUtil.getMiningFatigue(), 0);
    }

    public void applyTownNerf(KonPlayer player, KonTown town) {
        if (!player.isAdminBypassActive()) {
            for (PotionEffectType pot : this.townNerfs.keySet()) {
                int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.FATIGUE);
                int upgradedPotLevel = this.townNerfs.get(pot) + upgradeLevel;
                player.getBukkitPlayer().addPotionEffect(new PotionEffect(pot, 9999999, upgradedPotLevel));
            }
        }
    }

    public void clearTownNerf(KonPlayer player) {
        for (PotionEffectType pot : this.townNerfs.keySet()) {
            player.getBukkitPlayer().removePotionEffect(pot);
        }
    }

    public void clearAllTownNerfs(KonTown town) {
        for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!town.isLocInside(player.getBukkitPlayer().getLocation())) continue;
            this.clearTownNerf(player);
        }
    }

    public void refreshTownNerfs(KonTown town) {
        for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!town.isLocInside(player.getBukkitPlayer().getLocation())) continue;
            if (this.isPlayerEnemy(player, town.getKingdom())) {
                this.applyTownNerf(player, town);
                continue;
            }
            this.clearTownNerf(player);
        }
    }

    public void refreshTownNerfs(KonKingdom kingdom) {
        for (KonTown town : kingdom.getCapitalTowns()) {
            this.refreshTownNerfs(town);
        }
    }

    public boolean isTownNerf(PotionEffectType pot) {
        return this.townNerfs.containsKey(pot);
    }

    public void applyTownHearts(KonPlayer player, KonTown town) {
        if (player.getKingdom().equals(town.getKingdom())) {
            String modName = Konquest.healthModName;
            NamespacedKey modKey = this.konquest.healthModKey;
            int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.HEALTH);
            if (upgradeLevel >= 1) {
                double modifier = upgradeLevel * 2;
                CompatibilityUtil.applyHealthModifier(player.getBukkitPlayer(), modifier, modName, modKey);
            } else {
                CompatibilityUtil.removeHealthModifier(player.getBukkitPlayer(), modName, modKey);
            }
        }
    }

    public void clearTownHearts(KonPlayer player) {
        String modName = Konquest.healthModName;
        NamespacedKey modKey = this.konquest.healthModKey;
        CompatibilityUtil.removeHealthModifier(player.getBukkitPlayer(), modName, modKey);
    }

    public void clearAllTownHearts(KonTown town) {
        for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!town.isLocInside(player.getBukkitPlayer().getLocation())) continue;
            this.clearTownHearts(player);
        }
    }

    public void refreshTownHearts(KonTown town) {
        for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!town.isLocInside(player.getBukkitPlayer().getLocation())) continue;
            this.clearTownHearts(player);
            if (!player.getKingdom().equals(town.getKingdom())) continue;
            this.applyTownHearts(player, town);
        }
    }

    public void updateKingdomOfflineProtection() {
        this.updateKingdomOfflineProtection(false);
    }

    public void updateKingdomOfflineProtection(boolean force) {
        boolean isOfflineProtectedEnabled = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_ENEMY_EDIT_OFFLINE.getPath(), true);
        int offlineProtectedWarmupSeconds = this.konquest.getCore().getInt(CorePath.KINGDOMS_NO_ENEMY_EDIT_OFFLINE_WARMUP.getPath(), 0);
        int offlineProtectedMinimumPlayers = this.konquest.getCore().getInt(CorePath.KINGDOMS_NO_ENEMY_EDIT_OFFLINE_MINIMUM.getPath(), 0);
        int warmupMinutes = offlineProtectedWarmupSeconds / 60;
        int warmupSeconds = offlineProtectedWarmupSeconds % 60;
        String warmupTime = String.format("%d:%02d", warmupMinutes, warmupSeconds);
        for (KonKingdom kingdom : this.getKingdoms()) {
            if (isOfflineProtectedEnabled) {
                ArrayList<KonPlayer> onlineKingdomPlayers = this.konquest.getPlayerManager().getPlayersInKingdom(kingdom.getName());
                int numOnlineKingdomPlayers = onlineKingdomPlayers.size();
                Timer protectedWarmupTimer = kingdom.getProtectedWarmupTimer();
                if (offlineProtectedMinimumPlayers <= 0 && onlineKingdomPlayers.isEmpty() || numOnlineKingdomPlayers < offlineProtectedMinimumPlayers) {
                    if (offlineProtectedWarmupSeconds > 0 && protectedWarmupTimer.getTime() == -1 && !kingdom.isOfflineProtected()) {
                        ChatUtil.printDebug("Starting kingdom protection warmup timer for " + offlineProtectedWarmupSeconds + " seconds: " + kingdom.getName());
                        protectedWarmupTimer.stopTimer();
                        protectedWarmupTimer.setTime(offlineProtectedWarmupSeconds);
                        protectedWarmupTimer.startTimer();
                        ChatUtil.sendBroadcast(String.valueOf(ChatColor.LIGHT_PURPLE) + MessagePath.PROTECTION_NOTICE_KINGDOM_WARMUP.getMessage(kingdom.getName(), warmupTime));
                    }
                } else {
                    kingdom.setOfflineProtected(false);
                    protectedWarmupTimer.stopTimer();
                }
            }
            ArrayList<String> protectedTownNames = new ArrayList<String>();
            for (KonTown town : kingdom.getCapitalTowns()) {
                if (!town.updateProtection(force)) continue;
                protectedTownNames.add(town.getName());
            }
            if (protectedTownNames.isEmpty() || force) continue;
            ChatUtil.sendBroadcast(String.valueOf(ChatColor.LIGHT_PURPLE) + MessagePath.PROTECTION_NOTICE_TOWN_WARMUP.getMessage(kingdom.getName(), warmupTime, HelperUtil.formatCommaSeparatedList(protectedTownNames)));
        }
    }

    public double getSettleCost(KonOfflinePlayer player) {
        double cost = this.konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE.getPath());
        double incrementCost = this.konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE_INCREMENT.getPath());
        boolean isIncrementKingdom = this.konquest.getCore().getBoolean(CorePath.TOWNS_SETTLE_INCREMENT_KINGDOM.getPath(), false);
        int townCount = isIncrementKingdom ? player.getKingdom().getNumTowns() : this.getPlayerLordships(player);
        return (double)townCount * incrementCost + cost;
    }

    public int getPlayerLordships(KonOfflinePlayer player) {
        int count = 0;
        for (KonTown town : player.getKingdom().getCapitalTowns()) {
            if (!town.isPlayerLord(player.getOfflineBukkitPlayer())) continue;
            ++count;
        }
        return count;
    }

    public int getPlayerResidencies(KonOfflinePlayer player) {
        int count = 0;
        for (KonTown town : player.getKingdom().getCapitalTowns()) {
            if (!town.isPlayerResident(player.getOfflineBukkitPlayer())) continue;
            ++count;
        }
        return count;
    }

    public List<KonTown> getPlayerLordshipTowns(KonquestOfflinePlayer player) {
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        if (player.getKingdom() instanceof KonKingdom) {
            KonKingdom kingdom = (KonKingdom)player.getKingdom();
            for (KonTown town : kingdom.getCapitalTowns()) {
                if (!town.isPlayerLord(player.getOfflineBukkitPlayer())) continue;
                towns.add(town);
            }
        }
        return towns;
    }

    @NotNull
    public List<KonTown> getPlayerKnightTowns(KonquestOfflinePlayer player) {
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        if (player.getKingdom() instanceof KonKingdom) {
            KonKingdom kingdom = (KonKingdom)player.getKingdom();
            for (KonTown town : kingdom.getCapitalTowns()) {
                if (!town.isPlayerKnight(player.getOfflineBukkitPlayer()) || town.isPlayerLord(player.getOfflineBukkitPlayer())) continue;
                towns.add(town);
            }
        }
        return towns;
    }

    @NotNull
    public List<KonTown> getPlayerResidenceTowns(KonquestOfflinePlayer player) {
        ArrayList<KonTown> towns = new ArrayList<KonTown>();
        if (player.getKingdom() instanceof KonKingdom) {
            KonKingdom kingdom = (KonKingdom)player.getKingdom();
            for (KonTown town : kingdom.getCapitalTowns()) {
                if (!town.isPlayerResident(player.getOfflineBukkitPlayer())) continue;
                towns.add(town);
            }
        }
        return towns;
    }

    public void checkPlayerMemberships(KonPlayer player) {
        KonKingdom playerKingdom = player.getKingdom();
        Player bukkitPlayer = player.getBukkitPlayer();
        UUID id = bukkitPlayer.getUniqueId();
        for (KonKingdom kingdom : this.getKingdoms()) {
            if (kingdom.equals(playerKingdom)) continue;
            if (kingdom.isMember(id)) {
                if (kingdom.removeMember(id)) {
                    ChatUtil.printDebug("Cleaned kingdom membership of " + kingdom.getName() + " for player " + bukkitPlayer.getName());
                } else {
                    ChatUtil.printDebug("FAILED to clean kingdom membership of " + kingdom.getName() + " for player " + bukkitPlayer.getName());
                }
            }
            for (KonTown town : kingdom.getCapitalTowns()) {
                if (!town.isPlayerResident((OfflinePlayer)bukkitPlayer)) continue;
                if (town.removePlayerResident((OfflinePlayer)bukkitPlayer)) {
                    ChatUtil.printDebug("Cleaned town residency of " + town.getName() + " in kingdom " + kingdom.getName() + " for player " + bukkitPlayer.getName());
                    continue;
                }
                ChatUtil.printDebug("FAILED to clean town residency of " + town.getName() + " in kingdom " + kingdom.getName() + " for player " + bukkitPlayer.getName());
            }
        }
    }

    public void updatePlayerMembershipStats(KonPlayer player) {
        int countLord = 0;
        int countElite = 0;
        int countResident = 0;
        for (KonTown town : player.getKingdom().getCapitalTowns()) {
            if (town.isPlayerLord(player.getOfflineBukkitPlayer())) {
                ++countLord;
                continue;
            }
            if (town.isPlayerKnight(player.getOfflineBukkitPlayer())) {
                ++countElite;
                continue;
            }
            if (!town.isPlayerResident(player.getOfflineBukkitPlayer())) continue;
            ++countResident;
        }
        player.getPlayerStats().setStat(KonStatsType.LORDS, countLord);
        player.getPlayerStats().setStat(KonStatsType.KNIGHTS, countElite);
        player.getPlayerStats().setStat(KonStatsType.RESIDENTS, countResident);
    }

    @NotNull
    public KonLeaderboard getKingdomLeaderboard(KonKingdom kingdom) {
        KonLeaderboard leaderboard = new KonLeaderboard();
        if (kingdom.equals(this.barbarians)) {
            return leaderboard;
        }
        int weight_town_lords = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_TOWN_LORDS.getPath());
        int weight_town_knights = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_TOWN_KNIGHTS.getPath());
        int weight_town_residents = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_TOWN_RESIDENTS.getPath());
        int weight_land_lords = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_LAND_LORDS.getPath());
        int weight_land_knights = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_LAND_KNIGHTS.getPath());
        int weight_land_residents = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_LAND_RESIDENTS.getPath());
        HashMap<OfflinePlayer, KonPlayerScoreAttributes> memberScores = new HashMap<OfflinePlayer, KonPlayerScoreAttributes>();
        for (KonTown town : kingdom.getCapitalTowns()) {
            for (OfflinePlayer offlinePlayer : town.getPlayerResidents()) {
                int numTownLords = 0;
                int numTownKnights = 0;
                int numTownResidents = 0;
                int numLordLand = 0;
                int numKnightLand = 0;
                int numResidentLand = 0;
                if (town.isPlayerLord(offlinePlayer)) {
                    ++numTownLords;
                    numLordLand += town.getChunkList().size();
                } else if (town.isPlayerKnight(offlinePlayer)) {
                    ++numTownKnights;
                    numKnightLand += town.getChunkList().size();
                } else {
                    ++numTownResidents;
                    numResidentLand += town.getChunkList().size();
                }
                if (memberScores.containsKey(offlinePlayer)) {
                    ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).addAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS, numTownLords);
                    ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).addAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS, numTownKnights);
                    ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).addAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS, numTownResidents);
                    ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).addAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS, numLordLand);
                    ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).addAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS, numKnightLand);
                    ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).addAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS, numResidentLand);
                    continue;
                }
                KonOfflinePlayer validPlayer = this.konquest.getPlayerManager().getOfflinePlayer(offlinePlayer);
                if (validPlayer == null || !validPlayer.getKingdom().equals(kingdom)) continue;
                KonPlayerScoreAttributes newMemberAttributes = new KonPlayerScoreAttributes();
                newMemberAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS, weight_town_lords);
                newMemberAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS, weight_town_knights);
                newMemberAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS, weight_town_residents);
                newMemberAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS, weight_land_lords);
                newMemberAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS, weight_land_knights);
                newMemberAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS, weight_land_residents);
                newMemberAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS, numTownLords);
                newMemberAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS, numTownKnights);
                newMemberAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS, numTownResidents);
                newMemberAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS, numLordLand);
                newMemberAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS, numKnightLand);
                newMemberAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS, numResidentLand);
                memberScores.put(offlinePlayer, newMemberAttributes);
            }
        }
        int NUM_TOP_PLAYERS = 9;
        int topScore = 0;
        OfflinePlayer topPlayer = null;
        for (int i = 0; i < 9; ++i) {
            if (memberScores.isEmpty()) continue;
            for (OfflinePlayer offlinePlayer : memberScores.keySet()) {
                int playerScore = ((KonPlayerScoreAttributes)memberScores.get(offlinePlayer)).getScore();
                if (playerScore <= topScore) continue;
                topScore = playerScore;
                topPlayer = offlinePlayer;
            }
            if (topPlayer == null) continue;
            leaderboard.addEntry(topPlayer, topScore);
            memberScores.remove(topPlayer);
            topScore = 0;
            topPlayer = null;
        }
        return leaderboard;
    }

    @NotNull
    public KonKingdomScoreAttributes getKingdomScoreAttributes(KonKingdom kingdom) {
        KonKingdomScoreAttributes scoreAttributes = new KonKingdomScoreAttributes();
        if (kingdom.isCreated() && !kingdom.isPeaceful()) {
            int numKingdomTowns = kingdom.getTowns().size();
            ArrayList<KonOfflinePlayer> allPlayersInKingdom = this.konquest.getPlayerManager().getAllPlayersInKingdom(kingdom.getName());
            int numAllKingdomPlayers = allPlayersInKingdom.size();
            int numKingdomLand = 0;
            for (KonTown konTown : kingdom.getCapitalTowns()) {
                numKingdomLand += konTown.getChunkList().size();
            }
            int numKingdomFavor = 0;
            for (KonOfflinePlayer kingdomPlayer : allPlayersInKingdom) {
                numKingdomFavor += (int)KonquestPlugin.getBalance(kingdomPlayer.getOfflineBukkitPlayer());
            }
            int n = (int)this.konquest.getCore().getDouble(CorePath.SCORE_KINGDOM_TOWNS.getPath());
            int weight_land = (int)this.konquest.getCore().getDouble(CorePath.SCORE_KINGDOM_LAND.getPath());
            int weight_favor = (int)this.konquest.getCore().getDouble(CorePath.SCORE_KINGDOM_FAVOR.getPath());
            int weight_population = (int)this.konquest.getCore().getDouble(CorePath.SCORE_KINGDOM_POPULATION.getPath());
            scoreAttributes.setAttributeWeight(KonKingdomScoreAttributes.ScoreAttribute.TOWNS, n);
            scoreAttributes.setAttributeWeight(KonKingdomScoreAttributes.ScoreAttribute.LAND, weight_land);
            scoreAttributes.setAttributeWeight(KonKingdomScoreAttributes.ScoreAttribute.FAVOR, weight_favor);
            scoreAttributes.setAttributeWeight(KonKingdomScoreAttributes.ScoreAttribute.POPULATION, weight_population);
            scoreAttributes.setAttribute(KonKingdomScoreAttributes.ScoreAttribute.TOWNS, numKingdomTowns);
            scoreAttributes.setAttribute(KonKingdomScoreAttributes.ScoreAttribute.LAND, numKingdomLand);
            scoreAttributes.setAttribute(KonKingdomScoreAttributes.ScoreAttribute.FAVOR, numKingdomFavor);
            scoreAttributes.setAttribute(KonKingdomScoreAttributes.ScoreAttribute.POPULATION, numAllKingdomPlayers);
        }
        return scoreAttributes;
    }

    public int getKingdomScore(KonKingdom kingdom) {
        return this.getKingdomScoreAttributes(kingdom).getScore();
    }

    @NotNull
    public KonPlayerScoreAttributes getPlayerScoreAttributes(KonOfflinePlayer offlinePlayer) {
        KonPlayerScoreAttributes scoreAttributes = new KonPlayerScoreAttributes();
        if (!offlinePlayer.isBarbarian() && !offlinePlayer.getKingdom().isPeaceful()) {
            int numTownLords = 0;
            int numTownKnights = 0;
            int numTownResidents = 0;
            int numLordLand = 0;
            int numKnightLand = 0;
            int numResidentLand = 0;
            for (KonTown town : offlinePlayer.getKingdom().getCapitalTowns()) {
                if (town.isPlayerLord(offlinePlayer.getOfflineBukkitPlayer())) {
                    ++numTownLords;
                    numLordLand += town.getChunkList().size();
                    continue;
                }
                if (town.isPlayerKnight(offlinePlayer.getOfflineBukkitPlayer())) {
                    ++numTownKnights;
                    numKnightLand += town.getChunkList().size();
                    continue;
                }
                if (!town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++numTownResidents;
                numResidentLand += town.getChunkList().size();
            }
            int weight_town_lords = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_TOWN_LORDS.getPath());
            int weight_town_knights = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_TOWN_KNIGHTS.getPath());
            int weight_town_residents = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_TOWN_RESIDENTS.getPath());
            int weight_land_lords = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_LAND_LORDS.getPath());
            int weight_land_knights = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_LAND_KNIGHTS.getPath());
            int weight_land_residents = (int)this.konquest.getCore().getDouble(CorePath.SCORE_PLAYER_LAND_RESIDENTS.getPath());
            scoreAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS, weight_town_lords);
            scoreAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS, weight_town_knights);
            scoreAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS, weight_town_residents);
            scoreAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS, weight_land_lords);
            scoreAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS, weight_land_knights);
            scoreAttributes.setAttributeWeight(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS, weight_land_residents);
            scoreAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_LORDS, numTownLords);
            scoreAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_KNIGHTS, numTownKnights);
            scoreAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.TOWN_RESIDENTS, numTownResidents);
            scoreAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_LORDS, numLordLand);
            scoreAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_KNIGHTS, numKnightLand);
            scoreAttributes.setAttribute(KonPlayerScoreAttributes.ScoreAttribute.LAND_RESIDENTS, numResidentLand);
        }
        return scoreAttributes;
    }

    public int getPlayerScore(KonOfflinePlayer offlinePlayer) {
        return this.getPlayerScoreAttributes(offlinePlayer).getScore();
    }

    public void updateAllTownDisabledUpgrades() {
        for (KonKingdom kingdom : this.getKingdoms()) {
            this.konquest.getUpgradeManager().updateTownDisabledUpgrades(kingdom.getCapital());
            for (KonTown town : kingdom.getTowns()) {
                this.konquest.getUpgradeManager().updateTownDisabledUpgrades(town);
            }
        }
    }

    public boolean isPlayerJoinCooldown(OfflinePlayer player) {
        UUID id = player.getUniqueId();
        if (!this.joinPlayerCooldowns.containsKey(id)) {
            return false;
        }
        Date now = new Date();
        long endSeconds = this.joinPlayerCooldowns.get(id).intValue();
        if (now.after(new Date(endSeconds * 1000L))) {
            this.joinPlayerCooldowns.remove(id);
            return false;
        }
        return true;
    }

    public void applyPlayerJoinCooldown(OfflinePlayer player) {
        if (this.joinCooldownSeconds <= 0) {
            return;
        }
        UUID id = player.getUniqueId();
        int endTimeSeconds = (int)(new Date().getTime() / 1000L) + this.joinCooldownSeconds;
        this.joinPlayerCooldowns.put(id, endTimeSeconds);
    }

    public int getJoinCooldownRemainingSeconds(OfflinePlayer player) {
        UUID id = player.getUniqueId();
        if (!this.joinPlayerCooldowns.containsKey(id)) {
            return 0;
        }
        Date now = new Date();
        int endSeconds = this.joinPlayerCooldowns.get(id);
        if (now.after(new Date((long)endSeconds * 1000L))) {
            return 0;
        }
        return endSeconds - (int)(now.getTime() / 1000L);
    }

    public String getJoinCooldownRemainingTimeFormat(OfflinePlayer player, ChatColor color) {
        String remainCooldown = "";
        int cooldown = this.getJoinCooldownRemainingSeconds(player);
        if (cooldown > 0) {
            remainCooldown = HelperUtil.getTimeFormat(cooldown, color);
        }
        return remainCooldown;
    }

    public boolean isPlayerExileCooldown(OfflinePlayer player) {
        UUID id = player.getUniqueId();
        if (!this.exilePlayerCooldowns.containsKey(id)) {
            return false;
        }
        Date now = new Date();
        long endSeconds = this.exilePlayerCooldowns.get(id).intValue();
        if (now.after(new Date(endSeconds * 1000L))) {
            this.exilePlayerCooldowns.remove(id);
            return false;
        }
        return true;
    }

    public void applyPlayerExileCooldown(OfflinePlayer player) {
        if (this.exileCooldownSeconds <= 0) {
            return;
        }
        UUID id = player.getUniqueId();
        int endTimeSeconds = (int)(new Date().getTime() / 1000L) + this.exileCooldownSeconds;
        this.exilePlayerCooldowns.put(id, endTimeSeconds);
    }

    public int getExileCooldownRemainingSeconds(OfflinePlayer player) {
        UUID id = player.getUniqueId();
        if (!this.exilePlayerCooldowns.containsKey(id)) {
            return 0;
        }
        Date now = new Date();
        int endSeconds = this.exilePlayerCooldowns.get(id);
        if (now.after(new Date((long)endSeconds * 1000L))) {
            return 0;
        }
        return endSeconds - (int)(now.getTime() / 1000L);
    }

    public String getExileCooldownRemainingTimeFormat(OfflinePlayer player, ChatColor color) {
        String remainCooldown = "";
        int cooldown = this.getExileCooldownRemainingSeconds(player);
        if (cooldown > 0) {
            remainCooldown = HelperUtil.getTimeFormat(cooldown, color);
        }
        return remainCooldown;
    }

    public void loadJoinExileCooldowns() {
        int endSeconds;
        int maxEndSeconds;
        int nowSeconds;
        this.joinCooldownSeconds = this.konquest.getCore().getInt(CorePath.KINGDOMS_JOIN_COOLDOWN.getPath(), 0);
        this.exileCooldownSeconds = this.konquest.getCore().getInt(CorePath.KINGDOMS_EXILE_COOLDOWN.getPath(), 0);
        if (!this.joinPlayerCooldowns.isEmpty()) {
            HashMap<UUID, Integer> updateJoinMap = new HashMap<UUID, Integer>();
            if (this.joinCooldownSeconds > 0) {
                nowSeconds = (int)(new Date().getTime() / 1000L);
                maxEndSeconds = nowSeconds + this.joinCooldownSeconds;
                for (UUID u : this.joinPlayerCooldowns.keySet()) {
                    endSeconds = this.joinPlayerCooldowns.get(u);
                    updateJoinMap.put(u, Math.min(endSeconds, maxEndSeconds));
                }
            }
            this.joinPlayerCooldowns.clear();
            this.joinPlayerCooldowns.putAll(updateJoinMap);
        }
        if (!this.exilePlayerCooldowns.isEmpty()) {
            HashMap<UUID, Integer> updateExileMap = new HashMap<UUID, Integer>();
            if (this.exileCooldownSeconds > 0) {
                nowSeconds = (int)(new Date().getTime() / 1000L);
                maxEndSeconds = nowSeconds + this.exileCooldownSeconds;
                for (UUID u : this.exilePlayerCooldowns.keySet()) {
                    endSeconds = this.exilePlayerCooldowns.get(u);
                    updateExileMap.put(u, Math.min(endSeconds, maxEndSeconds));
                }
            }
            this.exilePlayerCooldowns.clear();
            this.exilePlayerCooldowns.putAll(updateExileMap);
        }
    }

    @Override
    public Material getTownCriticalBlock() {
        return this.townCriticalBlock;
    }

    @Override
    public int getMaxCriticalHits() {
        return this.maxCriticalHits;
    }

    public void loadCriticalBlocks() {
        this.maxCriticalHits = this.konquest.getCore().getInt(CorePath.MONUMENTS_DESTROY_AMOUNT.getPath(), 12);
        String townCriticalBlockTypeName = this.konquest.getCore().getString(CorePath.MONUMENTS_CRITICAL_BLOCK.getPath(), "");
        try {
            this.townCriticalBlock = Material.valueOf((String)townCriticalBlockTypeName);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid monument critical block \"" + townCriticalBlockTypeName + "\" given in core.monuments.critical_block, using default OBSIDIAN";
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
        }
    }

    public boolean isArmorValid(Material mat) {
        boolean result = false;
        result = this.isArmorBlockWhitelist ? this.armorBlocks.contains(mat) : !this.armorBlocks.contains(mat);
        return result;
    }

    public void loadArmorBlacklist() {
        this.armorBlocks.clear();
        this.isArmorBlockWhitelist = this.konquest.getCore().getBoolean(CorePath.TOWNS_ARMOR_BLACKLIST_REVERSE.getPath(), false);
        boolean isListEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ARMOR_BLACKLIST_ENABLE.getPath(), false);
        if (isListEnabled) {
            List armorList = this.konquest.getCore().getStringList(CorePath.TOWNS_ARMOR_BLACKLIST.getPath());
            for (String entry : armorList) {
                Material mat = Material.matchMaterial((String)entry);
                if (mat != null) {
                    this.armorBlocks.add(mat);
                    continue;
                }
                ChatUtil.printConsoleWarning("Invalid material \"" + entry + "\" in " + CorePath.TOWNS_ARMOR_BLACKLIST.getPath() + ", ignoring.");
            }
        }
    }

    public boolean applyTownPurchaseOffer(KonTown town, KonPlayer player, double amount) {
        if (town == null) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        if (!this.townPurchaseEnable) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        if (player.isBarbarian()) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return false;
        }
        if (town.getKingdom().equals(player.getKingdom()) || town instanceof KonCapital || amount < 1.0) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        String offerAmount = KonquestPlugin.getCurrencyFormat(amount);
        if (KonquestPlugin.getBalance((OfflinePlayer)player.getBukkitPlayer()) < amount) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(offerAmount));
            return false;
        }
        town.addPurchaseOffer(player.getBukkitPlayer().getUniqueId(), amount);
        ChatUtil.sendNotice(player, MessagePath.COMMAND_KINGDOM_NOTICE_OFFER_PURCHASE.getMessage(town.getName(), town.getKingdom().getName(), offerAmount));
        int numOffers = this.konquest.getKingdomManager().getNumTownPurchaseOffers(town.getKingdom());
        this.broadcastOfficers(town.getKingdom(), MessagePath.COMMAND_KINGDOM_NOTICE_OFFER_PENDING.getMessage(numOffers));
        return true;
    }

    public boolean respondTownPurchaseOffer(KonTown town, KonPlayer player, UUID offerID, boolean response) {
        if (town == null) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        if (!this.townPurchaseEnable) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        KonOfflinePlayer offerPlayer = this.konquest.getPlayerManager().getOfflinePlayerFromID(offerID);
        if (offerPlayer == null) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        if (offerPlayer.isBarbarian() || town.getKingdom().equals(offerPlayer.getKingdom()) || town instanceof KonCapital) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
            return false;
        }
        if (!response) {
            town.removePurchaseOffer(offerID);
            ChatUtil.sendNotice(player, MessagePath.COMMAND_KINGDOM_NOTICE_OFFER_DECLINED.getMessage(offerPlayer.getOfflineBukkitPlayer().getName(), town.getName()));
            return false;
        }
        double offerAmount = town.getPurchaseOfferAmount(offerID);
        if (offerAmount < 1.0 || KonquestPlugin.getBalance(offerPlayer.getOfflineBukkitPlayer()) < offerAmount) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return false;
        }
        KonquestPlugin.withdrawPlayer(offerPlayer.getOfflineBukkitPlayer(), offerAmount);
        if (town.getKingdom().isMasterValid()) {
            KonquestPlugin.depositPlayer(town.getKingdom().getPlayerMaster(), offerAmount);
        } else {
            KonquestPlugin.depositPlayer((OfflinePlayer)player.getBukkitPlayer(), offerAmount);
        }
        KonTown purchasedTown = this.captureTown(town.getName(), town.getKingdom().getName(), offerPlayer.getKingdom());
        if (purchasedTown == null) {
            ChatUtil.sendError(player, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
            return false;
        }
        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_PURCHASE.getMessage(purchasedTown.getName(), purchasedTown.getKingdom().getName()));
        purchasedTown.setPlayerLord(offerPlayer.getOfflineBukkitPlayer());
        return true;
    }

    public void refreshPurchaseOffers(KonTown town) {
        for (UUID id : town.getPurchaseOffers()) {
            if (!this.townPurchaseEnable || town instanceof KonCapital) {
                town.removePurchaseOffer(id);
                continue;
            }
            KonOfflinePlayer offerPlayer = this.konquest.getPlayerManager().getOfflinePlayerFromID(id);
            if (offerPlayer == null) continue;
            if (offerPlayer.isBarbarian() || town.getKingdom().equals(offerPlayer.getKingdom())) {
                town.removePurchaseOffer(id);
                continue;
            }
            double offerAmount = town.getPurchaseOfferAmount(id);
            if (!(offerAmount < 1.0) && !(KonquestPlugin.getBalance(offerPlayer.getOfflineBukkitPlayer()) < offerAmount)) continue;
            town.removePurchaseOffer(id);
        }
    }

    public int getNumTownPurchaseOffers(KonKingdom kingdom) {
        int result = 0;
        for (KonTown town : kingdom.getTowns()) {
            this.refreshPurchaseOffers(town);
            result += town.getNumPurchaseOffers();
        }
        return result;
    }

    public List<KonTown> getActiveTownPurchaseOffers(KonKingdom kingdom) {
        ArrayList<KonTown> result = new ArrayList<KonTown>();
        for (KonTown town : kingdom.getTowns()) {
            this.refreshPurchaseOffers(town);
            if (!town.hasPurchaseOffers()) continue;
            result.add(town);
        }
        return result;
    }

    public List<OfflinePlayer> getPlayerTownPurchaseOffers(KonTown town) {
        this.refreshPurchaseOffers(town);
        ArrayList<OfflinePlayer> result = new ArrayList<OfflinePlayer>();
        for (UUID id : town.getPurchaseOffers()) {
            result.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return result;
    }

    private void assignDiplomacyTickets() {
        for (DiplomacyTicket ticket : this.diplomacyTickets) {
            KonquestDiplomacyType relation;
            KonKingdom otherKingdom;
            KonKingdom kingdom = this.getKingdom(ticket.getOwnerKingdomName());
            if (!kingdom.isCreated() || !(otherKingdom = this.getKingdom(ticket.getOtherKingdomName())).isCreated() || (relation = ticket.getRelation()) == null) continue;
            if (ticket.isActive()) {
                kingdom.setActiveRelation(otherKingdom, relation);
                continue;
            }
            kingdom.setRelationRequest(otherKingdom, relation);
        }
        this.diplomacyTickets.clear();
    }

    private void loadKingdoms() {
        FileConfiguration kingdomsConfig = this.konquest.getConfigManager().getConfig("kingdoms");
        if (kingdomsConfig.get("kingdoms") == null) {
            ChatUtil.printConsoleError("Failed to load any kingdoms from kingdoms.yml! Check file permissions.");
            this.isKingdomDataNull = true;
            return;
        }
        String defaultWorldName = this.konquest.getCore().getString(CorePath.WORLD_NAME.getPath(), "world");
        this.diplomacyTickets.clear();
        ConfigurationSection rootConfig = kingdomsConfig.getConfigurationSection("kingdoms");
        assert (rootConfig != null);
        int numKingdoms = 0;
        int numTowns = 0;
        for (String kingdomName : rootConfig.getKeys(false)) {
            ConfigurationSection kingdomTownsSection = rootConfig.getConfigurationSection(kingdomName + ".towns");
            if (kingdomTownsSection != null) {
                numTowns += kingdomTownsSection.getKeys(false).size();
            }
            ++numKingdoms;
        }
        LoadingPrinter loadBar = new LoadingPrinter(numTowns, "Loading " + numKingdoms + " Kingdoms with " + numTowns + " Towns");
        for (String kingdomName : rootConfig.getKeys(false)) {
            ConfigurationSection kingdomTownsSection;
            ConfigurationSection kingdomDiplomacyRequestSection;
            ConfigurationSection kingdomDiplomacyActiveSection;
            ConfigurationSection kingdomRequestsSection;
            String message;
            ConfigurationSection kingdomSection = rootConfig.getConfigurationSection(kingdomName);
            assert (kingdomSection != null);
            ConfigurationSection capitalSection = kingdomSection.getConfigurationSection("towns.capital");
            if (capitalSection == null) {
                ChatUtil.printConsoleError("Bad data format in kingdoms.yml for kingdom " + kingdomName + ", attempting to migrate legacy kingdom to current format.");
                boolean legacyStatus = this.loadLegacyKingdom(kingdomSection, kingdomName);
                if (legacyStatus) {
                    message = "Kingdom " + kingdomName + " was created in a legacy version of Konquest and has been migrated. Review the kingdom setup.";
                    ChatUtil.printConsoleAlert(message);
                } else {
                    message = "Kingdom " + kingdomName + " was created in a legacy version of Konquest and could not be migrated. The kingdom was deleted.";
                    ChatUtil.printConsoleError(message);
                }
                this.konquest.opStatusMessages.add(message);
                continue;
            }
            String worldName = capitalSection.getString("world", defaultWorldName);
            World capitalWorld = Bukkit.getWorld((String)worldName);
            if (capitalWorld == null) {
                message = "Failed to load kingdom " + kingdomName + " capital in an unloaded world, " + worldName + ". Check plugin load order.";
                ChatUtil.printConsoleError(message);
                this.konquest.opStatusMessages.add(message);
                continue;
            }
            List sectionList = capitalSection.getDoubleList("center");
            double x = (Double)sectionList.get(0);
            double y = (Double)sectionList.get(1);
            double z = (Double)sectionList.get(2);
            Location capitalCenter = new Location(capitalWorld, x, y, z);
            this.kingdomMap.put(kingdomName, new KonKingdom(capitalCenter, kingdomName, this.konquest));
            KonKingdom newKingdom = this.kingdomMap.get(kingdomName);
            boolean isAdmin = kingdomSection.getBoolean("admin", false);
            newKingdom.setIsAdminOperated(isAdmin);
            int webColor = kingdomSection.getInt("webcolor", -1);
            newKingdom.setWebColor(webColor);
            String templateName = kingdomSection.getString("template", "");
            if (this.konquest.getSanctuaryManager().isTemplate(templateName)) {
                KonMonumentTemplate template = this.konquest.getSanctuaryManager().getTemplate(templateName);
                newKingdom.setMonumentTemplate(template);
            } else {
                ChatUtil.printConsoleError("Missing monument template \"" + templateName + "\" for Kingdom " + kingdomName + " in loaded data file!");
                this.konquest.opStatusMessages.add("Missing monument template for Kingdom " + kingdomName + "! Use \"/k admin kingdom\" to set a monument template for this Kingdom.");
            }
            ConfigurationSection kingdomPropertiesSection = kingdomSection.getConfigurationSection("properties");
            if (kingdomPropertiesSection != null) {
                for (String propertyName : kingdomPropertiesSection.getKeys(false)) {
                    boolean value = kingdomPropertiesSection.getBoolean(propertyName);
                    Object property = KonPropertyFlag.getFlag(propertyName);
                    boolean status = newKingdom.setPropertyValue((KonPropertyFlag)((Object)property), value);
                    if (status) continue;
                    ChatUtil.printDebug("Failed to set invalid property " + propertyName + " to Kingdom " + kingdomName);
                }
            }
            boolean isKingdomOpen = kingdomSection.getBoolean("open", false);
            newKingdom.setIsOpen(isKingdomOpen);
            String masterUUID = kingdomSection.getString("master", "");
            if (!masterUUID.equalsIgnoreCase("")) {
                UUID playerID = HelperUtil.idFromString(masterUUID);
                if (playerID != null) {
                    newKingdom.forceMaster(playerID);
                } else {
                    ChatUtil.printDebug("Kingdom " + kingdomName + " has a null UUID! Master remains invalid");
                }
            } else {
                ChatUtil.printDebug("Kingdom " + kingdomName + " does not have a stored Master ID");
            }
            ConfigurationSection kingdomMembersSection = kingdomSection.getConfigurationSection("members");
            if (kingdomMembersSection != null) {
                for (String residentUUID : kingdomMembersSection.getKeys(false)) {
                    boolean isOfficer = kingdomMembersSection.getBoolean(residentUUID, false);
                    newKingdom.addMember(UUID.fromString(residentUUID), isOfficer);
                }
            }
            if ((kingdomRequestsSection = kingdomSection.getConfigurationSection("requests")) != null) {
                for (String requestUUID : kingdomRequestsSection.getKeys(false)) {
                    boolean type = kingdomRequestsSection.getBoolean(requestUUID, false);
                    newKingdom.addJoinRequest(UUID.fromString(requestUUID), type);
                }
            }
            if ((kingdomDiplomacyActiveSection = kingdomSection.getConfigurationSection("diplomacy_active")) != null) {
                for (String diplomacyKingdomName : kingdomDiplomacyActiveSection.getKeys(false)) {
                    String relationName = kingdomDiplomacyActiveSection.getString(diplomacyKingdomName);
                    if (relationName == null) continue;
                    KonquestDiplomacyType relation = KonquestDiplomacyType.getDefault();
                    try {
                        relation = KonquestDiplomacyType.valueOf(relationName);
                    }
                    catch (Exception e) {
                        ChatUtil.printConsoleAlert("Failed to parse active diplomacy relation " + relationName + " between kingdoms " + kingdomName + " and " + diplomacyKingdomName);
                    }
                    DiplomacyTicket ticket = new DiplomacyTicket(kingdomName, diplomacyKingdomName, relation, true);
                    this.diplomacyTickets.add(ticket);
                }
            }
            if ((kingdomDiplomacyRequestSection = kingdomSection.getConfigurationSection("diplomacy_request")) != null) {
                for (String diplomacyKingdomName : kingdomDiplomacyRequestSection.getKeys(false)) {
                    String relationName = kingdomDiplomacyRequestSection.getString(diplomacyKingdomName);
                    if (relationName == null) continue;
                    KonquestDiplomacyType relation = KonquestDiplomacyType.getDefault();
                    try {
                        relation = KonquestDiplomacyType.valueOf(relationName);
                    }
                    catch (Exception e) {
                        ChatUtil.printConsoleAlert("Failed to parse request diplomacy relation " + relationName + " between kingdoms " + kingdomName + " and " + diplomacyKingdomName);
                    }
                    DiplomacyTicket ticket = new DiplomacyTicket(kingdomName, diplomacyKingdomName, relation, false);
                    this.diplomacyTickets.add(ticket);
                }
            }
            if ((kingdomTownsSection = kingdomSection.getConfigurationSection("towns")) == null) {
                ChatUtil.printDebug("Internal error, null town section in kingdoms.yml for kingdom " + kingdomName);
                continue;
            }
            for (String townName : kingdomTownsSection.getKeys(false)) {
                boolean isCapital = townName.equals("capital");
                ConfigurationSection townSection = kingdomTownsSection.getConfigurationSection(townName);
                assert (townSection != null);
                this.loadTown(townSection, townName, kingdomName, isCapital);
                loadBar.addProgress(1);
            }
            if (newKingdom.isMonumentTemplateValid()) continue;
            this.konquest.opStatusMessages.add("Kingdom " + kingdomName + " has Towns with invalid Monuments. You must set up a valid Monument Template and restart the server.");
        }
        if (this.kingdomMap.isEmpty()) {
            ChatUtil.printConsoleAlert("There are no Kingdoms.");
        } else {
            this.assignDiplomacyTickets();
            ChatUtil.printDebug("Loaded Kingdoms");
        }
    }

    private boolean loadLegacyKingdom(ConfigurationSection kingdomSection, String kingdomName) {
        float yaw;
        float pitch;
        double val;
        ConfigurationSection capitalSection = kingdomSection.getConfigurationSection("capital");
        ConfigurationSection monumentSection = kingdomSection.getConfigurationSection("monument");
        ConfigurationSection townsSection = kingdomSection.getConfigurationSection("towns");
        if (capitalSection == null || monumentSection == null || townsSection == null) {
            ChatUtil.printDebug("Failed to load legacy kingdom " + kingdomName + ", missing primary sections.");
            return false;
        }
        Set townNames = townsSection.getKeys(false);
        if (townNames.isEmpty()) {
            ChatUtil.printDebug("Failed to load legacy kingdom " + kingdomName + ", no towns");
            return false;
        }
        String defaultWorldName = this.konquest.getCore().getString(CorePath.WORLD_NAME.getPath(), "world");
        String worldName = capitalSection.getString("world", defaultWorldName);
        World capitalWorld = Bukkit.getWorld((String)worldName);
        if (capitalWorld == null) {
            ChatUtil.printDebug("Failed to load legacy kingdom " + kingdomName + ", null world: " + worldName);
            return false;
        }
        List sectionList = capitalSection.getDoubleList("spawn");
        double x = (Double)sectionList.get(0);
        double y = (Double)sectionList.get(1);
        double z = (Double)sectionList.get(2);
        if (sectionList.size() > 3) {
            val = (Double)sectionList.get(3);
            pitch = (float)val;
        } else {
            pitch = 0.0f;
        }
        if (sectionList.size() > 4) {
            val = (Double)sectionList.get(4);
            yaw = (float)val;
        } else {
            yaw = 0.0f;
        }
        Location capital_spawn = new Location(capitalWorld, x, y, z, yaw, pitch);
        sectionList = capitalSection.getDoubleList("center");
        x = (Double)sectionList.get(0);
        y = (Double)sectionList.get(1);
        z = (Double)sectionList.get(2);
        Location capital_center = new Location(capitalWorld, x, y, z);
        ArrayList<Point> capital_chunks = new ArrayList<Point>();
        String chunkStr = capitalSection.getString("chunks");
        if (chunkStr != null) {
            capital_chunks.addAll(HelperUtil.formatStringToPoints(chunkStr));
        }
        sectionList = monumentSection.getDoubleList("travel");
        x = (Double)sectionList.get(0);
        y = (Double)sectionList.get(1);
        z = (Double)sectionList.get(2);
        Location monument_travel = new Location(capitalWorld, x, y, z);
        sectionList = monumentSection.getDoubleList("cornerone");
        x = (Double)sectionList.get(0);
        y = (Double)sectionList.get(1);
        z = (Double)sectionList.get(2);
        Location monument_cornerone = new Location(capitalWorld, x, y, z);
        sectionList = monumentSection.getDoubleList("cornertwo");
        x = (Double)sectionList.get(0);
        y = (Double)sectionList.get(1);
        z = (Double)sectionList.get(2);
        Location monument_cornertwo = new Location(capitalWorld, x, y, z);
        String sanctuaryName = kingdomName + "Sanctuary";
        boolean sanctuaryStatus = this.konquest.getSanctuaryManager().addSanctuary(capital_center, sanctuaryName);
        if (!sanctuaryStatus) {
            ChatUtil.printDebug("Failed to load legacy kingdom " + kingdomName + ", could not add sanctuary: " + sanctuaryName);
            return false;
        }
        KonSanctuary sanctuary = this.konquest.getSanctuaryManager().getSanctuary(sanctuaryName);
        sanctuary.setSpawn(capital_spawn);
        sanctuary.addPoints(capital_chunks);
        this.konquest.getTerritoryManager().addAllTerritory(capitalWorld, sanctuary.getChunkList());
        ChatUtil.printConsoleAlert("Created new sanctuary " + sanctuaryName + " from legacy kingdom migration.");
        double cost = 0.0;
        String templateName = kingdomName + "Template";
        this.konquest.getSanctuaryManager().loadMonumentTemplate(sanctuary, templateName, monument_cornerone, monument_cornertwo, monument_travel, cost);
        ChatUtil.printConsoleAlert("Created new monument template " + templateName + " from legacy kingdom migration.");
        String capitalName = "";
        int capitalPopulation = 0;
        int capitalLand = 0;
        for (String townName : townNames) {
            String townChunks;
            ConfigurationSection townResidentsSection;
            ConfigurationSection townSection = townsSection.getConfigurationSection(townName);
            assert (townSection != null);
            int townPopulation = 0;
            int townLand = 0;
            String lordUUID = townSection.getString("lord", "");
            if (!lordUUID.equalsIgnoreCase("")) {
                ++townPopulation;
            }
            if ((townResidentsSection = townSection.getConfigurationSection("residents")) != null) {
                townPopulation += townResidentsSection.getKeys(false).size();
            }
            if ((townChunks = townSection.getString("chunks")) != null) {
                townLand += HelperUtil.formatStringToPoints(townChunks).size();
            }
            ChatUtil.printDebug("Evaluating for capital: " + townName + ", " + townLand + ", " + townPopulation);
            if (townLand > capitalLand) {
                capitalPopulation = townPopulation;
                capitalName = townName;
                capitalLand = townLand;
                ChatUtil.printDebug("Chose largest land: " + townName);
                continue;
            }
            if (townLand != capitalLand || townPopulation < capitalPopulation) continue;
            capitalPopulation = townPopulation;
            capitalName = townName;
            capitalLand = townLand;
            ChatUtil.printDebug("Chose largest land, largest pop: " + townName);
        }
        sectionList = townsSection.getConfigurationSection(capitalName).getDoubleList("center");
        x = (Double)sectionList.get(0);
        y = (Double)sectionList.get(1);
        z = (Double)sectionList.get(2);
        Location capitalCenter = new Location(capitalWorld, x, y, z);
        this.kingdomMap.put(kingdomName, new KonKingdom(capitalCenter, kingdomName, this.konquest));
        KonKingdom newKingdom = this.kingdomMap.get(kingdomName);
        if (this.konquest.getSanctuaryManager().isTemplate(templateName)) {
            KonMonumentTemplate template = this.konquest.getSanctuaryManager().getTemplate(templateName);
            newKingdom.setMonumentTemplate(template);
        } else {
            ChatUtil.printDebug("Missing template for legacy kingdom " + kingdomName + ", could not find template: " + templateName);
        }
        newKingdom.setIsLegacy(true);
        newKingdom.setIsOpen(true);
        newKingdom.setIsAdminOperated(true);
        for (String townName : townsSection.getKeys(false)) {
            boolean isCapital = townName.equals(capitalName);
            ConfigurationSection townSection = townsSection.getConfigurationSection(townName);
            assert (townSection != null);
            this.loadTown(townSection, townName, kingdomName, isCapital);
        }
        return true;
    }

    private void loadTown(ConfigurationSection townSection, String townName, String kingdomName, boolean isCapital) {
        ConfigurationSection townUpgradesSection;
        ConfigurationSection townOffersSection;
        ConfigurationSection townRequestsSection;
        String chunkStr;
        KonTown town;
        float yaw;
        float pitch;
        double val;
        boolean isShieldsEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ENABLE_SHIELDS.getPath(), false);
        boolean isArmorsEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ENABLE_ARMOR.getPath(), false);
        String defaultWorldName = this.konquest.getCore().getString(CorePath.WORLD_NAME.getPath(), "world");
        String worldName = townSection.getString("world", defaultWorldName);
        World townWorld = Bukkit.getServer().getWorld(worldName);
        if (townWorld == null) {
            String message = "Failed to load town " + townName + " in an unloaded world, " + worldName + ". Check plugin load order.";
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
            return;
        }
        int base = townSection.getInt("base");
        List sectionList = townSection.getDoubleList("spawn");
        double x = (Double)sectionList.get(0);
        double y = (Double)sectionList.get(1);
        double z = (Double)sectionList.get(2);
        if (sectionList.size() > 3) {
            val = (Double)sectionList.get(3);
            pitch = (float)val;
        } else {
            pitch = 0.0f;
        }
        if (sectionList.size() > 4) {
            val = (Double)sectionList.get(4);
            yaw = (float)val;
        } else {
            yaw = 0.0f;
        }
        Location townSpawn = new Location(townWorld, x, y, z, yaw, pitch);
        sectionList = townSection.getDoubleList("center");
        x = (Double)sectionList.get(0);
        y = (Double)sectionList.get(1);
        z = (Double)sectionList.get(2);
        Location townCenter = new Location(townWorld, x, y, z);
        if (isCapital) {
            town = this.kingdomMap.get(kingdomName).getCapital();
        } else {
            this.kingdomMap.get(kingdomName).addTown(townCenter, townName);
            town = this.kingdomMap.get(kingdomName).getTown(townName);
        }
        ConfigurationSection townPropertiesSection = townSection.getConfigurationSection("properties");
        if (townPropertiesSection != null) {
            for (String propertyName : townPropertiesSection.getKeys(false)) {
                boolean value = townPropertiesSection.getBoolean(propertyName);
                KonPropertyFlag property = KonPropertyFlag.getFlag(propertyName);
                boolean status = town.setPropertyValue(property, value);
                if (status) continue;
                ChatUtil.printDebug("Failed to set invalid property " + propertyName + " to Town " + townName);
            }
        }
        town.setSpawn(townSpawn);
        int monumentStatus = town.loadMonument(base, this.kingdomMap.get(kingdomName).getMonumentTemplate());
        if (monumentStatus != 0) {
            ChatUtil.printConsoleError("Failed to load monument for Town " + townName + " in kingdom " + kingdomName + " from invalid template");
        }
        if ((chunkStr = townSection.getString("chunks")) != null) {
            town.addPoints(HelperUtil.formatStringToPoints(chunkStr));
        }
        this.konquest.getTerritoryManager().addAllTerritory(townWorld, town.getChunkList());
        String specializationName = townSection.getString("specialization", "NONE");
        Villager.Profession profession = CompatibilityUtil.getProfessionFromName(specializationName);
        if (profession == null) {
            ChatUtil.printConsoleAlert("Failed to parse profession " + specializationName + " for town " + townName);
            profession = Villager.Profession.NONE;
        }
        town.setSpecialization(profession);
        boolean isShieldActive = townSection.getBoolean("shield", false);
        int shieldTime = townSection.getInt("shield_time", 0);
        Date now = new Date();
        if (isShieldsEnabled && isShieldActive && (long)shieldTime > now.getTime() / 1000L) {
            town.activateShield(shieldTime);
        }
        boolean isArmorActive = townSection.getBoolean("armor", false);
        int armorBlocks = townSection.getInt("armor_blocks", 0);
        if (isArmorsEnabled && isArmorActive && armorBlocks > 0) {
            town.activateArmor(armorBlocks);
        }
        boolean isOpen = townSection.getBoolean("open", false);
        town.setIsOpen(isOpen);
        boolean isPlotOnly = townSection.getBoolean("plot", false);
        town.setIsPlotOnly(isPlotOnly);
        boolean isAlliedBuilding = townSection.getBoolean("allied_building", false);
        town.setIsAlliedBuildingAllowed(isAlliedBuilding);
        boolean isFriendlyRedstone = townSection.getBoolean("friendly_redstone", true);
        town.setIsFriendlyRedstoneAllowed(isFriendlyRedstone);
        boolean isEnemyRedstone = townSection.getBoolean("redstone", false);
        town.setIsEnemyRedstoneAllowed(isEnemyRedstone);
        boolean isGolemOffensive = townSection.getBoolean("golem_offensive", false);
        town.setIsGolemOffensive(isGolemOffensive);
        String lordUUID = townSection.getString("lord", "");
        if (!lordUUID.equalsIgnoreCase("")) {
            UUID playerID = HelperUtil.idFromString(lordUUID);
            if (playerID != null) {
                town.setLord(playerID, false);
            } else {
                ChatUtil.printDebug("Town " + townName + " in kingdom " + kingdomName + " has a null UUID! Lord remains invalid");
            }
        } else {
            ChatUtil.printDebug("Town " + townName + " in kingdom " + kingdomName + " does not have a stored Lord ID");
        }
        ConfigurationSection townResidentSection = townSection.getConfigurationSection("residents");
        if (townResidentSection != null) {
            for (Object residentUUID : townResidentSection.getKeys(false)) {
                boolean isElite = townSection.getBoolean("residents." + (String)residentUUID);
                town.addPlayerResident(Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)residentUUID)), isElite, false);
            }
        }
        if ((townRequestsSection = townSection.getConfigurationSection("requests")) != null) {
            for (String requestUUID : townRequestsSection.getKeys(false)) {
                boolean type = townSection.getBoolean("requests." + requestUUID);
                town.addJoinRequest(UUID.fromString(requestUUID), type);
            }
        }
        if ((townOffersSection = townSection.getConfigurationSection("offers")) != null) {
            for (String offerUUID : townOffersSection.getKeys(false)) {
                double amount = townSection.getDouble("offers." + offerUUID);
                town.addPurchaseOffer(UUID.fromString(offerUUID), amount);
            }
        }
        if ((townUpgradesSection = townSection.getConfigurationSection("upgrades")) != null) {
            for (String upgradeName : townUpgradesSection.getKeys(false)) {
                int level = townSection.getInt("upgrades." + upgradeName);
                KonUpgrade upgrade = KonUpgrade.getUpgrade(upgradeName);
                if (upgrade == null) continue;
                town.addUpgrade(upgrade, level);
            }
        }
        this.konquest.getUpgradeManager().updateTownDisabledUpgrades(town);
        ConfigurationSection townPlotsSection = townSection.getConfigurationSection("plots");
        if (townPlotsSection != null) {
            for (String plotIndex : townPlotsSection.getKeys(false)) {
                String plotStr = townPlotsSection.getString(plotIndex + ".chunks");
                if (plotStr == null) continue;
                HashSet<Point> points = new HashSet<Point>(HelperUtil.formatStringToPoints(plotStr));
                ArrayList<UUID> users = new ArrayList<UUID>();
                for (String user : townSection.getStringList("plots." + plotIndex + ".members")) {
                    users.add(UUID.fromString(user));
                }
                KonPlot plot = new KonPlot(points, users);
                if (this.konquest.getPlotManager().addPlot(town, plot)) continue;
                ChatUtil.printConsoleError("Failed to add incompatible plot to town " + town.getName());
            }
        }
    }

    public void loadLegacyKingdomMemberships() {
        for (KonKingdom kingdom : this.getKingdoms()) {
            if (!kingdom.isLegacy()) continue;
            String kingdomName = kingdom.getName();
            ChatUtil.printDebug("Loading memberships for legacy kingdom " + kingdomName);
            for (KonOfflinePlayer member : this.konquest.getPlayerManager().getAllPlayersInKingdom(kingdom)) {
                UUID id = member.getOfflineBukkitPlayer().getUniqueId();
                kingdom.addMember(id, false);
                String playerName = member.getOfflineBukkitPlayer().getName();
                ChatUtil.printDebug("Added membership for player " + playerName + " in legacy kingdom " + kingdomName);
            }
        }
    }

    public void saveKingdoms() {
        if (this.isKingdomDataNull && this.kingdomMap.isEmpty()) {
            ChatUtil.printConsoleError("Aborted saving kingdom data because a problem was encountered while loading data from kingdoms.yml");
            return;
        }
        YamlConfiguration newSaveConfig = new YamlConfiguration();
        ConfigurationSection root = newSaveConfig.createSection("kingdoms");
        try {
            for (KonKingdom kingdom : this.kingdomMap.values()) {
                Object diplomacyKingdom2;
                String uuid;
                ConfigurationSection kingdomSection = root.createSection(kingdom.getName());
                kingdomSection.set("template", (Object)kingdom.getMonumentTemplateName());
                kingdomSection.set("admin", (Object)kingdom.isAdminOperated());
                kingdomSection.set("webcolor", (Object)kingdom.getWebColor());
                ConfigurationSection kingdomPropertiesSection = kingdomSection.createSection("properties");
                for (KonPropertyFlag konPropertyFlag : KonPropertyFlag.values()) {
                    if (!kingdom.hasPropertyValue(konPropertyFlag)) continue;
                    kingdomPropertiesSection.set(konPropertyFlag.toString(), (Object)kingdom.getPropertyValue(konPropertyFlag));
                }
                kingdomSection.set("open", (Object)kingdom.isOpen());
                kingdomSection.set("master", (Object)"");
                ConfigurationSection kingdomMemberSection = kingdomSection.createSection("members");
                for (OfflinePlayer member : kingdom.getPlayerMembers()) {
                    String string = member.getUniqueId().toString();
                    if (kingdom.isMaster(member.getUniqueId())) {
                        kingdomSection.set("master", (Object)string);
                        continue;
                    }
                    if (kingdom.isOfficer(member.getUniqueId())) {
                        kingdomMemberSection.set(string, (Object)true);
                        continue;
                    }
                    kingdomMemberSection.set(string, (Object)false);
                }
                ConfigurationSection kingdomRequestsSection = kingdomSection.createSection("requests");
                for (OfflinePlayer offlinePlayer : kingdom.getJoinRequests()) {
                    uuid = offlinePlayer.getUniqueId().toString();
                    kingdomRequestsSection.set(uuid, (Object)false);
                }
                for (OfflinePlayer offlinePlayer : kingdom.getJoinInvites()) {
                    uuid = offlinePlayer.getUniqueId().toString();
                    kingdomRequestsSection.set(uuid, (Object)true);
                }
                ConfigurationSection kingdomRelationActiveSection = kingdomSection.createSection("diplomacy_active");
                for (Object diplomacyKingdom2 : kingdom.getActiveRelationKingdoms()) {
                    kingdomRelationActiveSection.set(diplomacyKingdom2.getName(), (Object)kingdom.getActiveRelation((KonquestKingdom)diplomacyKingdom2).toString());
                }
                ConfigurationSection configurationSection = kingdomSection.createSection("diplomacy_request");
                diplomacyKingdom2 = kingdom.getRelationRequestKingdoms().iterator();
                while (diplomacyKingdom2.hasNext()) {
                    KonquestKingdom diplomacyKingdom3 = (KonquestKingdom)diplomacyKingdom2.next();
                    configurationSection.set(diplomacyKingdom3.getName(), (Object)kingdom.getRelationRequest(diplomacyKingdom3).toString());
                }
                ArrayList<KonTown> allTowns = new ArrayList<KonTown>();
                allTowns.add(kingdom.getCapital());
                allTowns.addAll(kingdom.getTowns());
                ConfigurationSection townsSection = kingdomSection.createSection("towns");
                for (KonTown town : allTowns) {
                    ConfigurationSection townInstanceSection = town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL) ? townsSection.createSection("capital") : townsSection.createSection(town.getName());
                    ConfigurationSection townPropertiesSection = townInstanceSection.createSection("properties");
                    for (KonPropertyFlag konPropertyFlag : KonPropertyFlag.values()) {
                        if (!town.hasPropertyValue(konPropertyFlag)) continue;
                        townPropertiesSection.set(konPropertyFlag.toString(), (Object)town.getPropertyValue(konPropertyFlag));
                    }
                    townInstanceSection.set("world", (Object)town.getWorld().getName());
                    townInstanceSection.set("base", (Object)town.getMonument().getBaseY());
                    townInstanceSection.set("spawn", (Object)new int[]{town.getSpawnLoc().getBlockX(), town.getSpawnLoc().getBlockY(), town.getSpawnLoc().getBlockZ(), (int)town.getSpawnLoc().getPitch(), (int)town.getSpawnLoc().getYaw()});
                    townInstanceSection.set("center", (Object)new int[]{town.getCenterLoc().getBlockX(), town.getCenterLoc().getBlockY(), town.getCenterLoc().getBlockZ()});
                    townInstanceSection.set("chunks", (Object)HelperUtil.formatPointsToString(town.getChunkList().keySet()));
                    townInstanceSection.set("specialization", (Object)town.getSpecializationName());
                    townInstanceSection.set("open", (Object)town.isOpen());
                    townInstanceSection.set("plot", (Object)town.isPlotOnly());
                    townInstanceSection.set("allied_building", (Object)town.isAlliedBuildingAllowed());
                    townInstanceSection.set("friendly_redstone", (Object)town.isFriendlyRedstoneAllowed());
                    townInstanceSection.set("redstone", (Object)town.isEnemyRedstoneAllowed());
                    townInstanceSection.set("golem_offensive", (Object)town.isGolemOffensive());
                    townInstanceSection.set("shield", (Object)town.isShielded(true));
                    townInstanceSection.set("shield_time", (Object)town.getShieldEndTime(true));
                    townInstanceSection.set("armor", (Object)town.isArmored(true));
                    townInstanceSection.set("armor_blocks", (Object)town.getArmorBlocks());
                    townInstanceSection.set("lord", (Object)"");
                    ConfigurationSection townInstanceResidentSection = townInstanceSection.createSection("residents");
                    for (OfflinePlayer resident : town.getPlayerResidents()) {
                        String string = resident.getUniqueId().toString();
                        if (town.isPlayerLord(resident)) {
                            townInstanceSection.set("lord", (Object)string);
                            continue;
                        }
                        if (town.isPlayerKnight(resident)) {
                            townInstanceResidentSection.set(string, (Object)true);
                            continue;
                        }
                        townInstanceResidentSection.set(string, (Object)false);
                    }
                    ConfigurationSection townInstanceRequestsSection = townInstanceSection.createSection("requests");
                    for (OfflinePlayer offlinePlayer : town.getJoinRequests()) {
                        String uuid3 = offlinePlayer.getUniqueId().toString();
                        townInstanceRequestsSection.set(uuid3, (Object)false);
                    }
                    for (OfflinePlayer offlinePlayer : town.getJoinInvites()) {
                        String uuid2 = offlinePlayer.getUniqueId().toString();
                        townInstanceRequestsSection.set(uuid2, (Object)true);
                    }
                    ConfigurationSection townInstanceOffersSection = townInstanceSection.createSection("offers");
                    for (KonUpgrade[] id : town.getPurchaseOffers()) {
                        double amount = town.getPurchaseOfferAmount((UUID)id);
                        townInstanceOffersSection.set(id.toString(), (Object)amount);
                    }
                    ConfigurationSection configurationSection2 = townInstanceSection.createSection("upgrades");
                    for (KonUpgrade upgrade : KonUpgrade.values()) {
                        int level = town.getRawUpgradeLevel(upgrade);
                        if (level <= 0) continue;
                        configurationSection2.set(upgrade.toString(), (Object)level);
                    }
                    ConfigurationSection townInstancePlotSection = townInstanceSection.createSection("plots");
                    int plotIndex = 0;
                    for (KonPlot plot : town.getPlots()) {
                        ConfigurationSection plotInstanceSection = townInstancePlotSection.createSection("plot_" + plotIndex);
                        plotInstanceSection.set("chunks", (Object)HelperUtil.formatPointsToString(plot.getPoints()));
                        plotInstanceSection.set("members", plot.getUserStrings());
                        ++plotIndex;
                    }
                }
            }
            FileConfiguration kingdomsConfig = this.konquest.getConfigManager().getConfig("kingdoms");
            kingdomsConfig.set("kingdoms", newSaveConfig.get("kingdoms"));
            if (!this.kingdomMap.isEmpty()) {
                ChatUtil.printConsole("Saved Kingdoms");
            }
        }
        catch (Error | Exception internalError) {
            ChatUtil.printConsoleError("Failed to save kingdoms, report this as a bug to the plugin author!");
            internalError.printStackTrace();
        }
    }
}

