/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.IllegalFormatException;
import org.bukkit.configuration.file.FileConfiguration;

public class LanguageManager {
    private final Konquest konquest;
    private FileConfiguration lang;
    private boolean isValid;

    public LanguageManager(Konquest konquest) {
        this.konquest = konquest;
        this.isValid = false;
    }

    public void initialize() {
        this.lang = this.konquest.getConfigManager().getLang();
        if (this.lang == null) {
            ChatUtil.printConsoleError("Failed to load any language messages");
        } else if (this.lang.getKeys(false).size() > 1) {
            if (this.validateMessages()) {
                this.isValid = true;
            } else {
                ChatUtil.printConsoleError("Failed to validate language messages. Correct the above issues with the language YAML file.");
            }
            this.checkMessages();
        } else {
            ChatUtil.printConsoleError("Failed to load language messages. Correct the above issues with the language YAML file.");
        }
        ChatUtil.printDebug("Language Manager is ready");
    }

    public boolean isLanguageValid() {
        return this.isValid;
    }

    public String get(MessagePath messagePath, Object ... args) {
        String result;
        String path = messagePath.getPath();
        if (this.lang.contains(path)) {
            int formats = messagePath.getFormats();
            if (formats != args.length) {
                ChatUtil.printConsoleError("Internal language path mismatch, expected " + formats + " '%s', got " + args.length + " for path " + path + ". Report this to the plugin author!");
            }
            if (args.length > 0) {
                try {
                    result = String.format(this.lang.getString(messagePath.getPath()), args);
                }
                catch (IllegalFormatException e) {
                    ChatUtil.printConsoleError("Language file expects " + formats + " '%s' for path " + path + ": " + e.getMessage());
                    result = this.lang.getString(messagePath.getPath());
                }
            } else {
                result = this.lang.getString(path);
            }
        } else {
            ChatUtil.printConsoleError("Language file is missing path: " + path);
            result = "<MISSING>";
        }
        result = ChatUtil.parseHex(result);
        return result;
    }

    private boolean validateMessages() {
        boolean result = true;
        String formatStr = "%s";
        for (MessagePath messagePath : MessagePath.values()) {
            if (this.lang.contains(messagePath.getPath(), false)) {
                String message = this.lang.getString(messagePath.getPath(), "");
                int formats = messagePath.getFormats();
                if (message.equals("")) {
                    result = false;
                    ChatUtil.printConsoleError("Language file is missing message for path: " + messagePath.getPath());
                    continue;
                }
                if (formats <= 0) continue;
                int lastIndex = 0;
                int count = 0;
                while (lastIndex != -1) {
                    if ((lastIndex = message.indexOf(formatStr, lastIndex)) == -1) continue;
                    ++count;
                    lastIndex += formatStr.length();
                }
                if (count == formats) continue;
                result = false;
                ChatUtil.printConsoleError("Language file message has bad format. Requires " + formats + " \"%s\" but contains " + count + " for path: " + messagePath.getPath());
                continue;
            }
            result = false;
            ChatUtil.printConsoleError("Language file is missing path: " + messagePath.getPath());
        }
        return result;
    }

    private void checkMessages() {
        boolean isAnyMissing = false;
        for (String path : this.lang.getKeys(true)) {
            if (this.lang.isConfigurationSection(path) || path.equals("version")) continue;
            boolean isFound = false;
            for (MessagePath messagePath : MessagePath.values()) {
                if (!messagePath.getPath().equals(path)) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            isAnyMissing = true;
            ChatUtil.printConsoleError("Language path is orphaned: " + path);
        }
        if (isAnyMissing) {
            ChatUtil.printConsoleError("Remove the orphaned paths above from the language file: " + this.konquest.getConfigManager().getLangName());
        }
    }
}

