/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.model.KonLootTable;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.CustomCommandPath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class LootManager
implements Timeable {
    private final Konquest konquest;
    private final HashMap<Location, Long> lootRefreshLog;
    private final HashMap<Inventory, Inventory> lootCache;
    private long refreshTimeSeconds;
    private long markedRefreshTime;
    private int monumentLootCount;
    private final Timer lootRefreshTimer;
    private final KonLootTable monumentLootTable;
    private final HashMap<String, KonLootTable> monumentSpecialLootTable;
    private final HashMap<String, KonLootTable> monumentCustomLootTable;
    private final HashMap<Location, Boolean> ruinLootEmptiedLog;
    private int ruinLootCount;
    private final KonLootTable ruinLootTable;
    private final HashMap<String, KonLootTable> ruinCustomLootTable;
    public static String defaultLootTableName = "default";

    public LootManager(Konquest konquest) {
        this.konquest = konquest;
        this.refreshTimeSeconds = 0L;
        this.markedRefreshTime = 0L;
        this.lootRefreshLog = new HashMap();
        this.lootCache = new HashMap();
        this.monumentLootCount = 0;
        this.lootRefreshTimer = new Timer(this);
        this.monumentLootTable = new KonLootTable();
        this.monumentSpecialLootTable = new HashMap();
        this.monumentCustomLootTable = new HashMap();
        this.ruinLootEmptiedLog = new HashMap();
        this.ruinLootCount = 0;
        this.ruinLootTable = new KonLootTable();
        this.ruinCustomLootTable = new HashMap();
    }

    public void initialize() {
        this.refreshTimeSeconds = this.konquest.getCore().getLong(CorePath.MONUMENTS_LOOT_REFRESH.getPath(), 0L);
        this.lootRefreshTimer.stopTimer();
        if (this.refreshTimeSeconds > 0L) {
            this.lootRefreshTimer.setTime((int)this.refreshTimeSeconds);
            this.lootRefreshTimer.startLoopTimer();
        }
        this.markedRefreshTime = new Date().getTime();
        this.monumentLootCount = this.konquest.getCore().getInt(CorePath.MONUMENTS_LOOT_COUNT.getPath(), 0);
        this.monumentLootCount = Math.max(this.monumentLootCount, 0);
        this.ruinLootCount = this.konquest.getCore().getInt(CorePath.RUINS_LOOT_COUNT.getPath(), 0);
        this.ruinLootCount = Math.max(this.ruinLootCount, 0);
        if (this.loadAllLoot()) {
            ChatUtil.printDebug("Loaded loot table from loot.yml");
        } else {
            ChatUtil.printConsoleError("Failed to load default loot tables, check loot.yml for syntax errors.");
        }
        ChatUtil.printDebug("Loot Manager is ready with loot count: " + this.monumentLootCount + ", " + this.ruinLootCount);
    }

    private HashMap<ItemStack, Integer> loadItems(ConfigurationSection itemsSection) {
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        if (itemsSection == null) {
            return result;
        }
        Material itemType = null;
        String pathName = itemsSection.getCurrentPath();
        for (String itemName : itemsSection.getKeys(false)) {
            boolean status = true;
            int itemAmount = 0;
            int itemWeight = 0;
            try {
                itemType = Material.valueOf((String)itemName);
            }
            catch (IllegalArgumentException e) {
                ChatUtil.printConsoleError("Invalid loot item \"" + itemName + "\" given in loot.yml path " + pathName + ", skipping this item.");
                status = false;
            }
            ConfigurationSection lootEntry = itemsSection.getConfigurationSection(itemName);
            if (lootEntry != null) {
                if (lootEntry.contains("amount")) {
                    itemAmount = lootEntry.getInt("amount", 1);
                    itemAmount = Math.max(itemAmount, 1);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing amount for item: " + itemName);
                    status = false;
                }
                if (lootEntry.contains("weight")) {
                    itemWeight = lootEntry.getInt("weight", 0);
                    itemWeight = Math.max(itemWeight, 0);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing weight for item: " + itemName);
                    status = false;
                }
            } else {
                status = false;
                ChatUtil.printConsoleError("loot.yml path " + pathName + " contains invalid item: " + itemName);
            }
            if (!status || itemWeight <= 0) continue;
            result.put(new ItemStack(itemType, itemAmount), itemWeight);
        }
        return result;
    }

    private HashMap<ItemStack, Integer> loadPotions(ConfigurationSection potionsSection) {
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        if (potionsSection == null) {
            return result;
        }
        String pathName = potionsSection.getCurrentPath();
        for (String potionName : potionsSection.getKeys(false)) {
            boolean status = true;
            boolean itemUpgraded = false;
            boolean itemExtended = false;
            int itemWeight = 0;
            ConfigurationSection lootEntry = potionsSection.getConfigurationSection(potionName);
            if (lootEntry != null) {
                if (lootEntry.contains("upgraded")) {
                    itemUpgraded = lootEntry.getBoolean("upgraded", false);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing upgraded for potion: " + potionName);
                    status = false;
                }
                if (lootEntry.contains("extended")) {
                    itemExtended = lootEntry.getBoolean("extended", false);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing extended for potion: " + potionName);
                    status = false;
                }
                if (lootEntry.contains("weight")) {
                    itemWeight = lootEntry.getInt("weight", 0);
                    itemWeight = Math.max(itemWeight, 0);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing weight for potion: " + potionName);
                    status = false;
                }
            } else {
                status = false;
                ChatUtil.printConsoleError("loot.yml path " + pathName + " contains invalid potion: " + potionName);
            }
            if (!status || itemWeight <= 0) continue;
            ItemStack potion = new ItemStack(Material.POTION, 1);
            PotionMeta meta = CompatibilityUtil.setPotionMeta((PotionMeta)potion.getItemMeta(), potionName, itemExtended, itemUpgraded);
            assert (meta != null);
            potion.setItemMeta((ItemMeta)meta);
            result.put(potion, itemWeight);
        }
        return result;
    }

    private HashMap<ItemStack, Integer> loadEbooks(ConfigurationSection ebookSection) {
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        if (ebookSection == null) {
            return result;
        }
        String pathName = ebookSection.getCurrentPath();
        for (String enchantName : ebookSection.getKeys(false)) {
            ConfigurationSection lootEntry;
            boolean status = true;
            int itemLevel = 0;
            int itemWeight = 0;
            Enchantment bookType = CompatibilityUtil.getEnchantment(enchantName);
            if (bookType == null) {
                ChatUtil.printConsoleError("Invalid loot enchantment \"" + enchantName + "\" given in loot.yml path " + pathName + ", skipping this enchantment.");
                status = false;
            }
            if ((lootEntry = ebookSection.getConfigurationSection(enchantName)) != null) {
                if (lootEntry.contains("level")) {
                    itemLevel = lootEntry.getInt("level", 0);
                    itemLevel = Math.max(itemLevel, 0);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing level for enchantment: " + enchantName);
                    status = false;
                }
                if (lootEntry.contains("weight")) {
                    itemWeight = lootEntry.getInt("weight", 0);
                    itemWeight = Math.max(itemWeight, 0);
                } else {
                    ChatUtil.printConsoleError("loot.yml path " + pathName + " is missing weight for enchantment: " + enchantName);
                    status = false;
                }
            } else {
                status = false;
                ChatUtil.printConsoleError("loot.yml path " + pathName + " contains invalid enchanted book: " + enchantName);
            }
            if (!status || itemWeight <= 0) continue;
            if (itemLevel < bookType.getStartLevel()) {
                itemLevel = bookType.getStartLevel();
            } else if (itemLevel > bookType.getMaxLevel()) {
                itemLevel = bookType.getMaxLevel();
            }
            ItemStack enchantBook = new ItemStack(Material.ENCHANTED_BOOK, 1);
            EnchantmentStorageMeta enchantMeta = (EnchantmentStorageMeta)enchantBook.getItemMeta();
            enchantMeta.addStoredEnchant(bookType, itemLevel, true);
            enchantBook.setItemMeta((ItemMeta)enchantMeta);
            result.put(enchantBook, itemWeight);
        }
        return result;
    }

    private boolean loadAllLoot() {
        ConfigurationSection ruinCustomSection;
        ConfigurationSection lootCustomSection;
        this.monumentLootTable.clearLoot();
        this.monumentSpecialLootTable.clear();
        this.monumentCustomLootTable.clear();
        this.ruinLootTable.clearLoot();
        this.ruinCustomLootTable.clear();
        FileConfiguration lootConfig = this.konquest.getConfigManager().getConfig("loot");
        boolean status = true;
        if (lootConfig.contains("loot")) {
            this.monumentLootTable.addLoot(this.loadItems(lootConfig.getConfigurationSection("loot.items")));
            this.monumentLootTable.addLoot(this.loadPotions(lootConfig.getConfigurationSection("loot.potions")));
            this.monumentLootTable.addLoot(this.loadEbooks(lootConfig.getConfigurationSection("loot.enchanted_books")));
            if (lootConfig.contains("loot.name")) {
                this.monumentLootTable.setName(lootConfig.getString("loot.name"));
            } else {
                this.monumentLootTable.setName(defaultLootTableName);
            }
        } else {
            status = false;
        }
        if (lootConfig.contains("ruins")) {
            this.ruinLootTable.addLoot(this.loadItems(lootConfig.getConfigurationSection("ruins.items")));
            this.ruinLootTable.addLoot(this.loadPotions(lootConfig.getConfigurationSection("ruins.potions")));
            this.ruinLootTable.addLoot(this.loadEbooks(lootConfig.getConfigurationSection("ruins.enchanted_books")));
            if (lootConfig.contains("ruins.name")) {
                this.ruinLootTable.setName(lootConfig.getString("ruins.name"));
            } else {
                this.ruinLootTable.setName(defaultLootTableName);
            }
        } else {
            status = false;
        }
        ConfigurationSection lootSpecialSection = lootConfig.getConfigurationSection("loot_special");
        if (lootSpecialSection != null) {
            for (Object professionName : lootSpecialSection.getKeys(false)) {
                if (CompatibilityUtil.getProfessionFromName((String)professionName) != null) {
                    KonLootTable professionLoot = new KonLootTable();
                    professionLoot.addLoot(this.loadItems(lootSpecialSection.getConfigurationSection((String)professionName + ".items")));
                    professionLoot.addLoot(this.loadPotions(lootSpecialSection.getConfigurationSection((String)professionName + ".potions")));
                    professionLoot.addLoot(this.loadEbooks(lootSpecialSection.getConfigurationSection((String)professionName + ".enchanted_books")));
                    if (lootSpecialSection.contains((String)professionName + ".name")) {
                        professionLoot.setName(lootSpecialSection.getString((String)professionName + ".name"));
                    } else {
                        professionLoot.setName((String)professionName);
                    }
                    this.monumentSpecialLootTable.put(((String)professionName).toLowerCase(), professionLoot);
                    continue;
                }
                ChatUtil.printConsoleError("Failed to load special monument loot table " + (String)professionName + ", the name must match a Villager Profession.");
            }
        }
        if ((lootCustomSection = lootConfig.getConfigurationSection("loot_custom")) != null) {
            for (String customName : lootCustomSection.getKeys(false)) {
                KonLootTable customLoot = new KonLootTable();
                customLoot.addLoot(this.loadItems(lootCustomSection.getConfigurationSection(customName + ".items")));
                customLoot.addLoot(this.loadPotions(lootCustomSection.getConfigurationSection(customName + ".potions")));
                customLoot.addLoot(this.loadEbooks(lootCustomSection.getConfigurationSection(customName + ".enchanted_books")));
                if (lootCustomSection.contains(customName + ".name")) {
                    customLoot.setName(lootCustomSection.getString(customName + ".name"));
                } else {
                    customLoot.setName(customName);
                }
                this.monumentCustomLootTable.put(customName.toLowerCase(), customLoot);
            }
        }
        if ((ruinCustomSection = lootConfig.getConfigurationSection("ruins_custom")) != null) {
            for (String customName : ruinCustomSection.getKeys(false)) {
                KonLootTable customLoot = new KonLootTable();
                customLoot.addLoot(this.loadItems(ruinCustomSection.getConfigurationSection(customName + ".items")));
                customLoot.addLoot(this.loadPotions(ruinCustomSection.getConfigurationSection(customName + ".potions")));
                customLoot.addLoot(this.loadEbooks(ruinCustomSection.getConfigurationSection(customName + ".enchanted_books")));
                if (ruinCustomSection.contains(customName + ".name")) {
                    customLoot.setName(ruinCustomSection.getString(customName + ".name"));
                } else {
                    customLoot.setName(customName);
                }
                this.ruinCustomLootTable.put(customName.toLowerCase(), customLoot);
            }
        }
        return status;
    }

    public void refreshCustomTableAssignments() {
        for (KonMonumentTemplate template : this.konquest.getSanctuaryManager().getAllTemplates()) {
            if (template.isLootTableDefault() || this.isMonumentLootTable(template.getLootTableName())) continue;
            template.setLootTableDefault();
        }
        for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
            if (ruin.isLootTableDefault() || this.isRuinLootTable(ruin.getLootTableName())) continue;
            ruin.setLootTableDefault();
        }
    }

    public KonLootTable getMonumentSpecialLootTable(String name) {
        String tableKey = name.toLowerCase();
        if (this.monumentSpecialLootTable.containsKey(tableKey)) {
            return this.monumentSpecialLootTable.get(tableKey);
        }
        return null;
    }

    public KonLootTable getMonumentCustomLootTable(String name) {
        String tableKey = name.toLowerCase();
        if (this.monumentCustomLootTable.containsKey(tableKey)) {
            return this.monumentCustomLootTable.get(tableKey);
        }
        return null;
    }

    public ArrayList<String> getMonumentLootTableKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(defaultLootTableName);
        result.addAll(this.monumentCustomLootTable.keySet());
        return result;
    }

    public boolean isMonumentLootTable(String name) {
        return name.equalsIgnoreCase(defaultLootTableName) || this.monumentCustomLootTable.containsKey(name.toLowerCase());
    }

    public boolean isMonumentSpecialLootTable(String name) {
        return this.monumentSpecialLootTable.containsKey(name.toLowerCase());
    }

    public String getMonumentLootDisplayName(KonMonumentTemplate template) {
        KonLootTable lootTable = null;
        if (!template.isLootTableDefault()) {
            lootTable = this.getMonumentCustomLootTable(template.getLootTableName());
        }
        if (lootTable == null) {
            lootTable = this.monumentLootTable;
        }
        return lootTable == null ? "Invalid" : lootTable.getName();
    }

    public String getMonumentLootDisplayName(KonTown town) {
        KonLootTable lootTable = null;
        if (this.konquest.getKingdomManager().getIsDiscountEnable()) {
            lootTable = this.getMonumentSpecialLootTable(town.getSpecializationName());
        }
        if (lootTable == null && !town.getKingdom().getMonumentTemplate().isLootTableDefault()) {
            lootTable = this.getMonumentCustomLootTable(town.getKingdom().getMonumentTemplate().getLootTableName());
        }
        if (lootTable == null) {
            lootTable = this.monumentLootTable;
        }
        return lootTable == null ? "Invalid" : lootTable.getName();
    }

    public String getMonumentLootTime() {
        String noColor = "";
        int timerCount = Math.max(this.lootRefreshTimer.getTime(), 0);
        return HelperUtil.getTimeFormat(timerCount, noColor);
    }

    public Inventory updateMonumentLoot(Inventory chestInventory, KonTown town, Player openPlayer) {
        long loggedLastFilledTime;
        Date lastFilledDate;
        if (chestInventory == null) {
            return null;
        }
        KonLootTable lootTable = null;
        Inventory originalInventory = chestInventory;
        if (chestInventory instanceof DoubleChestInventory) {
            originalInventory = ((DoubleChestInventory)chestInventory).getRightSide();
        }
        Inventory lootInventory = this.lootCache.get(originalInventory);
        ChatUtil.printDebug("Attempting to update loot in town " + town.getName());
        Date now = new Date();
        Location invLoc = originalInventory.getLocation();
        if (invLoc == null || invLoc.getWorld() == null) {
            return null;
        }
        if (this.lootRefreshLog.containsKey(invLoc) && (lastFilledDate = new Date(loggedLastFilledTime = this.lootRefreshLog.get(invLoc).longValue())).after(new Date(this.markedRefreshTime))) {
            ChatUtil.printDebug("  Failed, refresh time has not expired");
            ChatUtil.sendNotice((CommandSender)openPlayer, MessagePath.PROTECTION_NOTICE_LOOT_LATER.getMessage(new Object[0]));
            return lootInventory;
        }
        if (this.konquest.getKingdomManager().getIsDiscountEnable() && (lootTable = this.getMonumentSpecialLootTable(town.getSpecializationName())) != null) {
            ChatUtil.printDebug("  Using special monument loot table " + town.getSpecializationName());
        }
        if (lootTable == null && !town.getKingdom().getMonumentTemplate().isLootTableDefault() && (lootTable = this.getMonumentCustomLootTable(town.getKingdom().getMonumentTemplate().getLootTableName())) != null) {
            ChatUtil.printDebug("  Using custom monument loot table " + town.getKingdom().getMonumentTemplate().getLootTableName());
        }
        if (lootTable == null) {
            lootTable = this.monumentLootTable;
            ChatUtil.printDebug("   Using default monument loot table");
        }
        if (lootTable == null || lootTable.isEmptyLoot()) {
            ChatUtil.printDebug("  Failed, got missing or empty monument loot table");
            return lootInventory;
        }
        lootInventory = this.konquest.getPlugin().getServer().createInventory(originalInventory.getHolder(), originalInventory.getSize(), lootTable.getName());
        int upgradeLevel = this.konquest.getUpgradeManager().getTownUpgradeLevel(town, KonUpgrade.LOOT);
        int upgradedLootCount = this.monumentLootCount + upgradeLevel;
        int eventLootMultiplier = this.konquest.getGlobalEventManager().getMonumentLootMultiplier();
        int numLootCount = upgradedLootCount * eventLootMultiplier;
        this.clearUpperInventory(originalInventory);
        int finalItemCount = 0;
        for (int i = 0; i < numLootCount; ++i) {
            int availableSlot = lootInventory.firstEmpty();
            if (availableSlot == -1) continue;
            lootInventory.setItem(availableSlot, lootTable.chooseRandomItem());
            ++finalItemCount;
        }
        long lootLastFilledTime = now.getTime();
        this.lootRefreshLog.put(invLoc, lootLastFilledTime);
        this.lootCache.put(originalInventory, lootInventory);
        invLoc.getWorld().playSound(invLoc, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        this.konquest.executeCustomCommand(CustomCommandPath.TOWN_MONUMENT_LOOT_OPEN, openPlayer);
        ChatUtil.printDebug("  Success, updated " + finalItemCount + " items");
        return lootInventory;
    }

    private KonLootTable getRuinCustomLootTable(String name) {
        String tableKey = name.toLowerCase();
        if (this.ruinCustomLootTable.containsKey(tableKey)) {
            return this.ruinCustomLootTable.get(tableKey);
        }
        return null;
    }

    public ArrayList<String> getRuinLootTableKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(defaultLootTableName);
        result.addAll(this.ruinCustomLootTable.keySet());
        return result;
    }

    public boolean isRuinLootTable(String name) {
        return name.equalsIgnoreCase(defaultLootTableName) || this.ruinCustomLootTable.containsKey(name.toLowerCase());
    }

    public String getRuinLootDisplayName(KonRuin ruin) {
        KonLootTable lootTable = null;
        if (!ruin.isLootTableDefault()) {
            lootTable = this.getRuinCustomLootTable(ruin.getLootTableName());
        }
        if (lootTable == null) {
            lootTable = this.ruinLootTable;
        }
        return lootTable == null ? "Invalid" : lootTable.getName();
    }

    public Inventory updateRuinLoot(Inventory chestInventory, KonRuin ruin, Player openPlayer) {
        if (chestInventory == null) {
            return null;
        }
        KonLootTable lootTable = null;
        Inventory originalInventory = chestInventory;
        if (chestInventory instanceof DoubleChestInventory) {
            originalInventory = ((DoubleChestInventory)chestInventory).getRightSide();
        }
        Inventory lootInventory = this.lootCache.get(originalInventory);
        ChatUtil.printDebug("Attempting to update loot in ruin " + ruin.getName());
        Location invLoc = originalInventory.getLocation();
        if (invLoc == null || invLoc.getWorld() == null) {
            return null;
        }
        boolean isLootAfterCapture = this.konquest.getCore().getBoolean(CorePath.RUINS_LOOT_AFTER_CAPTURE.getPath());
        boolean isRuinCaptured = ruin.isCaptureDisabled();
        if (isLootAfterCapture && !isRuinCaptured) {
            ChatUtil.printDebug("  Failed, the ruin has not yet been captured");
            ChatUtil.sendNotice((CommandSender)openPlayer, MessagePath.PROTECTION_NOTICE_LOOT_CAPTURE.getMessage(new Object[0]));
            return lootInventory;
        }
        if (this.ruinLootEmptiedLog.containsKey(invLoc) && this.ruinLootEmptiedLog.get(invLoc).booleanValue()) {
            ChatUtil.printDebug("  Failed, the inventory has already been updated");
            ChatUtil.sendNotice((CommandSender)openPlayer, MessagePath.PROTECTION_NOTICE_LOOT_CAPTURE.getMessage(new Object[0]));
            return lootInventory;
        }
        if (!ruin.isLootTableDefault() && (lootTable = this.getRuinCustomLootTable(ruin.getLootTableName())) != null) {
            ChatUtil.printDebug("  Using custom ruin loot table " + ruin.getLootTableName());
        }
        if (lootTable == null) {
            lootTable = this.ruinLootTable;
            ChatUtil.printDebug("  Using default ruin loot table");
        }
        if (lootTable == null || lootTable.isEmptyLoot()) {
            ChatUtil.printDebug("  Failed, got missing or empty ruin loot table");
            return lootInventory;
        }
        lootInventory = this.konquest.getPlugin().getServer().createInventory(originalInventory.getHolder(), originalInventory.getSize(), lootTable.getName());
        this.clearUpperInventory(originalInventory);
        int eventLootMultiplier = this.konquest.getGlobalEventManager().getRuinLootMultiplier();
        int numLootCount = this.ruinLootCount * eventLootMultiplier;
        int finalItemCount = 0;
        for (int i = 0; i < numLootCount; ++i) {
            int availableSlot = lootInventory.firstEmpty();
            if (availableSlot == -1) continue;
            lootInventory.setItem(availableSlot, lootTable.chooseRandomItem());
            ++finalItemCount;
        }
        this.ruinLootEmptiedLog.put(invLoc, true);
        this.lootCache.put(originalInventory, lootInventory);
        invLoc.getWorld().playSound(invLoc, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        this.konquest.executeCustomCommand(CustomCommandPath.RUIN_LOOT_OPEN, openPlayer);
        ChatUtil.printDebug("  Success, updated " + finalItemCount + " items");
        return lootInventory;
    }

    public void resetRuinLoot(KonRuin ruin) {
        for (Map.Entry<Location, Boolean> entry : this.ruinLootEmptiedLog.entrySet()) {
            if (!ruin.isLocInside(entry.getKey())) continue;
            entry.setValue(false);
        }
    }

    private void clearUpperInventory(Inventory inventory) {
        inventory.clear();
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Loot Refresh Timer ended with null taskID!");
            return;
        }
        if (taskID == this.lootRefreshTimer.getTaskID()) {
            this.markedRefreshTime = new Date().getTime();
            ChatUtil.printDebug("Loot Refresh timer marked new availability time");
            for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
                KonMonumentTemplate template = player.getKingdom().getMonumentTemplate();
                if (player.isBarbarian() || template == null || !template.hasLoot()) continue;
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.GENERIC_NOTICE_LOOT.getMessage(new Object[0]));
            }
        }
    }
}

