/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.manager.KonquestPlaceholderManager;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.PlayerManager;
import com.github.rumsfield.konquest.manager.RuinManager;
import com.github.rumsfield.konquest.manager.TerritoryManager;
import com.github.rumsfield.konquest.model.KonGlobalEvent;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPrefix;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.Labeler;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderManager
implements KonquestPlaceholderManager {
    private final Konquest konquest;
    private final PlayerManager playerManager;
    private final KingdomManager kingdomManager;
    private final RuinManager ruinManager;
    private final TerritoryManager territoryManager;
    private int cooldownSeconds;
    private final Comparator<Ranked> rankedComparator;
    private long topScoreCooldownTime;
    private long topTownCooldownTime;
    private long topLandCooldownTime;
    private ArrayList<Ranked> topScoreList;
    private ArrayList<Ranked> topTownList;
    private ArrayList<Ranked> topLandList;
    private HashMap<String, HashMap<KingdomValue, Integer>> kingdomCache;
    private HashMap<String, HashMap<KingdomValue, Long>> kingdomCooldownTimes;

    public PlaceholderManager(Konquest konquest) {
        this.konquest = konquest;
        this.playerManager = konquest.getPlayerManager();
        this.kingdomManager = konquest.getKingdomManager();
        this.ruinManager = konquest.getRuinManager();
        this.territoryManager = konquest.getTerritoryManager();
        this.cooldownSeconds = 0;
        this.topScoreCooldownTime = 0L;
        this.topTownCooldownTime = 0L;
        this.topLandCooldownTime = 0L;
        this.topScoreList = new ArrayList();
        this.topTownList = new ArrayList();
        this.topLandList = new ArrayList();
        this.kingdomCache = new HashMap();
        this.kingdomCooldownTimes = new HashMap();
        this.rankedComparator = (rankOne, rankTwo) -> {
            int result = 0;
            if (rankOne.value < rankTwo.value) {
                result = 1;
            } else if (rankOne.value > rankTwo.value) {
                result = -1;
            }
            return result;
        };
    }

    public void initialize() {
        this.topScoreCooldownTime = 0L;
        this.topTownCooldownTime = 0L;
        this.topLandCooldownTime = 0L;
        this.topScoreList = new ArrayList();
        this.topTownList = new ArrayList();
        this.topLandList = new ArrayList();
        this.kingdomCache = new HashMap();
        this.kingdomCooldownTimes = new HashMap();
        this.cooldownSeconds = this.konquest.getCore().getInt(CorePath.PLACEHOLDER_REQUEST_LIMIT.getPath(), 0);
        ChatUtil.printDebug("Placeholder Manager is ready with cool-down seconds: " + this.cooldownSeconds);
    }

    private String boolean2Lang(boolean val) {
        String result = MessagePath.LABEL_FALSE.getMessage(new Object[0]);
        if (val) {
            result = MessagePath.LABEL_TRUE.getMessage(new Object[0]);
        }
        return result;
    }

    @Override
    public String getKingdom(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        return offlinePlayer == null ? "" : offlinePlayer.getKingdom().getName();
    }

    @Override
    public String getExile(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        return offlinePlayer == null ? "" : offlinePlayer.getExileKingdom().getName();
    }

    @Override
    public String getBarbarian(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        return offlinePlayer == null ? "" : this.boolean2Lang(offlinePlayer.isBarbarian());
    }

    @Override
    public String getTownsLord(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        int numTowns = 0;
        if (offlinePlayer != null) {
            for (KonTown town : offlinePlayer.getKingdom().getTowns()) {
                if (!town.isPlayerLord(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++numTowns;
            }
        }
        return "" + numTowns;
    }

    @Override
    public String getTownsKnight(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        int numTowns = 0;
        if (offlinePlayer != null) {
            for (KonTown town : offlinePlayer.getKingdom().getTowns()) {
                if (!town.isPlayerKnight(offlinePlayer.getOfflineBukkitPlayer()) || town.isPlayerLord(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++numTowns;
            }
        }
        return "" + numTowns;
    }

    @Override
    public String getTownsResident(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        int numTowns = 0;
        if (offlinePlayer != null) {
            for (KonTown town : offlinePlayer.getKingdom().getTowns()) {
                if (!town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer()) || town.isPlayerKnight(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++numTowns;
            }
        }
        return "" + numTowns;
    }

    @Override
    public String getTownsAll(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        int numTowns = 0;
        if (offlinePlayer != null) {
            for (KonTown town : offlinePlayer.getKingdom().getTowns()) {
                if (!town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++numTowns;
            }
        }
        return "" + numTowns;
    }

    @Override
    public String getTerritory(Player player) {
        String result = "";
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        if (onlinePlayer != null && player.isOnline()) {
            result = this.territoryManager.isChunkClaimed(player.getLocation()) ? Labeler.lookup(this.territoryManager.getChunkTerritory(player.getLocation()).getTerritoryType()) : Labeler.lookup(KonquestTerritoryType.WILD);
        }
        return result;
    }

    @Override
    public String getLand(Player player) {
        String result = "";
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        if (onlinePlayer != null && player.isOnline()) {
            result = this.territoryManager.isChunkClaimed(player.getLocation()) ? this.territoryManager.getChunkTerritory(player.getLocation()).getName() : Labeler.lookup(KonquestTerritoryType.WILD);
        }
        return result;
    }

    @Override
    public String getClaimed(Player player) {
        String result = "";
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        if (onlinePlayer != null && player.isOnline()) {
            result = this.boolean2Lang(this.territoryManager.isChunkClaimed(player.getLocation()));
        }
        return result;
    }

    @Override
    public String getScore(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        return offlinePlayer == null ? "" : String.valueOf(this.kingdomManager.getPlayerScore(offlinePlayer));
    }

    @Override
    public String getPrefix(Player player) {
        String result = "";
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        if (onlinePlayer != null) {
            KonPrefix playerPrefix = onlinePlayer.getPlayerPrefix();
            result = playerPrefix.getMainPrefixName();
        }
        return result;
    }

    public String getRank(Player player) {
        String result = "";
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        if (onlinePlayer != null) {
            KonKingdom kingdom = onlinePlayer.getKingdom();
            result = kingdom.getPlayerRankName(player.getUniqueId());
        }
        return result;
    }

    @Override
    public String getLordships(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        int count = 0;
        if (offlinePlayer != null) {
            for (KonTown town : offlinePlayer.getKingdom().getTowns()) {
                if (!town.isPlayerLord(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++count;
            }
        }
        String result = String.valueOf(count);
        return result;
    }

    @Override
    public String getResidencies(Player player) {
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        int count = 0;
        if (offlinePlayer != null) {
            for (KonTown town : offlinePlayer.getKingdom().getTowns()) {
                if (!town.isPlayerResident(offlinePlayer.getOfflineBukkitPlayer())) continue;
                ++count;
            }
        }
        String result = String.valueOf(count);
        return result;
    }

    @Override
    public String getChat(Player player) {
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        return onlinePlayer == null ? "" : this.boolean2Lang(onlinePlayer.isGlobalChat());
    }

    @Override
    public String getCombat(Player player) {
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        return onlinePlayer == null ? "" : this.boolean2Lang(onlinePlayer.isCombatTagged());
    }

    @Override
    public String getCombatTag(Player player) {
        KonPlayer onlinePlayer = this.playerManager.getPlayer(player);
        return onlinePlayer != null && onlinePlayer.isCombatTagged() ? ChatUtil.parseHex(this.konquest.getCore().getString(CorePath.COMBAT_PLACEHOLDER_TAG.getPath(), "")) : "";
    }

    @Override
    public String getRelation(Player playerOne, Player playerTwo) {
        String result = "";
        KonPlayer onlinePlayerOne = this.playerManager.getPlayer(playerOne);
        KonPlayer onlinePlayerTwo = this.playerManager.getPlayer(playerTwo);
        if (onlinePlayerOne != null && onlinePlayerTwo != null) {
            KonKingdom kingdomOne = onlinePlayerOne.getKingdom();
            KonKingdom kingdomTwo = onlinePlayerTwo.getKingdom();
            result = Labeler.lookup(this.kingdomManager.getRelationRole(kingdomOne, kingdomTwo));
        }
        return result;
    }

    @Override
    public String getRelationPrimaryColor(Player playerOne, Player playerTwo) {
        Object result = "";
        KonPlayer onlinePlayerOne = this.playerManager.getPlayer(playerOne);
        KonPlayer onlinePlayerTwo = this.playerManager.getPlayer(playerTwo);
        if (onlinePlayerOne != null && onlinePlayerTwo != null) {
            result = this.konquest.getDisplayPrimaryColor((KonquestOfflinePlayer)onlinePlayerOne, onlinePlayerTwo);
        }
        return result;
    }

    @Override
    public String getRelationSecondaryColor(Player playerOne, Player playerTwo) {
        Object result = "";
        KonPlayer onlinePlayerOne = this.playerManager.getPlayer(playerOne);
        KonPlayer onlinePlayerTwo = this.playerManager.getPlayer(playerTwo);
        if (onlinePlayerOne != null && onlinePlayerTwo != null) {
            result = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)onlinePlayerOne, onlinePlayerTwo);
        }
        return result;
    }

    public String getRelationKingdomWebColor(Player playerTwo) {
        String result = "";
        KonPlayer onlinePlayerTwo = this.playerManager.getPlayer(playerTwo);
        if (onlinePlayerTwo != null) {
            result = onlinePlayerTwo.getKingdom().getWebColorString();
        }
        return result;
    }

    @Override
    public String getTopScore(int rank) {
        Object result = "---";
        Date now = new Date();
        if (now.after(new Date(this.topScoreCooldownTime))) {
            this.topScoreList = new ArrayList();
            for (KonKingdom kingdom : this.kingdomManager.getKingdoms()) {
                String kingdomName = kingdom.getName();
                this.topScoreList.add(new Ranked(kingdomName, this.kingdomManager.getKingdomScore(kingdom)));
            }
            this.topScoreList.sort(this.rankedComparator);
            this.topScoreCooldownTime = now.getTime() + (long)this.cooldownSeconds * 1000L;
        }
        if (rank > 0 && rank <= this.topScoreList.size()) {
            result = this.topScoreList.get((int)(rank - 1)).name + " " + this.topScoreList.get((int)(rank - 1)).value;
        }
        return result;
    }

    @Override
    public String getTopTown(int rank) {
        Object result = "---";
        Date now = new Date();
        if (now.after(new Date(this.topTownCooldownTime))) {
            this.topTownList = new ArrayList();
            for (KonKingdom kingdom : this.kingdomManager.getKingdoms()) {
                String kingdomName = kingdom.getName();
                this.topTownList.add(new Ranked(kingdomName, kingdom.getTowns().size()));
            }
            this.topTownList.sort(this.rankedComparator);
            this.topTownCooldownTime = now.getTime() + (long)this.cooldownSeconds * 1000L;
        }
        if (rank > 0 && rank <= this.topTownList.size()) {
            result = this.topTownList.get((int)(rank - 1)).name + " " + this.topTownList.get((int)(rank - 1)).value;
        }
        return result;
    }

    @Override
    public String getTopLand(int rank) {
        Object result = "---";
        Date now = new Date();
        if (now.after(new Date(this.topLandCooldownTime))) {
            this.topLandList = new ArrayList();
            for (KonKingdom kingdom : this.kingdomManager.getKingdoms()) {
                String kingdomName = kingdom.getName();
                int kingdomLand = 0;
                for (KonTown town : kingdom.getCapitalTowns()) {
                    kingdomLand += town.getChunkList().size();
                }
                this.topLandList.add(new Ranked(kingdomName, kingdomLand));
            }
            this.topLandList.sort(this.rankedComparator);
            this.topLandCooldownTime = now.getTime() + (long)this.cooldownSeconds * 1000L;
        }
        if (rank > 0 && rank <= this.topLandList.size()) {
            result = this.topLandList.get((int)(rank - 1)).name + " " + this.topLandList.get((int)(rank - 1)).value;
        }
        return result;
    }

    private boolean isCooldownOver(String nameKey, KingdomValue valueType) {
        Date now = new Date();
        Long futureTime = now.getTime() + (long)this.cooldownSeconds * 1000L;
        boolean isReady = false;
        if (this.kingdomCooldownTimes.containsKey(nameKey)) {
            if (this.kingdomCooldownTimes.get(nameKey).containsKey((Object)valueType)) {
                if (now.after(new Date(this.kingdomCooldownTimes.get(nameKey).get((Object)valueType)))) {
                    isReady = true;
                    this.kingdomCooldownTimes.get(nameKey).put(valueType, futureTime);
                }
            } else {
                isReady = true;
                this.kingdomCache.get(nameKey).put(valueType, 0);
                this.kingdomCooldownTimes.get(nameKey).put(valueType, futureTime);
            }
        } else if (this.kingdomManager.isKingdom(nameKey)) {
            isReady = true;
            this.kingdomCache.put(nameKey, new HashMap());
            this.kingdomCache.get(nameKey).put(valueType, 0);
            this.kingdomCooldownTimes.put(nameKey, new HashMap());
            this.kingdomCooldownTimes.get(nameKey).put(valueType, futureTime);
        }
        return isReady;
    }

    public String getPlayerKingdomPlayers(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.getKingdomPlayers(offlinePlayer.getKingdom().getName());
        }
        return result;
    }

    @Override
    public String getKingdomPlayers(String name) {
        String nameKey = name.toLowerCase();
        KingdomValue type = KingdomValue.PLAYERS;
        Object result = "";
        if (this.isCooldownOver(nameKey, type) && this.kingdomCache.containsKey(nameKey)) {
            int value = this.playerManager.getAllPlayersInKingdom(this.kingdomManager.getKingdom(name)).size();
            this.kingdomCache.get(nameKey).put(type, value);
        }
        if (this.kingdomCache.containsKey(nameKey)) {
            result = String.valueOf(this.kingdomCache.get(nameKey).get((Object)type));
        }
        return result;
    }

    public String getPlayerKingdomOnline(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.getKingdomOnline(offlinePlayer.getKingdom().getName());
        }
        return result;
    }

    @Override
    public String getKingdomOnline(String name) {
        String nameKey = name.toLowerCase();
        KingdomValue type = KingdomValue.ONLINE;
        Object result = "";
        if (this.isCooldownOver(nameKey, type) && this.kingdomCache.containsKey(nameKey)) {
            int value = this.playerManager.getPlayersInKingdom(this.kingdomManager.getKingdom(name)).size();
            this.kingdomCache.get(nameKey).put(type, value);
        }
        if (this.kingdomCache.containsKey(nameKey)) {
            result = String.valueOf(this.kingdomCache.get(nameKey).get((Object)type));
        }
        return result;
    }

    public String getPlayerKingdomTowns(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.getKingdomTowns(offlinePlayer.getKingdom().getName());
        }
        return result;
    }

    @Override
    public String getKingdomTowns(String name) {
        String nameKey = name.toLowerCase();
        KingdomValue type = KingdomValue.TOWNS;
        Object result = "";
        if (this.isCooldownOver(nameKey, type) && this.kingdomCache.containsKey(nameKey)) {
            int value = this.kingdomManager.getKingdom(name).getTowns().size();
            this.kingdomCache.get(nameKey).put(type, value);
        }
        if (this.kingdomCache.containsKey(nameKey)) {
            result = String.valueOf(this.kingdomCache.get(nameKey).get((Object)type));
        }
        return result;
    }

    public String getPlayerKingdomLand(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.getKingdomLand(offlinePlayer.getKingdom().getName());
        }
        return result;
    }

    @Override
    public String getKingdomLand(String name) {
        String nameKey = name.toLowerCase();
        KingdomValue type = KingdomValue.LAND;
        Object result = "";
        if (this.isCooldownOver(nameKey, type) && this.kingdomCache.containsKey(nameKey)) {
            int value = 0;
            for (KonTown town : this.kingdomManager.getKingdom(name).getCapitalTowns()) {
                value += town.getChunkList().size();
            }
            this.kingdomCache.get(nameKey).put(type, value);
        }
        if (this.kingdomCache.containsKey(nameKey)) {
            result = String.valueOf(this.kingdomCache.get(nameKey).get((Object)type));
        }
        return result;
    }

    public String getPlayerKingdomFavor(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.getKingdomFavor(offlinePlayer.getKingdom().getName());
        }
        return result;
    }

    @Override
    public String getKingdomFavor(String name) {
        String nameKey = name.toLowerCase();
        KingdomValue type = KingdomValue.FAVOR;
        Object result = "";
        if (this.isCooldownOver(nameKey, type) && this.kingdomCache.containsKey(nameKey)) {
            int value = 0;
            for (KonOfflinePlayer kingdomPlayer : this.playerManager.getAllPlayersInKingdom(this.kingdomManager.getKingdom(name))) {
                value += (int)KonquestPlugin.getBalance(kingdomPlayer.getOfflineBukkitPlayer());
            }
            this.kingdomCache.get(nameKey).put(type, value);
        }
        if (this.kingdomCache.containsKey(nameKey)) {
            result = String.valueOf(this.kingdomCache.get(nameKey).get((Object)type));
        }
        return result;
    }

    public String getPlayerKingdomScore(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.getKingdomScore(offlinePlayer.getKingdom().getName());
        }
        return result;
    }

    @Override
    public String getKingdomScore(String name) {
        String nameKey = name.toLowerCase();
        KingdomValue type = KingdomValue.SCORE;
        Object result = "";
        if (this.isCooldownOver(nameKey, type) && this.kingdomCache.containsKey(nameKey)) {
            int value = this.kingdomManager.getKingdomScore(this.kingdomManager.getKingdom(name));
            this.kingdomCache.get(nameKey).put(type, value);
        }
        if (this.kingdomCache.containsKey(nameKey)) {
            result = String.valueOf(this.kingdomCache.get(nameKey).get((Object)type));
        }
        return result;
    }

    public String getRuinCooldown(String name) {
        String result = "";
        if (this.ruinManager.isRuin(name)) {
            result = this.ruinManager.getRuin(name).getCaptureTime();
        }
        return result;
    }

    public String getRuinCapture(String name) {
        String result = "";
        if (this.ruinManager.isRuin(name)) {
            result = this.boolean2Lang(!this.ruinManager.getRuin(name).isCaptureDisabled());
        }
        return result;
    }

    public String getRuinCriticals(String name) {
        Object result = "";
        if (this.ruinManager.isRuin(name)) {
            result = "" + this.ruinManager.getRuin(name).getCriticalLocations().size();
        }
        return result;
    }

    public String getRuinSpawns(String name) {
        Object result = "";
        if (this.ruinManager.isRuin(name)) {
            result = "" + this.ruinManager.getRuin(name).getSpawnLocations().size();
        }
        return result;
    }

    public String getTimerLoot(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.konquest.getLootManager().getMonumentLootTime();
        }
        return result;
    }

    public String getTimerPayment(Player player) {
        String result = "";
        KonOfflinePlayer offlinePlayer = this.playerManager.getOfflinePlayer((OfflinePlayer)player);
        if (offlinePlayer != null) {
            result = this.konquest.getKingdomManager().getKingdomPayTime();
        }
        return result;
    }

    public String getActiveEvents() {
        String result = "";
        ArrayList<String> eventNames = new ArrayList<String>();
        for (KonGlobalEvent activeEvent : this.konquest.getGlobalEventManager().getEvents(true)) {
            eventNames.add(activeEvent.getName());
        }
        if (!eventNames.isEmpty()) {
            result = HelperUtil.formatCommaSeparatedList(eventNames);
        }
        return result;
    }

    public String getActiveEventEffects() {
        String result = "";
        ArrayList<String> effectNames = new ArrayList<String>();
        for (KonGlobalEventEffect effect : this.konquest.getGlobalEventManager().getValidEffects()) {
            effectNames.add(effect.getTitle());
        }
        if (!effectNames.isEmpty()) {
            result = HelperUtil.formatCommaSeparatedList(effectNames);
        }
        return result;
    }

    private static class Ranked {
        String name;
        int value;

        Ranked(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    private static enum KingdomValue {
        PLAYERS,
        ONLINE,
        TOWNS,
        LAND,
        FAVOR,
        SCORE;

    }
}

