/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.manager.KonquestPlayerManager;
import com.github.rumsfield.konquest.api.model.KonquestKingdom;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonument;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManager
implements KonquestPlayerManager {
    private final Konquest konquest;
    private final HashMap<Player, KonPlayer> onlinePlayers;
    private final ConcurrentHashMap<OfflinePlayer, KonOfflinePlayer> allPlayers;
    private final ArrayList<String> blockedCommands;

    public PlayerManager(Konquest konquest) {
        this.konquest = konquest;
        this.onlinePlayers = new HashMap();
        this.allPlayers = new ConcurrentHashMap();
        this.blockedCommands = new ArrayList();
    }

    public void initialize() {
        this.blockedCommands.clear();
        this.blockedCommands.addAll(this.konquest.getCore().getStringList(CorePath.COMBAT_PREVENT_COMMAND_LIST.getPath()));
        ChatUtil.printDebug("Player Manager is ready");
    }

    @NotNull
    public ArrayList<String> getBlockedCommands() {
        return this.blockedCommands;
    }

    @Nullable
    public KonPlayer removePlayer(@NotNull Player bukkitPlayer) {
        KonPlayer player = this.onlinePlayers.remove(bukkitPlayer);
        ChatUtil.printDebug("Removed online player: " + bukkitPlayer.getName());
        return player;
    }

    @Override
    @Nullable
    public KonPlayer getPlayer(Player bukkitPlayer) {
        if (bukkitPlayer == null) {
            return null;
        }
        return this.onlinePlayers.get(bukkitPlayer);
    }

    @Nullable
    public KonPlayer getPlayer(CommandSender sender) {
        if (sender == null) {
            return null;
        }
        if (sender instanceof Player) {
            return this.onlinePlayers.get((Player)sender);
        }
        return null;
    }

    @Override
    public boolean isOnlinePlayer(Player bukkitPlayer) {
        if (bukkitPlayer == null) {
            return false;
        }
        return this.onlinePlayers.containsKey(bukkitPlayer);
    }

    @Override
    @Nullable
    public KonOfflinePlayer getOfflinePlayer(OfflinePlayer offlineBukkitPlayer) {
        return this.allPlayers.get(offlineBukkitPlayer);
    }

    @Override
    public boolean isOfflinePlayer(OfflinePlayer offlineBukkitPlayer) {
        return this.allPlayers.containsKey(offlineBukkitPlayer);
    }

    @Override
    public boolean isPlayerNameExist(String name) {
        boolean result = false;
        for (OfflinePlayer offlineBukkitPlayer : this.allPlayers.keySet()) {
            if (offlineBukkitPlayer.getName() == null || !name.equalsIgnoreCase(offlineBukkitPlayer.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @NotNull
    public KonPlayer createKonPlayer(Player bukkitPlayer) {
        KonPlayer newPlayer = new KonPlayer(bukkitPlayer, this.konquest.getKingdomManager().getBarbarians(), true);
        UUID id = bukkitPlayer.getUniqueId();
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            if (!kingdom.isMember(id)) continue;
            newPlayer.setKingdom(kingdom);
            newPlayer.setExileKingdom(kingdom);
            newPlayer.setBarbarian(false);
            ChatUtil.printConsoleWarning("New player " + bukkitPlayer.getName() + " already has kingdom membership in " + kingdom.getName() + ". Check your SQL database settings in core.yml, the database connection may have been lost or corrupted.");
            break;
        }
        this.onlinePlayers.put(bukkitPlayer, newPlayer);
        this.linkOnlinePlayerToCache(newPlayer);
        ChatUtil.printDebug("Created player " + bukkitPlayer.getName());
        return newPlayer;
    }

    @NotNull
    public KonPlayer importKonPlayer(Player bukkitPlayer, String kingdomName, String exileKingdomName, boolean isBarbarian) {
        Date now;
        KonPlayer importedPlayer;
        UUID id = bukkitPlayer.getUniqueId();
        if (isBarbarian) {
            importedPlayer = new KonPlayer(bukkitPlayer, this.konquest.getKingdomManager().getBarbarians(), true);
            for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
                if (!kingdom.isMember(id)) continue;
                importedPlayer.setKingdom(kingdom);
                importedPlayer.setExileKingdom(kingdom);
                importedPlayer.setBarbarian(false);
                ChatUtil.printConsoleWarning("Existing barbarian player " + bukkitPlayer.getName() + " has kingdom membership in " + kingdom.getName() + ". Check your SQL database settings in core.yml, the database connection may have been lost or corrupted.");
                break;
            }
        } else {
            KonKingdom playerKingdom = this.konquest.getKingdomManager().getKingdom(kingdomName);
            if (playerKingdom.equals(this.konquest.getKingdomManager().getBarbarians())) {
                importedPlayer = new KonPlayer(bukkitPlayer, this.konquest.getKingdomManager().getBarbarians(), true);
                boolean foundMembership = false;
                for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
                    if (!kingdom.isMember(id)) continue;
                    importedPlayer.setKingdom(kingdom);
                    importedPlayer.setExileKingdom(kingdom);
                    importedPlayer.setBarbarian(false);
                    ChatUtil.printConsoleWarning("Existing player " + bukkitPlayer.getName() + " is in an unknown kingdom, but already has kingdom membership in " + kingdom.getName() + ". Check your SQL database settings in core.yml, the database connection may have been lost or corrupted.");
                    break;
                }
                if (!foundMembership) {
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_FORCE_BARBARIAN.getMessage(new Object[0]));
                    ChatUtil.printDebug("Forced non-barbarian player with missing kingdom to become a barbarian");
                }
            } else if (playerKingdom.isMember(bukkitPlayer.getUniqueId())) {
                importedPlayer = new KonPlayer(bukkitPlayer, playerKingdom, false);
            } else {
                importedPlayer = new KonPlayer(bukkitPlayer, this.konquest.getKingdomManager().getBarbarians(), true);
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_FORCE_BARBARIAN.getMessage(new Object[0]));
                ChatUtil.printDebug("Forced non-barbarian player without kingdom membership to become a barbarian");
                playerKingdom.removeTownResidencies(bukkitPlayer.getUniqueId());
            }
        }
        long timeoutSeconds = this.konquest.getOfflineTimeoutSeconds();
        long lastSeenTimeMilliseconds = bukkitPlayer.getLastPlayed();
        if (timeoutSeconds != 0L && lastSeenTimeMilliseconds != 0L && (now = new Date()).after(new Date(lastSeenTimeMilliseconds + timeoutSeconds * 1000L))) {
            ChatUtil.printDebug("Player has exceeded offline timeout");
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_ABSENT.getMessage(new Object[0]));
        }
        if (this.konquest.getKingdomManager().isKingdom(exileKingdomName)) {
            importedPlayer.setExileKingdom(this.konquest.getKingdomManager().getKingdom(exileKingdomName));
        } else {
            importedPlayer.setExileKingdom(this.konquest.getKingdomManager().getBarbarians());
        }
        if (this.onlinePlayers.containsKey(bukkitPlayer)) {
            ChatUtil.printDebug("Skipped importing existing player " + bukkitPlayer.getName());
        } else {
            this.onlinePlayers.put(bukkitPlayer, importedPlayer);
            this.linkOnlinePlayerToCache(importedPlayer);
            ChatUtil.printDebug("Imported player " + bukkitPlayer.getName());
        }
        return importedPlayer;
    }

    private void linkOnlinePlayerToCache(KonPlayer player) {
        OfflinePlayer bukkitOfflinePlayer = player.getOfflineBukkitPlayer();
        ArrayList<OfflinePlayer> removingList = new ArrayList<OfflinePlayer>();
        for (OfflinePlayer offline : this.allPlayers.keySet()) {
            if (!offline.getUniqueId().equals(bukkitOfflinePlayer.getUniqueId())) continue;
            removingList.add(offline);
        }
        for (OfflinePlayer offline : removingList) {
            this.allPlayers.remove(offline);
        }
        if (bukkitOfflinePlayer.getName() != null) {
            this.allPlayers.put(bukkitOfflinePlayer, player);
        }
    }

    @Override
    public KonPlayer getPlayerFromName(String displayName) {
        for (KonPlayer player : this.onlinePlayers.values()) {
            if (player == null || player.getBukkitPlayer().getName() == null || !player.getBukkitPlayer().getName().equalsIgnoreCase(displayName)) continue;
            return player;
        }
        return null;
    }

    @Override
    public KonOfflinePlayer getOfflinePlayerFromName(String displayName) {
        for (KonOfflinePlayer offlinePlayer : this.allPlayers.values()) {
            if (offlinePlayer == null || offlinePlayer.getOfflineBukkitPlayer().getName() == null || !offlinePlayer.getOfflineBukkitPlayer().getName().equalsIgnoreCase(displayName)) continue;
            return offlinePlayer;
        }
        return null;
    }

    @Override
    public KonPlayer getPlayerFromID(UUID id) {
        for (KonPlayer player : this.onlinePlayers.values()) {
            if (player == null || player.getBukkitPlayer().getName() == null || !player.getBukkitPlayer().getUniqueId().equals(id)) continue;
            return player;
        }
        return null;
    }

    @Override
    public KonOfflinePlayer getOfflinePlayerFromID(UUID id) {
        for (KonOfflinePlayer offlinePlayer : this.allPlayers.values()) {
            if (offlinePlayer == null || offlinePlayer.getOfflineBukkitPlayer().getName() == null || !offlinePlayer.getOfflineBukkitPlayer().getUniqueId().equals(id)) continue;
            return offlinePlayer;
        }
        return null;
    }

    @Override
    public Collection<OfflinePlayer> getAllOfflinePlayers() {
        return new HashSet<OfflinePlayer>(this.allPlayers.keySet());
    }

    public Collection<KonOfflinePlayer> getAllKonquestOfflinePlayers() {
        return new HashSet<KonOfflinePlayer>(this.allPlayers.values());
    }

    public ArrayList<KonPlayer> getPlayersInKingdom(String kingdomName) {
        ArrayList<KonPlayer> playerList = new ArrayList<KonPlayer>();
        for (KonPlayer player : this.onlinePlayers.values()) {
            if (!player.getKingdom().getName().equalsIgnoreCase(kingdomName)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public ArrayList<KonPlayer> getPlayersInKingdom(KonquestKingdom kingdom) {
        ArrayList<KonPlayer> playerList = new ArrayList<KonPlayer>();
        for (KonPlayer player : this.onlinePlayers.values()) {
            if (!player.getKingdom().equals(kingdom)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    @Override
    public ArrayList<String> getPlayerNamesInKingdom(String kingdomName) {
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (KonPlayer player : this.onlinePlayers.values()) {
            if (!player.getKingdom().getName().equalsIgnoreCase(kingdomName)) continue;
            playerNameList.add(player.getBukkitPlayer().getName());
        }
        return playerNameList;
    }

    public ArrayList<String> getPlayerNames() {
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (KonPlayer player : this.onlinePlayers.values()) {
            playerNameList.add(player.getBukkitPlayer().getName());
        }
        return playerNameList;
    }

    public ArrayList<String> getAllPlayerNames() {
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (KonOfflinePlayer player : this.allPlayers.values()) {
            playerNameList.add(player.getOfflineBukkitPlayer().getName());
        }
        return playerNameList;
    }

    public ArrayList<KonOfflinePlayer> getAllPlayersInKingdom(String kingdomName) {
        ArrayList<KonOfflinePlayer> playerList = new ArrayList<KonOfflinePlayer>();
        for (KonOfflinePlayer player : this.allPlayers.values()) {
            if (!player.getKingdom().getName().equalsIgnoreCase(kingdomName)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public ArrayList<KonOfflinePlayer> getAllPlayersInKingdom(KonquestKingdom kingdom) {
        ArrayList<KonOfflinePlayer> playerList = new ArrayList<KonOfflinePlayer>();
        for (KonOfflinePlayer player : this.allPlayers.values()) {
            if (!player.getKingdom().equals(kingdom)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public ArrayList<KonPlayer> getPlayersNearTerritory(KonTerritory territory) {
        ArrayList<KonPlayer> playerList = new ArrayList<KonPlayer>();
        block0: for (KonPlayer onlinePlayer : this.onlinePlayers.values()) {
            for (Chunk chunk : HelperUtil.getAreaChunks(onlinePlayer.getBukkitPlayer().getLocation(), 2)) {
                if (!territory.hasChunk(chunk)) continue;
                playerList.add(onlinePlayer);
                continue block0;
            }
        }
        return playerList;
    }

    public ArrayList<KonPlayer> getPlayersInMonument(KonMonument monument) {
        ArrayList<KonPlayer> playerList = new ArrayList<KonPlayer>();
        Chunk monumentChunk = monument.getTravelPoint().getChunk();
        for (KonPlayer player : this.onlinePlayers.values()) {
            Chunk playerChunk = player.getBukkitPlayer().getLocation().getChunk();
            int playerY = player.getBukkitPlayer().getLocation().getBlockY();
            boolean isInChunk = playerChunk.getX() == monumentChunk.getX() && playerChunk.getZ() == monumentChunk.getZ();
            if (!isInChunk || playerY < monument.getBaseY() || playerY > monument.getTopY()) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public Collection<KonPlayer> getPlayersOnline() {
        return new HashSet<KonPlayer>(this.onlinePlayers.values());
    }

    public void initAllSavedPlayers() {
        this.allPlayers.clear();
        for (KonOfflinePlayer offlinePlayer : this.konquest.getDatabaseThread().getDatabase().getAllSavedPlayers()) {
            this.allPlayers.put(offlinePlayer.getOfflineBukkitPlayer(), offlinePlayer);
            KonKingdom playerKingdom = offlinePlayer.getKingdom();
            UUID id = offlinePlayer.getOfflineBukkitPlayer().getUniqueId();
            String playerName = offlinePlayer.getOfflineBukkitPlayer().getName();
            if (!playerKingdom.isCreated() || playerKingdom.isMember(id)) continue;
            ChatUtil.printDebug("Init allPlayers cache failed to match kingdom membership for player " + playerName + " in kingdom " + playerKingdom.getName());
            playerKingdom.addMember(id, false);
        }
        ChatUtil.printDebug("Initialized " + this.allPlayers.size() + " players from saved data.");
    }

    @Override
    public Collection<Player> getBukkitPlayersInKingdom(String kingdomName) {
        HashSet<Player> playerList = new HashSet<Player>();
        for (Player bukkitPlayer : this.onlinePlayers.keySet()) {
            KonPlayer player = this.onlinePlayers.get(bukkitPlayer);
            if (!player.getKingdom().getName().equalsIgnoreCase(kingdomName)) continue;
            playerList.add(bukkitPlayer);
        }
        return playerList;
    }

    @Override
    public Collection<Player> getBukkitPlayersInKingdom(KonquestKingdom kingdom) {
        HashSet<Player> playerList = new HashSet<Player>();
        for (Player bukkitPlayer : this.onlinePlayers.keySet()) {
            KonPlayer player = this.onlinePlayers.get(bukkitPlayer);
            if (!player.getKingdom().equals(kingdom)) continue;
            playerList.add(bukkitPlayer);
        }
        return playerList;
    }

    @Override
    public Collection<OfflinePlayer> getAllBukkitPlayersInKingdom(String kingdomName) {
        HashSet<OfflinePlayer> playerList = new HashSet<OfflinePlayer>();
        for (OfflinePlayer bukkitOfflinePlayer : this.allPlayers.keySet()) {
            KonOfflinePlayer player = this.allPlayers.get(bukkitOfflinePlayer);
            if (!player.getKingdom().getName().equalsIgnoreCase(kingdomName)) continue;
            playerList.add(bukkitOfflinePlayer);
        }
        return playerList;
    }

    @Override
    public Collection<OfflinePlayer> getAllBukkitPlayersInKingdom(KonquestKingdom kingdom) {
        HashSet<OfflinePlayer> playerList = new HashSet<OfflinePlayer>();
        for (OfflinePlayer bukkitOfflinePlayer : this.allPlayers.keySet()) {
            KonOfflinePlayer player = this.allPlayers.get(bukkitOfflinePlayer);
            if (!player.getKingdom().equals(kingdom)) continue;
            playerList.add(bukkitOfflinePlayer);
        }
        return playerList;
    }

    @Override
    public Collection<Player> getBukkitPlayersOnline() {
        return new HashSet<Player>(this.onlinePlayers.keySet());
    }

    public void clearAllMobTargets() {
        for (KonPlayer player : this.onlinePlayers.values()) {
            player.clearAllMobAttackers();
        }
    }

    public boolean togglePlayerFly(KonPlayer player) {
        Player bukkitPlayer = player.getBukkitPlayer();
        if (bukkitPlayer.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            KonTerritory territory;
            if (player.isFlyEnabled()) {
                player.setIsFlyEnabled(false);
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_DISABLE_AUTO.getMessage(new Object[0]));
                return true;
            }
            boolean isFriendly = false;
            if (this.konquest.getTerritoryManager().isChunkClaimed(bukkitPlayer.getLocation()) && (territory = this.konquest.getTerritoryManager().getChunkTerritory(bukkitPlayer.getLocation())) != null && territory.getKingdom().equals(player.getKingdom())) {
                isFriendly = true;
            }
            if (isFriendly) {
                player.setIsFlyEnabled(true);
                player.setFlyDisableWarmup(false);
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.GENERIC_NOTICE_ENABLE_AUTO.getMessage(new Object[0]));
                return true;
            }
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
        } else {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
        }
        return false;
    }
}

