/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.manager.KonquestPlotManager;
import com.github.rumsfield.konquest.api.model.KonquestTown;
import com.github.rumsfield.konquest.model.KonPlot;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import java.awt.Point;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlotManager
implements KonquestPlotManager {
    private final Konquest konquest;
    private boolean isPlotsEnabled;
    private boolean isAllowBuild;
    private boolean isAllowContainers;
    private boolean isIgnoreKnights;
    private int maxSize;

    public PlotManager(Konquest konquest) {
        this.konquest = konquest;
        this.isPlotsEnabled = false;
        this.isAllowBuild = false;
        this.isAllowContainers = false;
        this.isIgnoreKnights = false;
        this.maxSize = 16;
    }

    public void initialize() {
        this.isPlotsEnabled = this.konquest.getCore().getBoolean(CorePath.PLOTS_ENABLE.getPath(), false);
        this.isAllowBuild = this.konquest.getCore().getBoolean(CorePath.PLOTS_ALLOW_BUILD.getPath(), false);
        this.isAllowContainers = this.konquest.getCore().getBoolean(CorePath.PLOTS_ALLOW_CONTAINERS.getPath(), false);
        this.isIgnoreKnights = this.konquest.getCore().getBoolean(CorePath.PLOTS_IGNORE_KNIGHTS.getPath(), false);
        this.maxSize = this.konquest.getCore().getInt(CorePath.PLOTS_MAX_SIZE.getPath(), 16);
        ChatUtil.printDebug("Plot Manager is ready, enabled: " + this.isPlotsEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.isPlotsEnabled;
    }

    public boolean isBuildAllowed() {
        return this.isAllowBuild;
    }

    public boolean isContainerAllowed() {
        return this.isAllowContainers;
    }

    public boolean isKnightIgnored() {
        return this.isIgnoreKnights;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void removePlotPoint(KonTown town, Point point, World world) {
        if (!town.hasPlot(point, world)) {
            return;
        }
        KonPlot plot = town.getPlot(point, world).clone();
        if (plot == null) {
            return;
        }
        town.removePlot(plot);
        plot.removePoint(point);
        if (!plot.getPoints().isEmpty()) {
            town.putPlot(plot);
        }
    }

    public boolean addPlot(KonTown town, KonPlot plot) {
        boolean enabled = this.konquest.getCore().getBoolean(CorePath.PLOTS_ENABLE.getPath(), false);
        if (!enabled) {
            return true;
        }
        for (Point point : plot.getPoints()) {
            if (town.getChunkList().containsKey(point)) continue;
            return false;
        }
        for (OfflinePlayer offlinePlayer : plot.getUserOfflinePlayers()) {
            if (town.isPlayerResident(offlinePlayer)) continue;
            return false;
        }
        town.putPlot(plot);
        return true;
    }

    @Override
    public boolean isPlayerPlotProtectBuild(KonquestTown townArg, Location loc, Player player) {
        if (this.isBuildAllowed()) {
            return false;
        }
        return this.isPlayerPlotProtect(townArg, loc, player);
    }

    @Override
    public boolean isPlayerPlotProtectContainer(KonquestTown townArg, Location loc, Player player) {
        if (this.isContainerAllowed()) {
            return false;
        }
        return this.isPlayerPlotProtect(townArg, loc, player);
    }

    private boolean isPlayerPlotProtect(KonquestTown townArg, Location loc, Player player) {
        if (!(townArg instanceof KonTown)) {
            return false;
        }
        KonTown town = (KonTown)townArg;
        if (!town.hasPlot(loc)) {
            return false;
        }
        if (town.getPlot(loc).hasUser((OfflinePlayer)player)) {
            return false;
        }
        if (this.isKnightIgnored()) {
            return !town.isPlayerKnight((OfflinePlayer)player);
        }
        return !town.isPlayerLord((OfflinePlayer)player);
    }
}

