/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.manager.KonquestRuinManager;
import com.github.rumsfield.konquest.api.model.KonquestRuin;
import com.github.rumsfield.konquest.manager.LootManager;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RuinManager
implements KonquestRuinManager {
    private final Konquest konquest;
    private final HashMap<String, KonRuin> ruinMap;
    private Material ruinCriticalBlock;
    private boolean isRuinDataNull;

    public RuinManager(Konquest konquest) {
        this.konquest = konquest;
        this.ruinMap = new HashMap();
        this.ruinCriticalBlock = Material.OBSIDIAN;
        this.isRuinDataNull = false;
    }

    public void initialize() {
        this.loadCriticalBlocks();
        this.loadRuins();
        this.regenAllRuins();
        ChatUtil.printDebug("Ruin Manager is ready");
    }

    public void regenAllRuins() {
        for (KonRuin ruin : this.ruinMap.values()) {
            ruin.regenCriticalBlocks();
        }
        ChatUtil.printDebug("Regenerated all ruin critical blocks");
    }

    public void removeAllGolems() {
        for (KonRuin ruin : this.ruinMap.values()) {
            ruin.removeAllGolems();
        }
    }

    public void rewardPlayers(KonRuin ruin, KonKingdom kingdom) {
        int rewardFavor = this.konquest.getCore().getInt(CorePath.RUINS_CAPTURE_REWARD_FAVOR.getPath(), 0);
        int rewardExp = this.konquest.getCore().getInt(CorePath.RUINS_CAPTURE_REWARD_EXP.getPath(), 0);
        for (KonPlayer friendly : this.getRuinPlayers(ruin, kingdom)) {
            if (rewardFavor > 0) {
                ChatUtil.printDebug("Ruin capture favor rewarded to player " + friendly.getBukkitPlayer().getName());
                if (KonquestPlugin.depositPlayer((OfflinePlayer)friendly.getBukkitPlayer(), rewardFavor)) {
                    ChatUtil.sendNotice((CommandSender)friendly.getBukkitPlayer(), String.valueOf(ChatColor.LIGHT_PURPLE) + MessagePath.PROTECTION_NOTICE_RUIN.getMessage(ruin.getName()));
                }
            }
            if (rewardExp <= 0) continue;
            friendly.getBukkitPlayer().giveExp(rewardExp);
            ChatUtil.sendNotice((CommandSender)friendly.getBukkitPlayer(), MessagePath.GENERIC_NOTICE_REWARD_EXP.getMessage(rewardExp));
        }
    }

    public List<KonPlayer> getRuinPlayers(KonRuin ruin, KonKingdom kingdom) {
        ArrayList<KonPlayer> players = new ArrayList<KonPlayer>();
        for (KonPlayer friendly : this.konquest.getPlayerManager().getPlayersInKingdom(kingdom)) {
            if (!this.isLocInsideRuin(ruin, friendly.getBukkitPlayer().getLocation())) continue;
            players.add(friendly);
        }
        return players;
    }

    @Override
    public boolean isRuin(String name) {
        return this.ruinMap.containsKey(name.toLowerCase());
    }

    @Override
    public boolean isLocInsideRuin(KonquestRuin ruinArg, Location loc) {
        boolean result = false;
        if (ruinArg instanceof KonRuin) {
            KonRuin ruin = (KonRuin)ruinArg;
            if (this.konquest.getTerritoryManager().isChunkClaimed(loc) && ruin.equals(this.konquest.getTerritoryManager().getChunkTerritory(loc))) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean addRuin(Location loc, String name) {
        boolean result = false;
        if (this.konquest.validateNameConstraints(name) == 0) {
            for (Point point : HelperUtil.getAreaPoints(loc, 2)) {
                if (!this.konquest.getTerritoryManager().isChunkClaimed(point, loc.getWorld())) continue;
                ChatUtil.printDebug("Found a chunk conflict during ruin init: " + name);
                return false;
            }
            String nameLower = name.toLowerCase();
            this.ruinMap.put(nameLower, new KonRuin(loc, name, this.konquest.getKingdomManager().getNeutrals(), this.konquest));
            this.ruinMap.get(nameLower).initClaim();
            this.ruinMap.get(nameLower).updateBarPlayers();
            this.konquest.getTerritoryManager().addAllTerritory(loc.getWorld(), this.ruinMap.get(nameLower).getChunkList());
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(loc);
            this.konquest.getMapHandler().drawUpdateTerritory(this.ruinMap.get(nameLower));
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeRuin(String name) {
        boolean result = false;
        KonRuin oldRuin = this.ruinMap.remove(name.toLowerCase());
        if (oldRuin != null) {
            ArrayList<KonPlayer> nearbyPlayers = this.konquest.getPlayerManager().getPlayersNearTerritory(oldRuin);
            oldRuin.removeAllBarPlayers();
            oldRuin.removeAllGolems();
            this.konquest.getTerritoryManager().removeAllTerritory(oldRuin.getCenterLoc().getWorld(), oldRuin.getChunkList().keySet());
            for (KonPlayer player : nearbyPlayers) {
                this.konquest.getTerritoryManager().updatePlayerBorderParticles(player);
            }
            this.konquest.getMapHandler().drawRemoveTerritory(oldRuin);
            ChatUtil.printDebug("Removed Ruin " + name);
            oldRuin = null;
            result = true;
        }
        return result;
    }

    public boolean renameRuin(String name, String newName) {
        boolean result = false;
        if (this.isRuin(name) && this.konquest.validateNameConstraints(newName) == 0) {
            this.konquest.getMapHandler().drawRemoveTerritory(this.ruinMap.get(name.toLowerCase()));
            this.ruinMap.get(name.toLowerCase()).setName(newName);
            KonRuin ruin = this.ruinMap.remove(name.toLowerCase());
            this.ruinMap.put(newName.toLowerCase(), ruin);
            this.konquest.getMapHandler().drawUpdateTerritory(ruin);
            ruin.updateBarTitle();
            ruin.updateBarPlayers();
            result = true;
        }
        return result;
    }

    public boolean resetRuin(String name) {
        if (!this.isRuin(name)) {
            return false;
        }
        KonRuin ruin = this.ruinMap.get(name.toLowerCase());
        ruin.resetRuinCapture();
        return true;
    }

    @Override
    public KonRuin getRuin(String name) {
        return this.ruinMap.get(name.toLowerCase());
    }

    public Collection<KonRuin> getRuins() {
        return this.ruinMap.values();
    }

    @Override
    public Set<String> getRuinNames() {
        HashSet<String> result = new HashSet<String>();
        for (KonRuin ruin : this.ruinMap.values()) {
            result.add(ruin.getName());
        }
        return result;
    }

    @Override
    public Material getRuinCriticalBlock() {
        return this.ruinCriticalBlock;
    }

    private void loadCriticalBlocks() {
        String ruinCriticalBlockTypeName = this.konquest.getCore().getString(CorePath.RUINS_CRITICAL_BLOCK.getPath(), "");
        try {
            this.ruinCriticalBlock = Material.valueOf((String)ruinCriticalBlockTypeName);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid ruin critical block \"" + ruinCriticalBlockTypeName + "\" given in core.ruins.critical_block, using default OBSIDIAN";
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
        }
    }

    private void loadRuins() {
        FileConfiguration ruinsConfig = this.konquest.getConfigManager().getConfig("ruins");
        if (ruinsConfig.get("ruins") == null) {
            ChatUtil.printConsoleError("Failed to load any ruins from ruins.yml! Check file permissions.");
            this.isRuinDataNull = true;
            return;
        }
        ConfigurationSection ruinsSection = ruinsConfig.getConfigurationSection("ruins");
        for (String ruinName : ruinsConfig.getConfigurationSection("ruins").getKeys(false)) {
            ConfigurationSection ruinSection = ruinsSection.getConfigurationSection(ruinName);
            String worldName = ruinSection.getString("world", "world");
            List sectionList = ruinSection.getDoubleList("center");
            double x = (Double)sectionList.get(0);
            double y = (Double)sectionList.get(1);
            double z = (Double)sectionList.get(2);
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                String message;
                Location ruin_center = new Location(world, x, y, z);
                if (this.addRuin(ruin_center, ruinName)) {
                    KonRuin ruin = this.getRuin(ruinName);
                    if (ruin != null) {
                        ConfigurationSection ruinPropertiesSection;
                        ruin.addPoints(HelperUtil.formatStringToPoints(ruinSection.getString("chunks", "")));
                        for (Location loc : HelperUtil.formatStringToLocations(ruinSection.getString("criticals", ""), world)) {
                            loc.setWorld(world);
                            ruin.setCriticalLocation(loc);
                        }
                        for (Location loc : HelperUtil.formatStringToLocations(ruinSection.getString("spawns", ""), world)) {
                            loc.setWorld(world);
                            ruin.addSpawnLocation(loc);
                        }
                        this.konquest.getTerritoryManager().addAllTerritory(world, ruin.getChunkList());
                        if (ruinSection.contains("loot")) {
                            ruin.setLootTableName(ruinSection.getString("loot", LootManager.defaultLootTableName));
                        }
                        if ((ruinPropertiesSection = ruinSection.getConfigurationSection("properties")) != null) {
                            for (String propertyName : ruinPropertiesSection.getKeys(false)) {
                                boolean value = ruinPropertiesSection.getBoolean(propertyName);
                                KonPropertyFlag property = KonPropertyFlag.getFlag(propertyName);
                                boolean status = ruin.setPropertyValue(property, value);
                                if (status) continue;
                                ChatUtil.printDebug("Failed to set invalid property " + propertyName + " to Ruin " + ruinName);
                            }
                        }
                        ruin.updateBarTitle();
                        continue;
                    }
                    message = "Could not load ruin " + ruinName + ", ruins.yml may be corrupted and needs to be deleted.";
                    ChatUtil.printConsoleError(message);
                    this.konquest.opStatusMessages.add(message);
                    continue;
                }
                message = "Failed to load ruin " + ruinName + ", ruins.yml may be corrupted and needs to be deleted.";
                ChatUtil.printConsoleError(message);
                this.konquest.opStatusMessages.add(message);
                continue;
            }
            String message = "Failed to load ruin " + ruinName + " in an unloaded world, " + worldName + ". Check plugin load order.";
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
        }
    }

    public void saveRuins() {
        if (this.isRuinDataNull && this.ruinMap.isEmpty()) {
            ChatUtil.printConsoleError("Aborted saving ruin data because a problem was encountered while loading data from ruins.yml");
            return;
        }
        YamlConfiguration newSaveConfig = new YamlConfiguration();
        ConfigurationSection root = newSaveConfig.createSection("ruins");
        try {
            for (String name : this.ruinMap.keySet()) {
                KonRuin ruin = this.ruinMap.get(name);
                ConfigurationSection ruinSection = root.createSection(ruin.getName());
                ruinSection.set("world", (Object)ruin.getWorld().getName());
                ruinSection.set("center", (Object)new int[]{ruin.getCenterLoc().getBlockX(), ruin.getCenterLoc().getBlockY(), ruin.getCenterLoc().getBlockZ()});
                ruinSection.set("chunks", (Object)HelperUtil.formatPointsToString(ruin.getChunkList().keySet()));
                ruinSection.set("criticals", (Object)HelperUtil.formatLocationsToString(ruin.getCriticalLocations()));
                ruinSection.set("spawns", (Object)HelperUtil.formatLocationsToString(ruin.getSpawnLocations()));
                ruinSection.set("loot", (Object)ruin.getLootTableName());
                ConfigurationSection ruinPropertiesSection = ruinSection.createSection("properties");
                for (KonPropertyFlag flag : KonPropertyFlag.values()) {
                    if (!ruin.hasPropertyValue(flag)) continue;
                    ruinPropertiesSection.set(flag.toString(), (Object)ruin.getPropertyValue(flag));
                }
            }
            FileConfiguration ruinsConfig = this.konquest.getConfigManager().getConfig("ruins");
            ruinsConfig.set("ruins", newSaveConfig.get("ruins"));
            if (!this.ruinMap.isEmpty()) {
                ChatUtil.printConsole("Saved Ruins");
            }
        }
        catch (Error | Exception internalError) {
            ChatUtil.printConsoleError("Failed to save ruins, report this as a bug to the plugin author!");
            internalError.printStackTrace();
        }
    }
}

