/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.manager.LootManager;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SanctuaryManager {
    private final Konquest konquest;
    private final HashMap<String, KonSanctuary> sanctuaryMap;
    private boolean isSanctuaryDataNull;

    public SanctuaryManager(Konquest konquest) {
        this.konquest = konquest;
        this.sanctuaryMap = new HashMap();
        this.isSanctuaryDataNull = false;
    }

    public void initialize() {
        this.loadSanctuaries();
        ChatUtil.printDebug("Sanctuary Manager is ready");
    }

    public void refresh() {
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            sanctuary.setKingdom(this.konquest.getKingdomManager().getNeutrals());
        }
    }

    public boolean isSanctuary(String name) {
        return this.sanctuaryMap.containsKey(name.toLowerCase());
    }

    public boolean addSanctuary(Location loc, String name) {
        boolean result = false;
        if (this.konquest.validateNameConstraints(name) == 0) {
            for (Point point : HelperUtil.getAreaPoints(loc, 2)) {
                if (!this.konquest.getTerritoryManager().isChunkClaimed(point, loc.getWorld())) continue;
                ChatUtil.printDebug("Found a chunk conflict during sanctuary init: " + name);
                return false;
            }
            String nameLower = name.toLowerCase();
            this.sanctuaryMap.put(nameLower, new KonSanctuary(loc, name, this.konquest.getKingdomManager().getNeutrals(), this.konquest));
            this.sanctuaryMap.get(nameLower).initClaim();
            this.sanctuaryMap.get(nameLower).updateBarPlayers();
            this.konquest.getTerritoryManager().addAllTerritory(loc.getWorld(), this.sanctuaryMap.get(nameLower).getChunkList());
            this.konquest.getTerritoryManager().updatePlayerBorderParticles(loc);
            this.konquest.getMapHandler().drawUpdateTerritory(this.sanctuaryMap.get(nameLower));
            result = true;
        }
        return result;
    }

    public boolean removeSanctuary(String name) {
        if (!this.isSanctuary(name)) {
            return false;
        }
        KonSanctuary oldSanctuary = this.sanctuaryMap.remove(name.toLowerCase());
        if (oldSanctuary != null) {
            ArrayList<KonPlayer> nearbyPlayers = this.konquest.getPlayerManager().getPlayersNearTerritory(oldSanctuary);
            Set<String> templateNames = oldSanctuary.getTemplateNames();
            oldSanctuary.clearAllTemplates();
            oldSanctuary.removeAllBarPlayers();
            ArrayList<Point> sanctuaryPoints = new ArrayList<Point>(oldSanctuary.getChunkList().keySet());
            this.konquest.getShopHandler().deleteShopsInPoints(sanctuaryPoints, oldSanctuary.getWorld());
            this.konquest.getTerritoryManager().removeAllTerritory(oldSanctuary.getCenterLoc().getWorld(), oldSanctuary.getChunkList().keySet());
            for (KonPlayer player : nearbyPlayers) {
                this.konquest.getTerritoryManager().updatePlayerBorderParticles(player);
            }
            this.konquest.getMapHandler().drawRemoveTerritory(oldSanctuary);
            ChatUtil.printDebug("Removed Sanctuary " + name);
            oldSanctuary = null;
            for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
                if (!templateNames.contains(kingdom.getMonumentTemplateName())) continue;
                kingdom.clearMonumentTemplate();
                ChatUtil.printDebug("Cleared monument template from kingdom " + kingdom.getName());
            }
            this.refreshKingdomTemplates();
            return true;
        }
        return false;
    }

    public boolean renameSanctuary(String name, String newName) {
        boolean result = false;
        if (this.isSanctuary(name) && this.konquest.validateNameConstraints(newName) == 0) {
            this.konquest.getMapHandler().drawRemoveTerritory(this.sanctuaryMap.get(name.toLowerCase()));
            this.sanctuaryMap.get(name.toLowerCase()).setName(newName);
            KonSanctuary sanctuary = this.sanctuaryMap.remove(name.toLowerCase());
            this.sanctuaryMap.put(newName.toLowerCase(), sanctuary);
            this.konquest.getMapHandler().drawUpdateTerritory(sanctuary);
            sanctuary.updateBarTitle();
            sanctuary.updateBarPlayers();
            result = true;
        }
        return result;
    }

    public KonSanctuary getSanctuary(String name) {
        return this.sanctuaryMap.get(name.toLowerCase());
    }

    public Collection<KonSanctuary> getSanctuaries() {
        return this.sanctuaryMap.values();
    }

    public Set<String> getSanctuaryNames() {
        HashSet<String> result = new HashSet<String>();
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            result.add(sanctuary.getName());
        }
        return result;
    }

    public String getSanctuaryNameOfTemplate(String name) {
        String result = "";
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(name)) continue;
            result = sanctuary.getName();
        }
        return result;
    }

    public KonSanctuary getSanctuaryOfTemplate(KonMonumentTemplate template) {
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(template.getName())) continue;
            return sanctuary;
        }
        return null;
    }

    public boolean isTemplate(String name) {
        boolean result = false;
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isValidTemplate(String name) {
        boolean result = false;
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(name) || !sanctuary.getTemplate(name).isValid()) continue;
            result = true;
            break;
        }
        return result;
    }

    public KonMonumentTemplate getTemplate(String name) {
        KonMonumentTemplate result = null;
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(name)) continue;
            result = sanctuary.getTemplate(name);
            break;
        }
        return result;
    }

    public KonMonumentTemplate getTemplate(Location loc) {
        KonMonumentTemplate result = null;
        block0: for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            for (KonMonumentTemplate template : sanctuary.getTemplates()) {
                if (!template.isLocInside(loc)) continue;
                result = template;
                continue block0;
            }
        }
        return result;
    }

    public Set<String> getAllTemplateNames() {
        HashSet<String> result = new HashSet<String>();
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            for (KonMonumentTemplate template : sanctuary.getTemplates()) {
                result.add(template.getName());
            }
        }
        return result;
    }

    public Set<String> getAllValidTemplateNames() {
        HashSet<String> result = new HashSet<String>();
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            for (KonMonumentTemplate template : sanctuary.getTemplates()) {
                if (!template.isValid()) continue;
                result.add(template.getName());
            }
        }
        return result;
    }

    public Set<KonMonumentTemplate> getAllTemplates() {
        HashSet<KonMonumentTemplate> result = new HashSet<KonMonumentTemplate>();
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            result.addAll(sanctuary.getTemplates());
        }
        return result;
    }

    public Set<KonMonumentTemplate> getAllValidTemplates() {
        HashSet<KonMonumentTemplate> result = new HashSet<KonMonumentTemplate>();
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            for (KonMonumentTemplate template : sanctuary.getTemplates()) {
                if (!template.isValid()) continue;
                result.add(template);
            }
        }
        return result;
    }

    public int getNumTemplates() {
        int result = 0;
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            result += sanctuary.getTemplates().size();
        }
        return result;
    }

    public int getTallestTemplateHeight() {
        int maxHeight = -1;
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            for (KonMonumentTemplate template : sanctuary.getTemplates()) {
                int templateHeight = template.getHeight();
                if (templateHeight <= maxHeight) continue;
                maxHeight = templateHeight;
            }
        }
        return maxHeight;
    }

    public void refreshKingdomTemplates() {
        ChatUtil.printDebug("Refreshing all kingdom templates...");
        Set<KonMonumentTemplate> templates = this.getAllValidTemplates();
        if (!templates.isEmpty()) {
            KonMonumentTemplate chosenTemplate = templates.iterator().next();
            for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
                if (kingdom.hasMonumentTemplate()) continue;
                ChatUtil.printDebug("Updating kingdom " + kingdom.getName() + " to template " + chosenTemplate.getName());
                kingdom.updateMonumentTemplate(chosenTemplate);
            }
        } else {
            ChatUtil.printDebug("No valid templates exist!");
        }
    }

    public boolean renameMonumentTemplate(String name, String newName) {
        if (!this.isTemplate(name) || this.konquest.validateNameConstraints(newName) != 0) {
            return false;
        }
        KonSanctuary templateSanctuary = null;
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(name)) continue;
            templateSanctuary = sanctuary;
            break;
        }
        if (templateSanctuary == null) {
            return false;
        }
        return templateSanctuary.renameTemplate(name, newName);
    }

    public boolean removeMonumentTemplate(String name) {
        boolean result = false;
        String sanctuaryName = "";
        for (KonSanctuary sanctuary : this.sanctuaryMap.values()) {
            if (!sanctuary.isTemplate(name)) continue;
            sanctuary.stopTemplateBlanking(name);
            result = sanctuary.removeTemplate(name);
            this.konquest.getMapHandler().drawLabelTerritory(sanctuary);
            sanctuaryName = sanctuary.getName();
            break;
        }
        if (result) {
            ChatUtil.printDebug("Removed template " + name + " from sanctuary " + sanctuaryName);
            for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
                if (!kingdom.getMonumentTemplateName().equals(name)) continue;
                kingdom.clearMonumentTemplate();
                ChatUtil.printDebug("Cleared monument template from kingdom " + kingdom.getName());
            }
            this.refreshKingdomTemplates();
        } else {
            ChatUtil.printDebug("Failed to remove template " + name);
        }
        return result;
    }

    public int createMonumentTemplate(KonSanctuary sanctuary, String name, Location corner1, Location corner2, Location travelPoint, double cost, boolean save, boolean forceLoad) {
        int status;
        if (this.isTemplate(name)) {
            KonMonumentTemplate template = this.getTemplate(name);
            template.setCornerOne(corner1);
            template.setCornerTwo(corner2);
            template.setTravelPoint(travelPoint);
            template.setCost(cost);
            template.setValid(false);
            status = this.validateTemplate(template, sanctuary);
            if (status == 0) {
                template.setValid(true);
                ChatUtil.printDebug("Updated existing template " + name);
            } else {
                ChatUtil.printDebug("Failed to update existing template " + name);
                boolean restoreCheck = template.restorePrevious();
                if (restoreCheck) {
                    status = this.validateTemplate(template, sanctuary);
                    if (status == 0) {
                        template.setValid(true);
                        ChatUtil.printDebug("Restored existing template " + name);
                        return 10;
                    }
                    ChatUtil.printDebug("Failed to validate restored existing template " + name);
                } else {
                    ChatUtil.printDebug("Failed to restore Monument Template, null fields: \"" + name + "\"");
                    status = -1;
                }
            }
        } else {
            if (this.konquest.validateNameConstraints(name) != 0) {
                ChatUtil.printDebug("Failed to create Monument Template, bad name: \"" + name + "\"");
                return 5;
            }
            KonMonumentTemplate template = new KonMonumentTemplate(name, corner1, corner2, travelPoint, cost);
            status = this.validateTemplate(template, sanctuary);
            if (status == 0) {
                template.setValid(true);
                sanctuary.addTemplate(name, template);
                ChatUtil.printDebug("Created new valid template " + name);
            } else {
                if (forceLoad) {
                    sanctuary.addTemplate(name, template);
                }
                ChatUtil.printDebug("Created new invalid template " + name);
            }
        }
        this.konquest.getMapHandler().drawLabelTerritory(sanctuary);
        if (status == 0 && save) {
            this.saveSanctuaries();
            this.konquest.getConfigManager().saveConfigs();
        }
        return status;
    }

    public int createMonumentTemplate(KonSanctuary sanctuary, String name, Location corner1, Location corner2, Location travelPoint, double cost) {
        return this.createMonumentTemplate(sanctuary, name, corner1, corner2, travelPoint, cost, true, false);
    }

    public void loadMonumentTemplate(KonSanctuary sanctuary, String name, Location corner1, Location corner2, Location travelPoint, double cost) {
        int status = this.createMonumentTemplate(sanctuary, name, corner1, corner2, travelPoint, cost, false, true);
        if (status != 0) {
            String message = "Invalid Monument Template " + name + " for Sanctuary " + sanctuary.getName() + ", ";
            switch (status) {
                case 1: {
                    message = message + "base dimensions are not 16x16 blocks.";
                    break;
                }
                case 2: {
                    message = message + "region does not contain enough critical blocks.";
                    break;
                }
                case 3: {
                    message = message + "region does not contain a travel point.";
                    break;
                }
                case 4: {
                    message = message + "region is not within territory.";
                    break;
                }
                case 5: {
                    message = message + "invalid name.";
                    break;
                }
                default: {
                    message = message + "unknown reason.";
                }
            }
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
        }
    }

    public int validateTemplate(KonMonumentTemplate template, KonSanctuary sanctuary) {
        if (sanctuary == null || template.getCornerOne() == null || template.getCornerTwo() == null || template.getTravelPoint() == null || template.getName() == null) {
            ChatUtil.printDebug("Failed to validate Monument Template, null arguments");
            return 4;
        }
        String name = template.getName();
        Location corner1 = template.getCornerOne();
        Location corner2 = template.getCornerTwo();
        Location travelPoint = template.getTravelPoint();
        if (!sanctuary.isLocInside(corner1) || !sanctuary.isLocInside(corner2)) {
            ChatUtil.printDebug("Failed to validate Monument Template, corners are not inside sanctuary territory");
            return 4;
        }
        int diffX = (int)Math.abs(corner1.getX() - corner2.getX()) + 1;
        int diffZ = (int)Math.abs(corner1.getZ() - corner2.getZ()) + 1;
        if (diffX != 16 || diffZ != 16) {
            ChatUtil.printDebug("Failed to validate Monument Template, not 16x16: " + diffX + "x" + diffZ);
            return 1;
        }
        int maxCriticalhits = this.konquest.getCore().getInt(CorePath.MONUMENTS_DESTROY_AMOUNT.getPath());
        int c1X = corner1.getBlockX();
        int c1Y = corner1.getBlockY();
        int c1Z = corner1.getBlockZ();
        int c2X = corner2.getBlockX();
        int c2Y = corner2.getBlockY();
        int c2Z = corner2.getBlockZ();
        int bottomBlockX = Math.min(c1X, c2X);
        int bottomBlockY = Math.min(c1Y, c2Y);
        int bottomBlockZ = Math.min(c1Z, c2Z);
        int topBlockX = Math.max(c1X, c2X);
        int topBlockY = Math.max(c1Y, c2Y);
        int topBlockZ = Math.max(c1Z, c2Z);
        int criticalBlockCount = 0;
        int totalBlockCount = 0;
        int lootChestCount = 0;
        boolean containsChest = false;
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int y = bottomBlockY; y <= topBlockY; ++y) {
                for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                    Block monumentBlock = corner1.getWorld().getBlockAt(x, y, z);
                    if (monumentBlock.getType().equals((Object)this.konquest.getKingdomManager().getTownCriticalBlock())) {
                        ++criticalBlockCount;
                    } else if (monumentBlock.getState().getBlockData() instanceof Chest) {
                        Chest blockChestData = (Chest)monumentBlock.getState().getBlockData();
                        if (blockChestData.getType().equals((Object)Chest.Type.SINGLE) || blockChestData.getType().equals((Object)Chest.Type.RIGHT)) {
                            ++lootChestCount;
                        }
                        containsChest = true;
                    }
                    if (!monumentBlock.getType().isSolid()) continue;
                    ++totalBlockCount;
                }
            }
        }
        template.setNumBlocks(totalBlockCount);
        template.setNumCriticals(criticalBlockCount);
        template.setNumLootChests(lootChestCount);
        template.setLoot(containsChest);
        if (criticalBlockCount < maxCriticalhits) {
            ChatUtil.printDebug("Failed to validate Monument Template, not enough critical blocks. Found " + criticalBlockCount + ", required " + maxCriticalhits);
            return 2;
        }
        if (travelPoint.getBlockX() < bottomBlockX || travelPoint.getBlockX() > topBlockX || travelPoint.getBlockY() < bottomBlockY || travelPoint.getBlockY() > topBlockY || travelPoint.getBlockZ() < bottomBlockZ || travelPoint.getBlockZ() > topBlockZ) {
            ChatUtil.printDebug("Failed to create Monument Template, travel point is outside of corner bounds");
            return 3;
        }
        if (containsChest) {
            ChatUtil.printDebug("Validated Monument Template " + name + " with " + lootChestCount + " loot chest(s)");
        } else {
            ChatUtil.printDebug("Validated Monument Template " + name + " without loot");
        }
        return 0;
    }

    private void loadSanctuaries() {
        FileConfiguration sanctuariesConfig = this.konquest.getConfigManager().getConfig("sanctuaries");
        if (sanctuariesConfig.get("sanctuaries") == null) {
            ChatUtil.printConsoleError("Failed to load any sanctuaries from sanctuaries.yml! Check file permissions.");
            this.isSanctuaryDataNull = true;
            return;
        }
        ConfigurationSection sanctuariesSection = sanctuariesConfig.getConfigurationSection("sanctuaries");
        for (String sanctuaryName : sanctuariesConfig.getConfigurationSection("sanctuaries").getKeys(false)) {
            ConfigurationSection sanctuarySection = sanctuariesSection.getConfigurationSection(sanctuaryName);
            String worldName = sanctuarySection.getString("world", "world");
            World sanctuaryWorld = Bukkit.getWorld((String)worldName);
            if (sanctuaryWorld != null) {
                String message;
                float yaw;
                float pitch;
                double val;
                List sectionList = sanctuarySection.getDoubleList("spawn");
                double x = (Double)sectionList.get(0);
                double y = (Double)sectionList.get(1);
                double z = (Double)sectionList.get(2);
                if (sectionList.size() > 3) {
                    val = (Double)sectionList.get(3);
                    pitch = (float)val;
                } else {
                    pitch = 0.0f;
                }
                if (sectionList.size() > 4) {
                    val = (Double)sectionList.get(4);
                    yaw = (float)val;
                } else {
                    yaw = 0.0f;
                }
                Location sanctuarySpawn = new Location(sanctuaryWorld, x, y, z, yaw, pitch);
                sectionList = sanctuarySection.getDoubleList("center");
                x = (Double)sectionList.get(0);
                y = (Double)sectionList.get(1);
                z = (Double)sectionList.get(2);
                Location sanctuaryCenter = new Location(sanctuaryWorld, x, y, z);
                if (this.addSanctuary(sanctuaryCenter, sanctuaryName)) {
                    KonSanctuary sanctuary = this.getSanctuary(sanctuaryName);
                    if (sanctuary != null) {
                        sanctuary.setSpawn(sanctuarySpawn);
                        sanctuary.addPoints(HelperUtil.formatStringToPoints(sanctuarySection.getString("chunks", "")));
                        this.konquest.getTerritoryManager().addAllTerritory(sanctuaryWorld, sanctuary.getChunkList());
                        ConfigurationSection sanctuaryPropertiesSection = sanctuarySection.getConfigurationSection("properties");
                        if (sanctuaryPropertiesSection != null) {
                            for (String propertyName : sanctuaryPropertiesSection.getKeys(false)) {
                                boolean value = sanctuaryPropertiesSection.getBoolean(propertyName);
                                KonPropertyFlag property = KonPropertyFlag.getFlag(propertyName);
                                boolean status = sanctuary.setPropertyValue(property, value);
                                if (status) continue;
                                ChatUtil.printDebug("Failed to set invalid property " + propertyName + " to Sanctuary " + sanctuaryName);
                            }
                        }
                        sanctuary.updateBarTitle();
                        ConfigurationSection sanctuaryMonumentsSection = sanctuarySection.getConfigurationSection("monuments");
                        assert (sanctuaryMonumentsSection != null);
                        for (String templateName : sanctuaryMonumentsSection.getKeys(false)) {
                            ConfigurationSection templateSection = sanctuaryMonumentsSection.getConfigurationSection(templateName);
                            double cost = templateSection.getDouble("cost", 0.0);
                            sectionList = templateSection.getDoubleList("travel");
                            x = (Double)sectionList.get(0);
                            y = (Double)sectionList.get(1);
                            z = (Double)sectionList.get(2);
                            Location templateTravel = new Location(sanctuaryWorld, x, y, z);
                            sectionList = templateSection.getDoubleList("cornerone");
                            x = (Double)sectionList.get(0);
                            y = (Double)sectionList.get(1);
                            z = (Double)sectionList.get(2);
                            Location templateCornerOne = new Location(sanctuaryWorld, x, y, z);
                            sectionList = templateSection.getDoubleList("cornertwo");
                            x = (Double)sectionList.get(0);
                            y = (Double)sectionList.get(1);
                            z = (Double)sectionList.get(2);
                            Location templateCornerTwo = new Location(sanctuaryWorld, x, y, z);
                            this.loadMonumentTemplate(sanctuary, templateName, templateCornerOne, templateCornerTwo, templateTravel, cost);
                            if (!this.isTemplate(templateName)) continue;
                            KonMonumentTemplate template = this.getTemplate(templateName);
                            if (!templateSection.contains("loot")) continue;
                            template.setLootTableName(templateSection.getString("loot", LootManager.defaultLootTableName));
                        }
                        continue;
                    }
                    message = "Could not load Sanctuary " + sanctuaryName + ", sanctuaries.yml may be corrupted and needs to be deleted.";
                    ChatUtil.printConsoleError(message);
                    this.konquest.opStatusMessages.add(message);
                    continue;
                }
                message = "Failed to load Sanctuary " + sanctuaryName + ", sanctuaries.yml may be corrupted and needs to be deleted.";
                ChatUtil.printConsoleError(message);
                this.konquest.opStatusMessages.add(message);
                continue;
            }
            String message = "Failed to load Sanctuary " + sanctuaryName + " in an unloaded world, " + worldName + ". Check plugin load order.";
            ChatUtil.printConsoleError(message);
            this.konquest.opStatusMessages.add(message);
        }
        if (this.sanctuaryMap.isEmpty()) {
            ChatUtil.printDebug("No Sanctuaries to load!");
        } else {
            ChatUtil.printDebug("Loaded Sanctuaries");
        }
    }

    public void saveSanctuaries() {
        if (this.isSanctuaryDataNull && this.sanctuaryMap.isEmpty()) {
            ChatUtil.printConsoleError("Aborted saving sanctuary data because a problem was encountered while loading data from sanctuaries.yml");
            return;
        }
        YamlConfiguration newSaveConfig = new YamlConfiguration();
        ConfigurationSection root = newSaveConfig.createSection("sanctuaries");
        try {
            for (String name : this.sanctuaryMap.keySet()) {
                KonSanctuary sanctuary = this.sanctuaryMap.get(name);
                ConfigurationSection sanctuarySection = root.createSection(sanctuary.getName());
                sanctuarySection.set("world", (Object)sanctuary.getWorld().getName());
                sanctuarySection.set("spawn", (Object)new int[]{sanctuary.getSpawnLoc().getBlockX(), sanctuary.getSpawnLoc().getBlockY(), sanctuary.getSpawnLoc().getBlockZ(), (int)sanctuary.getSpawnLoc().getPitch(), (int)sanctuary.getSpawnLoc().getYaw()});
                sanctuarySection.set("center", (Object)new int[]{sanctuary.getCenterLoc().getBlockX(), sanctuary.getCenterLoc().getBlockY(), sanctuary.getCenterLoc().getBlockZ()});
                sanctuarySection.set("chunks", (Object)HelperUtil.formatPointsToString(sanctuary.getChunkList().keySet()));
                ConfigurationSection sanctuaryPropertiesSection = sanctuarySection.createSection("properties");
                for (KonPropertyFlag flag : KonPropertyFlag.values()) {
                    if (!sanctuary.hasPropertyValue(flag)) continue;
                    sanctuaryPropertiesSection.set(flag.toString(), (Object)sanctuary.getPropertyValue(flag));
                }
                ConfigurationSection sanctuaryMonumentsSection = sanctuarySection.createSection("monuments");
                for (String monumentName : sanctuary.getTemplateNames()) {
                    KonMonumentTemplate template = sanctuary.getTemplate(monumentName);
                    if (!template.isValid()) {
                        ChatUtil.printConsoleError("Saved invalid monument template named " + monumentName + ", in Sanctuary " + name + ".");
                    }
                    ConfigurationSection monumentSection = sanctuaryMonumentsSection.createSection(monumentName);
                    monumentSection.set("cost", (Object)template.getCost());
                    monumentSection.set("loot", (Object)template.getLootTableName());
                    monumentSection.set("travel", (Object)new int[]{template.getTravelPoint().getBlockX(), template.getTravelPoint().getBlockY(), template.getTravelPoint().getBlockZ()});
                    monumentSection.set("cornerone", (Object)new int[]{template.getCornerOne().getBlockX(), template.getCornerOne().getBlockY(), template.getCornerOne().getBlockZ()});
                    monumentSection.set("cornertwo", (Object)new int[]{template.getCornerTwo().getBlockX(), template.getCornerTwo().getBlockY(), template.getCornerTwo().getBlockZ()});
                }
            }
            FileConfiguration sanctuariesConfig = this.konquest.getConfigManager().getConfig("sanctuaries");
            sanctuariesConfig.set("sanctuaries", newSaveConfig.get("sanctuaries"));
            if (!this.sanctuaryMap.isEmpty()) {
                ChatUtil.printConsole("Saved Sanctuaries");
            }
        }
        catch (Error | Exception internalError) {
            ChatUtil.printConsoleError("Failed to save sanctuaries, report this as a bug to the plugin author!");
            internalError.printStackTrace();
        }
    }
}

