/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.manager.KonquestShieldManager;
import com.github.rumsfield.konquest.api.model.KonquestTown;
import com.github.rumsfield.konquest.model.KonArmor;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonShield;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ShieldManager
implements KonquestShieldManager {
    private final Konquest konquest;
    private boolean isShieldsEnabled;
    private boolean isArmorsEnabled;
    private final ArrayList<KonShield> shields;
    private final ArrayList<KonArmor> armors;
    private boolean isGlobalShieldFreeEvent;
    private boolean isGlobalShieldDisableEvent;
    private boolean isGlobalArmorDisableEvent;

    public ShieldManager(Konquest konquest) {
        this.konquest = konquest;
        this.isShieldsEnabled = false;
        this.isArmorsEnabled = false;
        this.shields = new ArrayList();
        this.armors = new ArrayList();
        this.isGlobalShieldFreeEvent = false;
        this.isGlobalShieldDisableEvent = false;
        this.isGlobalArmorDisableEvent = false;
    }

    public void initialize() {
        if (this.loadShields()) {
            this.isShieldsEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ENABLE_SHIELDS.getPath(), false);
        }
        if (this.loadArmors()) {
            this.isArmorsEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ENABLE_ARMOR.getPath(), false);
        }
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            for (KonTown town : kingdom.getTowns()) {
                if (!this.isShieldsEnabled && town.isShielded()) {
                    town.deactivateShield();
                }
                if (this.isArmorsEnabled || !town.isArmored()) continue;
                town.deactivateArmor();
            }
        }
        ChatUtil.printDebug("Shield Manager is ready, shields: " + this.isShieldsEnabled + ", armors: " + this.isArmorsEnabled);
    }

    private boolean loadShields() {
        this.shields.clear();
        FileConfiguration shieldsConfig = this.konquest.getConfigManager().getConfig("shields");
        if (shieldsConfig.get("shields") == null) {
            ChatUtil.printDebug("There is no shields section in shields.yml");
            return false;
        }
        for (String shieldName : shieldsConfig.getConfigurationSection("shields").getKeys(false)) {
            int shieldTime = 120;
            int shieldCost = 50;
            int shieldCostPerResident = 0;
            int shieldCostPerLand = 0;
            ConfigurationSection shieldSection = shieldsConfig.getConfigurationSection("shields." + shieldName);
            assert (shieldSection != null);
            if (shieldSection.contains("charge")) {
                shieldTime = shieldSection.getInt("charge", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"charge\" section for shield \"" + shieldName + "\", using default 120.");
            }
            if (shieldSection.contains("cost")) {
                shieldCost = shieldSection.getInt("cost", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"cost\" section for shield \"" + shieldName + "\", using default 50.");
            }
            if (shieldSection.contains("cost_per_resident")) {
                shieldCostPerResident = shieldSection.getInt("cost_per_resident", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"cost_per_resident\" section for shield \"" + shieldName + "\", using default 0.");
            }
            if (shieldSection.contains("cost_per_land")) {
                shieldCostPerLand = shieldSection.getInt("cost_per_land", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"cost_per_land\" section for shield \"" + shieldName + "\", using default 0.");
            }
            KonShield newShield = new KonShield(shieldName, shieldTime, shieldCost, shieldCostPerResident, shieldCostPerLand);
            this.shields.add(newShield);
        }
        return true;
    }

    private boolean loadArmors() {
        this.armors.clear();
        FileConfiguration shieldsConfig = this.konquest.getConfigManager().getConfig("shields");
        if (shieldsConfig.get("armors") == null) {
            ChatUtil.printDebug("There is no armors section in shields.yml");
            return false;
        }
        for (String armorName : shieldsConfig.getConfigurationSection("armors").getKeys(false)) {
            int armorBlocks = 50;
            int armorCost = 20;
            int armorCostPerResident = 0;
            int armorCostPerLand = 0;
            ConfigurationSection armorSection = shieldsConfig.getConfigurationSection("armors." + armorName);
            assert (armorSection != null);
            if (armorSection.contains("charge")) {
                armorBlocks = armorSection.getInt("charge", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"charge\" section for armor \"" + armorName + "\", using default 50.");
            }
            if (armorSection.contains("cost")) {
                armorCost = armorSection.getInt("cost", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"cost\" section for armor \"" + armorName + "\", using default 20.");
            }
            if (armorSection.contains("cost_per_resident")) {
                armorCostPerResident = armorSection.getInt("cost_per_resident", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"cost_per_resident\" section for armor \"" + armorName + "\", using default 0.");
            }
            if (armorSection.contains("cost_per_land")) {
                armorCostPerLand = armorSection.getInt("cost_per_land", 0);
            } else {
                ChatUtil.printConsoleError("Shields.yml is missing \"cost_per_land\" section for armor \"" + armorName + "\", using default 0.");
            }
            KonArmor newArmor = new KonArmor(armorName, armorBlocks, armorCost, armorCostPerResident, armorCostPerLand);
            this.armors.add(newArmor);
        }
        return true;
    }

    public KonShield getShield(String id) {
        KonShield result = null;
        for (KonShield shield : this.shields) {
            if (!shield.getId().equalsIgnoreCase(id)) continue;
            result = shield;
            break;
        }
        return result;
    }

    public KonArmor getArmor(String id) {
        KonArmor result = null;
        for (KonArmor armor : this.armors) {
            if (!armor.getId().equalsIgnoreCase(id)) continue;
            result = armor;
            break;
        }
        return result;
    }

    @Override
    public boolean isShieldsEnabled() {
        return this.isShieldsEnabled;
    }

    @Override
    public boolean isArmorsEnabled() {
        return this.isArmorsEnabled;
    }

    public List<KonShield> getShields() {
        return this.shields;
    }

    public List<KonArmor> getArmors() {
        return this.armors;
    }

    public int getTotalCostShield(KonShield shield, KonTown town) {
        return shield.getCost() + shield.getCostPerResident() * town.getNumResidents() + shield.getCostPerLand() * town.getNumLand();
    }

    public int getTotalCostArmor(KonArmor armor, KonTown town) {
        return armor.getCost() + armor.getCostPerResident() * town.getNumResidents() + armor.getCostPerLand() * town.getNumLand();
    }

    public boolean activateTownShield(KonShield shield, KonTown town, Player bukkitPlayer, boolean ignoreCost) {
        if (!this.isShieldsEnabled) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        if (this.isGlobalShieldFreeEvent || this.isGlobalShieldDisableEvent) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_EVENT.getMessage(new Object[0]));
            return false;
        }
        Date now = new Date();
        int shieldTime = shield.getDurationSeconds();
        int endTime = (int)(now.getTime() / 1000L) + shieldTime;
        int requiredCost = this.getTotalCostShield(shield, town);
        if (!ignoreCost && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < (double)requiredCost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_COST.getMessage(requiredCost));
            return false;
        }
        boolean isAttackCheckEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_SHIELDS_WHILE_ATTACKED.getPath(), false);
        if (!isAttackCheckEnabled && town.isAttacked()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_ATTACK.getMessage(new Object[0]));
            return false;
        }
        boolean isShieldAddEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_SHIELDS_ADD.getPath(), false);
        if (!isShieldAddEnabled && town.isShielded()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_ADD.getMessage(new Object[0]));
            return false;
        }
        int maxShields = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_SHIELDS.getPath(), 0);
        if (maxShields > 0 && shield.getDurationSeconds() + town.getRemainingShieldTimeSeconds() > maxShields) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_MAX.getMessage(maxShields));
            return false;
        }
        String timeFormat = HelperUtil.getTimeFormat(shield.getDurationSeconds(), ChatColor.AQUA);
        String shieldName = shield.getId() + " " + MessagePath.LABEL_SHIELD.getMessage(new Object[0]);
        if (town.isShielded()) {
            endTime = town.getShieldEndTime() + shieldTime;
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_ACTIVATE_ADD.getMessage(shieldName, timeFormat));
            ChatUtil.printDebug("Activated town shield addition " + shield.getId() + " to town " + town.getName() + " for end time " + endTime);
        } else {
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_ACTIVATE_NEW.getMessage(shieldName, timeFormat));
            ChatUtil.printDebug("Activated new town shield " + shield.getId() + " to town " + town.getName() + " for end time " + endTime);
        }
        town.activateShield(endTime);
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (!ignoreCost && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, requiredCost) && player != null) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, requiredCost);
        }
        return true;
    }

    public boolean activateTownArmor(KonArmor armor, KonTown town, Player bukkitPlayer, boolean ignoreCost) {
        if (!this.isArmorsEnabled) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        if (this.isGlobalArmorDisableEvent) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_EVENT.getMessage(new Object[0]));
            return false;
        }
        int requiredCost = this.getTotalCostArmor(armor, town);
        if (!ignoreCost && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < (double)requiredCost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_COST.getMessage(requiredCost));
            return false;
        }
        boolean isAttackCheckEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ARMOR_WHILE_ATTACKED.getPath(), false);
        if (!isAttackCheckEnabled && town.isAttacked()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_ATTACK.getMessage(new Object[0]));
            return false;
        }
        boolean isArmorAddEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ARMOR_ADD.getPath(), false);
        if (!isArmorAddEnabled && town.isArmored()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_ADD.getMessage(new Object[0]));
            return false;
        }
        int maxArmor = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_ARMOR.getPath(), 0);
        if (maxArmor > 0 && armor.getBlocks() + town.getArmorBlocks() > maxArmor) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_FAIL_MAX.getMessage(maxArmor));
            return false;
        }
        int newArmor = armor.getBlocks();
        String armorName = armor.getId() + " " + MessagePath.LABEL_ARMOR.getMessage(new Object[0]);
        if (town.isArmored()) {
            newArmor = town.getArmorBlocks() + armor.getBlocks();
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_ACTIVATE_ADD.getMessage(armorName, armor.getBlocks()));
            ChatUtil.printDebug("Activated town armor addition " + armor.getId() + " to town " + town.getName() + " for blocks " + armor.getBlocks());
        } else {
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.MENU_SHIELD_ACTIVATE_NEW.getMessage(armorName, armor.getBlocks()));
            ChatUtil.printDebug("Activated new town armor " + armor.getId() + " to town " + town.getName() + " for blocks " + armor.getBlocks());
        }
        town.activateArmor(newArmor);
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (!ignoreCost && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, requiredCost) && player != null) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, requiredCost);
        }
        return true;
    }

    @Override
    public int getTownShieldTime(KonquestTown townArg) {
        int result = -1;
        if (townArg instanceof KonTown) {
            KonTown town = (KonTown)townArg;
            result = town.getShieldEndTime();
        }
        return result;
    }

    @Override
    public int getTownArmorBlocks(KonquestTown townArg) {
        int result = -1;
        if (townArg instanceof KonTown) {
            KonTown town = (KonTown)townArg;
            result = town.getArmorBlocks();
        }
        return result;
    }

    @Override
    public boolean shieldSet(KonquestTown townArg, int value) {
        boolean result = false;
        if (!(townArg instanceof KonTown)) {
            return false;
        }
        KonTown town = (KonTown)townArg;
        Date now = new Date();
        int newEndTime = (int)(now.getTime() / 1000L) + value;
        if (town.isShielded()) {
            if (value <= 0) {
                town.deactivateShield();
            } else {
                town.activateShield(newEndTime);
            }
            result = true;
        } else if (value > 0) {
            town.activateShield(newEndTime);
            result = true;
        }
        return result;
    }

    @Override
    public boolean shieldAdd(KonquestTown townArg, int value) {
        boolean result = false;
        if (townArg instanceof KonTown) {
            Date end;
            KonTown town = (KonTown)townArg;
            Date now = new Date();
            int newEndTime = (int)(now.getTime() / 1000L) + value;
            if (town.isShielded()) {
                newEndTime = town.getShieldEndTime() + value;
            }
            if (now.after(end = new Date((long)newEndTime * 1000L))) {
                if (town.isShielded()) {
                    town.deactivateShield();
                    result = true;
                }
            } else {
                town.activateShield(newEndTime);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean armorSet(KonquestTown townArg, int value) {
        boolean result = false;
        if (!(townArg instanceof KonTown)) {
            return false;
        }
        KonTown town = (KonTown)townArg;
        if (town.isArmored()) {
            if (value <= 0) {
                town.deactivateArmor();
            } else {
                town.activateArmor(value);
            }
            result = true;
        } else if (value > 0) {
            town.activateArmor(value);
            result = true;
        }
        return result;
    }

    @Override
    public boolean armorAdd(KonquestTown townArg, int value) {
        boolean result = false;
        if (!(townArg instanceof KonTown)) {
            return false;
        }
        KonTown town = (KonTown)townArg;
        int newBlocks = value;
        if (town.isArmored()) {
            newBlocks = town.getArmorBlocks() + value;
        }
        if (newBlocks <= 0) {
            if (town.isArmored()) {
                town.deactivateArmor();
                result = true;
            }
        } else {
            town.activateArmor(newBlocks);
            result = true;
        }
        return result;
    }

    public void enableGlobalEventFreeShield(boolean isEnable) {
        this.isGlobalShieldFreeEvent = isEnable;
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            for (KonTown town : kingdom.getCapitalTowns()) {
                town.enableShieldFreeEvent(isEnable);
            }
        }
    }

    public void enableGlobalEventDisableShield(boolean isEnable) {
        this.isGlobalShieldDisableEvent = isEnable;
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            for (KonTown town : kingdom.getCapitalTowns()) {
                town.enableShieldDisableEvent(isEnable);
            }
        }
    }

    public void enableGlobalEventDisableArmor(boolean isEnable) {
        this.isGlobalArmorDisableEvent = isEnable;
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            for (KonTown town : kingdom.getCapitalTowns()) {
                town.enableArmorDisableEvent(isEnable);
            }
        }
    }
}

