/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.territory.KonquestTerritoryChunkEvent;
import com.github.rumsfield.konquest.api.manager.KonquestTerritoryManager;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPlot;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTerritoryCache;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Snow;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerritoryManager
implements KonquestTerritoryManager {
    private final Konquest konquest;
    private final HashMap<World, KonTerritoryCache> territoryWorldCache;
    public static final int DEFAULT_MAP_SIZE = 9;
    public static final int FAR_MAP_SIZE = 19;

    public TerritoryManager(Konquest konquest) {
        this.konquest = konquest;
        this.territoryWorldCache = new HashMap();
    }

    public void addAllTerritory(World world, HashMap<Point, KonTerritory> pointMap) {
        if (this.territoryWorldCache.containsKey(world)) {
            this.territoryWorldCache.get(world).putAll(pointMap);
        } else {
            KonTerritoryCache cache = new KonTerritoryCache();
            cache.putAll(pointMap);
            this.territoryWorldCache.put(world, cache);
        }
    }

    public void addTerritory(World world, Point point, KonTerritory territory) {
        if (this.territoryWorldCache.containsKey(world)) {
            this.territoryWorldCache.get(world).put(point, territory);
        } else {
            KonTerritoryCache cache = new KonTerritoryCache();
            cache.put(point, territory);
            this.territoryWorldCache.put(world, cache);
        }
    }

    public boolean removeAllTerritory(World world, Collection<Point> points) {
        boolean result = false;
        if (this.territoryWorldCache.containsKey(world)) {
            if (this.territoryWorldCache.get(world).removeAll(points)) {
                result = true;
            } else {
                ChatUtil.printDebug("Failed to remove all points for territory from world cache: " + world.getName());
            }
        } else {
            ChatUtil.printDebug("Failed to find world cache for bulk point removal: " + world.getName());
        }
        return result;
    }

    public boolean removeTerritory(World world, Point point) {
        boolean result = false;
        if (this.territoryWorldCache.containsKey(world)) {
            if (this.territoryWorldCache.get(world).remove(point)) {
                result = true;
            } else {
                ChatUtil.printDebug("Failed to remove single point for territory from world cache: " + world.getName());
            }
        } else {
            ChatUtil.printDebug("Failed to find world cache for point removal: " + world.getName());
        }
        return result;
    }

    @Override
    public boolean isChunkClaimed(Location loc) {
        return this.isChunkClaimed(HelperUtil.toPoint(loc), loc.getWorld());
    }

    public boolean isChunkClaimed(Point point, World world) {
        boolean result = false;
        if (this.territoryWorldCache.containsKey(world)) {
            result = this.territoryWorldCache.get(world).has(point);
        }
        return result;
    }

    @Override
    @Nullable
    public KonTerritory getChunkTerritory(Location loc) {
        return this.getChunkTerritory(HelperUtil.toPoint(loc), loc.getWorld());
    }

    @Nullable
    public KonTerritory getChunkTerritory(Point point, World world) {
        if (this.territoryWorldCache.containsKey(world)) {
            return this.territoryWorldCache.get(world).get(point);
        }
        return null;
    }

    public KonTerritory getAdjacentTerritory(Location loc) {
        KonTerritory closestTerritory = null;
        if (this.isChunkClaimed(loc)) {
            closestTerritory = this.getChunkTerritory(loc);
        } else {
            int minDistance = Integer.MAX_VALUE;
            for (Point areaPoint : HelperUtil.getSidePoints(loc)) {
                KonTerritory currentTerritory;
                int searchDist;
                if (!this.isChunkClaimed(areaPoint, loc.getWorld()) || (searchDist = HelperUtil.chunkDistance(loc, (currentTerritory = this.getChunkTerritory(areaPoint, loc.getWorld())).getCenterLoc())) == -1 || searchDist >= minDistance) continue;
                minDistance = searchDist;
                closestTerritory = currentTerritory;
            }
        }
        return closestTerritory;
    }

    @Override
    public int getDistanceToClosestTerritory(Location loc) {
        int minDistance = Integer.MAX_VALUE;
        int searchDist = 0;
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            searchDist = HelperUtil.chunkDistance(loc, kingdom.getCapital().getCenterLoc());
            if (searchDist != -1 && searchDist < minDistance) {
                minDistance = searchDist;
            }
            for (KonTown town : kingdom.getTowns()) {
                searchDist = HelperUtil.chunkDistance(loc, town.getCenterLoc());
                if (searchDist == -1 || searchDist >= minDistance) continue;
                minDistance = searchDist;
            }
        }
        for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
            searchDist = HelperUtil.chunkDistance(loc, ruin.getCenterLoc());
            if (searchDist == -1 || searchDist >= minDistance) continue;
            minDistance = searchDist;
        }
        for (KonSanctuary sanctuary : this.konquest.getSanctuaryManager().getSanctuaries()) {
            searchDist = HelperUtil.chunkDistance(loc, sanctuary.getCenterLoc());
            if (searchDist == -1 || searchDist >= minDistance) continue;
            minDistance = searchDist;
        }
        return minDistance;
    }

    @Override
    public int claimChunk(Location loc, boolean force) {
        if (this.isChunkClaimed(loc)) {
            return 3;
        }
        boolean foundAdjTerr = false;
        KonTerritory closestAdjTerr = null;
        World claimWorld = loc.getWorld();
        int minDistance = Integer.MAX_VALUE;
        for (Point sidePoint : HelperUtil.getSidePoints(loc)) {
            KonTerritory currentTerr;
            int searchDist;
            if (!this.isChunkClaimed(sidePoint, claimWorld) || (searchDist = HelperUtil.chunkDistance(loc, (currentTerr = this.getChunkTerritory(sidePoint, claimWorld)).getCenterLoc())) == -1 || searchDist >= minDistance) continue;
            minDistance = searchDist;
            closestAdjTerr = currentTerr;
            foundAdjTerr = true;
        }
        if (foundAdjTerr) {
            Point addPoint = HelperUtil.toPoint(loc);
            if (closestAdjTerr.getWorld().equals((Object)loc.getWorld()) && closestAdjTerr.testChunk(addPoint)) {
                KonPropertyFlagHolder holder;
                if (closestAdjTerr instanceof KonPropertyFlagHolder && !force && (holder = (KonPropertyFlagHolder)((Object)closestAdjTerr)).hasPropertyValue(KonPropertyFlag.CLAIM) && !holder.getPropertyValue(KonPropertyFlag.CLAIM)) {
                    return 5;
                }
                HashSet<Point> points = new HashSet<Point>();
                points.add(addPoint);
                KonquestTerritoryChunkEvent invokeEvent = new KonquestTerritoryChunkEvent(this.konquest, closestAdjTerr, loc, points, true);
                Konquest.callKonquestEvent(invokeEvent);
                if (invokeEvent.isCancelled()) {
                    return 4;
                }
                closestAdjTerr.addChunk(addPoint);
                this.addTerritory(loc.getWorld(), addPoint, closestAdjTerr);
                this.konquest.getMapHandler().drawUpdateTerritory(closestAdjTerr);
                this.konquest.getMapHandler().drawLabelTerritory(closestAdjTerr.getKingdom().getCapital());
                for (KonPlayer occupant : this.konquest.getPlayerManager().getPlayersOnline()) {
                    if (!occupant.getBukkitPlayer().getLocation().getChunk().equals((Object)loc.getChunk())) continue;
                    String color = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)occupant, closestAdjTerr);
                    ChatUtil.sendKonTitle(occupant, "", color + closestAdjTerr.getName());
                    if (closestAdjTerr instanceof KonBarDisplayer) {
                        ((KonBarDisplayer)((Object)closestAdjTerr)).addBarPlayer(occupant);
                    }
                    this.updatePlayerBorderParticles(occupant);
                }
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public boolean claimForAdmin(@NotNull KonPlayer player, @NotNull Location claimLoc) {
        Player bukkitPlayer = player.getBukkitPlayer();
        int claimStatus = this.claimChunk(claimLoc, true);
        switch (claimStatus) {
            case 0: {
                KonTerritory territory = this.getChunkTerritory(claimLoc);
                String territoryName = territory == null ? "" : territory.getName();
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_NOTICE_SUCCESS.getMessage("1", territoryName));
                HashSet<Point> claimSet = new HashSet<Point>();
                claimSet.add(HelperUtil.toPoint(claimLoc));
                player.getAdminClaimRegister().push(claimSet, territory);
                break;
            }
            case 1: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_ADJACENT.getMessage(new Object[0]));
                break;
            }
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_FAR.getMessage(new Object[0]));
                break;
            }
            case 3: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_CLAIMED.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(claimStatus));
            }
        }
        return claimStatus == 0;
    }

    public boolean claimForPlayer(@NotNull KonPlayer player, @NotNull Location claimLoc) {
        Player bukkitPlayer = player.getBukkitPlayer();
        World claimWorld = claimLoc.getWorld();
        if (this.konquest.getIntegrationManager().getWorldGuard().isEnabled() && !this.konquest.getIntegrationManager().getWorldGuard().isChunkClaimAllowed(claimLoc, bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_CLAIM_DENY.getMessage(new Object[0]));
            return false;
        }
        boolean isClaimResidentOnly = this.konquest.getCore().getBoolean(CorePath.TOWNS_ALLOW_CLAIM_RESIDENTS_ONLY.getPath(), false);
        for (Point point : HelperUtil.getAreaPoints(claimLoc, 2)) {
            if (!this.isChunkClaimed(point, claimWorld)) continue;
            KonTerritory territory = this.getChunkTerritory(point, claimWorld);
            if (territory != null && !player.getKingdom().equals(territory.getKingdom())) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_PROXIMITY.getMessage(new Object[0]));
                return false;
            }
            if (!isClaimResidentOnly || !(territory instanceof KonTown) || ((KonTown)territory).isPlayerResident((OfflinePlayer)player.getBukkitPlayer())) continue;
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_RESIDENT.getMessage(territory.getName()));
            return false;
        }
        double cost = this.konquest.getCore().getDouble(CorePath.FAVOR_COST_CLAIM.getPath());
        if (KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < cost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(cost));
            return false;
        }
        int claimStatus = this.claimChunk(claimLoc, false);
        switch (claimStatus) {
            case 0: {
                KonTerritory territory = this.getChunkTerritory(claimLoc);
                String territoryName = territory == null ? "" : territory.getName();
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_NOTICE_SUCCESS.getMessage("1", territoryName));
                this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CLAIM_LAND);
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CLAIMED, 1);
                break;
            }
            case 1: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_ADJACENT.getMessage(new Object[0]));
                break;
            }
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_FAR.getMessage(new Object[0]));
                break;
            }
            case 3: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_CLAIMED.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(claimStatus));
            }
        }
        if (cost > 0.0 && claimStatus == 0 && KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, cost)) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)cost);
        }
        return claimStatus == 0;
    }

    public int claimChunkRadius(Location loc, int radius, boolean force) {
        KonPropertyFlagHolder holder;
        World claimWorld = loc.getWorld();
        KonTerritory closestTerritory = this.getAdjacentTerritory(loc);
        if (closestTerritory == null || !closestTerritory.getWorld().equals((Object)claimWorld)) {
            return 1;
        }
        HashSet<Point> unclaimedChunks = new HashSet<Point>();
        for (Point point : HelperUtil.getAreaPoints(loc, radius)) {
            if (this.isChunkClaimed(point, claimWorld)) continue;
            unclaimedChunks.add(point);
        }
        boolean isAnyChunkBeyondDistanceLimit = false;
        HashSet<Point> claimedChunks = new HashSet<Point>();
        for (Point newChunk : unclaimedChunks) {
            if (closestTerritory.testChunk(newChunk)) {
                claimedChunks.add(newChunk);
                continue;
            }
            isAnyChunkBeyondDistanceLimit = true;
        }
        if (isAnyChunkBeyondDistanceLimit) {
            ChatUtil.printDebug("Not all chunks could be claimed due to max distance limit");
        }
        if (claimedChunks.isEmpty()) {
            return 2;
        }
        if (closestTerritory instanceof KonPropertyFlagHolder && !force && (holder = (KonPropertyFlagHolder)((Object)closestTerritory)).hasPropertyValue(KonPropertyFlag.CLAIM) && !holder.getPropertyValue(KonPropertyFlag.CLAIM)) {
            return 5;
        }
        HashSet<Point> points = new HashSet<Point>(claimedChunks);
        KonquestTerritoryChunkEvent invokeEvent = new KonquestTerritoryChunkEvent(this.konquest, closestTerritory, loc, points, true);
        Konquest.callKonquestEvent(invokeEvent);
        if (invokeEvent.isCancelled()) {
            return 4;
        }
        for (Point claimChunk : claimedChunks) {
            closestTerritory.addChunk(claimChunk);
            this.addTerritory(claimWorld, claimChunk, closestTerritory);
        }
        this.konquest.getMapHandler().drawUpdateTerritory(closestTerritory);
        this.konquest.getMapHandler().drawLabelTerritory(closestTerritory.getKingdom().getCapital());
        for (KonPlayer occupant : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!closestTerritory.isLocInside(occupant.getBukkitPlayer().getLocation())) continue;
            String color = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)occupant, closestTerritory);
            ChatUtil.sendKonTitle(occupant, "", color + closestTerritory.getName());
            if (closestTerritory instanceof KonBarDisplayer) {
                ((KonBarDisplayer)((Object)closestTerritory)).addBarPlayer(occupant);
            }
            this.updatePlayerBorderParticles(occupant);
        }
        return 0;
    }

    public boolean claimRadiusForAdmin(@NotNull KonPlayer player, Location claimLoc, int radius) {
        World claimWorld = claimLoc.getWorld();
        Player bukkitPlayer = player.getBukkitPlayer();
        KonTerritory claimTerritory = this.getAdjacentTerritory(claimLoc);
        if (claimTerritory == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_MISSING.getMessage(new Object[0]));
            return false;
        }
        for (Point point : HelperUtil.getAreaPoints(claimLoc, radius + 1)) {
            if (!this.isChunkClaimed(point, claimWorld) || claimTerritory.getKingdom().equals(this.getChunkTerritory(point, claimWorld).getKingdom())) continue;
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_PROXIMITY.getMessage(new Object[0]));
            return false;
        }
        HashSet<Point> toClaimChunks = new HashSet<Point>();
        for (Point point : HelperUtil.getAreaPoints(claimLoc, radius)) {
            if (this.isChunkClaimed(point, claimWorld) || !claimTerritory.testChunk(point)) continue;
            toClaimChunks.add(point);
        }
        int n = claimTerritory.getChunkPoints().size();
        int claimStatus = this.claimChunkRadius(claimLoc, radius, true);
        switch (claimStatus) {
            case 0: {
                int postClaimLand = claimTerritory.getChunkPoints().size();
                int numChunksClaimed = postClaimLand - n;
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_NOTICE_SUCCESS.getMessage(numChunksClaimed, claimTerritory.getName()));
                HashSet<Point> claimSet = new HashSet<Point>(toClaimChunks);
                player.getAdminClaimRegister().push(claimSet, claimTerritory);
                break;
            }
            case 1: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_ADJACENT.getMessage(new Object[0]));
                return false;
            }
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_FAR.getMessage(new Object[0]));
                return false;
            }
            case 4: {
                return false;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(claimStatus));
                return false;
            }
        }
        return true;
    }

    public boolean claimRadiusForPlayer(@NotNull KonPlayer player, Location claimLoc, int radius) {
        Player bukkitPlayer = player.getBukkitPlayer();
        World claimWorld = claimLoc.getWorld();
        assert (claimWorld != null);
        boolean isClaimResidentOnly = this.konquest.getCore().getBoolean(CorePath.TOWNS_ALLOW_CLAIM_RESIDENTS_ONLY.getPath(), false);
        for (Point point : HelperUtil.getAreaPoints(claimLoc, radius + 1)) {
            if (!this.isChunkClaimed(point, claimWorld)) continue;
            KonTerritory territory = this.getChunkTerritory(point, claimWorld);
            if (territory != null && !player.getKingdom().equals(territory.getKingdom())) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_PROXIMITY.getMessage(new Object[0]));
                return false;
            }
            if (!isClaimResidentOnly || !(territory instanceof KonTown) || ((KonTown)territory).isPlayerResident((OfflinePlayer)player.getBukkitPlayer())) continue;
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_RESIDENT.getMessage(territory.getName()));
            return false;
        }
        KonTerritory claimTerritory = this.getAdjacentTerritory(claimLoc);
        if (claimTerritory == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_MISSING.getMessage(new Object[0]));
            return false;
        }
        HashSet<Point> toClaimChunks = new HashSet<Point>();
        for (Point point : HelperUtil.getAreaPoints(claimLoc, radius)) {
            if (this.isChunkClaimed(point, claimWorld) || !claimTerritory.testChunk(point)) continue;
            toClaimChunks.add(point);
        }
        if (this.konquest.getIntegrationManager().getWorldGuard().isEnabled()) {
            for (Point testPoint : toClaimChunks) {
                if (this.konquest.getIntegrationManager().getWorldGuard().isChunkClaimAllowed(claimWorld, testPoint, bukkitPlayer)) continue;
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_CLAIM_DENY.getMessage(new Object[0]));
                return false;
            }
        }
        int unclaimedChunkAmount = toClaimChunks.size();
        double cost = this.konquest.getCore().getDouble(CorePath.FAVOR_COST_CLAIM.getPath());
        double totalCost = (double)unclaimedChunkAmount * cost;
        if (KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < totalCost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(totalCost));
            return false;
        }
        int preClaimLand = claimTerritory.getChunkPoints().size();
        int claimStatus = this.claimChunkRadius(claimLoc, radius, false);
        switch (claimStatus) {
            case 0: {
                double finalCost;
                int postClaimLand = claimTerritory.getChunkPoints().size();
                int numChunksClaimed = postClaimLand - preClaimLand;
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_NOTICE_SUCCESS.getMessage(numChunksClaimed, claimTerritory.getName()));
                this.konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CLAIM_LAND);
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.CLAIMED, numChunksClaimed);
                if (!(cost > 0.0) || numChunksClaimed <= 0 || !KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, finalCost = (double)numChunksClaimed * cost)) break;
                this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)finalCost);
                break;
            }
            case 1: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_ADJACENT.getMessage(new Object[0]));
                return false;
            }
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_CLAIM_ERROR_FAIL_FAR.getMessage(new Object[0]));
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                return false;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(claimStatus));
                return false;
            }
        }
        return true;
    }

    private boolean removeClaims(Set<Point> points, KonTerritory territory) {
        if (territory == null || points == null || points.isEmpty()) {
            return false;
        }
        World territoryWorld = territory.getWorld();
        Point territorySpawn = HelperUtil.toPoint(territory.getSpawnLoc());
        HashSet<KonPlayer> occupants = new HashSet<KonPlayer>();
        for (KonPlayer occupant : this.konquest.getPlayerManager().getPlayersOnline()) {
            if (!territory.isLocInside(occupant.getBukkitPlayer().getLocation())) continue;
            occupants.add(occupant);
        }
        boolean doUpdates = false;
        for (Point unclaimPoint : points) {
            boolean allowUnclaim = true;
            if (territory.getChunkList().containsKey(unclaimPoint)) {
                KonSanctuary sanctuary;
                boolean status;
                if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.TOWN)) {
                    this.konquest.getPlotManager().removePlotPoint((KonTown)territory, unclaimPoint, territoryWorld);
                } else if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY) && (status = (sanctuary = (KonSanctuary)territory).isChunkOnTemplate(unclaimPoint, territoryWorld))) {
                    allowUnclaim = false;
                }
            }
            if (!allowUnclaim || !territory.removeChunk(unclaimPoint)) continue;
            if (territorySpawn.equals(unclaimPoint)) {
                territory.setSpawn(territory.getCenterLoc());
            }
            this.removeTerritory(territoryWorld, unclaimPoint);
            doUpdates = true;
        }
        if (doUpdates) {
            for (KonPlayer occupant : occupants) {
                this.updatePlayerBorderParticles(occupant);
            }
            if (territory instanceof KonBarDisplayer) {
                ((KonBarDisplayer)((Object)territory)).updateBarPlayers();
            }
            this.konquest.getMapHandler().drawUpdateTerritory(territory);
            this.konquest.getMapHandler().drawLabelTerritory(territory.getKingdom().getCapital());
        }
        return doUpdates;
    }

    public boolean claimUndoForAdmin(KonPlayer player) {
        if (player == null) {
            return false;
        }
        Set<Point> claimPoints = player.getAdminClaimRegister().getClaim();
        KonTerritory claimTerritory = player.getAdminClaimRegister().getTerritory();
        player.getAdminClaimRegister().pop();
        return this.removeClaims(claimPoints, claimTerritory);
    }

    @Override
    public int unclaimChunk(Location loc, boolean force) {
        KonPropertyFlagHolder holder;
        if (!this.isChunkClaimed(loc)) {
            return 1;
        }
        KonTerritory territory = this.getChunkTerritory(loc);
        if (territory.isLocInCenter(loc)) {
            return 2;
        }
        if (territory instanceof KonPropertyFlagHolder && !force && (holder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.UNCLAIM) && !holder.getPropertyValue(KonPropertyFlag.UNCLAIM)) {
            return 5;
        }
        HashSet<Point> points = new HashSet<Point>();
        points.add(HelperUtil.toPoint(loc));
        KonquestTerritoryChunkEvent invokeEvent = new KonquestTerritoryChunkEvent(this.konquest, territory, loc, points, false);
        Konquest.callKonquestEvent(invokeEvent);
        if (invokeEvent.isCancelled()) {
            return 4;
        }
        boolean status = this.removeClaims(points, territory);
        return status ? 0 : 3;
    }

    public boolean unclaimForAdmin(@NotNull KonPlayer player, @NotNull Location claimLoc) {
        Player bukkitPlayer = player.getBukkitPlayer();
        KonTerritory territory = this.getChunkTerritory(claimLoc);
        int unclaimStatus = this.unclaimChunk(claimLoc, true);
        switch (unclaimStatus) {
            case 0: {
                String unclaimedName = "";
                if (territory != null) {
                    unclaimedName = territory.getName();
                }
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_NOTICE_SUCCESS.getMessage("1", unclaimedName));
                break;
            }
            case 1: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
                break;
            }
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_CENTER.getMessage(new Object[0]));
                break;
            }
            case 3: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(unclaimStatus));
            }
        }
        return unclaimStatus == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean unclaimForPlayer(@NotNull KonPlayer player, @NotNull Location claimLoc) {
        Player bukkitPlayer = player.getBukkitPlayer();
        if (!this.isChunkClaimed(claimLoc)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
            return false;
        }
        KonTerritory territory = this.getChunkTerritory(claimLoc);
        if (!(territory instanceof KonTown)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_TOWN.getMessage(new Object[0]));
            return false;
        }
        KonTown town = (KonTown)territory;
        if (!town.isPlayerLord((OfflinePlayer)bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_LORD.getMessage(new Object[0]));
            return false;
        }
        if (this.konquest.getIntegrationManager().getWorldGuard().isEnabled() && !this.konquest.getIntegrationManager().getWorldGuard().isChunkUnclaimAllowed(claimLoc, bukkitPlayer)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_UNCLAIM_DENY.getMessage(new Object[0]));
            return false;
        }
        territory = this.getChunkTerritory(claimLoc);
        String territoryName = territory.getName();
        int unclaimStatus = this.unclaimChunk(claimLoc, false);
        switch (unclaimStatus) {
            case 0: {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_NOTICE_SUCCESS.getMessage("1", territoryName));
                break;
            }
            case 1: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
                break;
            }
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_CENTER.getMessage(new Object[0]));
                break;
            }
            case 3: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(unclaimStatus));
            }
        }
        if (unclaimStatus != 0) return false;
        return true;
    }

    public int unclaimChunkRadius(Location loc, int radius, boolean force) {
        KonPropertyFlagHolder holder;
        if (!this.isChunkClaimed(loc)) {
            return 1;
        }
        KonTerritory territory = this.getChunkTerritory(loc);
        HashSet<Point> claimedChunks = new HashSet<Point>();
        Point territoryCenter = HelperUtil.toPoint(territory.getCenterLoc());
        for (Point point : HelperUtil.getAreaPoints(loc, radius)) {
            if (!territory.getChunkPoints().contains(point) || territoryCenter.equals(point)) continue;
            claimedChunks.add(point);
        }
        if (claimedChunks.isEmpty()) {
            return 2;
        }
        if (territory instanceof KonPropertyFlagHolder && !force && (holder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.UNCLAIM) && !holder.getPropertyValue(KonPropertyFlag.UNCLAIM)) {
            return 5;
        }
        HashSet<Point> points = new HashSet<Point>(claimedChunks);
        KonquestTerritoryChunkEvent invokeEvent = new KonquestTerritoryChunkEvent(this.konquest, territory, loc, points, false);
        Konquest.callKonquestEvent(invokeEvent);
        if (invokeEvent.isCancelled()) {
            return 4;
        }
        boolean status = this.removeClaims(points, territory);
        return status ? 0 : 3;
    }

    public boolean unclaimRadiusForAdmin(@NotNull KonPlayer player, @NotNull Location claimLoc, int radius) {
        Player bukkitPlayer = player.getBukkitPlayer();
        KonTerritory unclaimTerritory = this.getChunkTerritory(claimLoc);
        if (unclaimTerritory == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
            return false;
        }
        int preClaimLand = unclaimTerritory.getChunkPoints().size();
        int unclaimStatus = this.unclaimChunkRadius(claimLoc, radius, true);
        switch (unclaimStatus) {
            case 0: {
                int postClaimLand = unclaimTerritory.getChunkPoints().size();
                int numChunksClaimed = preClaimLand - postClaimLand;
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_NOTICE_SUCCESS.getMessage(numChunksClaimed, unclaimTerritory.getName()));
                break;
            }
            case 1: 
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
                break;
            }
            case 3: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(unclaimStatus));
            }
        }
        return unclaimStatus == 0;
    }

    public boolean unclaimRadiusForPlayer(@NotNull KonPlayer player, @NotNull Location claimLoc, int radius) {
        KonTerritory unclaimTerritory;
        Player bukkitPlayer = player.getBukkitPlayer();
        HashSet<Point> toUnclaimChunks = new HashSet<Point>();
        World claimWorld = claimLoc.getWorld();
        assert (claimWorld != null);
        if (this.isChunkClaimed(claimLoc)) {
            KonTerritory territory = this.getChunkTerritory(claimLoc);
            if (territory instanceof KonTown) {
                KonTown town = (KonTown)territory;
                if (!town.isPlayerLord((OfflinePlayer)bukkitPlayer)) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_LORD.getMessage(new Object[0]));
                    return false;
                }
            } else {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_TOWN.getMessage(new Object[0]));
                return false;
            }
            Point territoryCenter = HelperUtil.toPoint(territory.getCenterLoc());
            for (Point point : HelperUtil.getAreaPoints(claimLoc, radius)) {
                if (!territory.getChunkPoints().contains(point) || territoryCenter.equals(point)) continue;
                toUnclaimChunks.add(point);
            }
        } else {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
            return false;
        }
        if (this.konquest.getIntegrationManager().getWorldGuard().isEnabled()) {
            for (Point testPoint : toUnclaimChunks) {
                if (this.konquest.getIntegrationManager().getWorldGuard().isChunkUnclaimAllowed(claimWorld, testPoint, bukkitPlayer)) continue;
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_UNCLAIM_DENY.getMessage(new Object[0]));
                return false;
            }
        }
        if ((unclaimTerritory = this.getChunkTerritory(claimLoc)) == null) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
            return false;
        }
        int preClaimLand = unclaimTerritory.getChunkPoints().size();
        int unclaimStatus = this.unclaimChunkRadius(claimLoc, radius, false);
        switch (unclaimStatus) {
            case 0: {
                int postClaimLand = unclaimTerritory.getChunkPoints().size();
                int numChunksClaimed = preClaimLand - postClaimLand;
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_NOTICE_SUCCESS.getMessage(numChunksClaimed, unclaimTerritory.getName()));
                break;
            }
            case 1: 
            case 2: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_UNCLAIM_ERROR_FAIL_UNCLAIMED.getMessage(new Object[0]));
                break;
            }
            case 3: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]));
                break;
            }
            default: {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(unclaimStatus));
            }
        }
        return unclaimStatus == 0;
    }

    public HashMap<Location, Color> getBorderLocationMap(ArrayList<Chunk> renderChunks, KonPlayer player) {
        HashMap<Location, Color> locationMap = new HashMap<Location, Color>();
        int Y_MIN_LIMIT = player.getBukkitPlayer().getWorld().getMinHeight() + 1;
        int Y_MAX_LIMIT = player.getBukkitPlayer().getWorld().getMaxHeight() - 1;
        double X_MOD = 0.5;
        double Y_MOD = 1.0;
        double Y_MOD_SNOW = 1.1;
        double Z_MOD = 0.5;
        int[] sideLUTX = new int[]{0, 0, 1, -1};
        int[] sideLUTZ = new int[]{1, -1, 0, 0};
        int[] blockLUTXmin = new int[]{0, 0, 15, 0};
        int[] blockLUTXmax = new int[]{15, 15, 15, 0};
        int[] blockLUTZmin = new int[]{15, 0, 0, 0};
        int[] blockLUTZmax = new int[]{15, 0, 15, 15};
        for (Chunk chunk : renderChunks) {
            World renderWorld;
            Point point = HelperUtil.toPoint(chunk);
            if (!this.isChunkClaimed(point, renderWorld = chunk.getWorld())) continue;
            KonTerritory territory = this.getChunkTerritory(point, renderWorld);
            KonKingdom chunkKingdom = territory.getKingdom();
            Color renderColor = ChatUtil.lookupColor(this.konquest.getDisplayPrimaryColor((KonquestOfflinePlayer)player, territory));
            for (int i = 0; i < 4; ++i) {
                Point sidePoint = new Point(point.x + sideLUTX[i], point.y + sideLUTZ[i]);
                boolean isClaimed = this.isChunkClaimed(sidePoint, renderWorld);
                if (isClaimed && this.getChunkTerritory(sidePoint, renderWorld).getKingdom().equals(chunkKingdom)) continue;
                ChunkSnapshot chunkSnap = chunk.getChunkSnapshot(true, false, false);
                int y_max = 0;
                for (int x = blockLUTXmin[i]; x <= blockLUTXmax[i]; ++x) {
                    for (int z = blockLUTZmin[i]; z <= blockLUTZmax[i]; ++z) {
                        Snow snowBlock;
                        y_max = chunkSnap.getHighestBlockYAt(x, z);
                        y_max = Math.min(y_max, Y_MAX_LIMIT);
                        for (y_max = Math.max(y_max, Y_MIN_LIMIT); (chunk.getBlock(x, y_max, z).isPassable() || !chunk.getBlock(x, y_max, z).getType().isOccluding()) && y_max > Y_MIN_LIMIT; --y_max) {
                        }
                        while (chunk.getBlock(x, y_max + 1, z).isLiquid() && y_max < Y_MAX_LIMIT) {
                            ++y_max;
                        }
                        Block renderBlock = chunk.getBlock(x, y_max, z);
                        Block aboveBlock = chunk.getBlock(x, y_max + 1, z);
                        double y_mod = 1.0;
                        if (aboveBlock.getBlockData() instanceof Snow && (snowBlock = (Snow)aboveBlock.getBlockData()).getLayers() >= snowBlock.getMinimumLayers()) {
                            y_mod = 1.1;
                        }
                        Location renderLoc = new Location(renderBlock.getWorld(), renderBlock.getLocation().getX() + 0.5, renderBlock.getLocation().getY() + y_mod, renderBlock.getLocation().getZ() + 0.5);
                        locationMap.put(renderLoc, renderColor);
                    }
                }
            }
        }
        return locationMap;
    }

    public HashMap<Location, Color> getPlotBorderLocationMap(ArrayList<Chunk> renderChunks, KonPlayer player) {
        HashMap<Location, Color> locationMap = new HashMap<Location, Color>();
        int Y_MIN_LIMIT = player.getBukkitPlayer().getWorld().getMinHeight() + 1;
        int Y_MAX_LIMIT = player.getBukkitPlayer().getWorld().getMaxHeight() - 1;
        double X_MOD = 0.5;
        double Y_MOD = 1.0;
        double Y_MOD_SNOW = 1.1;
        double Z_MOD = 0.5;
        int[] sideLUTX = new int[]{0, 0, 1, -1};
        int[] sideLUTZ = new int[]{1, -1, 0, 0};
        int[] blockLUTXmin = new int[]{0, 0, 15, 0};
        int[] blockLUTXmax = new int[]{15, 15, 15, 0};
        int[] blockLUTZmin = new int[]{15, 0, 0, 0};
        int[] blockLUTZmax = new int[]{15, 0, 15, 15};
        for (Chunk chunk : renderChunks) {
            KonTerritory territory;
            World renderWorld;
            Point point = HelperUtil.toPoint(chunk);
            if (!this.isChunkClaimed(point, renderWorld = chunk.getWorld()) || !(territory = this.getChunkTerritory(point, renderWorld)).getKingdom().equals(player.getKingdom()) || !(territory instanceof KonTown) || !((KonTown)territory).hasPlot(point, renderWorld)) continue;
            KonTown town = (KonTown)territory;
            KonPlot chunkPlot = town.getPlot(point, renderWorld);
            Color renderColor = Color.ORANGE;
            if (chunkPlot != null && chunkPlot.hasUser(player.getOfflineBukkitPlayer())) {
                renderColor = Color.LIME;
            }
            for (int i = 0; i < 4; ++i) {
                Point sidePoint = new Point(point.x + sideLUTX[i], point.y + sideLUTZ[i]);
                boolean isClaimed = this.isChunkClaimed(sidePoint, renderWorld);
                boolean isPlot = town.hasPlot(sidePoint, renderWorld);
                if (isClaimed && isPlot && (chunkPlot == null || chunkPlot.equals(town.getPlot(sidePoint, renderWorld)))) continue;
                ChunkSnapshot chunkSnap = chunk.getChunkSnapshot(true, false, false);
                int y_max = 0;
                for (int x = blockLUTXmin[i]; x <= blockLUTXmax[i]; ++x) {
                    for (int z = blockLUTZmin[i]; z <= blockLUTZmax[i]; ++z) {
                        Snow snowBlock;
                        y_max = chunkSnap.getHighestBlockYAt(x, z);
                        y_max = Math.min(y_max, Y_MAX_LIMIT);
                        for (y_max = Math.max(y_max, Y_MIN_LIMIT); (chunk.getBlock(x, y_max, z).isPassable() || !chunk.getBlock(x, y_max, z).getType().isOccluding()) && y_max > Y_MIN_LIMIT; --y_max) {
                        }
                        while (chunk.getBlock(x, y_max + 1, z).isLiquid() && y_max < Y_MAX_LIMIT) {
                            ++y_max;
                        }
                        Block renderBlock = chunk.getBlock(x, y_max, z);
                        Block aboveBlock = chunk.getBlock(x, y_max + 1, z);
                        double y_mod = 1.0;
                        if (aboveBlock.getBlockData() instanceof Snow && (snowBlock = (Snow)aboveBlock.getBlockData()).getLayers() >= snowBlock.getMinimumLayers()) {
                            y_mod = 1.1;
                        }
                        Location renderLoc = new Location(renderBlock.getWorld(), renderBlock.getLocation().getX() + 0.5, renderBlock.getLocation().getY() + y_mod, renderBlock.getLocation().getZ() + 0.5);
                        locationMap.put(renderLoc, renderColor);
                    }
                }
            }
        }
        return locationMap;
    }

    public void updateTownDisplayBars(KonKingdom kingdom) {
        for (KonTown town : kingdom.getCapitalTowns()) {
            town.updateBarPlayers();
        }
    }

    public void updatePlayerBorderParticles(Location center) {
        if (center == null) {
            return;
        }
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        for (Entity nearbyEntity : world.getNearbyEntities(center, 64.0, 256.0, 64.0, e -> e instanceof Player)) {
            try {
                Player player = (Player)nearbyEntity;
                KonPlayer onlinePlayer = this.konquest.getPlayerManager().getPlayer(player);
                this.updatePlayerBorderParticles(onlinePlayer);
            }
            catch (Exception exception) {}
        }
    }

    public void updatePlayerBorderParticles(KonKingdom kingdom) {
        for (KonPlayer player : this.konquest.getPlayerManager().getPlayersInKingdom(kingdom)) {
            this.updatePlayerBorderParticles(player);
        }
    }

    public void updatePlayerBorderParticles(KonPlayer player) {
        this.updatePlayerBorderParticles(player, player.getBukkitPlayer().getLocation());
    }

    public void updatePlayerBorderParticles(KonPlayer player, Location loc) {
        if (player == null) {
            return;
        }
        if (player.isBorderDisplay()) {
            ArrayList<Chunk> nearbyChunks = HelperUtil.getAreaChunks(loc, 2);
            boolean isTerritoryNearby = false;
            for (Chunk chunk : nearbyChunks) {
                if (!this.isChunkClaimed(HelperUtil.toPoint(chunk), chunk.getWorld())) continue;
                isTerritoryNearby = true;
                break;
            }
            if (isTerritoryNearby) {
                Timer borderTimer = player.getBorderUpdateLoopTimer();
                borderTimer.stopTimer();
                borderTimer.setTime(1);
                HashMap<Location, Color> borderTerritoryMap = this.getBorderLocationMap(nearbyChunks, player);
                player.removeAllBorders();
                player.addTerritoryBorders(borderTerritoryMap);
                HashMap<Location, Color> plotBorderTerritoryMap = this.getPlotBorderLocationMap(nearbyChunks, player);
                player.removeAllPlotBorders();
                player.addTerritoryPlotBorders(plotBorderTerritoryMap);
                borderTimer.startLoopTimer(10);
            } else {
                this.stopPlayerBorderParticles(player);
            }
        } else {
            this.stopPlayerBorderParticles(player);
        }
    }

    public void stopPlayerBorderParticles(KonPlayer player) {
        Timer borderTimer = player.getBorderUpdateLoopTimer();
        if (borderTimer.isRunning()) {
            borderTimer.stopTimer();
        }
        player.removeAllBorders();
        player.removeAllPlotBorders();
    }

    public void printPlayerMap(KonPlayer player, int mapSize) {
        this.printPlayerMap(player, mapSize, player.getBukkitPlayer().getLocation());
    }

    /*
     * WARNING - void declaration
     */
    public void printPlayerMap(KonPlayer player, int mapSize, Location center) {
        String distStr;
        int searchDist;
        Player bukkitPlayer = player.getBukkitPlayer();
        Point originPoint = HelperUtil.toPoint(center);
        String mapWildSymbol = "-";
        String mapTownSymbol = "+";
        String mapCampSymbol = "=";
        String mapRuinSymbol = "%";
        String mapSanctuarySymbol = "$";
        String mapCapitalSymbol = "#";
        String[][] map = new String[mapSize][mapSize];
        BlockFace playerFace = bukkitPlayer.getFacing();
        String mapPlayer = "!";
        Object mapSymbolColor = String.valueOf(ChatColor.WHITE);
        Object playerColor = String.valueOf(ChatColor.WHITE);
        if (playerFace.equals((Object)BlockFace.NORTH)) {
            mapPlayer = "\u25b2";
        } else if (playerFace.equals((Object)BlockFace.EAST)) {
            mapPlayer = "\u25b6";
        } else if (playerFace.equals((Object)BlockFace.SOUTH)) {
            mapPlayer = "\u25bc";
        } else if (playerFace.equals((Object)BlockFace.WEST)) {
            mapPlayer = "\u25c0";
        }
        KonTerritory closestTerritory = null;
        boolean isLocValidSettle = true;
        int minDistance = Integer.MAX_VALUE;
        int proximity = Integer.MAX_VALUE;
        int min_distance_sanc = this.konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_SANCTUARY.getPath());
        int min_distance_town = this.konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
        if (!this.konquest.isWorldValid(center.getWorld())) {
            isLocValidSettle = false;
        }
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            searchDist = HelperUtil.chunkDistance(center, kingdom.getCapital().getCenterLoc());
            if (searchDist != -1) {
                if (searchDist < minDistance) {
                    minDistance = searchDist;
                    proximity = searchDist;
                    closestTerritory = kingdom.getCapital();
                }
                if (searchDist < min_distance_town) {
                    isLocValidSettle = false;
                }
            }
            for (KonTown konTown : kingdom.getTowns()) {
                searchDist = HelperUtil.chunkDistance(center, konTown.getCenterLoc());
                if (searchDist == -1) continue;
                if (searchDist < minDistance) {
                    minDistance = searchDist;
                    proximity = searchDist;
                    closestTerritory = konTown;
                }
                if (searchDist >= min_distance_town) continue;
                isLocValidSettle = false;
            }
        }
        for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
            searchDist = HelperUtil.chunkDistance(center, ruin.getCenterLoc());
            if (searchDist == -1) continue;
            if (searchDist < minDistance) {
                minDistance = searchDist;
                proximity = searchDist;
                closestTerritory = ruin;
            }
            if (searchDist >= min_distance_town) continue;
            isLocValidSettle = false;
        }
        for (KonSanctuary sanctuary : this.konquest.getSanctuaryManager().getSanctuaries()) {
            searchDist = HelperUtil.chunkDistance(center, sanctuary.getCenterLoc());
            if (searchDist == -1) continue;
            if (searchDist < minDistance) {
                minDistance = searchDist;
                proximity = searchDist;
                closestTerritory = sanctuary;
            }
            if (searchDist >= min_distance_sanc) continue;
            isLocValidSettle = false;
        }
        for (KonCamp camp : this.konquest.getCampManager().getCamps()) {
            searchDist = HelperUtil.chunkDistance(center, camp.getCenterLoc());
            if (searchDist == -1 || searchDist >= minDistance) continue;
            proximity = searchDist;
            closestTerritory = camp;
        }
        int max_distance_all = this.konquest.getCore().getInt(CorePath.TOWNS_MAX_DISTANCE_ALL.getPath());
        if (max_distance_all > 0 && closestTerritory != null && minDistance > max_distance_all) {
            isLocValidSettle = false;
        }
        int radius = this.konquest.getCore().getInt(CorePath.TOWNS_INIT_RADIUS.getPath());
        for (Point point : HelperUtil.getAreaPoints(center, radius)) {
            if (!this.isChunkClaimed(point, center.getWorld())) continue;
            isLocValidSettle = false;
        }
        Object settleTip = MessagePath.MENU_MAP_SETTLE_HINT.getMessage(new Object[0]);
        if (isLocValidSettle) {
            settleTip = String.valueOf(ChatColor.GOLD) + (String)settleTip;
        } else {
            settleTip = String.valueOf(ChatColor.STRIKETHROUGH) + (String)settleTip;
            settleTip = String.valueOf(ChatColor.GRAY) + (String)settleTip;
        }
        for (Point mapPoint : HelperUtil.getAreaPoints(center, (mapSize - 1) / 2 + 1)) {
            int diffOriginX = (int)(mapPoint.getX() - originPoint.getX());
            int diffOriginY = (int)(mapPoint.getY() - originPoint.getY());
            int mapY = (mapSize - 1) / 2 - diffOriginX;
            int mapX = (mapSize - 1) / 2 - diffOriginY;
            if (mapX < 0 || mapX >= mapSize) {
                ChatUtil.printDebug("Internal Error: Map X was " + mapX);
                return;
            }
            if (mapY < 0 || mapY >= mapSize) {
                ChatUtil.printDebug("Internal Error: Map Y was " + mapY);
                return;
            }
            if (this.isChunkClaimed(mapPoint, center.getWorld())) {
                KonTerritory territory = this.getChunkTerritory(mapPoint, center.getWorld());
                assert (territory != null);
                mapSymbolColor = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)player, territory);
                playerColor = this.konquest.getDisplayPrimaryColor((KonquestOfflinePlayer)player, territory);
                switch (territory.getTerritoryType()) {
                    case WILD: {
                        map[mapX][mapY] = String.valueOf(ChatColor.WHITE) + mapWildSymbol;
                        break;
                    }
                    case CAPITAL: {
                        map[mapX][mapY] = (String)mapSymbolColor + mapCapitalSymbol;
                        break;
                    }
                    case TOWN: {
                        map[mapX][mapY] = (String)mapSymbolColor + mapTownSymbol;
                        break;
                    }
                    case CAMP: {
                        map[mapX][mapY] = (String)mapSymbolColor + mapCampSymbol;
                        break;
                    }
                    case RUIN: {
                        map[mapX][mapY] = (String)mapSymbolColor + mapRuinSymbol;
                        break;
                    }
                    case SANCTUARY: {
                        map[mapX][mapY] = (String)mapSymbolColor + mapSanctuarySymbol;
                        break;
                    }
                    default: {
                        map[mapX][mapY] = String.valueOf(ChatColor.WHITE) + mapWildSymbol;
                        break;
                    }
                }
            } else {
                map[mapX][mapY] = String.valueOf(ChatColor.WHITE) + mapWildSymbol;
                playerColor = String.valueOf(ChatColor.GRAY);
            }
            if (mapX != (mapSize - 1) / 2 || mapY != (mapSize - 1) / 2) continue;
            map[mapX][mapY] = (String)playerColor + mapPlayer;
        }
        String string = String.valueOf(ChatColor.WHITE);
        int distance = 0;
        if (closestTerritory != null) {
            distance = proximity;
            String string2 = this.konquest.getDisplaySecondaryColor((KonquestOfflinePlayer)player, closestTerritory);
        }
        int maxDist = 99;
        if (max_distance_all > 0) {
            maxDist = max_distance_all;
        }
        if (distance > maxDist) {
            distStr = maxDist + "+";
            String string3 = String.valueOf(ChatColor.GRAY);
        } else {
            distStr = "" + distance;
        }
        String header = String.valueOf(ChatColor.GOLD) + MessagePath.MENU_MAP_CENTER.getMessage(new Object[0]) + ": " + (int)originPoint.getX() + "," + (int)originPoint.getY();
        ChatUtil.sendNotice((CommandSender)bukkitPlayer, header);
        String[] compassRose = new String[]{"   N  ", " W * E", "   S  "};
        for (int i = mapSize - 1; i >= 0; --i) {
            StringBuilder mapLine = new StringBuilder(String.valueOf(ChatColor.GOLD) + "|| ");
            for (int j = mapSize - 1; j >= 0; --j) {
                mapLine.append(map[i][j]).append(" ");
            }
            if (i <= mapSize - 1 && i >= mapSize - 3) {
                mapLine.append(ChatColor.GOLD).append(compassRose[mapSize - 1 - i]);
            }
            if (i == mapSize - 5) {
                mapLine.append(" ").append((String)settleTip);
            }
            if (i == mapSize - 7) {
                void var27_37;
                mapLine.append(" ").append((String)var27_37).append(MessagePath.MENU_MAP_PROXIMITY.getMessage(new Object[0])).append(": ").append(distStr);
            }
            ChatUtil.sendMessage((CommandSender)bukkitPlayer, mapLine.toString());
        }
    }
}

