/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.RandomWildLocationSearchTask;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import com.github.rumsfield.konquest.utility.TravelPlan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TravelManager
implements Timeable {
    private final Konquest konquest;
    private final HashMap<Player, TravelPlan> travelers;
    private final Timer travelExecutor;

    public TravelManager(Konquest konquest) {
        this.konquest = konquest;
        this.travelers = new HashMap();
        this.travelExecutor = new Timer(this);
        this.travelExecutor.stopTimer();
        this.travelExecutor.setTime(1);
        this.travelExecutor.startLoopTimer();
    }

    public void submitWildTravel(Player bukkitPlayer) {
        if (!this.konquest.isWorldValid(bukkitPlayer.getWorld())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
            return;
        }
        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TRAVEL_NOTICE_WILD_SEARCH.getMessage(new Object[0]));
        RandomWildLocationSearchTask task = new RandomWildLocationSearchTask(this.konquest, bukkitPlayer.getWorld(), location -> {
            if (location == null) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_TRAVEL_ERROR_WILD_TIMEOUT.getMessage(new Object[0]));
            } else {
                this.konquest.getTravelManager().submitTravel(bukkitPlayer, TravelDestination.WILD, null, (Location)location);
            }
        });
        task.runTaskTimer((Plugin)this.konquest.getPlugin(), 20L, 10L);
    }

    public boolean submitTravel(Player bukkitPlayer, TravelDestination destination, KonTerritory territory, Location travelLoc) {
        int chunkDistance;
        if (travelLoc == null) {
            return false;
        }
        if (this.konquest.getIntegrationManager().getWorldGuard().isEnabled()) {
            if (!this.konquest.getIntegrationManager().getWorldGuard().isLocationTravelExitAllowed(bukkitPlayer.getLocation(), bukkitPlayer)) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_TRAVEL_EXIT_DENY.getMessage(new Object[0]));
                return false;
            }
            if (!this.konquest.getIntegrationManager().getWorldGuard().isLocationTravelEnterAllowed(travelLoc, bukkitPlayer)) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_TRAVEL_ENTER_DENY.getMessage(new Object[0]));
                return false;
            }
        }
        boolean isGlobalEventTravel = this.konquest.getGlobalEventManager().isEffectValid(KonGlobalEventEffect.FREE_TRAVEL);
        boolean isTravelAlwaysAllowed = this.konquest.getCore().getBoolean(CorePath.FAVOR_ALLOW_TRAVEL_ALWAYS.getPath(), true);
        double cost = this.konquest.getCore().getDouble(CorePath.FAVOR_COST_TRAVEL.getPath(), 0.0);
        double cost_per_chunk = this.konquest.getCore().getDouble(CorePath.FAVOR_COST_TRAVEL_PER_CHUNK.getPath(), 0.0);
        double cost_world = this.konquest.getCore().getDouble(CorePath.FAVOR_COST_TRAVEL_WORLD.getPath(), 0.0);
        double cost_camp = this.konquest.getCore().getDouble(CorePath.FAVOR_COST_TRAVEL_CAMP.getPath(), 0.0);
        cost = cost < 0.0 ? 0.0 : cost;
        cost_per_chunk = cost_per_chunk < 0.0 ? 0.0 : cost_per_chunk;
        double d = cost_camp = cost_camp < 0.0 ? 0.0 : cost_camp;
        double total_cost = destination.equals((Object)TravelDestination.CAMP) ? cost_camp : ((chunkDistance = HelperUtil.chunkDistance(travelLoc, bukkitPlayer.getLocation())) >= 0 ? cost + cost_per_chunk * (double)chunkDistance : cost + cost_world);
        if (!isGlobalEventTravel && !isTravelAlwaysAllowed && total_cost > 0.0 && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < total_cost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(total_cost));
            return false;
        }
        if (isTravelAlwaysAllowed && KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < total_cost) {
            total_cost = 0.0;
        } else if (isGlobalEventTravel) {
            total_cost = 0.0;
        }
        Location travelLocAng = travelLoc;
        if (!destination.equals((Object)TravelDestination.SANCTUARY)) {
            Location pLoc = bukkitPlayer.getLocation();
            travelLocAng = new Location(travelLoc.getWorld(), travelLoc.getX(), travelLoc.getY(), travelLoc.getZ(), pLoc.getYaw(), pLoc.getPitch());
        }
        int warmupSeconds = this.konquest.getCore().getInt(CorePath.TRAVEL_WARMUP.getPath(), 0);
        warmupSeconds = Math.max(warmupSeconds, 0);
        if (isGlobalEventTravel) {
            warmupSeconds = 0;
        }
        if (warmupSeconds > 0) {
            String warmupTimeStr = "" + warmupSeconds;
            ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TRAVEL_NOTICE_WARMUP.getMessage(warmupTimeStr));
        }
        if (warmupSeconds > 0) {
            Date now = new Date();
            long warmupFinishTime = now.getTime() + (long)warmupSeconds * 1000L;
            this.travelers.put(bukkitPlayer, new TravelPlan(bukkitPlayer, destination, territory, travelLocAng, warmupFinishTime, total_cost));
            ChatUtil.printDebug("Submitted new travel plan for " + bukkitPlayer.getName() + ": now " + now.getTime() + " to " + warmupFinishTime + ", size " + this.travelers.size());
        } else {
            this.executeTravel(bukkitPlayer, destination, territory, travelLocAng, total_cost);
        }
        return true;
    }

    public boolean cancelTravel(Player bukkitPlayer) {
        boolean result = false;
        if (this.travelers.containsKey(bukkitPlayer)) {
            this.travelers.remove(bukkitPlayer);
            result = true;
        }
        return result;
    }

    private void executeTravel(Player bukkitPlayer, TravelDestination destination, KonTerritory territory, Location travelLoc, double cost) {
        KonPlayer player;
        String territoryName = territory == null ? "null" : territory.getName();
        ChatUtil.printDebug("Executing travel for " + bukkitPlayer.getName() + " to " + destination.toString() + " " + territoryName);
        this.konquest.telePlayerLocation(bukkitPlayer, travelLoc);
        switch (destination.ordinal()) {
            case 4: {
                if (!(territory instanceof KonTown)) break;
                KonTown town = (KonTown)territory;
                town.addPlayerTravelCooldown(bukkitPlayer.getUniqueId());
                if (town.isAttacked() && town.addDefender(bukkitPlayer)) {
                    ChatUtil.printDebug("Raid defense rewarded to player " + bukkitPlayer.getName());
                    int defendReward = this.konquest.getCore().getInt(CorePath.FAVOR_REWARDS_DEFEND_RAID.getPath());
                    KonquestPlugin.depositPlayer((OfflinePlayer)bukkitPlayer, defendReward);
                }
                for (OfflinePlayer resident : town.getPlayerResidents()) {
                    if (!resident.isOnline() || !town.isPlayerLord(resident) && !town.isPlayerKnight(resident) || resident.getUniqueId().equals(bukkitPlayer.getUniqueId())) continue;
                    ChatUtil.sendNotice((CommandSender)((Player)resident), MessagePath.COMMAND_TRAVEL_NOTICE_TOWN_TRAVEL.getMessage(bukkitPlayer.getName(), town.getName()));
                }
                break;
            }
            case 5: {
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_TRAVEL_NOTICE_WILD_TRAVEL.getMessage(new Object[0]));
                break;
            }
        }
        if (KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, cost) && (player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer)) != null) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, (int)cost);
        }
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Travel Executor Timer ended with null taskID!");
        } else if (taskID == this.travelExecutor.getTaskID()) {
            ArrayList<Player> expiredTravelers = new ArrayList<Player>();
            ArrayList<TravelPlan> expiredPlans = new ArrayList<TravelPlan>();
            Iterator<Object> iterator = this.travelers.keySet().iterator();
            while (iterator.hasNext()) {
                Date now = new Date();
                Player traveler = iterator.next();
                if (!now.after(new Date(this.travelers.get(traveler).getWarmupEndTime()))) continue;
                ChatUtil.printDebug("Found ready traveler " + traveler.getName() + ", " + now.getTime() + " is after " + this.travelers.get(traveler).getWarmupEndTime());
                expiredTravelers.add(traveler);
                expiredPlans.add(this.travelers.get(traveler));
            }
            for (Player traveler : expiredTravelers) {
                this.travelers.remove(traveler);
            }
            for (TravelPlan plan : expiredPlans) {
                this.executeTravel(plan.getTraveler(), plan.getDestination(), plan.getTerritory(), plan.getLocation(), plan.getCost());
            }
        }
    }

    public static enum TravelDestination {
        SANCTUARY,
        CAPITAL,
        CAMP,
        HOME,
        TOWN,
        WILD,
        OTHER;

    }
}

