/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.manager;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.manager.KonquestUpgradeManager;
import com.github.rumsfield.konquest.api.model.KonquestTown;
import com.github.rumsfield.konquest.api.model.KonquestUpgrade;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class UpgradeManager
implements KonquestUpgradeManager {
    private final Konquest konquest;
    private final HashMap<KonUpgrade, List<Integer>> upgradeCosts;
    private final HashMap<KonUpgrade, List<Integer>> upgradePopulations;
    private boolean isEnabled;

    public UpgradeManager(Konquest konquest) {
        this.konquest = konquest;
        this.upgradeCosts = new HashMap();
        this.upgradePopulations = new HashMap();
        this.isEnabled = false;
    }

    public void initialize() {
        if (!this.loadUpgrades()) {
            this.konquest.getConfigManager().overwriteBadConfig("upgrades");
            this.konquest.getConfigManager().updateConfigVersion("upgrades");
            if (!this.loadUpgrades()) {
                ChatUtil.printConsoleError("Failed to load bad upgrades from upgrades.yml. Try deleting all upgrades files and re-starting the server.");
            }
        }
        this.isEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_ENABLE_UPGRADES.getPath(), false);
        ChatUtil.printDebug("Upgrade Manager is ready, enabled " + this.isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    private boolean loadUpgrades() {
        this.upgradeCosts.clear();
        this.upgradePopulations.clear();
        FileConfiguration upgradesConfig = this.konquest.getConfigManager().getConfig("upgrades");
        if (upgradesConfig.get("upgrades") == null) {
            ChatUtil.printDebug("There is no upgrades section in upgrades.yml");
            return false;
        }
        boolean status = true;
        for (String upgradeName : upgradesConfig.getConfigurationSection("upgrades").getKeys(false)) {
            KonUpgrade upgrade = KonUpgrade.getUpgrade(upgradeName);
            if (upgrade != null) {
                ConfigurationSection upgradeSection = upgradesConfig.getConfigurationSection("upgrades." + upgradeName);
                List costList = new ArrayList();
                List popList = new ArrayList();
                assert (upgradeSection != null);
                if (upgradeSection.contains("costs")) {
                    costList = upgradeSection.getIntegerList("costs");
                } else {
                    ChatUtil.printDebug("Upgrades.yml is missing costs section for: " + upgradeName);
                    status = false;
                }
                if (upgradeSection.contains("populations")) {
                    popList = upgradeSection.getIntegerList("populations");
                } else {
                    ChatUtil.printDebug("Upgrades.yml is missing populations section for: " + upgradeName);
                    status = false;
                }
                if (costList.size() == upgrade.getMaxLevel() && popList.size() == upgrade.getMaxLevel()) {
                    this.upgradeCosts.put(upgrade, costList);
                    this.upgradePopulations.put(upgrade, popList);
                    continue;
                }
                ChatUtil.printDebug("Upgrades.yml has the wrong number of costs/populations for " + upgradeName + ", has " + costList.size() + " costs and " + popList.size() + " populations, but expected " + upgrade.getMaxLevel());
                status = false;
                continue;
            }
            ChatUtil.printDebug("Upgrades.yml contains bad upgrade name: " + upgradeName);
            status = false;
        }
        return status;
    }

    @Override
    public List<KonquestUpgrade> getAllUpgrades() {
        return new ArrayList<KonquestUpgrade>(Arrays.asList(KonUpgrade.values()));
    }

    @Override
    public HashMap<KonquestUpgrade, Integer> getAvailableUpgrades(KonquestTown townArg) {
        HashMap<KonquestUpgrade, Integer> result = new HashMap<KonquestUpgrade, Integer>();
        if (!(townArg instanceof KonTown)) {
            return result;
        }
        KonTown town = (KonTown)townArg;
        for (KonUpgrade upgrade : KonUpgrade.values()) {
            int currentLevel = town.getRawUpgradeLevel(upgrade);
            int nextLevel = currentLevel + 1;
            int nextCost = this.getUpgradeCost(upgrade, nextLevel);
            if (nextCost < 0 || nextLevel > upgrade.getMaxLevel()) continue;
            result.put(upgrade, nextLevel);
        }
        return result;
    }

    @Override
    public int getUpgradeCost(KonquestUpgrade upgrade, int level) {
        int result = -1;
        if (level > 0 && level <= upgrade.getMaxLevel() && this.upgradeCosts.containsKey(upgrade)) {
            result = this.upgradeCosts.get(upgrade).get(level - 1);
        }
        return result;
    }

    @Override
    public int getUpgradePopulation(KonquestUpgrade upgrade, int level) {
        int result = 0;
        if (level > 0 && level <= upgrade.getMaxLevel() && this.upgradePopulations.containsKey(upgrade)) {
            result = this.upgradePopulations.get(upgrade).get(level - 1);
        }
        return result;
    }

    public boolean addTownUpgrade(KonTown town, KonUpgrade upgrade, int level, Player bukkitPlayer) {
        int requiredPopulation;
        if (!this.isEnabled) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        if (town.hasPropertyValue(KonPropertyFlag.UPGRADE) && !town.getPropertyValue(KonPropertyFlag.UPGRADE)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return false;
        }
        boolean isAttackCheckEnabled = this.konquest.getCore().getBoolean(CorePath.TOWNS_UPGRADE_WHILE_ATTACKED.getPath(), false);
        if (!isAttackCheckEnabled && town.isAttacked()) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_UPGRADE_FAIL_ATTACK.getMessage(new Object[0]));
            return false;
        }
        int currentLevel = town.getUpgradeLevel(upgrade);
        if (level < 1 || level > upgrade.getMaxLevel() || level != currentLevel + 1) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_UPGRADE_FAIL_LEVEL.getMessage(upgrade.getName(), level, currentLevel));
            return false;
        }
        int currentPopulation = town.getNumResidents();
        if (currentPopulation < (requiredPopulation = this.upgradePopulations.get(upgrade).get(level - 1).intValue())) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_UPGRADE_FAIL_POPULATION.getMessage(upgrade.getName(), level, requiredPopulation));
            return false;
        }
        int requiredCost = this.upgradeCosts.get(upgrade).get(level - 1);
        if (KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer) < (double)requiredCost) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.MENU_UPGRADE_FAIL_COST.getMessage(upgrade.getName(), level, requiredCost));
            return false;
        }
        town.addUpgrade(upgrade, level);
        if (upgrade.equals(KonUpgrade.HEALTH)) {
            this.konquest.getKingdomManager().refreshTownHearts(town);
        }
        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.MENU_UPGRADE_ADD.getMessage(upgrade.getName(), level, town.getName()));
        ChatUtil.printDebug("Applied new upgrade " + upgrade.getName() + " level " + level + " to town " + town.getName());
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (KonquestPlugin.withdrawPlayer((OfflinePlayer)bukkitPlayer, requiredCost) && player != null) {
            this.konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.FAVOR, requiredCost);
        }
        return true;
    }

    @Override
    public boolean applyTownUpgrade(KonquestTown townArg, KonquestUpgrade upgrade, int level) {
        if (!this.isEnabled) {
            return false;
        }
        if (level < 0 || level > upgrade.getMaxLevel()) {
            return false;
        }
        if (!(townArg instanceof KonTown)) {
            return false;
        }
        KonTown town = (KonTown)townArg;
        town.addUpgrade(upgrade, level);
        if (upgrade.equals(KonUpgrade.HEALTH)) {
            this.konquest.getKingdomManager().refreshTownHearts(town);
        }
        ChatUtil.printDebug("Applied upgrade " + upgrade.getName() + " level " + level + " to town " + town.getName());
        this.updateTownDisabledUpgrades(town);
        return true;
    }

    @Override
    public int getTownUpgradeLevel(KonquestTown townArg, KonquestUpgrade upgrade) {
        int result = 0;
        if (this.isEnabled && townArg instanceof KonTown) {
            KonTown town = (KonTown)townArg;
            result = town.getUpgradeLevel(upgrade);
        }
        return result;
    }

    public void updateTownDisabledUpgrades(KonTown town) {
        for (KonUpgrade upgrade : KonUpgrade.values()) {
            int level = town.getRawUpgradeLevel(upgrade);
            if (level <= 0) continue;
            if (this.isEnabled) {
                int cost = this.getUpgradeCost(upgrade, level);
                if (cost >= 0) {
                    int townPop = town.getPlayerResidents().size();
                    if (townPop < this.upgradePopulations.get(upgrade).get(level - 1)) {
                        int newLevel;
                        for (newLevel = level; newLevel > 0 && townPop < this.upgradePopulations.get(upgrade).get(newLevel - 1); --newLevel) {
                        }
                        town.disableUpgrade(upgrade, newLevel);
                        ChatUtil.printDebug("UPGRADE: Disabled upgrade " + upgrade.getName() + " from level " + level + " to " + newLevel + " for town " + town.getName());
                        continue;
                    }
                    boolean status = town.allowUpgrade(upgrade);
                    if (status) {
                        ChatUtil.printDebug("UPGRADE: Successfully allowed upgrade " + upgrade.getName() + " level " + level + " for town " + town.getName());
                        continue;
                    }
                    ChatUtil.printDebug("UPGRADE: No change to upgrade " + upgrade.getName() + " level " + level + " for town " + town.getName());
                    continue;
                }
                town.disableUpgrade(upgrade, 0);
                ChatUtil.printDebug("UPGRADE: Disabled invalid upgrade " + upgrade.getName() + " to level 0 for town " + town.getName() + ", cost is " + cost);
                continue;
            }
            town.disableUpgrade(upgrade, 0);
            ChatUtil.printDebug("UPGRADE: Disabled unused upgrade " + upgrade.getName() + " to level 0 for town " + town.getName());
        }
    }
}

