/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.map;

import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;

public class AreaTerritory {
    private final Set<Point> areaPoints;
    private final List<double[]> xPoints;
    private final List<double[]> zPoints;
    private final List<double[]> xContours;
    private final List<double[]> zContours;
    private final String worldName;
    private final Location center;
    private final KonTerritory territory;

    public AreaTerritory(KonTerritory territory) {
        this.territory = territory;
        this.worldName = territory.getWorld().getName();
        this.areaPoints = territory.getChunkList().keySet();
        this.center = territory.getCenterLoc();
        this.xPoints = new ArrayList<double[]>();
        this.zPoints = new ArrayList<double[]>();
        this.xContours = new ArrayList<double[]>();
        this.zContours = new ArrayList<double[]>();
        this.calculateCorners();
    }

    private void calculateCorners() {
        double[] z;
        double[] x;
        ArrayList<Coord> cornerList = new ArrayList<Coord>();
        int[] cornerLUTX = new int[]{1, 1, -1, -1};
        int[] cornerLUTZ = new int[]{1, -1, -1, 1};
        int[] offsetLUTX = new int[]{16, 16, 0, 0};
        int[] offsetLUTZ = new int[]{16, 0, 0, 16};
        FaceDirection[] dirLUT = new FaceDirection[]{FaceDirection.NE, FaceDirection.SE, FaceDirection.SW, FaceDirection.NW};
        for (Point p : this.areaPoints) {
            for (int i = 0; i < 4; ++i) {
                boolean adj1 = this.areaPoints.contains(new Point(p.x, p.y + cornerLUTZ[i]));
                boolean adj2 = this.areaPoints.contains(new Point(p.x + cornerLUTX[i], p.y));
                boolean opp = this.areaPoints.contains(new Point(p.x + cornerLUTX[i], p.y + cornerLUTZ[i]));
                if (adj1 && adj2 && !opp) {
                    cornerList.add(new Coord(p.x * 16 + offsetLUTX[i], p.y * 16 + offsetLUTZ[i], false, dirLUT[i]));
                    continue;
                }
                if (adj1 || adj2) continue;
                cornerList.add(new Coord(p.x * 16 + offsetLUTX[i], p.y * 16 + offsetLUTZ[i], true, dirLUT[i]));
            }
        }
        List<List<Coord>> allContours = this.sortedCoords(cornerList);
        for (List<Coord> contour : allContours) {
            x = new double[contour.size()];
            z = new double[contour.size()];
            for (int i = 0; i < contour.size(); ++i) {
                x[i] = contour.get((int)i).x;
                z[i] = contour.get((int)i).z;
            }
            this.xContours.add(x);
            this.zContours.add(z);
        }
        for (Point p : this.areaPoints) {
            x = new double[]{p.x * 16, p.x * 16 + 16};
            z = new double[]{p.y * 16, p.y * 16 + 16};
            this.xPoints.add(x);
            this.zPoints.add(z);
        }
    }

    public int getNumContours() {
        return this.xContours.size();
    }

    public double[] getXContour(int n) {
        return this.xContours.get(n);
    }

    public double[] getZContour(int n) {
        return this.zContours.get(n);
    }

    public int getNumPoints() {
        return this.xPoints.size();
    }

    public double[] getXPoint(int n) {
        return this.xPoints.get(n);
    }

    public double[] getZPoint(int n) {
        return this.zPoints.get(n);
    }

    public String getWorldName() {
        return this.worldName;
    }

    public double getCenterX() {
        return this.center.getX();
    }

    public double getCenterY() {
        return this.center.getY();
    }

    public double getCenterZ() {
        return this.center.getZ();
    }

    public KonTerritory getTerritory() {
        return this.territory;
    }

    private List<List<Coord>> sortedCoords(List<Coord> coords) {
        int timeout;
        ArrayList<List<Coord>> sortedList = new ArrayList<List<Coord>>();
        ArrayList<Coord> remainingCorners = new ArrayList<Coord>(coords);
        for (timeout = 9001; !remainingCorners.isEmpty() && timeout > 0; --timeout) {
            ArrayList<Coord> contour = new ArrayList<Coord>();
            Coord current = (Coord)remainingCorners.get(0);
            for (Coord c : remainingCorners) {
                if (c.x <= current.x) continue;
                current = c;
            }
            remainingCorners.remove(current);
            contour.add(current);
            boolean isSearchSuccessful = true;
            while (contour.size() < coords.size() && isSearchSuccessful) {
                Coord candidate = null;
                block15: for (Coord c : remainingCorners) {
                    if (current.isConvex) {
                        switch (current.face.ordinal()) {
                            case 0: {
                                if (current.x != c.x || current.z <= c.z || candidate != null && c.z <= candidate.z) continue block15;
                                candidate = c;
                                continue block15;
                            }
                            case 1: {
                                if (current.z != c.z || current.x <= c.x || candidate != null && c.x <= candidate.x) continue block15;
                                candidate = c;
                                continue block15;
                            }
                            case 2: {
                                if (current.x != c.x || current.z >= c.z || candidate != null && c.z >= candidate.z) continue block15;
                                candidate = c;
                                continue block15;
                            }
                            case 3: {
                                if (current.z != c.z || current.x >= c.x || candidate != null && c.x >= candidate.x) continue block15;
                                candidate = c;
                                continue block15;
                            }
                        }
                        continue;
                    }
                    switch (current.face.ordinal()) {
                        case 0: {
                            if (current.z != c.z || current.x >= c.x || candidate != null && c.x >= candidate.x) break;
                            candidate = c;
                            break;
                        }
                        case 1: {
                            if (current.x != c.x || current.z <= c.z || candidate != null && c.z <= candidate.z) break;
                            candidate = c;
                            break;
                        }
                        case 2: {
                            if (current.z != c.z || current.x <= c.x || candidate != null && c.x <= candidate.x) break;
                            candidate = c;
                            break;
                        }
                        case 3: {
                            if (current.x != c.x || current.z >= c.z || candidate != null && c.z >= candidate.z) break;
                            candidate = c;
                            break;
                        }
                    }
                }
                if (candidate != null) {
                    remainingCorners.remove(candidate);
                    contour.add(candidate);
                    current = candidate;
                    continue;
                }
                isSearchSuccessful = false;
            }
            if (!contour.isEmpty()) {
                sortedList.add(contour);
                continue;
            }
            ChatUtil.printDebug("Failed to add empty contour!");
        }
        if (timeout == 0) {
            ChatUtil.printDebug("Contour search timed out!");
        }
        return sortedList;
    }

    private static enum FaceDirection {
        NE,
        SE,
        SW,
        NW;

    }

    private static class Coord {
        int x;
        int z;
        boolean isConvex;
        FaceDirection face;

        Coord(int x, int z, boolean isConvex, FaceDirection face) {
            this.x = x;
            this.z = z;
            this.isConvex = isConvex;
            this.face = face;
        }

        public String toString() {
            return String.format("{%d,%d,%s,%s}", this.x, this.z, this.isConvex, this.face.toString());
        }
    }
}

