/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.map;

import com.flowpowered.math.vector.Vector2d;
import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.map.AreaTerritory;
import com.github.rumsfield.konquest.map.MapHandler;
import com.github.rumsfield.konquest.map.Renderable;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.DetailMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.Objects;

public class BlueMapRender
implements Renderable {
    private final Konquest konquest;
    private boolean isEnabled;
    private static BlueMapAPI bapi = null;

    public BlueMapRender(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
    }

    @Override
    public void initialize() {
        boolean isReady = this.konquest.getIntegrationManager().getBlueMap().isReady();
        boolean bl = this.isEnabled = isReady && this.konquest.getIntegrationManager().getBlueMap().isEnabled();
        if (this.isEnabled) {
            bapi = this.konquest.getIntegrationManager().getBlueMap().getAPI();
            if (bapi == null) {
                this.isEnabled = false;
                ChatUtil.printDebug("Failed to initialize BlueMapRender with null API reference.");
            }
        } else {
            ChatUtil.printDebug("Failed to initialize BlueMapRender with disabled API.");
        }
    }

    @Override
    public String getMapName() {
        return this.konquest.getIntegrationManager().getBlueMap().getPluginName();
    }

    @Override
    public void drawUpdate(AreaTerritory area) {
        BlueMapWorld world;
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        float areaY = (float)territory.getCenterLoc().getY();
        String groupId = this.getGroupId(territory);
        String areaId = this.getAreaId(territory);
        String groupLabel = MapHandler.getGroupLabel(territory);
        String areaLabel = MapHandler.getIconLabel(territory);
        String areaDetail = MapHandler.getAreaLabel(territory, false);
        Color areaColor = this.getAreaColor(territory);
        Color lineColor = this.getLineColor(territory);
        MarkerSet territoryGroup = null;
        if (bapi.getWorld((Object)territory.getWorld()).isPresent() && !(world = (BlueMapWorld)bapi.getWorld((Object)territory.getWorld()).get()).getMaps().isEmpty() && world.getMaps().iterator().hasNext()) {
            territoryGroup = (MarkerSet)((BlueMapMap)world.getMaps().iterator().next()).getMarkerSets().get(groupId);
        }
        if (territoryGroup == null) {
            territoryGroup = MarkerSet.builder().label(groupLabel).toggleable(Boolean.valueOf(true)).build();
        }
        ShapeMarker.Builder areaBuilder = ((ShapeMarker.Builder)ShapeMarker.builder().label(areaLabel)).fillColor(areaColor).lineColor(lineColor);
        for (int i = 0; i < area.getNumContours(); ++i) {
            double[] xPoints = area.getXContour(i);
            double[] zPoints = area.getZContour(i);
            Shape.Builder shapeBuilder = Shape.builder();
            for (int c = 0; c < xPoints.length; ++c) {
                Vector2d point = new Vector2d(xPoints[c], zPoints[c]);
                shapeBuilder.addPoint(point);
            }
            if (i == 0) {
                areaBuilder.shape(shapeBuilder.build(), areaY);
                continue;
            }
            areaBuilder.holes(new Shape[]{shapeBuilder.build()});
        }
        areaBuilder.centerPosition();
        areaBuilder.depthTestEnabled(false);
        areaBuilder.detail(areaDetail);
        territoryGroup.put(areaId, (Marker)areaBuilder.build());
        if (bapi.getWorld((Object)territory.getWorld()).isPresent()) {
            BlueMapWorld world2 = (BlueMapWorld)bapi.getWorld((Object)territory.getWorld()).get();
            for (BlueMapMap map : world2.getMaps()) {
                map.getMarkerSets().put(groupId, territoryGroup);
            }
        }
    }

    @Override
    public void drawRemove(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        String groupId = this.getGroupId(territory);
        String areaId = this.getAreaId(territory);
        if (bapi.getWorld((Object)territory.getWorld()).isPresent()) {
            BlueMapWorld world = (BlueMapWorld)bapi.getWorld((Object)territory.getWorld()).get();
            for (BlueMapMap map : world.getMaps()) {
                if (map.getMarkerSets().containsKey(groupId)) {
                    ((MarkerSet)map.getMarkerSets().get(groupId)).remove(areaId);
                    if (!((MarkerSet)map.getMarkerSets().get(groupId)).getMarkers().isEmpty()) continue;
                    map.getMarkerSets().remove(groupId);
                    continue;
                }
                ChatUtil.printDebug("Failed to erase from missing BlueMap group, territory " + territory.getName());
            }
        }
    }

    @Override
    public void drawLabel(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        String groupId = this.getGroupId(territory);
        String areaId = this.getAreaId(territory);
        String areaDetail = MapHandler.getAreaLabel(territory, false);
        if (bapi.getWorld((Object)territory.getWorld()).isPresent()) {
            BlueMapWorld world = (BlueMapWorld)bapi.getWorld((Object)territory.getWorld()).get();
            for (BlueMapMap map : world.getMaps()) {
                if (!map.getMarkerSets().containsKey(groupId)) {
                    ChatUtil.printDebug("Failed to set detail of missing group, BlueMap territory " + territory.getName());
                    continue;
                }
                MarkerSet territoryGroup = (MarkerSet)map.getMarkerSets().get(groupId);
                if (!territoryGroup.getMarkers().containsKey(areaId)) {
                    ChatUtil.printDebug("Failed to set detail of missing area, BlueMap territory " + territory.getName());
                    continue;
                }
                Marker detailLabel = territoryGroup.get(areaId);
                if (detailLabel instanceof DetailMarker) {
                    ((DetailMarker)detailLabel).setDetail(areaDetail);
                    continue;
                }
                ChatUtil.printDebug("Failed to set detail of wrong marker type, BlueMap territory " + territory.getName());
            }
        }
    }

    @Override
    public void postBroadcast(String message) {
    }

    private String getGroupId(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".marker.sanctuary";
                break;
            }
            case RUIN: {
                result = (String)result + ".marker.ruin";
                break;
            }
            case CAMP: {
                result = (String)result + ".marker.camp";
                break;
            }
            case CAPITAL: 
            case TOWN: {
                result = (String)result + ".marker.kingdom";
                break;
            }
        }
        return result;
    }

    private String getAreaId(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".area.sanctuary." + territory.getName().toLowerCase();
                break;
            }
            case RUIN: {
                result = (String)result + ".area.ruin." + territory.getName().toLowerCase();
                break;
            }
            case CAMP: {
                result = (String)result + ".area.camp." + territory.getName().toLowerCase();
                break;
            }
            case CAPITAL: {
                result = (String)result + ".area.kingdom." + territory.getKingdom().getName().toLowerCase() + ".capital";
                break;
            }
            case TOWN: {
                result = (String)result + ".area.kingdom." + territory.getKingdom().getName().toLowerCase() + "." + territory.getName().toLowerCase();
                break;
            }
        }
        return result;
    }

    private Color getAreaColor(KonTerritory territory) {
        Color result = new Color(0xFFFFFF, 128);
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = new Color(0x646464, 128);
                break;
            }
            case RUIN: {
                result = new Color(0x242424, 128);
                break;
            }
            case CAMP: {
                result = new Color(10723594, 128);
                break;
            }
            case CAPITAL: 
            case TOWN: {
                result = new Color(MapHandler.getWebColor(territory), 128);
                break;
            }
        }
        return result;
    }

    private Color getLineColor(KonTerritory territory) {
        Color result = new Color(0, 255);
        if (Objects.requireNonNull(territory.getTerritoryType()) == KonquestTerritoryType.CAPITAL) {
            result = new Color(8392912, 255);
        }
        return result;
    }
}

