/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.map;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.map.AreaTerritory;
import com.github.rumsfield.konquest.map.MapHandler;
import com.github.rumsfield.konquest.map.Renderable;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

public class DynmapRender
implements Renderable {
    private final Konquest konquest;
    private boolean isEnabled;
    private static DynmapAPI dapi = null;
    private final HashMap<KonTerritory, ArrayList<String>> areaCache;

    public DynmapRender(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
        this.areaCache = new HashMap();
    }

    @Override
    public void initialize() {
        this.isEnabled = this.konquest.getIntegrationManager().getDynmap().isEnabled();
        if (this.isEnabled) {
            dapi = this.konquest.getIntegrationManager().getDynmap().getAPI();
        } else {
            ChatUtil.printDebug("Failed to initialize DynmapRender with disabled API.");
        }
    }

    @Override
    public String getMapName() {
        return this.konquest.getIntegrationManager().getDynmap().getPluginName();
    }

    @Override
    public void drawUpdate(AreaTerritory area) {
        int i;
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        String groupId = this.getGroupId(territory);
        String groupLabel = MapHandler.getGroupLabel(territory);
        String areaId = this.getAreaId(territory);
        String areaLabel = MapHandler.getAreaLabel(territory, true);
        int areaColor = this.getAreaColor(territory);
        int lineColor = this.getLineColor(territory);
        String iconId = this.getIconId(territory);
        String iconLabel = MapHandler.getIconLabel(territory);
        MarkerIcon icon = this.getIconMarker(territory);
        MarkerSet territoryGroup = dapi.getMarkerAPI().getMarkerSet(groupId);
        if (territoryGroup == null) {
            territoryGroup = dapi.getMarkerAPI().createMarkerSet(groupId, groupLabel, dapi.getMarkerAPI().getMarkerIcons(), false);
        }
        if (this.areaCache.containsKey(territory)) {
            for (String previousAreaId : this.areaCache.get(territory)) {
                AreaMarker areaMarker = territoryGroup.findAreaMarker(previousAreaId);
                if (areaMarker == null) continue;
                areaMarker.deleteMarker();
            }
            ChatUtil.printDebug("Cleared previously rendered Dynmap territory " + territory.getName());
        }
        ArrayList<CallSite> areaIdList = new ArrayList<CallSite>();
        for (i = 0; i < area.getNumContours(); ++i) {
            String contourId = areaId + ".contour." + i;
            AreaMarker areaContour = territoryGroup.findAreaMarker(contourId);
            if (areaContour == null) {
                areaContour = territoryGroup.createAreaMarker(contourId, "", false, area.getWorldName(), area.getXContour(i), area.getZContour(i), false);
                if (areaContour != null) {
                    areaContour.setFillStyle(0.0, areaColor);
                    areaContour.setLineStyle(1, 1.0, lineColor);
                }
            } else {
                areaContour.setCornerLocations(area.getXContour(i), area.getZContour(i));
                areaContour.setFillStyle(0.0, areaColor);
            }
            areaIdList.add((CallSite)((Object)contourId));
        }
        for (i = 0; i < area.getNumPoints(); ++i) {
            String pointId = areaId + ".point." + i;
            AreaMarker areaPoint = territoryGroup.findAreaMarker(pointId);
            if (areaPoint == null) {
                areaPoint = territoryGroup.createAreaMarker(pointId, areaLabel, true, area.getWorldName(), area.getXPoint(i), area.getZPoint(i), false);
                if (areaPoint != null) {
                    areaPoint.setFillStyle(0.5, areaColor);
                    areaPoint.setLineStyle(0, 0.0, lineColor);
                    areaPoint.setLabel(areaLabel, true);
                }
            } else {
                areaPoint.setCornerLocations(area.getXPoint(i), area.getZPoint(i));
                areaPoint.setLabel(areaLabel, true);
                areaPoint.setFillStyle(0.5, areaColor);
            }
            areaIdList.add((CallSite)((Object)pointId));
        }
        this.areaCache.put(territory, areaIdList);
        ChatUtil.printDebug("Updated Dynmap territory " + territory.getName());
        Marker territoryIcon = territoryGroup.findMarker(iconId);
        if (territoryIcon == null) {
            territoryGroup.createMarker(iconId, iconLabel, true, area.getWorldName(), area.getCenterX(), area.getCenterY(), area.getCenterZ(), icon, false);
        } else {
            territoryIcon.setLabel(iconLabel);
        }
    }

    @Override
    public void drawRemove(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        String groupId = this.getGroupId(territory);
        String iconId = this.getIconId(territory);
        MarkerSet territoryGroup = dapi.getMarkerAPI().getMarkerSet(groupId);
        if (territoryGroup != null) {
            if (this.areaCache.containsKey(territory)) {
                for (String previousAreaId : this.areaCache.get(territory)) {
                    AreaMarker areaMarker = territoryGroup.findAreaMarker(previousAreaId);
                    if (areaMarker == null) continue;
                    areaMarker.deleteMarker();
                }
            } else {
                ChatUtil.printDebug("Failed to erase un-rendered Dynmap territory " + territory.getName());
            }
            Marker territoryIcon = territoryGroup.findMarker(iconId);
            if (territoryIcon != null) {
                territoryIcon.deleteMarker();
            }
            if (territoryGroup.getAreaMarkers().isEmpty()) {
                territoryGroup.deleteMarkerSet();
            }
        }
    }

    @Override
    public void drawLabel(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        String groupId = this.getGroupId(territory);
        String areaLabel = MapHandler.getAreaLabel(territory, true);
        MarkerSet territoryGroup = dapi.getMarkerAPI().getMarkerSet(groupId);
        if (territoryGroup != null) {
            if (this.areaCache.containsKey(territory)) {
                for (String previousAreaId : this.areaCache.get(territory)) {
                    AreaMarker areaMarker = territoryGroup.findAreaMarker(previousAreaId);
                    if (areaMarker == null) continue;
                    areaMarker.setLabel(areaLabel, true);
                }
            } else {
                ChatUtil.printDebug("Failed to label un-rendered Dynmap territory " + territory.getName());
            }
        }
    }

    @Override
    public void postBroadcast(String message) {
        if (!this.isEnabled) {
            return;
        }
        dapi.sendBroadcastToWeb("Konquest", message);
    }

    private String getGroupId(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".marker.sanctuary";
                break;
            }
            case RUIN: {
                result = (String)result + ".marker.ruin";
                break;
            }
            case CAMP: {
                result = (String)result + ".marker.camp";
                break;
            }
            case CAPITAL: 
            case TOWN: {
                result = (String)result + ".marker.kingdom";
                break;
            }
        }
        return result;
    }

    private String getAreaId(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".area.sanctuary." + territory.getName().toLowerCase();
                break;
            }
            case RUIN: {
                result = (String)result + ".area.ruin." + territory.getName().toLowerCase();
                break;
            }
            case CAMP: {
                result = (String)result + ".area.camp." + territory.getName().toLowerCase();
                break;
            }
            case CAPITAL: {
                result = (String)result + ".area.kingdom." + territory.getKingdom().getName().toLowerCase() + ".capital";
                break;
            }
            case TOWN: {
                result = (String)result + ".area.kingdom." + territory.getKingdom().getName().toLowerCase() + "." + territory.getName().toLowerCase();
                break;
            }
        }
        return result;
    }

    private int getAreaColor(KonTerritory territory) {
        int result = 0xFFFFFF;
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = 0x646464;
                break;
            }
            case RUIN: {
                result = 0x242424;
                break;
            }
            case CAMP: {
                result = 10723594;
                break;
            }
            case CAPITAL: 
            case TOWN: {
                result = MapHandler.getWebColor(territory);
                break;
            }
        }
        return result;
    }

    private int getLineColor(KonTerritory territory) {
        int result = 0;
        if (Objects.requireNonNull(territory.getTerritoryType()) == KonquestTerritoryType.CAPITAL) {
            result = 8392912;
        }
        return result;
    }

    private String getIconId(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".icon.sanctuary." + territory.getName().toLowerCase();
                break;
            }
            case RUIN: {
                result = (String)result + ".icon.ruin." + territory.getName().toLowerCase();
                break;
            }
            case CAMP: {
                result = (String)result + ".icon.camp." + territory.getName().toLowerCase();
                break;
            }
            case CAPITAL: {
                result = (String)result + ".icon.kingdom." + territory.getKingdom().getName().toLowerCase() + ".capital";
                break;
            }
            case TOWN: {
                result = (String)result + ".icon.kingdom." + territory.getKingdom().getName().toLowerCase() + "." + territory.getName().toLowerCase();
                break;
            }
        }
        return result;
    }

    private MarkerIcon getIconMarker(KonTerritory territory) {
        MarkerIcon result = null;
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = dapi.getMarkerAPI().getMarkerIcon("temple");
                break;
            }
            case RUIN: {
                result = dapi.getMarkerAPI().getMarkerIcon("tower");
                break;
            }
            case CAMP: {
                result = dapi.getMarkerAPI().getMarkerIcon("pirateflag");
                break;
            }
            case CAPITAL: {
                result = dapi.getMarkerAPI().getMarkerIcon("star");
                break;
            }
            case TOWN: {
                result = dapi.getMarkerAPI().getMarkerIcon("orangeflag");
                break;
            }
        }
        return result;
    }
}

