/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.map;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.map.AreaTerritory;
import com.github.rumsfield.konquest.map.BlueMapRender;
import com.github.rumsfield.konquest.map.DynmapRender;
import com.github.rumsfield.konquest.map.Renderable;
import com.github.rumsfield.konquest.map.SquaremapRender;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class MapHandler {
    private final Konquest konquest;
    private final HashMap<String, Renderable> renderers;
    static final int sanctuaryColor = 0x646464;
    static final int ruinColor = 0x242424;
    static final int campColor = 10723594;
    static final int lineDefaultColor = 0;
    static final int lineCapitalColor = 8392912;
    static boolean isEnableKingdoms = true;
    static boolean isEnableCamps = true;
    static boolean isEnableSanctuaries = true;
    static boolean isEnableRuins = true;
    static boolean isShowBanners = true;
    private static final HashMap<String, String> imageBase64Cache = new HashMap();
    private static final HashMap<String, String> imageRelativeCache = new HashMap();

    public MapHandler(Konquest konquest) {
        this.konquest = konquest;
        this.renderers = new HashMap();
    }

    public void initialize() {
        String dynmapKey = "Dynmap";
        if (this.konquest.getIntegrationManager().getDynmap().isEnabled() && !this.renderers.containsKey(dynmapKey)) {
            this.renderers.put(dynmapKey, new DynmapRender(this.konquest));
        }
        String bluemapKey = "BlueMap";
        if (this.konquest.getIntegrationManager().getBlueMap().isEnabled() && !this.renderers.containsKey(bluemapKey)) {
            this.renderers.put(bluemapKey, new BlueMapRender(this.konquest));
        }
        String squaremapKey = "squaremap";
        if (this.konquest.getIntegrationManager().getSquaremap().isEnabled() && !this.renderers.containsKey(squaremapKey)) {
            this.renderers.put(squaremapKey, new SquaremapRender(this.konquest));
        }
        for (Renderable ren : this.renderers.values()) {
            ren.initialize();
        }
        isEnableKingdoms = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_MAP_OPTIONS_ENABLE_KINGDOMS.getPath());
        isEnableCamps = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_MAP_OPTIONS_ENABLE_CAMPS.getPath());
        isEnableSanctuaries = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_MAP_OPTIONS_ENABLE_SANCTUARIES.getPath());
        isEnableRuins = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_MAP_OPTIONS_ENABLE_RUINS.getPath());
        isShowBanners = this.konquest.getCore().getBoolean(CorePath.INTEGRATION_MAP_OPTIONS_SHOW_BANNERS.getPath());
        if (isShowBanners) {
            this.loadBannerImages();
        }
        this.printMapFeatures();
    }

    private void printMapFeatures() {
        String lineTemplate = "%-30s -> %s";
        String unavailable = String.valueOf(ChatColor.GRAY) + "Unavailable";
        Object statusKingdoms = ChatUtil.boolean2enable(isEnableKingdoms);
        Object statusCamps = ChatUtil.boolean2enable(isEnableCamps);
        Object statusSanctuaries = ChatUtil.boolean2enable(isEnableSanctuaries);
        Object statusRuins = ChatUtil.boolean2enable(isEnableRuins);
        Object statusBanners = ChatUtil.boolean2enable(isShowBanners);
        StringBuilder availableMaps = new StringBuilder();
        if (this.renderers.isEmpty()) {
            availableMaps.append("None");
            statusKingdoms = unavailable;
            statusCamps = unavailable;
            statusSanctuaries = unavailable;
            statusRuins = unavailable;
            statusBanners = unavailable;
        } else {
            Iterator<Renderable> renderIterator = this.renderers.values().iterator();
            while (renderIterator.hasNext()) {
                availableMaps.append(renderIterator.next().getMapName());
                if (!renderIterator.hasNext()) continue;
                availableMaps.append(", ");
            }
        }
        String[] status = new String[]{String.format(lineTemplate, "Available Maps", availableMaps), String.format(lineTemplate, "Show Kingdoms", statusKingdoms), String.format(lineTemplate, "Show Barbarian Camps", statusCamps), String.format(lineTemplate, "Show Sanctuaries", statusSanctuaries), String.format(lineTemplate, "Show Ruins", statusRuins), String.format(lineTemplate, "Display Banners", statusBanners)};
        ChatUtil.printConsoleAlert("Map Summary...");
        for (String row : status) {
            String line = String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.RESET) + row;
            Bukkit.getServer().getConsoleSender().sendMessage(line);
        }
    }

    private void loadBannerImages() {
        boolean doCopyImages = false;
        File dynmapImagePath = null;
        if (this.konquest.getIntegrationManager().getDynmap().isEnabled() && (dynmapImagePath = this.konquest.getIntegrationManager().getDynmap().getWebImagesFolder()).exists() && dynmapImagePath.isDirectory()) {
            doCopyImages = true;
        }
        String relativeBasePath = "/images/";
        String localBasePath = "banners/";
        imageBase64Cache.clear();
        imageRelativeCache.clear();
        ArrayList<String> bannerNames = new ArrayList<String>();
        bannerNames.add("default");
        bannerNames.add("sanctuary");
        bannerNames.add("ruin");
        bannerNames.add("camp");
        bannerNames.addAll(this.konquest.getKingdomManager().getKingdomNames());
        for (String bannerKey : bannerNames) {
            long IMAGE_MAX_BYTES;
            String fileName = bannerKey + ".png";
            String relativeFilePath = relativeBasePath + fileName;
            String localFilePath = localBasePath + fileName;
            File imageFile = new File(this.konquest.getPlugin().getDataFolder(), localFilePath);
            if (!imageFile.exists() || !imageFile.isFile()) continue;
            long fileSizeBytes = imageFile.length();
            if (fileSizeBytes > (IMAGE_MAX_BYTES = 100000L)) {
                ChatUtil.printConsoleError("Failed to load banner image file \"" + localFilePath + "\", file size " + fileSizeBytes + " exceeds maximum limit of " + IMAGE_MAX_BYTES + " bytes.");
                continue;
            }
            Object imageData = "";
            try {
                imageData = "data:image/png;base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(imageFile.toPath()));
            }
            catch (IOException exc) {
                ChatUtil.printConsoleError("Failed to load banner image file \"" + localFilePath + "\", problem reading file, check read permissions.");
            }
            if (!((String)imageData).isEmpty()) {
                imageBase64Cache.put(bannerKey, (String)imageData);
            }
            if (!doCopyImages) continue;
            Path source = imageFile.toPath();
            Path destination = new File(dynmapImagePath, fileName).toPath();
            try {
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                imageRelativeCache.put(bannerKey, relativeFilePath);
                ChatUtil.printDebug("Copied banner image file to Dynmap path: " + String.valueOf(destination));
            }
            catch (Exception e) {
                e.printStackTrace();
                ChatUtil.printConsoleError("Failed to copy image file " + String.valueOf(source) + " to " + String.valueOf(destination));
            }
        }
        if (!imageBase64Cache.containsKey("default")) {
            InputStream defaultResource = this.konquest.getPlugin().getResource("banners/default.png");
            if (defaultResource != null) {
                Object imageData = "";
                try {
                    imageData = "data:image/png;base64," + Base64.getEncoder().encodeToString(defaultResource.readAllBytes());
                }
                catch (IOException exc) {
                    ChatUtil.printConsoleError("Failed to load default banner image resource, problem reading file, check read permissions.");
                }
                if (!((String)imageData).isEmpty()) {
                    imageBase64Cache.put("default", (String)imageData);
                }
            } else {
                ChatUtil.printConsoleError("Failed to load default banner image from plugin resources.");
            }
        }
        ChatUtil.printConsoleAlert("Loaded Map Banner Images...");
        ArrayList<String> loadedBannerNames = new ArrayList<String>();
        for (String bannerName : bannerNames) {
            if (!imageBase64Cache.containsKey(bannerName)) continue;
            loadedBannerNames.add(bannerName);
        }
        String line = String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.RESET) + HelperUtil.formatCommaSeparatedList(loadedBannerNames);
        Bukkit.getServer().getConsoleSender().sendMessage(line);
    }

    public void drawUpdateTerritory(KonKingdom kingdom) {
        this.drawUpdateTerritory(kingdom, "");
    }

    public void drawUpdateTerritory(KonKingdom kingdom, String rendererName) {
        for (KonTown town : kingdom.getCapitalTowns()) {
            this.drawUpdateTerritory(town, rendererName);
        }
    }

    public void drawUpdateTerritory(KonTerritory territory) {
        this.drawUpdateTerritory(territory, "");
    }

    public void drawUpdateTerritory(KonTerritory territory, String rendererName) {
        if (this.isTerritoryDisabled(territory) || this.isTerritoryInvalid(territory)) {
            return;
        }
        AreaTerritory area = new AreaTerritory(territory);
        for (Renderable render : this.getRenderers(rendererName)) {
            try {
                render.drawUpdate(area);
            }
            catch (Error | Exception problem) {
                ChatUtil.printConsoleError(render.getMapName() + " encountered a problem while trying to draw territory " + territory.getName());
                problem.printStackTrace();
            }
        }
    }

    public void drawRemoveTerritory(KonTerritory territory) {
        this.drawRemoveTerritory(territory, "");
    }

    public void drawRemoveTerritory(KonTerritory territory, String rendererName) {
        if (this.isTerritoryDisabled(territory) || this.isTerritoryInvalid(territory)) {
            return;
        }
        AreaTerritory area = new AreaTerritory(territory);
        for (Renderable render : this.getRenderers(rendererName)) {
            try {
                render.drawRemove(area);
            }
            catch (Error | Exception problem) {
                ChatUtil.printConsoleError(render.getMapName() + " encountered a problem while trying to remove territory " + territory.getName());
                problem.printStackTrace();
            }
        }
    }

    public void drawLabelTerritory(KonTerritory territory) {
        this.drawLabelTerritory(territory, "");
    }

    public void drawLabelTerritory(KonTerritory territory, String rendererName) {
        if (this.isTerritoryDisabled(territory) || this.isTerritoryInvalid(territory)) {
            return;
        }
        AreaTerritory area = new AreaTerritory(territory);
        for (Renderable render : this.getRenderers(rendererName)) {
            try {
                render.drawLabel(area);
            }
            catch (Error | Exception problem) {
                ChatUtil.printConsoleError(render.getMapName() + " encountered a problem while trying to label territory " + territory.getName());
                problem.printStackTrace();
            }
        }
    }

    public void postBroadcast(String message) {
        for (Renderable render : this.renderers.values()) {
            try {
                render.postBroadcast(message);
            }
            catch (Error | Exception problem) {
                ChatUtil.printConsoleError(render.getMapName() + " encountered a problem while trying to broadcast a message");
                problem.printStackTrace();
            }
        }
    }

    public void drawAllTerritories() {
        this.drawAllTerritories("");
    }

    public void drawAllTerritories(String rendererName) {
        Date start = new Date();
        for (KonSanctuary sanctuary : this.konquest.getSanctuaryManager().getSanctuaries()) {
            this.drawUpdateTerritory(sanctuary, rendererName);
        }
        for (KonRuin ruin : this.konquest.getRuinManager().getRuins()) {
            this.drawUpdateTerritory(ruin, rendererName);
        }
        for (KonCamp camp : this.konquest.getCampManager().getCamps()) {
            this.drawUpdateTerritory(camp, rendererName);
        }
        for (KonKingdom kingdom : this.konquest.getKingdomManager().getKingdoms()) {
            this.drawUpdateTerritory(kingdom, rendererName);
        }
        Date end = new Date();
        int time = (int)(end.getTime() - start.getTime());
        if (rendererName.isEmpty()) {
            ChatUtil.printDebug("Rendering all territories in maps took " + time + " ms");
        } else {
            ChatUtil.printDebug("Rendering all territories with " + rendererName + " took " + time + " ms");
        }
    }

    private ArrayList<Renderable> getRenderers(String name) {
        ArrayList<Renderable> renderList = new ArrayList<Renderable>();
        if (name.isEmpty() || !this.renderers.containsKey(name)) {
            renderList.addAll(this.renderers.values());
        } else {
            renderList.add(this.renderers.get(name));
        }
        return renderList;
    }

    public static int getWebColor(KonTerritory territory) {
        int result = 0xFFFFFF;
        int webColor = territory.getKingdom().getWebColor();
        if (webColor == -1) {
            int hash = territory.getKingdom().getName().hashCode();
            result = hash & 0xFFFFFF;
        } else {
            result = webColor;
        }
        return result;
    }

    private boolean isTerritoryInvalid(KonTerritory territory) {
        boolean isValid = false;
        switch (territory.getTerritoryType()) {
            case SANCTUARY: 
            case RUIN: 
            case CAMP: 
            case TOWN: {
                isValid = true;
                break;
            }
            case CAPITAL: {
                if (!territory.getKingdom().isCreated()) break;
                isValid = true;
                break;
            }
        }
        return !isValid;
    }

    private boolean isTerritoryDisabled(KonTerritory territory) {
        boolean result = false;
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = isEnableSanctuaries;
                break;
            }
            case RUIN: {
                result = isEnableRuins;
                break;
            }
            case CAMP: {
                result = isEnableCamps;
                break;
            }
            case TOWN: 
            case CAPITAL: {
                result = isEnableKingdoms;
                break;
            }
        }
        return !result;
    }

    static String getGroupLabel(KonTerritory territory) {
        String result = "Konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = "Konquest Sanctuaries";
                break;
            }
            case RUIN: {
                result = "Konquest Ruins";
                break;
            }
            case CAMP: {
                result = "Konquest Barbarian Camps";
                break;
            }
            case TOWN: 
            case CAPITAL: {
                result = "Konquest Kingdoms";
                break;
            }
        }
        return result;
    }

    static String getIconLabel(KonTerritory territory) {
        Object result = "Konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = MessagePath.MAP_SANCTUARY.getMessage(new Object[0]) + " " + territory.getName();
                break;
            }
            case RUIN: {
                result = MessagePath.MAP_RUIN.getMessage(new Object[0]) + " " + territory.getName();
                break;
            }
            case CAMP: {
                result = MessagePath.MAP_BARBARIAN.getMessage(new Object[0]) + " " + territory.getName();
                break;
            }
            case CAPITAL: {
                result = territory.getKingdom().getCapital().getName();
                break;
            }
            case TOWN: {
                result = territory.getKingdom().getName() + " " + territory.getName();
                break;
            }
        }
        return result;
    }

    private static String getImageSource(String bannerKey, boolean isImageRelative) {
        String result = "";
        if (isImageRelative) {
            if (imageRelativeCache.containsKey(bannerKey)) {
                result = imageRelativeCache.get(bannerKey);
            } else if (imageRelativeCache.containsKey("default")) {
                result = imageRelativeCache.get("default");
            }
        } else if (imageBase64Cache.containsKey(bannerKey)) {
            result = imageBase64Cache.get(bannerKey);
        } else if (imageBase64Cache.containsKey("default")) {
            result = imageBase64Cache.get("default");
        }
        return result;
    }

    static String getAreaLabel(KonTerritory territory, boolean isImageRelative) {
        String result = "Konquest";
        String bodyBegin = "<body style=\"background-color:#fff0cc;font-family:Helvetica;\">";
        String nameHeaderFormat = "<h2 style=\"text-align:center;color:#de791b;\">%s</h2>";
        String typeHeaderFormat = "<h3 style=\"color:#8048b8;\">%s</h3>";
        String propertyLineFormat = "<b>%s:</b> %s <br>";
        String bannerImageFormat = "<div style=\"text-align:center\"><img src=\"%s\" alt=\"Banner\" height=\"96\"></div>";
        StringBuilder labelMaker = new StringBuilder();
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                String imageSource;
                KonSanctuary sanctuary = (KonSanctuary)territory;
                labelMaker.append(bodyBegin);
                if (isShowBanners && !(imageSource = MapHandler.getImageSource("sanctuary", isImageRelative)).isEmpty()) {
                    labelMaker.append(String.format(bannerImageFormat, imageSource));
                }
                labelMaker.append(String.format(nameHeaderFormat, sanctuary.getName())).append("<hr>").append(String.format(typeHeaderFormat, MessagePath.MAP_SANCTUARY.getMessage(new Object[0]))).append("<p>").append(String.format(propertyLineFormat, MessagePath.MAP_TEMPLATES.getMessage(new Object[0]), sanctuary.getTemplates().size())).append(String.format(propertyLineFormat, MessagePath.MAP_LAND.getMessage(new Object[0]), sanctuary.getChunkList().size())).append("</p>").append("</body>");
                result = labelMaker.toString();
                break;
            }
            case RUIN: {
                String imageSource;
                KonRuin ruin = (KonRuin)territory;
                labelMaker.append(bodyBegin);
                if (isShowBanners && !(imageSource = MapHandler.getImageSource("ruin", isImageRelative)).isEmpty()) {
                    labelMaker.append(String.format(bannerImageFormat, imageSource));
                }
                labelMaker.append(String.format(nameHeaderFormat, ruin.getName())).append("<hr>").append(String.format(typeHeaderFormat, MessagePath.MAP_RUIN.getMessage(new Object[0]))).append("<p>").append(String.format(propertyLineFormat, MessagePath.MAP_CRITICAL_HITS.getMessage(new Object[0]), ruin.getMaxCriticalHits())).append(String.format(propertyLineFormat, MessagePath.MAP_GOLEM_SPAWNS.getMessage(new Object[0]), ruin.getSpawnLocations().size())).append(String.format(propertyLineFormat, MessagePath.MAP_LAND.getMessage(new Object[0]), ruin.getChunkList().size())).append(String.format(propertyLineFormat, MessagePath.MAP_LOOT_TYPE.getMessage(new Object[0]), ruin.getKonquest().getLootManager().getRuinLootDisplayName(ruin))).append(String.format(propertyLineFormat, MessagePath.MAP_CAPTURE.getMessage(new Object[0]), !ruin.isCaptureDisabled())).append("</p>").append("</body>");
                result = labelMaker.toString();
                break;
            }
            case CAMP: {
                String imageSource;
                KonCamp camp = (KonCamp)territory;
                labelMaker.append(bodyBegin);
                if (isShowBanners && !(imageSource = MapHandler.getImageSource("camp", isImageRelative)).isEmpty()) {
                    labelMaker.append(String.format(bannerImageFormat, imageSource));
                }
                labelMaker.append(String.format(bannerImageFormat, "camp")).append(String.format(nameHeaderFormat, camp.getName())).append("<hr>").append(String.format(typeHeaderFormat, MessagePath.MAP_BARBARIANS.getMessage(new Object[0]))).append("<p>").append(String.format(propertyLineFormat, MessagePath.MAP_OWNER.getMessage(new Object[0]), camp.getOwner().getName())).append(String.format(propertyLineFormat, MessagePath.MAP_LAND.getMessage(new Object[0]), camp.getChunkList().size())).append("</p>").append("</body>");
                result = labelMaker.toString();
                break;
            }
            case CAPITAL: {
                String imageSource;
                KonCapital capital = (KonCapital)territory;
                String capitalLordName = "-";
                if (capital.getPlayerLord() != null) {
                    capitalLordName = capital.getPlayerLord().getName();
                }
                String kingdomMasterName = "-";
                if (capital.getKingdom().isMasterValid()) {
                    kingdomMasterName = capital.getKingdom().getPlayerMaster().getName();
                }
                int numKingdomOfficers = capital.getKingdom().getPlayerOfficersOnly().size();
                int numAllKingdomPlayers = territory.getKingdom().getNumMembers();
                int numKingdomTowns = territory.getKingdom().getTowns().size();
                int numKingdomLand = 0;
                for (KonTown town : territory.getKingdom().getCapitalTowns()) {
                    numKingdomLand += town.getNumLand();
                }
                labelMaker.append(bodyBegin);
                if (isShowBanners && !(imageSource = MapHandler.getImageSource(capital.getKingdom().getName(), isImageRelative)).isEmpty()) {
                    labelMaker.append(String.format(bannerImageFormat, imageSource));
                }
                labelMaker.append(String.format(nameHeaderFormat, capital.getName())).append("<hr>").append(String.format(typeHeaderFormat, MessagePath.MAP_CAPITAL.getMessage(new Object[0]))).append("<p>").append(String.format(propertyLineFormat, MessagePath.MAP_KINGDOM.getMessage(new Object[0]), capital.getKingdom().getName())).append(String.format(propertyLineFormat, MessagePath.MAP_LORD.getMessage(new Object[0]), capitalLordName)).append(String.format(propertyLineFormat, MessagePath.MAP_KNIGHTS.getMessage(new Object[0]), capital.getPlayerKnightsOnly().size())).append(String.format(propertyLineFormat, MessagePath.MAP_RESIDENTS.getMessage(new Object[0]), capital.getNumResidents())).append(String.format(propertyLineFormat, MessagePath.MAP_LAND.getMessage(new Object[0]), capital.getNumLand())).append(String.format(propertyLineFormat, MessagePath.MAP_LOOT_TYPE.getMessage(new Object[0]), capital.getKonquest().getLootManager().getMonumentLootDisplayName(capital))).append(String.format(propertyLineFormat, MessagePath.MAP_CAPTURE.getMessage(new Object[0]), !capital.isCaptureDisabled())).append("</p>").append(String.format(typeHeaderFormat, MessagePath.MAP_KINGDOM.getMessage(new Object[0]))).append("<p>").append(String.format(propertyLineFormat, MessagePath.MAP_MASTER.getMessage(new Object[0]), kingdomMasterName)).append(String.format(propertyLineFormat, MessagePath.MAP_OFFICERS.getMessage(new Object[0]), numKingdomOfficers)).append(String.format(propertyLineFormat, MessagePath.MAP_MEMBERS.getMessage(new Object[0]), numAllKingdomPlayers)).append(String.format(propertyLineFormat, MessagePath.MAP_TOWNS.getMessage(new Object[0]), numKingdomTowns)).append(String.format(propertyLineFormat, MessagePath.MAP_LAND.getMessage(new Object[0]), numKingdomLand)).append("</p>").append("</body>");
                result = labelMaker.toString();
                break;
            }
            case TOWN: {
                String imageSource;
                KonTown town = (KonTown)territory;
                String townLordName = "-";
                if (town.getPlayerLord() != null) {
                    townLordName = town.getPlayerLord().getName();
                }
                labelMaker.append(bodyBegin);
                if (isShowBanners && !(imageSource = MapHandler.getImageSource(town.getKingdom().getName(), isImageRelative)).isEmpty()) {
                    labelMaker.append(String.format(bannerImageFormat, imageSource));
                }
                labelMaker.append(String.format(nameHeaderFormat, town.getName())).append("<hr>").append(String.format(typeHeaderFormat, MessagePath.MAP_TOWN.getMessage(new Object[0]))).append("<p>").append(String.format(propertyLineFormat, MessagePath.MAP_KINGDOM.getMessage(new Object[0]), town.getKingdom().getName())).append(String.format(propertyLineFormat, MessagePath.MAP_LORD.getMessage(new Object[0]), townLordName)).append(String.format(propertyLineFormat, MessagePath.MAP_KNIGHTS.getMessage(new Object[0]), town.getPlayerKnightsOnly().size())).append(String.format(propertyLineFormat, MessagePath.MAP_RESIDENTS.getMessage(new Object[0]), town.getNumResidents())).append(String.format(propertyLineFormat, MessagePath.MAP_LAND.getMessage(new Object[0]), town.getNumLand())).append(String.format(propertyLineFormat, MessagePath.MAP_LOOT_TYPE.getMessage(new Object[0]), town.getKonquest().getLootManager().getMonumentLootDisplayName(town))).append(String.format(propertyLineFormat, MessagePath.MAP_CAPTURE.getMessage(new Object[0]), !town.isCaptureDisabled())).append("</p>").append("</body>");
                result = labelMaker.toString();
                break;
            }
        }
        return result;
    }
}

