/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.map;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.map.AreaTerritory;
import com.github.rumsfield.konquest.map.MapHandler;
import com.github.rumsfield.konquest.map.Renderable;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.bukkit.World;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;
import xyz.jpenilla.squaremap.api.marker.Polygon;

public class SquaremapRender
implements Renderable {
    private final Konquest konquest;
    private boolean isEnabled;
    private static Squaremap api = null;

    public SquaremapRender(Konquest konquest) {
        this.konquest = konquest;
        this.isEnabled = false;
    }

    @Override
    public void initialize() {
        this.isEnabled = this.konquest.getIntegrationManager().getSquaremap().isEnabled();
        if (this.isEnabled) {
            api = this.konquest.getIntegrationManager().getSquaremap().getAPI();
            if (api == null) {
                this.isEnabled = false;
                ChatUtil.printDebug("Failed to initialize SquaremapRender with null API reference.");
            } else {
                ArrayList<KonquestTerritoryType> iconTypes = new ArrayList<KonquestTerritoryType>();
                iconTypes.add(KonquestTerritoryType.CAPITAL);
                iconTypes.add(KonquestTerritoryType.TOWN);
                iconTypes.add(KonquestTerritoryType.SANCTUARY);
                iconTypes.add(KonquestTerritoryType.RUIN);
                iconTypes.add(KonquestTerritoryType.CAMP);
                for (KonquestTerritoryType type : iconTypes) {
                    BufferedImage iconImage = this.getIconImage(type);
                    if (iconImage != null) {
                        Key imageKey = this.getImageKey(type);
                        if (api.iconRegistry().hasEntry(imageKey)) continue;
                        api.iconRegistry().register(imageKey, (Object)iconImage);
                        continue;
                    }
                    ChatUtil.printConsoleError("Failed to register null image with squaremap for territory " + String.valueOf((Object)type));
                }
            }
        } else {
            ChatUtil.printDebug("Failed to initialize SquaremapRender with disabled API.");
        }
    }

    @Override
    public String getMapName() {
        return this.konquest.getIntegrationManager().getSquaremap().getPluginName();
    }

    @Override
    public void drawUpdate(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        Key groupKey = this.getGroupKey(territory);
        Key areaKey = this.getAreaKey(territory);
        Key imageKey = this.getImageKey(territory.getTerritoryType());
        Key iconKey = this.getIconKey(territory);
        String groupLabel = MapHandler.getGroupLabel(territory);
        String areaLabel = MapHandler.getIconLabel(territory);
        String areaDetail = MapHandler.getAreaLabel(territory, false);
        Color areaColor = this.getAreaColor(territory);
        Color lineColor = this.getLineColor(territory);
        MapWorld mapWorld = api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)territory.getWorld())).orElse(null);
        if (mapWorld == null) {
            ChatUtil.printDebug("Could not draw squaremap territory " + territory.getName() + " with invalid world, " + territory.getWorld().getName());
            return;
        }
        Registry layerRegistry = mapWorld.layerRegistry();
        if (!layerRegistry.hasEntry(groupKey)) {
            int index = this.getGroupIndex(territory);
            layerRegistry.register(groupKey, (Object)SimpleLayerProvider.builder((String)groupLabel).showControls(true).defaultHidden(false).layerPriority(index).zIndex(index).build());
        }
        SimpleLayerProvider groupLayerProvider = (SimpleLayerProvider)layerRegistry.get(groupKey);
        ArrayList areaOutline = new ArrayList();
        ArrayList areaNegativeSpace = new ArrayList();
        for (int i = 0; i < area.getNumContours(); ++i) {
            double[] xPoints = area.getXContour(i);
            double[] zPoints = area.getZContour(i);
            ArrayList<Point> countourPoints = new ArrayList<Point>();
            for (int c = 0; c < xPoints.length; ++c) {
                countourPoints.add(Point.of((double)xPoints[c], (double)zPoints[c]));
            }
            if (i == 0) {
                areaOutline.addAll(countourPoints);
                continue;
            }
            areaNegativeSpace.add(countourPoints);
        }
        Polygon areaShape = Marker.polygon(areaOutline, areaNegativeSpace);
        MarkerOptions markerOptions = MarkerOptions.builder().stroke(true).strokeColor(lineColor).strokeWeight(3).strokeOpacity(0.5).fill(true).fillColor(areaColor).fillOpacity(0.5).clickTooltip(areaDetail).hoverTooltip(areaLabel).build();
        areaShape.markerOptions(markerOptions);
        groupLayerProvider.addMarker(areaKey, (Marker)areaShape);
        if (api.iconRegistry().hasEntry(imageKey)) {
            Icon iconImage = Marker.icon((Point)Point.of((double)area.getCenterX(), (double)area.getCenterZ()), (Key)imageKey, (int)15);
            MarkerOptions iconOptions = iconImage.markerOptions().asBuilder().clickTooltip(areaDetail).hoverTooltip(areaLabel).build();
            iconImage.markerOptions(iconOptions);
            groupLayerProvider.addMarker(iconKey, (Marker)iconImage);
        }
    }

    @Override
    public void drawRemove(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        Key groupKey = this.getGroupKey(territory);
        Key areaKey = this.getAreaKey(territory);
        Key iconKey = this.getIconKey(territory);
        MapWorld mapWorld = api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)territory.getWorld())).orElse(null);
        if (mapWorld == null) {
            ChatUtil.printDebug("Could not remove squaremap territory " + territory.getName() + " from invalid world, " + territory.getWorld().getName());
            return;
        }
        Registry layerRegistry = mapWorld.layerRegistry();
        if (layerRegistry.hasEntry(groupKey)) {
            SimpleLayerProvider groupLayerProvider = (SimpleLayerProvider)layerRegistry.get(groupKey);
            groupLayerProvider.removeMarker(areaKey);
            groupLayerProvider.removeMarker(iconKey);
            if (groupLayerProvider.getMarkers().isEmpty()) {
                layerRegistry.unregister(groupKey);
                ChatUtil.printDebug("Removing squaremap group of territory " + territory.getName());
            }
        } else {
            ChatUtil.printDebug("Failed to erase from missing squaremap group, territory " + territory.getName());
        }
    }

    @Override
    public void drawLabel(AreaTerritory area) {
        if (!this.isEnabled) {
            return;
        }
        KonTerritory territory = area.getTerritory();
        Key groupKey = this.getGroupKey(territory);
        Key areaKey = this.getAreaKey(territory);
        Key iconKey = this.getAreaKey(territory);
        String areaLabel = MapHandler.getIconLabel(territory);
        String areaDetail = MapHandler.getAreaLabel(territory, false);
        Color areaColor = this.getAreaColor(territory);
        Color lineColor = this.getLineColor(territory);
        MapWorld mapWorld = api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)territory.getWorld())).orElse(null);
        if (mapWorld == null) {
            ChatUtil.printDebug("Could not label squaremap territory " + territory.getName() + " from invalid world, " + territory.getWorld().getName());
            return;
        }
        Registry layerRegistry = mapWorld.layerRegistry();
        if (!layerRegistry.hasEntry(groupKey)) {
            ChatUtil.printDebug("Failed to label missing squaremap group, territory " + territory.getName());
            return;
        }
        SimpleLayerProvider groupLayerProvider = (SimpleLayerProvider)layerRegistry.get(groupKey);
        if (!groupLayerProvider.hasMarker(areaKey)) {
            ChatUtil.printDebug("Failed to label missing squaremap marker, territory " + territory.getName());
            return;
        }
        Marker areaShape = (Marker)groupLayerProvider.registeredMarkers().get(areaKey);
        MarkerOptions markerOptions = areaShape.markerOptions().asBuilder().strokeColor(lineColor).fillColor(areaColor).clickTooltip(areaDetail).hoverTooltip(areaLabel).build();
        areaShape.markerOptions(markerOptions);
        Marker icon = (Marker)groupLayerProvider.registeredMarkers().get(iconKey);
        markerOptions = icon.markerOptions().asBuilder().clickTooltip(areaDetail).hoverTooltip(areaLabel).build();
        icon.markerOptions(markerOptions);
    }

    @Override
    public void postBroadcast(String message) {
    }

    private int getGroupIndex(KonTerritory territory) {
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                return 40;
            }
            case RUIN: {
                return 30;
            }
            case CAMP: {
                return 20;
            }
            case CAPITAL: 
            case TOWN: {
                return 10;
            }
        }
        return 100;
    }

    private Key getGroupKey(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".marker.sanctuary";
                break;
            }
            case RUIN: {
                result = (String)result + ".marker.ruin";
                break;
            }
            case CAMP: {
                result = (String)result + ".marker.camp";
                break;
            }
            case CAPITAL: 
            case TOWN: {
                result = (String)result + ".marker.kingdom";
                break;
            }
        }
        return Key.of((String)result);
    }

    private Key getAreaKey(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".area.sanctuary." + territory.getName().toLowerCase();
                break;
            }
            case RUIN: {
                result = (String)result + ".area.ruin." + territory.getName().toLowerCase();
                break;
            }
            case CAMP: {
                result = (String)result + ".area.camp." + territory.getName().toLowerCase();
                break;
            }
            case CAPITAL: {
                result = (String)result + ".area.kingdom." + territory.getKingdom().getName().toLowerCase() + ".capital";
                break;
            }
            case TOWN: {
                result = (String)result + ".area.kingdom." + territory.getKingdom().getName().toLowerCase() + "." + territory.getName().toLowerCase();
                break;
            }
        }
        return Key.of((String)result);
    }

    private Key getIconKey(KonTerritory territory) {
        Object result = "konquest";
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = (String)result + ".icon.sanctuary." + territory.getName().toLowerCase();
                break;
            }
            case RUIN: {
                result = (String)result + ".icon.ruin." + territory.getName().toLowerCase();
                break;
            }
            case CAMP: {
                result = (String)result + ".icon.camp." + territory.getName().toLowerCase();
                break;
            }
            case CAPITAL: {
                result = (String)result + ".icon.kingdom." + territory.getKingdom().getName().toLowerCase() + ".capital";
                break;
            }
            case TOWN: {
                result = (String)result + ".icon.kingdom." + territory.getKingdom().getName().toLowerCase() + "." + territory.getName().toLowerCase();
                break;
            }
        }
        return Key.of((String)result);
    }

    private Key getImageKey(KonquestTerritoryType type) {
        Object result = "konquest";
        switch (type) {
            case SANCTUARY: {
                result = (String)result + ".image.sanctuary";
                break;
            }
            case RUIN: {
                result = (String)result + ".image.ruin";
                break;
            }
            case CAMP: {
                result = (String)result + ".image.camp";
                break;
            }
            case CAPITAL: {
                result = (String)result + ".image.kingdom.capital";
                break;
            }
            case TOWN: {
                result = (String)result + ".image.kingdom.town";
                break;
            }
        }
        return Key.of((String)result);
    }

    private BufferedImage getIconImage(KonquestTerritoryType type) {
        InputStream resourceStream = null;
        BufferedImage image = null;
        switch (type) {
            case SANCTUARY: {
                resourceStream = this.konquest.getPlugin().getResource("img/temple.png");
                break;
            }
            case RUIN: {
                resourceStream = this.konquest.getPlugin().getResource("img/tower.png");
                break;
            }
            case CAMP: {
                resourceStream = this.konquest.getPlugin().getResource("img/pirateflag.png");
                break;
            }
            case CAPITAL: {
                resourceStream = this.konquest.getPlugin().getResource("img/star.png");
                break;
            }
            case TOWN: {
                resourceStream = this.konquest.getPlugin().getResource("img/orangeflag.png");
                break;
            }
        }
        try {
            if (resourceStream != null) {
                image = ImageIO.read(resourceStream);
                resourceStream.close();
            } else {
                ChatUtil.printConsoleError("Failed to find image file for territory type " + String.valueOf((Object)type));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    private Color getAreaColor(KonTerritory territory) {
        Color result = new Color(0xFFFFFF, false);
        switch (territory.getTerritoryType()) {
            case SANCTUARY: {
                result = new Color(0x646464, false);
                break;
            }
            case RUIN: {
                result = new Color(0x242424, false);
                break;
            }
            case CAMP: {
                result = new Color(10723594, false);
                break;
            }
            case CAPITAL: 
            case TOWN: {
                result = new Color(MapHandler.getWebColor(territory), false);
                break;
            }
        }
        return result;
    }

    private Color getLineColor(KonTerritory territory) {
        Color result = new Color(0, false);
        if (Objects.requireNonNull(territory.getTerritoryType()) == KonquestTerritoryType.CAPITAL) {
            result = new Color(8392912, false);
        }
        return result;
    }
}

