/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestCamp;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class KonCamp
extends KonTerritory
implements KonquestCamp,
KonBarDisplayer,
Timeable {
    private final OfflinePlayer owner;
    private final Timer raidAlertTimer;
    private final Timer protectedWarmupTimer;
    private final Timer protectedCountdownTimer;
    private boolean isRaidAlertDisabled;
    private boolean isOfflineProtected;
    private Location bedLocation;
    private final BossBar campBarAll;

    public KonCamp(Location loc, OfflinePlayer owner, KonKingdom kingdom, Konquest konquest) {
        super(loc, MessagePath.TERRITORY_CAMP.getMessage(new Object[0]).trim() + "_" + owner.getName(), kingdom, konquest);
        this.owner = owner;
        this.raidAlertTimer = new Timer(this);
        this.protectedWarmupTimer = new Timer(this);
        this.protectedCountdownTimer = new Timer(this);
        this.isRaidAlertDisabled = false;
        this.isOfflineProtected = false;
        this.bedLocation = loc;
        this.campBarAll = Bukkit.getServer().createBossBar(Konquest.barbarianColor2 + this.getName(), ChatUtil.mapBarColor(Konquest.barbarianColor1), BarStyle.SOLID, new BarFlag[0]);
        this.campBarAll.setVisible(true);
        this.initProtection();
    }

    private void initProtection() {
        boolean isOfflineProtectedEnabled = this.getKonquest().getCore().getBoolean(CorePath.CAMPS_NO_ENEMY_EDIT_OFFLINE.getPath(), true);
        if (isOfflineProtectedEnabled && !this.isOwnerOnline()) {
            this.isOfflineProtected = true;
            this.campBarAll.setTitle(Konquest.barbarianColor2 + this.getName() + " " + MessagePath.LABEL_PROTECTED.getMessage(new Object[0]));
        }
    }

    @Override
    public int initClaim() {
        if (!this.addChunks(HelperUtil.getAreaPoints(this.getCenterLoc(), this.getKonquest().getCore().getInt(CorePath.CAMPS_INIT_RADIUS.getPath())))) {
            ChatUtil.printDebug("Camp init failed: problem adding some chunks");
            return 4;
        }
        return 0;
    }

    @Override
    public boolean addChunk(Point point) {
        this.addPoint(point);
        return true;
    }

    @Override
    public boolean testChunk(Point point) {
        return true;
    }

    @Override
    public boolean isOwnerOnline() {
        return this.owner.isOnline();
    }

    @Override
    public OfflinePlayer getOwner() {
        return this.owner;
    }

    @Override
    public boolean isPlayerOwner(OfflinePlayer player) {
        return player.getUniqueId().equals(this.owner.getUniqueId());
    }

    public boolean isRaidAlertDisabled() {
        return this.isRaidAlertDisabled;
    }

    public void setIsRaidAlertDisabled(boolean val) {
        this.isRaidAlertDisabled = val;
    }

    public Timer getRaidAlertTimer() {
        return this.raidAlertTimer;
    }

    @Override
    public Location getBedLocation() {
        return this.bedLocation;
    }

    public void setBedLocation(Location loc) {
        this.bedLocation = loc;
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Camp Timer ended with null taskID!");
        } else if (taskID == this.raidAlertTimer.getTaskID()) {
            ChatUtil.printDebug("Raid Alert Timer ended with taskID: " + taskID);
            this.isRaidAlertDisabled = false;
        } else if (taskID == this.protectedWarmupTimer.getTaskID()) {
            ChatUtil.printDebug("Offline protection warmup Timer ended with taskID: " + taskID);
            this.isOfflineProtected = true;
            this.protectedCountdownTimer.stopTimer();
            this.campBarAll.setTitle(Konquest.barbarianColor2 + this.getName() + " " + MessagePath.LABEL_PROTECTED.getMessage(new Object[0]));
        } else if (taskID == this.protectedCountdownTimer.getTaskID()) {
            String remainingTime = HelperUtil.getTimeFormat(this.protectedWarmupTimer.getTime(), ChatColor.RED);
            this.campBarAll.setTitle(Konquest.barbarianColor2 + this.getName() + " " + remainingTime);
        } else {
            ChatUtil.printDebug("Camp Timer ended with unknown taskID: " + taskID);
        }
    }

    @Override
    public void addBarPlayer(KonPlayer player) {
        this.campBarAll.addPlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeBarPlayer(KonPlayer player) {
        this.campBarAll.removePlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeAllBarPlayers() {
        this.campBarAll.removeAll();
    }

    @Override
    public void updateBarPlayers() {
        this.campBarAll.removeAll();
        for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersOnline()) {
            Player bukkitPlayer = player.getBukkitPlayer();
            if (!this.isLocInside(bukkitPlayer.getLocation())) continue;
            this.campBarAll.addPlayer(bukkitPlayer);
        }
    }

    @Override
    public void updateBarTitle() {
        this.campBarAll.setTitle(Konquest.barbarianColor2 + this.getName());
    }

    public void setProtected(boolean val) {
        if (val) {
            boolean isOfflineProtectedEnabled = this.getKonquest().getCore().getBoolean(CorePath.CAMPS_NO_ENEMY_EDIT_OFFLINE.getPath(), true);
            int offlineProtectedWarmupSeconds = this.getKonquest().getCore().getInt(CorePath.CAMPS_NO_ENEMY_EDIT_OFFLINE_WARMUP.getPath(), 0);
            if (isOfflineProtectedEnabled) {
                if (offlineProtectedWarmupSeconds > 0 && this.protectedWarmupTimer.getTime() == -1 && !this.isOfflineProtected) {
                    this.protectedWarmupTimer.stopTimer();
                    this.protectedWarmupTimer.setTime(offlineProtectedWarmupSeconds);
                    this.protectedWarmupTimer.startTimer();
                    this.protectedCountdownTimer.stopTimer();
                    this.protectedCountdownTimer.setTime(0);
                    this.protectedCountdownTimer.startLoopTimer();
                } else if (offlineProtectedWarmupSeconds <= 0) {
                    this.isOfflineProtected = true;
                    this.campBarAll.setTitle(Konquest.barbarianColor2 + this.getName() + " " + MessagePath.LABEL_PROTECTED.getMessage(new Object[0]));
                }
            }
        } else {
            this.isOfflineProtected = false;
            this.protectedWarmupTimer.stopTimer();
            this.protectedCountdownTimer.stopTimer();
            this.campBarAll.setTitle(Konquest.barbarianColor2 + this.getName());
        }
    }

    @Override
    public boolean isProtected() {
        return this.isOfflineProtected;
    }

    public void applyGlow(Player bukkitPlayer) {
        boolean isGlowEnabled = this.getKonquest().getCore().getBoolean(CorePath.CAMPS_ENEMY_GLOW.getPath(), true);
        if (!isGlowEnabled) {
            return;
        }
        bukkitPlayer.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 100, 1));
    }

    @Override
    public KonquestTerritoryType getTerritoryType() {
        return KonquestTerritoryType.CAMP;
    }
}

