/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestCapital;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.CorePath;
import org.bukkit.Location;

public class KonCapital
extends KonTown
implements KonquestCapital {
    public KonCapital(Location loc, KonKingdom kingdom, Konquest konquest) {
        super(loc, kingdom.getName(), kingdom, konquest);
        this.updateName();
    }

    public KonCapital(Location loc, String name, KonKingdom kingdom, Konquest konquest) {
        super(loc, name, kingdom, konquest);
    }

    public void updateName() {
        this.setName(this.getCapitalName());
        this.updateBarTitle();
    }

    private String getCapitalName() {
        boolean isPrefix = this.getKonquest().getCore().getBoolean(CorePath.KINGDOMS_CAPITAL_PREFIX_SWAP.getPath(), false);
        String suffix = this.getKonquest().getCore().getString(CorePath.KINGDOMS_CAPITAL_SUFFIX.getPath(), "");
        String name = this.getKingdom().getName();
        if (isPrefix) {
            return suffix + " " + name;
        }
        return name + " " + suffix;
    }

    @Override
    public KonquestTerritoryType getTerritoryType() {
        return KonquestTerritoryType.CAPITAL;
    }
}

